/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.paperprint;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.PrintTypeEnum;
import kd.imc.bdm.common.constant.allele.AllEleInterfaceTypeEnum;
import kd.imc.bdm.common.dto.allele.AllEleRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseDTO;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.ComponentServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.dto.allele.AllElePaperPrintRequestDTO;
import kd.imc.sim.common.dto.allele.AllElePaperPrintResponseDTO;
import kd.imc.sim.common.helper.PaperPrintHelper;
import kd.imc.sim.formplugin.bill.originalbill.util.SelectDeviceUtil;
import kd.imc.sim.formplugin.issuing.paperprint.control.PrintInvoiceControl;
import org.apache.commons.lang3.StringUtils;

public class InvoicePrintListPlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(InvoicePrintListPlugin.class);
    private static final String COMPONENTFLEX = "epnamequery";
    private static final String ELE_PAPER_PRINT = "elepaperprint";
    private static final String PRINT_SETUP = "printsetup";
    private static final String PRINT = "print";
    private static final String IMC_SIM_PRINT_CACHE = "imc_sim_print_cache_";
    private static final String IMC_SIM_PRINT_DEFEAT_CACHE = "imc_sim_print_defeat_cache_";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{PRINT_SETUP, PRINT});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (PRINT.equals(key)) {
            DynamicObject[] vatInvoiceList = this.getInvoice();
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String GuestPrint = (String)formShowParameter.getCustomParam("GuestPrint");
            boolean isGuestPrint = "GuestPrint".equalsIgnoreCase(GuestPrint);
            if (!isGuestPrint) {
                PermissionHelper.checkPermission((String)"sim", (String)"sim_vatinvoice", (long)DynamicObjectUtil.getDynamicObjectLongValue((Object)vatInvoiceList[0].get("orgid")), (ImcPermItemEnum)ImcPermItemEnum.INVOICE_PRINT);
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{PRINT});
            String invoiceType = this.getPageCache().get("invoicetype");
            if (InvoiceUtils.isAllEPaperVehicleInvoice((String)invoiceType) || "1".equals(this.getView().getFormShowParameter().getCustomParam("elePaper")) || InvoiceUtils.isAllEPapperUsedCarInvoice((String)invoiceType)) {
                this.getPageCache().put("salertaxno", vatInvoiceList[0].getString("salertaxno"));
                HashMap<String, Object> param = new HashMap<String, Object>(4);
                param.put("salertaxno", vatInvoiceList[0].getString("salertaxno"));
                param.put("account", this.getModel().getValue("account"));
                if (AllEleServiceHelper.isNeedLogin((AbstractFormPlugin)this, param)) {
                    return;
                }
                this.startElePaperPrint(vatInvoiceList);
                return;
            }
            this.startPrint(vatInvoiceList);
        }
    }

    private DynamicObject[] getInvoice() {
        Map customParams = PaperPrintHelper.getCustomParams((AbstractFormPlugin)this);
        JSONArray arr = (JSONArray)customParams.get("keys");
        String tableFormId = PrintInvoiceControl.getFormId((String)this.getPageCache().get("printType"));
        return BusinessDataServiceHelper.load((String)tableFormId, (String)PropertieUtil.getAllPropertiesSplitByComma((String)tableFormId), (QFilter[])new QFilter("id", "in", (Object)arr.toArray()).toArray(), (String)MessageFormat.format("{0} asc", "invoiceno"));
    }

    public void afterCreateNewData(EventObject e) {
        JSONObject printMachineResponseJson;
        this.getView().setEnable(Boolean.FALSE, new String[]{"entryentity"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"accountflex"});
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String invoiceType = (String)formShowParameter.getCustomParam("invoicetype");
        String printType = (String)formShowParameter.getCustomParam("type");
        String GuestPrint = (String)formShowParameter.getCustomParam("GuestPrint");
        boolean isGuestPrint = "GuestPrint".equalsIgnoreCase(GuestPrint);
        if (!PrintTypeEnum.QD_PRINT.getType().equals(printType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"printnumflex"});
        } else {
            String printNum = CacheHelper.get((String)("detail_print_num" + RequestContext.get().getOrgId() + RequestContext.get().getUserId()));
            if (StringUtils.isNotBlank((CharSequence)printNum)) {
                this.getModel().setValue("printnum", (Object)Integer.parseInt(printNum));
            }
        }
        this.getPageCache().put("invoicetype", invoiceType);
        this.getPageCache().put("printType", printType);
        DynamicObject[] vatInvoiceList = this.getInvoice();
        if (vatInvoiceList == null || vatInvoiceList.length == 0) {
            return;
        }
        if (!isGuestPrint && "sim_vatinvoice_vehicles".equals(PrintInvoiceControl.getFormId((String)printType))) {
            PermissionHelper.checkPermission((String)"sim", (String)"sim_vatinvoice_vehicles", (long)DynamicObjectUtil.getDynamicObjectLongValue((Object)vatInvoiceList[0].get("orgid")), (ImcPermItemEnum)ImcPermItemEnum.INVOICE_PRINT);
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{COMPONENTFLEX});
        PrintInvoiceControl.initListViewAndShowSummation((AbstractFormPlugin)this, (String)printType, (DynamicObject[])vatInvoiceList);
        if (InvoiceUtils.isAllEPaperVehicleInvoice((String)invoiceType) || "1".equals(formShowParameter.getCustomParam("elePaper")) || InvoiceUtils.isAllEPapperUsedCarInvoice((String)invoiceType)) {
            ViewUtil.bindDataToHtml((AbstractFormPlugin)this, new HashMap(), (String)ELE_PAPER_PRINT);
            this.getView().setVisible(Boolean.FALSE, new String[]{"printflex"});
            SelectDeviceUtil.setAccount((AbstractFormPlugin)this, (String)vatInvoiceList[0].getString("salertaxno"), (String)"");
            return;
        }
        this.sendData2CustomView("0", "************", "************", "1", ResManager.loadKDString((String)"\u5f00\u59cb\u6253\u5370", (String)"InvoicePrintListPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        String printName = PrintInvoiceControl.getPrinterNameCacheKey((String)printType, (String)vatInvoiceList[0].getString("jqbh"));
        try {
            printMachineResponseJson = PrintInvoiceControl.sendGetPrintMachineRequest((String)vatInvoiceList[0].getString("jqbh"), (long)DynamicObjectUtil.getDynamicObjectLongValue((Object)vatInvoiceList[0].get("orgid")));
        }
        catch (MsgException msgException) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u6253\u5370\u673a\u5217\u8868\u5931\u8d25\uff1a%s", (String)"InvoicePrintListPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), msgException.getErrorMsg()));
            return;
        }
        LOGGER.info("getMachineInfo:" + printMachineResponseJson);
        if (ErrorType.SUCCESS.getCode().equals(printMachineResponseJson.getString("errcode"))) {
            PrintInvoiceControl.handleGetPrinterMachineResponse((AbstractFormPlugin)this, (JSONObject)printMachineResponseJson, (String)printName);
            return;
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{PRINT});
        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u6253\u5370\u673a\u5217\u8868\u5931\u8d25:%1$s errMsg:%2$s", (String)"InvoicePrintListPlugin_10", (String)"imc-sim-formplugin", (Object[])new Object[0]), vatInvoiceList[0].getString("jqbh"), printMachineResponseJson.getString("description")));
    }

    private void sendData2CustomView(String printSeq, String invoiceCode, String invoiceNo, String timeFlag, String printType) {
        Map map = PrintInvoiceControl.getSendCustomViewData((String)printSeq, (String)invoiceCode, (String)invoiceNo, (String)timeFlag, (String)printType);
        CustomControl printControl = (CustomControl)this.getView().getControl(COMPONENTFLEX);
        printControl.setData((Object)map);
    }

    private void startPrint(DynamicObject[] invoiceList) {
        this.getView().setVisible(Boolean.TRUE, new String[]{COMPONENTFLEX});
        String printType = this.getPageCache().get("printType");
        LOGGER.info("startPrint printType: " + printType);
        String printTypeStr = printType.equals(PrintTypeEnum.QD_PRINT.getType()) ? "\u6253\u5370\u6e05\u5355" : "\u6253\u5370\u53d1\u7968";
        String printmerName = this.getView().getControl("printmer").getModel().getValue("printmer").toString();
        LOGGER.info("startPrint \u5728\u6267\u884c\u6253\u5370\u7684\u6253\u5370\u673aprintmerName\uff1a" + printmerName);
        String printCache = IMC_SIM_PRINT_CACHE + this.getView().getPageId();
        String printErrCache = IMC_SIM_PRINT_DEFEAT_CACHE + this.getView().getPageId();
        String printNameCacheKey = PrintInvoiceControl.getPrinterNameCacheKey((String)printType, (String)invoiceList[0].getString("jqbh"));
        LOGGER.info("startPrint cachePrintNameKey: " + printNameCacheKey);
        CacheHelper.put((String)printNameCacheKey, (String)printmerName, (int)2592000);
        ThreadPools.executeOnce((String)"for:paper-print", () -> {
            int successFlag = 0;
            JSONObject jObject = JSONObject.parseObject((String)"{}");
            jObject.put("printseq", (Object)(successFlag + 1));
            jObject.put("invoicecode", (Object)invoiceList[0].getString("invoicecode"));
            jObject.put("invoiceno", (Object)invoiceList[0].getString("invoiceno"));
            jObject.put("timeflag", (Object)"1");
            jObject.put("printtype", (Object)printTypeStr);
            this.getPageCache().put(printCache, jObject.toJSONString());
            this.sendData2CustomView("1", invoiceList[0].getString("invoicecode"), invoiceList[0].getString("invoiceno"), "1", printTypeStr);
            String requestUrl = ComponentServiceHelper.getComponentRequestUrl((String)invoiceList[0].getString("jqbh"));
            int printCount = ((BigDecimal)this.getModel().getValue("printnum")).intValue();
            CacheHelper.put((String)("detail_print_num" + RequestContext.get().getOrgId() + RequestContext.get().getUserId()), (String)String.valueOf(printCount), (int)604800);
            for (DynamicObject obj : invoiceList) {
                jObject.put("printseq", (Object)(++successFlag));
                jObject.put("invoicecode", (Object)obj.getString("invoicecode"));
                jObject.put("invoiceno", (Object)obj.getString("invoiceno"));
                jObject.put("timeflag", (Object)"1");
                jObject.put("printtype", (Object)printTypeStr);
                this.getPageCache().put(printCache, jObject.toJSONString());
                LOGGER.info(String.format("startPrint \u6279\u91cf\u6253\u5370\u7684\u53d1\u7968\u4ee3\u7801\uff1a%s \u53f7\u7801\uff1a%s", obj.getString("invoicecode"), obj.getString("invoiceno")));
                boolean printRequest = true;
                for (int i = 0; i < printCount; ++i) {
                    try {
                        String requestData = PrintInvoiceControl.makeComponentReqJSON((DynamicObject)obj, (String)printType, (String)printmerName).toJSONString();
                        String errorMsg = PrintInvoiceControl.sendPrintInvoiceRequest((String)requestData, (String)requestUrl, (DynamicObject)obj);
                        if (StringUtils.isEmpty((CharSequence)errorMsg)) continue;
                        this.getPageCache().put("printErrorMsg", errorMsg);
                        printRequest = false;
                        continue;
                    }
                    catch (Exception e) {
                        printRequest = false;
                        LOGGER.error(String.format("startPrint \u53d1\u7968\u53f7\u7801%s\u6253\u5370\u5931\u8d25", obj.getString("invoiceno")), (Throwable)e);
                        break;
                    }
                }
                if (!printRequest) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("batchPrintDefault:" + this.getPageCache().get(printCache));
                    }
                    jObject.put("timeflag", (Object)"0");
                    this.getPageCache().put(printErrCache, jObject.toJSONString());
                    this.getPageCache().remove(printCache);
                    this.sendData2CustomView(jObject.getString("printseq"), jObject.getString("invoicecode"), jObject.getString("invoiceno"), "0", printTypeStr);
                    break;
                }
                if (successFlag != invoiceList.length) continue;
                jObject.put("timeflag", (Object)"0");
                this.getPageCache().put(printCache, jObject.toJSONString());
                this.sendData2CustomView(jObject.getString("printseq"), jObject.getString("invoicecode"), jObject.getString("invoiceno"), "0", printTypeStr);
            }
        });
    }

    private void startElePaperPrint(DynamicObject[] vatInvoiceList) {
        this.getView().setVisible(Boolean.TRUE, new String[]{ELE_PAPER_PRINT});
        String tableName = vatInvoiceList[0].getDynamicObjectType().getName();
        ArrayList<AllElePaperPrintResponseDTO> list = new ArrayList<AllElePaperPrintResponseDTO>(vatInvoiceList.length);
        for (DynamicObject inv : vatInvoiceList) {
            AllElePaperPrintResponseDTO paperPrint = new AllElePaperPrintResponseDTO();
            paperPrint.setInvoiceCode(inv.getString("invoicecode"));
            paperPrint.setInvoiceNo(inv.getString("invoiceno"));
            if ("sim_vatinvoice_vehicles".equals(tableName)) {
                if (InvoiceUtils.isAllEPaperVehicleInvoice((String)inv.getString("invoicetype"))) {
                    paperPrint.setInvoiceCategory("87");
                } else {
                    paperPrint.setInvoiceCategory("88");
                }
            } else if (InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode().equals(inv.getString("invoicetype"))) {
                paperPrint.setInvoiceCategory("86");
            } else {
                paperPrint.setInvoiceCategory("85");
            }
            paperPrint.setEtaxInvoiceNo(inv.getString("alletaxinvoiceno"));
            paperPrint.setInvoiceDate(DateUtils.format((Date)inv.getDate("issuetime"), (String)"yyyy-MM-dd HH:mm:ss"));
            list.add(paperPrint);
        }
        HashMap<String, Object> param = new HashMap<String, Object>(4);
        param.put("errCode", "0000");
        param.put("eventKey", PRINT);
        param.put("invoiceList", list);
        ViewUtil.bindDataToHtml((AbstractFormPlugin)this, param, (String)ELE_PAPER_PRINT);
    }

    public void customEvent(CustomEventArgs e) {
        String args = e.getEventArgs();
        String printCache = IMC_SIM_PRINT_CACHE + this.getView().getPageId();
        String printErrCache = IMC_SIM_PRINT_DEFEAT_CACHE + this.getView().getPageId();
        switch (e.getEventName()) {
            case "foreachData": {
                String data = this.getPageCache().get(printCache);
                if (StringUtils.isNotBlank((CharSequence)data)) {
                    JSONObject dObject = JSONObject.parseObject((String)data);
                    if (!StringUtils.isNotBlank((CharSequence)args)) break;
                    this.sendData2CustomView(dObject.getString("printseq"), dObject.getString("invoicecode"), dObject.getString("invoiceno"), dObject.getString("timeflag"), dObject.getString("printtype"));
                    break;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{COMPONENTFLEX});
                if (this.getPageCache().get(printErrCache) != null) {
                    PrintInvoiceControl.jumpShowPrintSuccessOrErrorPage((AbstractFormPlugin)this, (String)printErrCache, (boolean)false);
                    break;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6253\u5370\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6216\u91cd\u8bd5", (String)"InvoicePrintListPlugin_8", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                break;
            }
            case "closePrint": {
                if (args.equals("finish")) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{COMPONENTFLEX});
                    if (this.getPageCache().get(printErrCache) != null) {
                        PrintInvoiceControl.jumpShowPrintSuccessOrErrorPage((AbstractFormPlugin)this, (String)printErrCache, (boolean)false);
                        break;
                    }
                    PrintInvoiceControl.jumpShowPrintSuccessOrErrorPage((AbstractFormPlugin)this, null, (boolean)true);
                    break;
                }
                if (args.equals("close") && this.getPageCache().get(printCache) != null && this.getPageCache().get(printErrCache) == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u6253\u5370\u4e2d\uff0c\u8bf7\u52ff\u5f3a\u884c\u5173\u95ed", (String)"InvoicePrintListPlugin_9", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (!args.equals("close") || this.getPageCache().get(printCache) != null) break;
                this.getView().setVisible(Boolean.FALSE, new String[]{COMPONENTFLEX});
                break;
            }
            case "queryPrintInfo": {
                this.queryPrintInfo(args);
                break;
            }
            case "stepFinish": {
                this.updateInvoicePrinted(args);
                break;
            }
            case "showError": {
                this.getView().showErrorNotification(args);
                break;
            }
            case "showSuccess": {
                this.getView().showSuccessNotification(args);
            }
        }
    }

    private void updateInvoicePrinted(String args) {
        String tableFormId;
        DynamicObject invoice;
        AllElePaperPrintResponseDTO requestParam = (AllElePaperPrintResponseDTO)JSONObject.parseObject((String)args, AllElePaperPrintResponseDTO.class);
        if (StringUtils.isNotBlank((CharSequence)requestParam.getInvoiceCode()) && StringUtils.isNotBlank((CharSequence)requestParam.getInvoiceNo()) && (invoice = BusinessDataServiceHelper.loadSingle((String)(tableFormId = PrintInvoiceControl.getFormId((String)this.getPageCache().get("printType"))), (String)"printflag", (QFilter[])new QFilter("invoicecode", "=", (Object)requestParam.getInvoiceCode()).and("invoiceno", "=", (Object)requestParam.getInvoiceNo()).toArray())) != null) {
            invoice.set("printflag", (Object)"1");
            ImcSaveServiceHelper.update((DynamicObject)invoice);
        }
    }

    private void queryPrintInfo(String args) {
        AllElePaperPrintResponseDTO requestParam = (AllElePaperPrintResponseDTO)JSONObject.parseObject((String)args, AllElePaperPrintResponseDTO.class);
        AllElePaperPrintRequestDTO request = new AllElePaperPrintRequestDTO();
        request.setAccount((String)this.getModel().getValue("account"));
        request.setRequest_path(AllEleInterfaceTypeEnum.PAGER_PRINT_QUERY.getRequestPath());
        request.setSalerTaxNo(this.getPageCache().get("salertaxno"));
        request.setGovInvoiceType(requestParam.getInvoiceCategory());
        request.setInvoiceCode(requestParam.getInvoiceCode());
        request.setInvoiceNo(requestParam.getInvoiceNo());
        request.setEtaxInvoiceNo(requestParam.getEtaxInvoiceNo());
        request.setInvoiceDate(requestParam.getInvoiceDate());
        request.setPrintType(Integer.valueOf(0));
        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801:[%1$s],\u53d1\u7968\u53f7\u7801:[%2$s]\u6b63\u5728\u6253\u5370", (String)"InvoicePrintListPlugin_11", (String)"imc-sim-formplugin", (Object[])new Object[0]), requestParam.getInvoiceCode(), requestParam.getInvoiceNo()));
        AllEleResponseDTO response = AllEleServiceHelper.doPost((String)this.getPageCache().get("salertaxno"), (AllEleRequestDTO)request, JSONObject.class);
        if (!response.getSuccess().booleanValue()) {
            this.getView().showErrorNotification(response.getDescription());
            return;
        }
        JSONObject data = (JSONObject)response.getData();
        data.put("invoiceCode", (Object)requestParam.getInvoiceCode());
        data.put("invoiceNo", (Object)requestParam.getInvoiceNo());
        data.put("etaxInvoiceNo", (Object)requestParam.getEtaxInvoiceNo());
        HashMap<String, String> param = new HashMap<String, String>(4);
        param.put("eventKey", "queryPrintInfo");
        param.put("errCode", "0000");
        param.put("data", (String)data);
        ViewUtil.bindDataToHtml((AbstractFormPlugin)this, param, (String)ELE_PAPER_PRINT);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if ("sim_print_success".equals(actionId)) {
            this.getView().returnDataToParent((Object)"colse");
            this.getView().close();
        } else if ("bdm_tax_login".equals(actionId)) {
            if (closedCallBackEvent.getReturnData() == null) {
                return;
            }
            this.startElePaperPrint(this.getInvoice());
        }
    }
}

