/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imc.bdm.common.dto.BillMatch.BillMatchDetailVo;
import kd.imc.bdm.common.dto.BillMatch.BillMatchInvoiceDetailVo;
import kd.imc.bdm.common.dto.BillMatch.BillMatchResultResponseVo;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.callback.SendCallBackHelper;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.HttpUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.constant.table.MatchBillConstant;
import kd.imc.sim.common.dto.minusbill.MatchInvoiceDTO;
import kd.imc.sim.common.dto.minusbill.MinusBillDTO;
import kd.imc.sim.common.dto.minusbill.MinusBillItemDTO;
import kd.imc.sim.formplugin.match.MinusBillMatchHelper;
import org.apache.commons.collections.CollectionUtils;

public class MatchBillAsyncTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(MatchBillAsyncTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try (DLock lock = DLock.create((String)MatchBillAsyncTask.class.getName());){
            if (!lock.tryLock(1000L)) {
                return;
            }
            DeleteServiceHelper.delete((String)"sim_billmatch_data", (QFilter[])new QFilter("createdatefield", "<=", (Object)DateUtils.addDay((Date)new Date(), (int)-31)).toArray());
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"sim_billmatch_data", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_billmatch_data"), (QFilter[])new QFilter("matchStatus", "=", (Object)"0").toArray());
            this.retryCallBackFailed();
            MatchBillAsyncTask.matchBillMethod(dynamicObjects);
        }
    }

    private void retryCallBackFailed() {
        DynamicObject[] retryList;
        for (DynamicObject dynamicObject : retryList = BusinessDataServiceHelper.load((String)"sim_billmatch_data", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_billmatch_data"), (QFilter[])new QFilter("callbackstatus", "=", (Object)"2").toArray())) {
            logger.info("\u5339\u914d\u56de\u8c03\u5931\u8d25\u91cd\u63a8\uff1a" + dynamicObject.getString("billno"));
            BillMatchResultResponseVo billMatchResultResponseVo = (BillMatchResultResponseVo)JSON.parseObject((String)dynamicObject.getString("responsedata_tag"), BillMatchResultResponseVo.class);
            MatchBillAsyncTask.callBackMatchResult(dynamicObject, billMatchResultResponseVo);
        }
        if (retryList.length > 0) {
            ImcSaveServiceHelper.update((DynamicObject[])retryList);
        }
    }

    public static void matchBillMethod(DynamicObject[] dynamicObjects) {
        MinusBillMatchHelper minusBillMatchHelper = new MinusBillMatchHelper();
        for (DynamicObject dynamicObject : dynamicObjects) {
            MinusBillDTO minusBillDTO = (MinusBillDTO)JSON.parseObject((String)dynamicObject.getString("requestdata_tag"), MinusBillDTO.class);
            BillMatchResultResponseVo billMatchResponseVo = new BillMatchResultResponseVo();
            billMatchResponseVo.setBillNo(dynamicObject.getString("billno"));
            billMatchResponseVo.setMatchRule(dynamicObject.getString("matchRule"));
            billMatchResponseVo.setMatchName(dynamicObject.getString("matchName"));
            try {
                billMatchResponseVo.setMatchTime(DateUtils.format((Date)MinusBillMatchHelper.getMatchTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                minusBillMatchHelper.match(minusBillDTO);
            }
            catch (Exception e) {
                logger.error(String.format("\u5339\u914d\u5355\u636e\u4efb\u52a1\u53f7:[%s],\u5931\u8d25\u539f\u56e0:[%s]", dynamicObject.getString("batchno"), e), (Throwable)e);
                billMatchResponseVo.setMatchStatus("3");
                billMatchResponseVo.setMatchResult("0");
                dynamicObject.set("matchstatus", (Object)"3");
                dynamicObject.set("responsedata_tag", (Object)SerializationUtils.toJsonString((Object)billMatchResponseVo));
                dynamicObject.set("matchtime", (Object)DateUtils.stringToDate((String)billMatchResponseVo.getMatchTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                ImcSaveServiceHelper.save((DynamicObject)dynamicObject);
                continue;
            }
            try {
                boolean amountStandard = minusBillDTO.getConfig().getAmountStandard();
                boolean isMatch = false;
                boolean isAllMatch = true;
                ArrayList billMatchDetailVoList = Lists.newArrayListWithCapacity((int)0);
                for (MinusBillItemDTO minusBillDTOItem : minusBillDTO.getItems()) {
                    BillMatchDetailVo billMatchDetailVo = new BillMatchDetailVo();
                    billMatchDetailVo.setDetailId(minusBillDTOItem.getMatchOrMergeItemId().toString());
                    if (MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode().equals(minusBillDTOItem.getMatchStatus())) {
                        isMatch = true;
                        billMatchDetailVo.setMatchResult("1");
                        MatchBillAsyncTask.formatBillDetail(minusBillDTOItem, billMatchDetailVo, amountStandard);
                    } else if (CollectionUtils.isNotEmpty((Collection)minusBillDTOItem.getInvoiceList())) {
                        isMatch = true;
                        isAllMatch = false;
                        billMatchDetailVo.setMatchResult("2");
                        MatchBillAsyncTask.formatBillDetail(minusBillDTOItem, billMatchDetailVo, amountStandard);
                    } else {
                        isAllMatch = false;
                        billMatchDetailVo.setMatchResult("0");
                    }
                    billMatchDetailVoList.add(billMatchDetailVo);
                }
                if (isMatch) {
                    if (isAllMatch) {
                        billMatchResponseVo.setMatchStatus("2");
                        billMatchResponseVo.setMatchResult("1");
                    } else {
                        billMatchResponseVo.setMatchStatus("2");
                        billMatchResponseVo.setMatchResult("2");
                    }
                } else {
                    billMatchResponseVo.setMatchStatus("2");
                    billMatchResponseVo.setMatchResult("0");
                }
                billMatchResponseVo.setBillDetail((List)billMatchDetailVoList);
                dynamicObject.set("responsedata_tag", (Object)SerializationUtils.toJsonString((Object)billMatchResponseVo));
                dynamicObject.set("matchstatus", (Object)billMatchResponseVo.getMatchStatus());
                dynamicObject.set("matchresult", (Object)billMatchResponseVo.getMatchResult());
                dynamicObject.set("matchtime", (Object)DateUtils.stringToDate((String)billMatchResponseVo.getMatchTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                MatchBillAsyncTask.callBackMatchResult(dynamicObject, billMatchResponseVo);
                ImcSaveServiceHelper.save((DynamicObject)dynamicObject);
            }
            catch (Exception e) {
                logger.error(String.format("\u5339\u914d\u5355\u636e\u4efb\u52a1\u53f7:[%s],\u6570\u636e\u7ec4\u88c5\u5931\u8d25\u539f\u56e0:[%s]", dynamicObject.getString("batchno"), e.getMessage()), (Throwable)e);
            }
        }
    }

    private static void callBackMatchResult(DynamicObject dynamicObject, BillMatchResultResponseVo billMatchResponseVo) {
        if (StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("callbackurl"))) {
            int callbackCount = dynamicObject.getInt("callbackretry");
            try {
                if (callbackCount > 2) {
                    logger.info("\u5339\u914d\u56de\u63a8\u8d85\u8fc73\u6b21");
                    return;
                }
                int callBackTimeOut = SendCallBackHelper.getCallBackTimeOut();
                String result = HttpUtil.doPostJson((String)dynamicObject.getString("callbackurl"), null, (String)SerializationUtils.toJsonString((Object)billMatchResponseVo), (int)callBackTimeOut, (int)callBackTimeOut);
                logger.info("\u5339\u914d\u56de\u63a8result: " + result);
                JSONObject json = JSON.parseObject((String)result);
                if ("0".equals(json.getString("errorCode"))) {
                    dynamicObject.set("callbackstatus", (Object)"1");
                } else {
                    dynamicObject.set("callbackstatus", (Object)"2");
                    if (result.length() > 100) {
                        dynamicObject.set("callbackresp", (Object)result.substring(0, 99));
                    } else {
                        dynamicObject.set("callbackresp", (Object)result);
                    }
                }
            }
            catch (Exception e) {
                logger.error("\u5339\u914d\u56de\u63a8\u5f02\u5e38:", (Throwable)e);
                dynamicObject.set("callbackstatus", (Object)"2");
                if (e.getMessage() != null && e.getMessage().length() > 50) {
                    dynamicObject.set("callbackresp", (Object)e.getMessage().substring(0, 49));
                }
                dynamicObject.set("callbackresp", (Object)e.getMessage());
            }
            dynamicObject.set("callbackretry", (Object)(callbackCount + 1));
        }
    }

    private static void formatBillDetail(MinusBillItemDTO minusBillDTOItem, BillMatchDetailVo billMatchDetailVo, boolean amountStandard) {
        BigDecimal matchAmountOrNum = minusBillDTOItem.getMatchAmountOrNum();
        BigDecimal matchTaxAmount = BigDecimal.ZERO;
        BigDecimal matchTotalAmount = BigDecimal.ZERO;
        if (amountStandard) {
            matchTaxAmount = matchAmountOrNum.multiply(BigDecimal.valueOf(Double.parseDouble(minusBillDTOItem.getTaxRate()))).setScale(2, RoundingMode.HALF_UP);
            matchTotalAmount = matchAmountOrNum.add(matchTaxAmount).setScale(2, RoundingMode.HALF_UP);
            billMatchDetailVo.setMatchAmount(matchAmountOrNum.toPlainString());
            billMatchDetailVo.setMatchTaxAmount(matchTaxAmount.toPlainString());
            billMatchDetailVo.setMatchTotalAmount(matchTotalAmount.toPlainString());
        } else {
            matchAmountOrNum = BigDecimal.ZERO;
        }
        ArrayList billMatchList = Lists.newArrayListWithCapacity((int)0);
        for (MatchInvoiceDTO matchInvoiceDTO : minusBillDTOItem.getInvoiceList()) {
            BillMatchInvoiceDetailVo billMatch = new BillMatchInvoiceDetailVo();
            billMatch.setInvoiceCode(matchInvoiceDTO.getInvoicecode());
            billMatch.setInvoiceNo(matchInvoiceDTO.getInvoiceno());
            billMatch.setOriginalSeq(matchInvoiceDTO.getItemseq() == null ? "" : matchInvoiceDTO.getItemseq().toString());
            billMatch.setSeq(MatchBillAsyncTask.culculateSeq(billMatch.getOriginalSeq()));
            billMatch.setRedQuantity(matchInvoiceDTO.getItemNum() == null ? "" : matchInvoiceDTO.getItemNum().stripTrailingZeros().toPlainString());
            billMatch.setMatchAmount(matchInvoiceDTO.getItemAmount() == null ? "" : matchInvoiceDTO.getItemAmount().toPlainString());
            billMatch.setMatchTaxAmount(matchInvoiceDTO.getItemTax() == null ? "" : matchInvoiceDTO.getItemTax().stripTrailingZeros().toPlainString());
            billMatch.setMatchTotalAmount(matchInvoiceDTO.getItemAmount().add(matchInvoiceDTO.getItemTax()).setScale(2, RoundingMode.HALF_UP).toPlainString());
            if (!amountStandard) {
                matchAmountOrNum = matchAmountOrNum.add(matchInvoiceDTO.getItemAmount());
                matchTaxAmount = matchTaxAmount.add(matchInvoiceDTO.getItemTax());
            }
            long invoiceId = matchInvoiceDTO.getInvoiceid();
            DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])new QFilter("id", "=", (Object)invoiceId).toArray());
            if (invoice != null) {
                billMatch.setInvoiceDate(DateUtils.format((Date)invoice.getDate("issuetime"), (String)"yyyy-MM-dd HH:mm:ss"));
                billMatch.setInvoiceType(invoice.getString("invoicetype"));
                DynamicObjectCollection items = invoice.getDynamicObjectCollection("items");
                if (items.size() != 0) {
                    for (DynamicObject item : items) {
                        if (!item.getPkValue().toString().equals(matchInvoiceDTO.getItemid().toString())) continue;
                        billMatch.setRemainAmount(item.getBigDecimal("itemremainredamount").setScale(2, RoundingMode.HALF_UP).toPlainString());
                        billMatch.setRemainQuantity(BigDecimalUtil.formatNumOrUnitPrice((BigDecimal)item.getBigDecimal("itemremainrednum"), (int)16).stripTrailingZeros().toPlainString());
                        billMatch.setRemainTaxAmount(item.getBigDecimal("itemremainredtax").setScale(2, RoundingMode.HALF_UP).toPlainString());
                        billMatch.setPrice(item.getBigDecimal("unitprice").stripTrailingZeros().toPlainString());
                        billMatch.setRedPrice(matchInvoiceDTO.getItemUnitprice() == null ? "" : matchInvoiceDTO.getItemUnitprice().stripTrailingZeros().toPlainString());
                    }
                }
            }
            billMatchList.add(billMatch);
        }
        if (!amountStandard) {
            matchTotalAmount = matchAmountOrNum.add(matchTaxAmount);
            billMatchDetailVo.setMatchAmount(matchAmountOrNum.toPlainString());
            billMatchDetailVo.setMatchTaxAmount(matchTaxAmount.toPlainString());
            billMatchDetailVo.setMatchTotalAmount(matchTotalAmount.toPlainString());
        }
        billMatchDetailVo.setInvoiceDetail((List)billMatchList);
    }

    private static String culculateSeq(String originalSeq) {
        if (StringUtils.isNotBlank((CharSequence)originalSeq)) {
            try {
                int intOriginalSeq = Integer.parseInt(originalSeq);
                return String.valueOf(intOriginalSeq - 1);
            }
            catch (Exception e) {
                return "";
            }
        }
        return "";
    }
}

