/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.redconfirm;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.OperationConstant;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceQueryUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.bdm.lqpt.model.response.collect.InvoiceStatusQueryResponse;
import kd.imc.sim.common.constant.RedConfirmBillRedReasonEnum;
import kd.imc.sim.common.constant.RiskControlRecordConstant;
import kd.imc.sim.common.helper.RimLqptQueryHelper;
import kd.imc.sim.common.model.invoice.TaxedTypeEnum;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.bill.helper.RimInvoiceHelper;
import kd.imc.sim.formplugin.bill.originalbill.control.AllESpecialTypeControl;
import kd.imc.sim.formplugin.bill.originalbill.control.InvoiceOriginalFormControl;
import kd.imc.sim.formplugin.redconfirm.control.RedConfirmBillAddControl;
import kd.imc.sim.formplugin.redconfirm.control.RedConfirmBillIssueControl;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillHelper;
import kd.imc.sim.formplugin.risk.control.BillRiskControlService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class RedConfirmBillAddPlugin
extends AbstractFormPlugin
implements AfterF7SelectListener,
BeforeF7SelectListener {
    private static final String BILL_KEY = "billKey";
    private static final String BTN_ADDROW = "addrow";
    private static final String EDIT_TAX = "edittax";
    private static final String BTN_SUBMIT = "btn_submit";
    private static final String[] ITEM_DISABLE_KEY = new String[]{"num", "taxamount", "amount"};
    private static final Log LOGGER = LogFactory.getLog(RedConfirmBillAddPlugin.class);

    public void afterCreateNewData(EventObject e) {
        String orgId;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().setValue("applicant", customParams.get("applicant"));
        this.getModel().setValue("redreason", customParams.get("redreason"));
        String invoiceIdStr = (String)customParams.get("id");
        if (StringUtils.isBlank((CharSequence)invoiceIdStr)) {
            return;
        }
        long invoiceId = Long.parseLong(invoiceIdStr);
        if (0L == invoiceId) {
            return;
        }
        String billKey = customParams.getOrDefault(BILL_KEY, "sim_vatinvoice");
        DynamicObject invoice = BusinessDataServiceHelper.loadSingle((Object)invoiceId, (String)billKey);
        if (!"sim_vatinvoice".equals(billKey) && !"sim_vatinvoice_vehicles".equals(billKey)) {
            invoice = RimInvoiceHelper.createInvoiceByRim((DynamicObject)invoice);
        }
        try {
            this.getPageCache().put("remainRedAmount", invoice.getBigDecimal("remainredamount").toPlainString());
            this.getPageCache().put("taxedtype", invoice.getString("taxedtype"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        RedConfirmBillHelper.initRedConfirmBillFromInvoice((AbstractFormPlugin)this, (DynamicObject)invoice, (String)billKey);
        if (!"sim_vatinvoice".equals(billKey)) {
            this.setItemTaxEnable(false);
        }
        if (StringUtils.isNotBlank((CharSequence)(orgId = (String)customParams.get("org")))) {
            this.getPageCache().put("org", orgId);
        }
        this.queryLqOriginalInvoiceIssueTime();
    }

    private void queryLqOriginalInvoiceIssueTime() {
        try {
            String originalInvoiceType = (String)this.getModel().getValue("originalinvoicetype");
            if (StringUtils.isBlank((CharSequence)originalInvoiceType)) {
                return;
            }
            if (InvoiceUtils.isAllEInvoice((Object)originalInvoiceType)) {
                return;
            }
            Date originalIssueTime = (Date)this.getModel().getValue("originalissuetime");
            if (originalIssueTime == null) {
                return;
            }
            String hhmmss = DateUtils.format((Date)originalIssueTime, (String)"HHmmss");
            if (!"000000".equals(hhmmss)) {
                return;
            }
            String accountingQuery = ImcConfigUtil.getValue((String)"bdm_lqpt", (String)"open_rim_invoice_account_query");
            if (!"1".equals(accountingQuery)) {
                return;
            }
            String taxNo = (String)this.getModel().getValue("salertaxno");
            if ("1".equals(this.getModel().getValue("enteridentity"))) {
                taxNo = (String)this.getModel().getValue("buyertaxno");
            }
            if (!EnterpriseHelper.isLqptChannel((String)taxNo)) {
                return;
            }
            InvoiceStatusQueryResponse statusQueryResponse = new RimLqptQueryHelper().invoiceAccountingQuery(taxNo, originalInvoiceType, (String)this.getModel().getValue("originalinvoicecode"), (String)this.getModel().getValue("originalinvoiceno"), originalIssueTime);
            if (statusQueryResponse.getKprq() != null) {
                this.getModel().setValue("originalissuetime", (Object)statusQueryResponse.getKprq());
            }
        }
        catch (Exception e) {
            LOGGER.info("\u7a0e\u63a7\u7968\u8bbe\u7f6e\u539f\u84dd\u7968\u65e5\u671f\u5931\u8d25" + e.getMessage());
        }
    }

    public void afterBindData(EventObject e) {
        String account;
        QFilter qFilter;
        DynamicObject blueInvoice;
        String orgStr = this.getPageCache().get("org");
        if (StringUtils.isNotBlank((CharSequence)orgStr)) {
            long orgId = Long.parseLong(orgStr);
            this.getModel().setValue("org", (Object)orgId);
            this.getModel().setValue("useorg", (Object)orgId);
            this.getModel().setValue("createorg", (Object)orgId);
        }
        AllESpecialTypeControl.showOrHideFields((AbstractFormPlugin)this, (boolean)true);
        AllESpecialTypeControl.dealShowOrHideSpecailAreaMethod((AbstractFormPlugin)this);
        this.getModel().setDataChanged(false);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String invoiceIdStr = (String)formShowParameter.getCustomParam("id");
        String originalinvoiceno = (String)this.getModel().getValue("originalinvoiceno");
        String uploadstatus = (String)this.getModel().getValue("uploadstatus");
        this.cacheRedConfirmItems();
        if (StringUtils.isNotEmpty((CharSequence)invoiceIdStr)) {
            long invoiceId = Long.parseLong(invoiceIdStr);
            if (0L != invoiceId) {
                this.readReasonShowView();
            }
        } else if ("0".equals(uploadstatus) && StringUtils.isNotEmpty((CharSequence)originalinvoiceno) && null != (blueInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"remainredamount,taxedtype", (QFilter[])(qFilter = new QFilter("invoiceno", "=", (Object)originalinvoiceno)).toArray()))) {
            this.getPageCache().put("remainRedAmount", blueInvoice.getBigDecimal("remainredamount").toPlainString());
            this.getPageCache().put("taxedtype", blueInvoice.getString("taxedtype"));
            this.readReasonShowView();
            Object redReason = this.getModel().getValue("redreason");
            if (RedConfirmBillRedReasonEnum.SALES_DISCOUNTS.getCode().equals(redReason)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"redreason"});
            }
        }
        Object uploadStatus = this.getModel().getValue("uploadstatus");
        boolean uploadFlag = "1".equals(uploadStatus);
        this.getView().setVisible(Boolean.valueOf(!uploadFlag), new String[]{BTN_SUBMIT});
        String taxNo = (String)this.getModel().getValue("salertaxno");
        if (!uploadFlag && "1".equals(this.getModel().getValue("enteridentity"))) {
            taxNo = (String)this.getModel().getValue("buyertaxno");
        }
        if (EnterpriseHelper.isLqptChannel((String)taxNo)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"account"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"account"});
        DynamicObject accountObj = AllEleAuthHelper.getAccountByTaxNo((String)taxNo);
        Pair accountList = AllEleAuthHelper.getAccountList((DynamicObject)accountObj, (boolean)true);
        ViewUtil.setDropDownViewData((AbstractFormPlugin)this, (String)"account", (Map)((Map)accountList.getValue()));
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)operationStatus) && StringUtils.isNotBlank((CharSequence)(account = (String)this.getView().getFormShowParameter().getCustomParam("account")))) {
            this.getModel().setValue("account", (Object)account);
        }
        this.dealSetBuyerNameFieldMethod(uploadStatus);
    }

    private void cacheRedConfirmItems() {
        DynamicObjectCollection itemList = this.getModel().getEntryEntity("items");
        JSONObject blueInvoiceItems = new JSONObject();
        if (CollectionUtils.isNotEmpty((Collection)itemList)) {
            for (DynamicObject dynamicObject : itemList) {
                JSONObject blueInvoiceItem = new JSONObject();
                blueInvoiceItem.put("num", dynamicObject.get("num"));
                blueInvoiceItem.put("unitprice", dynamicObject.get("unitprice"));
                blueInvoiceItem.put("taxunitprice", dynamicObject.get("taxunitprice"));
                blueInvoiceItems.put(dynamicObject.getString("originseq"), (Object)blueInvoiceItem);
            }
            this.getPageCache().put("blueInvoiceItems", blueInvoiceItems.toJSONString());
        }
    }

    private void dealSetBuyerNameFieldMethod(Object uploadStatus) {
        if ("0".equals(uploadStatus) || "2".equals(uploadStatus)) {
            String approvalStatus = (String)this.getModel().getValue("status");
            if ("B".equals(approvalStatus) || "C".equals(approvalStatus)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"buyername"});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"buyername"});
            }
        }
    }

    private void setItemValueAndDisable(String[] disableKey) {
        boolean emptyFlag = false;
        Object redReason = this.getModel().getValue("redreason");
        if (RedConfirmBillRedReasonEnum.SALES_DISCOUNTS.getCode().equals(redReason)) {
            emptyFlag = true;
        }
        DynamicObjectCollection itemList = this.getModel().getEntryEntity("items");
        String[] ableKey = ITEM_DISABLE_KEY;
        if (null != disableKey) {
            ableKey = Arrays.asList(ITEM_DISABLE_KEY).stream().filter(n -> !Arrays.asList(disableKey).contains(n)).collect(Collectors.toList()).toArray(new String[0]);
        }
        for (int i = 0; i < itemList.size(); ++i) {
            DynamicObject itemObject = (DynamicObject)itemList.get(i);
            if (emptyFlag) {
                itemObject.set("num", (Object)"");
                itemObject.set("unitprice", (Object)"");
                itemObject.set("taxunitprice", (Object)"");
            } else {
                JSONObject blueInvoiceItemJSON;
                JSONObject blueInvoiceItem;
                boolean numIsNull = StringUtils.isEmpty((CharSequence)((DynamicObject)itemList.get(i)).getString("num")) || BigDecimal.ZERO.compareTo(new BigDecimal(((DynamicObject)itemList.get(i)).getString("num"))) == 0;
                boolean unitPirceIsNull = StringUtils.isEmpty((CharSequence)((DynamicObject)itemList.get(i)).getString("unitprice")) || BigDecimal.ZERO.compareTo(new BigDecimal(((DynamicObject)itemList.get(i)).getString("unitprice"))) == 0;
                boolean taxUnitPriceIsNull = StringUtils.isEmpty((CharSequence)((DynamicObject)itemList.get(i)).getString("taxunitprice")) || BigDecimal.ZERO.compareTo(new BigDecimal(((DynamicObject)itemList.get(i)).getString("taxunitprice"))) == 0;
                String blueInvoiceItems = this.getPageCache().get("blueInvoiceItems");
                if (numIsNull && unitPirceIsNull && taxUnitPriceIsNull && StringUtils.isNotEmpty((CharSequence)blueInvoiceItems) && null != (blueInvoiceItem = (blueInvoiceItemJSON = JSONObject.parseObject((String)blueInvoiceItems)).getJSONObject(((DynamicObject)itemList.get(i)).getString("seq"))) && !blueInvoiceItem.isEmpty()) {
                    itemObject.set("num", (Object)blueInvoiceItem.getString("num"));
                    itemObject.set("unitprice", (Object)blueInvoiceItem.getString("unitprice"));
                    itemObject.set("taxunitprice", (Object)blueInvoiceItem.getString("taxunitprice"));
                }
            }
            if (MathUtils.isNullOrZero((BigDecimal)itemObject.getBigDecimal("num"))) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"num"});
            }
            if (null != disableKey) {
                this.getView().setEnable(Boolean.FALSE, i, disableKey);
            }
            if (null == ableKey || ableKey.length == 0) continue;
            this.getView().setEnable(Boolean.TRUE, i, ableKey);
        }
        this.getModel().setValue("items", (Object)itemList);
        this.getView().updateView("items");
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"tbmain", "advcontoolbarap"});
        this.addClickListeners(new String[]{"goodscode", "goodsname"});
        this.addF7SelectListener("goodsid", "taxratecodeid");
    }

    private void addF7SelectListener(String ... keys) {
        for (String key : keys) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(key);
            if (basedataEdit == null) continue;
            basedataEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (EDIT_TAX.equals(itemKey)) {
            this.setItemTaxEnable(true);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (BTN_SUBMIT.equals(itemKey) || "btn_confirm".equals(itemKey) || "btn_red".equals(itemKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            List<DynamicObject> list = Collections.singletonList(dataEntity);
            String callbackKey = "risk_control_check_" + itemKey;
            RiskControlRecordConstant.ExecuteActionEnum executeAction = RiskControlRecordConstant.ExecuteActionEnum.getExecuteActionEnumByButtonKey((String)itemKey);
            boolean antiReplayControlFlag = BillRiskControlService.riskControl(list, (String)"sim_red_confirm_bill", (RiskControlRecordConstant.ExecuteActionEnum)executeAction, (AbstractFormPlugin)this, (String)callbackKey);
            if (antiReplayControlFlag) {
                evt.setCancel(true);
                return;
            }
        }
        if (!BTN_SUBMIT.equals(evt.getItemKey())) {
            return;
        }
        switch (itemKey) {
            case "addrow": {
                break;
            }
            case "edittax": {
                this.setItemTaxEnable(true);
                break;
            }
            case "btn_submit": {
                this.submitRedConfirm(evt);
            }
        }
    }

    private void setItemTaxEnable(boolean editAble) {
        DynamicObjectCollection itemList = this.getModel().getEntryEntity("items");
        for (int i = 0; i < itemList.size(); ++i) {
            this.getView().setEnable(Boolean.valueOf(editAble), i, new String[]{"tax"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("items");
        int[] rows = entryGrid.getSelectRows();
        int editIndex = 0;
        if (rows.length > 0) {
            editIndex = rows[0];
        }
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        switch (name) {
            case "num": {
                RedConfirmBillAddControl.editNum((AbstractFormPlugin)this, (int)editIndex, (BigDecimal)((BigDecimal)newValue), (BigDecimal)((BigDecimal)oldValue));
                break;
            }
            case "amount": {
                RedConfirmBillAddControl.editAmount((AbstractFormPlugin)this, (int)editIndex, (BigDecimal)((BigDecimal)newValue), (BigDecimal)((BigDecimal)oldValue));
                break;
            }
            case "unitprice": {
                RedConfirmBillAddControl.editUnitPrice((AbstractFormPlugin)this, (int)editIndex, (BigDecimal)((BigDecimal)newValue), (BigDecimal)((BigDecimal)oldValue));
                break;
            }
            case "taxunitprice": {
                RedConfirmBillAddControl.editTaxUnitPrice((AbstractFormPlugin)this, (int)editIndex, (BigDecimal)((BigDecimal)newValue), (BigDecimal)((BigDecimal)oldValue));
                break;
            }
            case "taxamount": {
                RedConfirmBillAddControl.editTaxAmount((AbstractFormPlugin)this, (int)editIndex, (BigDecimal)((BigDecimal)newValue), (BigDecimal)((BigDecimal)oldValue));
                break;
            }
            case "tax": {
                this.editTax(editIndex, (BigDecimal)newValue, (BigDecimal)oldValue);
                break;
            }
            case "taxrate": {
                RedConfirmBillAddControl.editTaxRate((AbstractFormPlugin)this, (int)editIndex, (String)((String)newValue));
                break;
            }
            case "invoicetype": {
                this.getModel().setValue("originalinvoicetype", newValue);
                if (InvoiceUtils.isPaperInvoice((String)((String)newValue))) {
                    this.getModel().setValue("iselepaper", (Object)"1");
                } else {
                    this.getModel().setValue("iselepaper", (Object)"0");
                }
            }
            case "redreason": {
                Object redReason = this.getModel().getValue("redreason");
                String remainRedAmount = this.getPageCache().get("remainRedAmount");
                String taxedtype = this.getPageCache().get("taxedtype");
                Object invoiceamount = this.getModel().getValue("invoiceamount");
                if (RedConfirmBillRedReasonEnum.INVOICE_ERR.getCode().equals(redReason) && StringUtils.isNotEmpty((CharSequence)remainRedAmount) && new BigDecimal(invoiceamount.toString()).compareTo(new BigDecimal(remainRedAmount).negate()) != 0) {
                    this.getView().getModel().setValue("redreason", oldValue);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u53f7\u7801\u5df2\u8fdb\u884c\u90e8\u5206\u7ea2\u51b2\uff0c\u4e0d\u652f\u6301\u7ea2\u51b2\u539f\u56e0\u4e3a\u3010\u5f00\u7968\u6709\u8bef\u3011\uff01", (String)"RedConfirmBillAddDialogPlugin_12", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (RedConfirmBillRedReasonEnum.SALES_RETURN.getCode().equals(redReason) && TaxedTypeEnum.all_e_reduced_tax.getValue().equals(taxedtype)) {
                    this.getView().getModel().setValue("redreason", oldValue);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u53f7\u7801\u5f81\u7a0e\u65b9\u5f0f\u4e3a\u51cf\u6309\u8ba1\u5f81\uff0c\u4e0d\u652f\u6301\u7ea2\u51b2\u539f\u56e0\u4e3a\u3010\u9500\u8d27\u9000\u56de\u3011\uff01", (String)"RedConfirmBillAddDialogPlugin_22", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.readReasonShowView();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void editTax(int editIndex, BigDecimal newTax, BigDecimal oldTax) {
        this.getModel().beginInit();
        try {
            if (BigDecimalUtil.greaterZero((BigDecimal)newTax)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u660e\u7ec6\u7a0e\u989d\u4e0d\u80fd\u5927\u4e8e0", (String)"RedConfirmBillAddPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                this.getModel().setValue("tax", (Object)oldTax, editIndex);
                return;
            }
            BigDecimal itemTaxAmount = (BigDecimal)this.getModel().getValue("taxamount", editIndex);
            if (itemTaxAmount.abs().compareTo(newTax.abs()) < 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u660e\u7ec6\u7a0e\u989d\u7edd\u5bf9\u503c\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u91d1\u989d\u7edd\u5bf9\u503c", (String)"RedConfirmBillAddPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                this.getModel().setValue("tax", (Object)oldTax, editIndex);
                return;
            }
            BigDecimal itemAmount = itemTaxAmount.subtract(newTax);
            this.getModel().setValue("amount", (Object)itemAmount, editIndex);
        }
        finally {
            this.getModel().endInit();
        }
        RedConfirmBillAddControl.updateField((AbstractFormPlugin)this, (int)editIndex, null);
        RedConfirmBillAddControl.countHeadAmount((AbstractFormPlugin)this);
    }

    private void submitRedConfirm(BeforeItemClickEvent evt) {
        String taxNo;
        this.getPageCache().put("save", "save");
        OperationResult operationResult = this.getView().invokeOperation("save", OperateOption.create());
        this.getPageCache().remove("save");
        if (!operationResult.isSuccess()) {
            this.getView().showErrorNotification(OperationConstant.getErrorMsg((OperationResult)operationResult));
            evt.setCancel(true);
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        if ("2".equals(this.getModel().getValue("applicant"))) {
            taxNo = (String)this.getModel().getValue("salertaxno");
            if ("02".equals(this.getModel().getValue("specialtype"))) {
                taxNo = (String)this.getModel().getValue("buyertaxno");
            }
        } else {
            taxNo = (String)this.getModel().getValue("buyertaxno");
        }
        params.put("salertaxno", taxNo);
        params.put("account", this.getModel().getValue("account"));
        if (AllEleServiceHelper.isNeedLogin((AbstractFormPlugin)this, params)) {
            evt.setCancel(true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("save".equals(operateKey)) {
            DynamicObject dynamicObject = this.getModel().getDataEntity();
            String billNo = dynamicObject.getString("orderno");
            DynamicObjectCollection itemObjectCollection = dynamicObject.getDynamicObjectCollection("items");
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("travelers");
            try {
                InvoiceOriginalFormControl.dealCheckTravelerItemMethod((String)billNo, (DynamicObjectCollection)itemObjectCollection, (DynamicObjectCollection)dynamicObjectCollection);
                InvoiceOriginalFormControl.dealCheckTransportTypeMethod((DynamicObjectCollection)dynamicObjectCollection);
            }
            catch (Exception e) {
                throw new KDBizException(e.getMessage());
            }
            String remark = dynamicObject.getString("remark");
            long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)dynamicObject.get("org"));
            if (String.valueOf(remark).length() <= 450) return;
            if (!InvoiceUtils.isCutRemark((Long)orgId)) throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\uff0c\u539f\u84dd\u7968\u53f7\u7801[%2$s]\u7684\u7ea2\u5b57\u786e\u8ba4\u5355\u5907\u6ce8\u8d85\u957f", (String)"RedConfirmBillSaveValidator_26", (String)"imc-sim-formplugin", (Object[])new Object[0]), dynamicObject.getString("billno"), dynamicObject.getString("originalinvoiceno")));
            dynamicObject.set("remark", (Object)InvoiceUtils.cutRemarkChar((String)remark, (int)450));
            return;
        }
        if ("btn_red".equals(operateKey)) {
            operate.getOption().setVariableValue("org", String.valueOf(DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("createorg"))));
            return;
        } else {
            if (!"deleteentry".equals(operateKey)) return;
            this.clearCacheRedConfirmItem();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        switch (args.getOperateKey()) {
            case "btn_submit": {
                this.getView().invokeOperation("refresh");
                if (!args.getOperationResult().isSuccess()) break;
                this.setItemTaxEnable(false);
                break;
            }
            case "save": {
                if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get("save"))) {
                    args.getOperationResult().setShowMessage(false);
                } else {
                    this.getView().invokeOperation("refresh");
                }
                if (!args.getOperationResult().isSuccess()) break;
                this.setItemTaxEnable(false);
                break;
            }
            case "btn_red": {
                OperationResult operationResult = args.getOperationResult();
                operationResult.setShowMessage(false);
                if (!operationResult.isSuccess()) {
                    this.getView().showTipNotification(OperationConstant.getErrorMsg((OperationResult)operationResult));
                    return;
                }
                String message = operationResult.getMessage();
                JSONObject json = JSONObject.parseObject((String)message);
                json.put("operateKey", (Object)args.getOperateKey());
                json.put("pkIds", (Object)operationResult.getSuccessPkIds());
                if (json.containsKey((Object)"cancelOrRedArInvoiceBillPks")) {
                    this.getPageCache().put("cancelOrRedArInvoiceBillPks", json.toJSONString());
                    ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\u5df2\u786e\u8ba4\u5e94\u6536\uff0c\u7ea2\u51b2\u53d1\u7968\u5c06\u51b2\u9500\u5f00\u7968\u7533\u8bf7\u5355\u6240\u5173\u8054\u7684\u8d22\u52a1\u5e94\u6536\u5355\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"RedConfirmBillListPlugin_55", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"cancelOrRedArInvoice");
                    return;
                }
                new RedConfirmBillIssueControl().handlerRedConfirmIssue(this, json);
                break;
            }
            case "deleteentry": {
                RedConfirmBillAddControl.countHeadAmount((AbstractFormPlugin)this);
                break;
            }
            case "submit": 
            case "unsubmit": 
            case "audit": 
            case "unaudit": {
                Object uploadStatus = this.getModel().getValue("uploadstatus");
                this.dealSetBuyerNameFieldMethod(uploadStatus);
                break;
            }
            case "addrow": {
                this.addRedConfirmRows();
            }
        }
    }

    private void clearCacheRedConfirmItem() {
        int[] selectRows;
        String blueInvoiceItemStr = this.getPageCache().get("blueInvoiceItems");
        if (StringUtils.isBlank((CharSequence)blueInvoiceItemStr)) {
            return;
        }
        JSONObject blueInvoiceItems = JSONObject.parseObject((String)blueInvoiceItemStr);
        IDataModel model = this.getModel();
        EntryGrid entry = (EntryGrid)this.getControl("items");
        for (int selectRow : selectRows = entry.getSelectRows()) {
            Object originalSeq = model.getValue("originseq", selectRow);
            blueInvoiceItems.remove((Object)String.valueOf(originalSeq));
        }
        this.getPageCache().put("blueInvoiceItems", blueInvoiceItems.toJSONString());
    }

    private void addRedConfirmRows() {
        String invoiceCode = (String)this.getModel().getValue("originalinvoicecode");
        String invoiceNo = (String)this.getModel().getValue("originalinvoiceno");
        if (StringUtils.isBlank((CharSequence)invoiceNo)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u539f\u84dd\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RedConfirmBillAddPlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject redConfirm = this.getModel().getDataEntity(true);
        DynamicObjectCollection redConfirmItems = redConfirm.getDynamicObjectCollection("items");
        HashSet<Object> oriItemIdSet = new HashSet<Object>(redConfirmItems.size());
        for (DynamicObject redConfirmItem : redConfirmItems) {
            Object oriItemId = redConfirmItem.get("originalinvoiceitemid");
            if (oriItemId == null) continue;
            oriItemIdSet.add(oriItemId);
        }
        DynamicObject invoice = QueryServiceHelper.queryOne((String)"sim_vatinvoice", (String)"id", (QFilter[])InvoiceQueryUtil.getInvoiceByCodeAndNo((String)invoiceCode, (String)invoiceNo).toArray());
        if (invoice == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9500\u9879\u7968\u6c60\u672a\u627e\u5230\u5bf9\u5e94\u539f\u84dd\u7968\u4fe1\u606f\u3002", (String)"RedConfirmBillAddPlugin_7", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter qFilter = new QFilter("invoiceid", "=", invoice.get("id"));
        if (!oriItemIdSet.isEmpty()) {
            qFilter.and("id", "not in", oriItemIdSet);
        }
        qFilter.and("rowtype", "!=", (Object)"1").and("amount", ">", (Object)BigDecimal.ZERO).and("itemremainredamount", ">", (Object)BigDecimal.ZERO);
        if (!QueryServiceHelper.exists((String)"sim_vatinvoice_item", (QFilter[])qFilter.toArray())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u53ef\u7ea2\u51b2\u660e\u7ec6\u3002", (String)"RedConfirmBillAddPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>(1);
        customParams.put("invoiceId", invoice.get("id"));
        ViewUtil.openListPage((AbstractFormPlugin)this, (QFilter)qFilter, (String)"sim_vatinvoice_item", (String)"sim_vatinvoice_item", (boolean)true, (boolean)true, null, customParams, null);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("bdm_tax_login".equals(closedCallBackEvent.getActionId()) && closedCallBackEvent.getReturnData() != null) {
            this.getView().invokeOperation(BTN_SUBMIT);
        }
        if ("sim_red_confirmbill_issue".equals(closedCallBackEvent.getActionId())) {
            this.getView().invokeOperation("refresh");
        }
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        if ("sim_red_coinfirm_account".equals(closedCallBackEvent.getActionId())) {
            JSONObject json = (JSONObject)closedCallBackEvent.getReturnData();
            new RedConfirmBillIssueControl().executeBatchRed(this, json);
        }
        if ("sim_vatinvoice_item".equals(closedCallBackEvent.getActionId())) {
            ListSelectedRowCollection itemIds = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            this.fillinItemByOriItems(itemIds);
        }
    }

    private void fillinItemByOriItems(ListSelectedRowCollection itemIds) {
        Object[] primaryKeyValues = itemIds.getPrimaryKeyValues();
        DynamicObject[] items = BusinessDataServiceHelper.load((String)"sim_vatinvoice_item", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice_item"), (QFilter[])new QFilter("id", "in", (Object)primaryKeyValues).toArray(), (String)"rowno");
        IDataModel model = this.getModel();
        model.beginInit();
        BigDecimal invoiceAmount = (BigDecimal)model.getValue("invoiceamount");
        BigDecimal totalTax = (BigDecimal)model.getValue("totaltax");
        BigDecimal totalAmount = (BigDecimal)model.getValue("totalamount");
        boolean startZero = RedConfirmBillHelper.checkOriginalInvoiceStartZero((String)((String)model.getValue("originalinvoicecode")), (String)((String)model.getValue("originalinvoiceno")));
        int[] indexArr = model.batchCreateNewEntryRow("items", items.length);
        for (int i = 0; i < items.length; ++i) {
            DynamicObject item = items[i];
            int index = indexArr[i];
            model.setValue("originseq", (Object)(startZero ? item.getInt("rowno") + 1 : item.getInt("rowno")), index);
            model.setValue("goodsname", item.get("goodsname"), index);
            model.setValue("specification", item.get("specification"), index);
            model.setValue("unit", item.get("unit"), index);
            model.setValue("taxrate", item.get("taxrate"), index);
            model.setValue("goodscode", item.get("goodscode"), index);
            model.setValue("rowtype", (Object)"0", index);
            model.setValue("billsourceid", item.get("billsourceid"), index);
            model.setValue("originalinvoiceitemid", item.get("id"), index);
            model.setValue("taxpremark", item.get("taxpremark"), index);
            model.setValue("zzstsgl", item.get("zzstsgl"), index);
            model.setValue("amount", (Object)item.getBigDecimal("itemremainredamount").negate(), index);
            model.setValue("tax", (Object)item.getBigDecimal("itemremainredtax").negate(), index);
            BigDecimal taxAmount = item.getBigDecimal("itemremainredamount").add(item.getBigDecimal("itemremainredtax")).negate();
            model.setValue("taxamount", (Object)taxAmount, index);
            invoiceAmount = invoiceAmount.add(item.getBigDecimal("itemremainredamount").negate());
            totalTax = totalTax.add(item.getBigDecimal("itemremainredtax").negate());
            totalAmount = totalAmount.add(taxAmount);
            if (RedConfirmBillRedReasonEnum.SALES_DISCOUNTS.getCode().equals(model.getValue("redreason")) || MathUtils.isNullOrZero((BigDecimal)item.getBigDecimal("unitprice"))) continue;
            model.setValue("num", (Object)item.getBigDecimal("itemremainrednum").negate(), index);
            if (item.getBigDecimal("itemremainredamount").compareTo(item.getBigDecimal("amount")) == 0) {
                model.setValue("unitprice", (Object)item.getBigDecimal("unitprice"), index);
                model.setValue("taxunitprice", (Object)item.getBigDecimal("taxunitprice"), index);
                continue;
            }
            if (MathUtils.isNullOrZero((BigDecimal)item.getBigDecimal("redprice"))) {
                model.setValue("unitprice", (Object)item.getBigDecimal("itemremainredamount").divide(item.getBigDecimal("itemremainrednum"), 13, 4), index);
            } else {
                model.setValue("unitprice", (Object)item.getBigDecimal("redprice"), index);
            }
            model.setValue("taxunitprice", (Object)taxAmount.divide(item.getBigDecimal("itemremainrednum"), 13, 4), index);
        }
        model.setValue("invoiceamount", (Object)invoiceAmount);
        model.setValue("totaltax", (Object)totalTax);
        model.setValue("totalamount", (Object)totalAmount);
        model.endInit();
        IFormView view = this.getView();
        view.updateView("items");
        view.updateView("invoiceamount");
        view.updateView("totaltax");
        view.updateView("totalamount");
        this.cacheRedConfirmItems();
        this.readReasonShowView();
    }

    public void afterF7Select(AfterF7SelectEvent event) {
        String key = ((Control)event.getSource()).getKey();
        EntryGrid grid = (EntryGrid)this.getControl("items");
        int[] rows = grid.getSelectRows();
        if (rows.length < 1) {
            return;
        }
        int selectRow = grid.getSelectRows()[0];
        switch (key) {
            case "goodsid": {
                RedConfirmBillAddControl.editGoodsId((AbstractFormPlugin)this, (AfterF7SelectEvent)event, (int)selectRow);
                break;
            }
            case "taxratecodeid": {
                DynamicObject taxCode = (DynamicObject)this.getModel().getValue("taxratecodeid", selectRow);
                this.getModel().setValue("goodscode", taxCode.get("mergecode"), selectRow);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = ((Control)e.getSource()).getKey();
        if ("goodsid".equals(key) && StringUtils.isBlank((CharSequence)((String)this.getModel().getValue("hsbz")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u542b\u7a0e\u6807\u5fd7", (String)"RedConfirmBillAddPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (MessageBoxResult.Cancel.equals((Object)messageBoxClosedEvent.getResult())) {
            return;
        }
        String callBackId = StringUtils.defaultString((String)messageBoxClosedEvent.getCallBackId());
        if (callBackId.startsWith("risk_control_check_")) {
            String key = callBackId.substring(callBackId.indexOf("risk_control_check_") + "risk_control_check_".length());
            BillRiskControlService.unlockRiskRecord((AbstractFormPlugin)this);
            BeforeItemClickEvent evt = new BeforeItemClickEvent(new Object(), key, key);
            this.beforeItemClick(evt);
            if (!evt.isCancel()) {
                this.getView().invokeOperation(key);
            }
        } else if ("cancelOrRedArInvoice".equals(callBackId)) {
            new RedConfirmBillIssueControl().handlerRedConfirmIssue(this, JSONObject.parseObject((String)this.getPageCache().get("cancelOrRedArInvoiceBillPks")));
        }
    }

    private void readReasonShowView() {
        Object redReason = this.getModel().getValue("redreason");
        String[] disableKey = ITEM_DISABLE_KEY;
        if (RedConfirmBillRedReasonEnum.SALES_RETURN.getCode().equals(redReason)) {
            disableKey = new String[]{"taxamount", "amount"};
        } else if (RedConfirmBillRedReasonEnum.SERVICE_CUT.getCode().equals(redReason)) {
            disableKey = null;
        } else if (RedConfirmBillRedReasonEnum.SALES_DISCOUNTS.getCode().equals(redReason)) {
            disableKey = new String[]{"num"};
        }
        String taxedtype = this.getPageCache().get("taxedtype");
        if (TaxedTypeEnum.all_e_deduction.getValue().equals(taxedtype) || TaxedTypeEnum.all_e_deduction_full.getValue().equals(taxedtype)) {
            disableKey = ITEM_DISABLE_KEY;
            this.getView().setEnable(Boolean.FALSE, new String[]{"deleterow"});
        }
        this.setItemValueAndDisable(disableKey);
    }
}

