/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.redconfirm;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.sim.common.dto.allele.redconfirm.AllEleRedConfirmDownLoadRequestDTO;
import kd.imc.sim.formplugin.bill.originalbill.util.SelectDeviceUtil;

public class RedConfirmBillDownloadPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        Date today = new Date();
        this.getModel().setValue("applytime_start", (Object)DateUtils.getFirstDateOfMonth((Date)today));
        this.getModel().setValue("applytime_end", (Object)today);
        this.getModel().setValue("org", this.getView().getFormShowParameter().getCustomParam("org"));
        this.setRpaAccount();
    }

    private void setRpaAccount() {
        try {
            SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("org")));
            SelectDeviceUtil.setAccount((AbstractFormPlugin)this, (String)saleInfo.getSaleTaxNo(), (String)"");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("org".equals(e.getProperty().getName())) {
            this.setRpaAccount();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void beforeClick(BeforeClickEvent evt) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        try {
            long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("org"));
            PermissionHelper.checkPermission((String)"sim", (String)"sim_red_confirm_bill", (long)orgId, (ImcPermItemEnum)ImcPermItemEnum.ITEM_DOWNLOAD);
            SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)orgId);
            params.put("salertaxno", saleInfo.getSaleTaxNo());
            params.put("account", this.getModel().getValue("account"));
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
            evt.setCancel(true);
            return;
        }
        if (AllEleServiceHelper.isNeedLogin((AbstractFormPlugin)this, params)) {
            evt.setCancel(true);
        }
    }

    public void click(EventObject evt) {
        this.downloadRedConfirmBill();
    }

    private void downloadRedConfirmBill() {
        AllEleRedConfirmDownLoadRequestDTO request = new AllEleRedConfirmDownLoadRequestDTO();
        request.setAccount((String)this.getModel().getValue("account"));
        request.setIdentity((String)this.getModel().getValue("applicantfw"));
        request.setStartDate(DateUtils.format((Date)((Date)this.getModel().getValue("applytime_start"))));
        request.setEndDate(DateUtils.format((Date)((Date)this.getModel().getValue("applytime_end"))));
        request.setOrgId(DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("org")));
        request.setOtherSideName((String)this.getModel().getValue("otherSideName"));
        request.setUpdateHead((Boolean)this.getView().getFormShowParameter().getCustomParam("updateHead"));
        request.setOriginalInvoiceCode((String)this.getModel().getValue("originalinvoicecode"));
        request.setOriginalInvoiceNo((String)this.getModel().getValue("originalinvoiceno"));
        request.setRedConfirmBillNo((String)this.getModel().getValue("redconfirmbillno"));
        this.getView().returnDataToParent((Object)request);
        this.getView().close();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        if ("bdm_tax_login".equals(closedCallBackEvent.getActionId())) {
            this.downloadRedConfirmBill();
        }
    }
}

