/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.redconfirm.op;

import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.sim.formplugin.redconfirm.op.validator.RedConfirmBillItemSaveValidator;
import kd.imc.sim.formplugin.redconfirm.op.validator.RedConfirmBillSaveValidator;
import org.apache.commons.lang3.StringUtils;

public class RedConfirmBillSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("remark");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("buyeremail");
        e.getFieldKeys().add("buyerphone");
        e.getFieldKeys().add("uploadstatus");
        e.getFieldKeys().add("originalinvoiceno");
        e.getFieldKeys().add("buyername");
        e.getFieldKeys().add("salername");
        e.getFieldKeys().add("items.goodsname");
        e.getFieldKeys().add("items.specification");
        e.getFieldKeys().add("items.unit");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new RedConfirmBillSaveValidator());
        e.addValidator((AbstractValidator)new RedConfirmBillItemSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] redConfirms;
        boolean clearBlank = "1".equals(ImcConfigUtil.getValue((String)"sim_red_confirm_bill", (String)"clear_blank"));
        HashMap<Long, Boolean> orgConfig = new HashMap<Long, Boolean>();
        for (DynamicObject redConfirm : redConfirms = e.getDataEntities()) {
            String remark = redConfirm.getString("remark");
            if (String.valueOf(remark).length() > 450) {
                long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)redConfirm.get("org"));
                Boolean isCutStr = (Boolean)orgConfig.get(orgId);
                if (null == isCutStr) {
                    isCutStr = InvoiceUtils.isCutRemark((Long)orgId);
                    orgConfig.put(orgId, isCutStr);
                }
                if (isCutStr.booleanValue()) {
                    redConfirm.set("remark", (Object)InvoiceUtils.cutRemarkChar((String)remark, (int)450));
                } else {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\uff0c\u539f\u84dd\u7968\u53f7\u7801[%2$s]\u7684\u7ea2\u5b57\u786e\u8ba4\u5355\u5907\u6ce8\u8d85\u957f", (String)"RedConfirmBillSaveValidator_26", (String)"imc-sim-formplugin", (Object[])new Object[0]), redConfirm.getString("billno"), redConfirm.getString("originalinvoiceno")));
                }
            }
            if (!clearBlank) continue;
            boolean isAllERpa = true;
            String originalInvoiceNo = redConfirm.getString("originalinvoiceno");
            if (StringUtils.isNotBlank((CharSequence)originalInvoiceNo) && originalInvoiceNo.length() == 20 && '7' == originalInvoiceNo.charAt(4)) {
                isAllERpa = false;
            }
            if (!isAllERpa && !"1".equals(ImcConfigUtil.getValue((String)"sim_red_confirm_bill", (String)"force_clear_blank"))) continue;
            this.replaceBlank(redConfirm, "buyername");
            this.replaceBlank(redConfirm, "salername");
            if (!DynamicObjectUtil.checkDynamicObjectHasField((DynamicObject)redConfirm, (String)"items")) continue;
            DynamicObjectCollection items = redConfirm.getDynamicObjectCollection("items");
            for (DynamicObject item : items) {
                this.replaceGoodsName(item);
                this.replaceBlank(item, "specification");
                this.replaceBlank(item, "unit");
            }
        }
    }

    private void replaceGoodsName(DynamicObject item) {
        if (!DynamicObjectUtil.checkDynamicObjectHasField((DynamicObject)item, (String)"goodsname")) {
            return;
        }
        String goodsName = item.getString("goodsname");
        if (StringUtils.isBlank((CharSequence)goodsName)) {
            return;
        }
        String xmmc = goodsName.replaceAll("^\\*[A-Za-z0-9\u3001\\u4E00-\\u9FA5]+\\*", "");
        String simpleGoodsName = goodsName.replace(xmmc, "");
        item.set("goodsname", (Object)(simpleGoodsName + xmmc.trim()));
    }

    private void replaceBlank(DynamicObject item, String key) {
        String val;
        if (DynamicObjectUtil.checkDynamicObjectHasField((DynamicObject)item, (String)key) && (val = item.getString(key)) != null) {
            item.set(key, (Object)val.trim());
        }
    }
}

