/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.redconfirm.op;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.bdm.common.constant.allele.AllEleInterfaceTypeEnum;
import kd.imc.bdm.common.dto.allele.AllEleRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseDTO;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.lqpt.model.request.LqptRequest;
import kd.imc.bdm.lqpt.model.request.base.redconfirmapply.RedConfirmBillApplyRequest;
import kd.imc.bdm.lqpt.model.response.LqptResponse;
import kd.imc.bdm.lqpt.model.response.base.redconfirmapply.RedConfirmBillApplyResponse;
import kd.imc.bdm.lqpt.service.LqptService;
import kd.imc.sim.async.LqCombineRedConfirmQueryImpl;
import kd.imc.sim.common.constant.InvoiceConstant;
import kd.imc.sim.common.constant.RedConfirmBillRedReasonEnum;
import kd.imc.sim.common.constant.RedConfirmStatusEnum;
import kd.imc.sim.common.dto.allele.AllEleRedConfirmBillUploadResponseDTO;
import kd.imc.sim.common.dto.allele.issue.AllEleIssueRequestDTO;
import kd.imc.sim.common.helper.RedInfoHelper;
import kd.imc.sim.common.helper.issueinvoice.UnitPriceHelper;
import kd.imc.sim.common.service.issueinvoice.impl.AllEleIssueInvoiceImpl;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.match.MinusBillMatchHelper;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillHelper;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillMailHelper;
import org.apache.commons.collections.CollectionUtils;

public class RedConfirmBillUploadOp
extends AbstractOperationServicePlugIn {
    private static final Log LOG = LogFactory.getLog(RedConfirmBillUploadOp.class);
    private static ThreadLocal<Map<Object, DLock>> lockListLocal = new ThreadLocal();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().addAll(PropertieUtil.addFieldKey((String)"sim_red_confirm_bill", (boolean)true));
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] redConfirmArr = e.getDataEntities();
        HashMap<Object, DLock> lockMap = new HashMap<Object, DLock>(redConfirmArr.length);
        for (DynamicObject redConfirm : redConfirmArr) {
            DLock lock = DLock.create((String)(redConfirm.getPkValue() + "redConfirmUpload"));
            lockMap.put(redConfirm.getPkValue(), lock);
        }
        lockListLocal.set(lockMap);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<DynamicObject> successObj = new ArrayList<DynamicObject>(dataEntities.length);
        HashSet<String> redConfirmBillNoSet = new HashSet<String>(1);
        String account = this.getOption().containsVariable("account") ? this.getOption().getVariableValue("account") : "";
        Map<Object, DLock> lockMap = lockListLocal.get();
        for (DynamicObject redConfirmBill : dataEntities) {
            String taxNo;
            DynamicObject redConfirmBillDb;
            DLock dLock = lockMap.get(redConfirmBill.getPkValue());
            if (dLock != null && !dLock.tryLock() || "1".equals((redConfirmBillDb = QueryServiceHelper.queryOne((String)"sim_red_confirm_bill", (String)String.join((CharSequence)",", "uploadstatus", "confirmstatus"), (QFilter[])new QFilter("id", "=", redConfirmBill.getPkValue()).toArray())).getString("uploadstatus")) && RedConfirmStatusEnum.isQuickRedByNumber((String)redConfirmBillDb.getString("confirmstatus"))) continue;
            if ("2".equals(redConfirmBill.getString("applicant"))) {
                taxNo = redConfirmBill.getString("salertaxno");
                if ("02".equals(redConfirmBill.getString("specialtype"))) {
                    taxNo = redConfirmBill.getString("buyertaxno");
                }
            } else {
                taxNo = redConfirmBill.getString("buyertaxno");
            }
            if (EnterpriseHelper.isLqptChannel((String)taxNo)) {
                this.redConfirmUploadLq(redConfirmBill, taxNo, successObj);
                continue;
            }
            AllEleIssueRequestDTO allEleIssueRequestDTO = AllEleIssueInvoiceImpl.buildIssueInvoide((DynamicObject)redConfirmBill);
            if (StringUtils.isNotBlank((CharSequence)account)) {
                allEleIssueRequestDTO.setAccount(account);
            }
            allEleIssueRequestDTO.setRequest_path(AllEleInterfaceTypeEnum.RED_CONFIRM_BILL_APPLY.getRequestPath());
            boolean isLeqiCombine = EnterpriseHelper.isLeqiCombineChannel((String)taxNo);
            if (!isLeqiCombine) {
                AllEleResponseDTO response = AllEleServiceHelper.doPost((String)taxNo, (AllEleRequestDTO)allEleIssueRequestDTO, AllEleRedConfirmBillUploadResponseDTO.class);
                if (response.getSuccess().booleanValue()) {
                    AllEleRedConfirmBillUploadResponseDTO uploadResponse = (AllEleRedConfirmBillUploadResponseDTO)response.getData();
                    if (StringUtils.isBlank((CharSequence)uploadResponse.getGovRedConfirmBillUuid()) && StringUtils.isNotBlank((CharSequence)uploadResponse.getRedConfirmBillNo()) && uploadResponse.getRedConfirmBillNo().length() == 16) {
                        if (!"1".equals(redConfirmBill.getString("source")) && !"4".equals(redConfirmBill.getString("source"))) {
                            redConfirmBill.set("uploadstatus", (Object)"2");
                            redConfirmBill.set("failreason", (Object)"\u8be5\u84dd\u7968\u5b58\u5728\u7ea2\u5b57\u4fe1\u606f\u8868");
                        } else if (!redConfirmBillNoSet.contains(uploadResponse.getRedConfirmBillNo())) {
                            redConfirmBillNoSet.add(uploadResponse.getRedConfirmBillNo());
                            RedInfoHelper.convertRedConfirmBillToRedInfo((DynamicObject)redConfirmBill, (AllEleRedConfirmBillUploadResponseDTO)uploadResponse);
                            DeleteServiceHelper.delete((IDataEntityType)redConfirmBill.getDataEntityType(), (Object[])new Object[]{redConfirmBill.getPkValue()});
                        }
                        this.operationResult.addErrorInfo((OperateErrorInfo)RedInfoHelper.buildValidationErrorInfo((DynamicObject)redConfirmBill, (String)String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7%1$s\u4e0a\u4f20\u8fd4\u56de\u7ea2\u5b57\u4fe1\u606f\u8868\u7f16\u53f7:%2$s\uff0c\u8bf7\u8fdb\u5165\u7ea2\u5b57\u4fe1\u606f\u8868\u9875\u9762\u67e5\u770b", (String)"RedConfirmBillUploadOp_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), redConfirmBill.getString("orderno"), uploadResponse.getRedConfirmBillNo())));
                        continue;
                    }
                    redConfirmBill.set("uploadstatus", (Object)"1");
                    redConfirmBill.set("uploaddate", (Object)DateUtils.stringToDate((String)uploadResponse.getRedConfirmEnterDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                    redConfirmBill.set("govuuid", (Object)uploadResponse.getGovRedConfirmBillUuid());
                    redConfirmBill.set("number", (Object)uploadResponse.getRedConfirmBillNo());
                    redConfirmBill.set("confirmstatus", (Object)uploadResponse.getRedConfirmBillStatus());
                    redConfirmBill.set("failreason", (Object)"");
                    if ("0".equals(redConfirmBill.getString("enteridentity")) && (RedConfirmStatusEnum.NO_CONFIRM.getBillCode().equals(redConfirmBill.getString("confirmstatus")) || RedConfirmStatusEnum.BUYER_CONFIRM.getBillCode().equals(redConfirmBill.getString("confirmstatus")))) {
                        redConfirmBill.set("account", (Object)allEleIssueRequestDTO.getAccount());
                        if (StringUtils.isNotBlank((CharSequence)allEleIssueRequestDTO.getAccount())) {
                            redConfirmBill.set("drawer", (Object)AllEleAuthHelper.getDrawerByAccount((String)allEleIssueRequestDTO.getSalerTaxNo(), (String)allEleIssueRequestDTO.getAccount()));
                        }
                    }
                    successObj.add(redConfirmBill);
                    continue;
                }
                if (response.getErrcode().equals("1304")) {
                    redConfirmBill.set("uploadstatus", (Object)"3");
                    DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_red_comfirm_bill_temp");
                    dynamicObject.set("orderno", (Object)redConfirmBill.getString("orderno"));
                    dynamicObject.set("operate", (Object)"0");
                    dynamicObject.set("createdate", (Object)new Date());
                    dynamicObject.set("redid", redConfirmBill.get("id"));
                    ImcSaveServiceHelper.save((DynamicObject)dynamicObject);
                    continue;
                }
                redConfirmBill.set("uploadstatus", (Object)"2");
                RedConfirmBillHelper.setFailReason((DynamicObject)redConfirmBill, (String)response.getDescription());
                this.operationResult.addErrorInfo((OperateErrorInfo)RedInfoHelper.buildValidationErrorInfo((DynamicObject)redConfirmBill, (String)String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7%1$s\u4e0a\u4f20\u5931\u8d25\uff0c%2$s", (String)"RedConfirmBillUploadOp_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), redConfirmBill.getString("orderno"), response.getDescription())));
                continue;
            }
            QFilter orderNoFilter = new QFilter("orderno", "=", (Object)String.valueOf(redConfirmBill.getLong("id")));
            DynamicObject[] asyncLog = BusinessDataServiceHelper.load((String)"sim_async_issue_invoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_async_issue_invoice", (boolean)true), (QFilter[])orderNoFilter.toArray());
            DynamicObject asyncInvoice = null;
            if (asyncLog.length > 0) {
                asyncInvoice = asyncLog[0];
            }
            if (asyncInvoice == null) {
                AllEleResponseDTO response = AllEleServiceHelper.doPost((String)taxNo, (AllEleRequestDTO)allEleIssueRequestDTO, AllEleRedConfirmBillUploadResponseDTO.class);
                if (response.getSuccess().booleanValue()) {
                    AllEleRedConfirmBillUploadResponseDTO data = (AllEleRedConfirmBillUploadResponseDTO)response.getData();
                    redConfirmBill.set("uploadbatchno", (Object)data.getBatchNo());
                    asyncInvoice = BusinessDataServiceHelper.newDynamicObject((String)"sim_async_issue_invoice");
                    asyncInvoice.set("orderno", (Object)String.valueOf(redConfirmBill.getLong("id")));
                    asyncInvoice.set("salertaxno", (Object)redConfirmBill.getString("salertaxno"));
                    asyncInvoice.set("invoicetype", (Object)redConfirmBill.getString("invoicetype"));
                    asyncInvoice.set("createdate", (Object)new Date());
                    asyncInvoice.set("govorderno", (Object)((AllEleRedConfirmBillUploadResponseDTO)response.getData()).getBatchNo());
                    asyncInvoice.set("issuechannel", (Object)"leqi_redconfirm_query");
                    asyncInvoice.set("querycount", (Object)0);
                    asyncInvoice = (DynamicObject)ImcSaveServiceHelper.save((DynamicObject)asyncInvoice);
                    asyncInvoice = BusinessDataServiceHelper.load((String)"sim_async_issue_invoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_async_issue_invoice", (boolean)true), (QFilter[])new QFilter("id", "=", asyncInvoice.get("id")).toArray())[0];
                } else {
                    redConfirmBill.set("uploadstatus", (Object)"2");
                    RedConfirmBillHelper.setFailReason((DynamicObject)redConfirmBill, (String)response.getDescription());
                    this.operationResult.addErrorInfo((OperateErrorInfo)RedInfoHelper.buildValidationErrorInfo((DynamicObject)redConfirmBill, (String)String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7%1$s\u4e0a\u4f20\u5931\u8d25\uff0c%2$s", (String)"RedConfirmBillUploadOp_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), redConfirmBill.getString("orderno"), response.getDescription())));
                }
            }
            if (asyncInvoice == null) continue;
            AllEleResponseDTO queryResponse = new LqCombineRedConfirmQueryImpl().queryRedConfirmUploadResult(asyncInvoice, redConfirmBill);
            if (queryResponse.getSuccess().booleanValue()) {
                successObj.add(redConfirmBill);
                continue;
            }
            redConfirmBill.set("uploadstatus", (Object)"2");
            RedConfirmBillHelper.setFailReason((DynamicObject)redConfirmBill, (String)queryResponse.getDescription());
            this.operationResult.addErrorInfo((OperateErrorInfo)RedInfoHelper.buildValidationErrorInfo((DynamicObject)redConfirmBill, (String)String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7%1$s\u4e0a\u4f20\u5931\u8d25\uff0c%2$s", (String)"RedConfirmBillUploadOp_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), redConfirmBill.getString("orderno"), queryResponse.getDescription())));
        }
        if ("1".equals(ImcConfigUtil.getValue((String)"sim_red_confirm_bill", (String)"upload_success"))) {
            e.setDataEntities(successObj.toArray(new DynamicObject[0]));
        }
        ImcSaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    private void redConfirmUploadLq(DynamicObject redConfirmBill, String taxNo, List<DynamicObject> successObj) {
        if ("1".equals(ImcConfigUtil.getValue((String)"sim_red_confirm_bill", (String)"recalc_price"))) {
            this.reCalcPrice(redConfirmBill);
        }
        RedConfirmBillApplyRequest request = (RedConfirmBillApplyRequest)DynamicObjectUtil.dynamicObject2Bean(RedConfirmBillApplyRequest.class, (DynamicObject)redConfirmBill);
        request.setNsrsbh(taxNo);
        RedConfirmBillHelper.buildRedConfirmApply((RedConfirmBillApplyRequest)request, (DynamicObject)redConfirmBill);
        LqptResponse response = new LqptService().send((LqptRequest)request);
        if (response.success()) {
            redConfirmBill.set("uploadstatus", (Object)"1");
            RedConfirmBillApplyResponse data = (RedConfirmBillApplyResponse)response.getData();
            redConfirmBill.set("uploaddate", (Object)new Date());
            redConfirmBill.set("govuuid", (Object)data.getUuid());
            redConfirmBill.set("number", (Object)data.getHzfpxxqrdbh());
            redConfirmBill.set("confirmstatus", (Object)data.getHzqrxxztDm());
            redConfirmBill.set("failreason", (Object)"");
            successObj.add(redConfirmBill);
        } else {
            redConfirmBill.set("uploadstatus", (Object)"2");
            RedConfirmBillHelper.setFailReason((DynamicObject)redConfirmBill, (String)response.getDescription());
            this.operationResult.addErrorInfo((OperateErrorInfo)RedInfoHelper.buildValidationErrorInfo((DynamicObject)redConfirmBill, (String)String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7%1$s\u4e0a\u4f20\u5931\u8d25\uff0c%2$s", (String)"RedConfirmBillUploadOp_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), redConfirmBill.getString("orderno"), response.getDescription())));
        }
    }

    private void reCalcPrice(DynamicObject redConfirmBill) {
        try {
            if (RedConfirmBillRedReasonEnum.SALES_DISCOUNTS.getCode().equals(redConfirmBill.getString("redreason"))) {
                return;
            }
            DynamicObjectCollection redConfirmItems = redConfirmBill.getDynamicObjectCollection("items");
            if (redConfirmItems.stream().allMatch(item -> DynamicObjectUtil.getDynamicObjectLongValue((Object)item.get("originalinvoiceitemid")) == 0L)) {
                return;
            }
            if (redConfirmItems.stream().allMatch(item -> MathUtils.isNullOrZero((BigDecimal)item.getBigDecimal("unitprice")))) {
                return;
            }
            String originalInvoiceCode = StringUtils.trimToEmpty((String)redConfirmBill.getString("originalinvoicecode"));
            String originalInvoiceNo = StringUtils.trimToEmpty((String)redConfirmBill.getString("originalinvoiceno"));
            if (StringUtils.isBlank((CharSequence)originalInvoiceNo)) {
                return;
            }
            DynamicObjectCollection invoiceItems = QueryServiceHelper.query((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "items.id as id", "items.unitprice as unitprice", "items.rowtype as rowtype"), (QFilter[])new QFilter("salertaxno", "=", (Object)redConfirmBill.getString("salertaxno")).and(InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)originalInvoiceCode, (String)originalInvoiceNo)).toArray());
            if (CollectionUtils.isEmpty((Collection)invoiceItems)) {
                return;
            }
            Map<Long, DynamicObject> itemId2ItemMap = invoiceItems.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v, (v1, v2) -> v1));
            DynamicObjectCollection redConfirms = QueryServiceHelper.query((String)"sim_red_confirm_bill", (String)"items.originalinvoiceitemid as originalinvoiceitemid", (QFilter[])new QFilter("originalinvoicecode", "=", (Object)originalInvoiceCode).and("originalinvoiceno", "=", (Object)originalInvoiceNo).and("redreason", "=", (Object)RedConfirmBillRedReasonEnum.SALES_DISCOUNTS.getCode()).and("issuestatus", "=", (Object)"0").and("id", "!=", redConfirmBill.getPkValue()).toArray());
            Set originalInvoiceItemId = redConfirms.stream().map(redConfirm -> redConfirm.getLong("originalinvoiceitemid")).collect(Collectors.toSet());
            for (DynamicObject redConfirmItem : redConfirmItems) {
                DynamicObject oriItem;
                Long oriItemId = redConfirmItem.getLong("originalinvoiceitemid");
                if (MathUtils.isNullOrZero((BigDecimal)redConfirmItem.getBigDecimal("unitprice"))) {
                    if (MathUtils.isNullOrZero((BigDecimal)redConfirmItem.getBigDecimal("taxunitprice")) || (oriItem = itemId2ItemMap.get(oriItemId)) == null) continue;
                    redConfirmItem.set("unitprice", (Object)oriItem.getBigDecimal("unitprice"));
                    redConfirmItem.set("num", (Object)UnitPriceHelper.calcNum((BigDecimal)redConfirmItem.getBigDecimal("amount"), (BigDecimal)redConfirmItem.getBigDecimal("unitprice")));
                    continue;
                }
                if (originalInvoiceItemId.contains(oriItemId) || (oriItem = itemId2ItemMap.get(oriItemId)) == null || "2".equals(oriItem.getString("rowtype")) || oriItem.getBigDecimal("unitprice").compareTo(redConfirmItem.getBigDecimal("unitprice")) == 0) continue;
                redConfirmItem.set("unitprice", (Object)oriItem.getBigDecimal("unitprice"));
                BigDecimal calcAmount = redConfirmItem.getBigDecimal("unitprice").multiply(redConfirmItem.getBigDecimal("num"));
                if (!BigDecimalUtil.compare((BigDecimal)calcAmount, (BigDecimal)redConfirmItem.getBigDecimal("amount"), (BigDecimal)InvoiceConstant.DIFF_01)) continue;
                redConfirmItem.set("num", (Object)UnitPriceHelper.calcNum((BigDecimal)redConfirmItem.getBigDecimal("amount"), (BigDecimal)redConfirmItem.getBigDecimal("unitprice")));
                redConfirmItem.set("taxunitprice", (Object)UnitPriceHelper.calcNum((BigDecimal)redConfirmItem.getBigDecimal("taxamount"), (BigDecimal)redConfirmItem.getBigDecimal("num")));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        new MinusBillMatchHelper().writebackMatchBillAndSetBillComprehensive(Arrays.stream(e.getDataEntities()).collect(Collectors.toList()));
        DynamicObject[] redConfirmList = (DynamicObject[])Arrays.stream(e.getDataEntities()).filter(redConfirm -> "1".equals(redConfirm.getString("uploadstatus"))).toArray(DynamicObject[]::new);
        Map<Object, DLock> lockMap = lockListLocal.get();
        for (DLock dLock : lockMap.values()) {
            dLock.unlock();
        }
        lockListLocal.remove();
        for (DynamicObject redConfirm2 : redConfirmList) {
            try {
                RedConfirmBillMailHelper.sendEmailImm((DynamicObject)redConfirm2);
            }
            catch (Exception ex) {
                LOG.error("\u53d1\u9001\u7ea2\u5b57\u786e\u8ba4\u5355\u90ae\u4ef6\u5931\u8d25" + redConfirm2.getString("number"), (Throwable)ex);
            }
        }
        RequestContext context = RequestContext.get();
        ThreadPools.executeOnceIncludeRequestContext((String)"assignRedConfirm", () -> {
            RequestContext.copyAndSet((RequestContext)context);
            RedConfirmBillHelper redConfirmBillHelper = new RedConfirmBillHelper();
            for (DynamicObject recConfirm : redConfirmList) {
                ArrayList<DynamicObject> redConfirms = new ArrayList<DynamicObject>(4);
                redConfirms.add(recConfirm);
                redConfirmBillHelper.assignRedConfirm(Long.valueOf(DynamicObjectUtil.getDynamicObjectLongValue((Object)recConfirm.get("org"))), recConfirm.getString("applicant"), redConfirms);
            }
        });
    }
}

