/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.redinfo;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.ComponentInterfaceTypeEnum;
import kd.imc.bdm.common.constant.EquipmentType;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.table.RedInfoConstant;
import kd.imc.bdm.common.dto.ComponentRequest;
import kd.imc.bdm.common.dto.ComponentResponse;
import kd.imc.bdm.common.dto.PaperInvoiceRollInfoDTO;
import kd.imc.bdm.common.enums.CancelRedEum;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.ComponentServiceHelper;
import kd.imc.bdm.common.helper.DrawerStrategyHelper;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.helper.invoice.RemarkTemplateHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.model.DrawerStrategyDTO;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.ConvertUpMoneyUtils;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.ModelUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.constant.BillConstant;
import kd.imc.sim.common.helper.RedInfoHelper;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.helper.issueinvoice.UnitPriceHelper;
import kd.imc.sim.common.model.invoice.IssueTypeEnum;
import kd.imc.sim.common.model.invoice.TaxedTypeEnum;
import kd.imc.sim.common.model.redinfo.RedInfoDTO;
import kd.imc.sim.common.service.InvoiceCheckService;
import kd.imc.sim.common.service.IssueInvoiceService;
import kd.imc.sim.formplugin.issuing.helper.IssueInvoiceHelper;
import kd.imc.sim.formplugin.redinfo.service.AbstractInitRedInfoService;
import kd.imc.sim.untrans.SimFormPluginConstellationUntrans;
import org.apache.commons.lang3.ObjectUtils;

public class RedInfoOpenInvoicePlugin
extends AbstractFormPlugin
implements SimFormPluginConstellationUntrans {
    protected static final Log log = LogFactory.getLog(AbstractInitRedInfoService.class);
    private static final String PRICE_NUM_CHANGE = "PRICE_NUM_CHANGE";
    private static final String MAIN_REMARK = "text_other_remark";
    private static final String PAGE_CACHE_WARP_DATA_DONT_CHANGE = "warpDataDontChange";

    public void afterCreateNewData(EventObject e) {
        String viewJQBH;
        Object pkValue = this.getView().getFormShowParameter().getCustomParam("id");
        DynamicObject redInfo = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"sim_red_info");
        if (redInfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\uff01", (String)"RedInfoOpenInvoicePlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        this.setSalerInfoAndPayeeIsNull(redInfo);
        this.setBuyerInfoIsNull(redInfo);
        ModelUtil.setModelAndEntryValueFromDynamicObject((DynamicObject)redInfo, (AbstractFormPlugin)this);
        BigDecimal totalAmount = redInfo.getBigDecimal("totalamount").setScale(2, 4);
        this.getModel().setValue("text_total_amount", (Object)("\uff08\u5927\u5199\uff09 " + ConvertUpMoneyUtils.toChinese((String)totalAmount.toString()) + " \uff08\u5c0f\u5199\uff09 " + totalAmount));
        this.getModel().setValue("text_invoice_date", (Object)DateUtils.format((Date)new Date()));
        this.getModel().setValue("text_invoice_remark", (Object)RemarkTemplateHelper.generateRedInfoRemark((DynamicObject)redInfo));
        this.setInvoiceName(redInfo.getString("salertaxno"), redInfo.getString("invoicetype"));
        this.getModel().setValue("jqbh", (Object)redInfo.getString("jqbh"));
        this.setEquipmentAndTerminaNo();
        if (EquipmentHelper.isDisableJQBH((Object)redInfo.getString("salertaxno"), (Object)this.getModel().getValue("jqbh"))) {
            this.getModel().setValue("jqbh", null);
        }
        if (!StringUtils.isEmpty((CharSequence)(viewJQBH = (String)this.getModel().getValue("jqbh")))) {
            this.getModel().setValue("terminalno", (Object)redInfo.getString("terminalno"));
        }
        this.setNextInvoiceCodeNo(redInfo.getString("invoicetype"));
        this.setTobacco(redInfo);
        this.setRemark(true);
        String drawer = (String)this.getModel().getValue("drawer");
        if (StringUtils.isBlank((CharSequence)drawer)) {
            this.getModel().setValue("drawer", (Object)RequestContext.get().getUserName());
        }
        this.getView().setVisible(this.isShowIssueContent(redInfo), new String[]{"issuecontent"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if ("btn_openinvoice".equals(evt.getItemKey())) {
            DynamicObjectCollection items = this.getModel().getEntryEntity("items");
            for (int i = 0; i < items.size(); ++i) {
                BigDecimal unitPrice = ((DynamicObject)items.get(i)).getBigDecimal("unitprice");
                BigDecimal number = ((DynamicObject)items.get(i)).getBigDecimal("num");
                if (unitPrice.compareTo(BigDecimal.ZERO) != 0) {
                    unitPrice = this.cutNum(unitPrice, 16);
                    this.getPageCache().put(PRICE_NUM_CHANGE, PRICE_NUM_CHANGE);
                    this.getModel().setValue("unitprice", (Object)unitPrice, i);
                }
                if (number.compareTo(BigDecimal.ZERO) == 0) continue;
                number = this.cutNum(number, 17);
                this.getPageCache().put(PRICE_NUM_CHANGE, PRICE_NUM_CHANGE);
                this.getModel().setValue("num", (Object)number, i);
            }
        }
    }

    public BigDecimal cutNum(BigDecimal bigDecimal, int length) {
        String[] strings;
        int num1;
        String numLong = String.valueOf(bigDecimal);
        if (numLong.length() > length && (num1 = (strings = numLong.split("\\."))[0].length()) < length) {
            return bigDecimal.setScale(length - num1 - 1, 1);
        }
        return bigDecimal;
    }

    public void setEquipmentAndTerminaNo() {
        long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("org"));
        SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)orgId);
        EquipmentUtil.initEquipmentAndTerminal((AbstractFormPlugin)this, (long)orgId, (String)saleInfo.getSaleTaxNo(), (String)"jqbh", (String)"terminalno", (boolean)true);
    }

    private Boolean isShowIssueContent(DynamicObject redInfo) {
        try {
            if (!"5".equals(redInfo.getString("infosource"))) {
                return Boolean.FALSE;
            }
            DynamicObject[] billRelations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)"sbillid", (QFilter[])new QFilter("tbillid", "=", redInfo.getPkValue()).and("isdelete", "!=", (Object)"Y").toArray());
            if (billRelations.length == 0) {
                return Boolean.FALSE;
            }
            Object[] sBillIds = Stream.of(billRelations).map(relation -> relation.getLong("sbillid")).distinct().toArray();
            DynamicObject[] invRelation = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)String.join((CharSequence)",", "tbillid", "pushtype"), (QFilter[])new QFilter("sbillid", "in", (Object)sBillIds).and("isdelete", "!=", (Object)"Y").toArray());
            Object[] tBillIds = Stream.of(invRelation).map(relation -> relation.getLong("tbillid")).distinct().toArray();
            if (tBillIds.length == 0 || tBillIds.length > 1) {
                return Boolean.FALSE;
            }
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)"invoiceamount", (QFilter[])new QFilter("id", "in", (Object)sBillIds).toArray());
            boolean isPush = Stream.of(invRelation).anyMatch(relation -> "1".equals(relation.getString("pushtype")));
            if (!Stream.of(bills).allMatch(bill -> bill.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) < 0) || isPush) {
                return Boolean.FALSE;
            }
            this.getPageCache().put("sbillid", String.join((CharSequence)",", Joiner.on((String)",").join(sBillIds)));
            return Boolean.TRUE;
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    private void setBuyerInfoIsNull(DynamicObject dynamicObject) {
        String buyerTaxNo = dynamicObject.getString("buyertaxno");
        if (StringUtils.isBlank((CharSequence)buyerTaxNo)) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)dynamicObject.getString("buyeraddr")) && StringUtils.isNotBlank((CharSequence)dynamicObject.getString("buyerbank"))) {
            return;
        }
        QFilter buyer = ImcBaseDataHelper.getInvTitleFilter((Object)dynamicObject.get("org"));
        buyer.and("taxno", "=", (Object)buyerTaxNo);
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"bdm_invice_title_strate", (String)"taxno, addr, openingbank,items.isdefault,items.itemaddr, items.itemopeningbank", (QFilter[])new QFilter[]{buyer}, (String)"items.isdefault desc");
        if (collect == null || collect.isEmpty()) {
            return;
        }
        for (DynamicObject dynamicBuyer : collect) {
            if (StringUtils.isNotBlank((CharSequence)dynamicObject.getString("buyeraddr")) && StringUtils.isNotBlank((CharSequence)dynamicObject.getString("buyerbank"))) {
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)dynamicBuyer.getString("addr"))) {
                dynamicObject.set("buyeraddr", (Object)dynamicBuyer.getString("addr"));
            }
            if (StringUtils.isNotBlank((CharSequence)dynamicBuyer.getString("openingbank"))) {
                dynamicObject.set("buyerbank", (Object)dynamicBuyer.getString("openingbank"));
            }
            if (!StringUtils.isBlank((CharSequence)dynamicObject.getString("buyeraddr")) || !StringUtils.isBlank((CharSequence)dynamicObject.getString("buyerbank"))) continue;
            if (StringUtils.isNotBlank((CharSequence)dynamicBuyer.getString("items.itemaddr"))) {
                dynamicObject.set("buyeraddr", (Object)dynamicBuyer.getString("items.itemaddr"));
            }
            if (!StringUtils.isNotBlank((CharSequence)dynamicBuyer.getString("items.itemopeningbank"))) continue;
            dynamicObject.set("buyerbank", (Object)dynamicBuyer.getString("items.itemopeningbank"));
        }
    }

    private void setSalerInfoAndPayeeIsNull(DynamicObject dynamicObject) {
        DynamicObject payeeObj;
        DynamicObject invoiceSettingObj;
        String saleTaxNo = dynamicObject.getString("salertaxno");
        if (StringUtils.isBlank((CharSequence)saleTaxNo)) {
            return;
        }
        SaleInfo saleInfo = new SaleInfo();
        saleInfo.setSaleTaxNo(saleTaxNo);
        if ((StringUtils.isBlank((CharSequence)dynamicObject.getString("saleraddr")) || StringUtils.isBlank((CharSequence)dynamicObject.getString("salerbank"))) && null != (invoiceSettingObj = TaxUtils.getSaleAddrBankByOrg((SaleInfo)saleInfo))) {
            if (StringUtils.isNotBlank((CharSequence)invoiceSettingObj.getString("invoiceAddr"))) {
                dynamicObject.set("saleraddr", (Object)invoiceSettingObj.getString("invoiceAddr"));
            }
            if (StringUtils.isNotBlank((CharSequence)invoiceSettingObj.getString("openuserbank"))) {
                dynamicObject.set("salerbank", (Object)invoiceSettingObj.getString("openuserbank"));
            }
        }
        if ((StringUtils.isBlank((CharSequence)dynamicObject.getString("payee")) || StringUtils.isBlank((CharSequence)dynamicObject.getString("reviewer"))) && null != (payeeObj = TaxUtils.getPayeeByOrg((SaleInfo)saleInfo))) {
            if (StringUtils.isNotBlank((CharSequence)payeeObj.getString("payee"))) {
                dynamicObject.set("payee", (Object)payeeObj.getString("payee"));
            }
            if (StringUtils.isNotBlank((CharSequence)payeeObj.getString("reviewer"))) {
                dynamicObject.set("reviewer", (Object)payeeObj.getString("reviewer"));
            }
        }
    }

    private void setTobacco(DynamicObject dynamicObject) {
        String specialType = dynamicObject.getString("specialtype");
        HashMap<String, String> specialTypeSelectMap = new HashMap<String, String>();
        specialTypeSelectMap.put(ResManager.loadKDString((String)"\u975e\u7279\u6b8a\u7968\u79cd", (String)"RedInfoOpenInvoicePlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]), "00");
        if ("11".equals(dynamicObject.getString("specialtype"))) {
            specialTypeSelectMap.put(ResManager.loadKDString((String)"\u5377\u70df", (String)"RedInfoOpenInvoicePlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]), "11");
        }
        if ("08".equals(dynamicObject.getString("specialtype"))) {
            specialTypeSelectMap.put(ResManager.loadKDString((String)"\u6210\u54c1\u6cb9", (String)"RedInfoOpenInvoicePlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]), "08");
        }
        ViewUtil.setDropDownViewData((AbstractFormPlugin)this, (String)"checkboxtobacco", specialTypeSelectMap);
        this.getModel().setValue("checkboxtobacco", (Object)(StringUtils.isBlank((CharSequence)specialType) ? "00" : specialType));
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbar_opt"});
        TextEdit saleEdit = (TextEdit)this.getView().getControl("saleraddr");
        saleEdit.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        QFilter qFilter = "saleraddr".equals(source.getKey()) ? new QFilter("taxno", "=", this.getModel().getValue("salertaxno")) : new QFilter("taxno", "=", (Object)"-1");
        ViewUtil.openListPage((AbstractFormPlugin)this, (QFilter)qFilter, (String)"sim_invoice_setting", (String)source.getKey());
    }

    private void returnDataToParent() {
        this.getView().returnDataToParent((Object)"refresh");
        this.getView().close();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection returnData;
        Object primaryKeyValue;
        DynamicObject salerSetting;
        String actionId = closedCallBackEvent.getActionId();
        if ("sim_red_info_openinvoice".equals(actionId) || "callback_sim_invoice_print_confirm".equals(actionId) || "sim_show_invoice_dialog".equals(actionId)) {
            if (closedCallBackEvent.getReturnData() == null) {
                this.returnDataToParent();
                return;
            }
            IssueInvoiceHelper.handleInvoicePrinterConfirm(this, closedCallBackEvent);
            return;
        }
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        if ("saleraddr".equals(actionId) && null != (salerSetting = BusinessDataServiceHelper.loadSingle((Object)(primaryKeyValue = (returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()).get(0).getPrimaryKeyValue()), (String)"sim_invoice_setting"))) {
            this.getView().getModel().setValue("saleraddr", (Object)salerSetting.getString("invoiceaddr"));
            this.getView().getModel().setValue("salerbank", (Object)salerSetting.getString("openuserbank"));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if ("btn_openinvoice".equals(evt.getItemKey())) {
            this.openInvoice();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if (e.getResult() == MessageBoxResult.Yes && "cancelOrRedArInvoice".equals(e.getCallBackId())) {
            String paramStr = this.getPageCache().get("cancelOrRedArInvoiceBillPks");
            this.getPageCache().remove("cancelOrRedArInvoiceBillPks");
            BotpHelper.writeOffArBillAndAddMark((String)paramStr, (String)"sim_red_info");
            this.confirmedOpenInvoice();
        }
    }

    private void confirmedOpenInvoice() {
        JSONObject invoiceJson = JSONObject.parseObject((String)this.getPageCache().get("redinfo_invoice_param"));
        DynamicObject invoiceObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
        DynamicObjectUtil.json2DynamicObjectContainItems((JSONObject)invoiceJson, (DynamicObject)invoiceObject, (boolean)true);
        String redInfoPkId = this.getPageCache().get("redinfo_db_param");
        this.doOpenInvoice(invoiceObject, redInfoPkId);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!StringUtils.isEmpty((CharSequence)this.getPageCache().get(PAGE_CACHE_WARP_DATA_DONT_CHANGE))) {
            return;
        }
        switch (e.getProperty().getName()) {
            case "invoicetype": {
                String invoiceType = (String)e.getChangeSet()[0].getNewValue();
                this.setInvoiceName((String)this.getModel().getValue("salertaxno"), invoiceType);
                this.setNextInvoiceCodeNo(e.getChangeSet()[0].getNewValue().toString());
                break;
            }
            case "jqbh": {
                String equipmentNo = (String)e.getChangeSet()[0].getNewValue();
                if (StringUtils.isBlank((CharSequence)equipmentNo)) {
                    return;
                }
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8bbe\u5907\u5207\u6362\u4e3a%s", (String)"RedInfoOpenInvoicePlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]), EquipmentType.getNameByCode((String)EquipmentHelper.getEquipmentTypeByNo((String)equipmentNo))));
                EquipmentUtil.showTerminalNo((AbstractFormPlugin)this, (String)equipmentNo, (String)"salertaxno", (String)"terminalno", (boolean)false);
                this.setNextInvoiceCodeNo((String)this.getModel().getValue("invoicetype"));
                this.setDeviceOpUserMethod();
                break;
            }
            case "num": {
                this.calculateUnitPrice(e.getChangeSet()[0]);
                break;
            }
            case "unitprice": {
                this.calculateNum(e.getChangeSet()[0]);
                break;
            }
            case "issuecontent": {
                this.changeIssueContent(e.getChangeSet()[0]);
            }
        }
    }

    private void setDeviceOpUserMethod() {
        long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("org"));
        String jqbh = (String)this.getModel().getValue("jqbh");
        log.info("setDeviceOpUserMethod, orgId:{}, jqbh:{}", (Object)orgId, (Object)jqbh);
        DrawerStrategyDTO drawerStrategyDTO = DrawerStrategyHelper.getDrawerStrategyFromCache((Long)orgId);
        if (drawerStrategyDTO == null) {
            return;
        }
        DynamicObject devDynamicObject = EquipmentUtil.getEquipmentDynamicObject((Long)orgId, (Object)jqbh);
        if (devDynamicObject == null) {
            return;
        }
        String drawerstrategy = drawerStrategyDTO.getDrawerStrategy();
        String payeeStrategy = drawerStrategyDTO.getPayeeStrategy();
        String reviewerStrategy = drawerStrategyDTO.getReviewerStrategy();
        log.info("setDeviceOpUserMethod, drawerstrategy:{}, payeeStrategy:{}, reviewerStrategy:{}", new Object[]{drawerstrategy, payeeStrategy, reviewerStrategy});
        if (StringUtils.isNotBlank((CharSequence)drawerstrategy) && "2".equals(drawerstrategy)) {
            this.getModel().setValue("drawer", (Object)devDynamicObject.getString("drawer"));
        }
        if (StringUtils.isNotBlank((CharSequence)payeeStrategy) && "2".equals(payeeStrategy)) {
            this.getModel().setValue("payee", (Object)devDynamicObject.getString("payee"));
        }
        if (StringUtils.isNotBlank((CharSequence)reviewerStrategy) && "2".equals(reviewerStrategy)) {
            this.getModel().setValue("reviewer", (Object)devDynamicObject.getString("reviewer"));
        }
    }

    private void changeIssueContent(ChangeData changeData) {
        String issueContent;
        if (StringUtils.isNotBlank((CharSequence)CacheHelper.get((String)"issuecontent"))) {
            return;
        }
        switch (issueContent = (String)changeData.getNewValue()) {
            case "0": {
                this.updateDetailByRedInfo();
                this.setRemark(true);
                break;
            }
            case "1": {
                this.updateDetailByOriginalBill(false, null);
                this.setRemark(false);
                break;
            }
            case "2": {
                MergeResult mergeResult = this.checkIsCanMerge();
                if (mergeResult.isMergeSucess()) {
                    this.updateDetailByOriginalBill(true, mergeResult);
                    this.setRemark(false);
                    break;
                }
                CacheHelper.put((String)"issuecontent", (String)"undo", (int)3);
                this.getModel().setValue("issuecontent", changeData.getOldValue());
                this.getView().showErrorNotification(mergeResult.getMsg());
            }
        }
    }

    private void setRemark(boolean isRedInfo) {
        if (isRedInfo) {
            DynamicObject redInfo = BusinessDataServiceHelper.loadSingle((Object)this.getView().getFormShowParameter().getCustomParam("id"), (String)"sim_red_info");
            this.getModel().setValue(MAIN_REMARK, (Object)redInfo.getString("applyreason"));
            return;
        }
        DynamicObject[] originalBills = this.getRelateOriginalBills(this.getRedInfo());
        StringBuilder remarkBuilder = new StringBuilder();
        for (DynamicObject originalBill : originalBills) {
            if (!StringUtils.isNotBlank((Object)originalBill)) continue;
            remarkBuilder.append(originalBill.getString("invoiceremark")).append(';');
        }
        if (remarkBuilder.length() > 0) {
            String remark = remarkBuilder.toString();
            this.getModel().setValue(MAIN_REMARK, (Object)remark);
        }
    }

    private MergeResult checkIsCanMerge() {
        DynamicObject redInfo = this.getRedInfo();
        DynamicObject[] originalBills = this.getRelateOriginalBills(redInfo);
        int size = 0;
        for (DynamicObject bill : originalBills) {
            size += bill.getDynamicObjectCollection("sim_original_bill_item").size();
        }
        DynamicObjectCollection items = this.getRedInfo().getDynamicObjectCollection("items");
        String firstRowGoodsName = ((DynamicObject)items.get(0)).getString("goodsname");
        boolean isRedInfoWithDetailList = BillConstant.TIP_ITEM_DETAIL.equalsIgnoreCase(firstRowGoodsName);
        String jqbh = (String)this.getModel().getValue("jqbh");
        if (size > 8) {
            if (isRedInfoWithDetailList) {
                MergeResult mergeResult = new MergeResult();
                mergeResult.setMergeSucess(false);
                mergeResult.setMsg(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u4e0d\u5305\u542b\u6e05\u5355\uff0c\u4f46\u8d1f\u6570\u5355\u636e\u5df2\u8d85\u8fc78\u884c\uff0c\u4e0d\u5141\u8bb8\u6309\u7167\u8ba2\u5355\u6570\u636e\u5f00\u7968\uff0c\u8bf7\u9009\u62e9\u3010\u6309\u7ea2\u5b57\u4fe1\u606f\u8868\u5f00\u7968\u3011\u3002", (String)"RedInfoOpenInvoicePlugin_7", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return mergeResult;
            }
            return this.mergeItems(originalBills, jqbh);
        }
        return this.mergeItems(originalBills, jqbh);
    }

    private DynamicObject[] getRelateOriginalBills(DynamicObject redInfo) {
        DynamicObject[] billRelations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)"sbillid", (QFilter[])new QFilter("tbillid", "=", redInfo.getPkValue()).and("isdelete", "!=", (Object)"Y").toArray());
        Object[] sBillIds = Stream.of(billRelations).map(relation -> relation.getLong("sbillid")).distinct().toArray();
        return BusinessDataServiceHelper.load((Object[])sBillIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill"));
    }

    private MergeResult mergeItems(DynamicObject[] originalBills, String devno) {
        HashMap<String, DynamicObject> mergeResult = new HashMap<String, DynamicObject>();
        MergeResult result = new MergeResult();
        ArrayList<DynamicObject> mergeItems = new ArrayList<DynamicObject>();
        result.setItems(mergeItems);
        for (DynamicObject originalBill : originalBills) {
            DynamicObjectCollection items = originalBill.getDynamicObjectCollection("sim_original_bill_item");
            for (DynamicObject item : items) {
                String mergeKey = item.getString("goodsname") + item.getString("specification") + item.getString("unit") + item.getString("taxrate") + item.get("unitprice") + item.get("policycontants");
                DynamicObject mergeItem = (DynamicObject)mergeResult.get(mergeKey);
                if (mergeItem != null) {
                    DynamicObject resultItem = (DynamicObject)mergeResult.get(mergeKey);
                    resultItem.set("amount", (Object)resultItem.getBigDecimal("amount").add(item.getBigDecimal("amount")));
                    resultItem.set("tax", (Object)resultItem.getBigDecimal("tax").add(item.getBigDecimal("tax")));
                    resultItem.set("num", (Object)resultItem.getBigDecimal("num").add(item.getBigDecimal("num")));
                    continue;
                }
                mergeResult.put(mergeKey, item);
            }
        }
        DynamicObject[] array = BusinessDataServiceHelper.load((String)"bdm_tax_equipment", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_tax_equipment", (boolean)true), (QFilter[])new QFilter("equipmentno", "=", (Object)devno).toArray());
        if (array.length == 0) {
            throw new MsgException(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u627e\u5230\u5bf9\u5e94\u7684\u8bbe\u5907", (String)"RedInfoOpenInvoicePlugin_8", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        String equipmentType = array[0].getString("equipmenttype");
        BigDecimal difference = "2".equals(equipmentType) ? new BigDecimal("0.06") : new BigDecimal("0.01");
        for (Map.Entry entry : mergeResult.entrySet()) {
            if (this.isItemDifferenceOverfull((DynamicObject)entry.getValue(), difference)) {
                result.setMergeSucess(false);
                result.setMsg(ResManager.loadKDString((String)"\u660e\u7ec6\u5408\u5e76\u540e\u8ba2\u5355\u91d1\u989d\u548c\u7ea2\u5b57\u4fe1\u606f\u8868\u91d1\u989d\u4e0d\u7b26\uff0c\u8bf7\u6309\u7167\u7ea2\u5b57\u4fe1\u606f\u8868\u5f00\u5177\u7ea2\u7968", (String)"RedInfoOpenInvoicePlugin_9", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return result;
            }
            if (BigDecimal.ZERO.compareTo(((DynamicObject)entry.getValue()).getBigDecimal("amount")) == 0) continue;
            mergeItems.add((DynamicObject)entry.getValue());
        }
        result.setMergeSucess(true);
        return result;
    }

    private boolean isItemDifferenceOverfull(DynamicObject item, BigDecimal difference) {
        BigDecimal amountDifference;
        String taxRate = item.getString("taxrate");
        BigDecimal taxRateValue = new BigDecimal(taxRate);
        BigDecimal calTax = item.getBigDecimal("amount").multiply(taxRateValue);
        BigDecimal absDifference = calTax.subtract(item.getBigDecimal("tax")).abs().setScale(2, RoundingMode.HALF_UP);
        if (absDifference.compareTo(difference) > 0) {
            return true;
        }
        BigDecimal amount = item.getBigDecimal("amount");
        BigDecimal num = item.getBigDecimal("num");
        BigDecimal unitPrice = item.getBigDecimal("unitprice");
        if (null != amount && null != num && null != unitPrice && BigDecimal.ZERO.compareTo(amount) != 0 && BigDecimal.ZERO.compareTo(num) != 0 && BigDecimal.ZERO.compareTo(unitPrice) != 0 && (amountDifference = amount.subtract(num.multiply(unitPrice)).setScale(2, RoundingMode.HALF_UP).abs()).compareTo(new BigDecimal("0.01")) > 0) {
            return false;
        }
        return false;
    }

    private DynamicObject getRedInfo() {
        Object pkValue = this.getView().getFormShowParameter().getCustomParam("id");
        return BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"sim_red_info");
    }

    private void updateDetailByRedInfo() {
        this.getView().getModel().deleteEntryData("items");
        DynamicObject redInfo = BusinessDataServiceHelper.loadSingle((Object)this.getView().getFormShowParameter().getCustomParam("id"), (String)"sim_red_info");
        DynamicObjectCollection items = redInfo.getDynamicObjectCollection("items");
        this.setRedInfoDetailView(items);
    }

    private void setRedInfoDetailView(DynamicObjectCollection items) {
        this.getModel().deleteEntryData("items");
        this.getModel().batchCreateNewEntryRow("items", items.size());
        DataEntityPropertyCollection properties = ((DynamicObject)items.get(0)).getDynamicObjectType().getProperties();
        DataEntityPropertyCollection viewItemProperties = ((EntryProp)this.getModel().getDataEntityType().getProperty("items")).getItemType().getProperties();
        Set viewProperties = viewItemProperties.stream().map(IMetadata::getName).collect(Collectors.toSet());
        viewProperties.remove("id");
        viewProperties.remove("seq");
        this.getPageCache().put(PAGE_CACHE_WARP_DATA_DONT_CHANGE, PAGE_CACHE_WARP_DATA_DONT_CHANGE);
        String entityName = ((DynamicObject)items.get(0)).getDataEntityType().getName();
        for (int i = 0; i < items.size(); ++i) {
            DynamicObject item = (DynamicObject)items.get(i);
            for (String field : viewProperties) {
                if (!properties.containsKey((Object)field)) continue;
                if ("sim_original_bill_item".equals(entityName) && "goodsname".equals(field)) {
                    String goodsSimpleName = item.getString("goodssimplename");
                    String goodsName = item.getString("goodsname");
                    if (StringUtils.isNotBlank((CharSequence)goodsSimpleName) && StringUtils.isNotBlank((CharSequence)goodsName) && !goodsName.startsWith("*")) {
                        goodsSimpleName = goodsSimpleName.startsWith("*") ? goodsSimpleName : '*' + goodsSimpleName + '*';
                        goodsName = goodsSimpleName + goodsName;
                    }
                    this.getModel().setValue(field, (Object)goodsName, i);
                    continue;
                }
                this.getModel().setValue(field, item.get(field), i);
            }
        }
        this.getPageCache().remove(PAGE_CACHE_WARP_DATA_DONT_CHANGE);
    }

    private void updateDetailByOriginalBill(boolean isMerge, MergeResult result) {
        DynamicObjectCollection items = new DynamicObjectCollection();
        if (isMerge) {
            items.addAll(result.getItems());
        } else {
            DynamicObject[] originalBills;
            this.getView().getModel().deleteEntryData("items");
            String[] sBillIdStr = this.getPageCache().get("sbillid").split(",");
            Object[] sBillIds = Stream.of(sBillIdStr).map(Long::valueOf).toArray();
            for (DynamicObject originalBill : originalBills = BusinessDataServiceHelper.load((Object[])sBillIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill"))) {
                items.addAll((Collection)originalBill.getDynamicObjectCollection("sim_original_bill_item"));
            }
        }
        this.setRedInfoDetailView(items);
    }

    private void checkLength(int maxLength, int rowIndex, String newValue, String fieldName) {
        if (null == newValue) {
            return;
        }
        if (GBKUtils.getGBKLength((String)newValue) > maxLength) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7%3$s\u4e2a\u5b57\u8282", (String)"RedInfoOpenInvoicePlugin_30", (String)"imc-sim-formplugin", (Object[])new Object[0]), rowIndex + 1, fieldName, maxLength));
        }
    }

    private void calculateNum(ChangeData changeData1) {
        String s = this.getPageCache().get(PRICE_NUM_CHANGE);
        if (StringUtils.isNotBlank((CharSequence)s)) {
            this.getPageCache().remove(PRICE_NUM_CHANGE);
            return;
        }
        int rowIndex = changeData1.getRowIndex();
        Object unitPrice = this.getModel().getValue("unitprice", rowIndex);
        if (null == unitPrice) {
            this.getModel().setValue("num", null);
            return;
        }
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
        BigDecimal Num = UnitPriceHelper.calcNum((BigDecimal)amount, (BigDecimal)((BigDecimal)unitPrice));
        String NumStr = Num.toPlainString();
        if (NumStr.length() > 16) {
            Num = Num.setScale(14 - (NumStr.length() - 16), RoundingMode.HALF_UP);
        }
        this.getPageCache().put(PRICE_NUM_CHANGE, PRICE_NUM_CHANGE);
        this.getModel().setValue("num", (Object)Num);
    }

    private void calculateUnitPrice(ChangeData changeData) {
        String s = this.getPageCache().get(PRICE_NUM_CHANGE);
        if (StringUtils.isNotBlank((CharSequence)s)) {
            this.getPageCache().remove(PRICE_NUM_CHANGE);
            return;
        }
        int rowIndex = changeData.getRowIndex();
        Object num = this.getModel().getValue("num", rowIndex);
        if (null == num) {
            this.getModel().setValue("unitprice", null);
            return;
        }
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
        BigDecimal unitPrice = PriceHelper.calcPriceOrNum((BigDecimal)amount, (BigDecimal)((BigDecimal)num), (boolean)false);
        String unitPriceStr = unitPrice.toPlainString();
        if (unitPriceStr.length() > 16) {
            unitPrice = unitPrice.setScale(14 - (unitPriceStr.length() - 16), RoundingMode.HALF_UP);
        }
        this.getPageCache().put(PRICE_NUM_CHANGE, PRICE_NUM_CHANGE);
        this.getModel().setValue("unitprice", (Object)unitPrice);
    }

    private void setNextInvoiceCodeNo(String invoiceType) {
        if (InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode().equals(invoiceType)) {
            this.getView().addClientCallBack("setNextInvoiceCodeNo", Integer.valueOf(100));
        } else {
            this.getModel().setValue("invoicecode", null);
            this.getModel().setValue("invoiceno", null);
        }
    }

    protected void setInvoiceName(String taxno, String invoiceType) {
        String invoiceProvince = InvoiceUtils.getInvoiceProvince((String)taxno);
        Label labelHead = (Label)this.getView().getControl("label_head");
        labelHead.setText(invoiceProvince + InvoiceType.getInvoiceDescription((String)invoiceType));
    }

    protected void openInvoice() {
        DynamicObject redInfoFromPage = ModelUtil.getModelValue2DynamicObject((String)"sim_red_info", (AbstractFormPlugin)this);
        redInfoFromPage.set("specialtype", this.getView().getModel().getValue("checkboxtobacco"));
        this.checkItemsData();
        Object pkId = this.getView().getFormShowParameter().getCustomParam("id");
        DynamicObject redInfoFromDB = BusinessDataServiceHelper.loadSingle((String)"sim_red_info", (String)String.join((CharSequence)",", "id", "org"), (QFilter[])new QFilter("id", "=", (Object)Long.parseLong(pkId.toString())).toArray());
        if (null == redInfoFromDB) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\uff01", (String)"RedInfoOpenInvoicePlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        PermissionHelper.checkPermission((String)"sim", (String)"sim_red_info", (long)DynamicObjectUtil.getDynamicObjectLongValue((Object)redInfoFromDB.get("org")), (ImcPermItemEnum)ImcPermItemEnum.SIM_RED);
        redInfoFromDB = BusinessDataServiceHelper.loadSingle((Object)redInfoFromDB.getPkValue(), (String)"sim_red_info");
        EquipmentHelper.checkTerminalNo((String)((String)this.getView().getModel().getValue("jqbh")), (String)redInfoFromDB.getString("salertaxno"), (String)((String)this.getView().getModel().getValue("terminalno")));
        RedInfoDTO pageRedInfo = (RedInfoDTO)DynamicObjectUtil.dynamicObject2Bean(RedInfoDTO.class, (DynamicObject)redInfoFromPage);
        if (!RedInfoConstant.isAuditSuccess((String)redInfoFromDB.getString("infostatus"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u72b6\u6001\u4e0d\u5141\u8bb8\u5f00\u7968", (String)"RedInfoOpenInvoicePlugin_11", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        if (!"3".equals(redInfoFromDB.getString("status"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u72b6\u6001\u4e0d\u5141\u8bb8\u5f00\u7968", (String)"RedInfoOpenInvoicePlugin_11", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)redInfoFromDB.getString("infocode")) || redInfoFromDB.getString("infocode").length() != 16) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7f16\u53f7\u4e0d\u5408\u6cd5\uff0816\u4f4d\u6570\u5b57\uff09", (String)"RedInfoOpenInvoicePlugin_12", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)redInfoFromDB.getString("invoicecode")) || StringUtils.isNotBlank((CharSequence)redInfoFromDB.getString("invoiceno"))) {
            this.showSuccessDialog(redInfoFromDB.getString("invoicetype"), redInfoFromDB.getString("jqbh"), redInfoFromDB.getString("invoicecode"), redInfoFromDB.getString("invoiceno"));
            return;
        }
        if (StringUtils.isBlank((CharSequence)pageRedInfo.getJqbh())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u5f00\u7968\u8bbe\u5907\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"RedInfoOpenInvoicePlugin_13", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        redInfoFromDB.set("drawer", redInfoFromPage.get("drawer"));
        RedInfoHelper.queryWaitInvoiceByInfoCodeThenDelete((DynamicObject)redInfoFromDB);
        DynamicObject redInvoice = this.getNewInvoiceDynamicObject(redInfoFromPage, redInfoFromDB, (String)this.getModel().getValue(MAIN_REMARK));
        String errorMsg = InvoiceCheckService.checkParams((DynamicObject)redInvoice, (boolean)false);
        if (!StringUtils.isEmpty((CharSequence)errorMsg)) {
            throw new KDBizException(errorMsg);
        }
        JSONObject param = BotpHelper.cancelOrRedArInvoice((DynamicObject[])new DynamicObject[]{redInfoFromDB}, (CancelRedEum)CancelRedEum.ISSUE_RED_INFO);
        Integer billPksSize = param.getInteger("billPksSize");
        if (billPksSize > 0) {
            this.getPageCache().put("redinfo_invoice_param", SerializationUtils.toJsonString((Object)DynamicObjectUtil.dynamicObject2JsonContainItems((DynamicObject)redInvoice, (JSONObject)new JSONObject())));
            this.getPageCache().put("redinfo_db_param", pkId.toString());
            this.getPageCache().put("cancelOrRedArInvoiceBillPks", param.toJSONString());
            ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\u5df2\u786e\u8ba4\u5e94\u6536\uff0c\u7ea2\u51b2\u53d1\u7968\u5c06\u51b2\u9500\u5f00\u7968\u7533\u8bf7\u5355\u6240\u5173\u8054\u7684\u8d22\u52a1\u5e94\u6536\u5355\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"RedInfoListPlugin_38", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"cancelOrRedArInvoice");
            return;
        }
        this.doOpenInvoice(redInvoice, pkId);
    }

    public DynamicObject getNewInvoiceDynamicObject(DynamicObject redInfoFromPage, DynamicObject redInfoFromDB, String otherRemark) {
        DynamicObject redInvoice = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
        DynamicObjectUtil.copyDynamicObject((DynamicObject)redInfoFromPage, (DynamicObject)redInvoice);
        redInvoice.set("totalamount", (Object)redInvoice.getBigDecimal("invoiceamount").add(redInvoice.getBigDecimal("totaltax")));
        otherRemark = otherRemark == null ? "" : otherRemark;
        String remark = RemarkTemplateHelper.generateRedInfoRemark((DynamicObject)redInfoFromDB);
        redInvoice.set("orgid", redInfoFromDB.get("org"));
        redInvoice.set("batchbelong", redInfoFromDB.get("batchbelong"));
        redInvoice.set("remark", (Object)GBKUtils.cutGBKString((String)(remark + otherRemark), (int)230));
        redInvoice.set("issuetype", (Object)IssueTypeEnum.red.getValue());
        redInvoice.set("hsbz", (Object)"0");
        redInvoice.set("buyertype", (Object)("5".equals(redInfoFromDB.getString("infosource")) || "10".equals(redInfoFromDB.getString("infosource")) ? "4" : "0"));
        redInvoice.set("originalinvoicecode", (Object)redInfoFromDB.getString("originalinvoicecode"));
        redInvoice.set("originalinvoiceno", (Object)redInfoFromDB.getString("originalinvoiceno"));
        redInvoice.set("taxedtype", (Object)TaxedTypeEnum.normal.getValue());
        log.info("\u4e13\u7968\u7ea2\u51b2\uff0c\u7ea2\u5b57\u4fe1\u606f\u8868\u5355\u636e\u7f16\u53f7\uff1a" + redInfoFromDB.getString("billno"));
        redInvoice.set("billno", (Object)redInfoFromDB.getString("billno"));
        redInvoice.set("infocode", (Object)redInfoFromDB.getString("infocode"));
        redInvoice.set("systemsource", (Object)redInfoFromDB.getString("systemsource"));
        redInvoice.set("deduction", (Object)redInfoFromDB.getBigDecimal("deduction"));
        redInvoice.set("issuewritebackstatus", (Object)"0");
        redInvoice.set("abolishwritebackstatus", (Object)"2");
        DynamicObjectCollection collection = redInvoice.getDynamicObjectCollection("items");
        for (DynamicObject item : collection) {
            item.set("taxamount", (Object)item.getBigDecimal("amount").add(item.getBigDecimal("tax")));
            String rowType = item.getString("rowtype");
            if (!StringUtils.isBlank((CharSequence)rowType)) continue;
            item.set("rowtype", (Object)"0");
        }
        if (collection.size() > 8) {
            redInvoice.set("inventorymark", (Object)"1");
        } else {
            redInvoice.set("inventorymark", (Object)"0");
        }
        redInvoice.set("invoicingoperator", (Object)Long.parseLong(RequestContext.get().getUserId()));
        return redInvoice;
    }

    public void doOpenInvoice(DynamicObject dynamicInvoice, Object redInfoPkId) {
        block20: {
            DynamicObject redInfoFromDB = BusinessDataServiceHelper.loadSingle((String)"sim_red_info", (String)"id", (QFilter[])new QFilter("id", "=", (Object)Long.parseLong(redInfoPkId.toString())).toArray());
            redInfoFromDB = BusinessDataServiceHelper.loadSingle((Object)redInfoFromDB.getPkValue(), (String)"sim_red_info");
            redInfoFromDB.set("drawer", this.getView().getModel().getValue("drawer"));
            String key = "imc_red_info_open_invoice_" + dynamicInvoice.getString("orderno");
            try (DLock lock = DLock.create((String)key);){
                boolean isGetLock = lock.tryLock(5000L);
                if (!isGetLock) {
                    throw new MsgException(ResManager.loadKDString((String)"\u8bf7\u52ff\u91cd\u590d\u70b9\u51fb", (String)"RedInfoOpenInvoicePlugin_17", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                }
                if (BotpHelper.isRedConfirmOrInfoNeedShowArTip((DynamicObject)redInfoFromDB)) {
                    this.getView().showTipNotification(BotpHelper.getRedFiTip(), Integer.valueOf(8000));
                }
                String orderNo = StringUtils.isBlank((CharSequence)redInfoFromDB.getString("orderno")) ? redInfoFromDB.getString("infoserialno") : redInfoFromDB.getString("orderno");
                dynamicInvoice.set("orderno", (Object)orderNo);
                MsgResponse response = IssueInvoiceService.doIssueInvoice((DynamicObject)dynamicInvoice);
                if (ErrorType.SUCCESS.getCode().equals(response.getErrorCode())) {
                    JSONObject json = JSONObject.parseObject((String)response.getRespData());
                    redInfoFromDB.set("invoicecode", json.get((Object)"invoicecode"));
                    redInfoFromDB.set("invoiceno", json.get((Object)"invoiceno"));
                    redInfoFromDB.set("status", (Object)"4");
                    Object issueTime = json.get((Object)"issuetime");
                    if (issueTime == null) {
                        redInfoFromDB.set("issuetime", (Object)new Date());
                    } else {
                        redInfoFromDB.set("issuetime", (Object)IssueInvoiceService.handleIssueTime((String)String.valueOf(json.get((Object)"issuetime"))));
                    }
                    SaveServiceHelper.update((DynamicObject)redInfoFromDB);
                    this.showSuccessDialog(dynamicInvoice.getString("invoicetype"), dynamicInvoice.getString("jqbh"), json.getString("invoicecode"), json.getString("invoiceno"));
                    break block20;
                }
                if (ErrorType.SUBMITED.getCode().equalsIgnoreCase(response.getErrorCode())) {
                    this.getView().close();
                    IssueInvoiceHelper.jumpWaitInvoiceListPage(this, null, ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u5f00\u7968\u8bf7\u6c42\uff0c\u8bf7\u7a0d\u5019\u5728'\u5f00\u7968\u67e5\u8be2'\u5217\u8868\uff0c\u67e5\u770b\u5f00\u5177\u6210\u529f\u53d1\u7968", (String)"RedInfoOpenInvoicePlugin_18", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    break block20;
                }
                throw new KDBizException(response.getErrorMsg());
            }
            catch (Exception e) {
                log.error("RedInfoOpenInvoice Exception", (Throwable)e);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e13\u7528\u53d1\u7968\u7ea2\u51b2\u5f02\u5e38: %s", (String)"RedInfoOpenInvoicePlugin_32", (String)"imc-sim-formplugin", (Object[])new Object[0]), e.getMessage()));
            }
        }
    }

    private void checkItemsData() {
        DynamicObjectCollection items = this.getModel().getEntryEntity("items");
        for (int i = 0; i < items.size(); ++i) {
            DynamicObject item = (DynamicObject)items.get(i);
            String specification = item.getString("specification");
            this.checkLength(40, i, specification, ResManager.loadKDString((String)"\u89c4\u683c", (String)"RedInfoOpenInvoicePlugin_33", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            String unit = item.getString("unit");
            this.checkLength(22, i, unit, ResManager.loadKDString((String)"\u5355\u4f4d", (String)"RedInfoOpenInvoicePlugin_34", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            BigDecimal unitPrice = item.getBigDecimal("unitprice");
            if (BigDecimalUtil.lessZero((BigDecimal)unitPrice)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u660e\u7ec6\uff0c\u5355\u4ef7\u5fc5\u987b\u5927\u4e8e0", (String)"RedInfoOpenInvoicePlugin_22", (String)"imc-sim-formplugin", (Object[])new Object[0]), i + 1));
            }
            BigDecimal num = item.getBigDecimal("num");
            if (BigDecimalUtil.greaterZero((BigDecimal)num)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u660e\u7ec6\uff0c\u6570\u91cf\u5fc5\u987b\u5c0f\u4e8e0", (String)"RedInfoOpenInvoicePlugin_23", (String)"imc-sim-formplugin", (Object[])new Object[0]), i + 1));
            }
            this.checkUnitPriceAndNum(unitPrice, num, i);
        }
    }

    private void checkUnitPriceAndNum(BigDecimal unitPrice, BigDecimal num, int rowIndex) {
        if (null == unitPrice && null != num || null == num && null != unitPrice) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u660e\u7ec6\uff0c\u5355\u4ef7\u548c\u6570\u91cf\u4e0d\u8981\u4e48\u540c\u65f6\u4e3a\u7a7a\uff0c\u8981\u4e48\u540c\u65f6\u4e0d\u4e3a\u7a7a", (String)"RedInfoOpenInvoicePlugin_24", (String)"imc-sim-formplugin", (Object[])new Object[0]), rowIndex + 1));
        }
        if (null == unitPrice) {
            return;
        }
        int unitPriceLength = unitPrice.setScale(0, RoundingMode.HALF_UP).toPlainString().length();
        if (unitPriceLength > 13) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u660e\u7ec6\uff0c\u5355\u4ef7\u6574\u6570\u4f4d\u6700\u592713\u4f4d", (String)"RedInfoOpenInvoicePlugin_25", (String)"imc-sim-formplugin", (Object[])new Object[0]), rowIndex + 1));
        }
        int numLength = num.setScale(0, RoundingMode.HALF_UP).toPlainString().replace("-", "").length();
        if (numLength > 13) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u660e\u7ec6\uff0c\u6570\u91cf\u6574\u6570\u4f4d\u6700\u592713\u4f4d", (String)"RedInfoOpenInvoicePlugin_26", (String)"imc-sim-formplugin", (Object[])new Object[0]), rowIndex + 1));
        }
        String unitPriceStr = unitPrice.stripTrailingZeros().toPlainString();
        if (unitPriceStr.length() > 16) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u660e\u7ec6\uff0c\u5355\u4ef7\u6574\u6570\u4f4d\u52a0\u5c0f\u6570\u70b9\u540e\u7684\u4f4d\u6570\u4e0d\u80fd\u8d85\u8fc716\u4f4d", (String)"RedInfoOpenInvoicePlugin_27", (String)"imc-sim-formplugin", (Object[])new Object[0]), rowIndex + 1));
        }
        String numStr = num.stripTrailingZeros().toPlainString().replace("-", "");
        if (numStr.length() > 16) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u660e\u7ec6\uff0c\u6570\u91cf\u6574\u6570\u4f4d\u52a0\u5c0f\u6570\u70b9\u540e\u7684\u4f4d\u6570\u4e0d\u80fd\u8d85\u8fc716\u4f4d", (String)"RedInfoOpenInvoicePlugin_28", (String)"imc-sim-formplugin", (Object[])new Object[0]), rowIndex + 1));
        }
    }

    public void showSuccessDialog(String invoiceType, String jqbh, String invoiceCode, String invoiceNo) {
        HashMap<String, String> customParams = new HashMap<String, String>(4);
        customParams.put("invoicecode", invoiceCode);
        customParams.put("invoiceno", invoiceNo);
        if (InvoiceUtils.getPaperInvoiceType().contains(invoiceType)) {
            customParams.put("invoicetype", invoiceType);
            customParams.put("jqbh", jqbh);
            ViewUtil.openDialog((AbstractFormPlugin)this, customParams, (String)"sim_invoice_print_confirm", (String)"callback_sim_invoice_print_confirm");
        } else {
            ViewUtil.openDialog((AbstractFormPlugin)this, customParams, (String)"sim_show_invoice_dialog", (String)"sim_red_info_openinvoice");
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        String equipmentNo = ObjectUtils.defaultIfNull((Object)this.getModel().getValue("jqbh"), (Object)"").toString();
        String invoiceType = ObjectUtils.defaultIfNull((Object)this.getModel().getValue("invoicetype"), (Object)"").toString();
        if (StringUtils.isBlank((CharSequence)equipmentNo)) {
            return;
        }
        if (!"setNextInvoiceCodeNo".equals(e.getName())) {
            return;
        }
        ImmutableSet equipmentSet = ImmutableSet.of((Object)"2", (Object)"0", (Object)"1");
        String equipmentType = EquipmentHelper.getEquipmentTypeByNo((String)equipmentNo);
        if (EquipmentHelper.getInvoiceTypeByEquipmentType((String)equipmentType).contains(invoiceType) && equipmentSet.contains((Object)equipmentType)) {
            long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("org"));
            SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)orgId);
            ComponentRequest request = new ComponentRequest(ComponentInterfaceTypeEnum.GETINVOICEINFO.getCzlx(), null, null, saleInfo.getDefaultTerminal());
            request.setInvoice_type(InvoiceType.getTypeCodeHx((String)invoiceType));
            ComponentResponse response = ComponentServiceHelper.doPost((String)ComponentServiceHelper.getComponentRequestUrl((String)equipmentNo), (String)JSON.toJSONString((Object)request), PaperInvoiceRollInfoDTO.class);
            if (response.isSucess() && response.getResponse() != null && ((PaperInvoiceRollInfoDTO)response.getResponse()).getInfo() != null) {
                this.getModel().setValue("invoicecode", (Object)((PaperInvoiceRollInfoDTO)response.getResponse()).getInfo().getInvoice_code());
                this.getModel().setValue("invoiceno", (Object)((PaperInvoiceRollInfoDTO)response.getResponse()).getInfo().getInvoice_num());
            }
        } else {
            this.getModel().setValue("invoicecode", null);
            this.getModel().setValue("invoiceno", null);
        }
    }

    private static class MergeResult {
        private List<DynamicObject> items;
        private boolean isMergeSucess;
        private String msg;

        private MergeResult() {
        }

        public List<DynamicObject> getItems() {
            return this.items;
        }

        public void setItems(List<DynamicObject> items) {
            this.items = items;
        }

        public boolean isMergeSucess() {
            return this.isMergeSucess;
        }

        public void setMergeSucess(boolean mergeSucess) {
            this.isMergeSucess = mergeSucess;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }
    }
}

