/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.report.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.HiddenButtonHelper;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.formplugin.report.AbstractReportPlugin;
import kd.imc.sim.formplugin.report.plugin.SimStatusReportDataPlugin;

public class SimStatusReportFormPlugin
extends AbstractReportPlugin
implements HyperLinkClickListener {
    public boolean verifyQuery(ReportQueryParam queryParam) {
        return this.timeVerify(queryParam);
    }

    public void afterCreateNewData(EventObject e) {
        HiddenButtonHelper.hideClose((AbstractFormPlugin)this, (String[])new String[]{"close"});
        this.initBaseOrgParamFilter();
        this.initStartDayFilter();
        this.initEndDayFilter();
    }

    public void registerListener(EventObject e) {
        ReportList entryGrid = (ReportList)this.getView().getControl("reportlistap");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        DynamicObject rowData = hyperLinkClickEvent.getRowData();
        IDataModel model = this.getModel();
        Date startDate = (Date)model.getValue("startdate");
        Date enddate = (Date)model.getValue("enddate");
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        DynamicObjectCollection orgList = filterInfo.getDynamicObjectCollection("org");
        String salername = rowData.getString("salername");
        String taxno = rowData.getString("taxno");
        String invoiceType = rowData.getString("invoicetype");
        String org_Name = rowData.getString("org_name");
        String invoiceStatus = rowData.getString("issuetype");
        this.showInvoice(startDate, enddate, filterInfo, orgList, salername, taxno, invoiceType, org_Name, invoiceStatus);
    }

    public void showInvoice(Date startDate, Date enddate, FilterInfo filterInfo, DynamicObjectCollection orgList, String salername, String taxno, String invoiceType, String org_Name, String invoiceStatus) {
        DynamicObject[] invoiceArray;
        QFilter orgFilter = this.getOrgFilter(orgList, org_Name);
        QFilter dateFilter = this.getDateFilter(startDate, enddate);
        QFilter issuedFilter = new QFilter("issuestatus", "=", (Object)IssueStatusEnum.ok.getCode());
        QFilter sellerTaxNoFilter = new QFilter("salertaxno", "=", (Object)taxno);
        QFilter sellerNameFilter = new QFilter("salername", "=", (Object)salername);
        QFilter invoiceTypeFilter = new QFilter("invoicetype", "=", (Object)invoiceType);
        QFilter invoiceStatusFilter = new QFilter("invoicestatus", "=", (Object)invoiceStatus);
        SimStatusReportDataPlugin data = new SimStatusReportDataPlugin();
        HashSet enterpriseName = data.queryEnterpriseName(filterInfo);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        Collections.addAll(qFilters, orgFilter, dateFilter, sellerTaxNoFilter, issuedFilter, sellerNameFilter, invoiceTypeFilter, invoiceStatusFilter);
        if ("\u5c0f\u8ba1".equals(invoiceType) || "\u603b\u8ba1".equals(invoiceType)) {
            qFilters.remove(invoiceStatusFilter);
            qFilters.remove(sellerTaxNoFilter);
            QFilter invoiceTypeFilterAll = new QFilter("invoicetype", "in", (Object)invoiceTypeArray);
            qFilters.remove(invoiceTypeFilter);
            qFilters.add(invoiceTypeFilterAll);
            if (StringUtils.isBlank((CharSequence)salername)) {
                qFilters.remove(sellerNameFilter);
            }
            QFilter allNameFilter = new QFilter("salername", "in", (Object)enterpriseName.toArray(new String[0]));
            qFilters.add(allNameFilter);
        }
        if ((invoiceArray = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]))).length > 0) {
            ArrayList<Object> pks = new ArrayList<Object>();
            for (DynamicObject invoice : invoiceArray) {
                pks.add(invoice.getPkValue());
            }
            QFilter idFilter = new QFilter("id", "in", (Object)pks.toArray());
            HashMap<String, String> parameter = new HashMap<String, String>();
            parameter.put("isFromGoodsReport", "isFromGoodsReport");
            ViewUtil.openListPageByMainPage((AbstractFormPlugin)this, (QFilter)idFilter, parameter, (String)"sim_vatinvoice", null, null);
        }
    }

    public QFilter getOrgFilter(DynamicObjectCollection collection, String orgName) {
        int size = collection.size();
        Object[] ids = new Object[size];
        for (int i = 0; i < collection.size(); ++i) {
            Object id;
            ids[i] = id = ((DynamicObject)collection.get(i)).get("id");
        }
        QFilter filter = ids.length == 0 ? new QFilter("id", "=", (Object)RequestContext.get().getOrgId()) : new QFilter("id", "in", (Object)ids);
        if (StringUtils.isNotBlank((CharSequence)orgName)) {
            QFilter nameFilter = new QFilter("name", "like", (Object)("%" + orgName + "%"));
            DynamicObject[] array = BusinessDataServiceHelper.load((String)"bdm_org", (String)"id", (QFilter[])new QFilter[]{filter, nameFilter});
            ArrayList<Object> list = new ArrayList<Object>();
            for (DynamicObject org : array) {
                list.add(org.getPkValue());
            }
            return new QFilter("orgid", "in", (Object)list.toArray(new Object[0]));
        }
        if (ids.length == 0) {
            return new QFilter("orgid", "=", (Object)RequestContext.get().getOrgId());
        }
        return new QFilter("orgid", "in", (Object)ids);
    }
}

