/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.vehicle;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.formplugin.invoicebatch.AbstractBatchDialogPlugin;
import kd.imc.sim.formplugin.issuing.control.BatchInvoiceControl;
import org.apache.commons.lang3.tuple.Pair;

public class VehicleInvoiceBatchPlugin
extends AbstractBatchDialogPlugin {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if (source.getKey().equals("btnok")) {
            PermissionHelper.checkPermission((String)"sim", (String)"sim_vehicles_wait", (long)Long.parseLong(this.getPageCache().get("orgid")), (ImcPermItemEnum)ImcPermItemEnum.IMC_SIM_INVOICE);
            this.issueInvoice();
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"customcontrolap"});
        Object firstId = this.getIssueIds()[0];
        DynamicObject waitDynamic = BusinessDataServiceHelper.loadSingle((Object)firstId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice_vehicles"));
        this.getPageCache().put("orgid", String.valueOf(DynamicObjectUtil.getDynamicObjectLongValue((Object)waitDynamic.get("orgid"))));
        String invoiceType = waitDynamic.getString("invoicetype");
        if (InvoiceUtils.isAllEVehicleInv((String)invoiceType) || InvoiceUtils.isUsedCarInvoice((Object)invoiceType)) {
            this.initAccountListAndSetDefault(waitDynamic);
        } else {
            this.setJqbh(waitDynamic);
        }
        this.setTotalCount();
        this.setListFilter();
    }

    private void initAccountListAndSetDefault(DynamicObject waitDynamic) {
        this.getView().setVisible(Boolean.TRUE, new String[]{"account"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"jqbh"});
        String account = waitDynamic.getString("account");
        String salerTaxNo = waitDynamic.getString("salertaxno");
        if (InvoiceUtils.isUsedCarInvoice((Object)waitDynamic.getString("invoicetype"))) {
            salerTaxNo = waitDynamic.getString("issuetaxno");
        }
        DynamicObject accountObj = AllEleAuthHelper.getAccountByTaxNo((String)salerTaxNo);
        Pair accountList = AllEleAuthHelper.getAccountList((DynamicObject)accountObj, (boolean)true);
        ViewUtil.setDropDownViewData((AbstractFormPlugin)this, (String)"account", (Map)((Map)accountList.getValue()));
        this.getModel().setValue("account", (Object)account);
    }

    private void setJqbh(DynamicObject waitDynamic) {
        this.getView().setVisible(Boolean.TRUE, new String[]{"jqbh"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"account"});
        String jqbh = waitDynamic.getString("jqbh");
        this.getModel().setValue("jqbh", (Object)jqbh);
        long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)waitDynamic.get("orgid"));
        orgId = orgId == 0L ? RequestContext.get().getOrgId() : orgId;
        EquipmentUtil.bindDefaultDev((AbstractFormPlugin)this, (String)"jqbh", (Long)orgId, (String)EquipmentUtil.getDefaultDevNoByOrg((Long)orgId));
    }

    private void setTotalCount() {
        String selectFields = String.join((CharSequence)",", "totalamount", "totaltax", "invoiceamount");
        Object[] ids = this.getIssueIds();
        QFilter[] qFilters = new QFilter("id", "in", (Object)ids).toArray();
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal taxAmount = BigDecimal.ZERO;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"sim_vatinvoice_vehicles", (String)selectFields, (QFilter[])qFilters, (String)"id");){
            if (ds != null) {
                for (Row data : ds) {
                    totalAmount = totalAmount.add(data.getBigDecimal("totalamount"));
                    taxAmount = taxAmount.add(data.getBigDecimal("totaltax"));
                }
            }
        }
        String format = String.format(ResManager.loadKDString((String)"\u603b\u8ba1\uff1a\u5f00\u7968\u4efd\u6570 %1$s \u4efd\uff0c\u4ef7\u7a0e\u5408\u8ba1 %2$s \u5143\uff0c\u7a0e\u989d %3$s \u5143\u3002", (String)"VehicleInvoiceBatchPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]), ids.length, totalAmount.setScale(2, 4), taxAmount.setScale(2, 4));
        this.getModel().setValue("labelap", (Object)format);
    }

    public String getOrderBy() {
        DynamicObject issueInvSetting = BusinessDataServiceHelper.loadSingleFromCache((String)"bdm_issue_inv_setting", (QFilter[])new QFilter("org", "=", (Object)Long.parseLong(this.getPageCache().get("orgid"))).toArray());
        String orderBy = "billno";
        if (null != issueInvSetting) {
            orderBy = issueInvSetting.getString("issueinvoiceorder");
        }
        switch (orderBy) {
            case "batchbelong": {
                orderBy = "batchno";
                break;
            }
            case "splitorder": {
                orderBy = "billno";
            }
        }
        return orderBy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void issueInvoice() {
        try {
            DynamicObject[] batchList = this.getDynamicObjects("sim_vatinvoice_vehicles");
            String invoiceType = batchList[0].getString("invoicetype");
            String devNo = (String)this.getModel().getValue("jqbh");
            String account = (String)this.getModel().getValue("account");
            if (InvoiceUtils.isAllEVehicleInv((String)invoiceType) || InvoiceUtils.isUsedCarInvoice((Object)invoiceType)) {
                if (StringUtils.isBlank((CharSequence)account)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u4e2a\u6570\u7535\u8d26\u53f7", (String)"VehicleInvoiceBatchPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    return;
                }
            } else if (StringUtils.isBlank((CharSequence)devNo)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u4e2a\u8bbe\u5907", (String)"VehicleInvoiceBatchPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u5f00\u7968\u4e2d", (String)"VehicleInvoiceBatchPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0])));
            BatchInvoiceControl.doBatchVehicleInvoice((String)devNo, (String)account, (DynamicObject[])batchList);
            this.getView().returnDataToParent((Object)"success");
            this.getView().close();
        }
        catch (MsgException exception) {
            this.getView().showErrorNotification(exception.getErrorMsg());
        }
        catch (Exception exception) {
            this.getView().showErrorNotification(exception.getMessage());
        }
        finally {
            this.getView().hideLoading();
        }
    }
}

