/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.vehicle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.ComponentInterfaceTypeEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.PrintTypeEnum;
import kd.imc.bdm.common.constant.TaxRate;
import kd.imc.bdm.common.constant.allele.AllEleInterfaceTypeEnum;
import kd.imc.bdm.common.dto.ComponentRequest;
import kd.imc.bdm.common.dto.ComponentResponse;
import kd.imc.bdm.common.dto.MoudleDataDTO;
import kd.imc.bdm.common.dto.allele.AllEleRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseDTO;
import kd.imc.bdm.common.dto.allele.AllEleVehicleRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleVehicleResponseDTO;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.AddressSplitHelper;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.ComponentServiceHelper;
import kd.imc.bdm.common.helper.DrawerStrategyHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.model.DrawerInfo;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.ConvertUpMoneyUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.ModelUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.UUID;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.dto.vehicle.VehicleInvoiceIssueResponseDTO;
import kd.imc.sim.common.service.IssueInvoiceService;
import kd.imc.sim.common.utils.DeviceUtil;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.common.utils.TaxCalcUtil;
import kd.imc.sim.formplugin.issuing.helper.IssueInvoiceHelper;
import kd.imc.sim.mq.consumer.service.IssueVehicleInvoiceServiceImpl;
import org.apache.commons.lang3.tuple.Pair;

public class VehicleInvoiceFormPlugin
extends AbstractFormPlugin {
    public static final String OPENINVOICE = "openinvoice";
    public static final String QUERY_VEHICLE_IDCODE = "queryvehicleidcode";
    public static final String SIM_FILL_VIHICLE_CODE = "sim_fill_vihicle_code";
    public static final String BTN_PREVIEW = "btn_preview";
    private static final Log LOGGER = LogFactory.getLog(VehicleInvoiceFormPlugin.class);

    public void afterCreateNewData(EventObject e) {
        boolean isVisible = false;
        try {
            boolean isPrintPage = this.getView().getFormShowParameter().getCustomParams().containsKey("vechiclePrint");
            String uuid = (String)this.getView().getFormShowParameter().getCustomParams().get("vechiclePrint");
            if (isPrintPage) {
                String pkValue = CacheHelper.get((String)String.valueOf(uuid));
                DynamicObject[] invoiceList = null;
                if (StringUtils.isNotBlank((CharSequence)pkValue)) {
                    QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(pkValue));
                    invoiceList = BusinessDataServiceHelper.load((String)"sim_vatinvoice_vehicles", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice_vehicles", (boolean)true), (QFilter[])filter.toArray());
                    this.getPageCache().put("id", pkValue);
                }
                if (invoiceList == null || invoiceList.length == 0) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"toolbarap", "flexpanelap12", "flexpanelap9"});
                    this.getView().showTipNotification(ApiErrCodeEnum.VEHICLE_INVOICE_PRINT_NO_INVOICE.getMsg());
                } else {
                    ModelUtil.setModelAndEntryValueFromDynamicObject((DynamicObject)invoiceList[0], (AbstractFormPlugin)this, (boolean)true);
                    String salerTaxNo = (String)this.getModel().getValue("salertaxno");
                    DynamicObject accountObj = AllEleAuthHelper.getAccountByTaxNo((String)salerTaxNo);
                    boolean isVirtual = StringUtils.isNotBlank((CharSequence)ImcConfigUtil.getValue((String)"all_ele_mock_invoice", (String)salerTaxNo));
                    if (null == accountObj && !isVirtual) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9500\u65b9\u672a\u914d\u7f6e\u6570\u7535\u8d26\u53f7", (String)"VehicleInvoiceFormPlugin_11", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(7000));
                        return;
                    }
                    Pair accountList = AllEleAuthHelper.getAccountList((DynamicObject)accountObj, (boolean)true);
                    ViewUtil.setDropDownViewData((AbstractFormPlugin)this, (String)"account", (Map)((Map)accountList.getValue()));
                    this.getModel().setValue("account", (Object)invoiceList[0].getString("account"));
                    this.setTotalAmountUp();
                    this.getView().setEnable(Boolean.FALSE, new String[]{"flexpanelap12", "", "flexpanelap9"});
                    isVisible = true;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{OPENINVOICE, QUERY_VEHICLE_IDCODE, "refresh", "close"});
            } else {
                this.initData();
            }
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            this.getView().showErrorNotification(ex.getMessage());
        }
        this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{"print", "downloadtool"});
        this.getView().setEnable(Boolean.valueOf(isVisible), new String[]{"print", "downloadtool"});
        if (InvoiceUtils.isAllEVehicleInv((String)((String)this.getModel().getValue("invoicetype")))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{QUERY_VEHICLE_IDCODE});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{QUERY_VEHICLE_IDCODE});
        }
    }

    private void initData() {
        long orgId = this.getOrgId();
        this.getModel().setValue("orgid", (Object)orgId);
        this.getModel().setValue("billno", (Object)("200_" + UUID.getBatchNumber() + "_0001"));
        this.getModel().setValue("orderno", (Object)("vehicle_" + UUID.next()));
        this.getModel().setValue("billsource", (Object)"2");
        this.setDrawer(orgId);
        this.setSaleInfo(orgId);
        String invoiceType = (String)this.getModel().getValue("invoicetype");
        if (InvoiceUtils.isAllEVehicleInv((String)invoiceType)) {
            this.initAccountListAndSetDefault();
        } else {
            EquipmentUtil.bindDevNoByOrg((AbstractFormPlugin)this, (String)"jqbh", (Long)orgId, null);
        }
    }

    private void initAccountListAndSetDefault() {
        String salerTaxNo = (String)this.getModel().getValue("issuetaxno");
        if (StringUtils.isBlank((CharSequence)salerTaxNo)) {
            salerTaxNo = (String)this.getModel().getValue("salertaxno");
        }
        DynamicObject accountObj = AllEleAuthHelper.getAccountByTaxNo((String)salerTaxNo);
        boolean isVirtual = StringUtils.isNotBlank((CharSequence)ImcConfigUtil.getValue((String)"all_ele_mock_invoice", (String)salerTaxNo));
        if (null == accountObj && !isVirtual) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9500\u65b9\u672a\u914d\u7f6e\u6570\u7535\u8d26\u53f7", (String)"VehicleInvoiceFormPlugin_11", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(7000));
            return;
        }
        Pair accountList = AllEleAuthHelper.getAccountList((DynamicObject)accountObj, (boolean)true);
        ViewUtil.setDropDownViewData((AbstractFormPlugin)this, (String)"account", (Map)((Map)accountList.getValue()));
        if (null != accountObj) {
            String defaultAccount = AllEleAuthHelper.getEpDefaultAccount((DynamicObject)accountObj, (boolean)true, (boolean)false);
            this.getModel().setValue("account", (Object)defaultAccount);
        }
    }

    private long getOrgId() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("orgid");
        long orgId = org == null ? RequestContext.get().getOrgId() : DynamicObjectUtil.getDynamicObjectLongValue((Object)org);
        return orgId;
    }

    private void setSaleInfo(long orgId) {
        Object invoiceType = this.getModel().getValue("invoicetype");
        SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)orgId);
        this.changeIssueWay(saleInfo);
        this.setIssuerInfo(invoiceType, saleInfo);
    }

    private void setIssuerInfo(Object invoiceType, SaleInfo saleInfo) {
        block5: {
            if (InvoiceUtils.isUsedCarInvoice((Object)invoiceType)) {
                try {
                    this.getModel().setValue("issuename", (Object)saleInfo.getSaleName());
                    this.getModel().setValue("issuetaxno", (Object)saleInfo.getSaleTaxNo());
                    DynamicObject saleDynamicObject = TaxUtils.getSaleAddrBankByOrg((SaleInfo)saleInfo);
                    if (saleDynamicObject != null) {
                        Pair bankAndAccPair = AddressSplitHelper.splitBankAndName((String)saleDynamicObject.getString("openuserbank"));
                        this.getView().getModel().setValue("issuebankname", bankAndAccPair.getKey());
                        this.getView().getModel().setValue("issuebankaccount", bankAndAccPair.getValue());
                        Pair addrPhonePair = AddressSplitHelper.splitAddressAndTel((String)saleDynamicObject.getString("invoiceaddr"));
                        this.getView().getModel().setValue("issueaddress", addrPhonePair.getKey());
                        this.getView().getModel().setValue("issuephone", addrPhonePair.getValue());
                        break block5;
                    }
                    this.setVehicleInfoNull("issuebankname", "issuebankaccount", "issueaddress", "issuephone");
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    this.getView().showErrorNotification(e.getMessage());
                }
            } else {
                this.setVehicleInfoNull("issuename", "issuetaxno", "issuebankname", "issuebankaccount", "issueaddress", "issuephone");
            }
        }
    }

    private void changeIssueWay(SaleInfo saleInfo) {
        Object issueWay = this.getModel().getValue("issueway");
        Object invoiceType = this.getModel().getValue("invoicetype");
        if ("07".equals(this.getModel().getValue("usedcarenterprisenature")) && InvoiceUtils.isUsedCarInvoice((Object)invoiceType)) {
            if ("1".equals(issueWay)) {
                this.setVehicleInfoNull("buyername", "buyertaxno", "buyeraddr", "buyerphone", "buyerproperty");
                this.getView().setEnable(Boolean.TRUE, new String[]{"buyername", "buyertaxno", "buyeraddr", "buyerphone", "buyerproperty", "salerproperty"});
            } else {
                this.setVehicleInfoNull("salerbankname", "saleraccount", "saleraddress", "salerphone", "salerproperty", "salername", "salertaxno");
                this.getView().setEnable(Boolean.TRUE, new String[]{"salerbankname", "saleraccount", "saleraddress", "salerphone", "salerproperty", "salername", "salertaxno"});
            }
            return;
        }
        if ("1".equals(issueWay) && InvoiceUtils.isUsedCarInvoice((Object)invoiceType)) {
            try {
                this.getModel().setValue("buyername", (Object)saleInfo.getSaleName());
                this.getModel().setValue("buyertaxno", (Object)saleInfo.getSaleTaxNo());
                DynamicObject saleDynamicObject = TaxUtils.getSaleAddrBankByOrg((SaleInfo)saleInfo);
                if (saleDynamicObject != null) {
                    Pair addrPhonePair = AddressSplitHelper.splitAddressAndTel((String)saleDynamicObject.getString("invoiceaddr"));
                    this.getView().getModel().setValue("buyeraddr", addrPhonePair.getKey());
                    this.getView().getModel().setValue("buyerphone", addrPhonePair.getValue());
                } else {
                    this.setVehicleInfoNull("buyeraddr", "buyerphone");
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                this.getView().showErrorNotification(e.getMessage());
            }
            this.setVehicleInfoNull("salername", "salertaxno", "salerbankname", "saleraccount", "saleraddress", "salerphone");
            this.getModel().setValue("buyerproperty", (Object)"0");
            this.getModel().setValue("salerproperty", (Object)"1");
            this.getView().setEnable(Boolean.FALSE, new String[]{"salerproperty"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"buyerproperty", "buyername", "buyertaxno"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"salername", "salertaxno"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"buyercardtype", "buyernation"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"cardtype", "nation"});
            this.setVehicleInfoNull("buyercardtype", "buyernation");
        } else {
            try {
                this.getModel().setValue("salername", (Object)saleInfo.getSaleName());
                this.getModel().setValue("salertaxno", (Object)saleInfo.getSaleTaxNo());
                DynamicObject saleDynamicObject = TaxUtils.getSaleAddrBankByOrg((SaleInfo)saleInfo);
                if (saleDynamicObject != null) {
                    Pair bankAndAccPair = AddressSplitHelper.splitBankAndName((String)saleDynamicObject.getString("openuserbank"));
                    this.getView().getModel().setValue("salerbankname", bankAndAccPair.getKey());
                    this.getView().getModel().setValue("saleraccount", bankAndAccPair.getValue());
                    Pair addrPhonePair = AddressSplitHelper.splitAddressAndTel((String)saleDynamicObject.getString("invoiceaddr"));
                    this.getView().getModel().setValue("saleraddress", addrPhonePair.getKey());
                    this.getView().getModel().setValue("salerphone", addrPhonePair.getValue());
                } else {
                    this.setVehicleInfoNull("salerbankname", "saleraccount", "saleraddress", "salerphone");
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                this.getView().showErrorNotification(e.getMessage());
            }
            this.setVehicleInfoNull("buyername", "buyertaxno", "buyeraddr", "buyerphone");
            this.getModel().setValue("salerproperty", (Object)"0");
            this.getView().setEnable(Boolean.FALSE, new String[]{"salerproperty"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"buyerproperty"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"buyername", "buyertaxno"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"salername", "salertaxno"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"cardtype", "nation"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"buyercardtype", "buyernation"});
            this.setVehicleInfoNull("cardtype", "nation");
        }
    }

    private void setAllCaption() {
        TextEdit salerPhoneControl;
        TextEdit salerAddressControl;
        TextEdit salerNameControl;
        TextEdit salerTaxNoControl;
        Object issueWay = this.getModel().getValue("issueway");
        Object invoiceType = this.getModel().getValue("invoicetype");
        if (InvoiceUtils.isUsedCarInvoice((Object)invoiceType)) {
            salerTaxNoControl = (TextEdit)this.getView().getControl("salertaxno");
            salerTaxNoControl.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5356\u65b9\u5355\u4f4d\u4ee3\u7801/\u8eab\u4efd\u8bc1\u53f7\u7801", (String)"VehicleInvoiceFormPlugin_13", (String)"imc-sim-formplugin", (Object[])new Object[0])));
            salerNameControl = (TextEdit)this.getView().getControl("salername");
            salerNameControl.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5356\u65b9\u5355\u4f4d/\u4e2a\u4eba", (String)"VehicleInvoiceFormPlugin_14", (String)"imc-sim-formplugin", (Object[])new Object[0])));
            salerAddressControl = (TextEdit)this.getView().getControl("saleraddress");
            salerAddressControl.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5356\u65b9\u5355\u4f4d/\u4e2a\u4eba\u4f4f\u5740", (String)"VehicleInvoiceFormPlugin_15", (String)"imc-sim-formplugin", (Object[])new Object[0])));
            salerPhoneControl = (TextEdit)this.getView().getControl("salerphone");
            salerPhoneControl.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5356\u65b9\u7535\u8bdd", (String)"VehicleInvoiceFormPlugin_16", (String)"imc-sim-formplugin", (Object[])new Object[0])));
        } else {
            salerTaxNoControl = (TextEdit)this.getView().getControl("salertaxno");
            salerTaxNoControl.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", (String)"VehicleInvoiceFormPlugin_17", (String)"imc-sim-formplugin", (Object[])new Object[0])));
            salerNameControl = (TextEdit)this.getView().getControl("salername");
            salerNameControl.setCaption(new LocaleString(ResManager.loadKDString((String)"\u9500\u8d27\u65b9\u5355\u4f4d\u540d\u79f0", (String)"VehicleInvoiceFormPlugin_18", (String)"imc-sim-formplugin", (Object[])new Object[0])));
            salerAddressControl = (TextEdit)this.getView().getControl("saleraddress");
            salerAddressControl.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5355\u4f4d\u4f4f\u5740", (String)"VehicleInvoiceFormPlugin_19", (String)"imc-sim-formplugin", (Object[])new Object[0])));
            salerPhoneControl = (TextEdit)this.getView().getControl("salerphone");
            salerPhoneControl.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7535\u8bdd", (String)"VehicleInvoiceFormPlugin_20", (String)"imc-sim-formplugin", (Object[])new Object[0])));
        }
        salerTaxNoControl = (TextEdit)this.getView().getControl("salertaxno");
        String caption = ResManager.loadKDString((String)"\u9500\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", (String)"VehicleInvoiceFormPlugin_21", (String)"imc-sim-formplugin", (Object[])new Object[0]);
        if (InvoiceUtils.isUsedCarInvoice((Object)invoiceType)) {
            caption = "1".equals(issueWay) ? ResManager.loadKDString((String)"\u5356\u65b9\u81ea\u7136\u4eba\u8bc1\u4ef6\u53f7\u7801", (String)"VehicleInvoiceFormPlugin_22", (String)"imc-sim-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5356\u65b9\u5355\u4f4d\u4ee3\u7801/\u8eab\u4efd\u8bc1\u53f7\u7801", (String)"VehicleInvoiceFormPlugin_13", (String)"imc-sim-formplugin", (Object[])new Object[0]);
        }
        salerTaxNoControl.setCaption(new LocaleString(caption));
        TextEdit buyerTaxNoControl = (TextEdit)this.getView().getControl("buyertaxno");
        String buyerTaxNoCaption = ResManager.loadKDString((String)"\u8d2d\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", (String)"VehicleInvoiceFormPlugin_23", (String)"imc-sim-formplugin", (Object[])new Object[0]);
        if (InvoiceUtils.isUsedCarInvoice((Object)invoiceType)) {
            buyerTaxNoCaption = ResManager.loadKDString((String)"\u4e70\u65b9\u5355\u4f4d\u4ee3\u7801/\u8eab\u4efd\u8bc1\u53f7\u7801", (String)"VehicleInvoiceFormPlugin_24", (String)"imc-sim-formplugin", (Object[])new Object[0]);
        }
        buyerTaxNoControl.setCaption(new LocaleString(buyerTaxNoCaption));
    }

    private void setDrawer(long orgId) {
        String jqbh = (String)this.getModel().getValue("jqbh");
        DynamicObject bill = BusinessDataServiceHelper.newDynamicObject((String)"sim_original_bill");
        bill.set("drawer", (Object)RequestContext.get().getUserName());
        bill.set("orgid", (Object)orgId);
        DrawerInfo info = DrawerStrategyHelper.getOriginalBillDrawerStrategy((Object)jqbh, (DynamicObject)bill);
        this.getModel().setValue("drawer", (Object)info.getDrawer());
    }

    public void afterBindData(EventObject e) {
        boolean notIssueStatus;
        String invoiceType = (String)this.getModel().getValue("invoicetype");
        try {
            boolean isPrintPage = this.getView().getFormShowParameter().getCustomParams().containsKey("vechiclePrint");
            if (!isPrintPage) {
                long orgId = this.getOrgId();
                EquipmentUtil.bindDevNoByOrgNotDefault((AbstractFormPlugin)this, (long)orgId, (String)"jqbh", null);
                String salerTaxNo = (String)this.getModel().getValue("salertaxno");
                DynamicObject accountObj = AllEleAuthHelper.getAccountByTaxNo((String)salerTaxNo);
                Pair accountList = AllEleAuthHelper.getAccountList((DynamicObject)accountObj, (boolean)true);
                ViewUtil.setDropDownViewData((AbstractFormPlugin)this, (String)"account", (Map)((Map)accountList.getValue()));
                this.setTotalAmountUp();
                if (this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW || IssueStatusEnum.ok.getCode().equals(this.getModel().getValue("issuestatus"))) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{OPENINVOICE, "refresh", BTN_PREVIEW});
                } else if (InvoiceType.PAPER_VEHICLE_INVOICE.getTypeCode().equals(invoiceType)) {
                    this.setNextInvoiceCodeNo();
                }
            }
            this.getView().setVisible(Boolean.valueOf(isPrintPage), new String[]{"print", "downloadtool"});
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            this.getView().showErrorNotification(ex.getMessage());
        }
        this.setAllCaption();
        if (InvoiceUtils.isUsedCarInvoice((Object)invoiceType)) {
            long orgId = this.getOrgId();
            SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)orgId);
            DynamicObject accountObj = AllEleAuthHelper.getAccountByTaxNo((String)saleInfo.getSaleTaxNo());
            Pair accountList = AllEleAuthHelper.getAccountList((DynamicObject)accountObj, (boolean)true);
            ViewUtil.setDropDownViewData((AbstractFormPlugin)this, (String)"account", (Map)((Map)accountList.getValue()));
            Object issueWay = this.getModel().getValue("issueway");
            if ("08".equals(this.getModel().getValue("usedcarenterprisenature"))) {
                if ("1".equals(issueWay)) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"buyerproperty", "buyername", "buyertaxno", "salerproperty"});
                    this.getView().setEnable(Boolean.TRUE, new String[]{"salername", "salertaxno"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"buyernation", "buyercardtype"});
                } else {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"salerproperty", "salername", "salertaxno"});
                    this.getView().setEnable(Boolean.TRUE, new String[]{"buyerproperty", "buyername", "buyertaxno"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"nation", "cardtype"});
                }
            } else {
                Object buyerProperty = this.getModel().getValue("buyerproperty");
                if ("1".equals(buyerProperty)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"buyernation", "buyercardtype"});
                    this.getView().setEnable(Boolean.TRUE, new String[]{"buyernation", "buyercardtype"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"buyernation", "buyercardtype"});
                    this.getView().setEnable(Boolean.FALSE, new String[]{"buyernation", "buyercardtype"});
                }
                Object salerProperty = this.getModel().getValue("salerproperty");
                if ("1".equals(salerProperty)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"nation", "cardtype"});
                    this.getView().setEnable(Boolean.TRUE, new String[]{"nation", "cardtype"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"nation", "cardtype"});
                    this.getView().setEnable(Boolean.FALSE, new String[]{"nation", "cardtype"});
                }
            }
        }
        Object issueStatus = this.getModel().getValue("issuestatus");
        boolean bl = notIssueStatus = IssueStatusEnum.none.getCode().equals(issueStatus) || IssueStatusEnum.failed.getCode().equals(issueStatus);
        if (InvoiceUtils.isAllEVehicleInv((String)invoiceType) && notIssueStatus) {
            this.getView().setVisible(Boolean.TRUE, new String[]{QUERY_VEHICLE_IDCODE});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{QUERY_VEHICLE_IDCODE});
        }
        if (!notIssueStatus) {
            this.getView().setStatus(OperationStatus.VIEW);
        }
        this.getModel().setDataChanged(false);
    }

    public void registerListener(EventObject e) {
        TextEdit textEdit = (TextEdit)this.getView().getControl("buyername");
        textEdit.addClickListener((ClickListener)this);
        this.addClickListeners(new String[]{"goodscode", "salername", "buyeraddr", "saleraddress", "issueaddress"});
        TextEdit vehicleTypeEdit = (TextEdit)this.getView().getControl("vehicletype");
        vehicleTypeEdit.addClickListener((ClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        String taxNo = (String)this.getModel().getValue("issuetaxno");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            taxNo = (String)this.getModel().getValue("salertaxno");
        }
        QFilter qFilter = new QFilter("taxno", "=", (Object)taxNo);
        switch (key) {
            case "buyername": {
                Object invoiceType = this.getModel().getValue("invoicetype");
                Object issueWay = this.getModel().getValue("issueway");
                Object nature = this.getModel().getValue("usedcarenterprisenature");
                if (InvoiceUtils.isUsedCarInvoice((Object)invoiceType) && "07".equals(nature) && "1".equals(issueWay)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e8c\u624b\u8f66\u5e02\u573a\u4f01\u4e1a\u53cd\u5411\u5f00\u7968\u65f6\u8bf7\u624b\u52a8\u8f93\u5165\u4e70\u65b9\u4fe1\u606f", (String)"VehicleInvoiceValidator_73", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    return;
                }
                ViewUtil.openListPage((AbstractFormPlugin)this, (QFilter)ImcBaseDataHelper.getInvTitleFilter((Object)this.getOrgId()), (String)"bdm_invice_title_strate", (String)"close_call_back_buyer_name");
                break;
            }
            case "vehicletype": {
                ViewUtil.openListPage((AbstractFormPlugin)this, (QFilter)new QFilter("org", "=", (Object)this.getOrgId()), (String)"bdm_vehicle_info", (String)"bdm_vehicle_info");
                break;
            }
            case "goodscode": {
                QFilter filter = new QFilter("sumitem", "=", (Object)false).and("enable", "=", (Object)true);
                ViewUtil.openListPage((AbstractFormPlugin)this, (QFilter)filter, (String)"er_taxclasscode", (String)"goodscode");
                break;
            }
            case "salername": {
                Object invoiceType = this.getModel().getValue("invoicetype");
                Object issueWay = this.getModel().getValue("issueway");
                Object nature = this.getModel().getValue("usedcarenterprisenature");
                if (InvoiceUtils.isUsedCarInvoice((Object)invoiceType) && "07".equals(nature) && "0".equals(issueWay)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e8c\u624b\u8f66\u5e02\u573a\u4f01\u4e1a\u6b63\u5411\u5f00\u7968\u65f6\u8bf7\u624b\u52a8\u8f93\u5165\u5356\u65b9\u4fe1\u606f", (String)"VehicleInvoiceValidator_72", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    return;
                }
                QFilter personFilter = new QFilter("buyertype", "=", (Object)"2");
                if (!InvoiceUtils.isUsedCarInvoice((Object)invoiceType) || !"1".equals(issueWay)) break;
                ViewUtil.openListPage((AbstractFormPlugin)this, (QFilter)ImcBaseDataHelper.getInvTitleFilter((Object)this.getOrgId()).and(personFilter), (String)"bdm_invice_title_strate", (String)"close_call_back_seller_name");
                break;
            }
            case "buyeraddr": {
                Object invoiceType = this.getModel().getValue("invoicetype");
                Object issueWay = this.getModel().getValue("issueway");
                Object nature = this.getModel().getValue("usedcarenterprisenature");
                if (InvoiceUtils.isUsedCarInvoice((Object)invoiceType) && "07".equals(nature) && "1".equals(issueWay)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e8c\u624b\u8f66\u5e02\u573a\u4f01\u4e1a\u53cd\u5411\u5f00\u7968\u65f6\u8bf7\u624b\u52a8\u8f93\u5165\u4e70\u65b9\u5730\u5740\u7b49\u4fe1\u606f", (String)"VehicleInvoiceValidator_75", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    return;
                }
                if ("1".equals(this.getModel().getValue("issueway"))) {
                    ViewUtil.openListPage((AbstractFormPlugin)this, (QFilter)qFilter, (String)"sim_invoice_setting", (String)"buyeraddr");
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b63\u5411\u5f00\u7968\u65f6\uff0c\u8bf7\u901a\u8fc7\u9009\u62e9\u8d2d\u4e70\u65b9\u540d\u79f0\u5e26\u51fa\u5730\u5740\u7535\u8bdd\u7b49\u4fe1\u606f", (String)"VehicleInvoiceListPlugin_18", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                break;
            }
            case "saleraddress": {
                Object invoiceType = this.getModel().getValue("invoicetype");
                Object issueWay = this.getModel().getValue("issueway");
                Object nature = this.getModel().getValue("usedcarenterprisenature");
                if (InvoiceUtils.isUsedCarInvoice((Object)invoiceType) && "07".equals(nature) && "0".equals(issueWay)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e8c\u624b\u8f66\u5e02\u573a\u4f01\u4e1a\u6b63\u5411\u5f00\u7968\u65f6\u8bf7\u624b\u52a8\u8f93\u5165\u5356\u65b9\u5730\u5740\u7b49\u4fe1\u606f", (String)"VehicleInvoiceValidator_74", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!"1".equals(this.getModel().getValue("issueway"))) {
                    ViewUtil.openListPage((AbstractFormPlugin)this, (QFilter)qFilter, (String)"sim_invoice_setting", (String)"saleraddress");
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53cd\u5411\u5f00\u7968\u65f6\uff0c\u8bf7\u901a\u8fc7\u9009\u62e9\u5356\u65b9\u5355\u4f4d/\u4e2a\u4eba\u5e26\u51fa\u5730\u5740\u7535\u8bdd\u7b49\u4fe1\u606f", (String)"VehicleInvoiceListPlugin_17", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                break;
            }
            case "issueaddress": {
                ViewUtil.openListPage((AbstractFormPlugin)this, (QFilter)qFilter, (String)"sim_invoice_setting", (String)"issueaddress");
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "queryvehicleidcode": {
                this.queryVehicleInfo();
                break;
            }
            case "downloadtool": {
                this.getView().openUrl("https://img.piaozone.com/etax-paper-print/etax-paper-print-com.zip");
                break;
            }
            case "print": {
                HashMap<String, Object> customParams = new HashMap<String, Object>(8);
                JSONArray jsonArray = new JSONArray();
                jsonArray.add((Object)Long.parseLong(this.getPageCache().get("id")));
                customParams.put("keys", jsonArray);
                customParams.put("type", PrintTypeEnum.VEHICLE_PRINT.getType());
                customParams.put("invoicetype", this.getModel().getValue("invoicetype"));
                customParams.put("GuestPrint", "GuestPrint");
                ViewUtil.openDialog((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u673a\u52a8\u8f66/\u4e8c\u624b\u8f66\u53d1\u7968\u6253\u5370", (String)"VehicleInvoiceListPlugin_12", (String)"imc-sim-formplugin", (Object[])new Object[0]), customParams, (String)"sim_labelape_print", (String)"sim_labelape_print");
                break;
            }
            case "btn_preview": {
                if (!InvoiceUtils.isAllEVehicleOrAllEUsedCar((String)((String)this.getModel().getValue("invoicetype")))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u76ee\u524d\u4ec5\u652f\u6301\u6570\u7535\u53d1\u7968\u9884\u89c8", (String)"VehicleInvoiceListPlugin_20", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (this.checkInvoiceOrPreview()) break;
                this.invoicePreview();
            }
        }
    }

    private void queryVehicleInfo() {
        String vehicleCode = (String)this.getModel().getValue("vehicleidcode");
        HashMap<String, String> vehicleMap = new HashMap<String, String>();
        vehicleMap.put("vehicleidcode", vehicleCode);
        ViewUtil.openDialog((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u63d0\u793a", (String)"VehicleInvoiceFormPlugin_8", (String)"imc-sim-formplugin", (Object[])new Object[0]), vehicleMap, (String)SIM_FILL_VIHICLE_CODE, (String)SIM_FILL_VIHICLE_CODE);
    }

    private void queryVehicleInfo(String vehicleIdCode) {
        AllEleVehicleRequestDTO requestDto = new AllEleVehicleRequestDTO();
        String account = (String)this.getModel().getValue("account");
        String salerTaxNo = (String)this.getModel().getValue("salertaxno");
        requestDto.setAccount(account);
        requestDto.setChassisNo(vehicleIdCode);
        if (InvoiceUtils.isAllEPaperVehicleInvoice((String)((String)this.getModel().getValue("invoicetype")))) {
            requestDto.setInvoiceType("12");
        } else {
            requestDto.setInvoiceType("83");
        }
        requestDto.setRequest_path(AllEleInterfaceTypeEnum.ELE_PAPER_MOTORVEHICLE_INFO_QUERY.getRequestPath());
        AllEleResponseDTO response = AllEleServiceHelper.doPost((String)salerTaxNo, (AllEleRequestDTO)requestDto, AllEleVehicleResponseDTO.class);
        if (!ErrorType.SUCCESS.getCode().equals(response.getErrcode())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u8f66\u8f86\u4fe1\u606f\u5931\u8d25:%s", (String)"VehicleInvoiceFormPlugin_7", (String)"imc-sim-formplugin", (Object[])new Object[0]), response.getDescription()));
        }
        AllEleVehicleResponseDTO data = (AllEleVehicleResponseDTO)response.getData();
        this.updateViewData(data);
        this.updateViewFromVehicleInfo(data);
    }

    private void updateViewFromVehicleInfo(AllEleVehicleResponseDTO data) {
        Object org = this.getModel().getValue("orgid");
        long orgPk = DynamicObjectUtil.getDynamicObjectLongValue((Object)org);
        QFilter filter = new QFilter("vehicletype", "=", (Object)data.getVehicleType()).and("org", "=", (Object)orgPk);
        DynamicObject[] arrays = BusinessDataServiceHelper.load((String)"bdm_vehicle_info", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_vehicle_info", (boolean)true), (QFilter[])filter.toArray());
        if (arrays.length > 0) {
            this.updateViewFromEleVehicleInfo(arrays[0]);
        }
    }

    private void updateViewData(AllEleVehicleResponseDTO data) {
        this.getModel().setValue("brandmodel", (Object)data.getModel());
        this.getModel().setValue("producingarea", (Object)data.getOrigin());
        this.getModel().setValue("certificatenum", (Object)data.getComplianceNo());
        this.getModel().setValue("importcertificate", (Object)data.getImportNo());
        this.getModel().setValue("enginenum", (Object)data.getEngineNo());
        this.getModel().setValue("vehicleidcode", (Object)data.getChassisNo());
        this.getModel().setValue("totalton", (Object)data.getVehicleWeight());
        this.getModel().setValue("limitepeople", (Object)data.getVehicleCapacity());
        this.getModel().setValue("overtaxcode", (Object)data.getTaxationVoucher());
        this.getModel().setValue("vehicletype", (Object)data.getVehicleType());
        this.getModel().setValue("producingname", (Object)data.getManufacturer());
        this.getModel().setValue("uuid", (Object)data.getVehicleUuid());
        this.getModel().setValue("commodityinspectionnum", (Object)data.getBusinessNo());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get("doNotChangeProperty"))) {
            return;
        }
        switch (e.getProperty().getName()) {
            case "jqbh": {
                this.setNextInvoiceCodeNo();
                break;
            }
            case "totalamount": {
                this.calcTaxAndInvoiceAmount();
                break;
            }
            case "taxrate": {
                this.calcTaxAndInvoiceAmount();
                break;
            }
            case "vehicletype": {
                if (!StringUtils.isBlank((CharSequence)((String)this.getModel().getValue("vehicletype")))) break;
                this.updateVehicleInfo(null);
                break;
            }
            case "invoicetype": {
                this.editInvoiceType(e);
                break;
            }
            case "issueway": {
                long orgId = this.getOrgId();
                SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)orgId);
                Object nature = this.getModel().getValue("usedcarenterprisenature");
                Object issueWay = this.getModel().getValue("issueway");
                if ("1".equals(issueWay) && "07".equals(nature)) {
                    this.getModel().setValue("issueway", (Object)"0");
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e8c\u624b\u8f66\u5e02\u573a\u4f01\u4e1a\u53ea\u80fd\u9009\u62e9\u6b63\u5411\u5f00\u7968\uff0c\u4e0d\u652f\u6301\u53cd\u5411\u5f00\u7968", (String)"VehicleInvoiceValidator_71", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.changeIssueWay(saleInfo);
                break;
            }
            case "usedcarenterprisenature": {
                Object nature = this.getModel().getValue("usedcarenterprisenature");
                Object issueWay = this.getModel().getValue("issueway");
                if ("1".equals(issueWay) && "07".equals(nature)) {
                    this.getModel().setValue("usedcarenterprisenature", (Object)"08");
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e8c\u624b\u8f66\u5e02\u573a\u4f01\u4e1a\u53ea\u80fd\u9009\u62e9\u6b63\u5411\u5f00\u7968\uff0c\u4e0d\u652f\u6301\u53cd\u5411\u5f00\u7968", (String)"VehicleInvoiceValidator_71", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    return;
                }
                long orgId = this.getOrgId();
                SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)orgId);
                this.changeIssueWay(saleInfo);
                break;
            }
            case "buyerproperty": {
                Object buyerProperty = this.getModel().getValue("buyerproperty");
                if (!"1".equals(buyerProperty)) break;
                this.getView().setVisible(Boolean.TRUE, new String[]{"buyernation", "buyercardtype"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"buyernation", "buyercardtype"});
                break;
            }
            case "salerproperty": {
                Object salerProperty = this.getModel().getValue("salerproperty");
                if (!"1".equals(salerProperty)) break;
                this.getView().setVisible(Boolean.TRUE, new String[]{"nation", "cardtype"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"nation", "cardtype"});
            }
        }
        this.setAllCaption();
    }

    private void editInvoiceType(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        long orgId = this.getOrgId();
        if (InvoiceType.PAPER_VEHICLE_INVOICE.getTypeCode().equals(newValue)) {
            EquipmentUtil.bindDevNoByOrg((AbstractFormPlugin)this, (String)"jqbh", (Long)orgId, null);
            this.getModel().setValue("account", null);
            this.getModel().setValue("version", (Object)"1");
        } else {
            this.initAccountListAndSetDefault();
            this.getModel().setValue("jqbh", null);
        }
        Object invoiceType = this.getModel().getValue("invoicetype");
        SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)orgId);
        this.setIssuerInfo(invoiceType, saleInfo);
        this.setBuyerAndSalerInfo(saleInfo);
        if (InvoiceUtils.isUsedCarInvoice((Object)invoiceType)) {
            String usedCarEnterpriseNature = "08";
            DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bdm_org");
            if (null != org) {
                QFilter filter = new QFilter("epinfo", "=", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)org.get("epinfo")));
                DynamicObject[] epInfos = BusinessDataServiceHelper.load((String)"bdm_enterprise_info", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_enterprise_info", (boolean)true), (QFilter[])filter.toArray());
                if (epInfos.length > 0) {
                    String tobaccoMark = epInfos[0].getString("tobaccomark");
                    if ("8".equals(tobaccoMark)) {
                        usedCarEnterpriseNature = "08";
                    }
                    if ("9".equals(tobaccoMark)) {
                        usedCarEnterpriseNature = "07";
                    }
                }
            }
            this.getModel().setValue("usedcarenterprisenature", (Object)usedCarEnterpriseNature);
        }
        if (InvoiceUtils.isAllEVehicleInv((String)((String)invoiceType))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{QUERY_VEHICLE_IDCODE});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{QUERY_VEHICLE_IDCODE});
        }
    }

    private void setBuyerAndSalerInfo(SaleInfo saleInfo) {
        this.changeIssueWay(saleInfo);
    }

    private String toChinese(String str) {
        String upStr = ConvertUpMoneyUtils.toChinese((String)str);
        if (upStr.endsWith("\u5706")) {
            upStr = upStr + "\u6574";
        }
        return upStr;
    }

    private void calcTaxAndInvoiceAmount() {
        this.setTotalAmountUp();
        BigDecimal totalAmount = (BigDecimal)this.getModel().getValue("totalamount");
        if (MathUtils.isNullOrZero((BigDecimal)totalAmount)) {
            return;
        }
        String taxRate = (String)this.getModel().getValue("taxrate");
        BigDecimal tax = TaxCalcUtil.calTax((BigDecimal)totalAmount, (BigDecimal)BigDecimal.ZERO, (String)taxRate, (boolean)true);
        this.getModel().setValue("totaltax", (Object)tax);
        this.getModel().setValue("invoiceamount", (Object)totalAmount.subtract(tax).setScale(2, 4));
    }

    private void setTotalAmountUp() {
        BigDecimal totalAmount = (BigDecimal)this.getModel().getValue("totalamount");
        this.getModel().setValue("totalamountstr", (Object)this.toChinese(MathUtils.isNullOrZero((BigDecimal)totalAmount) ? "0.00" : totalAmount.toString()));
        this.getView().updateView("totalamountstr");
    }

    private void updateVehicleInfo(DynamicObject vehicle) {
        try {
            this.getPageCache().put("doNotChangeProperty", "doNotChangeProperty");
            if (InvoiceUtils.isAllEVehicleInv((String)((String)this.getModel().getValue("invoicetype")))) {
                if (vehicle == null) {
                    return;
                }
                this.updateViewFromEleVehicleInfo(vehicle);
            } else {
                if (vehicle == null) {
                    this.setVehicleInfoNull("vehicletype", "brandmodel", "producingarea", "producingname", "taxrate", "goodscode", "zerotaxmark", "taxpremark", "zzstsgl");
                    return;
                }
                this.updateVehicleTypeBaseInfo(vehicle);
            }
        }
        finally {
            this.getPageCache().remove("doNotChangeProperty");
        }
    }

    private void updateViewFromEleVehicleInfo(DynamicObject vehicle) {
        this.getModel().setValue("taxrate", vehicle.get("taxrate"));
        this.getModel().setValue("goodscode", (Object)vehicle.getDynamicObject("goodscode").getString("mergecode"));
        this.getModel().setValue("zerotaxmark", vehicle.get("zerotaxmark"));
        this.getModel().setValue("taxpremark", vehicle.get("taxpremark"));
        this.getModel().setValue("zzstsgl", vehicle.get("zzstsgl"));
        if (StringUtils.isBlank((Object)this.getModel().getValue("vehicletype"))) {
            this.getModel().setValue("vehicletype", vehicle.get("vehicletype"));
        }
        if (StringUtils.isBlank((Object)this.getModel().getValue("brandmodel"))) {
            this.getModel().setValue("brandmodel", vehicle.get("brandmodel"));
        }
        if (StringUtils.isBlank((Object)this.getModel().getValue("producingarea"))) {
            this.getModel().setValue("producingarea", vehicle.get("producingarea"));
        }
        if (StringUtils.isBlank((Object)this.getModel().getValue("producingname"))) {
            this.getModel().setValue("producingname", vehicle.get("producingname"));
        }
    }

    private void updateVehicleTypeBaseInfo(DynamicObject vehicle) {
        this.getModel().setValue("vehicletype", vehicle.get("vehicletype"));
        this.getModel().setValue("brandmodel", vehicle.get("brandmodel"));
        this.getModel().setValue("producingarea", vehicle.get("producingarea"));
        this.getModel().setValue("producingname", vehicle.get("producingname"));
        this.getModel().setValue("taxrate", vehicle.get("taxrate"));
        this.getModel().setValue("goodscode", (Object)vehicle.getDynamicObject("goodscode").getString("mergecode"));
        this.getModel().setValue("zerotaxmark", vehicle.get("zerotaxmark"));
        this.getModel().setValue("taxpremark", vehicle.get("taxpremark"));
        this.getModel().setValue("zzstsgl", vehicle.get("zzstsgl"));
    }

    private void setVehicleInfoNull(String ... keys) {
        for (String key : keys) {
            this.getModel().setValue(key, null);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (StringUtils.equalsIgnoreCase((CharSequence)OPENINVOICE, (CharSequence)((FormOperate)args.getSource()).getOperateKey())) {
            args.setCancel(this.checkInvoiceOrPreview());
        }
    }

    private boolean checkInvoiceOrPreview() {
        boolean isVirtual;
        JSONObject json = new JSONObject();
        json.put("salertaxno", this.getModel().getValue("salertaxno"));
        String invoiceType = (String)this.getModel().getValue("invoicetype");
        String issueTaxNo = (String)this.getModel().getValue("salertaxno");
        if (InvoiceUtils.isUsedCarInvoice((Object)invoiceType)) {
            issueTaxNo = (String)this.getModel().getValue("issuetaxno");
        }
        if (!(isVirtual = StringUtils.isNotBlank((CharSequence)ImcConfigUtil.getValue((String)"all_ele_mock_invoice", (String)issueTaxNo))) && StringUtils.isBlank((Object)this.getModel().getValue("account")) && (InvoiceUtils.isAllEVehicleInv((String)invoiceType) || InvoiceUtils.isUsedCarInvoice((Object)invoiceType))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u7535\u8d26\u53f7", (String)"VehicleInvoiceFormPlugin_12", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(7000));
            return true;
        }
        if (InvoiceUtils.isAllEVehicleInv((String)invoiceType)) {
            json.put("account", this.getModel().getValue("account"));
            if (AllEleServiceHelper.isNeedLogin((AbstractFormPlugin)this, (Map)json)) {
                return true;
            }
            String vehicleType = (String)this.getModel().getValue("vehicletype");
            if (StringUtils.isNotBlank((CharSequence)vehicleType) && StringUtils.isBlank((Object)this.getModel().getValue("uuid"))) {
                AllEleVehicleRequestDTO requestDto = new AllEleVehicleRequestDTO();
                String account = (String)this.getModel().getValue("account");
                String salerTaxNo = (String)this.getModel().getValue("salertaxno");
                requestDto.setAccount(account);
                requestDto.setChassisNo(vehicleType);
                if (InvoiceUtils.isAllEPaperVehicleInvoice((String)invoiceType)) {
                    requestDto.setInvoiceType("12");
                } else {
                    requestDto.setInvoiceType("83");
                }
                requestDto.setRequest_path(AllEleInterfaceTypeEnum.ELE_PAPER_MOTORVEHICLE_INFO_QUERY.getRequestPath());
                AllEleResponseDTO response = AllEleServiceHelper.doPost((String)salerTaxNo, (AllEleRequestDTO)requestDto, AllEleVehicleResponseDTO.class);
                if (ErrorType.SUCCESS.getCode().equals(response.getErrcode())) {
                    this.getModel().setValue("uuid", (Object)((AllEleVehicleResponseDTO)response.getData()).getVehicleUuid());
                } else {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u673a\u52a8\u8f66uuid\u5931\u8d25:%s", (String)"VehicleInvoiceFormPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]), response.getDescription()));
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (OPENINVOICE.equals(operateKey)) {
            try {
                OperationResult result = afterDoOperationEventArgs.getOperationResult();
                if (result.isSuccess()) {
                    this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u5f00\u7968\u4e2d", (String)"VehicleInvoiceFormPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0])));
                    result.setShowMessage(false);
                    Object vehicleId = result.getSuccessPkIds().get(0);
                    DynamicObject vehicle = BusinessDataServiceHelper.loadSingle(vehicleId, (String)"sim_vatinvoice_vehicles");
                    String invoiceType = vehicle.getString("invoicetype");
                    boolean isGold3VehicleInv = InvoiceType.PAPER_VEHICLE_INVOICE.getTypeCode().equals(invoiceType);
                    VehicleInvoiceIssueResponseDTO response = IssueVehicleInvoiceServiceImpl.issueAllVehicleInvoice(vehicle);
                    IssueInvoiceService.handleVehicleInvoiceIssueResponse((VehicleInvoiceIssueResponseDTO)response, (DynamicObject)vehicle);
                    if (ErrorType.SUBMITED.getCode().equals(response.getErrorCode())) {
                        this.getView().invokeOperation("refresh");
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u5f00\u7968\u6210\u529f", (String)"VehicleInvoiceFormPlugin_9", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                        this.resetView();
                    } else if (ErrorType.SUCCESS.getCode().equals(response.getErrorCode()) && isGold3VehicleInv) {
                        this.getView().invokeOperation("refresh");
                        IssueInvoiceService.openPrintDialog((AbstractFormPlugin)this, (DynamicObject)vehicle);
                        this.resetView();
                    } else if (ErrorType.SUCCESS.getCode().equals(response.getErrorCode())) {
                        this.getView().invokeOperation("refresh");
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5f00\u7968\u6210\u529f", (String)"VehicleInvoiceFormPlugin_10", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                        this.resetView();
                    } else {
                        this.getView().showErrorNotification(response.getDescription());
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                this.getView().showErrorNotification(e.getMessage());
            }
            finally {
                this.getView().hideLoading();
            }
        }
    }

    private void resetView() {
        this.getView().setVisible(Boolean.FALSE, new String[]{OPENINVOICE, QUERY_VEHICLE_IDCODE, "refresh"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"flexpanelap", "flexpanelap3", "flexpanelap4", "flexpanelap6", "flexpanelap5"});
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "close_call_back_buyer_name": {
                ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                Object primaryKeyValue = returnData.get(0).getPrimaryKeyValue();
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"bdm_invice_title_strate", (String)String.join((CharSequence)",", "name", "buyertype", "idcode", "taxno"));
                this.updateBuyerTitleView(dynamicObject);
                break;
            }
            case "close_call_back_seller_name": {
                ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                Object primaryKeyValue = returnData.get(0).getPrimaryKeyValue();
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"bdm_invice_title_strate", (String)String.join((CharSequence)",", "name", "buyertype", "idcode", "taxno"));
                this.updateSalerTitleView(dynamicObject);
                break;
            }
            case "bdm_vehicle_info": {
                ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                Object primaryKeyValue = returnData.get(0).getPrimaryKeyValue();
                DynamicObject vehicleInfo = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"bdm_vehicle_info");
                this.updateVehicleInfo(vehicleInfo);
                break;
            }
            case "callback_sim_invoice_print_confirm": {
                IssueInvoiceHelper.handleInvoicePrinterConfirm(this, closedCallBackEvent);
                break;
            }
            case "sim_fill_vihicle_code": {
                String vihicleCode = (String)closedCallBackEvent.getReturnData();
                if (!StringUtils.isNotBlank((CharSequence)vihicleCode)) break;
                this.queryVehicleInfo(vihicleCode);
                break;
            }
            case "goodscode": {
                ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                Object primaryKeyValue = returnData.get(0).getPrimaryKeyValue();
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"er_taxclasscode");
                if (null == obj) break;
                this.getModel().setValue("goodscode", (Object)obj.getString("mergecode"));
                BigDecimal taxRate = obj.getBigDecimal("taxrate");
                Object invoiceType = this.getModel().getValue("invoicetype");
                String standardTaxRate = TaxRate.getRateStr((BigDecimal)taxRate);
                if (InvoiceUtils.isAllEPapperUsedCarInvoice((String)((String)invoiceType))) break;
                this.getModel().setValue("taxrate", (Object)standardTaxRate);
                break;
            }
            case "buyeraddr": {
                ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                Object primaryKeyValue = returnData.get(0).getPrimaryKeyValue();
                DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"sim_invoice_setting");
                Pair addrPhonePair = AddressSplitHelper.splitAddressAndTel((String)object.getString("invoiceaddr"));
                this.getView().getModel().setValue("issueaddress", addrPhonePair.getKey());
                this.getView().getModel().setValue("issuephone", addrPhonePair.getValue());
                break;
            }
            case "saleraddress": {
                ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                Object primaryKeyValue = returnData.get(0).getPrimaryKeyValue();
                DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"sim_invoice_setting");
                Pair bankAndAccPair = AddressSplitHelper.splitBankAndName((String)object.getString("openuserbank"));
                if (!InvoiceUtils.isUsedCarInvoice((Object)this.getModel().getValue("invoicetype"))) {
                    this.getView().getModel().setValue("salerbankname", bankAndAccPair.getKey());
                    this.getView().getModel().setValue("saleraccount", bankAndAccPair.getValue());
                }
                Pair addrPhonePair = AddressSplitHelper.splitAddressAndTel((String)object.getString("invoiceaddr"));
                this.getView().getModel().setValue("saleraddress", addrPhonePair.getKey());
                this.getView().getModel().setValue("salerphone", addrPhonePair.getValue());
                break;
            }
            case "issueaddress": {
                ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                Object primaryKeyValue = returnData.get(0).getPrimaryKeyValue();
                DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"sim_invoice_setting");
                Pair bankAndAccPair = AddressSplitHelper.splitBankAndName((String)object.getString("openuserbank"));
                this.getView().getModel().setValue("issuebankname", bankAndAccPair.getKey());
                this.getView().getModel().setValue("issuebankaccount", bankAndAccPair.getValue());
                Pair addrPhonePair = AddressSplitHelper.splitAddressAndTel((String)object.getString("invoiceaddr"));
                this.getView().getModel().setValue("issueaddress", addrPhonePair.getKey());
                this.getView().getModel().setValue("issuephone", addrPhonePair.getValue());
            }
        }
    }

    private void updateSalerTitleView(DynamicObject dynamicObject) {
        this.getModel().setValue("salername", dynamicObject.get("name"));
        String taxNo = "2".equals(dynamicObject.getString("buyertype")) ? dynamicObject.getString("idcode") : dynamicObject.getString("taxno");
        this.getModel().setValue("salertaxno", (Object)taxNo);
    }

    private void updateBuyerTitleView(DynamicObject dynamicObject) {
        this.getModel().setValue("buyername", dynamicObject.get("name"));
        String taxNo = "2".equals(dynamicObject.getString("buyertype")) ? dynamicObject.getString("idcode") : dynamicObject.getString("taxno");
        this.getModel().setValue("buyertaxno", (Object)taxNo);
        if ("0".equals(this.getModel().getValue("version"))) {
            this.getModel().setValue("buyercardno", (Object)taxNo);
        }
        if (InvoiceUtils.isUsedCarInvoice((Object)this.getModel().getValue("invoicetype"))) {
            if ("1".equals(dynamicObject.getString("buyertype"))) {
                this.getModel().setValue("buyerproperty", (Object)"0");
            }
            if ("2".equals(dynamicObject.getString("buyertype"))) {
                this.getModel().setValue("buyerproperty", (Object)"1");
            }
            if ("3".equals(dynamicObject.getString("buyertype"))) {
                this.getModel().setValue("buyerproperty", (Object)"2");
            }
        }
    }

    private void setNextInvoiceCodeNo() {
        String jqbh = (String)this.getModel().getValue("jqbh");
        if (StringUtils.isBlank((CharSequence)jqbh)) {
            return;
        }
        String equipmentType = DeviceUtil.getDevType((String)jqbh);
        try {
            if ("3".equals(equipmentType)) {
                return;
            }
            ComponentRequest request = new ComponentRequest(ComponentInterfaceTypeEnum.GETTAXDISKINFO.getCzlx(), null, null, null);
            ComponentResponse response = ComponentServiceHelper.doPost((String)ComponentServiceHelper.getComponentRequestUrl((String)jqbh), (String)JSON.toJSONString((Object)request), MoudleDataDTO.class);
            if (!response.isSucess()) {
                this.getView().showErrorNotification(response.getDescription());
                return;
            }
            if ("00000000".equals(((MoudleDataDTO)response.getResponse()).getJdcfphm())) {
                return;
            }
            String invoiceCode = ((MoudleDataDTO)response.getResponse()).getJdcfpdm();
            String invoiceNo = ((MoudleDataDTO)response.getResponse()).getJdcfphm();
            this.getModel().setValue("invoicecode", (Object)invoiceCode);
            this.getModel().setValue("invoiceno", (Object)invoiceNo);
            this.getModel().setValue("issuetime", (Object)new Date());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0b\u4e00\u5f20\u53d1\u7968\u4ee3\u7801\u53f7\u7801\u5931\u8d25\uff1a %s", (String)"VehicleInvoiceFormPlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private void invoicePreview() {
        DynamicObject invoiceDynamicObject = this.buildInvoice();
        IssueInvoiceHelper issueInvoiceHelper = new IssueInvoiceHelper();
        issueInvoiceHelper.invoicePreview(this, invoiceDynamicObject);
    }

    private DynamicObject buildInvoice() {
        DynamicObject invoiceDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice_vehicles");
        IFormView view = this.getView();
        IDataEntityType entityType = invoiceDynamicObject.getDataEntityType();
        DataEntityPropertyCollection collect = entityType.getProperties();
        for (IDataEntityProperty property : collect) {
            String field = property.getName();
            Control control = this.getControl(field);
            if (control == null || property instanceof EntryProp) continue;
            invoiceDynamicObject.set(field, view.getModel().getValue(field));
        }
        invoiceDynamicObject.set("orderno", view.getModel().getValue("orderno"));
        invoiceDynamicObject.set("invoicecode", (Object)"");
        invoiceDynamicObject.set("invoiceno", (Object)"");
        invoiceDynamicObject.set("issuetime", null);
        return invoiceDynamicObject;
    }
}

