/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.vehicle;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.UnitTestHelper;
import kd.imc.bdm.common.util.UUID;
import kd.imc.sim.common.AsyncCheckDTO;
import kd.imc.sim.common.dto.vehicle.VehicleInvoiceCheckDTO;
import kd.imc.sim.common.service.IssueInvoiceService;
import kd.imc.sim.formplugin.issuing.helper.VehicleImportHelper;

public class VehicleInvoiceImportPlugin
extends BatchImportPlugin {
    private static Log LOGGER = LogFactory.getLog(VehicleInvoiceImportPlugin.class);
    public static final String NEW = "new";
    private static ThreadLocal<VehicleInvoiceCheckDTO> checkDtoLocal = new ThreadLocal();

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        LOGGER.info("VehicleInvoiceImportPluginStart");
        String importType = UnitTestHelper.isUnitTest() ? NEW : (String)this.ctx.getOption().get("importtype");
        if (NEW.equals(importType)) {
            this.checkData(rowdatas, logger);
            this.fillInData(rowdatas);
        }
        return super.save(rowdatas, logger);
    }

    protected boolean isForceBatch() {
        return true;
    }

    protected int getBatchImportSize() {
        return super.getBatchImportSize();
    }

    private void fillInData(List<ImportBillData> rowdatas) {
        String batchNumber = UUID.getBatchNumber();
        String billNoHead = "200_" + batchNumber + "_";
        int size = rowdatas.size();
        int length = String.valueOf(size).length();
        int i = 1;
        long taxOrgId = 0L;
        for (ImportBillData billData : rowdatas) {
            JSONObject invoice = billData.getData();
            invoice.put("invoicetype", (Object)InvoiceType.PAPER_VEHICLE_INVOICE.getTypeCode());
            invoice.put("issuestatus", (Object)IssueStatusEnum.ok.getCode());
            invoice.put("billsource", (Object)"3");
            invoice.put("createtime", (Object)new Date());
            invoice.put("issuesource", (Object)"2");
            invoice.put("orderno", (Object)("vehicle_" + UUID.randomUUID()));
            if (0L == taxOrgId) {
                taxOrgId = IssueInvoiceService.getTaxOrgLongValue((String)invoice.getString("salertaxno"));
            }
            invoice.put("taxorg", (Object)taxOrgId);
            if (StringUtils.isBlank((CharSequence)invoice.getString("invoicestatus"))) {
                invoice.put("invoicestatus", (Object)"0");
            }
            invoice.put("orgid.id", (Object)RequestContext.get().getOrgId());
            String billNo = this.getBillNo(billNoHead, length, i);
            invoice.put("billno", (Object)billNo);
            ++i;
        }
    }

    private String getBillNo(String head, int length, int i) {
        int seqLength = String.valueOf(i).length();
        String zeroPrefix = "";
        if (length > seqLength) {
            int zeroNum = length - seqLength;
            StringBuilder builder = new StringBuilder();
            for (int i1 = 0; i1 < zeroNum; ++i1) {
                builder.append('0');
            }
            zeroPrefix = builder.toString();
        }
        return head + zeroPrefix + i;
    }

    private void checkData(List<ImportBillData> rowdatas, ImportLogger logger) {
        String epTaxNo;
        String epName;
        HashMap<String, String> invoiceMap;
        Iterator<ImportBillData> it = rowdatas.iterator();
        VehicleInvoiceCheckDTO totalCheckDto = new VehicleInvoiceCheckDTO();
        VehicleInvoiceCheckDTO localCheckDto = checkDtoLocal.get();
        Set jspEquipmentNos = new HashSet();
        if (localCheckDto == null) {
            localCheckDto = new VehicleInvoiceCheckDTO();
            checkDtoLocal.set(localCheckDto);
            invoiceMap = new HashMap<String, String>();
            localCheckDto.setInvoiceMap(invoiceMap);
            QFilter[] filters = new QFilter("id", "=", (Object)RequestContext.get().getOrgId()).toArray();
            LOGGER.info("orgFilter:" + SerializationUtils.toJsonString((Object)filters));
            DynamicObject[] array = BusinessDataServiceHelper.load((String)"bdm_org", (String)"epinfo", (QFilter[])new QFilter("id", "=", (Object)RequestContext.get().getOrgId()).toArray());
            if (array.length == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u672a\u5f15\u5165\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5f15\u5165\u8be5\u7ec4\u7ec7!", (String)"VehicleInvoiceImportPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            DynamicObject epInfo = array[0].getDynamicObject("epinfo");
            if (null == epInfo) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u672a\u6dfb\u52a0\u4f01\u4e1a\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6dfb\u52a0\u4f01\u4e1a\u4fe1\u606f", (String)"VehicleInvoiceImportPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            epName = String.valueOf(epInfo.get("name"));
            epTaxNo = String.valueOf(epInfo.get("number"));
            VehicleImportHelper.getJspSet((String)epTaxNo, jspEquipmentNos);
            localCheckDto.setJspEquipmentNoSet(jspEquipmentNos);
            localCheckDto.setSalerTaxNo(epTaxNo);
            localCheckDto.setSalerName(epName);
        } else {
            VehicleInvoiceCheckDTO localData = checkDtoLocal.get();
            invoiceMap = localData.getInvoiceMap();
            epName = localData.getSalerName();
            epTaxNo = localData.getSalerTaxNo();
            jspEquipmentNos = localData.getJspEquipmentNoSet();
        }
        totalCheckDto.setJspEquipmentNoSet(jspEquipmentNos);
        while (it.hasNext()) {
            ImportBillData billData = it.next();
            AsyncCheckDTO checkDto = new AsyncCheckDTO(true);
            int startIndex = billData.getStartIndex();
            JSONObject invoice = billData.getData();
            String invoiceCode = invoice.getString("invoicecode");
            String invoiceNo = invoice.getString("invoiceno");
            String key = invoiceCode + invoiceNo;
            if (invoiceMap.containsKey(key)) {
                this.setCheckStatus(false, checkDto, totalCheckDto);
                logger.log(Integer.valueOf(startIndex), ResManager.loadKDString((String)"\u8be5\u53d1\u7968\u4ee3\u7801\u3001\u53f7\u7801\u91cd\u590d", (String)"VehicleInvoiceImportPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            } else {
                invoiceMap.put(key, invoiceNo);
            }
            String taxNo = invoice.getString("salertaxno");
            String salerName = invoice.getString("salername");
            if (!epTaxNo.equals(taxNo)) {
                logger.log(Integer.valueOf(startIndex), String.format(ResManager.loadKDString((String)"\u9500\u65b9\u7a0e\u53f7%1$s\u548c\u5f53\u524d\u4e1a\u52a1\u5355\u5143%2$s\u4e0d\u7b26", (String)"VehicleInvoiceImportPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]), taxNo, epTaxNo));
                this.setCheckStatus(false, checkDto, totalCheckDto);
            }
            if (!epName.equals(salerName)) {
                logger.log(Integer.valueOf(startIndex), String.format(ResManager.loadKDString((String)"\u9500\u65b9\u540d\u79f0%1$s\u548c\u5f53\u524d\u4e1a\u52a1\u5355\u5143%2$s\u4e0d\u7b26", (String)"VehicleInvoiceImportPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]), salerName, epName));
                this.setCheckStatus(false, checkDto, totalCheckDto);
            }
            String invoiceTypeName = invoice.getString("invoicetype");
            if (InvoiceType.ALL_E_PAPER_USED_CAR_ELE.getDescription().equals(invoiceTypeName) || InvoiceType.ALL_E_VEHICLE_NORMAL_ELE.getDescription().equals(invoiceTypeName)) {
                logger.log(Integer.valueOf(startIndex), String.format(ResManager.loadKDString((String)"%1$s\u6682\u4e0d\u652f\u6301\u5bfc\u5165\u529f\u80fd", (String)"VehicleInvoiceImportPlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]), invoiceTypeName));
                this.setCheckStatus(false, checkDto, totalCheckDto);
            }
            try {
                VehicleImportHelper.commonCheck((ImportLogger)logger, (ImportBillData)billData, (AsyncCheckDTO)checkDto, (VehicleInvoiceCheckDTO)totalCheckDto);
                VehicleImportHelper.issuedCheck((ImportLogger)logger, (ImportBillData)billData, (AsyncCheckDTO)checkDto, (VehicleInvoiceCheckDTO)totalCheckDto);
            }
            catch (Exception e) {
                logger.log(Integer.valueOf(billData.getStartIndex()), (Throwable)e);
                this.setCheckStatus(false, checkDto, totalCheckDto);
                LOGGER.error(e.getMessage() + "\u5355\u636e\u6821\u9a8c\u5931\u8d25", (Throwable)e);
            }
            if (checkDto.isSuccess()) continue;
            logger.fail();
            it.remove();
        }
    }

    private void setCheckStatus(boolean isSuccess, AsyncCheckDTO lineResult, VehicleInvoiceCheckDTO totalCheckDto) {
        lineResult.setSuccess(isSuccess);
        totalCheckDto.setCheckSuccess(isSuccess);
    }
}

