/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.vehicle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.InvoiceStatus;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.constant.PrintTypeEnum;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.DownLoadCenterHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.helper.CheckCurrentOrgHelper;
import kd.imc.sim.common.helper.SimCallBackHelper;
import kd.imc.sim.common.utils.VehicleInvoiceValidUtil;
import kd.imc.sim.formplugin.issuing.control.InvoiceQueryControl;
import kd.imc.sim.formplugin.vehicle.AbstractVehicleInvoiceListPlugin;
import kd.imc.sim.formplugin.vehicle.control.VehicleIssueControl;

public class VehicleInvoiceListPlugin
extends AbstractVehicleInvoiceListPlugin {
    public static final String CALLBACK_SIM_VEHICLE_BATCH_RED = "sim_vehicle_batch_red";
    public static final String CALLBACK_SIM_VEHICLE_BATCH_RED_ALLE = "sim_vehicle_batch_red_alle";
    public static final String CALLBACK_SIM_VEHICLE_BATCH_INVALID = "sim_vehicle_batch_invalid";
    public static final String USED_CAR_CALL_BACK_KEY = "usedCarCallBackKey";
    private static final String KEY_DOWNLOAD_OFD = "download";

    public void setFilter(SetFilterEvent e) {
        QFilter qFilter = new QFilter("issuestatus", "=", (Object)IssueStatusEnum.ok.getCode());
        e.getCustomQFilters().add(qFilter);
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"print", "invalid", "red"});
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List listCommonFilterColumns;
        super.filterContainerInit(args);
        Object isFromGoodsReport = this.getView().getFormShowParameter().getCustomParam("isFromGoodsReport");
        if ("isFromGoodsReport".equals(isFromGoodsReport) && !CollectionUtils.isEmpty((Collection)(listCommonFilterColumns = args.getCommonFilterColumns()))) {
            for (FilterColumn filterColumn : listCommonFilterColumns) {
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                commonFilterColumn.setDefaultValue(null);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("refresh".equals(itemKey) || "delete".equals(itemKey)) {
            return;
        }
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        ArrayList noSelectList = new ArrayList();
        Collections.addAll(noSelectList, "btn_export", "btn_import");
        if (selectedRows.isEmpty() && !noSelectList.contains(itemKey)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e", (String)"VehicleInvoiceListPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] objects = BusinessDataServiceHelper.load((Object[])selectedRows.getPrimaryKeyValues(), (DynamicObjectType)billList.getEntityType());
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("keys", selectedRows.getPrimaryKeyValues());
        switch (itemKey) {
            case "print": {
                VehicleIssueControl.checkSelectedRowsPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.INVOICE_PRINT);
                this.print(this, objects, customParams);
                break;
            }
            case "invalid": {
                VehicleIssueControl.checkSelectedRowsPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.IMC_SIM_CANCEL_INVOICE);
                this.invalid(this, objects, customParams);
                break;
            }
            case "red": {
                VehicleIssueControl.checkSelectedRowsPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.SIM_RED);
                this.red(this, objects, customParams);
                break;
            }
            case "btn_export": {
                for (DynamicObject invoice : objects) {
                    VehicleInvoiceValidUtil.showNoSupportTip((DynamicObject)invoice, (String)ResManager.loadKDString((String)"\u5bfc\u51fa", (String)"VehicleIssueControl_7", (String)"imc-sim-service", (Object[])new Object[0]), (AbstractFormPlugin)this);
                }
                break;
            }
            case "download": {
                VehicleIssueControl.checkSelectedRowsPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.ITEM_DOWNLOAD);
                this.downLoadCheck(selectedRows);
            }
        }
    }

    private void red(VehicleInvoiceListPlugin plugin, DynamicObject[] objs, Map<String, Object> customParams) {
        if (objs.length > 10) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u6700\u591a\u53ea\u80fd\u6279\u91cf\u7ea2\u51b210\u5f20!", (String)"VehicleInvoiceListPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        TaxUtils.getSaleInfoByOrg((Long)DynamicObjectUtil.getDynamicObjectLongValue((Object)objs[0].get("orgid")));
        String invoiceType = objs[0].getString("invoicetype");
        for (DynamicObject obj : objs) {
            if (!IssueType.BLUE_INVOICE.getTypeCode().equals(obj.get("issuetype"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u7ea2\u51b2\u6b63\u6570\u53d1\u7968\uff01", (String)"VehicleInvoiceListPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!InvoiceStatus.isNormalInvIncludePartRed((String)obj.getString("invoicestatus"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u7ea2\u51b2\u5df2\u5f00\u5177\u7684\u53d1\u7968\uff01", (String)"VehicleInvoiceListPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            if (obj.getString("invoicetype").equals(invoiceType)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u540c\u65f6\u52fe\u9009\u673a\u52a8\u8f66\u53d1\u7968\u3001\u673a\u52a8\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968\uff08\u6570\u7535\u7eb8\u7968\uff09\u8fdb\u884c\u7ea2\u51b2", (String)"VehicleInvoiceListPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        if (InvoiceUtils.isAllEVehicleInv((String)invoiceType) && objs.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u7535\u7968\u53ea\u80fd\u9009\u62e9\u4e00\u5f20\u8fdb\u884c\u5f55\u5165\u7ea2\u5b57\u786e\u8ba4\u5355\uff01", (String)"RedInvoiceTreeListPlugin_35", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        if (InvoiceUtils.isAllEVehicleInv((String)invoiceType)) {
            ViewUtil.openDialog((AbstractFormPlugin)plugin, customParams, (String)CALLBACK_SIM_VEHICLE_BATCH_RED, (String)CALLBACK_SIM_VEHICLE_BATCH_RED_ALLE);
        } else if (InvoiceUtils.isUsedCarInvoice((Object)invoiceType)) {
            ViewUtil.openDialog((AbstractFormPlugin)plugin, customParams, (String)CALLBACK_SIM_VEHICLE_BATCH_RED, (String)USED_CAR_CALL_BACK_KEY);
        } else {
            ViewUtil.openDialog((AbstractFormPlugin)plugin, customParams, (String)CALLBACK_SIM_VEHICLE_BATCH_RED, (String)CALLBACK_SIM_VEHICLE_BATCH_RED);
        }
    }

    private void invalid(VehicleInvoiceListPlugin plugin, DynamicObject[] objects, Map<String, Object> customParams) {
        for (DynamicObject vehicleInvoice : objects) {
            if ("0".equals(vehicleInvoice.getString("invoicestatus"))) continue;
            plugin.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7 %1$s%2$s", (String)"VehicleInvoiceListPlugin_14", (String)"imc-sim-formplugin", (Object[])new Object[0]), vehicleInvoice.getString("billno"), ResManager.loadKDString((String)" \u53d1\u7968\u72b6\u6001\u975e\u6b63\u5e38\uff0c\u65e0\u6cd5\u8fdb\u884c\u4f5c\u5e9f", (String)"VehicleInvoiceListPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0])));
            return;
        }
        customParams.put("type", PrintTypeEnum.VEHICLE_PRINT.getType());
        ViewUtil.openDialog((AbstractFormPlugin)plugin, customParams, (String)"sim_inv_prev_abolish", (String)CALLBACK_SIM_VEHICLE_BATCH_INVALID);
    }

    public void print(AbstractListPlugin plugin, DynamicObject[] objects, Map<String, Object> customParams) {
        ArrayList<BigDecimal> invoiceNoList = new ArrayList<BigDecimal>(objects.length);
        HashSet<String> invoiceTypeSet = new HashSet<String>(objects.length);
        for (DynamicObject vehicleInvoice : objects) {
            if (org.apache.commons.lang.StringUtils.isEmpty((String)vehicleInvoice.getString("invoiceno"))) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u8fdb\u884c\u6253\u5370", (String)"VehicleInvoiceListPlugin_7", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!IssueStatusEnum.ok.getCode().equals(vehicleInvoice.getString("issuestatus"))) {
                plugin.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7 %1$s%2$s", (String)"VehicleInvoiceListPlugin_14", (String)"imc-sim-formplugin", (Object[])new Object[0]), vehicleInvoice.getString("billno"), ResManager.loadKDString((String)" \u8fd8\u672a\u5f00\u7968\uff0c\u65e0\u6cd5\u8fdb\u884c\u6253\u5370", (String)"VehicleInvoiceListPlugin_8", (String)"imc-sim-formplugin", (Object[])new Object[0])));
                return;
            }
            invoiceNoList.add(new BigDecimal(vehicleInvoice.getString("invoiceno")));
            if ("3".equals(vehicleInvoice.getString("billsource"))) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u901a\u8fc7excel\u5bfc\u5165\u7684\u673a\u52a8\u8f66\u53d1\u7968\u4e0d\u5141\u8bb8\u8fdb\u884c\u53d1\u7968\u6253\u5370\u64cd\u4f5c", (String)"VehicleInvoiceListPlugin_9", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            if ("1".equals(vehicleInvoice.getString("billsource"))) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u901a\u8fc7\u8fdb\u9879\u4e0b\u8f7d\u7684\u673a\u52a8\u8f66\u53d1\u7968\u4e0d\u5141\u8bb8\u8fdb\u884c\u53d1\u7968\u6253\u5370\u64cd\u4f5c", (String)"VehicleInvoiceListPlugin_10", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            invoiceTypeSet.add(vehicleInvoice.getString("invoicetype"));
        }
        if (invoiceTypeSet.size() > 1) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u7535\u53d1\u7968\u4e0e\u975e\u6570\u7535\u53d1\u7968\u4e0d\u652f\u6301\u540c\u65f6\u6253\u5370\u3002", (String)"VehicleInvoiceListPlugin_16", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        Collections.sort(invoiceNoList);
        if (((BigDecimal)invoiceNoList.get(0)).add(new BigDecimal(objects.length - 1)).compareTo((BigDecimal)invoiceNoList.get(objects.length - 1)) != 0) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u53d1\u7968\u53f7\u7801\u4e0d\u662f\u8fde\u7eed\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"VehicleInvoiceListPlugin_11", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        customParams.put("type", PrintTypeEnum.VEHICLE_PRINT.getType());
        customParams.put("invoicetype", invoiceTypeSet.toArray()[0]);
        ViewUtil.openDialog((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u673a\u52a8\u8f66/\u4e8c\u624b\u8f66\u53d1\u7968\u6253\u5370", (String)"VehicleInvoiceListPlugin_12", (String)"imc-sim-formplugin", (Object[])new Object[0]), customParams, (String)"sim_labelape_print", (String)"sim_labelape_print");
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        SimCallBackHelper.callBack((AbstractFormPlugin)this, (Object)event);
        Object returnData = event.getReturnData();
        if ("sim_choose_invoice_type".equals(event.getActionId()) && StringUtils.isNotBlank((Object)returnData)) {
            String fileTypeStr = (String)returnData;
            InvoiceQueryControl.downloadAllEleFile((AbstractListPlugin)this, (String)fileTypeStr);
        }
        this.getView().invokeOperation("refresh");
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        boolean isRefresh;
        super.confirmCallBack(messageBoxClosedEvent);
        if (MessageBoxResult.Yes != messageBoxClosedEvent.getResult()) {
            return;
        }
        if (KEY_DOWNLOAD_OFD.equals(messageBoxClosedEvent.getCallBackId()) && (isRefresh = InvoiceQueryControl.download((AbstractListPlugin)this))) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            billList.clearSelection();
            billList.getFilterParameter().setOrderBy("createtime desc");
            this.getView().invokeOperation("refresh");
        }
    }

    private void downLoadCheck(ListSelectedRowCollection selectedRows) {
        Set typeSet;
        DynamicObject[] objects = BusinessDataServiceHelper.load((Object[])selectedRows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice_vehicles"));
        CheckCurrentOrgHelper.checkSelectRowsCurrentAuthor((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.BTN_DOWNLOAD, (DynamicObject[])objects);
        try {
            typeSet = InvoiceQueryControl.checkDownLoadData((DynamicObject[])objects, (String)"\u4e0b\u8f7d", (boolean)true);
        }
        catch (KDBizException e) {
            this.getView().showTipNotification(e.getMessage());
            return;
        }
        DownLoadCenterHelper.checkLimitDownload((int)selectedRows.size(), (String)"zip");
        DownLoadCenterHelper.checkDownloadSize((DynamicObject[])objects);
        String noPdfNo = Stream.of(objects).filter(dObject -> "0".equals(dObject.getString("ofdstatus"))).filter(dObject -> !InvoiceType.ALL_E_PAPER_USED_CAR.getTypeCode().equalsIgnoreCase(dObject.getString("invoicetype")) && !InvoiceType.ALL_E_PAPER_USED_CAR_ELE.getTypeCode().equalsIgnoreCase(dObject.getString("invoicetype"))).map(dObject -> dObject.getString("invoiceno")).collect(Collectors.joining("\u3001"));
        if (StringUtils.isNotBlank((CharSequence)noPdfNo)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4ee5\u4e0b\u53d1\u7968\u672a\u751f\u6210\u7248\u5f0f\u6587\u4ef6\uff0c\u70b9\u51fb\u53d1\u7968\u53f7\u7801\u53ef\u4ee5\u751f\u6210\u5bf9\u5e94\u7248\u5f0f\u6587\u4ef6", (String)"InvoiceQueryListPlugin_7", (String)"imc-sim-formplugin", (Object[])new Object[0]), noPdfNo, MessageBoxOptions.OK, ConfirmTypes.Default, null);
            return;
        }
        if ("0".equals(typeSet.iterator().next())) {
            ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u662f\u5426\u786e\u5b9a\u4e0b\u8f7d\u4e8c\u624b\u8f66\u53d1\u7968\u7248\u5f0f\u6587\u4ef6\uff1f", (String)"VehicleInvoiceListPlugin_19", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)KEY_DOWNLOAD_OFD);
        }
    }
}

