/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.vehicle.validator;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.TaxRate;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.RegexUtil;
import kd.imc.sim.common.service.InvoiceCheckService;
import kd.imc.sim.common.utils.ApiVerifyUtil;
import kd.imc.sim.common.utils.DeviceUtil;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.common.utils.TaxCalcUtil;

public class VehicleInvoiceValidator
extends AbstractValidator {
    public static final Map cardTypeMap = new HashMap();

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.dataEntities) {
            DynamicObject vehicleInvoice = dataEntity.getDataEntity();
            try {
                VehicleInvoiceValidator.checkVehicleInvoice(vehicleInvoice);
            }
            catch (MsgException e) {
                this.addErrorMessage(dataEntity, e.getErrorMsg());
            }
        }
    }

    public static void checkVehicleInvoice(DynamicObject vehicleInvoice) {
        String invoiceType = vehicleInvoice.getString("invoicetype");
        VehicleInvoiceValidator.checkNull(invoiceType, ResManager.loadKDString((String)"\u53d1\u7968\u79cd\u7c7b", (String)"VehicleInvoiceValidator_41", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        boolean isGold3VehicleInvoice = InvoiceType.PAPER_VEHICLE_INVOICE.getTypeCode().equalsIgnoreCase(invoiceType);
        boolean isElePaperVehicleInvoice = InvoiceUtils.isAllEVehicleInv((String)invoiceType);
        boolean isUsedCarElePaperInvoice = InvoiceUtils.isUsedCarInvoice((Object)invoiceType);
        if (isGold3VehicleInvoice) {
            VehicleInvoiceValidator.checkGold3Fields(vehicleInvoice);
            VehicleInvoiceValidator.clearUsedCarFields(vehicleInvoice);
        }
        if (isElePaperVehicleInvoice) {
            VehicleInvoiceValidator.checkEleFields(vehicleInvoice);
            VehicleInvoiceValidator.clearUsedCarFields(vehicleInvoice);
        }
        if (isUsedCarElePaperInvoice) {
            VehicleInvoiceValidator.checkUsedCarElePaperFields(vehicleInvoice);
            VehicleInvoiceValidator.clearVechicleFields(vehicleInvoice);
        }
        String buyerEmail = vehicleInvoice.getString("buyeremail");
        VehicleInvoiceValidator.checkEmail(buyerEmail);
        String recipientPhone = vehicleInvoice.getString("recipientphone");
        VehicleInvoiceValidator.checkPhone(recipientPhone);
    }

    public static void checkEmail(String buyerEmail) {
        if (StringUtils.isNotBlank((CharSequence)buyerEmail)) {
            String[] emails = buyerEmail.split(";");
            if (emails.length > 3) {
                throw new MsgException(ResManager.loadKDString((String)"\u90ae\u7bb1\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc73\u4e2a", (String)"VehicleInvoiceValidator_91", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            for (String email : emails) {
                if (RegexUtil.isEmail((String)email)) continue;
                throw new MsgException(ResManager.loadKDString((String)"\u90ae\u7bb1\u683c\u5f0f\u9519\u8bef", (String)"VehicleInvoiceValidator_90", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public static void checkPhone(String recipientPhone) {
        if (StringUtils.isNotBlank((CharSequence)recipientPhone)) {
            String[] phones = recipientPhone.split(";");
            if (phones.length > 3) {
                throw new MsgException(ResManager.loadKDString((String)"\u6536\u7968\u624b\u673a\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc73\u4e2a", (String)"VehicleInvoiceValidator_92", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            for (String email : phones) {
                if (RegexUtil.isMobile((String)email)) continue;
                throw new MsgException(ResManager.loadKDString((String)"\u6536\u7968\u624b\u673a\u683c\u5f0f\u9519\u8bef", (String)"VehicleInvoiceValidator_93", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private static void clearVechicleFields(DynamicObject vehicleInvoice) {
        vehicleInvoice.set("producingname", null);
        vehicleInvoice.set("certificatenum", null);
        vehicleInvoice.set("importcertificate", null);
        vehicleInvoice.set("commodityinspectionnum", null);
        vehicleInvoice.set("enginenum", null);
        vehicleInvoice.set("totalton", null);
        vehicleInvoice.set("limitepeople", null);
        vehicleInvoice.set("overtaxcode", null);
    }

    private static void clearUsedCarFields(DynamicObject vehicleInvoice) {
        vehicleInvoice.set("issuename", null);
        vehicleInvoice.set("issuetaxno", null);
        vehicleInvoice.set("issueaddress", null);
        vehicleInvoice.set("issuephone", null);
        vehicleInvoice.set("issuebankname", null);
        vehicleInvoice.set("issuebankaccount", null);
        vehicleInvoice.set("licenseplatenumber", null);
        vehicleInvoice.set("registernumber", null);
        vehicleInvoice.set("vehicleadminname", null);
        vehicleInvoice.set("issueway", null);
        vehicleInvoice.set("nation", null);
        vehicleInvoice.set("buyerproperty", null);
        vehicleInvoice.set("salerproperty", null);
        vehicleInvoice.set("cardtype", null);
        vehicleInvoice.set("buyercardtype", null);
        vehicleInvoice.set("buyernation", null);
    }

    private static void checkUsedCarElePaperFields(DynamicObject vehicleInvoice) {
        boolean isZeroZZSTSGL;
        VehicleInvoiceValidator.checkNullAndCharLength(vehicleInvoice.getString("vehicleidcode"), 30, ResManager.loadKDString((String)"\u8f66\u8f86\u8bc6\u522b\u4ee3\u53f7/\u8f66\u67b6\u53f7\u7801", (String)"VehicleInvoiceValidator_12", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndCharLength(vehicleInvoice.getString("brandmodel"), 50, ResManager.loadKDString((String)"\u5382\u724c\u578b\u53f7", (String)"VehicleInvoiceValidator_8", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndCharLength(vehicleInvoice.getString("registernumber"), 50, ResManager.loadKDString((String)"\u767b\u8bb0\u8bc1\u53f7", (String)"VehicleInvoiceValidator_45", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndCharLength(vehicleInvoice.getString("vehicleadminname"), 100, ResManager.loadKDString((String)"\u8f6c\u5165\u5730\u8f66\u7ba1\u6240", (String)"VehicleInvoiceValidator_46", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndCharLength(vehicleInvoice.getString("licenseplatenumber"), 100, ResManager.loadKDString((String)"\u8f66\u724c\u7167\u53f7", (String)"VehicleInvoiceValidator_47", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        if (StringUtils.isBlank((Object)vehicleInvoice.get("vehicletype"))) {
            throw new MsgException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a", (String)"VehicleInvoiceValidator_34", (String)"imc-sim-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8f66\u8f86\u7c7b\u578b", (String)"VehicleInvoiceValidator_7", (String)"imc-sim-formplugin", (Object[])new Object[0])));
        }
        String errorMsg = VehicleInvoiceValidator.checkAccount(vehicleInvoice);
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            throw new MsgException(errorMsg);
        }
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("issuename"), 100, ResManager.loadKDString((String)"\u5f00\u7968\u65b9\u5355\u4f4d", (String)"VehicleInvoiceValidator_48", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("issuetaxno"), 20, ResManager.loadKDString((String)"\u5f00\u7968\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", (String)"VehicleInvoiceValidator_49", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("issueaddress"), 80, ResManager.loadKDString((String)"\u5f00\u7968\u65b9\u5355\u4f4d\u5730\u5740", (String)"VehicleInvoiceValidator_50", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("issuephone"), 50, ResManager.loadKDString((String)"\u5f00\u7968\u65b9\u7535\u8bdd", (String)"VehicleInvoiceValidator_51", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("issuebankname"), 80, ResManager.loadKDString((String)"\u5f00\u7968\u65b9\u5f00\u6237\u884c", (String)"VehicleInvoiceValidator_52", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("issuebankaccount"), 50, ResManager.loadKDString((String)"\u5f00\u7968\u65b9\u5f00\u6237\u94f6\u884c\u8d26\u53f7", (String)"VehicleInvoiceValidator_53", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNull(vehicleInvoice.getString("issueway"), ResManager.loadKDString((String)"\u5f00\u7968\u65b9\u5f0f", (String)"VehicleInvoiceValidator_59", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("salername"), 100, ResManager.loadKDString((String)"\u5356\u65b9\u5355\u4f4d/\u4e2a\u4eba", (String)"VehicleInvoiceValidator_60", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("salertaxno"), 30, ResManager.loadKDString((String)"\u5356\u65b9\u5355\u4f4d\u4ee3\u7801/\u8eab\u4efd\u8bc1\u53f7\u7801(\u5356\u65b9\u81ea\u7136\u4eba\u8bc1\u4ef6\u53f7\u7801)", (String)"VehicleInvoiceValidator_61", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("saleraddress"), 100, ResManager.loadKDString((String)"\u5356\u65b9\u5355\u4f4d/\u4e2a\u4eba\u4f4f\u5740", (String)"VehicleInvoiceValidator_62", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("salerphone"), 30, ResManager.loadKDString((String)"\u5356\u65b9\u7535\u8bdd", (String)"VehicleInvoiceValidator_63", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNull(vehicleInvoice.getString("usedcarenterprisenature"), ResManager.loadKDString((String)"\u4f01\u4e1a\u8d44\u8d28", (String)"VehicleInvoiceValidator_64", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        String usedCarNature = vehicleInvoice.getString("usedcarenterprisenature");
        if ("07".equals(usedCarNature) && !"0".equals(vehicleInvoice.getString("issueway"))) {
            throw new MsgException(ResManager.loadKDString((String)"\u4e8c\u624b\u8f66\u5e02\u573a\u4f01\u4e1a\u53ea\u80fd\u9009\u62e9\u6b63\u5411\u5f00\u7968\uff0c\u4e0d\u652f\u6301\u53cd\u5411\u5f00\u7968", (String)"VehicleInvoiceValidator_71", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("buyertaxno"), 30, ResManager.loadKDString((String)"\u4e70\u65b9\u5355\u4f4d\u4ee3\u7801/\u8eab\u4efd\u8bc1\u53f7\u7801", (String)"VehicleInvoiceValidator_66", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("buyeraddr"), 100, ResManager.loadKDString((String)"\u4e70\u65b9\u5355\u4f4d/\u4e2a\u4eba\u4f4f\u5740", (String)"VehicleInvoiceValidator_67", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("buyerphone"), 50, ResManager.loadKDString((String)"\u4e70\u65b9\u7535\u8bdd", (String)"VehicleInvoiceValidator_68", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkLength(vehicleInvoice.getString("drawer"), 10, ResManager.loadKDString((String)"\u5f00\u7968\u4eba", (String)"VehicleInvoiceValidator_21", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        if ("1".equals(vehicleInvoice.getString("buyerproperty"))) {
            Object buyerNation = vehicleInvoice.get("buyernation");
            if (null == buyerNation) {
                throw new MsgException(ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9\u4e3a\u4e2a\u4eba,\u5fc5\u987b\u586b\u5199\u56fd\u7c4d", (String)"VehicleInvoiceValidator_76", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            Object buyerCardType = vehicleInvoice.get("buyercardtype");
            if (StringUtils.isBlank((Object)buyerCardType)) {
                throw new MsgException(ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9\u4e3a\u4e2a\u4eba\uff0c\u5fc5\u987b\u586b\u5199\u8bc1\u4ef6\u7c7b\u578b", (String)"VehicleInvoiceValidator_77", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
        }
        if ("1".equals(vehicleInvoice.getString("salerproperty"))) {
            Object salerNation = vehicleInvoice.get("nation");
            if (null == salerNation) {
                throw new MsgException(ResManager.loadKDString((String)"\u9500\u552e\u65b9\u4e3a\u4e2a\u4eba\uff0c\u5fc5\u987b\u586b\u5199\u56fd\u7c4d", (String)"VehicleInvoiceValidator_78", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            Object salerCardType = vehicleInvoice.get("cardtype");
            if (StringUtils.isBlank((Object)salerCardType)) {
                throw new MsgException(ResManager.loadKDString((String)"\u9500\u552e\u65b9\u4e3a\u4e2a\u4eba\uff0c\u5fc5\u987b\u586b\u5199\u8bc1\u4ef6\u7c7b\u578b", (String)"VehicleInvoiceValidator_79", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
        }
        String issueType = vehicleInvoice.getString("issuetype");
        VehicleInvoiceValidator.checkAmount(vehicleInvoice, issueType);
        String zzstsgl = vehicleInvoice.getString("zzstsgl");
        String taxRate = vehicleInvoice.getString("taxrate");
        String taxPremark = vehicleInvoice.getString("taxpremark");
        boolean isUse = "1".equalsIgnoreCase(taxPremark);
        boolean bl = isZeroZZSTSGL = "\u514d\u7a0e".equals(zzstsgl) || "\u4e0d\u5f81\u7a0e".equals(zzstsgl) || "\u666e\u901a\u96f6\u7a0e\u7387".equals(zzstsgl);
        if (isZeroZZSTSGL && isUse && !TaxRate.ZERO_PERCENT.getRateValue().equals(taxRate)) {
            throw new MsgException(ResManager.loadKDString((String)"\u7a0e\u7387\u548c\u4f18\u60e0\u653f\u7b56\u4e0d\u5339\u914d", (String)"VehicleInvoiceValidator_69", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        VehicleInvoiceValidator.checkLength(vehicleInvoice.getString("remark"), 200, "\u5907\u6ce8");
        String issueWay = vehicleInvoice.getString("issueway");
        if ("0".equals(issueWay)) {
            VehicleInvoiceValidator.checkNull(vehicleInvoice.getString("buyerproperty"), ResManager.loadKDString((String)"\u4e70\u65b9\u6027\u8d28", (String)"VehicleInvoiceValidator_65", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        } else {
            VehicleInvoiceValidator.checkNull(vehicleInvoice.getString("salerproperty"), ResManager.loadKDString((String)"\u5356\u65b9\u6027\u8d28", (String)"VehicleInvoiceValidator_70", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
    }

    private static String checkAccount(DynamicObject vehicleInvoice) {
        boolean isVirtual = StringUtils.isNotBlank((CharSequence)ImcConfigUtil.getValue((String)"all_ele_mock_invoice", (String)vehicleInvoice.getString("issuetaxno")));
        if (isVirtual) {
            return "";
        }
        String account = vehicleInvoice.getString("account");
        if (StringUtils.isNotBlank((CharSequence)account)) {
            return AllEleAuthHelper.checkIssueAccount((String)vehicleInvoice.getString("issuetaxno"), (String)account);
        }
        return ResManager.loadKDString((String)"\u6570\u7535\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"VehicleImportHelper_7", (String)"imc-sim-service", (Object[])new Object[0]);
    }

    private static void checkEleFields(DynamicObject vehicleInvoice) {
        String issueType = vehicleInvoice.getString("issuetype");
        VehicleInvoiceValidator.checkNull(issueType, ResManager.loadKDString((String)"\u5f00\u7968\u7c7b\u578b", (String)"VehicleInvoiceValidator_6", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndCharLength(vehicleInvoice.getString("vehicleidcode"), 30, ResManager.loadKDString((String)"\u8f66\u8f86\u8bc6\u522b\u4ee3\u53f7/\u8f66\u67b6\u53f7\u7801", (String)"VehicleInvoiceValidator_12", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndCharLength(vehicleInvoice.getString("brandmodel"), 50, ResManager.loadKDString((String)"\u5382\u724c\u578b\u53f7", (String)"VehicleInvoiceValidator_8", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndCharLength(vehicleInvoice.getString("producingarea"), 50, ResManager.loadKDString((String)"\u4ea7\u5730", (String)"VehicleInvoiceValidator_9", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndCharLength(vehicleInvoice.getString("certificatenum"), 30, ResManager.loadKDString((String)"\u5408\u683c\u8bc1\u53f7", (String)"VehicleInvoiceValidator_10", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndCharLength(vehicleInvoice.getString("enginenum"), 50, ResManager.loadKDString((String)"\u53d1\u52a8\u673a\u53f7", (String)"VehicleInvoiceValidator_11", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndCharLength(vehicleInvoice.getString("vehicletype"), 20, ResManager.loadKDString((String)"\u8f66\u8f86\u7c7b\u578b", (String)"VehicleInvoiceValidator_7", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndCharLength(vehicleInvoice.getString("producingname"), 100, ResManager.loadKDString((String)"\u751f\u4ea7\u4f01\u4e1a\u540d\u79f0", (String)"VehicleInvoiceValidator_13", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndCharLength(vehicleInvoice.getString("uuid"), 30, ResManager.loadKDString((String)"\u673a\u52a8\u8f66uuid", (String)"VehicleInvoiceValidator_39", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkCharLength(vehicleInvoice.getString("importcertificate"), 30, ResManager.loadKDString((String)"\u8fdb\u53e3\u8bc1\u660e\u4e66\u53f7", (String)"VehicleInvoiceValidator_24", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkCharLength(vehicleInvoice.getString("commodityinspectionnum"), 30, ResManager.loadKDString((String)"\u5546\u68c0\u5355\u53f7", (String)"VehicleInvoiceValidator_25", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkCharLength(vehicleInvoice.getString("totalton"), 10, ResManager.loadKDString((String)"\u5428\u4f4d", (String)"VehicleInvoiceValidator_37", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkCharLength(vehicleInvoice.getString("limitepeople"), 5, ResManager.loadKDString((String)"\u9650\u4e58\u4eba\u6570", (String)"VehicleInvoiceValidator_38", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkCharLength(vehicleInvoice.getString("overtaxcode"), 30, ResManager.loadKDString((String)"\u5b8c\u7a0e\u51ed\u8bc1\u53f7\u7801", (String)"VehicleInvoiceValidator_40", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndCharLength(vehicleInvoice.getString("buyername"), 100, ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9\u540d\u79f0", (String)"VehicleInvoiceValidator_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkCharLength(vehicleInvoice.getString("buyertaxno"), 20, ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7/\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801/\u8eab\u4efd\u8bc1\u53f7\u7801", (String)"VehicleInvoiceValidator_42", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkCharLength(vehicleInvoice.getString("drawer"), 16, ResManager.loadKDString((String)"\u5f00\u7968\u4eba", (String)"VehicleInvoiceValidator_21", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndCharLength(vehicleInvoice.getString("goodscode"), 19, ResManager.loadKDString((String)"\u7a0e\u6536\u5206\u7c7b\u7f16\u7801", (String)"VehicleInvoiceValidator_22", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNull(vehicleInvoice.getString("taxpremark"), ResManager.loadKDString((String)"\u4f18\u60e0\u653f\u7b56\u7c7b\u578b", (String)"VehicleInvoiceValidator_23", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkAmount(vehicleInvoice, issueType);
        vehicleInvoice.set("version", null);
    }

    private static void checkGold3Fields(DynamicObject vehicleInvoice) {
        String version = vehicleInvoice.getString("version");
        VehicleInvoiceValidator.checkNull(version, ResManager.loadKDString((String)"\u7248\u672c\u53f7", (String)"VehicleInvoiceValidator_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        boolean isOldVersion = "0".equals(version);
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("buyername"), 100, ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9\u540d\u79f0", (String)"VehicleInvoiceValidator_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("buyertaxno"), 20, isOldVersion ? ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", (String)"VehicleInvoiceValidator_3", (String)"imc-sim-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7/\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801/\u8eab\u4efd\u8bc1\u53f7\u7801", (String)"VehicleInvoiceValidator_4", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        if (isOldVersion) {
            VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("buyercardno"), 22, ResManager.loadKDString((String)"\u7248\u672c\u53f7\u4e3a\u65e7\u7248\u65f6\uff0c\u8eab\u4efd\u8bc1\u53f7\u7801/\u7ec4\u7ec7\u673a\u6784\u4ee3\u7801", (String)"VehicleInvoiceValidator_5", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        String issueType = vehicleInvoice.getString("issuetype");
        VehicleInvoiceValidator.checkNull(issueType, ResManager.loadKDString((String)"\u5f00\u7968\u7c7b\u578b", (String)"VehicleInvoiceValidator_6", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("vehicletype"), 40, ResManager.loadKDString((String)"\u8f66\u8f86\u7c7b\u578b", (String)"VehicleInvoiceValidator_7", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("brandmodel"), 60, ResManager.loadKDString((String)"\u5382\u724c\u578b\u53f7", (String)"VehicleInvoiceValidator_8", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("producingarea"), 32, ResManager.loadKDString((String)"\u4ea7\u5730", (String)"VehicleInvoiceValidator_9", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("certificatenum"), 50, ResManager.loadKDString((String)"\u5408\u683c\u8bc1\u53f7", (String)"VehicleInvoiceValidator_10", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("enginenum"), 60, ResManager.loadKDString((String)"\u53d1\u52a8\u673a\u53f7", (String)"VehicleInvoiceValidator_11", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("vehicleidcode"), 23, ResManager.loadKDString((String)"\u8f66\u8f86\u8bc6\u522b\u4ee3\u53f7/\u8f66\u67b6\u53f7\u7801", (String)"VehicleInvoiceValidator_12", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("producingname"), 40, ResManager.loadKDString((String)"\u751f\u4ea7\u4f01\u4e1a\u540d\u79f0", (String)"VehicleInvoiceValidator_13", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("salername"), 100, ResManager.loadKDString((String)"\u9500\u65b9\u540d\u79f0", (String)"VehicleInvoiceValidator_19", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("salertaxno"), 20, ResManager.loadKDString((String)"\u9500\u65b9\u7a0e\u53f7", (String)"VehicleInvoiceValidator_20", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("drawer"), 10, ResManager.loadKDString((String)"\u5f00\u7968\u4eba", (String)"VehicleInvoiceValidator_21", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkNullAndLength(vehicleInvoice.getString("goodscode"), 19, ResManager.loadKDString((String)"\u7a0e\u6536\u5206\u7c7b\u7f16\u7801", (String)"VehicleInvoiceValidator_22", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        String taxPremark = vehicleInvoice.getString("taxpremark");
        VehicleInvoiceValidator.checkNull(taxPremark, ResManager.loadKDString((String)"\u4f18\u60e0\u653f\u7b56\u7c7b\u578b", (String)"VehicleInvoiceValidator_23", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkLength(vehicleInvoice.getString("importcertificate"), 36, ResManager.loadKDString((String)"\u8fdb\u53e3\u8bc1\u660e\u4e66\u53f7", (String)"VehicleInvoiceValidator_24", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkLength(vehicleInvoice.getString("commodityinspectionnum"), 32, ResManager.loadKDString((String)"\u5546\u68c0\u5355\u53f7", (String)"VehicleInvoiceValidator_25", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        VehicleInvoiceValidator.checkAmount(vehicleInvoice, issueType);
        String jqbh = vehicleInvoice.getString("jqbh");
        VehicleInvoiceValidator.checkNull(jqbh, ResManager.loadKDString((String)"\u8bbe\u5907\u7f16\u53f7", (String)"VehicleInvoiceValidator_28", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        String equipmentType = DeviceUtil.getDevType((String)vehicleInvoice.getString("jqbh"));
        if (!"2".equals(equipmentType) && !"3".equals(equipmentType)) {
            throw new MsgException(ErrorType.EMPTY_PARAM.getCode(), ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u91d1\u7a0e\u76d8\u5f00\u5177\u673a\u52a8\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968\u3002", (String)"VehicleInvoiceValidator_29", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
    }

    private static void checkAmount(DynamicObject vehicleInvoice, String issueType) {
        BigDecimal totalAmount = vehicleInvoice.getBigDecimal("totalamount");
        if (MathUtils.isNullOrZero((BigDecimal)totalAmount)) {
            throw new MsgException(ErrorType.EMPTY_PARAM.getCode(), ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u80fd\u4e3a0", (String)"VehicleInvoiceValidator_14", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        BigDecimal totalTax = vehicleInvoice.getBigDecimal("totaltax");
        String taxRate = vehicleInvoice.getString("taxrate");
        VehicleInvoiceValidator.checkNull(taxRate, ResManager.loadKDString((String)"\u7a0e\u7387", (String)"VehicleInvoiceValidator_16", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        if (!Arrays.asList(ApiVerifyUtil.getFloatTaxRate()).contains(taxRate)) {
            throw new MsgException(ErrorType.EMPTY_PARAM.getCode(), ResManager.loadKDString((String)"\u7a0e\u7387\u4e0d\u5408\u6cd5", (String)"VehicleInvoiceValidator_17", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        BigDecimal calcTax = TaxCalcUtil.calTax((BigDecimal)totalAmount, (BigDecimal)BigDecimal.ZERO, (String)vehicleInvoice.getString("taxrate"), (boolean)true);
        if (calcTax.compareTo(totalTax) != 0) {
            throw new MsgException(String.format(ResManager.loadKDString((String)"\u7a0e\u989d\u9519\u8bef\uff0c\u5b9e\u9645\u7a0e\u989d%1$s,\u4f20\u5165\u7a0e\u989d%2$s", (String)"VehicleInvoiceValidator_33", (String)"imc-sim-formplugin", (Object[])new Object[0]), calcTax.toString(), totalTax.setScale(2, 4).toString()));
        }
        if (issueType.equals("0") && totalAmount.compareTo(BigDecimal.ZERO) < 0) {
            throw new MsgException(ResManager.loadKDString((String)"\u5f00\u7968\u7c7b\u578b\u4e3a\u84dd\u7968\u65f6\uff0c\u5408\u8ba1\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0", (String)"VehicleInvoiceValidator_26", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        if (issueType.equals("1") && totalAmount.compareTo(BigDecimal.ZERO) > 0) {
            throw new MsgException(ResManager.loadKDString((String)"\u5f00\u7968\u7c7b\u578b\u4e3a\u7ea2\u7968\u65f6\uff0c\u5408\u8ba1\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e0", (String)"VehicleInvoiceValidator_27", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
    }

    public static void checkCharLength(String val, int length, String description) {
        if (val.length() > length) {
            throw new MsgException(String.format(ResManager.loadKDString((String)"%1$s\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7%2$s\uff08\u4e00\u4e2a\u6c49\u5b571\u4e2a\u5b57\u7b26\u957f\u5ea6\uff09", (String)"VehicleInvoiceValidator_43", (String)"imc-sim-formplugin", (Object[])new Object[0]), description, length));
        }
    }

    public static void checkNullAndCharLength(String val, int length, String description) {
        VehicleInvoiceValidator.checkNull(val, description);
        VehicleInvoiceValidator.checkCharLength(val, length, description);
    }

    public static void checkNullAndLength(String val, int length, String description) {
        VehicleInvoiceValidator.checkNull(val, description);
        VehicleInvoiceValidator.checkLength(val, length, description);
    }

    public static void checkNull(String val, String description) {
        if (StringUtils.isBlank((CharSequence)val)) {
            throw new MsgException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a", (String)"VehicleInvoiceValidator_34", (String)"imc-sim-formplugin", (Object[])new Object[0]), description));
        }
    }

    public static void checkLength(String val, int length, String description) {
        if (StringUtils.isBlank((CharSequence)val)) {
            return;
        }
        if (GBKUtils.getGBKLength((String)val) > length) {
            throw new MsgException(String.format(InvoiceCheckService.GBK_LEN_ERR_MSG_TEMPLATE, description, length));
        }
    }

    public static String checkNullAndLengthMessage(String val, int length, String description) {
        return VehicleInvoiceValidator.checkNullMessage(val, description) + VehicleInvoiceValidator.checkLengthMessage(val, length, description);
    }

    public static String checkNullMessage(String val, String description) {
        if (StringUtils.isBlank((CharSequence)val)) {
            return String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a", (String)"VehicleInvoiceValidator_34", (String)"imc-sim-formplugin", (Object[])new Object[0]), description);
        }
        return "";
    }

    public static String checkLengthMessage(String val, int length, String description) {
        if (StringUtils.isBlank((CharSequence)val)) {
            return "";
        }
        if (GBKUtils.getGBKLength((String)val) > length) {
            return String.format(InvoiceCheckService.GBK_LEN_ERR_MSG_TEMPLATE, description, length) + ";";
        }
        return "";
    }

    public static String checkIsNumberMessage(String val, String description) {
        if (StringUtils.isBlank((CharSequence)val)) {
            return String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a", (String)"VehicleInvoiceValidator_34", (String)"imc-sim-formplugin", (Object[])new Object[0]), description);
        }
        if (!BigDecimalUtil.isNumber((String)val)) {
            return String.format(ResManager.loadKDString((String)"%s\u5fc5\u987b\u4e3a\u6570\u503c\u7c7b\u578b", (String)"VehicleInvoiceValidator_35", (String)"imc-sim-formplugin", (Object[])new Object[0]), description);
        }
        return "";
    }

    static {
        cardTypeMap.put(ResManager.loadKDString((String)"\u7a0e\u52a1\u767b\u8bb0\u8bc1", (String)"VehicleInvoiceValidator_80", (String)"imc-sim-formplugin", (Object[])new Object[0]), "103");
        cardTypeMap.put(ResManager.loadKDString((String)"\u5c45\u6c11\u8eab\u4efd\u8bc1", (String)"VehicleInvoiceValidator_81", (String)"imc-sim-formplugin", (Object[])new Object[0]), "201");
        cardTypeMap.put(ResManager.loadKDString((String)"\u5916\u56fd\u62a4\u7167", (String)"VehicleInvoiceValidator_82", (String)"imc-sim-formplugin", (Object[])new Object[0]), "208");
        cardTypeMap.put(ResManager.loadKDString((String)"\u6e2f\u6fb3\u5c45\u6c11\u6765\u5f80\u5185\u5730\u901a\u884c\u8bc1", (String)"VehicleInvoiceValidator_83", (String)"imc-sim-formplugin", (Object[])new Object[0]), "210");
        cardTypeMap.put(ResManager.loadKDString((String)"\u53f0\u6e7e\u5c45\u6c11\u6765\u5f80\u5927\u9646\u901a\u884c\u8bc1", (String)"VehicleInvoiceValidator_84", (String)"imc-sim-formplugin", (Object[])new Object[0]), "213");
        cardTypeMap.put(ResManager.loadKDString((String)"\u5916\u56fd\u4eba\u6c38\u4e45\u5c45\u7559\u8eab\u4efd\u8bc1\uff08\u5916\u56fd\u4eba\u6c38\u4e45\u5c45\u7559\u8bc1\uff09", (String)"VehicleInvoiceValidator_85", (String)"imc-sim-formplugin", (Object[])new Object[0]), "233");
        cardTypeMap.put(ResManager.loadKDString((String)"\u5176\u4ed6\u4e2a\u4eba\u8bc1\u4ef6", (String)"VehicleInvoiceValidator_86", (String)"imc-sim-formplugin", (Object[])new Object[0]), "299");
        cardTypeMap.put(ResManager.loadKDString((String)"\u5916\u56fd\u4eba\u5c45\u7559\u8bc1", (String)"VehicleInvoiceValidator_87", (String)"imc-sim-formplugin", (Object[])new Object[0]), "215");
        cardTypeMap.put(ResManager.loadKDString((String)"\u9999\u6e2f\u6c38\u4e45\u6027\u5c45\u6c11\u8eab\u4efd\u8bc1", (String)"VehicleInvoiceValidator_88", (String)"imc-sim-formplugin", (Object[])new Object[0]), "219");
        cardTypeMap.put(ResManager.loadKDString((String)"\u53f0\u6e7e\u8eab\u4efd\u8bc1", (String)"VehicleInvoiceValidator_89", (String)"imc-sim-formplugin", (Object[])new Object[0]), "220");
    }
}

