/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.mq.consumer.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.bdm.common.constant.EquipmentType;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.OpenApiCallbackInterfaceCodeEnum;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.CallbackHelperUtil;
import kd.imc.bdm.common.util.CallbackMcloudUtil;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.MqPublishUtils;
import kd.imc.sim.common.helper.IssueInvoiceFailHelper;
import kd.imc.sim.common.helper.issueinvoice.IssueInvoiceMqHelper;
import kd.imc.sim.common.service.IssueInvoiceService;
import kd.imc.sim.formplugin.issuing.control.BatchInvoiceControl;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillHelper;
import kd.imc.sim.mq.consumer.service.AbstractIssueInvoiceService;
import kd.imc.sim.mq.consumer.service.IssueVehicleInvoiceServiceImpl;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class IssueVatInvoiceServiceImpl
extends AbstractIssueInvoiceService {
    private static final Log LOGGER = LogFactory.getLog(IssueVatInvoiceServiceImpl.class);
    private static final Long VehicleLabelOrgId = 999888999888L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void issueInvoice(Object arg0, String messageId, boolean resend, MessageAcker ack) {
        DynamicObject[] invoiceList;
        ArrayList orderNoList = (ArrayList)arg0;
        long orgId = this.getOrgId(orderNoList, ack, messageId);
        CacheHelper.remove((String)("SimConsumer" + messageId));
        if (orgId == 0L) {
            return;
        }
        if (VehicleLabelOrgId == orgId) {
            LOGGER.info("enterVehicleIssueProcess");
            IssueVehicleInvoiceServiceImpl vehicleInvoiceService = new IssueVehicleInvoiceServiceImpl();
            vehicleInvoiceService.issueInvoice(arg0, messageId, resend, ack);
            return;
        }
        Pair pair = this.getOrderByAndErrorContinue(orgId);
        if (!"billno".equals(pair.getRight())) {
            pair = "splitorder".equals(pair.getRight()) ? Pair.of((Object)pair.getLeft(), (Object)String.format("%s asc, %s asc", "billno", pair.getValue())) : Pair.of((Object)pair.getLeft(), (Object)String.format("%s asc, %s asc", pair.getValue(), "billno"));
        }
        if ((invoiceList = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "salertaxno", "jqbh", "invoicetype", "issuesource", "orderno", "issuestatus", "result", "wxid"), (QFilter[])new QFilter("orderno", "in", (Object)orderNoList.toArray()).and("issuestatus", "!=", (Object)IssueStatusEnum.ok.getCode()).toArray(), (String)((String)pair.getRight()))).length == 0) {
            ack.discard(messageId);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.error("SimConsumer \u672a\u67e5\u8be2\u5230\u975e\u5f00\u7968\u6210\u529f\u7684\u6570\u636e\uff1aorderno--\uff1a" + arg0);
            }
            return;
        }
        DLock lock = null;
        try {
            boolean isEleInvoiceSyncIssue;
            String invoiceType = invoiceList[0].getString("invoicetype");
            boolean bl = isEleInvoiceSyncIssue = "1".equals(ImcConfigUtil.getValue((String)"SimConsumer", (String)"ele_sync_invoice")) && (InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode().equals(invoiceType) || InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode().equals(invoiceType));
            if (isEleInvoiceSyncIssue || InvoiceUtils.isPaperInvoice((String)invoiceType) || EquipmentType.isLyServer((String)invoiceList[0].getString("issuesource"))) {
                String lockKey = IssueInvoiceMqHelper.getIssueInvoiceLockKey((String)invoiceList[0].getString("salertaxno"), (String)invoiceList[0].getString("jqbh"));
                lock = DLock.create((String)lockKey);
                try {
                    if (!lock.tryLock(5000L)) {
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info("\u6ca1\u6709\u83b7\u53d6\u5230\u9501\uff0c\u62d2\u7edd\u6d88\u606f" + arg0);
                        }
                        ack.discard(messageId);
                        MqPublishUtils.publish((String)"imc", (String)"imc.sim.sim_queue", (Object)arg0);
                        return;
                    }
                }
                catch (Exception e) {
                    ack.discard(messageId);
                    MqPublishUtils.publish((String)"imc", (String)"imc.sim.sim_queue", (Object)arg0);
                    return;
                }
            }
            ArrayList<DynamicObject> preIssueErrorInvoiceList = new ArrayList<DynamicObject>();
            boolean issueError = false;
            boolean isUnderWay = false;
            String preErrorMsg = "";
            for (DynamicObject invoice : invoiceList) {
                DLock issueLock = null;
                try {
                    issueLock = DLock.create((String)("imc_doIssueInvoice_" + invoice.getString("orderno")));
                    if (!issueLock.tryLock()) continue;
                    invoice = BusinessDataServiceHelper.loadSingle((Object)invoice.getPkValue(), (String)"sim_vatinvoice");
                    if (IssueStatusEnum.ok.getCode().equals(invoice.getString("issuestatus")) || BatchInvoiceControl.checkAsyncInvoiceIssuing((DynamicObject)invoice)) continue;
                    if (issueError && InvoiceUtils.isPaperInvoice((String)invoiceType) && !((Boolean)pair.getLeft()).booleanValue() && !isUnderWay) {
                        invoice.set("issuestatus", (Object)IssueStatusEnum.failed.getCode());
                        invoice.set("result", (Object)String.format(ResManager.loadKDString((String)"\u6279\u91cf\u5f00\u7968\u524d\u7f6e\u5b58\u5728\u5f00\u7968\u5931\u8d25: %s", (String)"IssueVatInvoiceServiceImpl_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), preErrorMsg));
                        preIssueErrorInvoiceList.add(invoice);
                        continue;
                    }
                    invoice.set("issuestatus", (Object)IssueStatusEnum.underway.getCode());
                    invoice.set("buyertaxno", (Object)(null == invoice.getString("buyertaxno") ? "" : invoice.getString("buyertaxno").replaceAll(" ", "").toUpperCase()));
                    ImcSaveServiceHelper.update((DynamicObject)invoice);
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("SimConsumer-\u5f00\u59cb\u8fdb\u884c\u5f00\u7968orderno" + invoice.getString("orderno"));
                    }
                    MsgResponse msgResponse = IssueInvoiceService.doIssueInvoice((DynamicObject)invoice, (boolean)true, (DLock)issueLock);
                    if (ErrorType.SUCCESS.getCode().equals(msgResponse.getErrorCode())) continue;
                    if (ErrorType.SUBMITED.getCode().equals(msgResponse.getErrorCode())) {
                        LOGGER.info(String.format("SimConsumer\u5f02\u6b65\u63d0\u4ea4\u5f00\u7968\u8bf7\u6c42_%s, ErrorMsg: %s", invoice.getString("orderno"), msgResponse.getErrorMsg()));
                        isUnderWay = true;
                    } else {
                        LOGGER.info(String.format("SimConsumer\u5f00\u7968\u5931\u8d25_%s, ErrorMsg: %s", invoice.getString("orderno"), msgResponse.getErrorMsg()));
                        IssueInvoiceFailHelper.createFailAutoIssueRecord((DynamicObject)invoice, (String)msgResponse.getErrorMsg(), (String)msgResponse.getErrorCode());
                        this.updateErrorInvoice(invoice, msgResponse.getErrorMsg(), msgResponse.getErrorCode());
                    }
                    preErrorMsg = msgResponse.getErrorMsg();
                    issueError = true;
                }
                catch (Exception e) {
                    issueError = true;
                    LOGGER.error("SimConsumer Exception\uff1a" + e.getMessage(), (Throwable)e);
                    this.updateErrorInvoice(invoice, e.getMessage(), ErrorType.FAIL.getCode());
                }
                finally {
                    if (issueLock != null) {
                        issueLock.unlock();
                    }
                }
            }
            if (!CollectionUtils.isEmpty(preIssueErrorInvoiceList)) {
                ImcSaveServiceHelper.save(preIssueErrorInvoiceList);
                for (DynamicObject invoice : preIssueErrorInvoiceList) {
                    CallbackHelperUtil.sendErrorCallbackMessage((String)String.format(ResManager.loadKDString((String)"\u6279\u91cf\u5f00\u7968\u524d\u7f6e\u5b58\u5728\u5f00\u7968\u5931\u8d25: %s", (String)"IssueVatInvoiceServiceImpl_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), preErrorMsg), (DynamicObject)invoice, (String)OpenApiCallbackInterfaceCodeEnum.INVOICE_OPEN.getCode());
                    IssueInvoiceFailHelper.createFailAutoIssueRecord((DynamicObject)invoice, (String)String.format(ResManager.loadKDString((String)"\u6279\u91cf\u5f00\u7968\u524d\u7f6e\u5b58\u5728\u5f00\u7968\u5931\u8d25: %s", (String)"IssueVatInvoiceServiceImpl_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), preErrorMsg), (String)ErrorType.FAIL.getCode());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("SimConsumer \u5f00\u7968\u5f02\u5e38", (Throwable)e);
            for (DynamicObject invoiceDynamicObject : invoiceList) {
                invoiceDynamicObject.set("issuestatus", (Object)IssueStatusEnum.getCode((String)ResManager.loadKDString((String)"\u5f00\u7968\u5931\u8d25", (String)"IssueVatInvoiceServiceImpl_7", (String)"imc-sim-formplugin", (Object[])new Object[0])));
                invoiceDynamicObject.set("result", (Object)GBKUtils.cutGBKString((String)e.getMessage(), (int)200));
            }
            SaveServiceHelper.save((DynamicObject[])invoiceList);
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
            ack.ack(messageId);
        }
    }

    private long getOrgId(ArrayList<String> orderNoList, MessageAcker ack, String messageId) {
        if (CollectionUtils.isEmpty(orderNoList)) {
            ack.discard(messageId);
            return 0L;
        }
        DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"orgid", (QFilter[])new QFilter("orderno", "=", (Object)orderNoList.get(0)).toArray());
        if (invoice == null || DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.getDynamicObject("orgid")) == 0L) {
            LOGGER.error("MQ\u67e5\u8be2\u53d1\u7968\u4e3a\u7a7a_" + orderNoList.get(0));
            return this.isRecursionQuery(orderNoList, ack, messageId);
        }
        return DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.getDynamicObject("orgid"));
    }

    private long isRecursionQuery(ArrayList<String> orderNoList, MessageAcker ack, String messageId) {
        int retryCount;
        String recursionQuery = ImcConfigUtil.getValue((String)"SimConsumer", (String)"recursionQuery");
        if (!"1".equals(recursionQuery)) {
            if (this.isVehicleInvoice(orderNoList)) {
                return VehicleLabelOrgId;
            }
            ack.discard(messageId);
            return 0L;
        }
        String retryCountStr = CacheHelper.get((String)("SimConsumer" + messageId));
        int n = retryCount = StringUtils.isBlank((String)retryCountStr) ? 0 : Integer.parseInt(retryCountStr);
        if (retryCount < 3) {
            try {
                Thread.sleep(3000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            CacheHelper.put((String)("SimConsumer" + messageId), (String)String.valueOf(retryCount + 1));
            return this.getOrgId(orderNoList, ack, messageId);
        }
        if (this.isVehicleInvoice(orderNoList)) {
            return VehicleLabelOrgId;
        }
        return 0L;
    }

    private boolean isVehicleInvoice(ArrayList<String> orderNoList) {
        String orderNo = orderNoList.get(0);
        QFilter filter = new QFilter("orderno", "=", (Object)orderNo);
        return QueryServiceHelper.exists((String)"sim_vatinvoice_vehicles", (QFilter[])filter.toArray());
    }

    private void updateErrorInvoice(DynamicObject invoiceObj, String errorMsg, String errorCode) {
        if (!ErrorType.SUBMITED.getCode().equals(errorCode)) {
            invoiceObj.set("issuestatus", (Object)IssueStatusEnum.getCode((String)ResManager.loadKDString((String)"\u5f00\u7968\u5931\u8d25", (String)"IssueVatInvoiceServiceImpl_7", (String)"imc-sim-formplugin", (Object[])new Object[0])));
            invoiceObj.set("result", (Object)GBKUtils.cutGBKString((String)errorMsg, (int)200));
            ImcSaveServiceHelper.update((DynamicObject)invoiceObj);
            if (InvoiceUtils.isAllEInvoice((Object)invoiceObj.getString("invoicetype")) && invoiceObj.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) < 0) {
                String orderNo = invoiceObj.getString("orderno");
                DynamicObject redConfirm = BusinessDataServiceHelper.loadSingle((String)"sim_red_confirm_bill", (String)String.join((CharSequence)",", "issuestatus", "failreason"), (QFilter[])new QFilter("orderno", "=", (Object)orderNo).toArray());
                if (redConfirm != null) {
                    redConfirm.set("issuestatus", (Object)"3");
                    RedConfirmBillHelper.setFailReason((DynamicObject)redConfirm, (String)errorMsg);
                    ImcSaveServiceHelper.update((DynamicObject)redConfirm);
                }
            }
        }
        if (StringUtils.isNotBlank((String)invoiceObj.getString("wxid"))) {
            ThreadPools.executeOnce((String)"FAIL_INV", () -> {
                if (DynamicObjectUtil.checkDynamicObjectHasField((DynamicObject)invoiceObj, (String)"items")) {
                    CallbackMcloudUtil.dealInvoice2Mcloud((DynamicObject)invoiceObj);
                }
            });
        }
    }
}

