/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.mq.consumer.service;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.dto.ComponentResponse;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.dto.vehicle.VehicleInvoiceIssueResponseDTO;
import kd.imc.sim.common.helper.issueinvoice.IssueInvoiceMqHelper;
import kd.imc.sim.common.service.IssueInvoiceService;
import kd.imc.sim.formplugin.vehicle.validator.VehicleInvoiceValidator;
import kd.imc.sim.mq.consumer.service.AbstractIssueInvoiceService;
import org.apache.commons.lang3.tuple.Pair;

public class IssueVehicleInvoiceServiceImpl
extends AbstractIssueInvoiceService {
    private static final Log LOGGER = LogFactory.getLog(IssueVehicleInvoiceServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void issueInvoice(Object arg0, String messageId, boolean resend, MessageAcker ack) {
        ArrayList orderNoList = (ArrayList)arg0;
        List vehicleField = PropertieUtil.addFieldKey((String)"sim_vatinvoice_vehicles");
        DynamicObject firstVehicle = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice_vehicles", (String)"orgid", (QFilter[])new QFilter("orderno", "=", orderNoList.get(0)).toArray());
        Pair<Boolean, String> pair = this.getOrderByAndErrorContinue(DynamicObjectUtil.getDynamicObjectLongValue((Object)firstVehicle.get("orgid")));
        pair = this.setOrderBy(vehicleField, pair);
        DynamicObject[] vehicleInvoiceList = BusinessDataServiceHelper.load((String)"sim_vatinvoice_vehicles", (String)String.join((CharSequence)",", vehicleField), (QFilter[])new QFilter("orderno", "in", (Object)orderNoList.toArray()).and("issuestatus", "!=", (Object)IssueStatusEnum.ok.getCode()).toArray(), (String)MessageFormat.format("{0} asc", pair.getRight()));
        if (vehicleInvoiceList.length == 0) {
            ack.discard(messageId);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.error("IssueVehicleInvoiceServiceImpl \u672a\u67e5\u8be2\u5230\u975e\u5f00\u7968\u6210\u529f\u7684\u6570\u636e\uff1aorderno--\uff1a" + arg0);
            }
            return;
        }
        String lockKey = IssueInvoiceMqHelper.getIssueInvoiceLockKey((String)vehicleInvoiceList[0].getString("salertaxno"), (String)vehicleInvoiceList[0].getString("jqbh"));
        try {
            DLock lock = DLock.create((String)lockKey);
            Object object = null;
            try {
                if (!lock.tryLock(1000L)) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("\u6ca1\u6709\u83b7\u53d6\u5230\u9501\uff0c\u62d2\u7edd\u6d88\u606f" + arg0);
                    }
                    ack.deny(messageId);
                    return;
                }
                ArrayList issueErrorInvoiceList = Lists.newArrayListWithCapacity((int)vehicleInvoiceList.length);
                for (DynamicObject vehicle : vehicleInvoiceList) {
                    if (((Boolean)pair.getLeft()).booleanValue() && issueErrorInvoiceList.size() > 0) {
                        this.updateInvoiceError(issueErrorInvoiceList, vehicle, ResManager.loadKDString((String)"\u524d\u7f6e\u53d1\u7968\u5f00\u7968\u5931\u8d25\u5bfc\u81f4\u5f53\u524d\u5f00\u7968\u5931\u8d25", (String)"IssueVehicleInvoiceServiceImpl_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                    vehicle.set("issuestatus", (Object)IssueStatusEnum.underway.getCode());
                    ImcSaveServiceHelper.update((DynamicObject)vehicle);
                    try {
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info("SimConsumer-\u5f00\u59cb\u8fdb\u884c\u5f00\u7968orderno" + vehicle.getString("orderno"));
                        }
                        try {
                            VehicleInvoiceValidator.checkVehicleInvoice(vehicle);
                        }
                        catch (MsgException e) {
                            LOGGER.info("SimConsumer\u6821\u9a8c\u5931\u8d25 " + e.getErrorMsg());
                            this.updateInvoiceError(issueErrorInvoiceList, vehicle, e.getErrorMsg());
                            continue;
                        }
                        VehicleInvoiceIssueResponseDTO response = IssueVehicleInvoiceServiceImpl.issueAllVehicleInvoice(vehicle);
                        IssueInvoiceService.handleVehicleInvoiceIssueResponse((VehicleInvoiceIssueResponseDTO)response, (DynamicObject)vehicle);
                        if (ErrorType.SUCCESS.getCode().equals(response.getErrorCode()) || ErrorType.SUBMITED.getCode().equals(response.getErrorCode())) continue;
                        issueErrorInvoiceList.add(vehicle);
                    }
                    catch (Exception e) {
                        LOGGER.error("SimConsumer Exception\uff1a" + e.getMessage(), (Throwable)e);
                        this.updateInvoiceError(issueErrorInvoiceList, vehicle, e.getMessage());
                    }
                }
                if (issueErrorInvoiceList.size() > 0) {
                    ImcSaveServiceHelper.update((List)issueErrorInvoiceList);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (lock != null) {
                    if (object != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        lock.close();
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("SimConsumer \u5f00\u7968\u5f02\u5e38", (Throwable)e);
            for (DynamicObject vehicle : vehicleInvoiceList) {
                vehicle.set("issuestatus", (Object)IssueStatusEnum.getCode((String)ResManager.loadKDString((String)"\u5f00\u7968\u5931\u8d25", (String)"IssueVehicleInvoiceServiceImpl_7", (String)"imc-sim-formplugin", (Object[])new Object[0])));
                vehicle.set("result", (Object)GBKUtils.cutGBKString((String)e.getMessage(), (int)200));
            }
            ImcSaveServiceHelper.update((DynamicObject[])vehicleInvoiceList);
        }
        finally {
            ack.ack(messageId);
        }
    }

    private Pair<Boolean, String> setOrderBy(List<String> vehicleField, Pair<Boolean, String> pair) {
        String orderBy = (String)pair.getValue();
        switch ((String)pair.getRight()) {
            case "batchbelong": {
                orderBy = "batchno";
                break;
            }
            case "splitorder": {
                orderBy = "billno";
                break;
            }
            default: {
                if (vehicleField.contains(pair.getRight())) break;
                orderBy = "billno";
            }
        }
        return Pair.of((Object)pair.getLeft(), (Object)orderBy);
    }

    private void updateInvoiceError(List<DynamicObject> issueErrorInvoiceList, DynamicObject vehicle, String errMsg) {
        vehicle.set("issuestatus", (Object)IssueStatusEnum.failed.getCode());
        vehicle.set("result", (Object)GBKUtils.cutGBKString((String)errMsg, (int)160));
        issueErrorInvoiceList.add(vehicle);
    }

    public static VehicleInvoiceIssueResponseDTO issueAllVehicleInvoice(DynamicObject vehicle) {
        VehicleInvoiceIssueResponseDTO response;
        String invoiceType = vehicle.getString("invoicetype");
        if (InvoiceUtils.isAllEVehicleInv((String)invoiceType) || InvoiceUtils.isUsedCarInvoice((Object)invoiceType)) {
            MsgResponse msgResponse = IssueInvoiceService.doIssueEleVehicleInvoice((DynamicObject)vehicle);
            response = IssueInvoiceService.wrapMsgResponse((MsgResponse)msgResponse);
        } else {
            vehicle.set("invoicetype", (Object)InvoiceType.PAPER_VEHICLE_INVOICE.getTypeCode());
            ComponentResponse comResponse = IssueInvoiceService.doIssueVehicleInvoice((DynamicObject)vehicle);
            response = (VehicleInvoiceIssueResponseDTO)comResponse.getResponse();
            response.setErrorCode(comResponse.getErrcode());
            response.setDescription(comResponse.getDescription());
        }
        return response;
    }
}

