/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.schedule.redconfirm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.bdm.common.constant.allele.AllEleInterfaceTypeEnum;
import kd.imc.bdm.common.dto.allele.AllEleRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseListDTO;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.lqpt.model.request.base.redconfirmdownload.RedConfirmDetailRequest;
import kd.imc.bdm.lqpt.model.response.base.redconfirmdownload.RedConfirmDetailResponse;
import kd.imc.sim.common.dto.allele.redconfirm.AllEleRedConfirmDownLoadRequestDTO;
import kd.imc.sim.common.dto.allele.redconfirm.AllEleRedConfirmDownLoadResponseDTO;
import kd.imc.sim.common.dto.allele.redconfirm.AllEleRedConfirmItemDownLoadRequestDTO;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillHelper;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillMailHelper;
import kd.imc.sim.schedule.AbstractJobTask;
import kd.imc.sim.schedule.service.impl.RedConfirmBillDownTaskRecordImpl;

public class RedConfirmBillDownloadTask
extends AbstractJobTask {
    private static Log LOGGER = LogFactory.getLog(RedConfirmBillDownloadTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u5f00\u59cb\u4e0b\u8f7d\u7ea2\u5b57\u786e\u8ba4\u5355", (String)"RedConfirmBillDownloadTask_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), null);
        AllEleRedConfirmDownLoadRequestDTO request = (AllEleRedConfirmDownLoadRequestDTO)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)map.get("request")), AllEleRedConfirmDownLoadRequestDTO.class);
        SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)request.getOrgId());
        try (DLock lock = DLock.create((String)(saleInfo.getSaleTaxNo() + "sim_red_confirm_bill_down"), (String)ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u4e0b\u8f7d\u9501", (String)"RedConfirmBillDownloadTask_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));){
            if (!lock.tryLock(1000L)) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("success", Boolean.FALSE);
                result.put("errMsg", String.format(ResManager.loadKDString((String)"\u7a0e\u53f7%s\u6b63\u5728\u4e0b\u8f7d\u7ea2\u5b57\u786e\u8ba4\u5355\uff0c\u8bf7\u4e0b\u8f7d\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u64cd\u4f5c", (String)"RedConfirmBillDownloadTask_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), saleInfo.getSaleTaxNo()));
                this.feedbackCustomdata(result);
                return;
            }
            this.downloadRedConfirmBill(request, saleInfo);
            RedConfirmBillMailHelper.deletePushRecord(null);
        }
    }

    private void downloadRedConfirmBill(AllEleRedConfirmDownLoadRequestDTO request, SaleInfo saleInfo) {
        int totalPage;
        String taskId = RequestContext.get().getTraceId();
        HashMap<String, Object> result = new HashMap<String, Object>();
        request.setRequest_path(AllEleInterfaceTypeEnum.RED_CONFIRM_BILL_QUERY.getRequestPath());
        request.setPageSize(50);
        if ("0".equals(request.getIdentity())) {
            request.setSalerName(saleInfo.getSaleName());
            request.setSalerTaxNo(saleInfo.getSaleTaxNo());
        } else {
            request.setBuyerName(saleInfo.getSaleName());
            request.setBuyerTaxNo(saleInfo.getSaleTaxNo());
        }
        boolean isLqpt = EnterpriseHelper.isLqptChannel((String)saleInfo.getSaleTaxNo());
        AllEleRedConfirmItemDownLoadRequestDTO itemRequest = new AllEleRedConfirmItemDownLoadRequestDTO();
        itemRequest.setRequest_path(AllEleInterfaceTypeEnum.RED_CONFIRM_BILL_DETAIL_QUERY.getRequestPath());
        itemRequest.setAccount(request.getAccount());
        DynamicObject downTaskRecord = RedConfirmBillDownTaskRecordImpl.saveRedConfirmBillDownTaskRecord(taskId, request, isLqpt);
        int pageNo = 1;
        ArrayList<AllEleRedConfirmDownLoadResponseDTO> responseLists = new ArrayList<AllEleRedConfirmDownLoadResponseDTO>();
        int downcount = 0;
        do {
            int progress;
            request.setPage(pageNo);
            AllEleResponseListDTO response = isLqpt ? RedConfirmBillHelper.downloadRedConfirmHeadFromLqWithErrorCode((AllEleRedConfirmDownLoadRequestDTO)request, (SaleInfo)saleInfo) : AllEleServiceHelper.doPostList((String)saleInfo.getSaleTaxNo(), (AllEleRequestDTO)request, AllEleRedConfirmDownLoadResponseDTO.class);
            if (!response.getSuccess().booleanValue() && pageNo == 1) {
                result.put("success", Boolean.FALSE);
                result.put("errMsg", response.getDescription());
                RedConfirmBillDownTaskRecordImpl.updateRedConfirmBillDownTaskRecord(downTaskRecord, "0", 0, 0);
                this.feedbackCustomdata(result);
                return;
            }
            totalPage = (response.getTotalElement() + 50 - 1) / 50;
            downcount = response.getTotalElement();
            int pageStart = (pageNo - 1) * 50;
            List responseList = response.getData();
            if (CollectionUtils.isEmpty((Collection)responseList)) {
                result.put("success", Boolean.FALSE);
                result.put("errMsg", ResManager.loadKDString((String)"\u5f53\u524d\u6761\u4ef6\u67e5\u8be2\u65e0\u7ea2\u5b57\u786e\u8ba4\u5355", (String)"RedConfirmBillDownloadTask_3", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                this.feedbackCustomdata(result);
                RedConfirmBillDownTaskRecordImpl.updateRedConfirmBillDownTaskRecord(downTaskRecord, "1", 0, 0);
                return;
            }
            if (!request.getUpdateHead().booleanValue()) {
                for (int i = 0; i < responseList.size(); ++i) {
                    String desc = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u4e0b\u8f7d\u7b2c%1$s\u9875\u7b2c%2$s\u6761\uff0c\u5171%3$s\u9875\uff0c\u5171%4$s\u6761", (String)"RedConfirmBillDownloadTask_4", (String)"imc-sim-formplugin", (Object[])new Object[0]), pageNo, i + 1, totalPage, response.getTotalElement());
                    itemRequest.setGovRedConfirmBillUuid(((AllEleRedConfirmDownLoadResponseDTO)responseList.get(i)).getGovRedConfirmBillUuid());
                    itemRequest.setRedConfirmBillNo(((AllEleRedConfirmDownLoadResponseDTO)responseList.get(i)).getRedConfirmBillNo());
                    itemRequest.setSalerTaxNo(((AllEleRedConfirmDownLoadResponseDTO)responseList.get(i)).getSalerTaxNo());
                    AllEleResponseDTO detail = isLqpt ? this.downloadRedConfirmDetailFromLq(saleInfo.getSaleTaxNo(), itemRequest) : AllEleServiceHelper.doPost((String)saleInfo.getSaleTaxNo(), (AllEleRequestDTO)itemRequest, AllEleRedConfirmDownLoadResponseDTO.class);
                    RedConfirmBillDownTaskRecordImpl.saveRedConfirmBillDownItem(downTaskRecord, (AllEleResponseDTO<AllEleRedConfirmDownLoadResponseDTO>)detail, ((AllEleRedConfirmDownLoadResponseDTO)responseList.get(i)).getRedConfirmBillNo());
                    if (detail == null || !detail.getSuccess().booleanValue()) continue;
                    AllEleRedConfirmDownLoadResponseDTO data = (AllEleRedConfirmDownLoadResponseDTO)detail.getData();
                    if (detail.getSuccess().booleanValue()) {
                        responseLists.add(data);
                    }
                    progress = (pageStart + i) * 100 / response.getTotalElement();
                    this.feedbackProgress(progress, desc, null);
                }
            } else {
                responseLists.addAll(response.getData());
                RedConfirmBillDownTaskRecordImpl.saveRedConfirmBillDownItem(downTaskRecord, responseLists);
                progress = pageNo * 100 / totalPage;
                String desc = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u4e0b\u8f7d\u7b2c%1$s\u9875\uff0c\u5171%2$s\u9875", (String)"RedConfirmBillDownloadTask_6", (String)"imc-sim-formplugin", (Object[])new Object[0]), pageNo, totalPage);
                this.feedbackProgress(progress, desc, null);
            }
        } while (++pageNo <= totalPage);
        result.put("success", Boolean.TRUE);
        result.put("errMsg", String.format(ResManager.loadKDString((String)"\u4e0b\u8f7d\u6210\u529f\uff0c\u6210\u529f%s\u6761", (String)"RedConfirmBillDownloadTask_5", (String)"imc-sim-formplugin", (Object[])new Object[0]), responseLists.size()));
        if (!CollectionUtils.isEmpty(responseLists)) {
            try {
                new RedConfirmBillHelper().download(request, responseLists);
                result.put("errMsg", String.format(ResManager.loadKDString((String)"\u4e0b\u8f7d\u6210\u529f\uff0c\u6210\u529f%s\u6761", (String)"RedConfirmBillDownloadTask_5", (String)"imc-sim-formplugin", (Object[])new Object[0]), responseLists.size()));
            }
            catch (KDBizException e) {
                result.put("success", Boolean.FALSE);
                result.put("errMsg", e.getMessage());
            }
        }
        RedConfirmBillDownTaskRecordImpl.updateRedConfirmBillDownTaskRecord(downTaskRecord, "1", downcount, responseLists.size());
        this.feedbackCustomdata(result);
    }

    public AllEleResponseDTO<AllEleRedConfirmDownLoadResponseDTO> downloadRedConfirmDetailFromLq(String taxNo, AllEleRedConfirmItemDownLoadRequestDTO itemDownLoad) {
        RedConfirmDetailRequest lqDetailRequest = new RedConfirmDetailRequest();
        lqDetailRequest.setXsfnsrsbh(itemDownLoad.getSalerTaxNo());
        lqDetailRequest.setUuid(itemDownLoad.getGovRedConfirmBillUuid());
        lqDetailRequest.setHzqrdbh(itemDownLoad.getRedConfirmBillNo());
        lqDetailRequest.setNsrsbh(taxNo);
        AllEleResponseListDTO detailResponseDTO = RedConfirmBillHelper.queryRedConfirmDetailByLqWithErrorCode((RedConfirmDetailRequest)lqDetailRequest);
        if (null == detailResponseDTO || null == detailResponseDTO.getData()) {
            LOGGER.error(String.format("\u4e0b\u8f7d\u7ea2\u5b57\u786e\u8ba4\u5355\u5931\u8d25\uff0c\u7ea2\u5b57\u786e\u8ba4\u5355\u7f16\u53f7[%s]", itemDownLoad.getRedConfirmBillNo()));
            if (null == detailResponseDTO) {
                return null;
            }
            AllEleResponseDTO responseDTO = new AllEleResponseDTO();
            responseDTO.setErrcode(detailResponseDTO.getErrcode());
            responseDTO.setDescription(detailResponseDTO.getDescription());
            return responseDTO;
        }
        RedConfirmDetailResponse detailResponse = (RedConfirmDetailResponse)detailResponseDTO.getData().get(0);
        AllEleRedConfirmDownLoadResponseDTO parseDetail = RedConfirmBillHelper.parseDownloadResponse((RedConfirmDetailResponse)detailResponse);
        AllEleResponseDTO responseDTO = new AllEleResponseDTO();
        responseDTO.setErrcode(ErrorType.SUCCESS.getCode());
        responseDTO.setData((Object)parseDetail);
        return responseDTO;
    }
}

