/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.schedule.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.bdm.common.constant.allele.AllEleInterfaceTypeEnum;
import kd.imc.bdm.common.dto.allele.AllEleRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseListDTO;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.sim.common.dto.allele.redconfirm.AllEleRedConfirmDownLoadRequestDTO;
import kd.imc.sim.common.dto.allele.redconfirm.AllEleRedConfirmDownLoadResponseDTO;
import kd.imc.sim.common.dto.allele.redconfirm.AllEleRedConfirmItemDownLoadRequestDTO;
import kd.imc.sim.common.helper.ExecutorServiceHelper;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillHelper;
import kd.imc.sim.schedule.redconfirm.RedConfirmBillDownloadTask;
import kd.imc.sim.schedule.service.AbstractRedConfirmBillHandle;

public class RedConfirmBillAutoDownloadImpl
extends AbstractRedConfirmBillHandle {
    private static Log LOGGER = LogFactory.getLog(RedConfirmBillAutoDownloadImpl.class);

    @Override
    public boolean supportTask(DynamicObject autoTaskObj) {
        return "5".equals(autoTaskObj.getString("type"));
    }

    @Override
    public void handleTask(DynamicObject autoTaskObj) {
        List<Long> orgPks = this.getUsedOrgs(autoTaskObj);
        HashSet<Long> orgSet = this.getLongs(orgPks);
        orgPks = this.filterAllEleOrgs(orgSet, autoTaskObj);
        String applyType = autoTaskObj.getString("appliertype");
        final HashSet<String> applicantTypeSet = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)applyType)) {
            applicantTypeSet.add(applyType);
        } else {
            applicantTypeSet.add("0");
            applicantTypeSet.add("1");
        }
        Date startTime = this.getStartTime(autoTaskObj.getString("timeperiod"));
        final String taxNos = autoTaskObj.getString("taxnos");
        final String startDateStr = DateUtils.format((Date)startTime);
        final String endDateStr = DateUtils.format((Date)new Date());
        final Map saleInfoMap = TaxUtils.getOrgPkSaleInfoMap(orgPks);
        ExecutorService executorService = ExecutorServiceHelper.newFixedExcecutorService((int)5, (int)5);
        final CountDownLatch countdownlatch = new CountDownLatch(orgPks.size());
        final RequestContext requestContext = RequestContext.get();
        for (final Long orgPk : orgPks) {
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        LOGGER.info("enterRedConfirmBillAutoDownload,orgPk:" + orgPk);
                        Set<Object> otherTaxNoSet = new HashSet();
                        if (StringUtils.isNotBlank((CharSequence)taxNos)) {
                            otherTaxNoSet = Arrays.stream(taxNos.split(",")).filter(o -> StringUtils.isNotBlank((CharSequence)o)).collect(Collectors.toSet());
                        }
                        RequestContext.copyAndSet((RequestContext)requestContext);
                        RedConfirmBillAutoDownloadImpl.this.downloadOneOrgRedConfirm(applicantTypeSet, otherTaxNoSet, startDateStr, endDateStr, saleInfoMap, orgPk);
                    }
                    catch (Exception e) {
                        LOGGER.error("RedConfirmBillAutoDownloadImplError:" + e.getMessage(), (Throwable)e);
                    }
                    finally {
                        countdownlatch.countDown();
                    }
                }
            });
        }
        try {
            countdownlatch.await();
            executorService.shutdown();
        }
        catch (Exception e) {
            LOGGER.error("RedConfirmBillAutoDownloadImplError:" + e.getMessage(), (Throwable)e);
        }
    }

    private void downloadOneOrgRedConfirm(HashSet<String> applicantTypeSet, Set<String> otherTaxNoSet, String startDateStr, String endDateStr, Map<Long, SaleInfo> saleInfoMap, Long orgPk) {
        SaleInfo saleInfo = saleInfoMap.get(orgPk);
        if (null == saleInfo) {
            return;
        }
        for (String applyTypeStr : applicantTypeSet) {
            if (!otherTaxNoSet.isEmpty()) {
                for (String taxNo : otherTaxNoSet) {
                    AllEleRedConfirmDownLoadRequestDTO downRequest = new AllEleRedConfirmDownLoadRequestDTO();
                    downRequest.setOrgId(orgPk.longValue());
                    downRequest.setIdentity(applyTypeStr);
                    downRequest.setStartDate(startDateStr);
                    downRequest.setOtherSideTaxNo(taxNo);
                    downRequest.setEndDate(endDateStr);
                    downRequest.setOnlyUpdate(Boolean.valueOf(false));
                    downRequest.setFromAutoBusiness(true);
                    if ("0".equals(applyTypeStr)) {
                        downRequest.setSalerName(saleInfo.getSaleName());
                        downRequest.setSalerTaxNo(saleInfo.getSaleTaxNo());
                    } else {
                        downRequest.setBuyerName(saleInfo.getSaleName());
                        downRequest.setBuyerTaxNo(saleInfo.getSaleTaxNo());
                    }
                    this.downRedConfirm(downRequest, saleInfo);
                }
                continue;
            }
            AllEleRedConfirmDownLoadRequestDTO downRequest = new AllEleRedConfirmDownLoadRequestDTO();
            downRequest.setOrgId(orgPk.longValue());
            downRequest.setIdentity(applyTypeStr);
            downRequest.setStartDate(startDateStr);
            downRequest.setEndDate(endDateStr);
            downRequest.setOnlyUpdate(Boolean.valueOf(false));
            downRequest.setFromAutoBusiness(true);
            if ("0".equals(applyTypeStr)) {
                downRequest.setSalerName(saleInfo.getSaleName());
                downRequest.setSalerTaxNo(saleInfo.getSaleTaxNo());
            } else {
                downRequest.setBuyerName(saleInfo.getSaleName());
                downRequest.setBuyerTaxNo(saleInfo.getSaleTaxNo());
            }
            this.downRedConfirm(downRequest, saleInfo);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void downRedConfirm(AllEleRedConfirmDownLoadRequestDTO request, SaleInfo saleInfo) {
        int logRedConfirmNoSeq;
        ArrayList<AllEleRedConfirmDownLoadResponseDTO> responseLists;
        RedConfirmBillHelper redConfirmBillHelper;
        block8: {
            int totalPage;
            int pageNo;
            AllEleRedConfirmItemDownLoadRequestDTO itemRequest;
            boolean isLqpt;
            RedConfirmBillDownloadTask downTask;
            block7: {
                try {
                    downTask = new RedConfirmBillDownloadTask();
                    redConfirmBillHelper = new RedConfirmBillHelper();
                    request.setRequest_path(AllEleInterfaceTypeEnum.RED_CONFIRM_BILL_QUERY.getRequestPath());
                    request.setPageSize(50);
                    isLqpt = EnterpriseHelper.isLqptChannel((String)saleInfo.getSaleTaxNo());
                    itemRequest = new AllEleRedConfirmItemDownLoadRequestDTO();
                    itemRequest.setRequest_path(AllEleInterfaceTypeEnum.RED_CONFIRM_BILL_DETAIL_QUERY.getRequestPath());
                    itemRequest.setAccount(request.getAccount());
                    pageNo = 1;
                    responseLists = new ArrayList<AllEleRedConfirmDownLoadResponseDTO>();
                    logRedConfirmNoSeq = 0;
                    try {}
                    catch (Exception e) {
                        LOGGER.error("downRedConfirmError:" + e.getMessage(), (Throwable)e);
                        break block8;
                    }
                    break block7;
                }
                catch (Exception e) {
                    LOGGER.error("autoDownloadRedConfirmError:" + e.getMessage(), (Throwable)e);
                }
                return;
            }
            do {
                request.setPage(pageNo);
                AllEleResponseListDTO response = isLqpt ? RedConfirmBillHelper.downloadRedConfirmHeadFromLqWithErrorCode((AllEleRedConfirmDownLoadRequestDTO)request, (SaleInfo)saleInfo) : AllEleServiceHelper.doPostList((String)saleInfo.getSaleTaxNo(), (AllEleRequestDTO)request, AllEleRedConfirmDownLoadResponseDTO.class);
                if (!response.getSuccess().booleanValue() && pageNo == 1) break;
                totalPage = (response.getTotalElement() + 50 - 1) / 50;
                List responseList = response.getData();
                if (CollectionUtils.isEmpty((Collection)responseList)) break;
                if (request.getUpdateHead().booleanValue()) continue;
                for (int i = 0; i < responseList.size(); ++i) {
                    itemRequest.setGovRedConfirmBillUuid(((AllEleRedConfirmDownLoadResponseDTO)responseList.get(i)).getGovRedConfirmBillUuid());
                    itemRequest.setRedConfirmBillNo(((AllEleRedConfirmDownLoadResponseDTO)responseList.get(i)).getRedConfirmBillNo());
                    itemRequest.setSalerTaxNo(((AllEleRedConfirmDownLoadResponseDTO)responseList.get(i)).getSalerTaxNo());
                    AllEleResponseDTO detail = isLqpt ? downTask.downloadRedConfirmDetailFromLq(saleInfo.getSaleTaxNo(), itemRequest) : AllEleServiceHelper.doPost((String)saleInfo.getSaleTaxNo(), (AllEleRequestDTO)itemRequest, AllEleRedConfirmDownLoadResponseDTO.class);
                    if (detail == null || !detail.getSuccess().booleanValue()) continue;
                    AllEleRedConfirmDownLoadResponseDTO data = (AllEleRedConfirmDownLoadResponseDTO)detail.getData();
                    if (detail.getSuccess().booleanValue()) {
                        responseLists.add(data);
                    }
                    if (responseLists.size() <= 500) continue;
                    redConfirmBillHelper.download(request, responseLists);
                    logRedConfirmNoSeq = this.logRedConfirmDetail(responseLists, logRedConfirmNoSeq);
                    responseLists.clear();
                }
            } while (++pageNo <= totalPage);
        }
        if (responseLists.size() <= 0) return;
        redConfirmBillHelper.download(request, responseLists);
        this.logRedConfirmDetail(responseLists, logRedConfirmNoSeq);
        responseLists.clear();
    }
}

