/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.schedule.service.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.sim.schedule.service.AbstractRedConfirmBillHandle;

public class RedConfirmBillAutoIssueImpl
extends AbstractRedConfirmBillHandle {
    private static Log LOGGER = LogFactory.getLog(RedConfirmBillAutoIssueImpl.class);

    @Override
    public boolean supportTask(DynamicObject autoTaskObj) {
        return "0".equals(autoTaskObj.getString("type"));
    }

    @Override
    public void handleTask(DynamicObject autoTaskObj) {
        List<Long> orgPks = this.getUsedOrgs(autoTaskObj);
        HashSet<Long> orgSet = this.getLongs(orgPks);
        orgPks = this.filterAllEleOrgs(orgSet, autoTaskObj);
        Object source = autoTaskObj.get("source");
        Set sourceSet = Arrays.stream(((String)source).split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        QFilter sourceFilter = new QFilter("source", "in", sourceSet);
        QFilter uploadFitler = new QFilter("uploadstatus", "=", (Object)"1");
        String[] issueStatusArray = new String[]{"2", "3"};
        QFilter issueStatusFilter = new QFilter("issuestatus", "in", (Object)issueStatusArray);
        QFilter confirmStatusFilter = new QFilter("confirmstatus", "in", (Object)new String[]{"01", "04"});
        QFilter statusFilter = new QFilter("status", "in", (Object)new String[]{"C", "D"});
        String timePeriod = autoTaskObj.getString("timeperiod");
        Date timeStart = this.getStartTime(timePeriod);
        QFilter uploadTimeFilter = new QFilter("uploaddate", ">=", (Object)timeStart);
        for (Long orgPk : orgPks) {
            QFilter orgFilter = ImcBaseDataHelper.getRedConfirmFilter((Object)orgPk);
            QFilter[] filters = new QFilter[]{orgFilter, uploadTimeFilter, issueStatusFilter, sourceFilter, confirmStatusFilter, uploadFitler, statusFilter};
            String fields = "id,invoiceno,specialtype,buyertaxno,salertaxno,number";
            DynamicObject[] confirms = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)fields, (QFilter[])filters);
            confirms = Arrays.stream(confirms).filter(o -> StringUtils.isBlank((CharSequence)o.getString("invoiceno"))).collect(Collectors.toList()).toArray(new DynamicObject[0]);
            ArrayList<Object> needIssueRedConfirmPks = this.filterOrgAsIssueOrg(orgPk, confirms);
            if (confirms.length > 0) {
                StringBuilder builder = new StringBuilder("autoIssueRedConfirmBillNos:");
                for (DynamicObject confirm : confirms) {
                    builder.append(confirm.getString("number")).append(',');
                }
                if (builder.length() > 0) {
                    LOGGER.info(builder.toString());
                }
            }
            if (needIssueRedConfirmPks.size() <= 0) continue;
            List partitions = Lists.partition(needIssueRedConfirmPks, (int)20);
            OperateOption option = OperateOption.create();
            option.setVariableValue("sellerOrgPk", String.valueOf(orgPk));
            for (List partition : partitions) {
                try {
                    Object[] array = partition.toArray();
                    OperationServiceHelper.executeOperate((String)"issue", (String)"sim_red_confirm_bill", (Object[])array, (OperateOption)option);
                }
                catch (Exception e) {
                    LOGGER.error(String.format("issueErrorMsg:%s", e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    private ArrayList<Object> filterOrgAsIssueOrg(Long orgPk, DynamicObject[] confirms) {
        SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)orgPk);
        ArrayList<Object> needIssueRedConfirmPks = new ArrayList<Object>();
        for (DynamicObject confirm : confirms) {
            String specialType = confirm.getString("specialtype");
            if ("02".equals(specialType) && confirm.getString("buyertaxno").equals(saleInfo.getSaleTaxNo())) {
                needIssueRedConfirmPks.add(confirm.getPkValue());
                continue;
            }
            if ("02".equals(specialType) || !confirm.getString("salertaxno").equals(saleInfo.getSaleTaxNo())) continue;
            needIssueRedConfirmPks.add(confirm.getPkValue());
        }
        return needIssueRedConfirmPks;
    }
}

