/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.schedule.service.impl;

import java.util.Collection;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.bdm.common.dto.allele.AllEleResponseDTO;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.dto.allele.redconfirm.AllEleRedConfirmDownLoadRequestDTO;
import kd.imc.sim.common.dto.allele.redconfirm.AllEleRedConfirmDownLoadResponseDTO;

public class RedConfirmBillDownTaskRecordImpl {
    private static Log LOGGER = LogFactory.getLog(RedConfirmBillDownTaskRecordImpl.class);

    public static DynamicObject saveRedConfirmBillDownTaskRecord(String taskId, AllEleRedConfirmDownLoadRequestDTO request, boolean isLqpt) {
        try {
            DynamicObject downTaskRecord = RedConfirmBillDownTaskRecordImpl.convertRequestToRecord(taskId, request, isLqpt);
            downTaskRecord.set("downstatus", (Object)"2");
            downTaskRecord.set("createrfield", (Object)RequestContext.get().getCurrUserId());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{downTaskRecord});
            return downTaskRecord;
        }
        catch (Exception e) {
            LOGGER.error("\u7ea2\u5b57\u786e\u8ba4\u5355\u4e0b\u8f7d\u64cd\u4f5c\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25\uff1a", (Throwable)e);
            return null;
        }
    }

    public static void updateRedConfirmBillDownTaskRecord(DynamicObject downTaskRecord, String downstatus, Integer downcount, Integer successcount) {
        if (null == downTaskRecord) {
            return;
        }
        downTaskRecord.set("downstatus", (Object)downstatus);
        downTaskRecord.set("downcount", (Object)downcount);
        downTaskRecord.set("successcount", (Object)successcount);
        SaveServiceHelper.update((DynamicObject)downTaskRecord);
    }

    public static void saveRedConfirmBillDownItem(DynamicObject downTaskRecord, List<AllEleRedConfirmDownLoadResponseDTO> responseLists) {
        try {
            RedConfirmBillDownTaskRecordImpl.convertresponseToRecord(downTaskRecord, responseLists);
            ThreadPools.executeOnceIncludeRequestContext((String)"AsynSaveRedConfirmBillDownTaskRecord", () -> SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{downTaskRecord}));
        }
        catch (Exception e) {
            LOGGER.error("\u7ea2\u5b57\u786e\u8ba4\u5355\u4e0b\u8f7d\u64cd\u4f5c\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    public static void saveRedConfirmBillDownItem(DynamicObject downTaskRecord, AllEleResponseDTO<AllEleRedConfirmDownLoadResponseDTO> detail, String redConfirmBillNo) {
        try {
            DynamicObjectCollection items2 = downTaskRecord.getDynamicObjectCollection("items");
            RedConfirmBillDownTaskRecordImpl.converRspDetailToRecordItem(downTaskRecord, items2, (AllEleRedConfirmDownLoadResponseDTO)detail.getData(), detail.getErrcode(), detail.getDescription(), redConfirmBillNo);
            ThreadPools.executeOnceIncludeRequestContext((String)"AsynSaveRedConfirmBillDownTaskRecord", () -> SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{downTaskRecord}));
        }
        catch (Exception e) {
            LOGGER.error("\u7ea2\u5b57\u786e\u8ba4\u5355\u4e0b\u8f7d\u64cd\u4f5c\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    private static DynamicObject convertRequestToRecord(String taskId, AllEleRedConfirmDownLoadRequestDTO request, boolean isLqpt) {
        QFilter filter = new QFilter("taskid", "=", (Object)taskId);
        DynamicObject downTaskRecord = BusinessDataServiceHelper.loadSingle((String)"sim_red_down_record", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_down_record", (boolean)true), (QFilter[])filter.toArray());
        if (null == downTaskRecord) {
            downTaskRecord = BusinessDataServiceHelper.newDynamicObject((String)"sim_red_down_record");
        }
        downTaskRecord.set("taskid", (Object)taskId);
        downTaskRecord.set("applicant", (Object)request.getIdentity());
        downTaskRecord.set("orgfield", (Object)request.getOrgId());
        if ("1".equals(request.getIdentity())) {
            downTaskRecord.set("taxno", (Object)request.getBuyerTaxNo());
            downTaskRecord.set("taxname", (Object)request.getBuyerName());
        } else {
            downTaskRecord.set("taxno", (Object)request.getSalerTaxNo());
            downTaskRecord.set("taxname", (Object)request.getSalerName());
        }
        downTaskRecord.set("applytime_start", (Object)DateUtils.stringToDate((String)request.getStartDate()));
        downTaskRecord.set("applytime_end", (Object)DateUtils.stringToDate((String)request.getEndDate()));
        downTaskRecord.set("othersidename", (Object)request.getOtherSideName());
        downTaskRecord.set("originalinvoicecode", (Object)request.getOriginalInvoiceCode());
        downTaskRecord.set("originalinvoiceno", (Object)request.getOriginalInvoiceNo());
        if (request.getUpdateHead().booleanValue()) {
            downTaskRecord.set("ishead", (Object)"1");
        } else {
            downTaskRecord.set("ishead", (Object)"0");
        }
        if (isLqpt) {
            downTaskRecord.set("downloadchannel", (Object)"1");
        } else {
            downTaskRecord.set("downloadchannel", (Object)"2");
        }
        downTaskRecord.set("redconfirmbillno", (Object)request.getRedConfirmBillNo());
        return downTaskRecord;
    }

    private static void convertresponseToRecord(DynamicObject downTaskRecord, List<AllEleRedConfirmDownLoadResponseDTO> responseLists) {
        DynamicObjectCollection items2 = downTaskRecord.getDynamicObjectCollection("items");
        if (CollectionUtils.isEmpty((Collection)items2)) {
            for (AllEleRedConfirmDownLoadResponseDTO responseDTO : responseLists) {
                RedConfirmBillDownTaskRecordImpl.converRspDetailToRecordItem(downTaskRecord, items2, responseDTO, null, null, null);
            }
        }
    }

    private static void converRspDetailToRecordItem(DynamicObject downTaskRecord, DynamicObjectCollection items2, AllEleRedConfirmDownLoadResponseDTO responseDTO, String errCode, String description, String redConfirmBillNo) {
        DynamicObject item = items2.addNew();
        if (null == responseDTO) {
            item.set("itemredconfirmbillno", (Object)redConfirmBillNo);
            item.set("issuestatus", (Object)"0");
            item.set("itemcount", (Object)0);
            item.set("downsuccess", (Object)"0");
        } else {
            item.set("itemredconfirmbillno", (Object)responseDTO.getRedConfirmBillNo());
            if (StringUtils.isEmpty((Object)responseDTO.getRedInvoiceNo())) {
                item.set("issuestatus", (Object)"0");
            } else {
                item.set("issuestatus", (Object)"1");
            }
            if ("0".equals(downTaskRecord.getString("ishead"))) {
                item.set("itemcount", (Object)responseDTO.getItems().size());
                if ("0000".equals(errCode)) {
                    item.set("downsuccess", (Object)"1");
                } else {
                    item.set("downsuccess", (Object)"0");
                }
            } else {
                item.set("itemcount", (Object)0);
                item.set("downsuccess", (Object)"1");
            }
        }
        item.set("errorcode", (Object)errCode);
        description = !StringUtils.isEmpty((Object)description) && description.length() > 200 ? description.substring(200) : description;
        item.set("errormsg", (Object)description);
    }
}

