/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.schedule.syncinvoice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Strings;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.EquipmentType;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.constant.TaxRate;
import kd.imc.bdm.common.constant.allele.AllEleInterfaceTypeEnum;
import kd.imc.bdm.common.dto.allele.AllEleQueryFullInvoicesDTO;
import kd.imc.bdm.common.dto.allele.AllEleRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseListDTO;
import kd.imc.bdm.common.dto.allele.AllEleSearchOptDTO;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.enums.PushStatusEnum;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.ComponentServiceHelper;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.async.LqAsyncIssueHandlerImpl;
import kd.imc.sim.common.dto.allele.AllEleFullInvoiceItemDTO;
import kd.imc.sim.common.dto.allele.AllEleFullInvoiceResponseDTO;
import kd.imc.sim.common.dto.allele.AllVehicleBillResponseDTO;
import kd.imc.sim.common.dto.syncinvoice.SyncQueryInvoiceDTO;
import kd.imc.sim.common.helper.BwServerInvoiceHelper;
import kd.imc.sim.common.helper.LyServerInvoiceHelper;
import kd.imc.sim.common.service.IssueInvoiceService;
import kd.imc.sim.formplugin.issuing.InvoiceSyncPlugin;
import kd.imc.sim.formplugin.issuing.control.InvoiceSyncControl;
import kd.imc.sim.formplugin.issuing.control.InvoiceSyncResponseControl;
import org.apache.commons.collections.CollectionUtils;

public class SyncDevInvoiceTask
extends AbstractTask {
    private static Log LOGGER = LogFactory.getLog(SyncDevInvoiceTask.class);
    public static final String TOTAL_NUM_KEY = "TOTAL_NUM";
    public static final String SUCCESS_NUM_KEY = "SUCCESS_NUM";
    private static final Set<String> vehicleAndUsedCarRpaInvoiceTypeSet = new HashSet<String>(Arrays.asList("12", "13", "83", "84"));

    public static void dispatchDevTask(InvoiceSyncPlugin formPlugin, SyncQueryInvoiceDTO requestBody) {
        LOGGER.info("\u9500\u9879\u5168\u7968\u6c60-\u53d1\u7968\u67e5\u8be2-\u540c\u6b65\u7a0e\u76d8\u53d1\u7968...");
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(formPlugin.getView().getFormShowParameter().getAppId());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(ResManager.loadKDString((String)"\u540c\u6b65\u53d1\u7968\u5b9a\u65f6\u4efb\u52a1", (String)"SyncDevInvoiceTask_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname(SyncDevInvoiceTask.class.getName());
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        HashMap<String, SyncQueryInvoiceDTO> params = new HashMap<String, SyncQueryInvoiceDTO>();
        params.put("request", requestBody);
        jobInfo.setParams(params);
        JobFormInfo formInfo = new JobFormInfo(jobInfo);
        formInfo.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, "dispatchDevTaskCall"));
        formInfo.setCanBackground(true);
        formInfo.setTimeout(600);
        formInfo.setClickClassName("kd.imc.sim.schedule.syncinvoice.SyncInvoiceTaskClick");
        JobForm.dispatch((JobFormInfo)formInfo, (IFormView)formPlugin.getView());
    }

    public static int saveEleVehicleInvoiceData(Set<String> invoiceReplaySet, List<AllVehicleBillResponseDTO> vehicleBillData, SyncQueryInvoiceDTO body) {
        ArrayList<DynamicObject> newInvoiceList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>();
        if (CollectionUtils.isNotEmpty(vehicleBillData)) {
            for (AllVehicleBillResponseDTO responseDTO : vehicleBillData) {
                String invoiceCode = StringUtils.trimToEmpty((String)responseDTO.getInvoiceCode());
                String invoiceNo = StringUtils.trimToEmpty((String)responseDTO.getInvoiceNo());
                if (SyncDevInvoiceTask.isFilterd(responseDTO, body)) continue;
                if (!invoiceReplaySet.add(invoiceCode + invoiceNo)) {
                    LOGGER.info("\u5b58\u5728\u91cd\u590d\u7684\u53d1\u7968\u6570\u636e\uff1a\u53d1\u7968\u4ee3\u7801-{}\uff0c \u53d1\u7968\u53f7\u7801-{}", (Object)invoiceCode, (Object)invoiceNo);
                    continue;
                }
                QFilter filter = new QFilter("invoicecode", "=", (Object)invoiceCode);
                filter.and("invoiceno", "=", (Object)invoiceNo);
                DynamicObject invoiceObj = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice_vehicles", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice_vehicles"), (QFilter[])filter.toArray());
                if (null != invoiceObj) {
                    Date issueTime = invoiceObj.getDate("issuetime");
                    Date issueTimeNew = DateUtils.handleDate((String)responseDTO.getInvoiceDate());
                    if (DateUtils.isNullOrStartOfDay((Date)issueTime) && !DateUtils.isNullOrStartOfDay((Date)issueTimeNew)) {
                        invoiceObj.set("issuetime", (Object)issueTimeNew);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)responseDTO.getEtaxInvoiceNo()) && StringUtils.isEmpty((CharSequence)invoiceObj.getString("alletaxinvoiceno"))) {
                        invoiceObj.set("alletaxinvoiceno", (Object)responseDTO.getEtaxInvoiceNo());
                    }
                    updateList.add(invoiceObj);
                    continue;
                }
                invoiceObj = InvoiceSyncControl.transRpaVehicleObj((Long)body.getOrgId(), (AllVehicleBillResponseDTO)responseDTO, (SyncQueryInvoiceDTO)body);
                String taxRate = invoiceObj.getString("taxrate");
                BigDecimal invoiceAmount = invoiceObj.getBigDecimal("invoiceamount");
                if (BigDecimalUtil.compareZero((BigDecimal)invoiceAmount) && TaxRate.ZERO_PERCENT.getRateValue().equals(taxRate)) {
                    invoiceObj.set("invoiceamount", (Object)invoiceAmount);
                }
                invoiceObj.set("billno", (Object)("300_" + kd.imc.bdm.common.util.UUID.getBatchNumber() + "_0001"));
                invoiceObj.set("orderno", (Object)("vehicle_" + kd.imc.bdm.common.util.UUID.randomUUID()));
                invoiceObj.set("issuesource", (Object)"12");
                invoiceObj.set("orgid", (Object)body.getOrgId());
                invoiceObj.set("billsource", (Object)"6");
                invoiceObj.set("issuestatus", (Object)IssueStatusEnum.ok.getCode());
                invoiceObj.set("invoicetype", (Object)body.getOldInvoiceType());
                invoiceObj.set("taxpremark", (Object)"0");
                invoiceObj.set("pushstatus", (Object)PushStatusEnum.none.getCode());
                if (InvoiceUtils.isAllEVehicleOrAllEUsedCar((String)invoiceObj.getString("invoicetype"))) {
                    invoiceObj.set("ofdstatus", (Object)"0");
                } else {
                    invoiceObj.set("ofdstatus", (Object)"3");
                }
                if (BigDecimalUtil.greaterZero((BigDecimal)invoiceObj.getBigDecimal("totalamount"))) {
                    invoiceObj.set("issuetype", (Object)IssueType.BLUE_INVOICE.getTypeCode());
                } else {
                    invoiceObj.set("issuetype", (Object)IssueType.RED_INVOICE.getTypeCode());
                }
                String taxNo = invoiceObj.getString("salertaxno");
                if (InvoiceUtils.isUsedCarInvoice((Object)invoiceObj.getString("invoicetype"))) {
                    taxNo = invoiceObj.getString("issuetaxno");
                }
                Long taxOrgPk = IssueInvoiceService.getTaxOrgLongValue((String)taxNo);
                invoiceObj.set("taxorg", (Object)taxOrgPk);
                invoiceObj.set("createtime", (Object)new Date());
                newInvoiceList.add(invoiceObj);
            }
        }
        if (newInvoiceList.size() > 0) {
            DynamicObject[] dynamicObjectArray = (DynamicObject[])ImcSaveServiceHelper.save(newInvoiceList);
        }
        if (updateList.size() > 0) {
            ImcSaveServiceHelper.update(updateList);
        }
        return newInvoiceList.size() + updateList.size();
    }

    private static boolean isFilterd(AllVehicleBillResponseDTO responseDTO, SyncQueryInvoiceDTO body) {
        if (InvoiceType.PAPER_VEHICLE_INVOICE.getTypeCode().equals(body.getOldInvoiceType()) && StringUtils.isNotBlank((CharSequence)responseDTO.getEtaxInvoiceNo())) {
            return true;
        }
        if (InvoiceType.ALL_E_VEHICLE_NORMAL.getTypeCode().equals(body.getOldInvoiceType()) && StringUtils.isBlank((CharSequence)responseDTO.getEtaxInvoiceNo())) {
            return true;
        }
        if (InvoiceType.PAPER_USED_CAR_INVOICE.getTypeCode().equals(body.getOldInvoiceType()) && StringUtils.isNotBlank((CharSequence)responseDTO.getEtaxInvoiceNo())) {
            return true;
        }
        if (InvoiceType.ALL_E_VEHICLE_NORMAL.getTypeCode().equals(body.getOldInvoiceType())) {
            return StringUtils.isBlank((CharSequence)responseDTO.getEtaxInvoiceNo());
        }
        return false;
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u540c\u6b65\u53d1\u7968\u4fe1\u606f", (String)"SyncDevInvoiceTask_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), null);
        LOGGER.info("DevInvoiceQueryTaskStart...");
        SyncQueryInvoiceDTO request = (SyncQueryInvoiceDTO)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)map.get("request")), SyncQueryInvoiceDTO.class);
        String lockKey = request.getTaxNo() + request.getEquipmentType();
        try (DLock lock = DLock.create((String)lockKey, (String)"sync_invoice_lock");){
            if (!lock.tryLock(1000L)) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("success", Boolean.FALSE);
                result.put("errMsg", String.format(ResManager.loadKDString((String)"\u7a0e\u53f7%s\u6b63\u5728\u540c\u6b65\u53d1\u7968\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"SyncDevInvoiceTask_28", (String)"imc-sim-formplugin", (Object[])new Object[0]), request.getTaxNo()));
                this.feedbackCustomdata(result);
                return;
            }
            this.batchSync(request);
        }
    }

    private void batchSync(SyncQueryInvoiceDTO body) {
        String equipmentNo = body.getEquipmentNo();
        String terminalNo = body.getTerminalNo();
        String invoiceType = body.getInvoiceType();
        String equipmentType = body.getEquipmentType();
        Date startDate = DateUtils.stringToDate((String)body.getStartDate(), (String)"yyyy-MM-dd");
        Date endDate = DateUtils.stringToDate((String)body.getEndDate(), (String)"yyyy-MM-dd");
        String taxNo = body.getTaxNo();
        Long orgId = body.getOrgId();
        HashMap<String, Object> result = new HashMap<String, Object>();
        LOGGER.info("\u6279\u91cf\u540c\u6b65\u7684\u53c2\u6570\u4e3a-batchSync\uff1a{}", (Object)JSON.toJSONString((Object)body));
        int invoiceCount = 0;
        try {
            if ("8".equals(equipmentType)) {
                invoiceCount = this.bwBatchCodeSync(equipmentNo, equipmentType, terminalNo, invoiceType, startDate, taxNo, orgId);
            } else if (EquipmentType.isLyServer((String)equipmentType)) {
                invoiceCount = this.lyBatchCodeSync(equipmentNo, equipmentType, terminalNo, invoiceType, startDate, endDate, orgId);
            } else if (EquipmentHelper.isComponentDevice((String)equipmentType)) {
                invoiceCount = this.batchCodeSync(equipmentNo, equipmentType, terminalNo, invoiceType, startDate, endDate, orgId);
            } else if ("199".equals(equipmentType)) {
                Map<String, Integer> resultMap = SyncDevInvoiceTask.rpaBatchCodeSync(body, taxNo, false);
                invoiceCount = resultMap.get(SUCCESS_NUM_KEY);
            }
        }
        catch (MsgException e) {
            result.put("success", Boolean.FALSE);
            result.put("errMsg", e.getErrorMsg());
            this.feedbackCustomdata(result);
            LOGGER.error("\u53d1\u7968\u540c\u6b65\u629b\u51fa\u5f02\u5e381", (Throwable)e);
            return;
        }
        catch (Exception e) {
            result.put("success", Boolean.FALSE);
            result.put("errMsg", ResManager.loadKDString((String)"\u53d1\u7968\u6279\u91cf\u540c\u6b65\u5904\u7406\u5f02\u5e38", (String)"SyncDevInvoiceTask_11", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            LOGGER.error("\u53d1\u7968\u6279\u91cf\u540c\u6b65\u5931\u8d252", (Throwable)e);
            this.feedbackCustomdata(result);
            return;
        }
        result.put("success", Boolean.TRUE);
        result.put("errMsg", ResManager.loadKDString((String)"\u53d1\u7968\u540c\u6b65\u6210\u529f", (String)"SyncDevInvoiceTask_13", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        result.put("invoiceCount", invoiceCount);
        this.feedbackCustomdata(result);
    }

    public static Map<String, Integer> rpaBatchCodeSync(SyncQueryInvoiceDTO body, String sellerTaxNo, boolean historySync) {
        int totalPage;
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>(2);
        AllEleQueryFullInvoicesDTO request = new AllEleQueryFullInvoicesDTO();
        request.setHistorySync(historySync);
        AllEleSearchOptDTO searchOpt = new AllEleSearchOptDTO();
        searchOpt.setPageSize(Integer.valueOf(50));
        searchOpt.setDataType(Integer.valueOf(2));
        boolean fullInvoice = false;
        if ("-1".equals(body.getInvoiceType()) && body.getInvoiceNo() != null && body.getInvoiceNo().length() == 20) {
            fullInvoice = true;
        }
        if (fullInvoice || InvoiceUtils.isAllEInvoice((Object)body.getInvoiceType()) && StringUtils.isNotEmpty((CharSequence)body.getInvoiceNo())) {
            searchOpt.setInvoiceCode("");
            searchOpt.setQdInvoiceNo(body.getInvoiceNo());
        } else {
            searchOpt.setInvoiceCode(body.getInvoiceCode());
            searchOpt.setInvoiceNo(body.getInvoiceNo());
        }
        if (StringUtils.isNotEmpty((CharSequence)body.getAccount())) {
            request.setAccount(body.getAccount());
        }
        searchOpt.setStartTime(body.getStartDate());
        searchOpt.setEndTime(body.getEndDate());
        String invoiceType = body.getInvoiceType();
        invoiceType = StringUtils.isEmpty((CharSequence)invoiceType) || StringUtils.equals((CharSequence)invoiceType, (CharSequence)"-1") ? "" : InvoiceSyncControl.transAllEleType((String)invoiceType);
        searchOpt.setInvoiceType(invoiceType);
        request.setRequest_path(AllEleInterfaceTypeEnum.PAGE_QUERY_FULL_INVOICE_BODY.getRequestPath());
        int pageNo = 1;
        int invoiceCount = 0;
        HashSet<String> invoiceReplaySet = new HashSet<String>();
        int totalNum = 0;
        do {
            List data;
            searchOpt.setPageNo(Integer.valueOf(pageNo));
            request.setSearchOpt(searchOpt);
            LOGGER.info("rpaBatchCodeSync\u53c2\u6570\u4e3a\uff1a{}-pageNo\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)request), (Object)pageNo);
            AllEleResponseListDTO response = AllEleServiceHelper.doPostList((String)sellerTaxNo, (AllEleRequestDTO)request, AllEleFullInvoiceResponseDTO.class);
            if (!StringUtils.equals((CharSequence)response.getErrcode(), (CharSequence)ErrorType.SUCCESS.getCode())) {
                throw new MsgException(response.getDescription());
            }
            int totalElement = response.getTotalElement();
            if (totalNum == 0) {
                totalNum = totalElement;
            }
            int lastElement = totalElement % 50;
            totalPage = totalElement / 50;
            if (lastElement > 0) {
                ++totalPage;
            }
            if (CollectionUtils.isEmpty((Collection)(data = response.getData()))) {
                if (pageNo != 1) continue;
                throw new MsgException(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u540c\u6b65\u7684\u53d1\u7968\u6570\u636e", (String)"SyncDevInvoiceTask_19", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            invoiceCount += SyncDevInvoiceTask.saveEleFullInvoiceData(invoiceReplaySet, data, body);
            ++pageNo;
        } while (pageNo <= totalPage);
        resultMap.put(TOTAL_NUM_KEY, totalNum);
        resultMap.put(SUCCESS_NUM_KEY, invoiceCount);
        return resultMap;
    }

    public static int saveEleFullInvoiceData(Set<String> invoiceReplaySet, List<AllEleFullInvoiceResponseDTO> data, SyncQueryInvoiceDTO body) {
        ArrayList<DynamicObject> newInvoiceList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>();
        int lqSuccessSize = 0;
        for (AllEleFullInvoiceResponseDTO responseDTO : data) {
            String invoiceCode = StringUtils.trimToEmpty((String)responseDTO.getInvoiceCode());
            String invoiceNo = StringUtils.trimToEmpty((String)responseDTO.getInvoiceNo());
            if (!invoiceReplaySet.add(invoiceCode + invoiceNo)) {
                LOGGER.info("\u5b58\u5728\u91cd\u590d\u7684\u53d1\u7968\u6570\u636e\uff1a\u53d1\u7968\u4ee3\u7801-{}\uff0c \u53d1\u7968\u53f7\u7801-{}", (Object)invoiceCode, (Object)invoiceNo);
                continue;
            }
            if (vehicleAndUsedCarRpaInvoiceTypeSet.contains(responseDTO.getInvoiceType()) && "-1".equals(body.getInvoiceType())) continue;
            QFilter filter = new QFilter("invoicecode", "=", (Object)invoiceCode);
            filter.and("invoiceno", "=", (Object)invoiceNo);
            DynamicObject invoiceObj = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])filter.toArray());
            if (invoiceObj != null) {
                boolean isSave = false;
                if ("13".equals(invoiceObj.getString("issuesource")) && !IssueStatusEnum.ok.getCode().equals(invoiceObj.getString("issuestatus"))) {
                    lqSuccessSize += SyncDevInvoiceTask.lqInvoiceSuccessCheck(invoiceObj, responseDTO);
                    continue;
                }
                if (body.isFromHistorySync() && "00".equals(invoiceObj.getString("specialtype"))) {
                    invoiceObj = InvoiceSyncControl.fillSpecialFields((DynamicObject)invoiceObj, (AllEleFullInvoiceResponseDTO)responseDTO, (boolean)true);
                }
                if (StringUtils.isNotEmpty((CharSequence)responseDTO.getEtaxInvoiceNo()) && StringUtils.isEmpty((CharSequence)invoiceObj.getString("alletaxinvoiceno"))) {
                    invoiceObj.set("alletaxinvoiceno", (Object)responseDTO.getEtaxInvoiceNo());
                }
                if (!InvoiceUtils.isAllEInvoice((Object)invoiceObj.getString("invoicetype")) || !"3".equals(invoiceObj.getString("invoicestatus"))) {
                    String invoiceStatus = InvoiceSyncControl.transInvoiceStatus((String)responseDTO.getInvoiceStatus());
                    invoiceObj.set("invoicestatus", (Object)invoiceStatus);
                }
                Date issueTime = invoiceObj.getDate("issuetime");
                Date issueTimeNew = DateUtils.handleDate((String)responseDTO.getInvoiceDate());
                if (DateUtils.isNullOrStartOfDay((Date)issueTime) && !DateUtils.isNullOrStartOfDay((Date)issueTimeNew)) {
                    invoiceObj.set("issuetime", (Object)issueTimeNew);
                }
                IssueInvoiceService.setBlueInvoiceItemRedPrice((DynamicObject)invoiceObj, (AllEleFullInvoiceResponseDTO)responseDTO);
                if ("1".equals(ImcConfigUtil.getValue((String)"updateDbInv", (String)"updateDbInv"))) {
                    LOGGER.info("enterUpdateDbInv");
                    invoiceObj = SyncDevInvoiceTask.updateDbInvFromSyncData(body, responseDTO, invoiceObj);
                }
                LOGGER.info("\u66f4\u65b0\u6570\u7535\u7968\u6570\u636e...");
                IssueInvoiceService.dealInvoiceRemarkByIssueType((DynamicObject)invoiceObj, (AllEleFullInvoiceResponseDTO)responseDTO);
                if (isSave) {
                    newInvoiceList.add(invoiceObj);
                } else {
                    updateList.add(invoiceObj);
                }
            } else {
                invoiceObj = InvoiceSyncControl.transRpaObj((Long)body.getOrgId(), (AllEleFullInvoiceResponseDTO)responseDTO);
                if (body.isFromHistorySync()) {
                    InvoiceSyncControl.fillSpecialFields((DynamicObject)invoiceObj, (AllEleFullInvoiceResponseDTO)responseDTO, (boolean)false);
                }
                invoiceObj.set("billno", (Object)("300_" + kd.imc.bdm.common.util.UUID.getBatchNumber() + "_0001"));
                invoiceObj.set("orderno", (Object)kd.imc.bdm.common.util.UUID.randomUUID());
                invoiceObj.set("issuesource", (Object)"12");
                invoiceObj.set("orgid", (Object)body.getOrgId());
                invoiceObj.set("ofdstatus", (Object)"0");
                IssueInvoiceService.updateDiscountInfo((DynamicObject)invoiceObj);
                newInvoiceList.add(invoiceObj);
            }
            invoiceObj.set("issuestatus", (Object)IssueStatusEnum.ok.getCode());
            IssueInvoiceService.updateBaseInvoiceType((DynamicObject)invoiceObj);
        }
        InvoiceSyncControl.afterCommonBatchSync(newInvoiceList, updateList);
        return newInvoiceList.size() + updateList.size() + lqSuccessSize;
    }

    private static int lqInvoiceSuccessCheck(DynamicObject compareInvoice, AllEleFullInvoiceResponseDTO checkInvoice) {
        try {
            LOGGER.info(String.format("\u5f00\u59cb\u6bd4\u5bf9\u53d1\u7968\uff0c\u53d1\u7968\u53f7\u7801[%s]", compareInvoice.getString("invoiceno")));
            String checkBuyerName = StringUtils.trimToEmpty((String)checkInvoice.getBuyerName()).replaceAll("\\(\u4e2a\u4eba\\)", "").replaceAll("\uff08\u4e2a\u4eba\uff09", "");
            String buyerName = StringUtils.trimToEmpty((String)compareInvoice.getString("buyername")).replaceAll("\\(\u4e2a\u4eba\\)", "").replaceAll("\uff08\u4e2a\u4eba\uff09", "");
            if (!buyerName.equals(checkBuyerName)) {
                LOGGER.info("\u8d2d\u65b9\u540d\u79f0\u6bd4\u5bf9\u4e0d\u4e00\u81f4");
                return 0;
            }
            if (!StringUtils.trimToEmpty((String)checkInvoice.getBuyerTaxNo()).equals(compareInvoice.getString("buyertaxno"))) {
                LOGGER.info("\u8d2d\u65b9\u7a0e\u53f7\u6bd4\u5bf9\u4e0d\u4e00\u81f4");
                return 0;
            }
            if (!StringUtils.trimToEmpty((String)checkInvoice.getInvoiceDate()).equals(DateUtils.format((Date)compareInvoice.getDate("issuetime"), (String)"yyyy-MM-dd HH:mm:ss"))) {
                LOGGER.info("\u5f00\u7968\u65e5\u671f\u6bd4\u5bf9\u4e0d\u4e00\u81f4");
                return 0;
            }
            if (StringUtils.isBlank((CharSequence)checkInvoice.getInvoiceAmount()) || compareInvoice.getBigDecimal("invoiceamount").setScale(2, 4).compareTo(new BigDecimal(checkInvoice.getInvoiceAmount())) != 0) {
                LOGGER.info("\u5f00\u7968\u91d1\u989d\u6bd4\u5bf9\u4e0d\u4e00\u81f4");
                return 0;
            }
            if (StringUtils.isBlank((CharSequence)checkInvoice.getTotalTaxAmount()) || compareInvoice.getBigDecimal("totaltax").setScale(2, 4).compareTo(new BigDecimal(checkInvoice.getTotalTaxAmount())) != 0) {
                LOGGER.info("\u5f00\u7968\u7a0e\u989d\u6bd4\u5bf9\u4e0d\u4e00\u81f4");
                return 0;
            }
            if (StringUtils.isBlank((CharSequence)checkInvoice.getTotalAmount()) || compareInvoice.getBigDecimal("totalamount").setScale(2, 4).compareTo(new BigDecimal(checkInvoice.getTotalAmount())) != 0) {
                LOGGER.info("\u4ef7\u7a0e\u5408\u8ba1\u6bd4\u5bf9\u4e0d\u4e00\u81f4");
                return 0;
            }
            DynamicObjectCollection invoiceItems = compareInvoice.getDynamicObjectCollection("items");
            List checkItemList = checkInvoice.getItems();
            if (checkItemList == null || invoiceItems.size() != checkItemList.size()) {
                LOGGER.info("\u660e\u7ec6\u884c\u6570\u6bd4\u5bf9\u4e0d\u4e00\u81f4");
                return 0;
            }
            for (int i = 0; i < invoiceItems.size(); ++i) {
                DynamicObject invoiceItem = (DynamicObject)invoiceItems.get(i);
                AllEleFullInvoiceItemDTO checkItem = (AllEleFullInvoiceItemDTO)checkItemList.get(i);
                int index = i + 1;
                if (invoiceItem.getBigDecimal("amount").setScale(2, 4).compareTo(new BigDecimal(checkItem.getDetailAmount())) != 0) {
                    LOGGER.info(String.format("\u660e\u7ec6\u7b2c%s\u884c\u91d1\u989d\u6bd4\u5bf9\u4e0d\u4e00\u81f4", index));
                    return 0;
                }
                if (invoiceItem.getBigDecimal("tax").setScale(2, 4).compareTo(new BigDecimal(checkItem.getTaxAmount())) != 0) {
                    LOGGER.info(String.format("\u660e\u7ec6\u7b2c%s\u884c\u7a0e\u989d\u6bd4\u5bf9\u4e0d\u4e00\u81f4", index));
                    return 0;
                }
                if (!StringUtils.trimToEmpty((String)invoiceItem.getString("specification")).equals(StringUtils.trimToEmpty((String)checkItem.getSpecModel()))) {
                    LOGGER.info(String.format("\u660e\u7ec6\u7b2c%s\u884c\u89c4\u683c\u578b\u53f7\u6bd4\u5bf9\u4e0d\u4e00\u81f4", index));
                    return 0;
                }
                String specialType = compareInvoice.getString("specialtype");
                if (!("E06".equals(specialType) || "E05".equals(specialType) || StringUtils.trimToEmpty((String)invoiceItem.getString("unit")).equals(StringUtils.trimToEmpty((String)checkItem.getUnit())))) {
                    LOGGER.info(String.format("\u660e\u7ec6\u7b2c%s\u884c\u5355\u4f4d\u6bd4\u5bf9\u4e0d\u4e00\u81f4", index));
                    return 0;
                }
                if (StringUtils.trimToEmpty((String)invoiceItem.getString("goodsname")).contains(StringUtils.trimToEmpty((String)checkItem.getGoodsName()))) continue;
                LOGGER.info(String.format("\u660e\u7ec6\u7b2c%s\u884c\u5546\u54c1\u540d\u79f0\u6bd4\u5bf9\u4e0d\u4e00\u81f4", index));
                return 0;
            }
            DynamicObject asyncInvoice = BusinessDataServiceHelper.newDynamicObject((String)"sim_async_issue_invoice");
            asyncInvoice.set("invoiceno", (Object)checkInvoice.getInvoiceNo());
            asyncInvoice.set("issuetime", (Object)DateUtils.handleDate((String)checkInvoice.getInvoiceDate()));
            new LqAsyncIssueHandlerImpl().handleLqptInvoiceSuccess(compareInvoice, asyncInvoice);
            return 1;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static DynamicObject updateDbInvFromSyncData(SyncQueryInvoiceDTO body, AllEleFullInvoiceResponseDTO responseDTO, DynamicObject invoiceObj) {
        try {
            BigDecimal responseTotalAmount = BigDecimal.ONE;
            try {
                responseTotalAmount = new BigDecimal(responseDTO.getTotalAmount());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!BigDecimalUtil.compareZero((BigDecimal)invoiceObj.getBigDecimal("totalamount").subtract(responseTotalAmount))) {
                DynamicObject rpaDownloadObj = InvoiceSyncControl.transRpaObj((Long)body.getOrgId(), (AllEleFullInvoiceResponseDTO)responseDTO);
                DynamicObjectCollection rpaItems = rpaDownloadObj.getDynamicObjectCollection("items");
                DynamicObjectCollection dbItems = invoiceObj.getDynamicObjectCollection("items");
                invoiceObj.set("totalamount", rpaDownloadObj.get("totalamount"));
                invoiceObj.set("invoiceamount", rpaDownloadObj.get("invoiceamount"));
                invoiceObj.set("totaltax", rpaDownloadObj.get("totaltax"));
                for (int i = 0; i < rpaItems.size(); ++i) {
                    if (i == 0 && dbItems.size() > rpaItems.size()) {
                        HashSet<Long> needDeleteItemPks = new HashSet<Long>(rpaItems.size());
                        for (int j = 0; j < dbItems.size(); ++j) {
                            if (j + 1 <= rpaItems.size()) continue;
                            needDeleteItemPks.add(((DynamicObject)dbItems.get(j)).getLong("id"));
                        }
                        Iterator it = dbItems.iterator();
                        while (it.hasNext()) {
                            DynamicObject redConfirmItem = (DynamicObject)it.next();
                            if (!needDeleteItemPks.contains(redConfirmItem.getLong("id"))) continue;
                            it.remove();
                        }
                    }
                    if (i == 0 && dbItems.size() < rpaItems.size()) {
                        int needAdd = rpaItems.size() - dbItems.size();
                        for (int k = 0; k < needAdd; ++k) {
                            dbItems.addNew();
                        }
                    }
                    DynamicObject rpaItem = (DynamicObject)rpaItems.get(i);
                    DynamicObject dbItem = (DynamicObject)dbItems.get(i);
                    dbItem.set("goodsname", rpaItem.get("goodsname"));
                    dbItem.set("unit", rpaItem.get("unit"));
                    dbItem.set("amount", rpaItem.get("amount"));
                    dbItem.set("tax", rpaItem.get("tax"));
                    dbItem.set("num", rpaItem.get("num"));
                    dbItem.set("taxrate", rpaItem.get("taxrate"));
                    dbItem.set("taxamount", rpaItem.get("taxamount"));
                    dbItem.set("unitprice", rpaItem.get("unitprice"));
                    if (!BigDecimalUtil.compareZero((BigDecimal)dbItem.getBigDecimal("num"))) {
                        BigDecimal taxUnitprice = dbItem.getBigDecimal("taxamount").divide(dbItem.getBigDecimal("num"), 8, RoundingMode.HALF_UP);
                        dbItem.set("taxunitprice", (Object)taxUnitprice);
                    }
                    dbItem.set("taxflag", rpaItem.get("taxflag"));
                    dbItem.set("goodscode", rpaItem.get("goodscode"));
                    dbItem.set("zerotaxmark", rpaItem.get("zerotaxmark"));
                    dbItem.set("specification", rpaItem.get("specification"));
                    dbItem.set("seq", rpaItem.get("seq"));
                    dbItem.set("itemremainredamount", rpaItem.get("itemremainredamount"));
                    dbItem.set("itemremainredtax", rpaItem.get("itemremainredtax"));
                    dbItem.set("itemremainrednum", rpaItem.get("itemremainrednum"));
                }
                invoiceObj = (DynamicObject)ImcSaveServiceHelper.save((DynamicObject)invoiceObj);
            }
        }
        catch (Exception e) {
            LOGGER.info("enterDbInvError:" + e.getMessage(), (Object)e);
        }
        return invoiceObj;
    }

    public int batchCodeSync(String equipmentNo, String equipmentType, String terminalNo, String invoiceType, Date startDate, Date endDate, Long orgId) throws InterruptedException {
        ArrayList<DynamicObject> newInvoiceList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>();
        int ymxh = 0;
        int syncNum = 10;
        while (ymxh >= 0) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("czlx", (Object)"38");
            jsonObject.put("hxbzdh", (Object)(StringUtils.isEmpty((CharSequence)terminalNo) ? "" : terminalNo));
            JSONObject dataObject = new JSONObject();
            if (!Strings.isNullOrEmpty((String)invoiceType)) {
                if ("-1".equals(invoiceType)) {
                    invoiceType = "";
                }
                dataObject.put("kpzl", (Object)invoiceType);
            }
            dataObject.put("kssj", (Object)DateUtils.format((Date)startDate, (String)"yyyyMMdd"));
            dataObject.put("jzsj", (Object)DateUtils.format((Date)endDate, (String)"yyyyMMdd"));
            dataObject.put("mysl", (Object)String.valueOf(syncNum));
            dataObject.put("ymxh", (Object)(ymxh + ""));
            jsonObject.put("sjd", (Object)dataObject);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("\u6279\u91cf\u540c\u6b65\u53d1\u7968\u8bf7\u6c42\uff1a" + jsonObject);
            }
            JSONObject responseJson = this.doBatchSyncHttpRequest(equipmentNo, jsonObject);
            String errCode = responseJson.getString("errcode");
            String description = responseJson.getString("description");
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("\u53d1\u7968\u7a0e\u76d8\u540c\u6b65 responseJson: " + responseJson);
            }
            if (!ErrorType.SUCCESS.getCode().equals(errCode)) {
                throw new MsgException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u540c\u6b65\u5931\u8d25\uff1a%s", (String)"SyncDevInvoiceTask_29", (String)"imc-sim-formplugin", (Object[])new Object[0]), description));
            }
            JSONObject resultObj = responseJson.getJSONObject("sjd");
            int number = resultObj.getInteger("zjsl");
            if (number <= 0) {
                throw new MsgException(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u540c\u6b65\u7684\u53d1\u7968\u6570\u636e", (String)"SyncDevInvoiceTask_19", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            if (number > 5000) {
                throw new MsgException(ResManager.loadKDString((String)"\u5355\u6b21\u540c\u6b65\u53d1\u7968\u603b\u6570\u5927\u4e8e5000\uff0c\u8bf7\u8c03\u6574\u6279\u91cf\u540c\u6b65\u65f6\u95f4\u51cf\u5c11\u5355\u6b21\u540c\u6b65\u6570\u91cf\uff01", (String)"SyncDevInvoiceTask_20", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            ymxh = number - (ymxh + 1) * syncNum > 0 ? ++ymxh : -1;
            JSONArray fpjh = resultObj.getJSONArray("fpjh");
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("\u53d1\u7968\u7a0e\u76d8\u540c\u6b65 \u7b2c%s\u6b21\u540c\u6b65\u53d1\u7968\u6570\u91cf\uff1a%s", ymxh, fpjh.size()));
            }
            for (int i = 0; i < fpjh.size(); ++i) {
                JSONObject fpObj = fpjh.getJSONObject(i);
                DynamicObject invoiceObj = this.getInvoiceObj(fpObj.getString("fpdm"), fpObj.getString("fphm"));
                boolean invoiceExist = false;
                if (invoiceObj == null) {
                    LOGGER.info("\u53d1\u7968\u7a0e\u76d8\u540c\u6b65\uff0c\u53d1\u7968\u4e0d\u5b58\u5728\uff0c" + fpObj.getString("ddh"));
                    if (!StringUtils.isEmpty((CharSequence)fpObj.getString("ddh"))) {
                        QFilter filter2 = new QFilter("orderno", "=", (Object)fpObj.getString("ddh"));
                        invoiceObj = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice"), (QFilter[])filter2.toArray());
                        if (invoiceObj != null) {
                            LOGGER.info("\u53d1\u7968\u7a0e\u76d8\u540c\u6b65\uff0c\u901a\u8fc7\u6d41\u6c34\u53f7\u67e5\u8be2\uff0c\u53d1\u7968\u5df2\u5b58\u5728 " + fpObj.getString("ddh"));
                            invoiceExist = true;
                        } else {
                            LOGGER.info("\u53d1\u7968\u7a0e\u76d8\u540c\u6b65\uff0c\u901a\u8fc7\u6d41\u6c34\u53f7\u67e5\u8be2\uff0c\u53d1\u7968\u4e0d\u5b58\u5728 " + fpObj.getString("ddh"));
                        }
                    }
                } else {
                    invoiceExist = true;
                }
                if (invoiceExist) {
                    InvoiceSyncControl.invoiceExist((JSONObject)fpObj, (DynamicObject)invoiceObj);
                    updateList.add(invoiceObj);
                } else {
                    invoiceObj = InvoiceSyncControl.transObj((JSONObject)fpObj);
                    invoiceObj.set("orderno", (Object)kd.imc.bdm.common.util.UUID.randomUUID());
                    this.setInvoiceObj(equipmentType, equipmentNo, orgId, invoiceObj);
                    IssueInvoiceService.updateDiscountInfo((DynamicObject)invoiceObj);
                    newInvoiceList.add(invoiceObj);
                }
                invoiceObj.set("issuestatus", (Object)IssueStatusEnum.ok.getCode());
                InvoiceSyncControl.updateOriginInvoiceCodeByRemark((DynamicObject)invoiceObj);
                IssueInvoiceService.updateBaseInvoiceType((DynamicObject)invoiceObj);
            }
        }
        InvoiceSyncControl.afterCommonBatchSync(newInvoiceList, updateList);
        return newInvoiceList.size() + updateList.size();
    }

    private DynamicObject getInvoiceObj(String invoiceCode, String invoiceNo) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("\u53d1\u7968\u7a0e\u76d8\u540c\u6b65\uff1a%s - %s", invoiceCode, invoiceNo));
        }
        QFilter filter = new QFilter("invoicecode", "=", (Object)invoiceCode);
        filter.and("invoiceno", "=", (Object)invoiceNo);
        DynamicObject invoiceObj = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice"), (QFilter[])filter.toArray());
        return invoiceObj;
    }

    private int bwBatchCodeSync(String equipmentNo, String equipmentType, String terminalNo, String invoiceType, Date startDate, String salerTaxNo, Long orgId) {
        ArrayList<DynamicObject> newInvoiceList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>();
        JSONObject invoiceJson = this.createResultJson(terminalNo, invoiceType);
        invoiceJson.put("issuetime", (Object)startDate);
        invoiceJson.put("salertaxno", (Object)salerTaxNo);
        invoiceJson.put("jqbh", (Object)equipmentNo);
        MsgResponse msgResponse = BwServerInvoiceHelper.getInvoice((JSONObject)invoiceJson);
        if (!ErrorType.SUCCESS.getCode().equals(msgResponse.getErrorCode())) {
            LOGGER.error(msgResponse.getErrorMsg());
            throw new MsgException(msgResponse.getErrorMsg());
        }
        JSONArray invoiceArr = JSONObject.parseArray((String)msgResponse.getRespData());
        int number = invoiceArr.size();
        if (number <= 0) {
            throw new MsgException(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u540c\u6b65\u7684\u53d1\u7968\u6570\u636e", (String)"SyncDevInvoiceTask_19", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        for (int i = 0; i < invoiceArr.size(); ++i) {
            JSONObject resultObj = invoiceArr.getJSONObject(i);
            DynamicObject invoiceObj = this.getInvoiceObj(resultObj.getString("fpdm"), resultObj.getString("fphm"));
            if (invoiceObj != null) {
                InvoiceSyncControl.invoiceExistBw((JSONObject)resultObj, (DynamicObject)invoiceObj);
                updateList.add(invoiceObj);
            } else {
                invoiceObj = InvoiceSyncControl.transBwObj((String)invoiceType, (JSONObject)resultObj);
                IssueInvoiceService.updateDiscountInfo((DynamicObject)invoiceObj);
                this.setInvoiceObj(equipmentType, equipmentNo, orgId, invoiceObj);
                newInvoiceList.add(invoiceObj);
            }
            invoiceObj.set("issuestatus", (Object)IssueStatusEnum.ok.getCode());
            IssueInvoiceService.updateBaseInvoiceType((DynamicObject)invoiceObj);
            InvoiceSyncControl.updateOriginInvoiceCodeByRemark((DynamicObject)invoiceObj);
        }
        InvoiceSyncControl.afterCommonBatchSync(newInvoiceList, updateList);
        return newInvoiceList.size() + updateList.size();
    }

    private void setInvoiceObj(String equipmentType, String equipmentNo, Long orgId, DynamicObject invoiceObj) {
        invoiceObj.set("issuesource", (Object)equipmentType);
        invoiceObj.set("jqbh", (Object)equipmentNo);
        invoiceObj.set("billno", (Object)("300_" + kd.imc.bdm.common.util.UUID.getBatchNumber() + "_0001"));
        invoiceObj.set("orgid", (Object)orgId);
        invoiceObj.set("ofdstatus", (Object)"0");
    }

    private JSONObject doBatchSyncHttpRequest(String equipmentNo, JSONObject requestJson) throws InterruptedException {
        JSONObject responseJson = ComponentServiceHelper.doPost((String)ComponentServiceHelper.getComponentRequestUrl((String)equipmentNo), (String)JSONObject.toJSONString((Object)requestJson));
        if ("0001".equals(responseJson.getString("errcode")) || "0002".equals(responseJson.getString("errcode"))) {
            Thread.sleep(3000L);
            responseJson = this.doBatchSyncHttpRequest(equipmentNo, requestJson);
        }
        return responseJson;
    }

    private JSONObject createResultJson(String terminalNo, String invoiceType) {
        JSONObject invoiceJson = new JSONObject();
        invoiceJson.put("terminalno", (Object)terminalNo);
        if (StringUtils.isBlank((CharSequence)invoiceType) || "-1".equals(invoiceType)) {
            throw new MsgException(ResManager.loadKDString((String)"\u8be5\u76d8\u7c7b\u578b\u9700\u8981\u6307\u5b9a\u53d1\u7968\u79cd\u7c7b\u8fdb\u884c\u540c\u6b65", (String)"SyncDevInvoiceTask_26", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        invoiceJson.put("invoicetype", (Object)InvoiceSyncControl.transType((String)invoiceType));
        return invoiceJson;
    }

    public int lyBatchCodeSync(String equipmentNo, String equipmentType, String terminalNo, String invoiceType, Date startDate, Date endDate, long orgId) {
        ArrayList<DynamicObject> newInvoiceList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>();
        JSONObject invoiceJson = this.createResultJson(terminalNo, invoiceType);
        invoiceJson.put("startDate", (Object)startDate);
        invoiceJson.put("endDate", (Object)endDate);
        invoiceJson.put("jqbh", (Object)equipmentNo);
        MsgResponse msgResponse = LyServerInvoiceHelper.getInvoice((JSONObject)invoiceJson);
        if (!ErrorType.SUCCESS.getCode().equals(msgResponse.getErrorCode())) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u53d1\u7968\u540c\u6b65\u5931\u8d25\uff1a%s", (String)"SyncDevInvoiceTask_29", (String)"imc-sim-formplugin", (Object[])new Object[0]), msgResponse == null ? ResManager.loadKDString((String)"\u8bf7\u6c42\u5931\u8d25", (String)"SyncDevInvoiceTask_27", (String)"imc-sim-formplugin", (Object[])new Object[0]) : msgResponse.getErrorMsg());
            LOGGER.error(errMsg);
            throw new MsgException(errMsg);
        }
        JSONArray invoiceArr = JSONObject.parseArray((String)msgResponse.getRespData());
        int number = invoiceArr.size();
        if (number <= 0) {
            throw new MsgException(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u540c\u6b65\u7684\u53d1\u7968\u6570\u636e", (String)"SyncDevInvoiceTask_19", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        for (int i = 0; i < invoiceArr.size(); ++i) {
            JSONObject resultObj = invoiceArr.getJSONObject(i);
            DynamicObject invoiceObj = this.getInvoiceObj(resultObj.getString("invoicecode"), resultObj.getString("invoiceno"));
            if (invoiceObj != null) {
                InvoiceSyncResponseControl.invoiceExist((JSONObject)resultObj, (DynamicObject)invoiceObj);
                updateList.add(invoiceObj);
            } else {
                invoiceObj = InvoiceSyncResponseControl.transObj((JSONObject)resultObj);
                this.setInvoiceObj(equipmentType, equipmentNo, orgId, invoiceObj);
                InvoiceUtils.filterOneInvoiceIllegalItems((DynamicObject)invoiceObj);
                IssueInvoiceService.setBlueInvoiceRemainRedAmount((DynamicObject)invoiceObj);
                IssueInvoiceService.updateDiscountInfo((DynamicObject)invoiceObj);
                newInvoiceList.add(invoiceObj);
            }
            invoiceObj.set("issuestatus", (Object)IssueStatusEnum.ok.getCode());
            IssueInvoiceService.updateBaseInvoiceType((DynamicObject)invoiceObj);
            InvoiceSyncControl.updateOriginInvoiceCodeByRemark((DynamicObject)invoiceObj);
        }
        InvoiceSyncControl.afterCommonBatchSync(newInvoiceList, updateList);
        return newInvoiceList.size() + updateList.size();
    }
}

