/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.async;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dlock.DLock;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imc.bdm.common.constant.allele.AllEleInterfaceTypeEnum;
import kd.imc.bdm.common.dto.allele.AllEleRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseDTO;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.constant.RpaErrorType;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.async.AbstractAsyncIssueHandler;
import kd.imc.sim.common.dto.allele.issue.AllEleIssueResponseDTO;
import kd.imc.sim.common.dto.vehicle.VehicleInvoiceIssueResponseDTO;
import kd.imc.sim.common.helper.allele.AllEleInvoiceFileHelper;
import kd.imc.sim.common.helper.allele.CreditQuotaHelper;
import kd.imc.sim.common.service.IssueInvoiceService;
import org.apache.commons.lang3.StringUtils;

public class RpaAsyncIssueHandlerImpl
extends AbstractAsyncIssueHandler {
    public void handlerInvoice(List<DynamicObject> asyncInvoices) {
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(asyncInvoices.size());
        for (DynamicObject asyncInvoice : asyncInvoices) {
            this.handlerOneInvoice(updateList, asyncInvoice);
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            ImcSaveServiceHelper.save(updateList);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handlerOneInvoice(List<DynamicObject> updateList, DynamicObject asyncInvoice) {
        String orderNo = asyncInvoice.getString("orderno");
        try {
            Throwable throwable;
            DLock dLock;
            block38: {
                boolean bl;
                block39: {
                    AllEleResponseDTO response;
                    DynamicObject invoice;
                    block36: {
                        boolean bl2;
                        block37: {
                            block34: {
                                boolean bl3;
                                block35: {
                                    block32: {
                                        boolean bl4;
                                        block33: {
                                            dLock = DLock.create((String)(RpaAsyncIssueHandlerImpl.class.getName() + orderNo));
                                            throwable = null;
                                            if (dLock.tryLock()) break block32;
                                            bl4 = false;
                                            if (dLock == null) return bl4;
                                            if (throwable == null) break block33;
                                            try {
                                                dLock.close();
                                                return bl4;
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                                return bl4;
                                            }
                                        }
                                        dLock.close();
                                        return bl4;
                                    }
                                    invoice = this.checkInvoiceIssue(asyncInvoice);
                                    if (invoice != null) break block34;
                                    bl3 = true;
                                    if (dLock == null) return bl3;
                                    if (throwable == null) break block35;
                                    try {
                                        dLock.close();
                                        return bl3;
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                        return bl3;
                                    }
                                }
                                dLock.close();
                                return bl3;
                            }
                            if (LOGGER.isInfoEnabled()) {
                                LOGGER.info(String.format("\u6d41\u6c34\u53f7:[%s]\u5f02\u6b65\u67e5\u8be2\u5f00\u7968\u7ed3\u679c", asyncInvoice.getString("govorderno")));
                            }
                            AllEleRequestDTO request = new AllEleRequestDTO();
                            request.setRequest_path(AllEleInterfaceTypeEnum.ASYNC_ISSUE_INVOICE_QUERY.getRequestPath());
                            HashMap<String, String> queryParam = new HashMap<String, String>(4);
                            queryParam.put("serialNo", asyncInvoice.getString("govorderno"));
                            request.setAccount(invoice.getString("account"));
                            request.setHistorySync(true);
                            if ("lq_combine".equals(asyncInvoice.getString("issuechannel"))) {
                                request.setBatchNo(asyncInvoice.getString("govorderno"));
                                request.setOrderNo(asyncInvoice.getString("orderno"));
                                response = AllEleServiceHelper.doPost((String)asyncInvoice.getString("salertaxno"), (AllEleRequestDTO)request, AllEleIssueResponseDTO.class);
                            } else {
                                response = AllEleServiceHelper.doGet((String)asyncInvoice.getString("salertaxno"), (AllEleRequestDTO)request, AllEleIssueResponseDTO.class, queryParam);
                            }
                            if (!response.getSuccess().booleanValue()) break block36;
                            this.handlerRpaIssueSuccess((AllEleResponseDTO<AllEleIssueResponseDTO>)response, asyncInvoice);
                            bl2 = true;
                            if (dLock == null) return bl2;
                            if (throwable == null) break block37;
                            try {
                                dLock.close();
                                return bl2;
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                                return bl2;
                            }
                        }
                        dLock.close();
                        return bl2;
                    }
                    if ("1304".equals(response.getErrcode()) || "1011".equals(response.getErrcode()) || "rpa9999".equals(response.getErrcode())) {
                        this.addUpdateCount(asyncInvoice, updateList);
                        this.updateIssueingMessage((AllEleResponseDTO<AllEleIssueResponseDTO>)response, asyncInvoice);
                        break block38;
                    }
                    if (RpaErrorType.containError((String)response.getErrcode())) {
                        response.setDescription(RpaErrorType.getMessageByCode((String)response.getErrcode()));
                    }
                    invoice.set("result", (Object)GBKUtils.cutGBKString((String)response.getDescription(), (int)100));
                    this.handleLqptInvoiceFailed(invoice, response.getErrcode());
                    bl = true;
                    if (dLock == null) return bl;
                    if (throwable == null) break block39;
                    try {
                        dLock.close();
                        return bl;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        return bl;
                    }
                }
                dLock.close();
                return bl;
            }
            try {
                return false;
                catch (Exception e) {
                    LOGGER.error(String.format("\u6d41\u6c34\u53f7:[%s]\u5f02\u6b65\u67e5\u8be2\u5f00\u7968\u66f4\u65b0\u5931\u8d25", asyncInvoice.getString("govorderno")), (Throwable)e);
                    return false;
                }
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            catch (Throwable throwable7) {
                throw throwable7;
            }
            finally {
                if (dLock != null) {
                    if (throwable != null) {
                        try {
                            dLock.close();
                        }
                        catch (Throwable throwable8) {
                            throwable.addSuppressed(throwable8);
                        }
                    } else {
                        dLock.close();
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5224\u65ad\u53d1\u7968\u662f\u5426\u5f00\u5177\u6210\u529f\u5f02\u5e38", (Throwable)e);
        }
        return false;
    }

    private void updateIssueingMessage(AllEleResponseDTO<AllEleIssueResponseDTO> response, DynamicObject asyncInvoice) {
        DynamicObject invoice = null;
        invoice = InvoiceUtils.isAllEVehicleInv((String)asyncInvoice.getString("invoicetype")) || InvoiceUtils.isUsedCarInvoice((Object)asyncInvoice.getString("invoicetype")) ? BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice_vehicles", (String)"result", (QFilter[])new QFilter("orderno", "=", (Object)asyncInvoice.getString("orderno")).toArray()) : BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"result", (QFilter[])new QFilter("orderno", "=", (Object)asyncInvoice.getString("orderno")).toArray());
        if (invoice == null) {
            DeleteServiceHelper.delete((String)"sim_async_issue_invoice", (QFilter[])new QFilter("orderno", "=", (Object)asyncInvoice.getString("orderno")).toArray());
            return;
        }
        invoice.set("result", (Object)GBKUtils.cutGBKString((String)response.getDescription(), (int)100));
        ImcSaveServiceHelper.update((DynamicObject)invoice);
    }

    private void handlerRpaIssueSuccess(AllEleResponseDTO<AllEleIssueResponseDTO> response, DynamicObject asyncInvoice) {
        DynamicObject invoice = InvoiceUtils.isAllEVehicleInv((String)asyncInvoice.getString("invoicetype")) || InvoiceUtils.isUsedCarInvoice((Object)asyncInvoice.getString("invoicetype")) ? BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice_vehicles", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice_vehicles", (boolean)true), (QFilter[])new QFilter("orderno", "=", (Object)asyncInvoice.getString("orderno")).toArray()) : BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])new QFilter("orderno", "=", (Object)asyncInvoice.getString("orderno")).toArray());
        if (invoice == null) {
            DeleteServiceHelper.delete((String)"sim_async_issue_invoice", (QFilter[])new QFilter("orderno", "=", (Object)asyncInvoice.getString("orderno")).toArray());
            return;
        }
        AllEleIssueResponseDTO responseData = (AllEleIssueResponseDTO)response.getData();
        JSONObject responseJson = new JSONObject();
        responseJson.put("invoicecode", (Object)responseData.getInvoiceCode());
        responseJson.put("invoiceno", (Object)responseData.getInvoiceNo());
        responseJson.put("issuetime", (Object)responseData.getInvoiceDate());
        responseJson.put("alletaxinvoiceno", (Object)responseData.getEtaxInvoiceNo());
        responseJson.put("fileurl", (Object)responseData.getOfdUrl());
        invoice.set("govorderno", (Object)responseData.getGovSerialNo());
        invoice.set("alletaxinvoiceno", (Object)responseData.getEtaxInvoiceNo());
        if (StringUtils.isNotBlank((CharSequence)responseData.getDrawer())) {
            invoice.set("drawer", (Object)responseData.getDrawer());
        }
        invoice.set("invoiceno", (Object)responseData.getInvoiceNo());
        invoice.set("issuetime", (Object)DateUtils.handleDate((String)responseData.getInvoiceDate()));
        if (!InvoiceUtils.isAllEPaperVehicleInvoice((String)asyncInvoice.getString("invoicetype")) && !InvoiceUtils.isAllEPapperUsedCarInvoice((String)asyncInvoice.getString("invoicetype"))) {
            invoice.set("fileurl", (Object)responseData.getOfdUrl());
            invoice.set("xmlfileurl", (Object)responseData.getXmlUrl());
            invoice.set("pdffileurl", (Object)responseData.getPdfUrl());
            invoice.set("snapshoturl", (Object)responseData.getSnapshotUrl());
            AllEleInvoiceFileHelper.addFileRecord((DynamicObject)invoice, (String)(response.isVirtual() ? "virtual" : "rpa"));
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("\u53d1\u7968\u53f7\u7801:[%s]\u66f4\u65b0\u6388\u4fe1\u989d\u5ea6", invoice.getString("invoiceno")));
        }
        if (StringUtils.isNotBlank((CharSequence)responseData.getAvailableVolume())) {
            CacheHelper.put((String)("creditQuota_" + invoice.getString("salertaxno")), (String)CreditQuotaHelper.getNumberFormat((BigDecimal)new BigDecimal(responseData.getAvailableVolume())), (int)14400);
        }
        if (StringUtils.isNotBlank((CharSequence)responseData.getTotalVolume())) {
            CacheHelper.put((String)("totalCreditQuota_" + invoice.getString("salertaxno")), (String)CreditQuotaHelper.getNumberFormat((BigDecimal)new BigDecimal(responseData.getTotalVolume())), (int)14400);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("\u53d1\u7968\u53f7\u7801:[%s]\u66f4\u65b0\u6388\u4fe1\u989d\u5ea6\u7ed3\u675f", invoice.getString("invoiceno")));
        }
        DeleteServiceHelper.delete((String)"sim_async_issue_invoice", (QFilter[])new QFilter("orderno", "=", (Object)invoice.getString("orderno")).toArray());
        MsgResponse msgResponse = new MsgResponse();
        msgResponse.setErrorCode(ErrorType.SUCCESS.getCode());
        msgResponse.setRespData(responseJson.toJSONString());
        if (InvoiceUtils.isAllEVehicleInv((String)asyncInvoice.getString("invoicetype")) || InvoiceUtils.isUsedCarInvoice((Object)asyncInvoice.getString("invoicetype"))) {
            IssueInvoiceService.handleVehicleInvoiceIssueResponse((VehicleInvoiceIssueResponseDTO)IssueInvoiceService.wrapMsgResponse((MsgResponse)msgResponse), (DynamicObject)invoice);
        } else {
            IssueInvoiceService.handlerIssueSuccess((DynamicObject)invoice, (MsgResponse)msgResponse);
        }
    }
}

