/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.async;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.enums.PushStatusEnum;
import kd.imc.bdm.common.helper.BatchPushMailSettingHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.UnitTestHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.RequestUtils;
import kd.imc.bdm.common.util.UUID;
import kd.imc.sim.async.AbstractAsyncIssueHandler;
import kd.imc.sim.common.helper.HostModeInvoiceHelper;
import kd.imc.sim.common.helper.InvoiceMailTimingHelper;
import kd.imc.sim.common.helper.LyServerInvoiceHelper;
import kd.imc.sim.common.service.IssueInvoiceService;
import kd.imc.sim.common.service.issueinvoice.impl.AbstractTGIssueInvoiceImpl;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;
import org.apache.commons.lang.StringUtils;

public class TgAsyncIssueHandlerImpl
extends AbstractAsyncIssueHandler {
    public void handlerInvoice(List<DynamicObject> asyncInvoices) {
        MsgResponse msgResponse;
        LOGGER.info(String.format("SyncTGInvoiceTask request size: %d", asyncInvoices.size()));
        HashMap<String, DynamicObject> asyncInvoiceMap = new HashMap<String, DynamicObject>(asyncInvoices.size());
        JSONArray jsonArray = new JSONArray();
        for (DynamicObject asyncInvoice : asyncInvoices) {
            String orderNo = asyncInvoice.getString("orderno");
            asyncInvoiceMap.put(orderNo, asyncInvoice);
            jsonArray.add((Object)orderNo);
        }
        if (UnitTestHelper.isUnitTest()) {
            msgResponse = new MsgResponse();
            msgResponse.setErrorCode(IssueStatusEnum.ok.getCode());
            msgResponse.setRespData("[{\"orderno\":\"2722b7f913304c8d954acf106f4a4033\",\"errormsg\":\"\u5f00\u7968\u5931\u8d25\uff1a\u7f51\u7edc\u8fde\u63a5\u8d85\u65f6\",\"skm\":\"\",\"snapshoturl\":\"\",\"id\":\"1500769168486579200\",\"issuestatus\":\"5\",\"issuetime\":\"2022-09-02 16:00:25\",\"fileurl\":\"\",\"invoiceno\":\"\",\"jqbh\":\"661030040520\",\"checkcode\":\"\",\"invoicecode\":\"\",\"ofdstatus\":\"\"},{\"orderno\":\"e9158b387eb34025b995705a8dd865a4\",\"errormsg\":\"\",\"skm\":\"3+557<4+3*<2/*9/6>252/225*25+*+596-325/67//1-98<><018175--8+>83>4<3/<<9*0/4-6*->061/2553+596-325/67//1-9<71+\",\"snapshoturl\":\"\",\"id\":\"1504225173019037696\",\"issuestatus\":\"0\",\"issuetime\":\"2022-09-07 10:32:37\",\"fileurl\":\"\",\"invoiceno\":\"53420650\",\"jqbh\":\"661030040520\",\"checkcode\":\"80009518450170539333\",\"invoicecode\":\"033001950304\",\"ofdstatus\":\"0\"}]");
        } else {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("\u5f02\u6b65\u5f00\u7968\u8bf7\u6c42\u5f00\u7968\u7ed3\u679c\u8bf7\u6c42\u6570\u636e:%s", jsonArray.toJSONString()));
            }
            msgResponse = RequestUtils.doRequest((String)UUID.next(), (String)"SyncTGInvoice", (Object)jsonArray);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("\u5f02\u6b65\u5f00\u7968\u8bf7\u6c42\u5f00\u7968\u7ed3\u679c\u8fd4\u56de\u6570\u636e:%s", JSONObject.toJSONString((Object)msgResponse)));
            }
        }
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(asyncInvoices.size());
        JSONArray returnDataArray = JSONArray.parseArray((String)msgResponse.getRespData());
        for (Object o : returnDataArray) {
            JSONObject jsonObject = (JSONObject)o;
            if (IssueStatusEnum.ok.getCode().equals(jsonObject.getString("issuestatus"))) {
                this.handleTGInvoiceSuccess(jsonObject);
                continue;
            }
            if (IssueStatusEnum.failed.getCode().equals(jsonObject.getString("issuestatus"))) {
                this.handleTGInvoiceFailed(jsonObject);
                continue;
            }
            if (IssueStatusEnum.timeout.getCode().equals(jsonObject.getString("issuestatus"))) {
                this.updateInvoiceStatus(jsonObject, IssueStatusEnum.underway.getCode(), true);
                this.addUpdateCount((DynamicObject)asyncInvoiceMap.get(jsonObject.getString("orderno")), updateList);
                continue;
            }
            if (!IssueStatusEnum.underway.getCode().equals(jsonObject.getString("issuestatus"))) continue;
            this.addUpdateCount((DynamicObject)asyncInvoiceMap.get(jsonObject.getString("orderno")), updateList);
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            ImcSaveServiceHelper.save(updateList);
        }
    }

    public void handleTGInvoiceSuccess(JSONObject jsonObject) {
        DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])new QFilter("orderno", "=", (Object)jsonObject.getString("orderno")).toArray());
        if (invoice == null) {
            DeleteServiceHelper.delete((String)"sim_async_issue_invoice", (QFilter[])new QFilter("orderno", "=", (Object)jsonObject.getString("orderno")).toArray());
            return;
        }
        String invoiceCode = jsonObject.getString("invoicecode");
        String invoiceNo = jsonObject.getString("invoiceno");
        IssueInvoiceService.deleteIncomeDownloadInvoice((String)invoiceCode, (String)invoiceNo);
        DynamicObject queryInvoice = QueryServiceHelper.queryOne((String)"sim_vatinvoice", (String)"orderno", (QFilter[])InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)invoiceCode, (String)invoiceNo).toArray());
        if (null != queryInvoice && !jsonObject.getString("orderno").equals(queryInvoice.getString("orderno"))) {
            jsonObject.put("errcode", (Object)ErrorType.FAIL.getCode());
            jsonObject.put("errormsg", (Object)String.format(ResManager.loadKDString((String)"\u5f00\u7968\u5931\u8d25\uff0c\u4e0d\u540c\u6d41\u6c34\u53f7\u8fd4\u56de\u76f8\u540c\u53d1\u7968\u53f7\u7801\uff0c\u53d1\u7968\u4ee3\u7801\u4e3a:%1$s,\u53d1\u7968\u53f7\u7801\u4e3a:%2$s", (String)"TgAsyncIssueHandlerImpl_0", (String)"imc-sim-service", (Object[])new Object[0]), invoiceCode, invoiceNo));
            this.handleTGInvoiceFailed(jsonObject);
            return;
        }
        this.queryStock(invoice);
        AbstractTGIssueInvoiceImpl.warpIssueSuccess((DynamicObject)invoice, (JSONObject)jsonObject);
        MsgResponse response = new MsgResponse();
        response.setErrorCode(ErrorType.SUCCESS.getCode());
        response.setRespData(jsonObject.toJSONString());
        IssueInvoiceService.handlerIssueSuccess((DynamicObject)invoice, (MsgResponse)response);
        try {
            boolean isRedMatchBill = "10".equals(invoice.getString("contraststatus"));
            if ("1".equals(ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.MATCH_RED_INV_SEND_MSG))) {
                isRedMatchBill = false;
            }
            if (isRedMatchBill) {
                return;
            }
            String orderNo = invoice.getString("orderno");
            try (DLock lock = DLock.create((String)("sendMsgAndEmail" + orderNo));){
                if (!lock.tryLock(1L)) {
                    return;
                }
                if ("1".equals(invoice.getString("ofdstatus")) && PushStatusEnum.underway.getCode().equals(invoice.getString("pushstatus")) && StringUtils.isNotBlank((String)invoice.getString("fileurl"))) {
                    DynamicObject pushMailStrategy = BatchPushMailSettingHelper.matchBatchPushMailSetting((DynamicObject)invoice);
                    InvoiceMailTimingHelper.sendSmsOrEmail((DynamicObject)invoice, (DynamicObject)pushMailStrategy);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("\u53d1\u7968\u90ae\u4ef6\u77ed\u4fe1\u5f02\u5e38\uff0c\u53d1\u7968\u4ee3\u7801[%s]\uff0c\u53f7\u7801[%s]\uff0c\u6d41\u6c34\u53f7[%s]", invoice.getString("invoicecode"), invoice.getString("invoiceno"), invoice.getString("orderno")));
        }
    }

    private void queryStock(DynamicObject invoice) {
        String equipmentNo = invoice.getString("jqbh");
        try (DLock lock = DLock.create((String)("sim_queryStock" + equipmentNo), (String)"queryStock");){
            ThreadPools.executeOnce((String)"sim_queryStockthread", () -> {
                String equipmentType = invoice.getString("issuesource");
                String invoiceType = invoice.getString("invoicetype");
                String terminalNo = invoice.getString("terminalno");
                String taxNo = invoice.getString("salertaxno");
                String taxName = invoice.getString("salername");
                Long remainder = null;
                if ("9".equals(equipmentType) || "10".equals(equipmentType) || "11".equals(equipmentType)) {
                    MsgResponse lyResponse = LyServerInvoiceHelper.getInvoiceStock((String)equipmentNo, (String)terminalNo, (String)invoiceType, (String)equipmentNo, (String)taxNo);
                    remainder = this.getRemainder(lyResponse);
                }
                if ("4".equals(equipmentType) || "6".equals(equipmentType) || "7".equals(equipmentType)) {
                    MsgResponse msgResponse = HostModeInvoiceHelper.getInvoiceStock((String)taxNo, (String)invoiceType, (String)equipmentNo);
                    remainder = this.getRemainder(msgResponse);
                }
                if (remainder != null) {
                    this.saveStock(taxNo, taxName, equipmentNo, equipmentType, invoiceType, remainder);
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5e93\u5b58\u5931\u8d25:" + equipmentNo, (Throwable)e);
        }
    }

    private Long getRemainder(MsgResponse response) {
        if (ErrorType.SUCCESS.getCode().equals(response.getErrorCode())) {
            JSONObject retJson = JSONObject.parseObject((String)response.getRespData());
            String remainder = retJson.getString("remainder");
            return BigDecimalUtil.transDecimal((Object)remainder).longValue();
        }
        return null;
    }

    private void saveStock(String taxNo, String taxName, String equipmentNo, String equipmentType, String invoiceType, Long count) {
        QFilter filter = new QFilter("equipmentno", "=", (Object)equipmentNo);
        DynamicObject stock = QueryServiceHelper.queryOne((String)"bdm_stock_manage", (String)"id", (QFilter[])filter.toArray());
        if (stock == null) {
            stock = BusinessDataServiceHelper.newDynamicObject((String)"bdm_stock_manage");
            stock.set("creator", (Object)Long.parseLong(RequestContext.get().getUserId()));
            stock.set("createtime", (Object)new Date());
        } else {
            stock = BusinessDataServiceHelper.loadSingle((Object)stock.get("id"), (String)"bdm_stock_manage");
        }
        stock.set("taxno", (Object)taxNo);
        stock.set("epname", (Object)taxName);
        stock.set("equipmentno", (Object)equipmentNo);
        stock.set("equipmenttype", (Object)equipmentType);
        stock.set("billstatus", (Object)"C");
        stock.set("modifytime", (Object)new Date());
        stock.set("modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
        String field = null;
        if (InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode().equals(invoiceType)) {
            field = "invoicestock";
        } else if (InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode().equals(invoiceType)) {
            field = "specialinvoicestock";
        } else if (InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode().equals(invoiceType)) {
            field = "einvoicestock";
        } else if (InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode().equals(invoiceType)) {
            field = "especialinvoicestock";
        }
        stock.set(field, (Object)count);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{stock});
    }
}

