/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.billcenter.sys.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.HttpClientUtils;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.openapi.InvoiceVo;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.MD5;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.sim.billcenter.BillCenterInvoiceCommonService;
import kd.imc.sim.billcenter.BillCenterInvoiceLogService;
import kd.imc.sim.billcenter.BillCenterOrgMappingService;
import kd.imc.sim.billcenter.domain.FuShiImageDataVO;
import kd.imc.sim.billcenter.domain.FuShiImageDetailVO;
import kd.imc.sim.billcenter.domain.FuShiImageOrderVO;
import kd.imc.sim.billcenter.sys.ExternalSystemsDataService;
import kd.imc.sim.common.constant.BillCenterLogEnum;
import kd.imc.sim.common.constant.ErrorType;
import kd.imc.sim.common.model.billcenter.BillErrorVo;
import kd.imc.sim.common.utils.TaxCalcUtil;
import org.apache.commons.lang3.StringUtils;

public class FuShiImageDataImpl
implements ExternalSystemsDataService {
    private static final Log logger = LogFactory.getLog(FuShiImageDataImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<BillVo> getData(JSONObject paramObject) {
        ArrayList<BillVo> applyBillList = new ArrayList<BillVo>();
        String paramContent = paramObject.getString("paramContent");
        String systemCode = paramObject.getString("systemCode");
        logger.info("FuShiImageDataImpl, paramContent:{}, systemCode:{}", (Object)paramContent, (Object)systemCode);
        if (StringUtils.isEmpty((CharSequence)paramContent) || StringUtils.isEmpty((CharSequence)systemCode)) {
            throw new KDBizException(new ErrorCode(ErrorType.PARAM_IS_NULL.getErrcode(), ErrorType.PARAM_IS_NULL.getDescription()), new Object[]{systemCode});
        }
        try (DLock lock = DLock.create((String)"getFuShiImageOrderThread", (String)"getFuShiImageOrderLogic");){
            block41: {
                if (!lock.tryLock()) break block41;
                try {
                    String result;
                    String billNoParam;
                    block39: {
                        block42: {
                            BillCenterOrgMappingService orgMappingService = new BillCenterOrgMappingService();
                            DynamicObject frontSystemObject = orgMappingService.loadSingleBySystemCode(systemCode);
                            if (frontSystemObject == null) break block42;
                            String client_enc_key = frontSystemObject.getString("client_enc_key");
                            billNoParam = this.getBillNoParamMethod(paramContent, null);
                            boolean flag = false;
                            if (StringUtils.isNotEmpty((CharSequence)client_enc_key)) {
                                flag = Boolean.parseBoolean(client_enc_key);
                            }
                            if (flag) {
                                result = ResManager.loadKDString((String)"{'err_no': 0,'message': 'success','data': [{'id': '00000000021','noticeSn': '2023102490442705F8','tradeTime': '1696819467','details': [{'oid': '2023100910902EB82D','name': 'mini\u7167\u7247\u4e66','price': '','quantity': '','amount': 50,'taxrate': 0.13,'hastax': '1','taxcode': '1060201050000000000'}],'sellerName': '\u73e0\u6d77\u957f\u9686\u6295\u8d44\u53d1\u5c55\u6709\u9650\u516c\u53f8','sellerTaxId': '92510100MA6CP4GH82','sellerAddrTel': '\u73e0\u6d77\u5e02\u6a2a\u7434\u5bcc\u7965\u6e7e 0756-8688888','sellerBankAcct': '\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u80a1\u4efd\u6709\u9650\u516c\u53f8\u6a2a\u7434\u7ca4\u6fb3\u6df1\u5ea6\u5408\u4f5c\u533a\u5206\u884c 2002025619000044503'}]}", (String)"FuShiImageDataImpl_0", (String)"imc-sim-service", (Object[])new Object[0]);
                                break block39;
                            } else {
                                BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
                                DynamicObject dynamicObject = billCenterInvoiceCommonService.dealCheckBillCenterDataMethod("billno", billNoParam, systemCode);
                                if (dynamicObject == null) {
                                    result = this.doGetDataService(frontSystemObject, paramContent);
                                    break block39;
                                } else {
                                    String billno = dynamicObject.getString("billno");
                                    String invoice_status = dynamicObject.getString("invoice_status");
                                    String push_status = dynamicObject.getString("pushstatus");
                                    logger.info("FuShiImageDataImpl, \u539f\u59cb\u8ba2\u5355\u7f16\u53f7:{}, \u53d1\u7968\u72b6\u6001:{}, \u4e0b\u63a8\u72b6\u6001:{}", new Object[]{billno, invoice_status, push_status});
                                    if ("1".equals(invoice_status) || "5".equals(invoice_status)) {
                                        BillErrorVo billErrorVo = new BillErrorVo();
                                        String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8ba2\u5355\u7f16\u53f7:%1$s\uff0c\u5df2\u7ecf\u5b8c\u6210\u5f00\u7968\u64cd\u4f5c\uff01", (String)"FuShiImageDataImpl_2", (String)"imc-sim-service", (Object[])new Object[0]), billNoParam);
                                        billErrorVo.setErrorMsg(errorMsg);
                                        billErrorVo.setFailNum(1);
                                        applyBillList.add((BillVo)billErrorVo);
                                        ArrayList<BillVo> arrayList = applyBillList;
                                        return arrayList;
                                    }
                                    if ("2".equals(invoice_status)) {
                                        BillErrorVo billErrorVo = new BillErrorVo();
                                        String errorMsg = ResManager.loadKDString((String)"\u6b64\u8ba2\u5355\u5df2\u90e8\u5206\u5f00\u7968\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u5f00\u5177\u5269\u4f59\u53d1\u7968\u91d1\u989d!", (String)"FuShiImageDataImpl_3", (String)"imc-sim-service", (Object[])new Object[0]);
                                        billErrorVo.setErrorMsg(errorMsg);
                                        billErrorVo.setFailNum(1);
                                        applyBillList.add((BillVo)billErrorVo);
                                        ArrayList<BillVo> arrayList = applyBillList;
                                        return arrayList;
                                    }
                                    if ("0".equals(push_status) || "1".equals(push_status)) {
                                        BillErrorVo billErrorVo = new BillErrorVo();
                                        String errorMsg = ResManager.loadKDString((String)"\u6b64\u8ba2\u5355\u5df2\u4e0b\u63a8\u6216\u90e8\u5206\u4e0b\u63a8\u5904\u7406\uff0c\u4e0d\u80fd\u91cd\u590d\u62c9\u53d6\u8d26\u5355\u6570\u636e!", (String)"GalaSysDataImpl_13", (String)"imc-sim-service", (Object[])new Object[0]);
                                        billErrorVo.setErrorMsg(errorMsg);
                                        billErrorVo.setFailNum(1);
                                        applyBillList.add((BillVo)billErrorVo);
                                        ArrayList<BillVo> arrayList = applyBillList;
                                        return arrayList;
                                    }
                                    result = this.doGetDataService(frontSystemObject, paramContent);
                                }
                            }
                            break block39;
                        }
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u672a\u5339\u914d\u5230\u5bcc\u58eb\u5f71\u50cf\u7cfb\u7edf%1$s\u53c2\u6570\u914d\u7f6e", (String)"FuShiImageDataImpl_1", (String)"imc-sim-service", (Object[])new Object[0]), systemCode));
                    }
                    this.dealSaveInterfaceLogDataByType(systemCode, "1", billNoParam, paramContent, result);
                    this.dealFormatBillDataMethod(applyBillList, result, systemCode);
                }
                catch (Exception e) {
                    String errorMsg = e.getMessage();
                    logger.error("\u83b7\u53d6\u5bcc\u57fa\u4e1a\u52a1\u7cfb\u7edf\u7684\u5f85\u7533\u8bf7\u5f00\u7968\u6570\u636e\u51fa\u73b0\u5f02\u5e38:{}", (Object)errorMsg);
                    BillErrorVo billErrorVo = new BillErrorVo();
                    billErrorVo.setErrorMsg(errorMsg);
                    billErrorVo.setFailNum(1);
                    applyBillList.add((BillVo)billErrorVo);
                }
                finally {
                    lock.unlock();
                }
                ArrayList<BillVo> e = applyBillList;
                return e;
            }
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6b63\u5728\u62c9\u53d6\u8ba2\u5355\u6570\u636e\uff0c\u8bf7\u7a0d\u5019\u91cd\u8bd5!", (String)"CenterElectronicsDataImpl_14", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
    }

    private String getBillNoParamMethod(String paramContent, InvoiceVo invoiceVo) {
        if (StringUtils.isNotEmpty((CharSequence)paramContent)) {
            JSONObject paramObject = JSONObject.parseObject((String)paramContent);
            String noticeSn = paramObject.getString("billNo");
            return noticeSn;
        }
        if (invoiceVo != null) {
            return invoiceVo.getBillNo();
        }
        return null;
    }

    private void dealSaveInterfaceLogDataByType(String systemCode, String opType, String billNoParam, String paramContent, String result) {
        BillCenterInvoiceLogService billCenterInvoiceLogService = new BillCenterInvoiceLogService();
        billCenterInvoiceLogService.dealSaveInterfaceLogDataByType(systemCode, opType, billNoParam, paramContent, result);
    }

    public void dealFormatBillDataMethod(List<BillVo> applyBillList, String result, String systemCode) {
        List fuShiImageDataVOList;
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            FuShiImageOrderVO fuShiImageOrderVO = (FuShiImageOrderVO)JSONObject.parseObject((String)result, FuShiImageOrderVO.class);
            String err_no = fuShiImageOrderVO.getErr_no();
            String message = fuShiImageOrderVO.getMessage();
            logger.info("dealFormatBillDataMethod, err_no:{}, message:{}", (Object)err_no, (Object)message);
            if (!"0".equals(err_no) || !"success".equals(message)) {
                String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u5bcc\u58eb\u5f71\u50cf\u8fd4\u56de\u7684\u5f00\u7968\u6570\u636e\uff0c\u72b6\u6001\u7801\u4e0d\u6b63\u786e\uff01", (String)"FuShiImageDataImpl_4", (String)"imc-sim-service", (Object[])new Object[0]);
                throw new KDBizException(errorMsg);
            }
            fuShiImageDataVOList = fuShiImageOrderVO.getData();
            logger.info("dealFormatBillDataMethod, fuShiImageDataVOList\u5927\u5c0f\u662f:{}", (Object)(fuShiImageDataVOList == null ? 0 : fuShiImageDataVOList.size()));
            if (fuShiImageDataVOList == null || fuShiImageDataVOList.isEmpty()) {
                String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u5bcc\u58eb\u5f71\u50cf\u8fd4\u56de\u7684\u5f00\u7968\u6570\u636e\u7ed3\u679c\u96c6\u5185\u5bb9\u4e3a\u7a7a\uff01", (String)"FuShiImageDataImpl_5", (String)"imc-sim-service", (Object[])new Object[0]);
                throw new KDBizException(errorMsg);
            }
        } else {
            String errorMsg = ResManager.loadKDString((String)"\u5bcc\u58eb\u5f71\u50cf\u7cfb\u7edf\u83b7\u53d6\u4e0d\u5230\u76f8\u5173\u7684\u8d26\u5355\u6570\u636e\uff01", (String)"FuShiImageDataImpl_6", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        this.dealCreateBillCenterDataMethod(fuShiImageDataVOList, systemCode, applyBillList);
    }

    private void dealCreateBillCenterDataMethod(List<FuShiImageDataVO> fuShiImageDataVOList, String systemCode, List<BillVo> applyBillList) {
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        for (FuShiImageDataVO fuShiImageDataVO : fuShiImageDataVOList) {
            boolean flag = false;
            String serialNo = fuShiImageDataVO.getId();
            String billNo = fuShiImageDataVO.getNoticeSn();
            logger.info("dealCreateBillCenterDataMethod, serialNo:{}, billNo:{}, systemCode:{}", new Object[]{serialNo, billNo, systemCode});
            QFilter qFilter = new QFilter("billno", "=", (Object)billNo).and("system_code", "=", (Object)systemCode);
            DynamicObject dynamicObject = billCenterInvoiceCommonService.dealLoadIsomerismBillDataMethod(qFilter);
            if (dynamicObject == null) {
                dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_isomerism_bill_data");
            } else {
                flag = true;
            }
            logger.info("dealCreateBillCenterDataMethod, FuShiImageDataImpl, flag:{}", (Object)flag);
            this.dealCreateBillHeaderDataMethod(dynamicObject, billNo, systemCode, serialNo, fuShiImageDataVO);
            this.dealCreateBillItemDataMethod(dynamicObject, fuShiImageDataVO);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            billCenterInvoiceCommonService.dealFormatBillDataMethod(dynamicObject, applyBillList);
        }
    }

    private void dealCreateBillItemDataMethod(DynamicObject dynamicObject, FuShiImageDataVO fuShiImageDataVO) {
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("sim_isomerism_item_data");
        if (dynamicObjectCollection == null) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u5355\u4e2d\u5fc3\u5546\u54c1\u660e\u7ec6\u533a\u5143\u6570\u636e\u4e0d\u5b58\u5728\uff01", (String)"FuShiImageDataImpl_7", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        if (dynamicObjectCollection.size() > 0) {
            dynamicObjectCollection.clear();
        }
        List details = fuShiImageDataVO.getDetails();
        int row = 1;
        String systemCode = dynamicObject.getString("system_code");
        for (FuShiImageDetailVO fuShiImageDetailVO : details) {
            Date billDate;
            DynamicObject itemObject = dynamicObjectCollection.addNew();
            itemObject.set("product_id", (Object)row);
            itemObject.set("product_name", (Object)fuShiImageDetailVO.getName());
            itemObject.set("product_code", (Object)fuShiImageDetailVO.getOid());
            itemObject.set("product_type", null);
            BigDecimal productNum = BigDecimal.ONE;
            String quantity = fuShiImageDetailVO.getQuantity();
            if (StringUtils.isNotEmpty((CharSequence)quantity)) {
                productNum = new BigDecimal(quantity);
            }
            itemObject.set("product_quantity", (Object)productNum);
            Object productAmount = fuShiImageDetailVO.getAmount();
            if (productAmount == null) {
                productAmount = BigDecimal.ZERO;
            }
            itemObject.set("product_amount", productAmount);
            String price = fuShiImageDetailVO.getPrice();
            if (StringUtils.isEmpty((CharSequence)price)) {
                price = String.valueOf(new BigDecimal(productAmount.toString()).divide(productNum).setScale(2, 4));
            }
            itemObject.set("product_price", (Object)price);
            itemObject.set("avg_amount", productAmount);
            String taxCode = fuShiImageDetailVO.getTaxcode();
            itemObject.set("tax_code", (Object)taxCode);
            Object taxRate = fuShiImageDetailVO.getTaxrate();
            if (taxRate == null) {
                taxRate = BigDecimal.ZERO;
            }
            itemObject.set("tax_rate", taxRate);
            boolean hasTaxFlag = "1".equals(fuShiImageDetailVO.getHastax());
            BigDecimal taxAmount = TaxCalcUtil.calTax((BigDecimal)new BigDecimal(productAmount.toString()), (BigDecimal)BigDecimal.ZERO, (String)taxRate.toString(), (boolean)hasTaxFlag);
            itemObject.set("tax_amount", (Object)taxAmount);
            itemObject.set("invoicable_switch", (Object)"1");
            String tradeTime = fuShiImageDataVO.getTradeTime();
            if (StringUtils.isEmpty((CharSequence)tradeTime)) {
                billDate = new Date();
            } else {
                tradeTime = String.valueOf(Long.parseLong(tradeTime) * 1000L);
                billDate = new Date(Long.parseLong(tradeTime));
            }
            itemObject.set("consume_time", (Object)billDate);
            itemObject.set("folio_no", null);
            itemObject.set("tc_group", null);
            itemObject.set("tax_no", (Object)fuShiImageDataVO.getSellerTaxId());
            itemObject.set("splitkey", (Object)fuShiImageDataVO.getSellerTaxId());
            DynamicObject orgObject = TaxUtils.getOrgDynamicObjectByTaxNo((String)fuShiImageDataVO.getSellerTaxId());
            itemObject.set("orgid", (Object)orgObject);
            BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
            DynamicObject itemTypeObject = billCenterInvoiceCommonService.getBillCenterItemType(taxCode);
            itemObject.set("itemtype", (Object)itemTypeObject);
            itemObject.set("unpushamount", productAmount);
            itemObject.set("unpushtax", (Object)taxAmount);
            itemObject.set("unpushnum", (Object)productNum);
            itemObject.set("rowpushstatus", (Object)"-1");
            this.dealSetItemOpenInvoiceTypeMethod(itemObject, taxCode);
            itemObject.set("apply_no", (Object)systemCode);
            ++row;
        }
    }

    private void dealSetItemOpenInvoiceTypeMethod(DynamicObject itemObject, String taxCode) {
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        DynamicObject specialInvoiceObject = billCenterInvoiceCommonService.dealGetSpecialInvoiceMethod(null, null, null, taxCode);
        if (specialInvoiceObject == null) {
            itemObject.set("openinvoicetype", (Object)"02");
        } else {
            String is_special_invoice = specialInvoiceObject.getString("is_special_invoice");
            if (StringUtils.isBlank((CharSequence)is_special_invoice) || "0".equals(is_special_invoice)) {
                itemObject.set("openinvoicetype", (Object)"02");
            } else {
                itemObject.set("openinvoicetype", (Object)"01");
            }
        }
    }

    private void dealCreateBillHeaderDataMethod(DynamicObject dynamicObject, String billNo, String systemCode, String serialNo, FuShiImageDataVO fuShiImageDataVO) {
        Date billDate;
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        dynamicObject.set("billno", (Object)billNo);
        dynamicObject.set("bill_json_data", (Object)serialNo);
        dynamicObject.set("billstatus", (Object)"C");
        dynamicObject.set("pushstatus", (Object)"-1");
        dynamicObject.set("system_code", (Object)systemCode);
        String systemName = billCenterInvoiceCommonService.getSystemNameMethod(systemCode);
        dynamicObject.set("system_name", (Object)systemName);
        BillCenterOrgMappingService billCenterOrgMappingService = new BillCenterOrgMappingService();
        DynamicObject frontSystemObject = billCenterOrgMappingService.loadSingleBySystemCode(systemCode);
        dynamicObject.set("system", (Object)frontSystemObject);
        dynamicObject.set("org_code", null);
        dynamicObject.set("org_name", null);
        DynamicObject orgObject = TaxUtils.getOrgDynamicObjectByTaxNo((String)fuShiImageDataVO.getSellerTaxId());
        dynamicObject.set("org", (Object)orgObject);
        dynamicObject.set("custom_name", null);
        dynamicObject.set("bill_create_time", (Object)new Date());
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        String tradeTime = fuShiImageDataVO.getTradeTime();
        if (StringUtils.isEmpty((CharSequence)tradeTime)) {
            billDate = new Date();
        } else {
            tradeTime = String.valueOf(Long.parseLong(tradeTime) * 1000L);
            billDate = new Date(Long.parseLong(tradeTime));
        }
        dynamicObject.set("bill_date", (Object)billDate);
        dynamicObject.set("user_phone", null);
        dynamicObject.set("remark", null);
        BigDecimal totalAmount = this.getBillTotalAmountMethod(fuShiImageDataVO);
        dynamicObject.set("total_amount", (Object)totalAmount);
        dynamicObject.set("invoicable_amount", (Object)totalAmount);
        dynamicObject.set("invoice_amount", (Object)BigDecimal.ZERO);
        dynamicObject.set("remain_amount", (Object)totalAmount);
        dynamicObject.set("invoice_status", (Object)"0");
        dynamicObject.set("hsbz", (Object)"1");
    }

    private BigDecimal getBillTotalAmountMethod(FuShiImageDataVO fuShiImageDataVO) {
        List details = fuShiImageDataVO.getDetails();
        BigDecimal totalAmount = new BigDecimal("0.00");
        for (FuShiImageDetailVO fuShiImageDetailVO : details) {
            totalAmount = totalAmount.add(new BigDecimal(fuShiImageDetailVO.getAmount()));
        }
        return totalAmount;
    }

    private String doGetDataService(DynamicObject frontSystemObject, String paramContent) throws Exception {
        String systemUrl = frontSystemObject.getString("system_url");
        String requestUrl = systemUrl + "/thirdpart/getOrderInfoByApply";
        JSONObject paramObject = JSONObject.parseObject((String)paramContent);
        String noticeSn = paramObject.getString("billNo");
        String secret = frontSystemObject.getString("client_secret");
        long timestamp = System.currentTimeMillis() / 1000L;
        StringBuilder bs = new StringBuilder();
        bs.append(secret).append("noticeSn").append(noticeSn).append("timestamp").append(timestamp).append(secret);
        String sign = MD5.md5Hex((String)bs.toString()).toUpperCase();
        logger.info("FuShiImageDataImpl, doGetDataService, \u52a0\u5bc6\u5185\u5bb9sign\u662f:{}", (Object)sign);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("noticeSn", noticeSn);
        body.put("timestamp", timestamp);
        body.put("sign", sign);
        try {
            String result = HttpClientUtils.postAppJson((String)requestUrl, null, body);
            logger.info("FuShiImageDataImpl, doGetDataService, \u8fd4\u56de\u7684\u7ed3\u679c\u5185\u5bb9\u662f:{}", (Object)result);
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dealUpdateOpenInvoiceStatus(DynamicObject dynamicObject, InvoiceVo invoiceVo) {
        block11: {
            logger.info("FuShiImageDataImpl, dealUpdateOpenInvoiceStatus, dynamicObject\uff1a{}", (Object)SerializationUtils.toJsonString((Object)dynamicObject));
            if (dynamicObject == null) {
                logger.error("FuShiImageDataImpl, dealUpdateOpenInvoiceStatus, \u56de\u4f20\u5f00\u7968\u5bf9\u8c61\u4e3a\u7a7a\uff01");
                return;
            }
            if (this.invociceFailCallBack(dynamicObject)) {
                return;
            }
            BillCenterOrgMappingService orgMappingService = new BillCenterOrgMappingService();
            String systemCode = invoiceVo.getSystemSource();
            String billNo = invoiceVo.getBillNo();
            logger.info("FuShiImageDataImpl, dealUpdateOpenInvoiceStatus, systemCode:{}, billNo:{}", (Object)systemCode, (Object)billNo);
            DynamicObject frontSystemObject = orgMappingService.loadSingleBySystemCode(systemCode);
            Map<Object, Object> body = new HashMap();
            String result = "";
            try {
                if (frontSystemObject != null) {
                    String systemUrl = frontSystemObject.getString("system_url");
                    String requestUrl = systemUrl + "/thirdpart/notify/invoice";
                    body = this.createUpdateResultStatusMethod(dynamicObject, invoiceVo);
                    logger.info("FuShiImageDataImpl, dealUpdateResultStatus, \u8bf7\u6c42\u53c2\u6570\u5185\u5bb9\u662f\uff1a{}", body);
                    result = HttpClientUtils.postAppJson((String)requestUrl, null, body);
                    logger.info("FuShiImageDataImpl, dealUpdateResultStatus, \u7ed3\u679c\u8fd4\u56de\u5185\u5bb9\u662f\uff1a{}", (Object)result);
                    break block11;
                }
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u672a\u5339\u914d\u5230\u5bcc\u58eb\u5f71\u50cf\u7cfb\u7edf%1$s\u53c2\u6570\u914d\u7f6e", (String)"FuShiImageDataImpl_1", (String)"imc-sim-service", (Object[])new Object[0]), systemCode));
            }
            catch (Exception e) {
                logger.error("\u63a8\u9001\u5bcc\u58eb\u5f71\u50cf\u7cfb\u7edf\uff0c\u66f4\u65b0\u72b6\u6001\u4e0e\u7ed3\u679c\u5904\u7406\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u662f\uff1a{}", (Object)e.getMessage());
            }
            finally {
                JSONObject innerParamObject = new JSONObject(body);
                String billNoParam = this.getBillNoParamMethod(null, invoiceVo);
                int invoiceProperty = invoiceVo.getInvoiceProperty();
                if (0 == invoiceProperty) {
                    this.dealSaveInterfaceLogDataByType(systemCode, BillCenterLogEnum.BLUE_INV_RESULT_OP_TYPE.getBillStatus(), billNoParam, innerParamObject.toJSONString(), result);
                    this.dealStaticsCallbackMethod(billNo, systemCode, result);
                } else if (1 == invoiceProperty) {
                    this.dealSaveInterfaceLogDataByType(systemCode, BillCenterLogEnum.RED_INV_RESULT_OP_TYPE.getBillStatus(), billNoParam, innerParamObject.toJSONString(), result);
                }
            }
        }
    }

    private void dealStaticsCallbackMethod(String billNo, String systemCode, String result) {
        String callbackStatus;
        if (StringUtils.isNotBlank((CharSequence)result)) {
            FuShiImageOrderVO fuShiImageOrderVO = (FuShiImageOrderVO)JSONObject.parseObject((String)result, FuShiImageOrderVO.class);
            if (fuShiImageOrderVO != null) {
                String err_no = fuShiImageOrderVO.getErr_no();
                String message = fuShiImageOrderVO.getMessage();
                callbackStatus = "0".equals(err_no) && "success".equals(message) ? "1" : "2";
            } else {
                callbackStatus = "2";
            }
        } else {
            callbackStatus = "2";
        }
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        if ("2".equals(callbackStatus)) {
            billCenterInvoiceCommonService.dealStaticsCallbackMethod(billNo, systemCode, 1, callbackStatus);
        } else {
            billCenterInvoiceCommonService.dealStaticsCallbackMethod(billNo, systemCode, callbackStatus);
        }
    }

    @Override
    public void dealPushCallBackStatusToFrontSystem(JSONObject paramObject) {
        BillCenterInvoiceLogService billCenterInvoiceLogService = new BillCenterInvoiceLogService();
        if (paramObject.containsKey((Object)"approvalResult")) {
            billCenterInvoiceLogService.dealNoticeApprovalRejectMethod(paramObject);
        } else if (paramObject.containsKey((Object)"approvalProcess")) {
            billCenterInvoiceLogService.dealNoticeApprovalProcessMethod(paramObject);
        } else if (paramObject.containsKey((Object)"approvalSuccess")) {
            billCenterInvoiceLogService.dealNoticeApprovalSuccessMethod(paramObject);
        } else {
            this.dealNoticeCallBackStatusToFrontSystem(paramObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealNoticeCallBackStatusToFrontSystem(JSONObject paramObject) {
        block7: {
            BillCenterOrgMappingService orgMappingService = new BillCenterOrgMappingService();
            String systemCode = paramObject.getString("systemCode");
            String innerParam = paramObject.getString("innerParam");
            String billNo = paramObject.getString("billNo");
            String opType = paramObject.getString("opType");
            logger.info("FuShiImageDataImpl, dealPushCallBackStatusToFrontSystem, systemCode:{}, billNo:{}", (Object)systemCode, (Object)billNo);
            DynamicObject frontSystemObject = orgMappingService.loadSingleBySystemCode(systemCode);
            String result = "";
            try {
                if (frontSystemObject != null) {
                    String systemUrl = frontSystemObject.getString("system_url");
                    String requestUrl = systemUrl + "/thirdpart/notify/invoice";
                    Map<String, Object> bodyMap = this.dealFormatBodyContentMethod(innerParam);
                    logger.info("FuShiImageDataImpl, dealPushCallBackStatusToFrontSystem, \u8bf7\u6c42\u53c2\u6570\u5185\u5bb9\u662f\uff1a{}", bodyMap);
                    result = HttpClientUtils.postAppJson((String)requestUrl, null, bodyMap);
                    logger.info("FuShiImageDataImpl, dealPushCallBackStatusToFrontSystem, \u7ed3\u679c\u8fd4\u56de\u5185\u5bb9\u662f\uff1a{}", (Object)result);
                    break block7;
                }
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u672a\u5339\u914d\u5230\u5bcc\u58eb\u5f71\u50cf\u7cfb\u7edf%1$s\u53c2\u6570\u914d\u7f6e", (String)"FuShiImageDataImpl_1", (String)"imc-sim-service", (Object[])new Object[0]), systemCode));
            }
            catch (Exception e) {
                result = e.getMessage();
                logger.error("\u624b\u5de5\u63a8\u9001\u5bcc\u58eb\u5f71\u50cf\u7cfb\u7edf\uff0c\u66f4\u65b0\u72b6\u6001\u4e0e\u7ed3\u679c\u5904\u7406\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u662f\uff1a{}", (Object)result);
            }
            finally {
                this.dealSaveInterfaceLogDataByType(systemCode, opType, billNo, innerParam, result);
                if (BillCenterLogEnum.BLUE_INV_RESULT_OP_TYPE.getBillStatus().equals(opType)) {
                    this.dealStaticsCallbackMethod(billNo, systemCode, result);
                }
            }
        }
    }

    @Override
    public String dealGetQrCodeMethod(JSONObject paramObject) {
        return null;
    }

    private Map<String, Object> dealFormatBodyContentMethod(String innerParam) {
        if (StringUtils.isNotEmpty((CharSequence)innerParam)) {
            JSONObject jsonObject;
            JSONObject bodyMap = jsonObject = JSON.parseObject((String)innerParam);
            return bodyMap;
        }
        return null;
    }

    private Map<String, Object> createUpdateResultStatusMethod(DynamicObject dynamicObject, InvoiceVo invoiceVo) {
        logger.info("FuShiImageDataImpl, createUpdateResultStatusMethod, invoiceVo\uff1a{}", (Object)SerializationUtils.toJsonString((Object)invoiceVo));
        String status = "success";
        if (IssueStatusEnum.underway.getCode().equals(dynamicObject.getString("issuestatus")) || StringUtils.isEmpty((CharSequence)dynamicObject.getString("invoicestatus"))) {
            invoiceVo.setInvoiceStatus("1");
        } else if (IssueStatusEnum.failed.getCode().equals(dynamicObject.getString("issuestatus"))) {
            status = "error";
        }
        String billNo = invoiceVo.getBillNo();
        String systemCode = invoiceVo.getSystemSource();
        logger.info("FuShiImageDataImpl, createUpdateResultStatusMethod, billNo:{}, systemCode:{}", (Object)billNo, (Object)systemCode);
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        DynamicObject billCenterObject = billCenterInvoiceCommonService.dealCheckBillCenterDataMethod("billno", billNo, systemCode);
        if (billCenterObject == null) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8ba2\u5355\u7f16\u53f7:%1$s\uff0c\u65e0\u6cd5\u5339\u914d\u5230\u8d26\u5355\u4e2d\u5fc3\u7684\u8ba2\u5355\u6570\u636e\uff01", (String)"FuShiImageDataImpl_8", (String)"imc-sim-service", (Object[])new Object[0]), billNo);
            throw new KDBizException(errorMsg);
        }
        String serialNo = billCenterObject.getString("bill_json_data");
        logger.info("FuShiImageDataImpl, createUpdateResultStatusMethod, serialNo:{}", (Object)serialNo);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("status", status);
        body.put("message", dynamicObject.getString("result"));
        ArrayList dataList = new ArrayList();
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("id", serialNo);
        dataMap.put("code", invoiceVo.getInvoiceStatus());
        dataMap.put("message", "");
        dataMap.put("invoicecode", invoiceVo.getInvoiceCode());
        dataMap.put("invoiceno", invoiceVo.getInvoiceNum());
        dataMap.put("invoicetime", DateUtils.format((Date)invoiceVo.getInvoiceDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        dataMap.put("pdfurl", invoiceVo.getInvoicePdfFileUrl());
        dataMap.put("ofdurl", invoiceVo.getInvoiceFileUrl());
        dataMap.put("xmlurl", invoiceVo.getInvoiceXmlFileUrl());
        String type = "";
        if (invoiceVo.getInvoiceProperty() == 0) {
            type = "1";
        } else if (invoiceVo.getInvoiceProperty() == 1) {
            type = "2";
        }
        dataMap.put("type", type);
        String invoicetype = "";
        if (StringUtils.equalsAny((CharSequence)invoiceVo.getInvoiceType(), (CharSequence[])new CharSequence[]{"028", "026"})) {
            invoicetype = "0";
        } else if (StringUtils.equalsAny((CharSequence)invoiceVo.getInvoiceType(), (CharSequence[])new CharSequence[]{"004", "007"})) {
            invoicetype = "1";
        }
        dataMap.put("invoicetype", invoicetype);
        dataMap.put("applyinvoicecode", invoiceVo.getOriginalInvoiceCode());
        dataMap.put("applyinvoiceno", invoiceVo.getOriginalInvoiceNumber());
        dataList.add(dataMap);
        body.put("data", dataList);
        return body;
    }
}

