/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.billcenter.sys.impl;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.openapi.InvoiceVo;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.sim.billcenter.BillCenterInvoiceCommonService;
import kd.imc.sim.billcenter.BillCenterInvoiceLogService;
import kd.imc.sim.billcenter.BillCenterOrgMappingService;
import kd.imc.sim.billcenter.domain.GalaSysQueryOrderDataDetailVO;
import kd.imc.sim.billcenter.domain.GalaSysQueryOrderDataVO;
import kd.imc.sim.billcenter.domain.GalaSysQueryOrderVO;
import kd.imc.sim.billcenter.sys.ExternalSystemDataHandler;
import kd.imc.sim.billcenter.sys.ExternalSystemsDataService;
import kd.imc.sim.billcenter.sys.impl.DaoKongDataImpl;
import kd.imc.sim.common.constant.BillCenterLogEnum;
import kd.imc.sim.common.constant.BillCenterSystemEnum;
import kd.imc.sim.common.constant.ErrorType;
import kd.imc.sim.common.model.billcenter.BillErrorVo;
import kd.imc.sim.common.service.SimClassMappingService;
import kd.imc.sim.common.utils.TaxCalcUtil;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class GalaSysDataImpl
implements ExternalSystemsDataService {
    private static final Log logger = LogFactory.getLog(GalaSysDataImpl.class);
    private static final String XIE_GANG_FLAG = "/";
    private static final String HENG_GANG_FLAG = "-";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<BillVo> getData(JSONObject paramObject) {
        ArrayList<BillVo> applyBillList = new ArrayList<BillVo>();
        String systemCode = paramObject.getString("systemCode");
        String paramContent = paramObject.getString("paramContent");
        logger.info("GalaSysDataImpl, paramContent:{}, systemCode:{}", (Object)paramContent, (Object)systemCode);
        if (StringUtils.isEmpty((CharSequence)paramContent) || StringUtils.isEmpty((CharSequence)systemCode)) {
            throw new KDBizException(new ErrorCode(ErrorType.PARAM_IS_NULL.getErrcode(), ErrorType.PARAM_IS_NULL.getDescription()), new Object[]{systemCode});
        }
        try (DLock lock = DLock.create((String)"getPwCYOrderThread", (String)"getPwCYOrderLogic");){
            if (lock.tryLock()) {
                block40: {
                    try {
                        String result;
                        String systemSource = this.dealGetSystemSourceMethod(paramContent);
                        logger.info("GalaSysDataImpl, dealGetSystemCodeMethod, systemSource:{}", (Object)systemSource);
                        if (StringUtils.isBlank((CharSequence)systemSource)) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7cfb\u7edf\u6765\u6e90\u7f16\u7801\u4e0d\u6b63\u786e\uff0c\u4e0d\u80fd\u591f\u67e5\u8be2\u76f8\u5173\u7684\u8ba2\u5355\u6570\u636e\uff01", (String)"GalaSysDataImpl_0", (String)"imc-sim-service", (Object[])new Object[0]));
                        }
                        BillCenterOrgMappingService orgMappingService = new BillCenterOrgMappingService();
                        QFilter qFilter = new QFilter("number", "=", (Object)systemSource);
                        DynamicObject frontSystemObject = orgMappingService.loadSingle(qFilter);
                        if (frontSystemObject == null) break block40;
                        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
                        String client_enc_key = frontSystemObject.getString("client_enc_key");
                        String extractedCode = this.getBillNoParamMethod(paramContent);
                        String extractedDate = this.getBillExtractedDate(paramContent);
                        DynamicObject dynamicObject = billCenterInvoiceCommonService.dealCheckBillCenterDataMethod("extracted_code", extractedCode, systemSource);
                        if (dynamicObject == null) {
                            result = this.doGetDataService(frontSystemObject, paramContent);
                        } else {
                            String billno = dynamicObject.getString("billno");
                            String invoice_status = dynamicObject.getString("invoice_status");
                            String push_status = dynamicObject.getString("pushstatus");
                            logger.info("GalaSysDataImpl, \u539f\u59cb\u8ba2\u5355\u7f16\u53f7:{}, \u53d1\u7968\u72b6\u6001:{}, \u4e0b\u63a8\u72b6\u6001:{}", new Object[]{billno, invoice_status, push_status});
                            if ("1".equals(invoice_status) || "5".equals(invoice_status)) {
                                BillErrorVo billErrorVo = new BillErrorVo();
                                String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u63d0\u53d6\u7801:%1$s\uff0c\u5df2\u7ecf\u5b8c\u6210\u5f00\u7968\u64cd\u4f5c\uff01", (String)"GalaSysDataImpl_6", (String)"imc-sim-service", (Object[])new Object[0]), extractedCode);
                                billErrorVo.setErrorMsg(errorMsg);
                                billErrorVo.setFailNum(1);
                                applyBillList.add((BillVo)billErrorVo);
                                ArrayList<BillVo> arrayList = applyBillList;
                                return arrayList;
                            }
                            if ("2".equals(invoice_status)) {
                                BillErrorVo billErrorVo = new BillErrorVo();
                                String errorMsg = ResManager.loadKDString((String)"\u6b64\u8ba2\u5355\u5df2\u90e8\u5206\u5f00\u7968\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u5f00\u5177\u5269\u4f59\u53d1\u7968\u91d1\u989d!", (String)"GalaSysDataImpl_7", (String)"imc-sim-service", (Object[])new Object[0]);
                                billErrorVo.setErrorMsg(errorMsg);
                                billErrorVo.setFailNum(1);
                                applyBillList.add((BillVo)billErrorVo);
                                ArrayList<BillVo> arrayList = applyBillList;
                                return arrayList;
                            }
                            if ("1".equals(push_status) || "0".equals(push_status)) {
                                BillErrorVo billErrorVo = new BillErrorVo();
                                String errorMsg = ResManager.loadKDString((String)"\u6b64\u8ba2\u5355\u5df2\u4e0b\u63a8\u6216\u90e8\u5206\u4e0b\u63a8\u5904\u7406\uff0c\u4e0d\u80fd\u91cd\u590d\u62c9\u53d6\u8d26\u5355\u6570\u636e!", (String)"GalaSysDataImpl_13", (String)"imc-sim-service", (Object[])new Object[0]);
                                billErrorVo.setErrorMsg(errorMsg);
                                billErrorVo.setFailNum(1);
                                applyBillList.add((BillVo)billErrorVo);
                                ArrayList<BillVo> arrayList = applyBillList;
                                return arrayList;
                            }
                            result = this.doGetDataService(frontSystemObject, paramContent);
                        }
                        String dealStatus = BillCenterLogEnum.RECEIVE_DEAL_TYPE.getBillStatus();
                        this.dealSaveInterfaceLogDataByType(systemSource, "1", extractedCode, paramContent, result, dealStatus);
                        String errorMsg = this.dealCheckNoPullBillDataMethod(systemCode, result);
                        if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
                            throw new KDBizException(errorMsg);
                        }
                        this.dealCreateBillCenterDataMethod(result, systemSource, extractedCode, extractedDate, applyBillList);
                        boolean flag = billCenterInvoiceCommonService.dealCheckAppOpKeyMethod(paramContent);
                        if (flag) {
                            billCenterInvoiceCommonService.dealCheckMoreThan30Method(applyBillList);
                        }
                    }
                    catch (Exception e) {
                        String errorMsg = e.getMessage();
                        logger.error("\u83b7\u53d6\u77f3\u57fa\u73af\u4f01\u4e1a\u52a1\u7cfb\u7edf\u7684\u5f85\u7533\u8bf7\u5f00\u7968\u6570\u636e\u51fa\u73b0\u5f02\u5e38:{}", (Object)errorMsg);
                        BillErrorVo billErrorVo = new BillErrorVo();
                        billErrorVo.setErrorMsg(errorMsg);
                        billErrorVo.setFailNum(1);
                        applyBillList.add((BillVo)billErrorVo);
                    }
                    finally {
                        lock.unlock();
                    }
                }
                ArrayList<BillVo> e = applyBillList;
                return e;
            }
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6b63\u5728\u626b\u7801\u62c9\u5355\u5904\u7406\uff0c\u8bf7\u7a0d\u5019\u91cd\u8bd5!", (String)"GalaSysDataImpl_5", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
    }

    private String getBillExtractedDate(String paramContent) {
        JSONObject paramObject = JSONObject.parseObject((String)paramContent);
        String date = paramObject.getString("date");
        return date;
    }

    private String getBillNoParamMethod(String paramContent) {
        JSONObject paramObject = JSONObject.parseObject((String)paramContent);
        String codeNo = paramObject.getString("codeNo");
        return codeNo;
    }

    private String dealCheckNoPullBillDataMethod(String systemCode, String result) {
        QFilter qFilter = new QFilter("number", "=", (Object)systemCode);
        DynamicObject simClassMappingCfg = SimClassMappingService.getInterfaceByCondition((QFilter)qFilter);
        if (simClassMappingCfg != null) {
            Date limitDate = null;
            try {
                limitDate = simClassMappingCfg.getDate("limit_date");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (limitDate == null) {
                return null;
            }
            GalaSysQueryOrderDataVO galaSysQueryOrderDataVO = this.getGalaSysOrderDataMethod(result);
            String sellDate = galaSysQueryOrderDataVO.getSellDate();
            Date billDate = new Date();
            if (StringUtils.isNotEmpty((CharSequence)sellDate)) {
                if (sellDate.contains(XIE_GANG_FLAG)) {
                    sellDate = sellDate.replace(XIE_GANG_FLAG, HENG_GANG_FLAG);
                }
                billDate = DateUtils.stringToDate((String)sellDate);
            }
            logger.info("GalaSysDataImpl, limitDate:{}, sellDate:{},  billDate:{}", new Object[]{limitDate, sellDate, billDate});
            if (billDate.compareTo(limitDate) <= 0) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u65e5\u671f:%1$s\u524d\u7684\uff0c\u4e3a\u907f\u514d\u91cd\u590d\u5f00\u7968\uff0c\u4e0d\u5141\u8bb8\u62c9\u53d6\u6570\u636e\uff01", (String)"GalaSysDataImpl_CHECK_DATE_0", (String)"imc-sim-service", (Object[])new Object[0]), DateUtils.format((Date)limitDate));
                return errorMsg;
            }
        }
        return null;
    }

    private String dealGetSystemSourceMethod(String paramContent) {
        JSONObject paramObject = JSONObject.parseObject((String)paramContent);
        String codeNo = paramObject.getString("codeNo");
        if (StringUtils.isNotEmpty((CharSequence)codeNo)) {
            if (codeNo.startsWith("11")) {
                return BillCenterSystemEnum.SYSTEM_GALA_GZPW.getCode();
            }
            if (codeNo.startsWith("12")) {
                return BillCenterSystemEnum.SYSTEM_GALA_GZCY.getCode();
            }
            if (codeNo.startsWith("13")) {
                return BillCenterSystemEnum.SYSTEM_GALA_ZHPW.getCode();
            }
            if (codeNo.startsWith("14")) {
                return BillCenterSystemEnum.SYSTEM_GALA_ZHCY.getCode();
            }
            if (codeNo.startsWith("15")) {
                return BillCenterSystemEnum.SYSTEM_GALA_QYCY.getCode();
            }
        }
        return null;
    }

    private void dealSaveInterfaceLogDataByType(String systemCode, String opType, String billNoParam, String paramContent, String result, String billStatus) {
        BillCenterInvoiceLogService billCenterInvoiceLogService = new BillCenterInvoiceLogService();
        billCenterInvoiceLogService.dealSaveInterfaceLogDataByType(systemCode, opType, billNoParam, paramContent, result, billStatus);
    }

    private GalaSysQueryOrderDataVO getGalaSysOrderDataMethod(String result) {
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            GalaSysQueryOrderVO galaSysQueryOrderVO = (GalaSysQueryOrderVO)JSONObject.parseObject((String)result, GalaSysQueryOrderVO.class);
            if (galaSysQueryOrderVO == null) {
                String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u73af\u4f01\u8fd4\u56de\u7684\u5f00\u7968\u6570\u636e\u5bf9\u8c61\u4e3a\u7a7a\uff01", (String)"GalaSysDataImpl_10", (String)"imc-sim-service", (Object[])new Object[0]);
                throw new KDBizException(errorMsg);
            }
            String resultCode = galaSysQueryOrderVO.getResult();
            String resultMsg = galaSysQueryOrderVO.getResultMsg();
            logger.info("dealFormatBillDataMethod, resultCode:{}, resultMsg:{}", (Object)resultCode, (Object)resultMsg);
            if (!"0".equals(resultCode)) {
                logger.error("\u5f53\u524d\u73af\u4f01\u8fd4\u56de\u7684\u5f00\u7968\u6570\u636e\u5bf9\u8c61\u5931\u8d25\uff01");
                throw new KDBizException(resultMsg);
            }
            GalaSysQueryOrderDataVO galaSysQueryOrderDataVO = galaSysQueryOrderVO.getResultJson();
            if (galaSysQueryOrderDataVO == null) {
                String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u73af\u4f01\u8fd4\u56de\u7684\u5f00\u7968\u6570\u636e\u5bf9\u8c61\u4e3a\u7a7a\uff01", (String)"GalaSysDataImpl_8", (String)"imc-sim-service", (Object[])new Object[0]);
                throw new KDBizException(errorMsg);
            }
            return galaSysQueryOrderDataVO;
        }
        String errorMsg = ResManager.loadKDString((String)"\u77f3\u57fa\u73af\u4f01\u7cfb\u7edf\u83b7\u53d6\u4e0d\u5230\u76f8\u5173\u7684\u8d26\u5355\u6570\u636e\uff01", (String)"GalaSysDataImpl_9", (String)"imc-sim-service", (Object[])new Object[0]);
        throw new KDBizException(errorMsg);
    }

    private void dealCreateBillCenterDataMethod(String result, String systemSource, String extractedCode, String extractedDate, List<BillVo> applyBillList) {
        GalaSysQueryOrderDataVO galaSysQueryOrderDataVO = this.getGalaSysOrderDataMethod(result);
        boolean flag = false;
        String billNo = galaSysQueryOrderDataVO.getDealID();
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        logger.info("dealCreateBillCenterDataMethod, billNo:{}, systemSource:{}", (Object)billNo, (Object)systemSource);
        QFilter qFilter = new QFilter("billno", "=", (Object)billNo).and("system_code", "=", (Object)systemSource);
        DynamicObject dynamicObject = billCenterInvoiceCommonService.dealLoadIsomerismBillDataMethod(qFilter);
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_isomerism_bill_data");
        } else {
            flag = true;
        }
        logger.info("dealCreateBillCenterDataMethod, GalaSysDataImpl, flag:{}", (Object)flag);
        this.dealCreateBillHeaderDataMethod(dynamicObject, billNo, systemSource, extractedCode, extractedDate, galaSysQueryOrderDataVO);
        this.dealCreateBillItemDataMethod(dynamicObject, galaSysQueryOrderDataVO);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        billCenterInvoiceCommonService.dealFormatBillDataMethod(dynamicObject, applyBillList);
    }

    private void dealCreateBillItemDataMethod(DynamicObject dynamicObject, GalaSysQueryOrderDataVO galaSysQueryOrderDataVO) {
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("sim_isomerism_item_data");
        if (dynamicObjectCollection == null) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u5355\u4e2d\u5fc3\u5546\u54c1\u660e\u7ec6\u533a\u5143\u6570\u636e\u4e0d\u5b58\u5728\uff01", (String)"GalaSysDataImpl_11", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        if (dynamicObjectCollection.size() > 0) {
            dynamicObjectCollection.clear();
        }
        List details = galaSysQueryOrderDataVO.getItems();
        int row = 1;
        String systemCode = dynamicObject.getString("system_code");
        for (GalaSysQueryOrderDataDetailVO orderDataDetailVO : details) {
            Date billDate;
            DynamicObject itemObject = dynamicObjectCollection.addNew();
            itemObject.set("product_id", (Object)row);
            itemObject.set("product_name", (Object)orderDataDetailVO.getName());
            itemObject.set("product_code", null);
            itemObject.set("specification", (Object)orderDataDetailVO.getType());
            int quantity = orderDataDetailVO.getQty();
            if (quantity == 0) {
                quantity = 1;
            }
            itemObject.set("product_quantity", (Object)new BigDecimal(quantity));
            BigDecimal productAmount = orderDataDetailVO.getAmount();
            if (productAmount == null) {
                productAmount = BigDecimal.ZERO;
            }
            itemObject.set("product_amount", (Object)productAmount);
            BigDecimal price = orderDataDetailVO.getPrice();
            if (price == null) {
                price = new BigDecimal(((Object)productAmount).toString()).divide(new BigDecimal(quantity)).setScale(2, 4);
            }
            itemObject.set("product_price", (Object)price);
            itemObject.set("avg_amount", (Object)productAmount);
            String taxCode = orderDataDetailVO.getTaxCode();
            itemObject.set("tax_code", (Object)taxCode);
            Object taxRate = orderDataDetailVO.getTaxRate();
            if (taxRate == null) {
                taxRate = BigDecimal.ZERO;
            }
            itemObject.set("tax_rate", taxRate);
            boolean hasTaxFlag = orderDataDetailVO.getHasTax() == 1;
            BigDecimal taxAmount = TaxCalcUtil.calTax((BigDecimal)new BigDecimal(((Object)productAmount).toString()), (BigDecimal)BigDecimal.ZERO, (String)taxRate.toString(), (boolean)hasTaxFlag);
            itemObject.set("tax_amount", (Object)taxAmount);
            itemObject.set("invoicable_switch", (Object)"1");
            String sellDate = galaSysQueryOrderDataVO.getSellDate();
            if (StringUtils.isNotEmpty((CharSequence)sellDate)) {
                if (sellDate.contains(XIE_GANG_FLAG)) {
                    sellDate = sellDate.replace(XIE_GANG_FLAG, HENG_GANG_FLAG);
                }
                billDate = DateUtils.stringToDate((String)sellDate);
            } else {
                billDate = new Date();
            }
            itemObject.set("consume_time", (Object)billDate);
            itemObject.set("folio_no", null);
            itemObject.set("tc_group", null);
            itemObject.set("tax_no", (Object)orderDataDetailVO.getSellerTaxId());
            itemObject.set("splitkey", (Object)orderDataDetailVO.getSellerTaxId());
            DynamicObject orgObject = TaxUtils.getOrgDynamicObjectByTaxNo((String)orderDataDetailVO.getSellerTaxId());
            itemObject.set("orgid", (Object)orgObject);
            BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
            DynamicObject itemTypeObject = billCenterInvoiceCommonService.getBillCenterItemType(taxCode);
            itemObject.set("itemtype", (Object)itemTypeObject);
            itemObject.set("unpushamount", (Object)productAmount);
            itemObject.set("unpushtax", (Object)taxAmount);
            itemObject.set("unpushnum", (Object)quantity);
            itemObject.set("rowpushstatus", (Object)"-1");
            this.dealSetItemOpenInvoiceTypeMethod(itemObject, taxCode);
            itemObject.set("apply_no", (Object)systemCode);
            ++row;
        }
    }

    private void dealSetItemOpenInvoiceTypeMethod(DynamicObject itemObject, String taxCode) {
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        DynamicObject specialInvoiceObject = billCenterInvoiceCommonService.dealGetSpecialInvoiceMethod(null, null, null, taxCode);
        if (specialInvoiceObject == null) {
            itemObject.set("openinvoicetype", (Object)"02");
        } else {
            String is_special_invoice = specialInvoiceObject.getString("is_special_invoice");
            if (StringUtils.isBlank((CharSequence)is_special_invoice) || "0".equals(is_special_invoice)) {
                itemObject.set("openinvoicetype", (Object)"02");
            } else {
                itemObject.set("openinvoicetype", (Object)"01");
            }
        }
    }

    private void dealCreateBillHeaderDataMethod(DynamicObject dynamicObject, String billNo, String systemSource, String extractedCode, String extractedDate, GalaSysQueryOrderDataVO galaSysQueryOrderDataVO) {
        Date billDate;
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        dynamicObject.set("billno", (Object)billNo);
        dynamicObject.set("billstatus", (Object)"C");
        dynamicObject.set("pushstatus", (Object)"-1");
        dynamicObject.set("system_code", (Object)systemSource);
        String systemName = billCenterInvoiceCommonService.getSystemNameMethod(systemSource);
        dynamicObject.set("system_name", (Object)systemName);
        BillCenterOrgMappingService billCenterOrgMappingService = new BillCenterOrgMappingService();
        DynamicObject frontSystemObject = billCenterOrgMappingService.loadSingleBySystemCode(systemSource);
        dynamicObject.set("system", (Object)frontSystemObject);
        dynamicObject.set("org_code", null);
        dynamicObject.set("org_name", null);
        dynamicObject.set("org", (Object)billCenterInvoiceCommonService.getOrgMethod(systemSource));
        dynamicObject.set("custom_name", null);
        dynamicObject.set("bill_create_time", (Object)new Date());
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        String sellDate = galaSysQueryOrderDataVO.getSellDate();
        if (StringUtils.isNotEmpty((CharSequence)sellDate)) {
            if (sellDate.contains(XIE_GANG_FLAG)) {
                sellDate = sellDate.replace(XIE_GANG_FLAG, HENG_GANG_FLAG);
            }
            billDate = DateUtils.stringToDate((String)sellDate);
        } else {
            billDate = new Date();
        }
        dynamicObject.set("bill_date", (Object)billDate);
        dynamicObject.set("user_phone", null);
        dynamicObject.set("remark", null);
        BigDecimal totalAmount = this.getBillTotalAmountMethod(galaSysQueryOrderDataVO);
        dynamicObject.set("total_amount", (Object)totalAmount);
        dynamicObject.set("invoicable_amount", (Object)totalAmount);
        dynamicObject.set("invoice_amount", (Object)BigDecimal.ZERO);
        dynamicObject.set("remain_amount", (Object)totalAmount);
        dynamicObject.set("invoice_status", (Object)"0");
        dynamicObject.set("extracted_code", (Object)extractedCode);
        dynamicObject.set("hsbz", (Object)"1");
    }

    private BigDecimal getBillTotalAmountMethod(GalaSysQueryOrderDataVO galaSysQueryOrderDataVO) {
        BigDecimal totalAmount = new BigDecimal("0.00");
        List items = galaSysQueryOrderDataVO.getItems();
        for (GalaSysQueryOrderDataDetailVO galaSysQueryOrderDataDetailVO : items) {
            totalAmount = totalAmount.add(galaSysQueryOrderDataDetailVO.getAmount());
        }
        return totalAmount;
    }

    private String doGetDataService(DynamicObject frontSystemObject, String paramContent) throws Exception {
        String sign = this.getSignMethod(frontSystemObject, paramContent);
        logger.info("GalaSysDataImpl, doGetDataService, sign:{}", (Object)sign);
        if (StringUtils.isNotEmpty((CharSequence)sign)) {
            String systemUrl = frontSystemObject.getString("system_url");
            String requestUrl = systemUrl + "/Service1.asmx?op=GetDealInfo";
            logger.info("GalaSysDataImpl, doGetDataService, requestUrl{}", (Object)requestUrl);
            JSONObject paramObject = JSONObject.parseObject((String)paramContent);
            String codeNO = paramObject.getString("codeNo");
            String date = paramObject.getString("date");
            try {
                String dataXml = GalaSysDataImpl.getDataXml(codeNO, date, sign);
                logger.info("GalaSysDataImpl, doGetDataService, dataXml{}", (Object)dataXml);
                String result = GalaSysDataImpl.getHttpResult(requestUrl, dataXml, "text/xml;charset=utf-8");
                logger.info("GalaSysDataImpl, doGetDataService, \u83b7\u53d6\u5f00\u7968\u6570\u636e\uff0cresult\u8fd4\u56de\u5185\u5bb9\u662f\uff1a{}", (Object)result);
                if (StringUtils.isNotEmpty((CharSequence)result)) {
                    int startIndex = result.indexOf("<GetDealInfoResult>") + "<GetDealInfoResult>".length();
                    int endIndex = result.indexOf("</GetDealInfoResult>");
                    String dealInfo = result.substring(startIndex, endIndex);
                    logger.info("GalaSysDataImpl, doGetDataService, \u83b7\u53d6\u5f00\u7968\u6570\u636e\uff0cGetDealInfoResult\u8fd4\u56de\u5185\u5bb9\u662f\uff1a{}", (Object)dealInfo);
                    return dealInfo;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            logger.error("GalaSysDataImpl\uff0c\u83b7\u53d6sign\u4e3a\u7a7a\uff01");
        }
        return null;
    }

    private String getSignMethod(DynamicObject frontSystemObject, String paramContent) throws Exception {
        String systemUrl = frontSystemObject.getString("system_url");
        String requestUrl = systemUrl + "/Service1.asmx?op=GetSign";
        logger.info("GalaSysDataImpl, getSignMethod, requestUrl{}", (Object)requestUrl);
        JSONObject paramObject = JSONObject.parseObject((String)paramContent);
        String codeNO = paramObject.getString("codeNo");
        String date = paramObject.getString("date");
        try {
            String signXml = GalaSysDataImpl.getSignXml(codeNO, date);
            logger.info("GalaSysDataImpl, getSignMethod, signXml{}", (Object)signXml);
            String result = GalaSysDataImpl.getHttpResult(requestUrl, signXml, "text/xml;charset=utf-8");
            logger.info("GalaSysDataImpl, getSignMethod, \u83b7\u53d6sign\u6570\u636e\uff0cresult\u8fd4\u56de\u5185\u5bb9\u662f\uff1a{}", (Object)result);
            if (StringUtils.isNotEmpty((CharSequence)result)) {
                int startIndex = result.indexOf("<GetSignResult>") + "<GetSignResult>".length();
                int endIndex = result.indexOf("</GetSignResult>");
                String sign = result.substring(startIndex, endIndex);
                logger.info("GalaSysDataImpl, getSignMethod, \u83b7\u53d6sign\u6570\u636e\uff0csign\u662f\uff1a{}", (Object)sign);
                return sign;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private String getSignMethod(DynamicObject frontSystemObject, String systemCode, String billNo) throws Exception {
        String systemUrl = frontSystemObject.getString("system_url");
        String requestUrl = systemUrl + "/Service1.asmx?op=GetSign";
        logger.info("GalaSysDataImpl, getSignMethod, requestUrl{}", (Object)requestUrl);
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        DynamicObject billDataObject = billCenterInvoiceCommonService.dealCheckBillCenterDataMethod("billno", billNo, systemCode);
        if (billDataObject == null) {
            String errorMsg = ResManager.loadKDString((String)"\u56de\u8c03\u5f02\u6784\u7cfb\u7edf\u65f6\uff0c\u672a\u5339\u914d\u5230\u8d26\u5355\u4e2d\u5fc3\u7684\u539f\u59cb\u8ba2\u5355\u6570\u636e\uff01", (String)"GalaSysDataImpl_4", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        String codeNo = billDataObject.getString("extracted_code");
        Date billDate = billDataObject.getDate("bill_date");
        if (billDate == null) {
            billDate = new Date();
        }
        String date = DateUtils.format((Date)billDate);
        logger.info("GalaSysDataImpl, getSignMethod, codeNo:{}, date:{}", (Object)codeNo, (Object)date);
        try {
            String signXml = GalaSysDataImpl.getSignXml(codeNo, date);
            logger.info("GalaSysDataImpl, getSignMethod, signXml{}", (Object)signXml);
            String result = GalaSysDataImpl.getHttpResult(requestUrl, signXml, "text/xml;charset=utf-8");
            logger.info("GalaSysDataImpl, getSignMethod, \u83b7\u53d6sign\u6570\u636e\uff0cresult\u8fd4\u56de\u5185\u5bb9\u662f\uff1a{}", (Object)result);
            if (StringUtils.isNotEmpty((CharSequence)result)) {
                int startIndex = result.indexOf("<GetSignResult>") + "<GetSignResult>".length();
                int endIndex = result.indexOf("</GetSignResult>");
                String sign = result.substring(startIndex, endIndex);
                logger.info("GalaSysDataImpl, getSignMethod, \u83b7\u53d6sign\u6570\u636e\uff0csign\u662f\uff1a{}", (Object)sign);
                return sign;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dealUpdateOpenInvoiceStatus(DynamicObject dynamicObject, InvoiceVo invoiceVo) {
        if (invoiceVo == null) {
            logger.error("GalaSysDataImpl, dealUpdateOpenInvoiceStatus, \u56de\u4f20\u5f00\u7968\u5bf9\u8c61\u4e3a\u7a7a\uff01");
            return;
        }
        if (this.invociceFailCallBack(dynamicObject)) {
            return;
        }
        BillCenterOrgMappingService orgMappingService = new BillCenterOrgMappingService();
        String systemCode = invoiceVo.getSystemSource();
        String billNo = invoiceVo.getBillNo();
        logger.info("GalaSysDataImpl, dealUpdateOpenInvoiceStatus, systemCode:{}, billNo:{}", (Object)systemCode, (Object)billNo);
        DynamicObject frontSystemObject = orgMappingService.loadSingleBySystemCode(systemCode);
        String requestContent = "";
        String result = "";
        String dealStatus = null;
        try {
            if (frontSystemObject != null) {
                String sign = this.getSignMethod(frontSystemObject, systemCode, billNo);
                logger.info("GalaSysDataImpl, dealUpdateOpenInvoiceStatus, sign:{}", (Object)sign);
                if (StringUtils.isNotEmpty((CharSequence)sign)) {
                    String systemUrl = frontSystemObject.getString("system_url");
                    String requestUrl = systemUrl + "/Service1.asmx?op=Confirm";
                    requestContent = this.createUpdateResultStatusMethod(invoiceVo, sign);
                    logger.info("GalaSysDataImpl, dealUpdateResultStatus, \u8bf7\u6c42\u53c2\u6570\u5185\u5bb9\u662f:{}", (Object)requestContent);
                    String resultXml = GalaSysDataImpl.getHttpResult(requestUrl, requestContent, "text/xml;charset=utf-8");
                    logger.info("GalaSysDataImpl, dealUpdateResultStatus, resultXml\u7ed3\u679c\u8fd4\u56de\u5185\u5bb9\u662f\uff1a{}", (Object)resultXml);
                    if (StringUtils.isNotEmpty((CharSequence)resultXml)) {
                        int startIndex = resultXml.indexOf("<ConfirmResult>") + "<ConfirmResult>".length();
                        int endIndex = resultXml.indexOf("</ConfirmResult>");
                        result = resultXml.substring(startIndex, endIndex);
                        dealStatus = BillCenterLogEnum.SUCCESS_DEAL_TYPE.getBillStatus();
                        logger.info("GalaSysDataImpl, dealUpdateResultStatus, result\uff1a{}", (Object)result);
                    }
                }
            } else {
                logger.error("\u56de\u4f20\u7ed3\u679c\u72b6\u6001\u65f6\uff0c\u672a\u5339\u914d\u5230\u73af\u4f01\u7684\u7cfb\u7edf\u914d\u7f6e\u6570\u636e\uff01");
            }
        }
        catch (Exception e) {
            dealStatus = BillCenterLogEnum.FAIL_DEAL_TYPE.getBillStatus();
            logger.error("\u63a8\u9001\u77f3\u57fa\u73af\u4f01\uff0c\u66f4\u65b0\u72b6\u6001\u4e0e\u7ed3\u679c\u5904\u7406\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u662f\uff1a{}", (Object)e.getMessage());
        }
        finally {
            int invoiceProperty = invoiceVo.getInvoiceProperty();
            if (0 == invoiceProperty) {
                this.dealSaveInterfaceLogDataByType(systemCode, BillCenterLogEnum.BLUE_INV_RESULT_OP_TYPE.getBillStatus(), invoiceVo.getBillNo(), requestContent, result, dealStatus);
                this.dealStaticsCallbackMethod(billNo, systemCode, result);
            } else if (1 == invoiceProperty) {
                this.dealSaveInterfaceLogDataByType(systemCode, BillCenterLogEnum.RED_INV_RESULT_OP_TYPE.getBillStatus(), invoiceVo.getBillNo(), requestContent, result, dealStatus);
            }
            this.dealCheckDataSourceByDaoKong(billNo, systemCode, invoiceVo);
        }
    }

    private void dealCheckDataSourceByDaoKong(String billNo, String systemCode, InvoiceVo invoiceVo) {
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        DynamicObject billDataObject = billCenterInvoiceCommonService.dealCheckBillCenterDataMethod("billno", billNo, systemCode);
        if (billDataObject == null) {
            logger.error("dealCheckDataSourceByDaoKong, \u8d26\u5355\u7f16\u53f7:{}\uff0c\u7cfb\u7edf\u7f16\u7801:{}, \u672a\u5339\u914d\u5230\u8d26\u5355\u6570\u636e\u3002", (Object)billNo, (Object)systemCode);
            return;
        }
        String daoKongOrderNo = billDataObject.getString("daokong_order_no");
        String daoKongAreaNo = billDataObject.getString("daokong_area_no");
        String daoKongOrderSource = billDataObject.getString("daokong_order_source");
        logger.info("dealCheckDataSourceByDaoKong, daoKongOrderNo:{}, daoKongAreaNo:{}, daoKongOrderSource:{}", new Object[]{daoKongOrderNo, daoKongAreaNo, daoKongOrderSource});
        if (StringUtils.isEmpty((CharSequence)daoKongOrderNo) || StringUtils.isEmpty((CharSequence)daoKongAreaNo) || StringUtils.isEmpty((CharSequence)daoKongOrderSource)) {
            logger.error("dealCheckDataSourceByDaoKong, \u5f53\u524d\u8d26\u5355\u4e0d\u542b\u6709\u9053\u63a7\u8ba2\u5355\u7684\u53c2\u6570\u3002");
            return;
        }
        DaoKongDataImpl externalSystemsDataService = new DaoKongDataImpl();
        QFilter qFilter = new QFilter("invoiceno", "=", (Object)invoiceVo.getInvoiceNum());
        String selectProperties = PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)false);
        DynamicObject invoiceObject = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)selectProperties, (QFilter[])qFilter.toArray());
        externalSystemsDataService.dealUpdateOpenInvoiceStatus(invoiceObject, invoiceVo);
    }

    private void dealStaticsCallbackMethod(String billNo, String systemCode, String result) {
        String callbackStatus;
        if (StringUtils.isNotBlank((CharSequence)result)) {
            GalaSysQueryOrderVO galaSysQueryOrderVO = (GalaSysQueryOrderVO)JSONObject.parseObject((String)result, GalaSysQueryOrderVO.class);
            if (galaSysQueryOrderVO != null) {
                String status = galaSysQueryOrderVO.getResult();
                String resultMsg = galaSysQueryOrderVO.getResultMsg();
                callbackStatus = "0".equals(status) && "\u6210\u529f".equals(resultMsg) ? "1" : ("1".equals(status) && "\u5df2\u5f00\u7535\u5b50\u53d1\u7968".equals(resultMsg) ? "1" : "2");
            } else {
                callbackStatus = "2";
            }
        } else {
            callbackStatus = "2";
        }
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        if ("2".equals(callbackStatus)) {
            billCenterInvoiceCommonService.dealStaticsCallbackMethod(billNo, systemCode, 1, callbackStatus);
        } else {
            billCenterInvoiceCommonService.dealStaticsCallbackMethod(billNo, systemCode, callbackStatus);
        }
    }

    private String createUpdateResultStatusMethod(InvoiceVo invoiceVo, String sign) {
        Date date;
        logger.info("GalaSysDataImpl, createUpdateResultStatusMethod, billNo:{}, batch:{}, systemCode:{}", new Object[]{invoiceVo.getBillNo(), invoiceVo.getBatch(), invoiceVo.getSystemSource()});
        String systemCode = invoiceVo.getSystemSource();
        String billNo = invoiceVo.getBillNo();
        if (StringUtils.isBlank((CharSequence)billNo)) {
            billNo = invoiceVo.getBatch();
        }
        if ((date = invoiceVo.getInvoiceDate()) == null) {
            date = new Date();
        }
        String invoiceDate = DateUtils.format((Date)date, (String)"yyyy-MM-dd");
        String invoiceCode = invoiceVo.getInvoiceCode();
        if (StringUtils.isBlank((CharSequence)invoiceCode)) {
            invoiceCode = "";
        }
        String invoiceNum = invoiceVo.getInvoiceNum();
        String InvType = invoiceVo.getInvoiceType();
        String pdfUrl = invoiceVo.getInvoicePdfFileUrl();
        if (StringUtils.isNotEmpty((CharSequence)pdfUrl)) {
            pdfUrl = Base64.getEncoder().encodeToString(pdfUrl.getBytes());
        }
        String checkCode = invoiceVo.getCheckCode();
        String sellerTaxpayerId = invoiceVo.getSellerTaxpayerId();
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        DynamicObject billDataObject = billCenterInvoiceCommonService.dealCheckBillCenterDataMethod("billno", billNo, systemCode);
        if (billDataObject == null) {
            String errorMsg = ResManager.loadKDString((String)"\u56de\u8c03\u5f02\u6784\u7cfb\u7edf\u65f6\uff0c\u672a\u5339\u914d\u5230\u8d26\u5355\u4e2d\u5fc3\u7684\u539f\u59cb\u8ba2\u5355\u6570\u636e\uff01", (String)"GalaSysDataImpl_3", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        String codeNo = billDataObject.getString("extracted_code");
        Date billDate = billDataObject.getDate("bill_date");
        if (billDate == null) {
            billDate = new Date();
        }
        String codeDate = DateUtils.format((Date)billDate);
        logger.info("GalaSysDataImpl, createUpdateResultStatusMethod, codeNo:{}, codeDate:{}", (Object)codeNo, (Object)codeDate);
        String param = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">\n  <soap:Body>\n    <Confirm xmlns=\"http://tempuri.org/\">\n      <CodeNO>" + codeNo + "</CodeNO>\n      <Date>" + codeDate + "</Date>\n      <InvInfos>\n        <InvInfo>\n          <InvCode>" + invoiceCode + "</InvCode>\n          <InvNumber>" + invoiceNum + "</InvNumber>\n          <InvData>" + invoiceDate + "</InvData>\n          <InvType>" + InvType + "</InvType>\n          <PDFURL>" + pdfUrl + "</PDFURL>\n          <JYM>" + checkCode + "</JYM>\n          <SellerTaxId>" + sellerTaxpayerId + "</SellerTaxId>\n        </InvInfo>\n      </InvInfos>\n      <Sign>" + sign + "</Sign>\n    </Confirm>\n  </soap:Body>\n</soap:Envelope>";
        return param;
    }

    @Override
    public void dealPushCallBackStatusToFrontSystem(JSONObject paramObject) {
        BillCenterInvoiceLogService billCenterInvoiceLogService = new BillCenterInvoiceLogService();
        if (paramObject.containsKey((Object)"approvalResult")) {
            billCenterInvoiceLogService.dealNoticeApprovalRejectMethod(paramObject);
        } else if (paramObject.containsKey((Object)"approvalProcess")) {
            billCenterInvoiceLogService.dealNoticeApprovalProcessMethod(paramObject);
        } else if (paramObject.containsKey((Object)"approvalSuccess")) {
            billCenterInvoiceLogService.dealNoticeApprovalSuccessMethod(paramObject);
        } else {
            this.dealNoticeCallBackStatusToFrontSystem(paramObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealNoticeCallBackStatusToFrontSystem(JSONObject paramObject) {
        block9: {
            BillCenterOrgMappingService orgMappingService = new BillCenterOrgMappingService();
            String systemCode = paramObject.getString("systemCode");
            String innerParam = paramObject.getString("innerParam");
            String billNo = paramObject.getString("billNo");
            String opType = paramObject.getString("opType");
            logger.info("GalaSysDataImpl, dealPushCallBackStatusToFrontSystem, systemCode:{}, billNo:{}", (Object)systemCode, (Object)billNo);
            DynamicObject frontSystemObject = orgMappingService.loadSingleBySystemCode(systemCode);
            String result = "";
            String dealStatus = null;
            try {
                if (frontSystemObject != null) {
                    String systemUrl = frontSystemObject.getString("system_url");
                    String requestUrl = systemUrl + "/Service1.asmx?op=Confirm";
                    String requestContent = innerParam;
                    logger.info("GalaSysDataImpl, dealPushCallBackStatusToFrontSystem, \u8bf7\u6c42\u53c2\u6570\u5185\u5bb9\u662f:{}", (Object)requestContent);
                    String resultXml = GalaSysDataImpl.getHttpResult(requestUrl, requestContent, "text/xml;charset=utf-8");
                    logger.info("GalaSysDataImpl, dealPushCallBackStatusToFrontSystem, resultXml\u7ed3\u679c\u8fd4\u56de\u5185\u5bb9\u662f\uff1a{}", (Object)resultXml);
                    if (StringUtils.isNotEmpty((CharSequence)resultXml)) {
                        int startIndex = resultXml.indexOf("<ConfirmResult>") + "<ConfirmResult>".length();
                        int endIndex = resultXml.indexOf("</ConfirmResult>");
                        result = resultXml.substring(startIndex, endIndex);
                        dealStatus = BillCenterLogEnum.SUCCESS_DEAL_TYPE.getBillStatus();
                        logger.info("GalaSysDataImpl, dealPushCallBackStatusToFrontSystem, result\uff1a{}", (Object)result);
                    } else {
                        dealStatus = BillCenterLogEnum.FAIL_DEAL_TYPE.getBillStatus();
                        result = ResManager.loadKDString((String)"\u624b\u5de5\u63a8\u9001\u56de\u8c03\u7ed3\u679c\u8fd4\u56de\u7684\u5185\u5bb9\u4e3a\u7a7a\uff01", (String)"GalaSysDataImpl_12", (String)"imc-sim-service", (Object[])new Object[0]);
                    }
                    break block9;
                }
                dealStatus = BillCenterLogEnum.FAIL_DEAL_TYPE.getBillStatus();
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u672a\u5339\u914d\u5230\u73af\u4f01\u9910\u996e\u548c\u7968\u52a1\u7cfb\u7edf%1$s\u53c2\u6570\u914d\u7f6e\uff01", (String)"GalaSysDataImpl_2", (String)"imc-sim-service", (Object[])new Object[0]), systemCode));
            }
            catch (Exception e) {
                result = e.getMessage();
                dealStatus = BillCenterLogEnum.FAIL_DEAL_TYPE.getBillStatus();
                logger.error("\u624b\u5de5\u63a8\u9001\u73af\u4f01\u9910\u996e\u548c\u7968\u52a1\u7cfb\u7edf\uff0c\u66f4\u65b0\u72b6\u6001\u4e0e\u7ed3\u679c\u5904\u7406\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u662f\uff1a{}", (Object)result);
            }
            finally {
                this.dealSaveInterfaceLogDataByType(systemCode, opType, billNo, innerParam, result, dealStatus);
                if (BillCenterLogEnum.BLUE_INV_RESULT_OP_TYPE.getBillStatus().equals(opType)) {
                    this.dealStaticsCallbackMethod(billNo, systemCode, result);
                }
            }
        }
    }

    @Override
    public String dealGetQrCodeMethod(JSONObject paramObject) {
        return null;
    }

    private static String getSignXml(String codeNO, String date) {
        String signXml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">\n  <soap:Body>\n    <GetSign xmlns=\"http://tempuri.org/\">\n      <CodeNO>" + codeNO + "</CodeNO>\n      <Date>" + date + "</Date>\n    </GetSign>\n  </soap:Body>\n</soap:Envelope>";
        return signXml;
    }

    private static String getDataXml(String codeNO, String date, String sign) {
        String dataXml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">\n  <soap:Body>\n    <GetDealInfo xmlns=\"http://tempuri.org/\">\n      <CodeNO>" + codeNO + "</CodeNO>\n      <Date>" + date + "</Date>\n      <Sign>" + sign + "</Sign>\n    </GetDealInfo>\n  </soap:Body>\n</soap:Envelope>";
        return dataXml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getHttpResult(String sendUrl, String param, String contentType) throws IOException {
        HttpURLConnection conn = null;
        String result = "";
        try {
            String result1 = ExternalSystemDataHandler.getUntilTestResult(sendUrl, sendUrl, param);
            if (result1 != null) {
                String string = result1;
                return string;
            }
            URL url = new URL(sendUrl);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setRequestProperty("Charset", "UTF-8");
            conn.setRequestProperty("Connection", "Keep-Alive");
            conn.setRequestProperty("Content-Type", contentType);
            conn.setConnectTimeout(15000);
            conn.setReadTimeout(150000);
            conn.connect();
            try (OutputStream out = conn.getOutputStream();){
                out.write(param.getBytes(StandardCharsets.UTF_8));
                out.flush();
                out.close();
                try (InputStream inputStream = conn.getInputStream();){
                    result = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                }
            }
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return result;
    }
}

