/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.billcenter.sys.impl;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.openapi.InvoiceVo;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.sim.billcenter.BillCenterInvoiceCommonService;
import kd.imc.sim.billcenter.BillCenterInvoiceLogService;
import kd.imc.sim.billcenter.BillCenterOrgMappingService;
import kd.imc.sim.billcenter.domain.JieShunOrderVO;
import kd.imc.sim.billcenter.sys.ExternalSystemsDataService;
import kd.imc.sim.billcenter.util.JdbcUtil;
import kd.imc.sim.common.constant.ErrorType;
import kd.imc.sim.common.model.billcenter.BillErrorVo;
import kd.imc.sim.common.service.SimClassMappingService;
import kd.imc.sim.common.utils.TaxCalcUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class JieShunDataImpl
implements ExternalSystemsDataService {
    private static final Log logger = LogFactory.getLog(JieShunDataImpl.class);

    @Override
    public List<BillVo> getData(JSONObject paramObject) {
        String errorMsg;
        BillErrorVo billErrorVo;
        ArrayList<BillVo> applyBillList = new ArrayList<BillVo>();
        String paramContent = paramObject.getString("paramContent");
        String systemCode = paramObject.getString("systemCode");
        logger.info("JieShunDataImpl, paramContent:{}, systemCode:{}", (Object)paramContent, (Object)systemCode);
        if (StringUtils.isEmpty((CharSequence)systemCode) || StringUtils.isEmpty((CharSequence)paramContent) || "{}".equals(paramContent)) {
            throw new KDBizException(new ErrorCode(ErrorType.PARAM_IS_NULL.getErrcode(), ErrorType.PARAM_IS_NULL.getDescription()), new Object[]{systemCode});
        }
        this.dealSyncJieShunBillDataMethod(systemCode, paramContent);
        String voucherNo = this.getBillNoParamMethod(paramContent);
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        QFilter qFilter = new QFilter("voucher_no", "=", (Object)voucherNo).and("system_code", "=", (Object)systemCode);
        DynamicObjectCollection dynamicObjectCollection = billCenterInvoiceCommonService.dealCheckBillCenterDataMethod(qFilter);
        if (dynamicObjectCollection == null || dynamicObjectCollection.isEmpty()) {
            String errorMsg2 = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u67e5\u8be2\u7684\u8f66\u724c\u53f7:%1$s\uff0c\u672a\u627e\u5230\u76f8\u5173\u7684\u8ba2\u5355\u6570\u636e\uff01", (String)"JieShunDataImpl_4", (String)"imc-sim-service", (Object[])new Object[0]), voucherNo);
            throw new KDBizException(errorMsg2);
        }
        int size = dynamicObjectCollection.size();
        logger.info("JieShunDataImpl\uff0c size:{}", (Object)size);
        int finishedNum = 0;
        int processNum = 0;
        int unFinishNum = 0;
        ArrayList<DynamicObject> unFinishedList = new ArrayList<DynamicObject>(dynamicObjectCollection.size());
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String push_status = dynamicObject.getString("pushstatus");
            String billno = dynamicObject.getString("billno");
            String invoice_status = dynamicObject.getString("invoice_status");
            boolean flag = ("1".equals(invoice_status) || "5".equals(invoice_status)) && "1".equals(push_status);
            logger.info("JieShunDataImpl, \u539f\u59cb\u8ba2\u5355\u7f16\u53f7:{}, \u53d1\u7968\u72b6\u6001:{}, \u4e0b\u63a8\u72b6\u6001\uff1a{}, flag:{}", new Object[]{billno, invoice_status, push_status, flag});
            if (flag) {
                ++finishedNum;
                continue;
            }
            if ("2".equals(invoice_status) || "7".equals(invoice_status)) {
                ++processNum;
                continue;
            }
            ++unFinishNum;
            unFinishedList.add(dynamicObject);
        }
        logger.info("JieShunDataImpl, finishedNum:{}, processNum:{}, unFinishNum:{}", new Object[]{finishedNum, processNum, unFinishNum});
        if (size == finishedNum) {
            billErrorVo = new BillErrorVo();
            errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u67e5\u8be2\u7684\u8f66\u724c\u53f7:%1$s\u8ba2\u5355\u6570\u636e\uff0c\u5df2\u7ecf\u5b8c\u6210\u5f00\u7968\uff01", (String)"JieShunDataImpl_0", (String)"imc-sim-service", (Object[])new Object[0]), voucherNo);
            billErrorVo.setErrorMsg(errorMsg);
            billErrorVo.setFailNum(1);
            applyBillList.add((BillVo)billErrorVo);
            return applyBillList;
        }
        if (size == processNum) {
            billErrorVo = new BillErrorVo();
            errorMsg = ResManager.loadKDString((String)"\u6b64\u8ba2\u5355\u5df2\u90e8\u5206\u5f00\u7968\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u5f00\u5177\u5269\u4f59\u53d1\u7968\u91d1\u989d!", (String)"JieShunDataImpl_2", (String)"imc-sim-service", (Object[])new Object[0]);
            billErrorVo.setErrorMsg(errorMsg);
            billErrorVo.setFailNum(1);
            applyBillList.add((BillVo)billErrorVo);
            return applyBillList;
        }
        if (unFinishNum > 0) {
            this.dealGetJieShunOrderDataMethod(unFinishedList, paramContent, applyBillList);
        }
        return applyBillList;
    }

    private void dealGetJieShunOrderDataMethod(List<DynamicObject> unFinishedList, String paramContent, List<BillVo> applyBillList) {
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        for (DynamicObject dynamicObject : unFinishedList) {
            String billNo = dynamicObject.getString("billno");
            boolean isMoreThanFlag = this.dealRecentlyOrderDataMethod(dynamicObject);
            boolean opKey = billCenterInvoiceCommonService.dealCheckAppOpKeyMethod(paramContent);
            logger.info("dealCreateBillCenterDataMethod, JieShunDataImpl, billNo:{}, isMoreThanFlag:{}, opKey:{}", new Object[]{billNo, isMoreThanFlag, opKey});
            if (isMoreThanFlag && opKey) continue;
            billCenterInvoiceCommonService.dealFormatBillDataMethod(dynamicObject, applyBillList);
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("sim_isomerism_item_data");
            String parkName = "";
            if (CollectionUtils.isNotEmpty((Collection)dynamicObjectCollection)) {
                DynamicObject itemObject = (DynamicObject)dynamicObjectCollection.get(0);
                parkName = itemObject.getString("product_code");
            }
            for (BillVo billVo : applyBillList) {
                billVo.setTextField2(parkName);
            }
        }
    }

    private boolean dealRecentlyOrderDataMethod(DynamicObject dynamicObject) {
        Date nowDate = new Date();
        String billNo = dynamicObject.getString("billno");
        Date end_date = dynamicObject.getDate("bill_date");
        if (end_date == null) {
            end_date = dynamicObject.getDate("createtime");
        }
        int disDays = DateUtils.timeDifferenceDay((Date)end_date, (Date)nowDate);
        logger.info("JieShunDataImpl, dealRecentlyOrderDataMethod, billNo:{}, disDays:{}", (Object)billNo, (Object)disDays);
        return disDays > 30;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealSyncJieShunBillDataMethod(String systemCode, String paramContent) {
        ResultSet resultSet;
        PreparedStatement statement;
        Connection connection;
        block9: {
            List<JieShunOrderVO> jieShunOrderVOList;
            block8: {
                connection = null;
                statement = null;
                resultSet = null;
                connection = JdbcUtil.getConnection((String)systemCode);
                String sql = this.getSQLMethod();
                statement = connection.prepareStatement(sql);
                String voucherNo = null;
                if (StringUtils.isNotEmpty((CharSequence)paramContent)) {
                    voucherNo = this.getBillNoParamMethod(paramContent);
                    statement.setString(1, voucherNo);
                }
                resultSet = statement.executeQuery();
                jieShunOrderVOList = this.dealFormatJieShunOrderMethod(resultSet);
                logger.info("JieShunDataImpl,\u8f6c\u6362\u6210\u6377\u987a\u8ba2\u5355\u5bf9\u8c61\u5217\u8868\u662f:{}", (Object)jieShunOrderVOList.size());
                if (jieShunOrderVOList.size() != 0) break block8;
                JdbcUtil.close((ResultSet)resultSet, (Statement)statement, (Connection)connection);
                return;
            }
            try {
                ArrayList<JieShunOrderVO> needOpenInvoiceList = new ArrayList<JieShunOrderVO>(jieShunOrderVOList.size());
                ArrayList<JieShunOrderVO> notNeedOpenInvoiceList = new ArrayList<JieShunOrderVO>(jieShunOrderVOList.size());
                this.dealGetNeedOpenInvoiceListMethod(jieShunOrderVOList, needOpenInvoiceList, notNeedOpenInvoiceList);
                logger.info("\u9700\u8981\u5f00\u7968\u7684\u6377\u987a\u505c\u8f66\u7684\u8ba2\u5355\u6570\u636e:{}", (Object)needOpenInvoiceList.size());
                if (needOpenInvoiceList.size() > 0) {
                    List<JieShunOrderVO> jieShunOrderList = this.dealCheckNoPullBillDataMethod(needOpenInvoiceList, systemCode);
                    this.dealCreateBillCenterDataMethod(jieShunOrderList, systemCode, paramContent);
                    break block9;
                }
                if (needOpenInvoiceList.size() != 0 || notNeedOpenInvoiceList.size() > 0) {
                    // empty if block
                }
            }
            catch (Exception e) {
                try {
                    String errorMsg = e.getMessage();
                    logger.error("\u67e5\u8be2\u6377\u987a\u6570\u636e\uff0c\u4fdd\u5b58\u5165\u8d26\u5355\u4e2d\u5fc3\u51fa\u73b0\u5f02\u5e38:{}", (Object)errorMsg);
                }
                catch (Throwable throwable) {
                    JdbcUtil.close(resultSet, statement, (Connection)connection);
                    throw throwable;
                }
                JdbcUtil.close(resultSet, (Statement)statement, (Connection)connection);
            }
        }
        JdbcUtil.close((ResultSet)resultSet, (Statement)statement, (Connection)connection);
    }

    private List<JieShunOrderVO> dealCheckNoPullBillDataMethod(List<JieShunOrderVO> needOpenInvoiceList, String systemCode) {
        ArrayList<JieShunOrderVO> jieShunOrderList = new ArrayList<JieShunOrderVO>(needOpenInvoiceList.size());
        ArrayList<JieShunOrderVO> notSaveOrderList = new ArrayList<JieShunOrderVO>(needOpenInvoiceList.size());
        QFilter qFilter = new QFilter("number", "=", (Object)systemCode);
        DynamicObject simClassMappingCfg = SimClassMappingService.getInterfaceByCondition((QFilter)qFilter);
        if (simClassMappingCfg != null) {
            Date limitDate = simClassMappingCfg.getDate("limit_date");
            if (limitDate == null) {
                logger.info("dealCheckNoPullBillDataMethod, needOpenInvoiceList\u5927\u5c0f:{}", (Object)needOpenInvoiceList.size());
                return needOpenInvoiceList;
            }
            for (JieShunOrderVO jieShunOrderVO : needOpenInvoiceList) {
                String chargeTime = jieShunOrderVO.getChargeTime();
                if (!StringUtils.isNotEmpty((CharSequence)chargeTime)) continue;
                Date chargeDate = DateUtils.stringToDate((String)chargeTime);
                if (chargeDate.compareTo(limitDate) <= 0) {
                    notSaveOrderList.add(jieShunOrderVO);
                    continue;
                }
                jieShunOrderList.add(jieShunOrderVO);
            }
        }
        logger.info("dealCheckNoPullBillDataMethod, jieShunOrderList:{}, notSaveOrderList:{}", (Object)jieShunOrderList.size(), (Object)notSaveOrderList.size());
        return jieShunOrderList;
    }

    private String getBillNoParamMethod(String paramContent) {
        JSONObject subObject = JSONObject.parseObject((String)paramContent);
        String voucherNo = subObject.getString("billNo");
        return voucherNo;
    }

    private void dealCreateBillCenterDataMethod(List<JieShunOrderVO> needOpenInvoiceList, String systemCode, String paramContent) {
        for (JieShunOrderVO jieShunOrderVO : needOpenInvoiceList) {
            boolean flag = false;
            String billNo = jieShunOrderVO.getOrderId();
            BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
            logger.info("dealCreateBillCenterDataMethod, billNo:{}, systemSource:{}", (Object)billNo, (Object)systemCode);
            QFilter qFilter = new QFilter("billno", "=", (Object)billNo).and("system_code", "=", (Object)systemCode);
            DynamicObject dynamicObject = billCenterInvoiceCommonService.dealLoadIsomerismBillDataMethod(qFilter);
            if (dynamicObject == null) {
                dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_isomerism_bill_data");
            } else {
                flag = true;
            }
            logger.info("dealCreateBillCenterDataMethod, JieShunDataImpl, flag:{}", (Object)flag);
            this.dealCreateBillHeaderDataMethod(dynamicObject, billNo, systemCode, jieShunOrderVO);
            this.dealCreateBillItemDataMethod(dynamicObject, jieShunOrderVO);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    private void dealCreateBillItemDataMethod(DynamicObject dynamicObject, JieShunOrderVO jieShunOrderVO) {
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("sim_isomerism_item_data");
        if (dynamicObjectCollection == null) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u5355\u4e2d\u5fc3\u5546\u54c1\u660e\u7ec6\u533a\u5143\u6570\u636e\u4e0d\u5b58\u5728\uff01", (String)"JieShunDataImpl_5", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        if (dynamicObjectCollection.size() > 0) {
            dynamicObjectCollection.clear();
        }
        int row = 1;
        DynamicObject itemObject = dynamicObjectCollection.addNew();
        itemObject.set("product_id", (Object)row);
        itemObject.set("product_name", (Object)ResManager.loadKDString((String)"\u505c\u8f66\u8d39", (String)"JieShunDataImpl_1", (String)"imc-sim-service", (Object[])new Object[0]));
        itemObject.set("product_code", (Object)jieShunOrderVO.getParkName());
        itemObject.set("product_type", null);
        int quantity = 1;
        itemObject.set("product_quantity", (Object)new BigDecimal(quantity));
        BigDecimal productAmount = jieShunOrderVO.getActualMoney();
        if (productAmount == null) {
            productAmount = BigDecimal.ZERO;
        }
        itemObject.set("product_amount", (Object)productAmount);
        BigDecimal price = jieShunOrderVO.getActualMoney();
        if (price == null) {
            price = new BigDecimal(((Object)productAmount).toString()).divide(new BigDecimal(quantity)).setScale(2, 4);
        }
        itemObject.set("product_price", (Object)price);
        itemObject.set("avg_amount", (Object)productAmount);
        String taxCode = jieShunOrderVO.getTaxCode();
        itemObject.set("tax_code", (Object)taxCode);
        BigDecimal taxRate = jieShunOrderVO.getTaxRate();
        if (taxRate == null) {
            taxRate = BigDecimal.ZERO;
        }
        BigDecimal tax_rate = new BigDecimal(((Object)taxRate).toString()).divide(new BigDecimal(100)).setScale(2, 4);
        itemObject.set("tax_rate", (Object)tax_rate);
        BigDecimal taxAmount = TaxCalcUtil.calTax((BigDecimal)new BigDecimal(((Object)productAmount).toString()), (BigDecimal)BigDecimal.ZERO, (String)tax_rate.toString(), (boolean)true);
        itemObject.set("tax_amount", (Object)taxAmount);
        itemObject.set("invoicable_switch", (Object)"1");
        String chargeTime = jieShunOrderVO.getChargeTime();
        Date billDate = StringUtils.isEmpty((CharSequence)chargeTime) ? DateUtils.stringToDate((String)chargeTime) : new Date();
        itemObject.set("consume_time", (Object)billDate);
        itemObject.set("folio_no", null);
        itemObject.set("tc_group", null);
        String taxNo = jieShunOrderVO.getTaxNum();
        itemObject.set("tax_no", (Object)taxNo);
        itemObject.set("splitkey", (Object)taxNo);
        DynamicObject orgObject = TaxUtils.getOrgDynamicObjectByTaxNo((String)taxNo);
        itemObject.set("orgid", (Object)orgObject);
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        DynamicObject itemTypeObject = billCenterInvoiceCommonService.getBillCenterItemType(taxCode);
        itemObject.set("itemtype", (Object)itemTypeObject);
        itemObject.set("unpushamount", (Object)productAmount);
        itemObject.set("unpushtax", (Object)taxAmount);
        itemObject.set("unpushnum", (Object)quantity);
        itemObject.set("rowpushstatus", (Object)"-1");
        this.dealSetItemOpenInvoiceTypeMethod(itemObject, taxCode);
        String systemCode = dynamicObject.getString("system_code");
        itemObject.set("apply_no", (Object)systemCode);
        ++row;
    }

    private void dealSetItemOpenInvoiceTypeMethod(DynamicObject itemObject, String taxCode) {
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        DynamicObject specialInvoiceObject = billCenterInvoiceCommonService.dealGetSpecialInvoiceMethod(null, null, null, taxCode);
        if (specialInvoiceObject == null) {
            itemObject.set("openinvoicetype", (Object)"02");
        } else {
            String is_special_invoice = specialInvoiceObject.getString("is_special_invoice");
            if (StringUtils.isBlank((CharSequence)is_special_invoice) || "0".equals(is_special_invoice)) {
                itemObject.set("openinvoicetype", (Object)"02");
            } else {
                itemObject.set("openinvoicetype", (Object)"01");
            }
        }
    }

    private void dealCreateBillHeaderDataMethod(DynamicObject dynamicObject, String billNo, String systemCode, JieShunOrderVO jieShunOrderVO) {
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        dynamicObject.set("billno", (Object)billNo);
        dynamicObject.set("billstatus", (Object)"C");
        dynamicObject.set("pushstatus", (Object)"-1");
        dynamicObject.set("system_code", (Object)systemCode);
        String systemName = billCenterInvoiceCommonService.getSystemNameMethod(systemCode);
        dynamicObject.set("system_name", (Object)systemName);
        BillCenterOrgMappingService billCenterOrgMappingService = new BillCenterOrgMappingService();
        DynamicObject frontSystemObject = billCenterOrgMappingService.loadSingleBySystemCode(systemCode);
        dynamicObject.set("system", (Object)frontSystemObject);
        dynamicObject.set("org_code", (Object)jieShunOrderVO.getCompanyId());
        dynamicObject.set("org_name", (Object)jieShunOrderVO.getCompanyName());
        String taxNo = jieShunOrderVO.getTaxNum();
        DynamicObject orgObject = TaxUtils.getOrgDynamicObjectByTaxNo((String)taxNo);
        dynamicObject.set("org", (Object)orgObject);
        dynamicObject.set("custom_name", null);
        dynamicObject.set("bill_create_time", (Object)new Date());
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        String sellDate = jieShunOrderVO.getChargeTime();
        Date billDate = StringUtils.isNotEmpty((CharSequence)sellDate) ? DateUtils.stringToDate((String)sellDate) : new Date();
        dynamicObject.set("bill_date", (Object)billDate);
        dynamicObject.set("user_phone", null);
        dynamicObject.set("remark", null);
        BigDecimal totalAmount = jieShunOrderVO.getActualMoney();
        dynamicObject.set("total_amount", (Object)totalAmount);
        dynamicObject.set("invoicable_amount", (Object)totalAmount);
        dynamicObject.set("invoice_amount", (Object)BigDecimal.ZERO);
        dynamicObject.set("remain_amount", (Object)totalAmount);
        dynamicObject.set("invoice_status", (Object)"0");
        dynamicObject.set("voucher_no", (Object)jieShunOrderVO.getVoucherNo());
        dynamicObject.set("begin_date", (Object)DateUtils.stringToDate((String)jieShunOrderVO.getInTime()));
        dynamicObject.set("end_date", (Object)DateUtils.stringToDate((String)jieShunOrderVO.getChargeTime()));
        dynamicObject.set("hsbz", (Object)"1");
    }

    private void dealGetNeedOpenInvoiceListMethod(List<JieShunOrderVO> jieShunOrderVOList, List<JieShunOrderVO> needOpenInvoiceList, List<JieShunOrderVO> notNeedOpenInvoiceList) {
        for (JieShunOrderVO jieShunOrderVO : jieShunOrderVOList) {
            String invoiced = jieShunOrderVO.getInvoiced();
            if ("0".equals(invoiced)) {
                needOpenInvoiceList.add(jieShunOrderVO);
                continue;
            }
            if (!"1".equals(invoiced)) continue;
            notNeedOpenInvoiceList.add(jieShunOrderVO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dealUpdateOpenInvoiceStatus(DynamicObject dynamicObject, InvoiceVo invoiceVo) {
        if (dynamicObject == null) {
            logger.error("JieShunDataImpl, dealUpdateOpenInvoiceStatus, \u56de\u4f20\u5f00\u7968\u5bf9\u8c61\u4e3a\u7a7a\uff01");
            return;
        }
        if (this.invociceFailCallBack(dynamicObject)) {
            return;
        }
        logger.info("JieShunDataImpl, dealUpdateOpenInvoiceStatus, invoiceVo\uff1a{}", (Object)SerializationUtils.toJsonString((Object)invoiceVo));
        String systemCode = invoiceVo.getSystemSource();
        String billNo = invoiceVo.getBillNo();
        logger.info("JieShunDataImpl, dealUpdateOpenInvoiceStatus, systemCode:{}, billNo:{}", (Object)systemCode, (Object)billNo);
        if (StringUtils.isEmpty((CharSequence)systemCode) || StringUtils.isEmpty((CharSequence)billNo)) {
            logger.error("\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u591f\u66f4\u65b0\u6377\u987a\u505c\u8f66\u7684\u6570\u636e\u72b6\u6001\uff01");
            return;
        }
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = JdbcUtil.getConnection((String)systemCode);
            String sql = this.getUpdateSQLMethod();
            statement = connection.prepareStatement(sql);
            if (StringUtils.isNotEmpty((CharSequence)billNo)) {
                statement.setString(1, billNo);
            }
            int row = statement.executeUpdate();
            logger.info("JieShunDataImpl, dealUpdateOpenInvoiceStatus, row:{}", (Object)row);
        }
        catch (Exception e) {
            try {
                logger.error("\u66f4\u65b0\u6377\u987a\u505c\u8f66\u7684\u6570\u636e\u51fa\u73b0\u5f02\u5e38:{}", (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                JdbcUtil.close(null, statement, (Connection)connection);
                throw throwable;
            }
            JdbcUtil.close(null, (Statement)statement, (Connection)connection);
        }
        JdbcUtil.close(null, (Statement)statement, (Connection)connection);
    }

    @Override
    public void dealPushCallBackStatusToFrontSystem(JSONObject paramObject) {
        BillCenterInvoiceLogService billCenterInvoiceLogService = new BillCenterInvoiceLogService();
        if (paramObject.containsKey((Object)"approvalResult")) {
            billCenterInvoiceLogService.dealNoticeApprovalRejectMethod(paramObject);
        } else if (paramObject.containsKey((Object)"approvalProcess")) {
            billCenterInvoiceLogService.dealNoticeApprovalProcessMethod(paramObject);
        } else if (paramObject.containsKey((Object)"approvalSuccess")) {
            billCenterInvoiceLogService.dealNoticeApprovalSuccessMethod(paramObject);
        }
    }

    @Override
    public String dealGetQrCodeMethod(JSONObject paramObject) {
        return null;
    }

    private String getSQLMethod() {
        String sql = "select COMPANY_ID, COMPANY_NAME,PARKNAME, ORDER_ID, VOUCHER_NO, CHARGE_TIME, IN_TIME, ACTUAL_MONEY, AFTER_TAX_MONEY,TAX_RATE,TAX_CODE,TAX_NUM,INVOICED from JIESHUN_TAX where VOUCHER_NO=? and INVOICED=0";
        return sql;
    }

    private String getUpdateSQLMethod() {
        String sql = "update JIESHUN_TAX set INVOICED=1 where ORDER_ID=?";
        return sql;
    }

    private List<JieShunOrderVO> dealFormatJieShunOrderMethod(ResultSet resultSet) throws SQLException {
        ArrayList<JieShunOrderVO> JieShunOrderVOList = new ArrayList<JieShunOrderVO>(50);
        while (resultSet.next()) {
            JieShunOrderVO jieShunOrderVO = new JieShunOrderVO();
            jieShunOrderVO.setCompanyId(resultSet.getString("COMPANY_ID"));
            jieShunOrderVO.setCompanyName(resultSet.getString("COMPANY_NAME"));
            jieShunOrderVO.setParkName(resultSet.getString("PARKNAME"));
            jieShunOrderVO.setOrderId(resultSet.getString("ORDER_ID"));
            jieShunOrderVO.setVoucherNo(resultSet.getString("VOUCHER_NO"));
            jieShunOrderVO.setChargeTime(resultSet.getString("CHARGE_TIME"));
            jieShunOrderVO.setInTime(resultSet.getString("IN_TIME"));
            jieShunOrderVO.setActualMoney(resultSet.getBigDecimal("ACTUAL_MONEY"));
            jieShunOrderVO.setAfterTaxMoney(resultSet.getBigDecimal("AFTER_TAX_MONEY"));
            jieShunOrderVO.setTaxRate(resultSet.getBigDecimal("TAX_RATE"));
            jieShunOrderVO.setTaxCode(resultSet.getString("TAX_CODE"));
            jieShunOrderVO.setTaxNum(resultSet.getString("TAX_NUM"));
            jieShunOrderVO.setInvoiced(resultSet.getString("INVOICED"));
            JieShunOrderVOList.add(jieShunOrderVO);
        }
        return JieShunOrderVOList;
    }
}

