/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.billcenter.sys.impl;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.openapi.InvoiceVo;
import kd.imc.bdm.common.util.Base64Util;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.sim.billcenter.BillCenterInvoiceCommonService;
import kd.imc.sim.billcenter.BillCenterInvoiceCoreService;
import kd.imc.sim.billcenter.BillCenterInvoiceLogService;
import kd.imc.sim.billcenter.BillCenterOrgMappingService;
import kd.imc.sim.billcenter.sys.ExternalSystemsDataService;
import kd.imc.sim.billcenter.sys.OperaBlockDataLogicService;
import kd.imc.sim.billcenter.sys.OperaCommonLogicService;
import kd.imc.sim.common.constant.ErrorType;
import kd.imc.sim.common.model.billcenter.BillErrorVo;
import kd.imc.sim.common.service.SimClassMappingService;
import org.apache.commons.lang3.StringUtils;

public class OperaDataImpl
implements ExternalSystemsDataService {
    private static final Log logger = LogFactory.getLog(OperaDataImpl.class);

    @Override
    public List<BillVo> getData(JSONObject paramObject) {
        ArrayList<BillVo> applyBillList;
        block8: {
            applyBillList = new ArrayList<BillVo>();
            String paramContent = paramObject.getString("paramContent");
            String systemCode = paramObject.getString("systemCode");
            logger.info("OperaDataImpl, paramContent:{}, systemCode:{}", (Object)paramContent, (Object)systemCode);
            if (StringUtils.isEmpty((CharSequence)paramContent) || StringUtils.isEmpty((CharSequence)systemCode)) {
                throw new KDBizException(new ErrorCode(ErrorType.PARAM_IS_NULL.getErrcode(), ErrorType.PARAM_IS_NULL.getDescription()), new Object[]{systemCode});
            }
            try {
                String opKey = this.getOpKeyMethod(paramContent);
                logger.info("OperaDataImpl, opKey:{}", (Object)opKey);
                ArrayList<Object> successMsgList = new ArrayList<Object>(16);
                ArrayList<Object> errorMsgList = new ArrayList<Object>(16);
                if ("APP".equals(opKey)) {
                    DynamicObjectCollection dynamicObjectCollection = this.doGetDataService(paramContent, systemCode);
                    boolean isScanFlag = this.dealCheckIsScanMethod(paramContent);
                    ArrayList<String> tipMsgList = new ArrayList<String>(8);
                    dynamicObjectCollection = this.dealRecentlyOrderDataMethod(dynamicObjectCollection, isScanFlag, tipMsgList);
                    logger.info("OperaDataImpl\uff0c \u79fb\u52a8\u7aef\u67e5\u8be2\u5230\u6570\u636e\u5927\u5c0f\u662f:{}, isScanFlag:{}, tipMsgList\u5927\u5c0f:{}", new Object[]{dynamicObjectCollection.size(), isScanFlag, tipMsgList.size()});
                    if (isScanFlag && !tipMsgList.isEmpty()) {
                        BillErrorVo billErrorVo = new BillErrorVo();
                        billErrorVo.setErrorMsg((String)tipMsgList.get(0));
                        billErrorVo.setFailNum(1);
                        applyBillList.add((BillVo)billErrorVo);
                        return applyBillList;
                    }
                    BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
                    for (DynamicObject dynamicObject : dynamicObjectCollection) {
                        billCenterInvoiceCommonService.dealFormatBillDataMethod(dynamicObject, applyBillList);
                    }
                    break block8;
                }
                if ("PC".equals(opKey)) {
                    this.dealSyncOperaDataByDBConnect(systemCode, paramContent, successMsgList, errorMsgList);
                    this.dealCheckBillCenterMoreThanDate(systemCode, successMsgList, errorMsgList);
                    logger.info("\u5f53\u524d\u6267\u884c\u6210\u529f\u7684\u6570\u91cf\u662f:{}\uff0c\u9519\u8bef\u7684\u6570\u91cf\u662f:{}", (Object)successMsgList.size(), (Object)errorMsgList.size());
                    this.dealFormatBillErrorDataMethod(successMsgList, errorMsgList, applyBillList);
                    break block8;
                }
                if ("PC_BLOCK".equals(opKey)) {
                    long startTime = System.currentTimeMillis();
                    ThreadPools.executeOnceIncludeRequestContext((String)"sync_block_opera_bill_data", () -> {
                        OperaBlockDataLogicService simGetBillDataService = new OperaBlockDataLogicService();
                        simGetBillDataService.dealSyncOperaBlockBillDataMethod(systemCode, paramContent, successMsgList, errorMsgList);
                    });
                    long endTime = System.currentTimeMillis();
                    logger.info("\u6267\u884c\u7684\u65f6\u95f4\u5dee\u662f:{}", (Object)(endTime - startTime));
                    break block8;
                }
                String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u7c7b\u578b\u4e0d\u5b58\u5728\uff01", (String)"OperaDataImpl_1", (String)"imc-sim-service", (Object[])new Object[0]);
                throw new KDBizException(errorMsg);
            }
            catch (Exception e) {
                String errorMsg = e.getMessage();
                logger.error("\u83b7\u53d6Opera\u4e1a\u52a1\u7cfb\u7edf\u7684\u5f85\u7533\u8bf7\u5f00\u7968\u6570\u636e\u51fa\u73b0\u5f02\u5e38:{}", (Object)errorMsg);
                BillErrorVo billErrorVo = new BillErrorVo();
                billErrorVo.setErrorMsg(errorMsg);
                billErrorVo.setFailNum(1);
                applyBillList.add((BillVo)billErrorVo);
            }
        }
        return applyBillList;
    }

    private boolean dealCheckIsScanMethod(String paramContent) {
        JSONObject jsonObject = JSONObject.parseObject((String)paramContent);
        String billNo = jsonObject.getString("billNo");
        String phoneNumber = jsonObject.getString("phoneNumber");
        return StringUtils.isNotEmpty((CharSequence)billNo) && StringUtils.isEmpty((CharSequence)phoneNumber);
    }

    public void dealCheckBillCenterMoreThanDate(String systemCode, List<Object> successMsgList, List<Object> errorMsgList) {
        String billNo;
        DynamicObject billCenterObject;
        DynamicObject simClassMappingCfg = SimClassMappingService.getInterfaceByCode((String)systemCode);
        if (simClassMappingCfg == null) {
            return;
        }
        Date limitDate = simClassMappingCfg.getDate("limit_date");
        if (limitDate == null) {
            return;
        }
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        ArrayList<Object> subList = new ArrayList<Object>(successMsgList.size());
        for (Object object : successMsgList) {
            billCenterObject = (DynamicObject)object;
            billNo = billCenterObject.getString("billno");
            Date endDate = billCenterObject.getDate("end_date");
            logger.info("dealCheckBillCenterMoreThanDate, billNo:{}, limitDate:{}, endDate:{}", new Object[]{billNo, limitDate, endDate});
            if (endDate.compareTo(limitDate) > 0) continue;
            HashMap<String, Set<String>> subErrorMsgMap = new HashMap<String, Set<String>>(8);
            billCenterInvoiceCommonService.dealAddErrorMsgMethod("billNo", DateUtils.format((Date)limitDate), subErrorMsgMap);
            errorMsgList.add(subErrorMsgMap);
            subList.add(object);
        }
        if (subList.size() > 0) {
            for (Object object : subList) {
                billCenterObject = (DynamicObject)object;
                billNo = billCenterObject.getString("billno");
                DynamicObject dynamicObject = billCenterInvoiceCommonService.dealCheckBillCenterDataMethod("billno", billNo, systemCode);
                Long pkId = dynamicObject.getLong("id");
                DeleteServiceHelper.delete((IDataEntityType)dynamicObject.getDataEntityType(), (Object[])new Object[]{pkId});
            }
            successMsgList.removeAll(subList);
        }
        logger.info("dealCheckBillCenterMoreThanDate\uff0c subList\u5927\u5c0f:{}, successMsgList\u5927\u5c0f:{}", (Object)subList.size(), (Object)successMsgList.size());
    }

    private DynamicObjectCollection dealRecentlyOrderDataMethod(DynamicObjectCollection dynamicObjectCollection, boolean isScanFlag, List<String> tipMsgList) {
        DynamicObjectCollection recentlyOrderCollection = new DynamicObjectCollection();
        if (dynamicObjectCollection == null || dynamicObjectCollection.size() == 0) {
            return recentlyOrderCollection;
        }
        Date nowDate = new Date();
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String billNo = dynamicObject.getString("billno");
            Date end_date = dynamicObject.getDate("end_date");
            if (end_date == null) {
                end_date = dynamicObject.getDate("createtime");
            }
            int disDays = DateUtils.timeDifferenceDay((Date)end_date, (Date)nowDate);
            logger.info("dealRecentlyOrderDataMethod, billNo:{}, disDays:{}", (Object)billNo, (Object)disDays);
            if (disDays > 31) {
                if (!isScanFlag) continue;
                String tipMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8ba2\u5355\u53f7:%1$s\uff0c\u5df2\u8d85\u8fc730\u5929\uff0c\u4e0d\u80fd\u591f\u81ea\u52a9\u5f00\u7968\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5b8c\u6210\u5f00\u7968\uff01", (String)"OperaDataImpl_20", (String)"imc-sim-service", (Object[])new Object[0]), billNo);
                tipMsgList.add(tipMsg);
            }
            recentlyOrderCollection.add((Object)dynamicObject);
        }
        logger.info("dealRecentlyOrderDataMethod, \u6ee1\u8db3\u60c5\u51b5\u7684\u6570\u636e\u91cf:{}", (Object)recentlyOrderCollection.size());
        return recentlyOrderCollection;
    }

    private void dealFormatBillErrorDataMethod(List<Object> successMsgList, List<Object> errorMsgList, List<BillVo> applyBillList) {
        if (successMsgList.size() > 0) {
            BillErrorVo billErrorVo = new BillErrorVo();
            billErrorVo.setSuccessNum(successMsgList.size());
            billErrorVo.setFailNum(0);
            applyBillList.add((BillVo)billErrorVo);
        }
        if (errorMsgList.size() > 0) {
            StringBuilder builder = new StringBuilder();
            for (Object object : errorMsgList) {
                Map errorMsgMap = (Map)object;
                StringBuilder stringBuilder = new StringBuilder();
                for (Map.Entry entryObject : errorMsgMap.entrySet()) {
                    String key = (String)entryObject.getKey();
                    Set subErrorMsgSet = (Set)entryObject.getValue();
                    Iterator iterator = subErrorMsgSet.iterator();
                    String errorMsg = "";
                    while (iterator.hasNext()) {
                        String value = (String)iterator.next();
                        if (StringUtils.isEmpty((CharSequence)errorMsg)) {
                            errorMsg = value;
                            continue;
                        }
                        errorMsg = errorMsg + "," + value;
                    }
                    String tipMsg = null;
                    if ("systemCode".equals(key)) {
                        tipMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\uff08%1$s\uff09\uff0c\u672a\u5339\u914d\u5916\u56f4\u7cfb\u7edf\u914d\u7f6e\u6570\u636e\uff01", (String)"OperaDataImpl_2", (String)"imc-sim-service", (Object[])new Object[0]), errorMsg);
                    } else if ("orgCode".equals(key)) {
                        tipMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4ea7\u54c1\u7f16\u7801\uff08%1$s\uff09\uff0c\u672a\u5339\u914d\u5230\u7ec4\u7ec7\u6620\u5c04\u5173\u7cfb\u914d\u7f6e\u6570\u636e\uff01", (String)"OperaDataImpl_3", (String)"imc-sim-service", (Object[])new Object[0]), errorMsg);
                    } else if ("taxRate".equals(key)) {
                        tipMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4ea7\u54c1\u7f16\u7801\uff08%1$s\uff09\uff0c\u672a\u5339\u914d\u4ea7\u54c1\u7684\u7a0e\u7387\u914d\u7f6e\u6570\u636e\uff01", (String)"OperaDataImpl_4", (String)"imc-sim-service", (Object[])new Object[0]), errorMsg);
                    } else if ("productCode".equals(key)) {
                        tipMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4ea7\u54c1\u7f16\u7801\uff08%1$s\uff09\uff0c\u672a\u5339\u914d\u5230\u5f00\u7968\u9879\u914d\u7f6e\u6570\u636e\uff01", (String)"OperaDataImpl_6", (String)"imc-sim-service", (Object[])new Object[0]), errorMsg);
                    } else if ("payCode".equals(key)) {
                        tipMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u652f\u4ed8\u7f16\u7801\uff08%1$s\uff09\uff0c\u672a\u5339\u914d\u5230\u652f\u4ed8\u65b9\u5f0f\u914d\u7f6e\u6570\u636e\uff01", (String)"OperaDataImpl_7", (String)"imc-sim-service", (Object[])new Object[0]), errorMsg);
                    } else if ("saleOrg".equals(key)) {
                        tipMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4ea7\u54c1\u7f16\u7801\uff08%1$s\uff09\uff0c\u672a\u5339\u914d\u5230\u4ee3\u552e\u7ec4\u7ec7\u914d\u7f6e\u6570\u636e\uff01", (String)"OperaDataImpl_8", (String)"imc-sim-service", (Object[])new Object[0]), errorMsg);
                    } else if ("disableCode".equals(key)) {
                        tipMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u652f\u4ed8\u7f16\u7801\uff08%1$s\uff09\uff0c\u5bf9\u5e94\u914d\u7f6e\u6570\u636e\u662f\u7981\u7528\u72b6\u6001\uff01", (String)"OperaDataImpl_9", (String)"imc-sim-service", (Object[])new Object[0]), errorMsg);
                    } else if ("approvalCode".equals(key)) {
                        tipMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u652f\u4ed8\u7f16\u7801\uff08%1$s\uff09\uff0c\u5bf9\u5e94\u914d\u7f6e\u6570\u636e\u662f\u672a\u5ba1\u6838\u72b6\u6001\uff01", (String)"OperaDataImpl_10", (String)"imc-sim-service", (Object[])new Object[0]), errorMsg);
                    } else if ("exceptionDataCode".equals(key)) {
                        tipMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u5355\u7f16\u53f7\uff08%1$s\uff09\uff0c\u660e\u7ec6\u9879\u603b\u989d\u4e0e\u652f\u4ed8\u9879\u603b\u989d\u4e0d\u76f8\u7b49\uff01", (String)"OperaDataImpl_11", (String)"imc-sim-service", (Object[])new Object[0]), errorMsg);
                    } else if ("itemType".equals(key)) {
                        tipMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4ea7\u54c1\u7f16\u7801\uff08%1$s\uff09\uff0c\u672a\u5339\u914d\u5230\u76f8\u5173\u8d26\u5355\u4e2d\u5fc3\u5206\u7c7b\u914d\u7f6e\uff01", (String)"OperaDataImpl_19", (String)"imc-sim-service", (Object[])new Object[0]), errorMsg);
                    } else if ("billNo".equals(key)) {
                        tipMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u65e5\u671f:%1$s\u524d\u7684\uff0c\u4e3a\u907f\u514d\u91cd\u590d\u5f00\u7968\uff0c\u4e0d\u5141\u8bb8\u62c9\u53d6\u6570\u636e\uff01", (String)"HeroGourmetSysDataImpl_1", (String)"imc-sim-service", (Object[])new Object[0]), errorMsg);
                    } else if ("dbUser".equals(key)) {
                        tipMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u5e93\u7528\u6237:%1$s\uff0c\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u6b64\u89c6\u56fe\uff01", (String)"OperaCommonLogicService_5", (String)"imc-sim-service", (Object[])new Object[0]), errorMsg);
                    } else if ("billPush".equals(key)) {
                        tipMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8ba2\u5355\u7f16\u53f7:%1$s\uff0c\u5df2\u4e0b\u63a8\u5f00\u7968\u7533\u8bf7\u5355\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u4e0b\u63a8\uff01", (String)"OperaCommonLogicService_7", (String)"imc-sim-service", (Object[])new Object[0]), errorMsg);
                    }
                    stringBuilder.append(tipMsg).append("\n");
                }
                builder.append((CharSequence)stringBuilder);
            }
            logger.info("\u9519\u8bef\u5185\u5bb9\u662f:{}", (Object)builder.toString());
            BillErrorVo billErrorVo = new BillErrorVo();
            billErrorVo.setErrorMsg(builder.toString());
            billErrorVo.setFailNum(errorMsgList.size());
            billErrorVo.setSuccessNum(0);
            applyBillList.add((BillVo)billErrorVo);
        }
    }

    private String getOpKeyMethod(String paramContent) {
        JSONObject jsonObject = JSONObject.parseObject((String)paramContent);
        if (jsonObject.containsKey((Object)"opKey")) {
            return jsonObject.getString("opKey");
        }
        return null;
    }

    private void dealSyncOperaDataByDBConnect(String systemCode, String paramContent, List<Object> successMsgList, List<Object> errorMsgList) {
        QFilter qFilter;
        logger.info("dealSyncOperaDataByDBConnect, systemCode:{}, paramContent:{}", (Object)systemCode, (Object)paramContent);
        BillCenterOrgMappingService orgMappingService = new BillCenterOrgMappingService();
        if ("Opera".equals(systemCode)) {
            List<String> systemCodeList = orgMappingService.getSystemCodeListMethod();
            qFilter = new QFilter("number", "in", systemCodeList);
        } else {
            qFilter = new QFilter("number", "=", (Object)systemCode);
        }
        DynamicObjectCollection dynamicObjectCollection = orgMappingService.loadSystemCfgDataByCondition(qFilter);
        if (dynamicObjectCollection == null || dynamicObjectCollection.size() == 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\uff1a%1$s\uff0c\u672a\u5339\u914d\u76f8\u5173\u7684\u7cfb\u7edf\u914d\u7f6e\u6570\u636e\uff01", (String)"OperaDataImpl_0", (String)"imc-sim-service", (Object[])new Object[0]), systemCode));
        }
        logger.info("dealSyncOperaDataByDBConnect, \u8bfb\u53d6\u7684Opera\u6570\u636e\u6e90\u5171\u6709\uff1a{}", (Object)dynamicObjectCollection.size());
        OperaCommonLogicService operaCommonLogicService = new OperaCommonLogicService();
        JSONObject jsonObject = JSONObject.parseObject((String)paramContent);
        String billNo = jsonObject.getString("billNo");
        String phoneNumber = jsonObject.getString("phoneNumber");
        String blockCode = jsonObject.getString("blockCode");
        logger.info("dealSyncOperaDataByDBConnect, billNo:{}, phoneNumber:{}, blockCode:{}", new Object[]{billNo, phoneNumber, blockCode});
        String[] paramArray = new String[]{billNo, phoneNumber, blockCode, null, null};
        for (DynamicObject frontSystemObject : dynamicObjectCollection) {
            operaCommonLogicService.dealCreateDBConnMethod(frontSystemObject, paramArray, successMsgList, errorMsgList);
        }
        String billNoParam = ResManager.loadKDString((String)"\u624b\u5de5\u540c\u6b65\u8d26\u5355\u6570\u636e\u2014\u2014\u6563\u5ba2\u56e2", (String)"OperaDataImpl_12", (String)"imc-sim-service", (Object[])new Object[0]);
        operaCommonLogicService.dealSaveInterfaceLogMethod(systemCode, paramArray, billNoParam, successMsgList.size(), errorMsgList.size());
    }

    private DynamicObjectCollection doGetDataService(String paramContent, String systemCode) {
        JSONObject jsonObject = JSONObject.parseObject((String)paramContent);
        String billNo = jsonObject.getString("billNo");
        String phoneNumber = jsonObject.getString("phoneNumber");
        QFilter qFilter = null;
        if (StringUtils.isNotEmpty((CharSequence)billNo) && StringUtils.isNotEmpty((CharSequence)phoneNumber)) {
            qFilter = new QFilter("billno", "=", (Object)billNo).and("user_phone", "=", (Object)phoneNumber);
        } else if (StringUtils.isNotEmpty((CharSequence)billNo)) {
            qFilter = new QFilter("billno", "=", (Object)billNo);
        } else if (StringUtils.isNotEmpty((CharSequence)phoneNumber)) {
            qFilter = new QFilter("user_phone", "=", (Object)phoneNumber);
        }
        if (qFilter == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u67e5\u8be2\u6761\u4ef6\u53c2\u6570\u4e0d\u5408\u6cd5\uff01", (String)"OperaDataImpl_5", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        if ("Opera".equals(systemCode)) {
            BillCenterOrgMappingService billCenterOrgMappingService = new BillCenterOrgMappingService();
            List<String> systemCodeList = billCenterOrgMappingService.getSystemCodeListMethod();
            qFilter = qFilter.and("system_code", "in", systemCodeList);
        } else {
            qFilter = qFilter.and("system_code", "=", (Object)systemCode);
        }
        DynamicObjectCollection receiveBillCollection = new DynamicObjectCollection();
        DynamicObjectCollection dynamicObjectCollection = BillCenterInvoiceCoreService.loadDynamicObjectCollection((QFilter)qFilter);
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            BigDecimal totalAmount;
            String push_status = dynamicObject.getString("pushstatus");
            if ("1".equals(push_status) || "2".equals(push_status) || (totalAmount = dynamicObject.getBigDecimal("total_amount")) == null || totalAmount.compareTo(BigDecimal.ZERO) == 0) continue;
            receiveBillCollection.add((Object)dynamicObject);
        }
        return receiveBillCollection;
    }

    @Override
    public void dealUpdateOpenInvoiceStatus(DynamicObject dynamicObject, InvoiceVo invoiceVo) {
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        if (this.invociceFailCallBack(dynamicObject)) {
            return;
        }
        String billNo = invoiceVo.getBillNo();
        String systemCode = invoiceVo.getSystemSource();
        billCenterInvoiceCommonService.dealStaticsCallbackMethod(billNo, systemCode, 0, "-1");
    }

    @Override
    public void dealPushCallBackStatusToFrontSystem(JSONObject paramObject) {
        BillCenterInvoiceLogService billCenterInvoiceLogService = new BillCenterInvoiceLogService();
        if (paramObject.containsKey((Object)"approvalResult")) {
            billCenterInvoiceLogService.dealNoticeApprovalRejectMethod(paramObject);
        } else if (paramObject.containsKey((Object)"approvalProcess")) {
            billCenterInvoiceLogService.dealNoticeApprovalProcessMethod(paramObject);
        } else if (paramObject.containsKey((Object)"approvalSuccess")) {
            billCenterInvoiceLogService.dealNoticeApprovalSuccessMethod(paramObject);
        } else {
            this.dealNoticeCallBackStatusToFrontSystem(paramObject);
        }
    }

    private void dealNoticeCallBackStatusToFrontSystem(JSONObject paramObject) {
        String billNo = paramObject.getString("billNo");
        String systemCode = paramObject.getString("systemCode");
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        billCenterInvoiceCommonService.dealStaticsCallbackMethod(billNo, systemCode, 0, "-1");
    }

    @Override
    public String dealGetQrCodeMethod(JSONObject paramObject) {
        String baseUrl;
        String billNo = paramObject.getString("billNo");
        String systemCode = paramObject.getString("systemCode");
        logger.info("OperaDataImpl, dealGetQrCodeMethod, billNo:{}, systemCode:{}", (Object)billNo, (Object)systemCode);
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        DynamicObject billCenterDO = billCenterInvoiceCommonService.dealCheckBillCenterDataMethod("billno", billNo, systemCode);
        if (billCenterDO == null) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8ba2\u5355\u53f7:%1$s\uff0c\u8d26\u5355\u4e2d\u5fc3\u7684\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01", (String)"OperaDataImpl_13", (String)"imc-sim-service", (Object[])new Object[0]), billNo);
            throw new KDBizException(errorMsg);
        }
        BigDecimal remainAmount = billCenterDO.getBigDecimal("remain_amount");
        if (remainAmount == null || remainAmount.compareTo(BigDecimal.ZERO) == 0) {
            String errorMsg = ResManager.loadKDString((String)"\u8ba2\u5355\u5269\u4f59\u53ef\u5f00\u7968\u91d1\u989d\u5c0f\u4e8e\u7b49\u4e8e0\u7684\u60c5\u51b5\uff0c\u4e0d\u80fd\u591f\u751f\u6210\u5c0f\u7968\u7801!", (String)"OperaDataImpl_14", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        String ddh = billCenterDO.getString("billno");
        OperaCommonLogicService operaCommonLogicService = new OperaCommonLogicService();
        boolean isEqualFlag = operaCommonLogicService.dealCheckItemPaymentAmountMethod(billCenterDO);
        if (!isEqualFlag) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8ba2\u5355\u7f16\u53f7:%1$s\uff0c\u5bf9\u5e94\u7684\u6d88\u8d39\u9879\u603b\u91d1\u989d\u4e0e\u652f\u4ed8\u9879\u603b\u91d1\u989d\u4e0d\u76f8\u7b49\uff0c\u4e0d\u652f\u6301\u81ea\u52a9\u5f00\u7968\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u624b\u5de5\u5f00\u7968\uff01", (String)"OperaDataImpl_15", (String)"imc-sim-service", (Object[])new Object[0]), ddh);
            throw new KDBizException(errorMsg);
        }
        boolean canOpenFlag = operaCommonLogicService.dealComparedAmountIsEqualMethod(billCenterDO);
        logger.info("BillCenterPrintPlugin, ddh:{}, canOpenFlag:{}", (Object)ddh, (Object)canOpenFlag);
        if (!canOpenFlag) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8ba2\u5355\u7f16\u53f7:%1$s\u4e2d\u660e\u7ec6\u9879\u603b\u989d\u548c\u652f\u4ed8\u9879\u603b\u989d\u4e0d\u7b49\uff0c\u4e0d\u652f\u6301\u81ea\u52a9\u5f00\u7968\uff0c\u8bf7\u624b\u5de5\u5904\u7406\u5f00\u7968\uff01", (String)"OperaDataImpl_16", (String)"imc-sim-service", (Object[])new Object[0]), ddh);
            throw new KDBizException(errorMsg);
        }
        logger.info("\u5141\u8bb8\u6253\u5370\u4e8c\u7ef4\u7801\u7684\u529f\u80fd\uff01");
        logger.info("\u8d26\u5355\u4e2d\u5fc3\u6253\u5370\u7684\u539f\u59cb\u8ba2\u5355\u5185\u5bb9:{}", (Object)ddh);
        String pushStatus = billCenterDO.getString("pushstatus");
        BigDecimal invoiceAmount = billCenterDO.getBigDecimal("invoice_amount");
        if ("1".equals(pushStatus) && remainAmount.compareTo(BigDecimal.ZERO) > 0 && invoiceAmount.compareTo(BigDecimal.ZERO) > 0) {
            String errorMsg = ResManager.loadKDString((String)"\u6b64\u8ba2\u5355\u5df2\u90e8\u5206\u5f00\u7968\uff0c\u4e0d\u80fd\u591f\u751f\u6210\u5c0f\u7968\u7801\uff01", (String)"OperaDataImpl_17", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        ddh = Base64Util.encode((byte[])ddh.getBytes(StandardCharsets.UTF_8));
        logger.info("\u8d26\u5355\u4e2d\u5fc3\u6253\u5370\u7684\u52a0\u5bc6\u8ba2\u5355\u5185\u5bb9:{}", (Object)ddh);
        try {
            baseUrl = (String)ImcConfigUtil.getValue((String)"bdm_ismc_config_move").get("bdm_ismc_config_move_cloud_url");
        }
        catch (Throwable ignore) {
            baseUrl = RequestContext.get().getClientFullContextPath();
        }
        if (StringUtils.isEmpty((CharSequence)baseUrl)) {
            String errorMsg = ResManager.loadKDString((String)"\u6253\u5370\u5c0f\u7968\u7801\u7684\u524d\u7f00\u5730\u5740\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u6253\u5370\uff01", (String)"BillCenterPrint_0", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        baseUrl = baseUrl.substring(0, baseUrl.lastIndexOf("/"));
        return String.format("%s?businessScene=5&billSource=billCenter&sysSource=%s&ddh=%s", baseUrl, systemCode, ddh);
    }
}

