/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.billcenter.workhotel.event;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDBizException;
import kd.bos.form.container.Tab;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.imc.bdm.common.constant.CheckPhoneEnum;
import kd.imc.bdm.common.dto.BillRelationDTO;
import kd.imc.bdm.common.dto.merge.MergeRequestDTO;
import kd.imc.bdm.common.dto.merge.MergeResponseDTO;
import kd.imc.bdm.common.dto.split.SplitRequestDTO;
import kd.imc.bdm.common.dto.split.SplitResponseDTO;
import kd.imc.bdm.common.helper.cache.MsgAuthSettingCacheHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.service.OpenInvoiceService;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.billcenter.workhotel.dto.BillCenterHotelProcessDTO;
import kd.imc.sim.common.service.InvoiceCheckService;
import kd.imc.sim.formplugin.bill.originalbill.workbench.event.AbstractBillWorkbenchCustomEvent;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillInvoiceRelationHelper;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillMergeHelper;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillSplitHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class BillCenterProcessCustomEvent
extends AbstractBillWorkbenchCustomEvent {
    @Override
    public void customEvent(AbstractFormPlugin that, CustomEventArgs e) {
        String event = e.getEventName();
        String param = e.getEventArgs();
        switch (event) {
            case "process/searchTitle": {
                JSONObject searchJson = JSONObject.parseObject((String)param);
                if (searchJson == null || !StringUtils.isNotBlank((CharSequence)searchJson.getString("buyername"))) break;
                HashMap<String, Object> params = new HashMap<String, Object>(4);
                params.put("company", new OpenInvoiceService().queryCompany(searchJson.getString("buyername")));
                BillCenterProcessCustomEvent.updateCustomControl(that, params, "process/searchTitle");
                break;
            }
            case "process/openTitlePage": {
                JSONObject json = JSONObject.parseObject((String)param);
                String orgStr = BillCenterProcessCustomEvent.getPageCacheVal(that, "currentOrg");
                QFilter qFilter = new QFilter("org", "=", (Object)Long.parseLong(orgStr));
                if (json != null && StringUtils.isNotBlank((CharSequence)json.getString("buyername"))) {
                    qFilter.and("buyername", "like", (Object)('%' + json.getString("buyername") + '%'));
                }
                BillCenterProcessCustomEvent.putPageCache(that, "process/openTitlePage", param);
                ViewUtil.openListPage((AbstractFormPlugin)that, (QFilter)qFilter, (String)"sim_scan_invoice", (String)"process/openTitlePage");
                break;
            }
            case "process/nextStep": {
                this.nextStep(that, param);
            }
        }
    }

    public void nextStep(AbstractFormPlugin that, String param) {
        List process = JSONArray.parseArray((String)param, BillCenterHotelProcessDTO.class);
        if (CollectionUtils.isEmpty((Collection)process)) {
            that.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillCenterProcessCustomEvent_0", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        PushArgs args = new PushArgs();
        args.setSourceEntityNumber("sim_isomerism_bill_data");
        args.setTargetEntityNumber("sim_original_bill");
        args.setRuleId("1859565732606768128");
        List pkList = JSONArray.parseArray((String)BillCenterProcessCustomEvent.getPageCacheVal(that, "pks"), Long.class);
        HashMap<Object, Set> billCenter2BillMap = new HashMap<Object, Set>(pkList.size());
        ArrayList originalBills = new ArrayList(process.size());
        for (Object billCenterHotelProcessDTO : process) {
            try {
                this.checkParams(that, (BillCenterHotelProcessDTO)billCenterHotelProcessDTO);
            }
            catch (KDBizException e) {
                that.getView().showTipNotification(e.getMessage());
                return;
            }
            args.addCustomParam("bills", JSONObject.toJSONString((Object)billCenterHotelProcessDTO));
            Set processIdSet = billCenterHotelProcessDTO.getItems().stream().map(item -> Long.parseLong(item.getSid())).collect(Collectors.toSet());
            List<Long> filterPks = pkList.stream().filter(processIdSet::contains).collect(Collectors.toList());
            ArrayList selectedRows = new ArrayList(8);
            filterPks.forEach(pk -> selectedRows.add(new ListSelectedRow(pk)));
            args.setSelectedRows(selectedRows);
            ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)args);
            if (!pushResult.isSuccess()) {
                List billReports = pushResult.getBillReports();
                throw new KDBizException("push fail:" + (CollectionUtils.isEmpty((Collection)billReports) ? pushResult.getMessage() : billReports.stream().map(SourceBillReport::getFailMessage).collect(Collectors.joining(","))));
            }
            MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)"sim_original_bill");
            List pushList = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
            List pushIds = pushList.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            for (Long pk2 : filterPks) {
                Set set = billCenter2BillMap.computeIfAbsent(pk2, k -> new HashSet());
                set.addAll(pushIds);
            }
            originalBills.addAll(pushList);
        }
        HashMap<String, List> billMaps = new HashMap<String, List>();
        for (DynamicObject originalBill : originalBills) {
            String invoiceType = originalBill.getString("invoicetype");
            String mapKey = InvoiceUtils.isAllEInvoice((Object)invoiceType) ? invoiceType : invoiceType + "\u25cf\u25c6\u25a0" + originalBill.getString("jqbh");
            List bills = billMaps.computeIfAbsent(mapKey, k -> new ArrayList());
            bills.add(originalBill);
            DynamicObjectCollection items = originalBill.getDynamicObjectCollection("sim_original_bill_item");
            for (DynamicObject item2 : items) {
                item2.set("id", (Object)DBServiceHelper.genGlobalLongId());
            }
        }
        ArrayList invoices = new ArrayList(originalBills.size());
        ArrayList mergeRelationList = new ArrayList(originalBills.size());
        ArrayList relationList = new ArrayList(originalBills.size());
        for (List bills : billMaps.values()) {
            MergeRequestDTO request = new MergeRequestDTO.Builder().bills(bills.toArray(new DynamicObject[0])).mergeBill(false).mergeBillDetail(true).setJqbh(((DynamicObject)bills.get(0)).getString("jqbh")).build();
            MergeResponseDTO mergeResponseDTO = new BillMergeHelper().mergeBill(request);
            mergeRelationList.addAll(mergeResponseDTO.getRelations());
            SplitRequestDTO splitRequest = new SplitRequestDTO();
            for (Object mergeBill : mergeResponseDTO.getBills()) {
                splitRequest.setBill((DynamicObject)mergeBill);
                splitRequest.setBillNoMap(mergeResponseDTO.getBillNoMap());
                SplitResponseDTO splitResponseDTO = BillSplitHelper.splitBill((SplitRequestDTO)splitRequest, (String)mergeBill.getString("jqbh"));
                if (splitResponseDTO.getInvoices().size() > 1) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u91d1\u989d\u8d85\u8fc7\u8bbe\u5907\u9650\u5236", (String)"BillCenterProcessCustomEvent_7", (String)"imc-sim-service", (Object[])new Object[0]));
                }
                invoices.addAll(splitResponseDTO.getInvoices());
                relationList.addAll(splitResponseDTO.getRelations());
            }
        }
        MainEntityType billDtType = EntityMetadataCache.getDataEntityType((String)"sim_original_bill");
        BillCenterProcessCustomEvent.putPageCache(that, "sim_original_bill", DynamicObjectSerializeUtil.serialize((Object[])originalBills.toArray(), (DynamicObjectType)billDtType));
        MainEntityType invoiceDtType = EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice");
        BillCenterProcessCustomEvent.putPageCache(that, "sim_vatinvoice", DynamicObjectSerializeUtil.serialize((Object[])invoices.toArray(), (DynamicObjectType)invoiceDtType));
        List relations = BillInvoiceRelationHelper.mergeRelation(mergeRelationList, relationList);
        BillCenterProcessCustomEvent.putPageCache(that, "sim_bill_inv_relation", JSONArray.toJSONString((Object)relations));
        HashMap<Object, Map> invoiceMaps = new HashMap<Object, Map>(invoices.size());
        for (DynamicObject invoice : invoices) {
            invoiceMaps.put(invoice.getPkValue(), DynamicObjectUtil.dynamicObjectToMap((DynamicObject)invoice, (boolean)true));
        }
        HashMap treatmentInvoiceList = new HashMap(pkList.size());
        Set entries = billCenter2BillMap.entrySet();
        for (Map.Entry entry : entries) {
            Set originalBillPk = (Set)entry.getValue();
            Set<Long> invoiceIds = relations.stream().filter(relation -> originalBillPk.contains(relation.getsBillId())).map(BillRelationDTO::gettBillId).collect(Collectors.toSet());
            ArrayList invoiceList = new ArrayList(invoiceIds.size());
            invoiceIds.forEach(invoiceId -> invoiceList.add(invoiceMaps.get(invoiceId)));
            treatmentInvoiceList.put(entry.getKey().toString(), invoiceList);
        }
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("treatmentInvoiceList", treatmentInvoiceList);
        params.put("curIndex", 1);
        BillCenterProcessCustomEvent.updateCustomControl(that, params, "setCurrentDisplay");
        Tab tab = (Tab)that.getView().getControl("tabap");
        tab.activeTab("preview");
    }

    private void checkParams(AbstractFormPlugin that, BillCenterHotelProcessDTO process) {
        if (StringUtils.isBlank((CharSequence)process.getInvoicetype())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillCenterProcessCustomEvent_1", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        if (!InvoiceUtils.isAllEInvoice((Object)process.getInvoicetype()) && StringUtils.isBlank((CharSequence)process.getJqbh())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bbe\u5907\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillCenterProcessCustomEvent_2", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)process.getBuyername())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d2d\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillCenterProcessCustomEvent_3", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        if (InvoiceUtils.isSpecialInvoice((String)process.getInvoicetype())) {
            if (StringUtils.isBlank((CharSequence)process.getBuyertaxno())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8d2d\u65b9\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillCenterProcessCustomEvent_4", (String)"imc-sim-service", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)process.getBuyeraddr())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8d2d\u65b9\u5730\u5740\u53ca\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillCenterProcessCustomEvent_5", (String)"imc-sim-service", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)process.getBuyerbank())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8d2d\u65b9\u5f00\u6237\u884c\u53ca\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillCenterProcessCustomEvent_6", (String)"imc-sim-service", (Object[])new Object[0]));
            }
        }
        if (InvoiceUtils.isEtcInvoice((String)process.getInvoicetype())) {
            String checkPhone = MsgAuthSettingCacheHelper.getCacheCheckPhoneByOrgId((long)Long.parseLong(BillCenterProcessCustomEvent.getPageCacheVal(that, "currentOrg")));
            if (CheckPhoneEnum.DEFAULT.getCode().equals(checkPhone)) {
                if (StringUtils.isBlank((CharSequence)process.getBuyerphone()) && StringUtils.isBlank((CharSequence)process.getBuyeremail())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8d2d\u4e70\u65b9\u90ae\u7bb1\u6216\u624b\u673a\u53f7", (String)"InvoiceCheckService_55", (String)"imc-sim-common", (Object[])new Object[0]));
                }
                InvoiceCheckService.checkMobile((String)process.getBuyerphone());
            }
            this.checkBuyerEmailMethod(process.getBuyeremail());
        }
        if (StringUtils.isBlank((CharSequence)process.getBuyerproperty())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d2d\u65b9\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillCenterProcessCustomEvent_8", (String)"imc-sim-service", (Object[])new Object[0]));
        }
    }

    private void checkBuyerEmailMethod(String buyerEmail) {
        if (StringUtils.isEmpty((CharSequence)buyerEmail)) {
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)buyerEmail) && GBKUtils.getGBKLength((String)buyerEmail) > 300) {
            String GBK_LEN_ERR_MSG_TEMPLATE = ResManager.loadKDString((String)"%1$s\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7%2$s\uff08\u4e00\u4e2a\u6c49\u5b572\u4e2a\u5b57\u7b26\u957f\u5ea6\uff09", (String)"InvoiceCheckService_0", (String)"imc-sim-common", (Object[])new Object[0]);
            throw new MsgException(String.format(GBK_LEN_ERR_MSG_TEMPLATE, "\u8d2d\u4e70\u65b9\u90ae\u7bb1", 300));
        }
        String[] emailList = buyerEmail.split(";");
        if (emailList.length > 10) {
            throw new MsgException(ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9\u90ae\u7bb1\u4e0d\u80fd\u8d85\u8fc710\u4e2a", (String)"InvoiceCheckService_5", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        String emailRegex = "/^([a-zA-Z0-9._%+-]+)@([a-zA-Z0-9-]+\\.[a-zA-Z]{2,})(\\.[a-zA-Z]{2,})?$/";
        for (String subEmail : emailList) {
            if (!Pattern.matches(emailRegex, subEmail)) continue;
            throw new MsgException(ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"InvoiceCheckService_6", (String)"imc-sim-common", (Object[])new Object[0]));
        }
    }
}

