/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.CheckPhoneEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.table.BdmIssueInvSettingConstant;
import kd.imc.bdm.common.constant.table.RedReasonEnum;
import kd.imc.bdm.common.dto.BillCheckProcessDto;
import kd.imc.bdm.common.dto.BillDeductionItemVo;
import kd.imc.bdm.common.dto.BillDetailVo;
import kd.imc.bdm.common.dto.BillFreightItemVo;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.dto.ExtraInfoItemVo;
import kd.imc.bdm.common.dto.SaleAddrAndPayeeDTO;
import kd.imc.bdm.common.dto.allelespecial.BillBuildInfoVo;
import kd.imc.bdm.common.dto.allelespecial.BillEstateLeaseInfoVo;
import kd.imc.bdm.common.dto.allelespecial.BillEstateSaleInfoVo;
import kd.imc.bdm.common.dto.allelespecial.BillEstateSaleItemVo;
import kd.imc.bdm.common.enums.AllEPrivilegeTypeEnum;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.helper.AddressSplitHelper;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.InvoiceValidHelper;
import kd.imc.bdm.common.helper.IssueInvSettingHelper;
import kd.imc.bdm.common.helper.ReducedHelper;
import kd.imc.bdm.common.helper.cache.MsgAuthSettingCacheHelper;
import kd.imc.bdm.common.helper.cache.TaxClassCodeCheckHelper;
import kd.imc.bdm.common.helper.invoice.ReduceOnePoint5Helper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.model.BaseInvoice;
import kd.imc.bdm.common.model.BaseInvoiceItem;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.CallbackHelperUtil;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.RegexUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.sim.common.constant.InvoiceConstant;
import kd.imc.sim.common.constant.OpenApiInterfaceCodeEnum;
import kd.imc.sim.common.constant.ValidTypeEnum;
import kd.imc.sim.common.helper.BillPushSetValueHelper;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.helper.issueinvoice.UnitPriceHelper;
import kd.imc.sim.common.model.invoice.CoalTypeCodeEnum;
import kd.imc.sim.common.model.invoice.InvoiceSpecialType;
import kd.imc.sim.common.model.invoice.TaxedTypeEnum;
import kd.imc.sim.common.model.invoice.ZzstsglEnum;
import kd.imc.sim.common.service.CheckBillService;
import kd.imc.sim.common.service.InvoiceCheckService;
import kd.imc.sim.common.utils.AllEleLqAddressSplitUtil;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.common.utils.TaxCalcUtil;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.bill.originalbill.control.InvoiceOriginalFormControl;
import kd.imc.sim.formplugin.match.BillMatchHelper;
import kd.imc.sim.formplugin.match.ConditionMatchHelper;
import kd.sdk.annotation.SdkDeprecated;
import org.apache.commons.lang3.tuple.Pair;

public class BillValidaterHelper {
    private static final Log LOGGER = LogFactory.getLog(BillValidaterHelper.class);
    private static final String billNoReg = "^[0-9a-zA-Z_\\-]+$";

    public static ApiResult validAllESpecial(BillVo bill, boolean isIssueProcess) {
        BaseInvoice baseInvoice;
        String simpleaddress;
        List billDetailList;
        if (!InvoiceUtils.isAllEInvoice((Object)bill.getInvoiceType()) && !AllEleAuthHelper.isElePaper((Object)bill.getIsElePaper())) {
            if (InvoiceSpecialType.allEleSpecialType((String)bill.getSpecialType()) && !"02".equals(bill.getSpecialType())) {
                return ResponseVo.fail((String)ErrorType.FAIL.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5f53\u524d\u53d1\u7968\u79cd\u7c7b\u4e3a\u3010%1$s\u3011,\u4e0d\u652f\u6301\u6570\u7535\u7684\u7279\u6b8a\u7968\u79cd\u3010%2$s\u3011", (String)"BillValidaterHelper_0", (String)"imc-sim-service", (Object[])new Object[0]), InvoiceType.getDescription((String)bill.getInvoiceType()), InvoiceSpecialType.InvoiceSpecialTypeEnum.getDescriptionByCode((String)bill.getSpecialType())));
            }
            return ResponseVo.success((String)"");
        }
        if (TaxUtils.isPurchaseInvoice((String)bill.getSpecialType())) {
            if (!InvoiceType.ALL_E_NORMAL.getTypeCode().equals(bill.getInvoiceType())) {
                return ResponseVo.fail((String)ErrorType.FAIL.getCode(), (String)String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), bill.getBillNo(), ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b\u4e0d\u652f\u6301\u6570\u7535\u519c\u4ea7\u54c1\u6536\u8d2d\u53d1\u7968", (String)"BillValidaterHelper_128", (String)"imc-sim-service", (Object[])new Object[0])));
            }
            return ResponseVo.success((String)"");
        }
        if (!InvoiceSpecialType.allEleSpecialType((String)bill.getSpecialType())) {
            return ResponseVo.success((String)"");
        }
        if ("3".equals(bill.getTaxationStyle()) && StringUtils.isNotEmpty((CharSequence)bill.getSpecialType()) && !InvoiceSpecialType.InvoiceSpecialTypeEnum.ESTATE_LEASE.getCode().equals(bill.getSpecialType()) && !"00".equals(bill.getSpecialType())) {
            return ResponseVo.fail((String)ErrorType.FAIL.getCode(), (String)String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), bill.getBillNo(), ResManager.loadKDString((String)"\u7279\u6b8a\u7968\u79cd\u53ea\u6709\u6570\u7535\u4e0d\u52a8\u4ea7\u7ecf\u8425\u79df\u8d41\u670d\u52a1\u652f\u6301\u51cf\u6309\u5f81\u7a0e", (String)"BillValidaterHelper_127", (String)"imc-sim-service", (Object[])new Object[0])));
        }
        if ("E03".equals(bill.getSpecialType()) || "E06".equals(bill.getSpecialType()) || "E05".equals(bill.getSpecialType())) {
            BillValidaterHelper.supplementSpecialIndustryInfo(bill);
        }
        if (isIssueProcess && "E03".equals(bill.getSpecialType()) && bill.getBuildInfo() == null) {
            return ResponseVo.fail((String)ErrorType.FAIL.getCode(), (String)String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), bill.getBillNo(), ResManager.loadKDString((String)"\u5efa\u7b51\u670d\u52a1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillValidaterHelper_1", (String)"imc-sim-service", (Object[])new Object[0])));
        }
        if (isIssueProcess && "E04".equals(bill.getSpecialType()) && bill.getFreightItems().size() == 0) {
            return ResponseVo.fail((String)ErrorType.FAIL.getCode(), (String)String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), bill.getBillNo(), ResManager.loadKDString((String)"\u8d27\u7269\u8fd0\u8f93\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillValidaterHelper_4", (String)"imc-sim-service", (Object[])new Object[0])));
        }
        if ("E12".equals(bill.getSpecialType())) {
            if (!InvoiceType.ALL_E_NORMAL.getTypeCode().equals(bill.getInvoiceType())) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%s\u7684\u53d1\u7968\u7c7b\u578b\u4e0d\u652f\u6301\u6570\u7535\u519c\u4ea7\u54c1\u6536\u8d2d\u53d1\u7968", (String)"BillValidaterHelper_140", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
            }
            List details = bill.getBillDetail();
            for (int i = 0; i < details.size(); ++i) {
                String privilegeContent = ((BillDetailVo)details.get(i)).getPrivilegeContent();
                int privilegeFlag = ((BillDetailVo)details.get(i)).getPrivilegeFlag();
                String taxRate = ((BillDetailVo)details.get(0)).getTaxRate();
                BigDecimal taxRateDecimalValue = BigDecimal.TEN;
                try {
                    taxRateDecimalValue = new BigDecimal(taxRate);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (privilegeFlag == 1 && "\u514d\u7a0e".equals(privilegeContent) && taxRateDecimalValue.compareTo(BigDecimal.ZERO) == 0) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\u7b2c%2$s\u884c\u660e\u7ec6\u660e\u7ec6\u7a0e\u7387\u5fc5\u987b\u4e3a\uff1a0,\u662f\u5426\u4eab\u53d7\u4f18\u60e0\u653f\u7b56\u6807\u8bc6\u4e3a\uff1a\u4eab\u53d7\uff0c\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\u4e3a\uff1a\u514d\u7a0e\uff08\u81ea\u4ea7\u519c\u4ea7\u54c1\u9500\u552e\u53d1\u7968\u660e\u7ec6\u7a0e\u7387\u8981\u6c42\u5fc5\u987b\u4e3a\u514d\u7a0e\uff09", (String)"BillValidaterHelper_141", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), i + 1));
            }
        }
        if ("E09".equals(bill.getSpecialType())) {
            billDetailList = bill.getBillDetail();
            int count = BillValidaterHelper.countItemNumMethod(null, billDetailList);
            if (count > 1) {
                String errorMsg = ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u53ea\u652f\u6301\u4e00\u884c\u5546\u54c1\u660e\u7ec6", (String)"BillValidaterHelper_129", (String)"imc-sim-service", (Object[])new Object[0]);
                return ResponseVo.fail((String)ErrorType.FAIL.getCode(), (String)String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), bill.getBillNo(), errorMsg));
            }
        } else if ("E07".equals(bill.getSpecialType())) {
            billDetailList = bill.getBillDetail();
            for (BillDetailVo billDetailVo : billDetailList) {
                String unit = billDetailVo.getUnits();
                int lineProperty = billDetailVo.getLineProperty();
                if (2 != lineProperty || "\u8f86".equals(unit)) continue;
                String errorMsg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%s,\u5355\u4f4d\u680f\u5fc5\u987b\u4e3a:\u8f86", (String)"BillValidaterHelper_124", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo());
                throw new MsgException(errorMsg);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(simpleaddress = (baseInvoice = BillValidaterHelper.convertBillVo2BaseInvoice(bill)).getSimpleaddress()))) {
            DynamicObject adminDivision = BigDecimalUtil.isNumber((String)simpleaddress) ? BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(simpleaddress), (String)"bdm_admindivision") : BusinessDataServiceHelper.loadSingleFromCache((String)"bdm_admindivision", (QFilter[])new QFilter("name", "=", (Object)simpleaddress).toArray());
            if (adminDivision == null) {
                return ResponseVo.fail((String)ErrorType.FAIL.getCode(), (String)String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), bill.getBillNo(), String.format(ResManager.loadKDString((String)"%s\u4e0d\u6b63\u786e", (String)"BillValidaterHelper_5", (String)"imc-sim-service", (Object[])new Object[0]), "E03".equals(bill.getSpecialType()) ? ResManager.loadKDString((String)"\u5efa\u7b51\u670d\u52a1\u53d1\u751f\u5730", (String)"BillValidaterHelper_6", (String)"imc-sim-service", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0d\u52a8\u4ea7\u5730\u5740", (String)"BillValidaterHelper_7", (String)"imc-sim-service", (Object[])new Object[0]))));
            }
            baseInvoice.setSimpleaddress(adminDivision.getString("name"));
            if ("E03".equals(bill.getSpecialType())) {
                bill.getBuildInfo().setSimpleAddress(adminDivision.getPkValue().toString());
            }
            if ("E06".equals(bill.getSpecialType())) {
                bill.getEstateLeaseInfo().setSimpleAddress(adminDivision.getPkValue().toString());
            }
            if ("E05".equals(bill.getSpecialType())) {
                bill.getEstateSaleInfo().setSimpleAddress(adminDivision.getPkValue().toString());
            }
        }
        try {
            if (isIssueProcess) {
                InvoiceCheckService.checkEleSpecialType((BaseInvoice)baseInvoice);
            }
        }
        catch (MsgException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return ResponseVo.fail((String)ErrorType.FAIL.getCode(), (String)e.getErrorMsg());
        }
        return ResponseVo.success((String)"");
    }

    @SdkDeprecated
    public static int countItemNumMethod(DynamicObjectCollection itemObjectCollection, List<BillDetailVo> billDetailList) {
        int count = 0;
        if (itemObjectCollection != null && !itemObjectCollection.isEmpty()) {
            for (DynamicObject itemObject : itemObjectCollection) {
                String rowtype = itemObject.getString("rowtype");
                if (!"2".equals(rowtype)) continue;
                ++count;
            }
        }
        if (billDetailList != null && !billDetailList.isEmpty()) {
            for (BillDetailVo billDetailVo : billDetailList) {
                int lineProperty = billDetailVo.getLineProperty();
                if (lineProperty != 2) continue;
                ++count;
            }
        }
        return count;
    }

    public static BillVo supplementSpecialIndustryInfo(BillVo bill) {
        int i;
        DynamicObject matchedDynamicObject;
        DynamicObject dynamicObject = null;
        if ("E03".equals(bill.getSpecialType())) {
            if (StringUtils.isNotBlank((CharSequence)bill.getBuildInfo().getSpecialIndustryNumber())) {
                dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bdm_estatelease_info", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_estatelease_info"), (QFilter[])new QFilter("number", "=", (Object)bill.getBuildInfo().getSpecialIndustryNumber()).toArray());
            } else if (bill.isFromBillPush() && BillValidaterHelper.isEstateInfoEmpty("E03", bill)) {
                dynamicObject = BillValidaterHelper.matchBuilding(bill, "buildInfo");
            }
            if (dynamicObject != null && dynamicObject.get("estatetype").equals("buildInfo") && BillValidaterHelper.isAllBlank(new String[]{bill.getBuildInfo().getBuildingName(), bill.getBuildInfo().getCrossCitySign(), bill.getBuildInfo().getDetailAddress(), bill.getBuildInfo().getLandTaxNo(), bill.getBuildInfo().getSimpleAddress()})) {
                bill.getBuildInfo().setSimpleAddress(((DynamicObject)dynamicObject.get("simpleaddress")).getString("name"));
                bill.getBuildInfo().setBuildingName(dynamicObject.getString("buildingname"));
                bill.getBuildInfo().setCrossCitySign(dynamicObject.getString("crosscitysign"));
                bill.getBuildInfo().setDetailAddress(dynamicObject.getString("detailaddress"));
                bill.getBuildInfo().setLandTaxNo(dynamicObject.getString("landtaxno"));
            }
        }
        if ("E06".equals(bill.getSpecialType())) {
            if (!CollectionUtils.isEmpty((Collection)bill.getEstateLeaseItems())) {
                matchedDynamicObject = null;
                for (i = 0; i < bill.getEstateLeaseItems().size(); ++i) {
                    if (StringUtils.isNotBlank((CharSequence)((BillEstateSaleItemVo)bill.getEstateLeaseItems().get(i)).getSpecialIndustryNumber())) {
                        dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bdm_estatelease_info", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_estatelease_info"), (QFilter[])new QFilter("number", "=", (Object)((BillEstateSaleItemVo)bill.getEstateLeaseItems().get(i)).getSpecialIndustryNumber()).toArray());
                    } else if (bill.isFromBillPush() && BillValidaterHelper.isEstateInfoEmpty("E06", bill)) {
                        if (null == matchedDynamicObject) {
                            matchedDynamicObject = BillValidaterHelper.matchBuilding(bill, "estateLeaseInfo");
                        }
                        dynamicObject = matchedDynamicObject;
                    }
                    BillEstateSaleItemVo estateItem = (BillEstateSaleItemVo)bill.getEstateLeaseItems().get(i);
                    if (dynamicObject == null || !dynamicObject.get("estatetype").equals("estateLeaseInfo") || !BillValidaterHelper.isAllBlank(new String[]{estateItem.getCityAdreess(), estateItem.getAreaunit(), estateItem.getCrossCitySign(), estateItem.getDetailAddress(), estateItem.getEstateId()})) continue;
                    String simpleAddress = ((DynamicObject)dynamicObject.get("simpleaddress")).getString("name");
                    Map adrressMap = AllEleLqAddressSplitUtil.split((String)simpleAddress);
                    String provinceName = (String)adrressMap.get("province");
                    String cityName = (String)adrressMap.get("city");
                    ((BillEstateSaleItemVo)bill.getEstateLeaseItems().get(i)).setProvinceAdress(provinceName);
                    ((BillEstateSaleItemVo)bill.getEstateLeaseItems().get(i)).setCityAdreess(cityName);
                    ((BillEstateSaleItemVo)bill.getEstateLeaseItems().get(i)).setDetailAddress(dynamicObject.getString("detailaddress"));
                    ((BillEstateSaleItemVo)bill.getEstateLeaseItems().get(i)).setCrossCitySign(dynamicObject.getString("crosscitysign"));
                    ((BillEstateSaleItemVo)bill.getEstateLeaseItems().get(i)).setAreaunit(dynamicObject.getString("areaunit"));
                    ((BillEstateSaleItemVo)bill.getEstateLeaseItems().get(i)).setEstateId(dynamicObject.getString("estateid"));
                }
            } else if (StringUtils.isNotBlank((CharSequence)bill.getEstateLeaseInfo().getSpecialIndustryNumber())) {
                dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bdm_estatelease_info", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_estatelease_info"), (QFilter[])new QFilter("number", "=", (Object)bill.getEstateLeaseInfo().getSpecialIndustryNumber()).toArray());
                if (dynamicObject != null && dynamicObject.get("estatetype").equals("estateLeaseInfo") && BillValidaterHelper.isAllBlank(new String[]{bill.getEstateLeaseInfo().getSimpleAddress(), bill.getEstateLeaseInfo().getAreaunit(), bill.getEstateLeaseInfo().getCrossCitySign(), bill.getEstateLeaseInfo().getDetailAddress(), bill.getEstateLeaseInfo().getEstateId()})) {
                    bill.getEstateLeaseInfo().setSimpleAddress(((DynamicObject)dynamicObject.get("simpleaddress")).getString("name"));
                    bill.getEstateLeaseInfo().setAreaunit(dynamicObject.getString("areaunit"));
                    bill.getEstateLeaseInfo().setCrossCitySign(dynamicObject.getString("crosscitysign"));
                    bill.getEstateLeaseInfo().setDetailAddress(dynamicObject.getString("detailaddress"));
                    bill.getEstateLeaseInfo().setEstateId(dynamicObject.getString("estateid"));
                }
            } else if (bill.isFromBillPush() && BillValidaterHelper.isEstateInfoEmpty("E06", bill) && (dynamicObject = BillValidaterHelper.matchBuilding(bill, "estateLeaseInfo")) != null && dynamicObject.get("estatetype").equals("estateLeaseInfo") && BillValidaterHelper.isAllBlank(new String[]{bill.getEstateLeaseInfo().getSimpleAddress(), bill.getEstateLeaseInfo().getAreaunit(), bill.getEstateLeaseInfo().getCrossCitySign(), bill.getEstateLeaseInfo().getDetailAddress(), bill.getEstateLeaseInfo().getEstateId()})) {
                bill.getEstateLeaseInfo().setSimpleAddress(((DynamicObject)dynamicObject.get("simpleaddress")).getString("name"));
                bill.getEstateLeaseInfo().setAreaunit(dynamicObject.getString("areaunit"));
                bill.getEstateLeaseInfo().setCrossCitySign(dynamicObject.getString("crosscitysign"));
                bill.getEstateLeaseInfo().setDetailAddress(dynamicObject.getString("detailaddress"));
                bill.getEstateLeaseInfo().setEstateId(dynamicObject.getString("estateid"));
            }
        }
        if ("E05".equals(bill.getSpecialType())) {
            if (!CollectionUtils.isEmpty((Collection)bill.getEstateSaleItems())) {
                matchedDynamicObject = null;
                for (i = 0; i < bill.getEstateSaleItems().size(); ++i) {
                    if (StringUtils.isNotBlank((CharSequence)((BillEstateSaleItemVo)bill.getEstateSaleItems().get(i)).getSpecialIndustryNumber())) {
                        dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bdm_estatelease_info", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_estatelease_info"), (QFilter[])new QFilter("number", "=", (Object)((BillEstateSaleItemVo)bill.getEstateSaleItems().get(i)).getSpecialIndustryNumber()).toArray());
                    } else if (bill.isFromBillPush() && BillValidaterHelper.isEstateInfoEmpty("E05", bill)) {
                        if (null == matchedDynamicObject) {
                            matchedDynamicObject = BillValidaterHelper.matchBuilding(bill, "estateSaleInfo");
                        }
                        dynamicObject = matchedDynamicObject;
                    }
                    if (dynamicObject == null || !dynamicObject.get("estatetype").equals("estateSaleInfo") || !BillValidaterHelper.isAllBlank(new String[]{((BillEstateSaleItemVo)bill.getEstateSaleItems().get(i)).getProvinceAdress(), ((BillEstateSaleItemVo)bill.getEstateSaleItems().get(i)).getEstateCode(), ((BillEstateSaleItemVo)bill.getEstateSaleItems().get(i)).getDetailAddress(), ((BillEstateSaleItemVo)bill.getEstateSaleItems().get(i)).getCrossCitySign(), ((BillEstateSaleItemVo)bill.getEstateSaleItems().get(i)).getLandTaxNo(), ((BillEstateSaleItemVo)bill.getEstateSaleItems().get(i)).getAreaunit(), ((BillEstateSaleItemVo)bill.getEstateSaleItems().get(i)).getEstateId()})) continue;
                    String simpleAddress = ((DynamicObject)dynamicObject.get("simpleaddress")).getString("name");
                    Map adrressMap = AllEleLqAddressSplitUtil.split((String)simpleAddress);
                    String provinceName = (String)adrressMap.get("province");
                    String cityName = (String)adrressMap.get("city");
                    ((BillEstateSaleItemVo)bill.getEstateSaleItems().get(i)).setProvinceAdress(provinceName);
                    ((BillEstateSaleItemVo)bill.getEstateSaleItems().get(i)).setCityAdreess(cityName);
                    ((BillEstateSaleItemVo)bill.getEstateSaleItems().get(i)).setEstateCode(dynamicObject.getString("estatecode"));
                    ((BillEstateSaleItemVo)bill.getEstateSaleItems().get(i)).setDetailAddress(dynamicObject.getString("detailaddress"));
                    ((BillEstateSaleItemVo)bill.getEstateSaleItems().get(i)).setCrossCitySign(dynamicObject.getString("crosscitysign"));
                    ((BillEstateSaleItemVo)bill.getEstateSaleItems().get(i)).setLandTaxNo(dynamicObject.getString("landtaxno"));
                    ((BillEstateSaleItemVo)bill.getEstateSaleItems().get(i)).setApprovedPrice(new BigDecimal(dynamicObject.getString("approvedprice")));
                    ((BillEstateSaleItemVo)bill.getEstateSaleItems().get(i)).setActualTurnover(new BigDecimal(dynamicObject.getString("actualturnover")));
                    ((BillEstateSaleItemVo)bill.getEstateSaleItems().get(i)).setAreaunit(dynamicObject.getString("areaunit"));
                    ((BillEstateSaleItemVo)bill.getEstateSaleItems().get(i)).setEstateId(dynamicObject.getString("estateid"));
                    ((BillEstateSaleItemVo)bill.getEstateSaleItems().get(i)).setOnLineContracteNo(dynamicObject.getString("onlinecontracteno"));
                }
            } else if (StringUtils.isNotBlank((CharSequence)bill.getEstateSaleInfo().getSpecialIndustryNumber())) {
                dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bdm_estatelease_info", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_estatelease_info"), (QFilter[])new QFilter("number", "=", (Object)bill.getEstateSaleInfo().getSpecialIndustryNumber()).toArray());
                if (dynamicObject != null && dynamicObject.get("estatetype").equals("estateSaleInfo") && BillValidaterHelper.isAllBlank(new String[]{bill.getEstateSaleInfo().getSimpleAddress(), bill.getEstateSaleInfo().getEstateCode(), bill.getEstateSaleInfo().getDetailAddress(), bill.getEstateSaleInfo().getCrossCitySign(), bill.getEstateSaleInfo().getLandTaxNo(), bill.getEstateSaleInfo().getAreaunit(), bill.getEstateSaleInfo().getEstateId()})) {
                    bill.getEstateSaleInfo().setSimpleAddress(((DynamicObject)dynamicObject.get("simpleaddress")).getString("name"));
                    bill.getEstateSaleInfo().setEstateCode(dynamicObject.getString("estatecode"));
                    bill.getEstateSaleInfo().setDetailAddress(dynamicObject.getString("detailaddress"));
                    bill.getEstateSaleInfo().setCrossCitySign(dynamicObject.getString("crosscitysign"));
                    bill.getEstateSaleInfo().setLandTaxNo(dynamicObject.getString("landtaxno"));
                    bill.getEstateSaleInfo().setApprovedPrice(new BigDecimal(dynamicObject.getString("approvedprice")));
                    bill.getEstateSaleInfo().setActualTurnover(new BigDecimal(dynamicObject.getString("actualturnover")));
                    bill.getEstateSaleInfo().setAreaunit(dynamicObject.getString("areaunit"));
                    bill.getEstateSaleInfo().setEstateId(dynamicObject.getString("estateid"));
                }
            } else if (bill.isFromBillPush() && BillValidaterHelper.isEstateInfoEmpty("E05", bill) && (dynamicObject = BillValidaterHelper.matchBuilding(bill, "estateSaleInfo")) != null && dynamicObject.get("estatetype").equals("estateSaleInfo") && BillValidaterHelper.isAllBlank(new String[]{bill.getEstateSaleInfo().getSimpleAddress(), bill.getEstateSaleInfo().getEstateCode(), bill.getEstateSaleInfo().getDetailAddress(), bill.getEstateSaleInfo().getCrossCitySign(), bill.getEstateSaleInfo().getLandTaxNo(), bill.getEstateSaleInfo().getAreaunit(), bill.getEstateSaleInfo().getEstateId()})) {
                bill.getEstateSaleInfo().setSimpleAddress(((DynamicObject)dynamicObject.get("simpleaddress")).getString("name"));
                bill.getEstateSaleInfo().setEstateCode(dynamicObject.getString("estatecode"));
                bill.getEstateSaleInfo().setDetailAddress(dynamicObject.getString("detailaddress"));
                bill.getEstateSaleInfo().setCrossCitySign(dynamicObject.getString("crosscitysign"));
                bill.getEstateSaleInfo().setLandTaxNo(dynamicObject.getString("landtaxno"));
                bill.getEstateSaleInfo().setApprovedPrice(new BigDecimal(dynamicObject.getString("approvedprice")));
                bill.getEstateSaleInfo().setActualTurnover(new BigDecimal(dynamicObject.getString("actualturnover")));
                bill.getEstateSaleInfo().setAreaunit(dynamicObject.getString("areaunit"));
                bill.getEstateSaleInfo().setEstateId(dynamicObject.getString("estateid"));
            }
        }
        return bill;
    }

    private static boolean isEstateInfoEmpty(String estateLeaseType, BillVo bill) {
        if ("E06".equals(estateLeaseType)) {
            if (!CollectionUtils.isEmpty((Collection)bill.getEstateLeaseItems())) {
                for (BillEstateSaleItemVo estateLeaseItem : bill.getEstateLeaseItems()) {
                    if (!StringUtils.isNotBlank((CharSequence)estateLeaseItem.getCityAdreess()) && !StringUtils.isNotBlank((CharSequence)estateLeaseItem.getProvinceAdress()) && !StringUtils.isNotBlank((CharSequence)estateLeaseItem.getDetailAddress()) && !StringUtils.isNotBlank((CharSequence)estateLeaseItem.getCrossCitySign()) && !StringUtils.isNotBlank((CharSequence)estateLeaseItem.getAreaunit()) && !StringUtils.isNotBlank((CharSequence)estateLeaseItem.getEstateId())) continue;
                    return false;
                }
                return true;
            }
            BillEstateLeaseInfoVo estateLeaseInfo = bill.getEstateLeaseInfo();
            if (null == estateLeaseInfo) {
                return true;
            }
            return StringUtils.isBlank((CharSequence)estateLeaseInfo.getSimpleAddress()) && StringUtils.isBlank((CharSequence)estateLeaseInfo.getAreaunit()) && StringUtils.isBlank((CharSequence)estateLeaseInfo.getCrossCitySign()) && StringUtils.isBlank((CharSequence)estateLeaseInfo.getDetailAddress()) && StringUtils.isBlank((CharSequence)estateLeaseInfo.getEstateId());
        }
        if ("E03".equals(estateLeaseType)) {
            BillBuildInfoVo buildInfo = bill.getBuildInfo();
            if (null == buildInfo) {
                return true;
            }
            return StringUtils.isBlank((CharSequence)buildInfo.getSimpleAddress()) && StringUtils.isBlank((CharSequence)buildInfo.getBuildingName()) && StringUtils.isBlank((CharSequence)buildInfo.getCrossCitySign()) && StringUtils.isBlank((CharSequence)buildInfo.getDetailAddress()) && StringUtils.isBlank((CharSequence)buildInfo.getLandTaxNo());
        }
        if ("E05".equals(estateLeaseType)) {
            List estateSaleItems = bill.getEstateSaleItems();
            if (CollectionUtils.isEmpty((Collection)bill.getEstateSaleItems())) {
                BillEstateSaleInfoVo saleInfo = bill.getEstateSaleInfo();
                if (null == saleInfo) {
                    return true;
                }
                return StringUtils.isBlank((CharSequence)saleInfo.getEstateCode()) && StringUtils.isBlank((CharSequence)saleInfo.getDetailAddress()) && StringUtils.isBlank((CharSequence)saleInfo.getCrossCitySign()) && StringUtils.isBlank((CharSequence)saleInfo.getLandTaxNo()) && BigDecimalUtil.compareZero((BigDecimal)saleInfo.getApprovedPrice()) && BigDecimalUtil.compareZero((BigDecimal)saleInfo.getActualTurnover()) && StringUtils.isBlank((CharSequence)saleInfo.getAreaunit()) && StringUtils.isBlank((CharSequence)saleInfo.getEstateId());
            }
            for (BillEstateSaleItemVo estateSaleItem : estateSaleItems) {
                if (!StringUtils.isNotBlank((CharSequence)estateSaleItem.getProvinceAdress()) && !StringUtils.isNotBlank((CharSequence)estateSaleItem.getCityAdreess()) && !StringUtils.isNotBlank((CharSequence)estateSaleItem.getEstateCode()) && !StringUtils.isNotBlank((CharSequence)estateSaleItem.getDetailAddress()) && !StringUtils.isNotBlank((CharSequence)estateSaleItem.getLandTaxNo()) && BigDecimalUtil.compareZero((BigDecimal)estateSaleItem.getApprovedPrice()) && BigDecimalUtil.compareZero((BigDecimal)estateSaleItem.getActualTurnover()) && !StringUtils.isNotBlank((CharSequence)estateSaleItem.getAreaunit()) && !StringUtils.isNotBlank((CharSequence)estateSaleItem.getEstateId()) && !StringUtils.isNotBlank((CharSequence)estateSaleItem.getOnLineContracteNo())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static DynamicObject matchBuilding(BillVo billVo, String EstateType) {
        DynamicObject[] buildings;
        if (!"1".equals(ImcConfigUtil.getValue((String)"matchBuilding", (String)"matchBuilding"))) {
            return null;
        }
        QFilter baseFilter = ImcBaseDataHelper.getMatchBuildingFilter((Object)billVo.getOrgId());
        baseFilter = baseFilter.and("estatetype", "=", (Object)EstateType);
        for (DynamicObject building : buildings = BusinessDataServiceHelper.load((String)"bdm_estatelease_info", (String)"filter_tag,priority", (QFilter[])baseFilter.toArray(), (String)"priority asc")) {
            String filterStr = building.getString("filter_tag");
            QFilter filter = new QFilter("id", "=", (Object)building.getLong("id"));
            if (StringUtils.isBlank((CharSequence)filterStr)) {
                DynamicObject[] array = BusinessDataServiceHelper.load((String)"bdm_estatelease_info", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_estatelease_info", (boolean)true), (QFilter[])filter.toArray());
                return array[0];
            }
            DynamicObject bill = DynamicObjectUtil.bean2DynamicObject((Object)billVo, (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"sim_original_bill"));
            if (!ConditionMatchHelper.verify((String)filterStr, (DynamicObject)bill)) continue;
            DynamicObject[] array = BusinessDataServiceHelper.load((String)"bdm_estatelease_info", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_estatelease_info", (boolean)true), (QFilter[])filter.toArray());
            return array[0];
        }
        return null;
    }

    public static boolean isAllBlank(String[] strings) {
        boolean flag = true;
        for (String string : strings) {
            if (!StringUtils.isNotBlank((CharSequence)string)) continue;
            flag = false;
        }
        return flag;
    }

    private static BaseInvoice convertBillVo2BaseInvoice(BillVo bill) {
        BaseInvoice baseInvoice = new BaseInvoice();
        baseInvoice.setBillno(bill.getBillNo());
        baseInvoice.setInvoicetype(bill.getInvoiceType());
        baseInvoice.setSpecialtype(bill.getSpecialType());
        baseInvoice.setSalertaxno(bill.getSellerTaxpayerId());
        baseInvoice.setTaxedtype(bill.getTaxationStyle());
        baseInvoice.setDeduction(bill.getDeduction());
        baseInvoice.setInvoiceamount(bill.getTotalAmount());
        baseInvoice.setDeductionItems(bill.getDeductionItems());
        baseInvoice.setFreightItems(bill.getFreightItems());
        baseInvoice.setTravelerList(bill.getTravelerList());
        baseInvoice.setVehicheVesselShipList(bill.getVehicheVesselShipList());
        baseInvoice.setArIssue(Boolean.valueOf(CallbackHelperUtil.isFromArIssueBill((String)bill.getSystemSource())));
        if (StringUtils.isNotBlank((CharSequence)bill.getSpecialType())) {
            switch (bill.getSpecialType()) {
                case "E03": {
                    baseInvoice.setSimpleaddress(bill.getBuildInfo().getSimpleAddress());
                    baseInvoice.setDetailaddress(bill.getBuildInfo().getDetailAddress());
                    baseInvoice.setCrosscitysign(bill.getBuildInfo().getCrossCitySign());
                    baseInvoice.setBuildingname(bill.getBuildInfo().getBuildingName());
                    baseInvoice.setLandtaxno(bill.getBuildInfo().getLandTaxNo());
                    baseInvoice.setCrossCityTaxVerifyNo(bill.getBuildInfo().getCrossCityTaxVerifyNo());
                    break;
                }
                case "E06": {
                    if (CollectionUtils.isEmpty((Collection)bill.getEstateLeaseItems())) {
                        BillEstateSaleItemVo leaseItemVo = new BillEstateSaleItemVo();
                        ArrayList leaseItemVos = new ArrayList(1);
                        Map adrressMap = AllEleLqAddressSplitUtil.split((String)bill.getEstateLeaseInfo().getSimpleAddress());
                        leaseItemVo.setProvinceAdress((String)adrressMap.get("province"));
                        leaseItemVo.setCityAdreess((String)adrressMap.get("city"));
                        leaseItemVo.setDetailAddress(bill.getEstateLeaseInfo().getDetailAddress());
                        leaseItemVo.setCrossCitySign(bill.getEstateLeaseInfo().getCrossCitySign());
                        leaseItemVo.setEstateId(bill.getEstateLeaseInfo().getEstateId());
                        leaseItemVo.setAreaunit(bill.getEstateLeaseInfo().getAreaunit());
                        leaseItemVo.setStartLeaseDate(bill.getEstateLeaseInfo().getStartLeaseDate());
                        leaseItemVo.setEndLeaseDate(bill.getEstateLeaseInfo().getEndLeaseDate());
                        leaseItemVos.add(leaseItemVo);
                        bill.setEstateLeaseItems((List)leaseItemVos);
                    } else {
                        List itemList = bill.getEstateLeaseItems();
                        for (BillEstateSaleItemVo itemVo : itemList) {
                            if (!StringUtils.isNotBlank((CharSequence)itemVo.getSimpleAddress()) || !StringUtils.isBlank((CharSequence)itemVo.getProvinceAdress()) && !StringUtils.isBlank((CharSequence)itemVo.getCityAdreess())) continue;
                            Map adrressMap = AllEleLqAddressSplitUtil.split((String)itemVo.getSimpleAddress());
                            itemVo.setProvinceAdress((String)adrressMap.get("province"));
                            itemVo.setCityAdreess((String)adrressMap.get("city"));
                        }
                    }
                    baseInvoice.setEstateSaleItems(bill.getEstateLeaseItems());
                    bill.setEstateSaleItems(bill.getEstateLeaseItems());
                    break;
                }
                case "E05": {
                    if (CollectionUtils.isEmpty((Collection)bill.getEstateSaleItems())) {
                        baseInvoice.setAreaunit(bill.getEstateSaleInfo().getAreaunit());
                        ArrayList<BillEstateSaleItemVo> saleItemVos = new ArrayList<BillEstateSaleItemVo>(1);
                        BillEstateSaleItemVo saleItemVo = BillValidaterHelper.billEstateSaleInfoVo2BillEstateSaleItemVo(bill.getEstateSaleInfo());
                        saleItemVos.add(saleItemVo);
                        bill.setCoBuyerFlag("0");
                        bill.setCoBuyerItems(null);
                        bill.setEstateSaleItems(saleItemVos);
                    }
                    baseInvoice.setCoBuyerFlag(bill.getCoBuyerFlag());
                    baseInvoice.setCoBuyerItems(bill.getCoBuyerItems());
                    baseInvoice.setEstateSaleItems(bill.getEstateSaleItems());
                }
            }
        }
        List billDetails = bill.getBillDetail();
        ArrayList<BaseInvoiceItem> items = new ArrayList<BaseInvoiceItem>(billDetails.size());
        for (BillDetailVo billDetail : billDetails) {
            BaseInvoiceItem item = new BaseInvoiceItem();
            item.setRowtype(String.valueOf(billDetail.getLineProperty()));
            item.setNum(StringUtils.isBlank((CharSequence)billDetail.getQuantity()) ? null : new BigDecimal(billDetail.getQuantity()));
            item.setUnitprice(StringUtils.isBlank((CharSequence)billDetail.getPrice()) ? null : new BigDecimal(billDetail.getPrice()));
            item.setTaxunitprice(StringUtils.isBlank((CharSequence)billDetail.getIncludeTaxPrice()) ? null : new BigDecimal(billDetail.getIncludeTaxPrice()));
            item.setUnit(StringUtils.isBlank((CharSequence)billDetail.getUnits()) ? null : billDetail.getUnits());
            item.setGoodscode(StringUtils.isBlank((CharSequence)billDetail.getRevenueCode()) ? null : billDetail.getRevenueCode());
            item.setGoodsname(StringUtils.isBlank((CharSequence)billDetail.getGoodsName()) ? null : billDetail.getGoodsName());
            items.add(item);
        }
        baseInvoice.setInvoiceItemList(items);
        return baseInvoice;
    }

    public static BillEstateSaleItemVo billEstateSaleInfoVo2BillEstateSaleItemVo(BillEstateSaleInfoVo saleInfoVo) {
        BillEstateSaleItemVo saleItemVo = new BillEstateSaleItemVo();
        saleItemVo.setEstateCode(saleInfoVo.getEstateCode());
        Map adrressMap = AllEleLqAddressSplitUtil.split((String)saleInfoVo.getSimpleAddress());
        saleItemVo.setProvinceAdress((String)adrressMap.get("province"));
        saleItemVo.setCityAdreess((String)adrressMap.get("city"));
        saleItemVo.setDetailAddress(saleInfoVo.getDetailAddress());
        saleItemVo.setCrossCitySign(saleInfoVo.getCrossCitySign());
        saleItemVo.setLandTaxNo(saleInfoVo.getLandTaxNo());
        saleItemVo.setApprovedPrice(saleInfoVo.getApprovedPrice());
        saleItemVo.setActualTurnover(saleInfoVo.getActualTurnover());
        saleItemVo.setEstateId(saleInfoVo.getEstateId());
        saleItemVo.setAreaunit(saleInfoVo.getAreaunit());
        return saleItemVo;
    }

    public static ApiResult validAllEDeduction(BillVo bill, ValidTypeEnum validType) {
        if (!TaxedTypeEnum.alleTaxedTypeDeduction((String)bill.getTaxationStyle())) {
            return ResponseVo.success((String)"");
        }
        try {
            if (validType == ValidTypeEnum.BILL) {
                for (BillDeductionItemVo deductionItem : bill.getDeductionItems()) {
                    QFilter qFilter = null;
                    if ("01".equals(deductionItem.getEvidenceType()) && StringUtils.isNotBlank((CharSequence)deductionItem.getEtaxInvoiceNo())) {
                        qFilter = InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)"", (String)deductionItem.getEtaxInvoiceNo());
                    } else if (("02".equals(deductionItem.getEvidenceType()) || "03".equals(deductionItem.getEvidenceType())) && StringUtils.isNotBlank((CharSequence)deductionItem.getInvoiceCode()) && StringUtils.isNotBlank((CharSequence)deductionItem.getInvoiceNo())) {
                        qFilter = InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)deductionItem.getInvoiceCode(), (String)deductionItem.getInvoiceNo());
                    }
                    if (qFilter == null) continue;
                    qFilter.and(new QFilter("orgid", "=", (Object)bill.getOrgId()));
                    DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "totalamount", "issuetime"), (QFilter[])qFilter.toArray());
                    if (invoice == null) continue;
                    deductionItem.setOriEvidenceAmount(invoice.getBigDecimal("totalamount"));
                    deductionItem.setInvoiceDate(DateUtils.format((Date)invoice.getDate("issuetime")));
                    if (!MathUtils.isNullOrZero((BigDecimal)deductionItem.getEvidenceAmount())) continue;
                    deductionItem.setEvidenceAmount(invoice.getBigDecimal("totalamount"));
                }
            }
            BaseInvoice baseInvoice = BillValidaterHelper.convertBillVo2BaseInvoice(bill);
            InvoiceCheckService.checkEleDeduction((BaseInvoice)baseInvoice, (bill.getAutoInvoice() == 1 ? 1 : 0) != 0);
        }
        catch (MsgException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return ResponseVo.fail((String)ErrorType.FAIL.getCode(), (String)e.getErrorMsg());
        }
        return ResponseVo.success((String)"");
    }

    public static ApiResult validBillInvoice(DynamicObject confirmBill, boolean isPluginSave, BillCheckProcessDto process) {
        if (null == confirmBill) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_NO_DATA.getCode(), (String)ResManager.loadKDString((String)"\u5355\u636e\u4fe1\u606f\u672a\u4f20\u5165", (String)"BillValidaterHelper_8", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        BillVo bill = (BillVo)DynamicObjectUtil.dynamicObject2Bean(BillVo.class, (DynamicObject)confirmBill);
        if (null == bill) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_NO_DATA.getCode(), (String)ResManager.loadKDString((String)"\u5355\u636e\u4fe1\u606f\u672a\u4f20\u5165", (String)"BillValidaterHelper_8", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        bill.setAutoInvoice(isPluginSave ? 0 : 1);
        BillValidaterHelper.fillDateType(bill, confirmBill);
        switch (bill.getSpecialType()) {
            case "E06": {
                bill.setEstateLeaseInfo((BillEstateLeaseInfoVo)DynamicObjectUtil.dynamicObject2Bean(BillEstateLeaseInfoVo.class, (DynamicObject)confirmBill));
                if (!DynamicObjectUtil.checkDynamicObjectHasField((DynamicObject)confirmBill, (String)"estatesales") || CollectionUtils.isEmpty((Collection)confirmBill.getDynamicObjectCollection("estatesales"))) break;
                bill.setEstateLeaseItems(DynamicObjectUtil.dynamicObjectCollection2List(BillEstateSaleItemVo.class, (DynamicObjectCollection)confirmBill.getDynamicObjectCollection("estatesales")));
                break;
            }
            case "E03": {
                bill.setBuildInfo((BillBuildInfoVo)DynamicObjectUtil.dynamicObject2Bean(BillBuildInfoVo.class, (DynamicObject)confirmBill));
                break;
            }
            case "E05": {
                if (!DynamicObjectUtil.checkDynamicObjectHasField((DynamicObject)confirmBill, (String)"estatesales") || !CollectionUtils.isEmpty((Collection)confirmBill.getDynamicObjectCollection("estatesales"))) break;
                bill.setEstateSaleInfo((BillEstateSaleInfoVo)DynamicObjectUtil.dynamicObject2Bean(BillEstateSaleInfoVo.class, (DynamicObject)confirmBill));
                break;
            }
            case "E04": {
                DynamicObjectCollection freightItems = confirmBill.getDynamicObjectCollection("freights");
                ArrayList items = new ArrayList(freightItems.size());
                freightItems.forEach(freightItem -> items.add(DynamicObjectUtil.dynamicObject2Bean(BillFreightItemVo.class, (DynamicObject)freightItem)));
                bill.setFreightItems(items);
            }
        }
        ApiResult validResult = BillValidaterHelper.validBillCommon(bill, null, ValidTypeEnum.INVOICE, !isPluginSave, process);
        if (!validResult.getSuccess()) {
            return validResult;
        }
        validResult = BillValidaterHelper.validBillBuyer(bill, ValidTypeEnum.INVOICE);
        if (!validResult.getSuccess()) {
            return validResult;
        }
        validResult = BillValidaterHelper.validBillSeller(bill, null, null, ValidTypeEnum.INVOICE);
        if (!validResult.getSuccess()) {
            return validResult;
        }
        validResult = BillValidaterHelper.validAllESpecial(bill, process.isCheckAllESpecialFields());
        if (!validResult.getSuccess()) {
            return validResult;
        }
        try {
            DynamicObjectCollection dynamicObjectCollection = confirmBill.getDynamicObjectCollection("travelers");
            if (process.isCheckAllESpecialFields() && "E09".equals(bill.getSpecialType())) {
                DynamicObjectCollection itemObjectCollection = confirmBill.getDynamicObjectCollection("sim_original_bill_item");
                InvoiceOriginalFormControl.dealCheckTravelerItemMethod(bill.getBillNo(), itemObjectCollection, dynamicObjectCollection);
                InvoiceOriginalFormControl.dealCheckTransportTypeMethod(dynamicObjectCollection);
            }
        }
        catch (Exception e) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BUYER_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]%2$s", (String)"BillValidaterHelper_187", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), e.getMessage()));
        }
        validResult = BillValidaterHelper.validAllEDeduction(bill, ValidTypeEnum.INVOICE);
        if (!validResult.getSuccess()) {
            return validResult;
        }
        if (isPluginSave && BotpHelper.onlySubmitCheck((DynamicObject)confirmBill)) {
            return validResult;
        }
        validResult = BillValidaterHelper.validBillDetailEntrance(bill, ValidTypeEnum.INVOICE);
        if (!validResult.getSuccess()) {
            return validResult;
        }
        validResult = BillValidaterHelper.checkCoalTypeCodeAndQuality(bill, process.isCheckAllESpecialFields());
        if (!validResult.getSuccess()) {
            return validResult;
        }
        return validResult;
    }

    private static void dealAllESpecialFields(DynamicObject confirmBill, BillVo bill) {
        switch (bill.getSpecialType()) {
            case "E06": {
                bill.setEstateLeaseInfo((BillEstateLeaseInfoVo)DynamicObjectUtil.dynamicObject2Bean(BillEstateLeaseInfoVo.class, (DynamicObject)confirmBill));
                if (!DynamicObjectUtil.checkDynamicObjectHasField((DynamicObject)confirmBill, (String)"estatesales") || CollectionUtils.isEmpty((Collection)confirmBill.getDynamicObjectCollection("estatesales"))) break;
                bill.setEstateLeaseItems(DynamicObjectUtil.dynamicObjectCollection2List(BillEstateSaleItemVo.class, (DynamicObjectCollection)confirmBill.getDynamicObjectCollection("estatesales")));
                break;
            }
            case "E03": {
                bill.setBuildInfo((BillBuildInfoVo)DynamicObjectUtil.dynamicObject2Bean(BillBuildInfoVo.class, (DynamicObject)confirmBill));
                break;
            }
            case "E05": {
                if (!DynamicObjectUtil.checkDynamicObjectHasField((DynamicObject)confirmBill, (String)"estatesales") || !CollectionUtils.isEmpty((Collection)confirmBill.getDynamicObjectCollection("estatesales"))) break;
                bill.setEstateSaleInfo((BillEstateSaleInfoVo)DynamicObjectUtil.dynamicObject2Bean(BillEstateSaleInfoVo.class, (DynamicObject)confirmBill));
                break;
            }
            case "E04": {
                DynamicObjectCollection freightItems = confirmBill.getDynamicObjectCollection("freights");
                ArrayList items = new ArrayList(freightItems.size());
                freightItems.forEach(freightItem -> items.add(DynamicObjectUtil.dynamicObject2Bean(BillFreightItemVo.class, (DynamicObject)freightItem)));
                bill.setFreightItems(items);
            }
        }
    }

    private static void fillDateType(BillVo bill, DynamicObject confirmBill) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        if (StringUtils.isNotBlank((Object)confirmBill.get("billdate"))) {
            bill.setBillDate(format.format(confirmBill.getDate("billdate")));
        }
        if (StringUtils.isNotBlank((Object)confirmBill.getDate("contractdate"))) {
            bill.setContractDate(format.format(confirmBill.getDate("contractdate")));
        }
        if (StringUtils.isNotBlank((Object)confirmBill.getDate("exchangedate"))) {
            bill.setExchangeDate(format.format(confirmBill.getDate("exchangedate")));
        }
        if (StringUtils.isNotBlank((Object)confirmBill.getDate("originalissuetime"))) {
            bill.setOriginalIssueTime(format.format(confirmBill.getDate("originalissuetime")));
        }
        if (!TaxedTypeEnum.all_e_deduction.getValue().equals(confirmBill.getString("taxationstyle"))) {
            return;
        }
        DynamicObjectCollection deductions = confirmBill.getDynamicObjectCollection("deductions");
        List deductionItems = bill.getDeductionItems();
        for (int i = 0; i < deductions.size(); ++i) {
            DynamicObject deduction = (DynamicObject)deductions.get(i);
            BillDeductionItemVo billDeductionItemVo = (BillDeductionItemVo)deductionItems.get(i);
            Date date = deduction.getDate("invoicedate");
            if (date == null) continue;
            billDeductionItemVo.setInvoiceDate(format.format(date));
        }
    }

    public static ApiResult validBillCommon(BillVo bill, Set<String> billNos, ValidTypeEnum validType, boolean needCheckRed, BillCheckProcessDto process) {
        String first;
        BigDecimal extra;
        ApiResult normalInfoResult;
        try {
            new CheckBillService(bill).checkBillNO().checkInvoiceType(process).checkTotalAmount().checkBuyerProperty();
        }
        catch (MsgException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return ResponseVo.fail((String)e.getErrorCode(), (String)e.getErrorMsg());
        }
        int billProperty = bill.getTotalAmount().compareTo(BigDecimal.ZERO);
        if (billProperty >= 0) {
            bill.setBillProperty(1);
        } else {
            bill.setBillProperty(-1);
        }
        if (bill.getAutoInvoice() != 1) {
            bill.setAutoInvoice(0);
        }
        if (bill.getIncludeTaxFlag() != 1) {
            bill.setIncludeTaxFlag(0);
        }
        if (bill.getPriority() != 1) {
            bill.setPriority(0);
        }
        if (needCheckRed && (normalInfoResult = BillValidaterHelper.checkRedNormalInfo(bill)) != null) {
            return normalInfoResult;
        }
        ApiResult apiResult = BillValidaterHelper.checkPhoneAndEmail(bill, validType);
        if (apiResult != null) {
            return apiResult;
        }
        apiResult = BillValidaterHelper.checkDeduction(bill, validType, process);
        if (apiResult != null) {
            return apiResult;
        }
        apiResult = BillValidaterHelper.checkBillDate(bill);
        if (apiResult != null) {
            return apiResult;
        }
        if (StringUtils.isBlank((CharSequence)bill.getSellerTaxpayerId())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_TAXPAYERID_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u9500\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u672a\u4f20\u5165", (String)"BillValidaterHelper_9", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
        }
        if (null == bill.getBillDetail() || bill.getBillDetail().isEmpty()) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u660e\u7ec6\u6570\u636e\u672a\u4f20\u5165", (String)"BillValidaterHelper_10", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
        }
        if (validType == ValidTypeEnum.BILL) {
            if (null != billNos && billNos.contains(bill.getBillNo())) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u91cd\u590d\u63a8\u9001", (String)"BillValidaterHelper_11", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
            }
            QFilter qfilter = new QFilter("billno", "=", (Object)bill.getBillNo()).and("salertaxno", "=", (Object)bill.getSellerTaxpayerId());
            if (QueryServiceHelper.exists((String)"sim_original_bill", (QFilter[])qfilter.toArray())) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u5df2\u5b58\u5728", (String)"BillValidaterHelper_12", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
            }
        } else if (validType == ValidTypeEnum.INVOICE && (extra = bill.getOriginalIncludeTaxAmount().subtract(bill.getIncludeTaxAmount()).setScale(2, 4).abs()).compareTo(new BigDecimal("10")) > 0) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u539f\u59cb\u4ef7\u7a0e\u5408\u8ba1\u4e0e\u4ef7\u7a0e\u5408\u8ba1\u76f8\u5dee\u4e0d\u80fd\u8d85\u8fc710", (String)"BillValidaterHelper_13", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
        }
        if ((apiResult = BillValidaterHelper.drawerAndRemarkCheck(bill, validType)) != null) {
            return apiResult;
        }
        apiResult = BillValidaterHelper.checkExtNoUseField(bill);
        if (apiResult != null) {
            return apiResult;
        }
        if (TaxedTypeEnum.all_e_reduced_tax.getValue().equals(bill.getTaxationStyle())) {
            if (StringUtils.isEmpty((CharSequence)bill.getReductionTaxType()) && !EnterpriseHelper.isLqptChannel((String)bill.getSellerTaxpayerId())) {
                first = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"BillValidaterHelper_142", (String)"imc-sim-service", (Object[])new Object[0]);
                String end = ResManager.loadKDString((String)"\u5f81\u7a0e\u65b9\u5f0f\u4e3a\u51cf\u6309\u5f81\u7a0e-\u6570\u7535\u65f6\uff0c\u51cf\u6309\u5f81\u7a0e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillValidaterHelper_143", (String)"imc-sim-service", (Object[])new Object[0]);
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)(first + bill.getBillNo() + end));
            }
            if (!InvoiceUtils.isAllEInvoice((Object)bill.getInvoiceType())) {
                first = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"BillValidaterHelper_142", (String)"imc-sim-service", (Object[])new Object[0]);
                String end = ResManager.loadKDString((String)"\u5f81\u7a0e\u65b9\u5f0f\u4e3a\u51cf\u6309\u5f81\u7a0e-\u6570\u7535\u65f6\uff0c\u53d1\u7968\u7c7b\u578b\u9700\u4e3a\u6570\u7535", (String)"BillValidaterHelper_144", (String)"imc-sim-service", (Object[])new Object[0]);
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)(first + bill.getBillNo() + end));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)bill.getReductionTaxType()) && !"3".equals(bill.getTaxationStyle())) {
            first = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"BillValidaterHelper_142", (String)"imc-sim-service", (Object[])new Object[0]);
            String end = ResManager.loadKDString((String)"\u51cf\u6309\u5f81\u7a0e\u7c7b\u578b\u4e0d\u4e3a\u7a7a\u65f6\uff0c\u5f81\u7a0e\u65b9\u5f0f\u9700\u586b\u51cf\u6309\u5f81\u7a0e 3", (String)"BillValidaterHelper_145", (String)"imc-sim-service", (Object[])new Object[0]);
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)(first + bill.getBillNo() + end));
        }
        apiResult = BillValidaterHelper.checkBillExtraInfo(bill);
        if (null != apiResult) {
            return apiResult;
        }
        return ResponseVo.success((String)"");
    }

    private static ApiResult checkExtNoUseField(BillVo bill) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"sim_original_bill");
        DataEntityPropertyCollection properties = entityType.getProperties();
        try {
            BillValidaterHelper.checkLength(properties, "contractno", bill, bill.getContractNo());
            BillValidaterHelper.checkLength(properties, "purchasername", bill, bill.getPurchaserName());
            BillValidaterHelper.checkLength(properties, "purchasercontact", bill, bill.getPurchaserContact());
            BillValidaterHelper.checkLength(properties, "purchaserphone", bill, bill.getPurchaserPhone());
            BillValidaterHelper.checkLength(properties, "billremark", bill, bill.getNote());
        }
        catch (KDBizException e) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)e.getMessage());
        }
        return null;
    }

    private static ApiResult checkBillExtraInfo(BillVo bill) {
        if (BigDecimalUtil.lessZero((BigDecimal)bill.getTotalAmount())) {
            bill.setExtraInfoItems(null);
            return null;
        }
        List extraInfoItems = bill.getExtraInfoItems();
        if (null != extraInfoItems && extraInfoItems.size() > 0) {
            HashSet<String> nameSet = new HashSet<String>();
            for (int i = 0; i < extraInfoItems.size(); ++i) {
                ExtraInfoItemVo extraInfoItem = (ExtraInfoItemVo)extraInfoItems.get(i);
                String extraName = extraInfoItem.getExtraInfoName();
                String extraType = extraInfoItem.getExtraInfoType();
                String extraValue = extraInfoItem.getExtraInfoValue();
                if ("2".equals(extraType)) {
                    try {
                        Date date = DateUtils.stringToDate((String)extraValue, (String)"yyyy-MM-dd");
                        extraInfoItem.setExtraDate(date);
                        String dateStr = DateUtils.format((Date)date, (String)"yyyy-MM-dd");
                        extraInfoItem.setExtraInfoValue(dateStr);
                    }
                    catch (Exception e) {
                        return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e:%1$s\u7684\u7b2c:%2$s\u884c\u9644\u52a0\u8981\u7d20\u503c\u683c\u5f0f\u6709\u8bef", (String)"BillValidaterHelper_160", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), i + 1));
                    }
                }
                if (!("1".equals(extraType) || "0".equals(extraType) || "2".equals(extraType))) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e:%1$s\u7684\u7b2c:%2$s\u884c\u9644\u52a0\u8981\u7d20\u7c7b\u578b\u6709\u8bef", (String)"BillValidaterHelper_162", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), i + 1));
                }
                Date extraDate = extraInfoItem.getExtraDate();
                if (StringUtils.isBlank((CharSequence)extraName) || StringUtils.isBlank((CharSequence)extraType) || StringUtils.isBlank((CharSequence)extraValue)) {
                    if ("2".equals(extraType)) {
                        if (null == extraDate) {
                            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e:%1$s\u7684\u7b2c:%2$s\u884c\u9644\u52a0\u8981\u7d20\u540d\u79f0\u3001\u9644\u52a0\u8981\u7d20\u7c7b\u578b\u3001\u9644\u52a0\u8981\u7d20\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillValidaterHelper_158", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), i + 1));
                        }
                    } else {
                        return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e:%1$s\u7684\u7b2c:%2$s\u884c\u9644\u52a0\u8981\u7d20\u540d\u79f0\u3001\u9644\u52a0\u8981\u7d20\u7c7b\u578b\u3001\u9644\u52a0\u8981\u7d20\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillValidaterHelper_158", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), i + 1));
                    }
                }
                if (extraName.length() > 200 || String.valueOf(extraValue).length() > 200) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e:%1$s\u7684\u7b2c:%2$s\u884c\u9644\u52a0\u8981\u7d20\u540d\u79f0\u3001\u9644\u52a0\u8981\u7d20\u503c\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7200\u5b57\u7b26", (String)"BillValidaterHelper_159", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), i + 1));
                }
                if ("1".equals(extraType) && !BigDecimalUtil.isNumber((String)extraValue)) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e:%1$s\u7684\u7b2c:%2$s\u884c\u9644\u52a0\u8981\u7d20\u503c\u683c\u5f0f\u6709\u8bef", (String)"BillValidaterHelper_160", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), i + 1));
                }
                if (nameSet.contains(extraName)) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e:%1$s\u7684\u7b2c:%2$s\u884c\u5df2\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u9644\u52a0\u8981\u7d20\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0", (String)"BillValidaterHelper_161", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), i + 1));
                }
                nameSet.add(extraName);
            }
        }
        return null;
    }

    public static ApiResult checkRedNormalInfo(BillVo bill) {
        if (InvoiceUtils.isNormalInvoice((String)bill.getInvoiceType()) && -1 == bill.getBillProperty()) {
            if (StringUtils.isNotBlank((CharSequence)bill.getBlueinvoiceCode()) && StringUtils.isNotBlank((CharSequence)bill.getBlueinvoiceNo())) {
                if (!RegexUtil.isInvoiceCode((String)bill.getBlueinvoiceCode())) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7684\u5f85\u51b2\u84dd\u7968\u4ee3\u7801[%2$s]\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"BillValidaterHelper_14", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), bill.getBlueinvoiceCode()));
                }
                if (!RegexUtil.isInvoiceNo((String)bill.getBlueinvoiceNo())) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7684\u5f85\u51b2\u84dd\u7968\u53f7\u7801[%2$s]\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"BillValidaterHelper_15", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), bill.getBlueinvoiceNo()));
                }
                QFilter filter = new QFilter("invoicecode", "=", (Object)bill.getBlueinvoiceCode()).and("invoiceno", "=", (Object)bill.getBlueinvoiceNo()).and("issuestatus", "=", (Object)"0").and("issuetype", "=", (Object)"0");
                if (InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode().equals(bill.getInvoiceType())) {
                    filter.and("invoicetype", "=", (Object)InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode());
                } else {
                    filter.and("invoicetype", "not in", (Object)InvoiceUtils.getSpecialInvoiceType().toArray());
                }
                DynamicObject[] load = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])new QFilter[]{filter});
                if (load.length > 0) {
                    if ("6".equals(load[0].getString("invoicestatus")) || "3".equals(load[0].getString("invoicestatus"))) {
                        return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u5f85\u51b2\u53d1\u7968\u5df2\u7ea2\u51b2\u6216\u5df2\u4f5c\u5e9f", (String)"BillValidaterHelper_16", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
                    }
                    bill.setBlueInvoiceType(load[0].getString("invoicetype"));
                    bill.setOriginalIssueTime(new SimpleDateFormat("yyyy-MM-dd").format(load[0].getDate("issuetime")));
                } else {
                    if (bill.getAutoInvoice() == 0) {
                        return BillValidaterHelper.checkUnAutoInvoiceNormalRed(bill);
                    }
                    if (StringUtils.isBlank((CharSequence)bill.getBlueInvoiceType()) || StringUtils.isBlank((CharSequence)bill.getOriginalIssueTime())) {
                        return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u5f85\u51b2\u53d1\u7968\u79cd\u7c7b \u6216 \u5f85\u51b2\u84dd\u7968\u5f00\u7968\u65e5\u671f\u8bf7\u8865\u5145\u5b8c\u6574", (String)"BillValidaterHelper_17", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
                    }
                }
                if (StringUtils.isBlank((CharSequence)bill.getRedReason()) || !RedReasonEnum.getAllTypeCode().contains(bill.getRedReason())) {
                    bill.setRedReason(RedReasonEnum.INVOICE_ERR.getTypeCode());
                }
                if (!InvoiceUtils.isNormalInvoice((String)bill.getBlueInvoiceType()) && !InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode().equals(bill.getBlueInvoiceType())) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u5f85\u51b2\u53d1\u7968\u79cd\u7c7b\u53ea\u80fd\u662f\u666e\u7968\u6216\u5377\u7968", (String)"BillValidaterHelper_18", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
                }
                if (InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode().equals(bill.getBlueInvoiceType()) && !InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode().equals(bill.getBlueInvoiceType())) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u5377\u7968\u7684\u5f85\u51b2\u53d1\u7968\u79cd\u7c7b\u53ea\u80fd\u662f\u5377\u7968", (String)"BillValidaterHelper_19", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
                }
            } else {
                if (StringUtils.isBlank((CharSequence)bill.getBlueinvoiceCode()) && StringUtils.isNotBlank((CharSequence)bill.getBlueinvoiceNo()) || StringUtils.isNotBlank((CharSequence)bill.getBlueinvoiceCode()) && StringUtils.isBlank((CharSequence)bill.getBlueinvoiceNo())) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u7684\u5f85\u51b2\u84dd\u7968\u4ee3\u7801\u548c\u5f85\u51b2\u84dd\u7968\u53f7\u7801\u9700\u540c\u65f6\u586b\u6216\u8005\u4e0d\u586b", (String)"BillValidaterHelper_20", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
                }
                bill.setOriginalIssueTime(null);
                bill.setBlueInvoiceType("");
                bill.setRedReason("");
            }
        }
        return null;
    }

    private static ApiResult checkUnAutoInvoiceNormalRed(BillVo bill) {
        if (StringUtils.isNotBlank((CharSequence)bill.getRedReason()) && !RedReasonEnum.getAllTypeCode().contains(bill.getRedReason())) {
            bill.setRedReason(RedReasonEnum.INVOICE_ERR.getTypeCode());
        }
        if (StringUtils.isNotBlank((CharSequence)bill.getBlueInvoiceType()) && !InvoiceUtils.isNormalInvoice((String)bill.getBlueInvoiceType()) && !InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode().equals(bill.getBlueInvoiceType())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u5f85\u51b2\u53d1\u7968\u79cd\u7c7b\u53ea\u80fd\u662f\u666e\u7968\u6216\u5377\u7968", (String)"BillValidaterHelper_18", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
        }
        if (StringUtils.isNotBlank((CharSequence)bill.getBlueInvoiceType()) && InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode().equals(bill.getBlueInvoiceType()) && !InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode().equals(bill.getBlueInvoiceType())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u5377\u7968\u7684\u5f85\u51b2\u53d1\u7968\u79cd\u7c7b\u53ea\u80fd\u662f\u5377\u7968", (String)"BillValidaterHelper_19", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
        }
        return null;
    }

    public static ApiResult checkPhoneAndEmail(BillVo bill, ValidTypeEnum validType) {
        String[] phones;
        if (InvoiceUtils.isEtcInvoice((String)bill.getInvoiceType())) {
            if (StringUtils.isNotBlank((CharSequence)bill.getBuyerRecipientPhone()) && !InvoiceValidHelper.isMobile((String)bill.getBuyerRecipientPhone()) && MsgAuthSettingCacheHelper.isCheckPhone((long)bill.getOrgId())) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BUYERRPHONE_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u6536\u7968\u4eba\u624b\u673a\u53f7[%2$s]\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"BillValidaterHelper_21", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), bill.getBuyerRecipientPhone()));
            }
        } else {
            boolean volumeCreatePdf = "1".equals(ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.VOLUME_INVOICE_CREATE_PDF));
            if (volumeCreatePdf && InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode().equals(bill.getInvoiceType())) {
                BillValidaterHelper.checkVolumePhoneEmail(bill);
            } else {
                bill.setBuyerRecipientMail("");
                bill.setBuyerRecipientPhone("");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)bill.getBuyerRecipientPhone()) && (phones = bill.getBuyerRecipientPhone().split(";")).length > 3) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BUYERRPHONE_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u6536\u7968\u4eba\u624b\u673a\u53f7[%2$s]\u6700\u591a\u652f\u6301\u4f20\u51653\u4e2a\u624b\u673a\u53f7", (String)"BillValidaterHelper_22", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), bill.getBuyerRecipientPhone()));
        }
        if (StringUtils.isNotBlank((CharSequence)bill.getBuyerRecipientMail())) {
            String[] mail = bill.getBuyerRecipientMail().split(";");
            if (mail.length > 10) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BUYERREMAIL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u6536\u7968\u4eba\u90ae\u7bb1[%2$s]\u6700\u591a\u652f\u6301\u4f20\u516510\u4e2a\u90ae\u7bb1", (String)"BillValidaterHelper_23", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), bill.getBuyerRecipientMail()));
            }
            for (String m : mail) {
                if (RegexUtil.isEmail((String)m)) continue;
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BUYERREMAIL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u6536\u7968\u4eba\u90ae\u7bb1[%2$s]\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"BillValidaterHelper_24", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), m));
            }
        }
        if ((validType == ValidTypeEnum.INVOICE || bill.getAutoInvoice() == 1) && InvoiceUtils.isEtcInvoice((String)bill.getInvoiceType()) && bill.getBillProperty() == 1) {
            String checkPhone = MsgAuthSettingCacheHelper.getCacheCheckPhoneByOrgId((long)bill.getOrgId());
            if (CheckPhoneEnum.DEFAULT.getCode().equals(checkPhone) && StringUtils.isBlank((CharSequence)bill.getBuyerRecipientMail()) && StringUtils.isBlank((CharSequence)bill.getBuyerRecipientPhone())) {
                return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_EMAIL_OR_PHONE_NEW.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7:%1$s,%2$s", (String)"BillValidaterHelper_25", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), ApiErrCodeEnum.INVOICE_OPEN_EMAIL_OR_PHONE_NEW.getMsg()));
            }
        }
        return null;
    }

    private static void checkVolumePhoneEmail(BillVo bill) {
        if (StringUtils.isNotBlank((CharSequence)bill.getBuyerRecipientPhone())) {
            String[] phones;
            for (String phone : phones = bill.getBuyerRecipientPhone().split(";")) {
                if (InvoiceValidHelper.isMobile((String)phone)) continue;
                bill.setBuyerRecipientPhone("");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)bill.getBuyerRecipientMail())) {
            String[] mails;
            for (String mail : mails = bill.getBuyerRecipientMail().split(";")) {
                if (RegexUtil.isEmail((String)mail)) continue;
                bill.setBuyerRecipientMail("");
            }
        }
    }

    public static ApiResult checkBillDate(BillVo bill) {
        SimpleDateFormat sdf;
        if (StringUtils.isNotBlank((CharSequence)bill.getBillDate())) {
            sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                sdf.parse(bill.getBillDate());
            }
            catch (ParseException e) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u5bf9\u5e94\u5355\u636e\u65e5\u671f[%2$s]\u683c\u5f0f\u4e0d\u6b63\u786e(yyyy-MM-dd)", (String)"BillValidaterHelper_26", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), bill.getBillDate()));
            }
        }
        if (null != bill.getContractDate()) {
            sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                sdf.parse(bill.getBillDate());
            }
            catch (ParseException e) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u5bf9\u5e94\u5408\u540c\u65e5\u671f[%2$s]\u683c\u5f0f\u4e0d\u6b63\u786e(yyyy-MM-dd)", (String)"BillValidaterHelper_27", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), bill.getContractDate()));
            }
        }
        return null;
    }

    public static ApiResult checkDeduction(BillVo bill, ValidTypeEnum validType, BillCheckProcessDto process) {
        List dedectionItems;
        if (StringUtils.isBlank((CharSequence)bill.getTaxationStyle())) {
            bill.setTaxationStyle(TaxedTypeEnum.normal.getValue());
        }
        if (InvoiceUtils.isAllEInvoice((Object)bill.getInvoiceType())) {
            if (!TaxedTypeEnum.alleTaxedType((String)bill.getTaxationStyle())) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u6570\u7535\u7968\u5f81\u7a0e\u65b9\u5f0f\u6709\u8bef\uff0c\u53ea\u80fd\u4e3a0\u666e\u901a\u5f81\u7a0e,01\u5dee\u989d\u5f81\u7a0e-\u5168\u989d\u5f00\u7968,02\u5dee\u989d\u5f81\u7a0e-\u5dee\u989d\u5f00\u7968,3\u51cf\u6309\u5f81\u7a0e", (String)"BillValidaterHelper_28", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
            }
        } else if (!TaxedTypeEnum.taxControlTaxedType((String)bill.getTaxationStyle())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u7a0e\u63a7\u53d1\u7968\u5f81\u7a0e\u65b9\u5f0f\u6709\u8bef\uff0c\u53ea\u80fd\u4e3a0\u666e\u901a\u5f81\u7a0e,1\u51cf\u6309\u8ba1\u589e,2\u5dee\u989d\u5f81\u7a0e", (String)"BillValidaterHelper_29", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
        }
        if (TaxedTypeEnum.all_e_deduction.getValue().equals(bill.getTaxationStyle())) {
            dedectionItems = bill.getDeductionItems();
            if (!CollectionUtils.isEmpty((Collection)dedectionItems) && MathUtils.isNullOrZero((BigDecimal)bill.getDeduction())) {
                bill.setDeduction(dedectionItems.stream().map(BillDeductionItemVo::getDeduction).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
            if (!MathUtils.isNullOrZero((BigDecimal)bill.getDeduction())) {
                String remark = String.format("\u6263\u9664\u989d\uff1a%s\u3002", bill.getDeduction().setScale(2, 4).stripTrailingZeros().toPlainString());
                bill.setRemark(remark + (bill.getRemark() == null ? "" : System.lineSeparator() + bill.getRemark()));
            }
        }
        if (!MathUtils.isNullOrZero((BigDecimal)bill.getDeduction()) && !InvoiceUtils.isAllEInvoice((Object)bill.getInvoiceType())) {
            bill.setTaxationStyle(TaxedTypeEnum.deduction.getValue());
        }
        if (!process.isCheckAllESpecialFields()) {
            return null;
        }
        if (TaxedTypeEnum.all_e_deduction.getValue().equals(bill.getTaxationStyle())) {
            dedectionItems = bill.getDeductionItems();
            if (bill.getAutoInvoice() == 1) {
                if (bill.getTotalAmount().compareTo(BigDecimal.ZERO) < 0) {
                    bill.setDeductionItems(new ArrayList(1));
                } else if (CollectionUtils.isEmpty((Collection)dedectionItems)) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u5dee\u989d\u5f81\u7a0e-\u5dee\u989d\u5f00\u7968\u5dee\u989d\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillValidaterHelper_30", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
                }
            }
        } else {
            bill.setDeductionItems(null);
            if (TaxedTypeEnum.all_e_deduction_full.getValue().equals(bill.getTaxationStyle())) {
                bill.setDeduction(BigDecimal.ZERO);
            }
        }
        if (MathUtils.isNullOrZero((BigDecimal)bill.getDeduction())) {
            if (TaxedTypeEnum.deduction.getValue().equals(bill.getTaxationStyle())) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u5dee\u989d\u5f81\u7a0e\u6263\u9664\u989d\u4e0d\u80fd\u4e3a0", (String)"BillValidaterHelper_31", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
            }
            if (TaxedTypeEnum.all_e_deduction.getValue().equals(bill.getTaxationStyle())) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u5dee\u989d\u5f81\u7a0e-\u5dee\u989d\u5f00\u7968\u6263\u9664\u989d\u4e0d\u80fd\u4e3a0", (String)"BillValidaterHelper_32", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
            }
        } else {
            if (bill.getBillProperty() == -1 && bill.getDeduction().compareTo(BigDecimal.ZERO) > 0) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u4e3a\u8d1f\u6570\u5355\u636e\uff0c\u5dee\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e0", (String)"BillValidaterHelper_33", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
            }
            if (bill.getBillProperty() == 1 && bill.getDeduction().compareTo(BigDecimal.ZERO) < 0) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u4e3a\u6b63\u6570\u5355\u636e\uff0c\u5dee\u989d\u4e0d\u5141\u8bb8\u5c0f\u4e8e0", (String)"BillValidaterHelper_34", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
            }
            if (validType == ValidTypeEnum.INVOICE && bill.getTotalAmount().abs().compareTo(bill.getDeduction().abs()) < 0) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u5dee\u989d\u5927\u4e8e\u53d1\u7968\u91d1\u989d", (String)"BillValidaterHelper_35", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApiResult drawerAndRemarkCheck(BillVo bill, ValidTypeEnum validType) {
        if (StringUtils.isNotBlank((CharSequence)bill.getDrawer()) && (!GBKUtils.checkValidGbk((String)bill.getDrawer()) || GBKUtils.getGBKLength((String)bill.getDrawer()) > 16)) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u5f00\u7968\u4eba[%2$s]\u4e0d\u5408\u6cd5-\u5305\u542b\u975eGBK\u7f16\u7801\u6216\u662f\u8d85\u6700\u5927\u957f\u5ea6[%3$s]\u5b57\u8282", (String)"BillValidaterHelper_36", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), bill.getDrawer(), 16));
        }
        if (!(validType != ValidTypeEnum.INVOICE && bill.getAutoInvoice() != 1 || InvoiceUtils.isAllEInvoice((Object)bill.getInvoiceType()) || AllEleAuthHelper.isElePaper((Object)bill.getIsElePaper()) || !StringUtils.isBlank((CharSequence)bill.getDrawer()))) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u5f00\u7968\u4eba\u5fc5\u586b", (String)"BillValidaterHelper_37", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
        }
        String invoiceType = bill.getInvoiceType();
        if (InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
            if (StringUtils.isNotBlank((CharSequence)bill.getPayee()) && (!GBKUtils.checkValidGbk((String)bill.getPayee()) || String.valueOf(bill.getPayee()).length() > 16)) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u6536\u6b3e\u4eba[%2$s]\u4e0d\u5408\u6cd5-\u5305\u542b\u975eGBK\u7f16\u7801\u6216\u662f\u8d85\u6700\u5927\u957f\u5ea6[%3$s]\u5b57\u7b26", (String)"BillValidaterHelper_38", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), bill.getPayee(), 16));
            }
            if (StringUtils.isNotBlank((CharSequence)bill.getReviewer()) && (!GBKUtils.checkValidGbk((String)bill.getReviewer()) || String.valueOf(bill.getReviewer()).length() > 16)) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u590d\u6838\u4eba[%2$s]\u4e0d\u5408\u6cd5-\u5305\u542b\u975eGBK\u7f16\u7801\u6216\u662f\u8d85\u6700\u5927\u957f\u5ea6[%3$s]\u5b57\u7b26", (String)"BillValidaterHelper_39", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), bill.getReviewer(), 16));
            }
        } else {
            if (StringUtils.isNotBlank((CharSequence)bill.getPayee()) && (!GBKUtils.checkValidGbk((String)bill.getPayee()) || GBKUtils.getGBKLength((String)bill.getPayee()) > 16)) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u6536\u6b3e\u4eba[%2$s]\u4e0d\u5408\u6cd5-\u5305\u542b\u975eGBK\u7f16\u7801\u6216\u662f\u8d85\u6700\u5927\u957f\u5ea6[%3$s]\u5b57\u8282", (String)"BillValidaterHelper_40", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), bill.getPayee(), 16));
            }
            if (StringUtils.isNotBlank((CharSequence)bill.getReviewer()) && (!GBKUtils.checkValidGbk((String)bill.getReviewer()) || GBKUtils.getGBKLength((String)bill.getReviewer()) > 16)) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u590d\u6838\u4eba[%2$s]\u4e0d\u5408\u6cd5-\u5305\u542b\u975eGBK\u7f16\u7801\u6216\u662f\u8d85\u6700\u5927\u957f\u5ea6[%3$s]\u5b57\u8282", (String)"BillValidaterHelper_41", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), bill.getReviewer(), 16));
            }
        }
        if (!StringUtils.isNotBlank((CharSequence)bill.getRemark())) return null;
        if (!GBKUtils.checkValidGbk((String)bill.getRemark())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u53d1\u7968\u5907\u6ce8\u5305\u542b\u975eGBK\u7f16\u7801\u5b57\u7b26", (String)"BillValidaterHelper_42", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
        }
        if (InvoiceUtils.isAllEInvoice((Object)invoiceType) || "1".equals(bill.getIsElePaper())) {
            if (String.valueOf(bill.getRemark()).length() <= 450) return null;
            if (!InvoiceUtils.isCutRemark((Long)bill.getOrgId())) return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u53d1\u7968\u5907\u6ce8[%3$s]\u8d85\u8fc7\u53d1\u7968\u53ef\u5f00\u5177\u6700\u5927\u957f\u5ea6[%2$s]\u5b57\u7b26", (String)"BillValidaterHelper_43", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), 450, bill.getRemark()));
            String billRemark = InvoiceUtils.cutRemarkChar((String)bill.getRemark(), (int)450);
            bill.setRemark(billRemark);
            return null;
        } else {
            if (GBKUtils.getGBKLength((String)bill.getRemark()) <= 230) return null;
            if (!InvoiceUtils.isCutRemark((Long)bill.getOrgId())) return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u53d1\u7968\u5907\u6ce8[%3$s]\u8d85\u8fc7\u53d1\u7968\u53ef\u5f00\u5177\u6700\u5927\u957f\u5ea6[%2$s]\u5b57\u8282", (String)"BillValidaterHelper_44", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), 230, bill.getRemark()));
            String remark = GBKUtils.cutGBKString((String)bill.getRemark(), (int)230);
            bill.setRemark(remark);
        }
        return null;
    }

    public static ApiResult validBillBuyer(BillVo bill, ValidTypeEnum validType) {
        String invoiceType = bill.getInvoiceType();
        if (StringUtils.isBlank((CharSequence)bill.getBuyerName()) && !"5".equals(bill.getBillSource()) && bill.getAutoInvoice() == 1) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BUYER_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u8d2d\u65b9\u540d\u79f0\u672a\u4f20\u5165", (String)"BillValidaterHelper_50", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
        }
        if (!GBKUtils.checkValidGbk((String)bill.getBuyerName())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BUYER_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u8d2d\u65b9\u540d\u79f0[%2$s]\u5305\u542b\u975eGBK\u7f16\u7801\u5b57\u7b26", (String)"BillValidaterHelper_51", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), bill.getBuyerName()));
        }
        if (InvoiceType.checkIsTaxInvoice((String)invoiceType) && GBKUtils.getGBKLength((String)bill.getBuyerName()) > 100) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BUYER_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u8d2d\u65b9\u540d\u79f0[%2$s]\u8d85\u8fc7\u53d1\u7968\u53ef\u5f00\u5177\u6700\u5927\u957f\u5ea6[%3$s]\u5b57\u8282", (String)"BillValidaterHelper_52", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), bill.getBuyerName(), 100));
        }
        int buyerProperty = bill.getBuyerProperty();
        if (StringUtils.isNotBlank((CharSequence)bill.getBuyerBankAndAccount())) {
            if (!GBKUtils.checkValidGbk((String)bill.getBuyerBankAndAccount())) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BUYER_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u8d2d\u65b9\u94f6\u884c\u8d26\u53f7[%2$s]\u5305\u542b\u975eGBK\u7f16\u7801\u5b57\u7b26", (String)"BillValidaterHelper_55", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), bill.getBuyerBankAndAccount()));
            }
            if (InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
                if (String.valueOf(bill.getBuyerBankAndAccount()).length() > 150) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BUYER_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u8d2d\u65b9\u94f6\u884c\u8d26\u53f7[%2$s]\u8d85\u8fc7\u53d1\u7968\u53ef\u5f00\u5177\u6700\u5927\u957f\u5ea6[%3$s]\u5b57\u7b26", (String)"BillValidaterHelper_56", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), bill.getBuyerBankAndAccount(), 150));
                }
            } else if (InvoiceType.checkIsTaxInvoice((String)invoiceType) && GBKUtils.getGBKLength((String)bill.getBuyerBankAndAccount()) > 100) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BUYER_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u8d2d\u65b9\u94f6\u884c\u8d26\u53f7[%2$s]\u8d85\u8fc7\u53d1\u7968\u53ef\u5f00\u5177\u6700\u5927\u957f\u5ea6[%3$s]\u5b57\u8282", (String)"BillValidaterHelper_57", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), bill.getBuyerBankAndAccount(), 100));
            }
        } else if ((validType == ValidTypeEnum.INVOICE || bill.getAutoInvoice() == 1) && buyerProperty == 0 && (InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode().equals(bill.getInvoiceType()) || InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode().equals(bill.getInvoiceType()))) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BUYER_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u5f00\u5177\u4e13\u7528\u53d1\u7968\u8d2d\u65b9\u94f6\u884c\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillValidaterHelper_58", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
        }
        if (StringUtils.isNotBlank((CharSequence)bill.getBuyerAddressAndTel())) {
            if (!GBKUtils.checkValidGbk((String)bill.getBuyerAddressAndTel())) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BUYER_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u8d2d\u65b9\u5730\u5740\u7535\u8bdd[%2$s]\u5305\u542b\u975eGBK\u7f16\u7801\u5b57\u7b26", (String)"BillValidaterHelper_59", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), bill.getBuyerAddressAndTel()));
            }
            if (InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
                if (String.valueOf(bill.getBuyerAddressAndTel()).length() > 120) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BUYER_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u8d2d\u65b9\u5730\u5740\u7535\u8bdd[%2$s]\u8d85\u8fc7\u53d1\u7968\u53ef\u5f00\u5177\u6700\u5927\u957f\u5ea6[%3$s]\u5b57\u7b26", (String)"BillValidaterHelper_60", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), bill.getBuyerAddressAndTel(), 120));
                }
            } else if (InvoiceType.checkIsTaxInvoice((String)invoiceType) && GBKUtils.getGBKLength((String)bill.getBuyerAddressAndTel()) > 100) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BUYER_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u8d2d\u65b9\u5730\u5740\u7535\u8bdd[%2$s]\u8d85\u8fc7\u53d1\u7968\u53ef\u5f00\u5177\u6700\u5927\u957f\u5ea6[%3$s]\u5b57\u8282", (String)"BillValidaterHelper_61", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), bill.getBuyerAddressAndTel(), 100));
            }
        } else if ((validType == ValidTypeEnum.INVOICE || bill.getAutoInvoice() == 1) && buyerProperty == 0 && (InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode().equals(bill.getInvoiceType()) || InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode().equals(bill.getInvoiceType()))) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BUYER_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u5f00\u5177\u4e13\u7528\u53d1\u7968\u8d2d\u65b9\u5730\u5740\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillValidaterHelper_62", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
        }
        return ResponseVo.success((String)"");
    }

    public static ApiResult validBillSeller(BillVo bill, DynamicObject seller, DynamicObject sellerInvoiceSetting, ValidTypeEnum validType) {
        String invoiceType = bill.getInvoiceType();
        if (StringUtils.isBlank((CharSequence)bill.getSellerTaxpayerId())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_TAXPAYERID_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u9500\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillValidaterHelper_63", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
        }
        if (validType == ValidTypeEnum.BILL && null != seller && StringUtils.isNotBlank((CharSequence)seller.getString("name"))) {
            bill.setSellerName(seller.getString("name"));
        }
        if (StringUtils.isNotBlank((CharSequence)bill.getSellerName())) {
            if (!GBKUtils.checkValidGbk((String)bill.getSellerName())) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_SELLER_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u9500\u65b9\u540d\u79f0[%2$s]\u5305\u542b\u975eGBK\u7f16\u7801\u5b57\u7b26", (String)"BillValidaterHelper_64", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), bill.getSellerName()));
            }
            if (InvoiceType.checkIsTaxInvoice((String)invoiceType) && GBKUtils.getGBKLength((String)bill.getSellerName()) > 100) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_SELLER_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u9500\u65b9\u540d\u79f0[%2$s]\u8d85\u8fc7\u53d1\u7968\u53ef\u5f00\u5177\u6700\u5927\u957f\u5ea6[%3$s]\u5b57\u8282", (String)"BillValidaterHelper_65", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), bill.getSellerName(), 100));
            }
        } else if (validType == ValidTypeEnum.INVOICE || bill.getAutoInvoice() == 1) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_SELLER_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u9500\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillValidaterHelper_66", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
        }
        if (validType == ValidTypeEnum.BILL && StringUtils.isBlank((CharSequence)bill.getSellerAddressAndTel()) && null != sellerInvoiceSetting) {
            bill.setSellerAddressAndTel(StringUtils.isBlank((CharSequence)sellerInvoiceSetting.getString("invoiceaddr")) ? "" : sellerInvoiceSetting.getString("invoiceaddr"));
        }
        if (validType == ValidTypeEnum.BILL && StringUtils.isBlank((CharSequence)bill.getSellerBankAndAccount()) && null != sellerInvoiceSetting) {
            bill.setSellerBankAndAccount(StringUtils.isBlank((CharSequence)sellerInvoiceSetting.getString("openuserbank")) ? "" : sellerInvoiceSetting.getString("openuserbank"));
        }
        if (StringUtils.isNotBlank((CharSequence)bill.getSellerBankAndAccount())) {
            if (!GBKUtils.checkValidGbk((String)bill.getSellerBankAndAccount())) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_SELLER_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u9500\u65b9\u94f6\u884c\u8d26\u53f7[%2$s]\u5305\u542b\u975eGBK\u7f16\u7801\u5b57\u7b26", (String)"BillValidaterHelper_67", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), bill.getSellerBankAndAccount()));
            }
            if (InvoiceType.checkIsTaxInvoice((String)invoiceType) && GBKUtils.getGBKLength((String)bill.getSellerBankAndAccount()) > 100) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_SELLER_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u9500\u65b9\u94f6\u884c\u8d26\u53f7[%2$s]\u8d85\u8fc7\u53d1\u7968\u53ef\u5f00\u5177\u6700\u5927\u957f\u5ea6[%3$s]\u5b57\u8282", (String)"BillValidaterHelper_68", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), bill.getSellerBankAndAccount(), 100));
            }
        } else if (!(bill.getAutoInvoice() != 1 || InvoiceUtils.isAllEInvoice((Object)bill.getInvoiceType()) && EnterpriseHelper.isLqptChannel((String)bill.getSellerTaxpayerId()))) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_SELLER_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u9500\u65b9\u540d\u79f0\u94f6\u884c\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillValidaterHelper_69", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
        }
        if (StringUtils.isNotBlank((CharSequence)bill.getSellerAddressAndTel())) {
            if (!GBKUtils.checkValidGbk((String)bill.getSellerAddressAndTel())) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_SELLER_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u9500\u65b9\u5730\u5740\u7535\u8bdd[%2$s]\u5305\u542b\u975eGBK\u7f16\u7801\u5b57\u7b26", (String)"BillValidaterHelper_70", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), bill.getSellerAddressAndTel()));
            }
            if (InvoiceType.checkIsTaxInvoice((String)invoiceType) && GBKUtils.getGBKLength((String)bill.getSellerAddressAndTel()) > 100) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_SELLER_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u9500\u65b9\u5730\u5740\u7535\u8bdd[%2$s]\u8d85\u8fc7\u53d1\u7968\u53ef\u5f00\u5177\u6700\u5927\u957f\u5ea6[%3$s]\u5b57\u8282", (String)"BillValidaterHelper_71", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), bill.getSellerAddressAndTel(), 100));
            }
        } else if (!(validType != ValidTypeEnum.INVOICE && bill.getAutoInvoice() != 1 || InvoiceUtils.isAllEInvoice((Object)bill.getInvoiceType()) && EnterpriseHelper.isLqptChannel((String)bill.getSellerTaxpayerId()))) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_SELLER_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u9500\u65b9\u5730\u5740\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillValidaterHelper_72", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
        }
        return ResponseVo.success((String)"");
    }

    public static ApiResult validBillDetailEntrance(BillVo bill, ValidTypeEnum validType) {
        if (null == bill.getBillDetail() || bill.getBillDetail().isEmpty()) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u660e\u7ec6\u6570\u636e\u672a\u4f20\u5165", (String)"BillValidaterHelper_10", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
        }
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalTaxAmount = BigDecimal.ZERO;
        BigDecimal includeTaxAmount = BigDecimal.ZERO;
        int inx = 1;
        DynamicObject issueInvSetting = validType == ValidTypeEnum.BILL ? IssueInvSettingHelper.getIssueInvSetting((Long)bill.getOrgId()) : IssueInvSettingHelper.getDefaultIssueInvSetting((Long)bill.getOrgId());
        bill.setNormalRowCheck(InvoiceUtils.normalRowCheck());
        bill.setCheckAmountDiff(BillValidaterHelper.isCheckAmountDiff001(bill));
        bill.setNotCheckTaxDiff(BillValidaterHelper.isCheckTaxDiff006(bill));
        for (int i = 0; i < bill.getBillDetail().size(); ++i) {
            ApiResult validResult;
            BillDetailVo detail = (BillDetailVo)bill.getBillDetail().get(i);
            if (validType == ValidTypeEnum.BILL) {
                detail.setDetailRowNo(i);
            }
            if (!(validResult = BillValidaterHelper.validBillDetail(bill, detail, i, inx, validType, issueInvSetting)).getSuccess()) {
                return validResult;
            }
            if (null != detail.getGift() && detail.getGift().booleanValue()) {
                if (StringUtils.isBlank((CharSequence)detail.getQuantity())) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)" \u7b2c%d\u884c\u8d60\u54c1\u884c\u6570\u91cf\u4e0d\u80fd\u4e3a0", (String)"BillValidaterHelper_73", (String)"imc-sim-service", (Object[])new Object[0]), i + 1));
                }
                ++inx;
                continue;
            }
            if (validType == ValidTypeEnum.BILL && null != detail.getDiscountAmount() && detail.getDiscountAmount().compareTo(BigDecimal.ZERO) != 0) {
                BillDetailVo discountLine = new BillDetailVo(detail.getGoodsName(), detail.getDiscountAmount(), detail.getTaxRate(), detail.getDiscountTaxAmount(), detail.getRevenueCode(), detail.getRevenueName(), detail.getPrivilegeFlag().intValue(), detail.getPrivilegeContent(), bill.getIncludeTaxFlag());
                discountLine.setTaxCodeId(detail.getTaxCodeId());
                discountLine.setBillSourceId(detail.getBillSourceId());
                discountLine.setDetailRowNo(i + 1);
                discountLine.setCoalTypeCode(detail.getCoalTypeCode());
                bill.getBillDetail().add(i + 1, discountLine);
                ++i;
                totalAmount = totalAmount.add(discountLine.getAmount());
                totalTaxAmount = totalTaxAmount.add(discountLine.getTaxAmount());
                includeTaxAmount = includeTaxAmount.add(discountLine.getIncludeTaxAmount());
                detail.setDiscountAmount(BigDecimal.ZERO);
                detail.setDiscountTaxAmount(BigDecimal.ZERO);
                detail.setDiscountRate("");
            }
            totalAmount = totalAmount.add(detail.getAmount().setScale(2, RoundingMode.HALF_UP));
            totalTaxAmount = totalTaxAmount.add(detail.getTaxAmount().setScale(2, RoundingMode.HALF_UP));
            includeTaxAmount = includeTaxAmount.add(detail.getIncludeTaxAmount().setScale(2, RoundingMode.HALF_UP));
            detail.setGoodsName(detail.getGoodsName().trim());
            ++inx;
        }
        totalTaxAmount = totalTaxAmount.setScale(2, RoundingMode.HALF_UP);
        includeTaxAmount = includeTaxAmount.setScale(2, RoundingMode.HALF_UP);
        totalAmount = totalAmount.setScale(2, RoundingMode.HALF_UP);
        if (validType == ValidTypeEnum.BILL) {
            if (bill.getIncludeTaxFlag() == 1) {
                if (MathUtils.isZero((BigDecimal)bill.getIncludeTaxAmount())) {
                    bill.setIncludeTaxAmount(bill.getTotalAmount());
                    bill.setTotalAmount(bill.getIncludeTaxAmount().subtract(totalTaxAmount));
                }
                if (!MathUtils.isZero((BigDecimal)bill.getIncludeTaxAmount()) && bill.getIncludeTaxAmount().compareTo(includeTaxAmount) != 0) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u660e\u7ec6\u5408\u8ba1\u542b\u7a0e\u91d1\u989d\u4e0e\u4f20\u5165\u5355\u636e\u5408\u8ba1\u542b\u7a0e\u91d1\u989d\u4e0d\u4e00\u81f4", (String)"BillValidaterHelper_74", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
                }
            }
            if (bill.getIncludeTaxFlag() == 0 && !MathUtils.isZero((BigDecimal)bill.getTotalAmount()) && bill.getTotalAmount().compareTo(totalAmount) != 0) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u660e\u7ec6\u5408\u8ba1\u91d1\u989d\u4e0e\u4f20\u5165\u5355\u636e\u5408\u8ba1\u91d1\u989d\u4e0d\u4e00\u81f4", (String)"BillValidaterHelper_75", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
            }
            if (!MathUtils.isZero((BigDecimal)bill.getTotalTaxAmount()) && bill.getTotalTaxAmount().compareTo(totalTaxAmount) != 0) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u660e\u7ec6\u5408\u8ba1\u7a0e\u989d\u4e0e\u4f20\u5165\u5355\u636e\u5408\u8ba1\u7a0e\u989d\u4e0d\u4e00\u81f4", (String)"BillValidaterHelper_76", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
            }
            bill.setTotalAmount(totalAmount);
            bill.setTotalTaxAmount(totalTaxAmount);
            bill.setIncludeTaxAmount(includeTaxAmount);
            bill.setOriginalIncludeTaxAmount(includeTaxAmount);
        } else if (bill.getTotalAmount().compareTo(totalAmount) != 0 || bill.getIncludeTaxAmount().compareTo(includeTaxAmount) != 0 || bill.getTotalTaxAmount().compareTo(totalTaxAmount) != 0) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u660e\u7ec6\u5408\u8ba1\u91d1\u989d\u4e0e\u4f20\u5165\u5408\u8ba1\u91d1\u989d\u4e0d\u4e00\u81f4", (String)"BillValidaterHelper_77", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
        }
        return ResponseVo.success((String)"");
    }

    public static Map<Object, List<DynamicObject>> getSettingByTaxNo(Set<String> taxNoSet) {
        QFilter qFilter = new QFilter("taxno", "in", taxNoSet);
        DynamicObject[] settings = BusinessDataServiceHelper.load((String)"sim_invoice_setting", (String)String.join((CharSequence)",", "taxno", "invoiceaddr", "openuserbank", "filter_tag", "ischeck", "shop_no"), (QFilter[])qFilter.toArray());
        Map<Object, List<DynamicObject>> settingMap = Stream.of(settings).collect(Collectors.groupingBy(e -> e.get("taxno")));
        settingMap.forEach((k, v) -> v.sort(Comparator.comparing(o -> o.getString("ischeck"))));
        return settingMap;
    }

    public static void setSaleInfoByTaxNo(List<Map<String, Object>> bills, SaleAddrAndPayeeDTO saleAddrAndPayee) {
        HashSet<String> taxNoSet = new HashSet<String>(Collections.singletonList(saleAddrAndPayee.getSaleTaxNo()));
        Map<Object, List<DynamicObject>> settingByTaxNo = BillValidaterHelper.getSettingByTaxNo(taxNoSet);
        BillMatchHelper billMatchHelper = new BillMatchHelper();
        Map<String, Object> billMap = bills.get(0);
        DynamicObject billHead = BusinessDataServiceHelper.newDynamicObject((String)"sim_original_bill");
        DynamicObjectUtil.map2DynamicObject(billMap, (DynamicObject)billHead);
        List settings = settingByTaxNo.getOrDefault(saleAddrAndPayee.getSaleTaxNo(), new ArrayList(1));
        billMatchHelper.matchSalerAddrAndBank(billHead, settings.toArray(new DynamicObject[0]));
        for (Map<String, Object> bill : bills) {
            bill.put("salertaxno", saleAddrAndPayee.getSaleTaxNo());
            bill.put("salername", saleAddrAndPayee.getSaleName());
            if (StringUtils.isBlank((Object)bill.get("salerbank"))) {
                bill.put("salerbank", billHead.getString("salerbank"));
            }
            if (!StringUtils.isBlank((Object)bill.get("saleraddr"))) continue;
            bill.put("saleraddr", billHead.getString("saleraddr"));
        }
    }

    public static void setSaleInfoByTaxNo(List<BillVo> bills) {
        try {
            HashSet<String> taxNoSet = new HashSet<String>(bills.size());
            for (BillVo bill : bills) {
                taxNoSet.add(bill.getSellerTaxpayerId());
            }
            Map<Object, List<DynamicObject>> settingByTaxNo = BillValidaterHelper.getSettingByTaxNo(taxNoSet);
            LOGGER.info(String.format("BillValidaterHelper setSaleInfoByTaxNo settingByTaxNo:%s ,taxNoSet:%s", SerializationUtils.toJsonString(settingByTaxNo), SerializationUtils.toJsonString(taxNoSet)));
            BillMatchHelper billMatchHelper = new BillMatchHelper();
            for (BillVo billVo : bills) {
                DynamicObject bill = BusinessDataServiceHelper.newDynamicObject((String)"sim_original_bill");
                DynamicObjectUtil.bean2DynamicObject((Object)billVo, (DynamicObject)bill);
                List settings = settingByTaxNo.getOrDefault(billVo.getSellerTaxpayerId(), new ArrayList(1));
                billMatchHelper.matchSalerAddrAndBank(bill, settings.toArray(new DynamicObject[0]));
                if (StringUtils.isBlank((CharSequence)billVo.getSellerBankAndAccount())) {
                    billVo.setSellerBankAndAccount(bill.getString("salerbank"));
                }
                if (!StringUtils.isBlank((CharSequence)billVo.getSellerAddressAndTel())) continue;
                billVo.setSellerAddressAndTel(bill.getString("saleraddr"));
            }
        }
        catch (Exception e) {
            LOGGER.info(String.format("\u5339\u914d\u9500\u65b9\u62ac\u5934\u51fa\u9519:%s", e));
        }
    }

    public static void setSaleInfo(DynamicObject bill) {
        HashSet<String> taxNoSet = new HashSet<String>(1);
        taxNoSet.add(bill.getString("salertaxno"));
        Map<Object, List<DynamicObject>> settingByTaxNo = BillValidaterHelper.getSettingByTaxNo(taxNoSet);
        List settings = settingByTaxNo.getOrDefault(bill.getString("salertaxno"), new ArrayList(1));
        BillMatchHelper billMatchHelper = new BillMatchHelper();
        billMatchHelper.matchSalerAddrAndBank(bill, settings.toArray(new DynamicObject[0]));
    }

    private static void setDetailGoods(BillDetailVo detailGoods, DynamicObject goods) {
        if (null != goods.get("taxcode.number")) {
            detailGoods.setRevenueCode(goods.getString("taxcode.number"));
        }
        if (null != goods.get("privilegeflag")) {
            detailGoods.setPrivilegeFlag(Integer.valueOf(goods.getInt("privilegeflag")));
        }
        if (null != goods.get("privilegetype")) {
            detailGoods.setPrivilegeContent(goods.getString("privilegeflag"));
        }
        if (null != goods.get("specifications")) {
            detailGoods.setSpecification(goods.getString("specifications"));
        }
    }

    public static ApiResult validBillDetail(BillVo bill, BillDetailVo detail, int i, int index, ValidTypeEnum validType, DynamicObject issueInvSetting) {
        try {
            if (detail == null) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillValidaterHelper_78", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index));
            }
            if (detail.getLineProperty() == 0) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u6027\u8d28\u4e0d\u652f\u6301", (String)"BillValidaterHelper_79", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index));
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getBillSourceId()) && (detail.getBillSourceId().length() > 50 || !detail.getBillSourceId().matches(billNoReg))) {
                if (detail.getBillSourceId().length() > 50) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_ITEM_DETAILID_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u7f16\u53f7\u8d85\u8fc7\u6700\u5927\u957f\u5ea6[%3$s]", (String)"BillValidaterHelper_80", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index, 50));
                }
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_ITEM_DETAILID_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u7f16\u53f7\u4f20\u5165\u4e0d\u5408\u6cd5\uff0c\u53ea\u80fd\u5305\u542b\u6570\u5b57\u3001\u5b57\u7b26\u53ca\u4e0b\u5212\u7ebf", (String)"BillValidaterHelper_81", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index));
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getLineRemark()) && (!GBKUtils.checkValidGbk((String)detail.getLineRemark()) || GBKUtils.getGBKLength((String)detail.getLineRemark()) > 200)) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_ITEM_DETAILID_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u884c\u5907\u6ce8[%3$s]\u5305\u542b\u975eGBK\u7f16\u7801\u6216\u8d85\u8fc7\u6700\u5927\u5b57\u8282\u957f\u5ea6[%4$s]", (String)"BillValidaterHelper_82", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index, detail.getLineRemark(), 200));
            }
            BillValidaterHelper.checkGoodsName(bill, detail, index);
            BillValidaterHelper.checkSpecificationAndUnit(bill, detail, index, issueInvSetting);
            BillValidaterHelper.checkVehicleItem(bill, detail, i);
            BillValidaterHelper.checkTaxRate(bill, detail, index);
            BillValidaterHelper.checkPrivilegeFlag(bill, detail, index);
            if (validType == ValidTypeEnum.BILL) {
                if (!MathUtils.isNullOrZero((BigDecimal)detail.getAmount())) {
                    detail.setAmount(detail.getAmount().setScale(2, 4));
                }
                if (!MathUtils.isNullOrZero((BigDecimal)detail.getTaxAmount())) {
                    detail.setTaxAmount(detail.getTaxAmount().setScale(2, 4));
                }
                if (!MathUtils.isNullOrZero((BigDecimal)detail.getDiscountAmount())) {
                    detail.setDiscountAmount(detail.getDiscountAmount().setScale(2, 4));
                }
            }
            if (detail.getLineProperty() == 1) {
                try {
                    BillValidaterHelper.checkDiscountRow(bill, detail, i, index, validType);
                }
                catch (KDBizException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)e.getMessage());
                }
                BillPushSetValueHelper.clearAndFillDiscountData((BillVo)bill, (BillDetailVo)detail, (int)i);
            }
            BillValidaterHelper.checkAmountPriceQuanlity(bill, detail, index);
            if (validType == ValidTypeEnum.BILL && (null != detail.getDiscountAmount() && detail.getDiscountAmount().compareTo(BigDecimal.ZERO) != 0 || StringUtils.isNotBlank((CharSequence)detail.getDiscountRate()) && !"0E-10".equals(detail.getDiscountRate()) && !"0".equals(detail.getDiscountRate()))) {
                if (!(null != detail.getDiscountAmount() && detail.getDiscountAmount().compareTo(BigDecimal.ZERO) != 0 || "0E-10".equals(detail.getDiscountRate()) || "0".equals(detail.getDiscountRate()))) {
                    if (!RegexUtil.isFloatLargeZero((String)detail.getDiscountRate().replaceAll("%", ""))) {
                        return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u6298\u6263\u7387[%3$s]\u4e0d\u5408\u6cd5", (String)"BillValidaterHelper_83", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index, detail.getDiscountRate()));
                    }
                    BigDecimal discountAmount = detail.getDiscountRate().contains("%") || RegexUtil.isInteger((String)detail.getDiscountRate()) ? detail.getAmount().multiply(new BigDecimal(detail.getDiscountRate().replaceAll("%", ""))).divide(new BigDecimal("100"), 2, 4) : detail.getAmount().multiply(new BigDecimal(detail.getDiscountRate())).setScale(2, 4);
                    detail.setDiscountRate("");
                    detail.setDiscountAmount(discountAmount);
                }
                if (detail.getAmount().compareTo(detail.getDiscountAmount().abs()) < 0) {
                    if (MathUtils.isZero((BigDecimal)detail.getAmount())) {
                        throw new MsgException(ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u91d1\u989d\u4e3a0\u65f6\uff0c\u4e0d\u80fd\u586b\u5199\u6298\u6263", (String)"BillValidaterHelper_84", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index));
                    }
                    throw new MsgException(ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u6298\u6263\u91d1\u989d\u5927\u4e8e\u5546\u54c1\u91d1\u989d", (String)"BillValidaterHelper_85", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getRevenueCode())) {
                DynamicObject revenueCode;
                if (detail.getRevenueCode().length() <= 19) {
                    detail.setRevenueCode(BillValidaterHelper.paddingRevenueCode(detail.getRevenueCode()));
                }
                if (null == (revenueCode = TaxClassCodeCheckHelper.geTaxCode((String)detail.getRevenueCode()))) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u5206\u7c7b\u7f16\u7801[%3$s]\u4e0d\u6b63\u786e", (String)"BillValidaterHelper_86", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index, detail.getRevenueCode()));
                }
                detail.setRevenueName(revenueCode.getString("simplename"));
                detail.setTaxCodeId(Long.valueOf(DynamicObjectUtil.getDynamicObjectLongValue((Object)revenueCode)));
            } else if (validType == ValidTypeEnum.INVOICE) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u5206\u7c7b\u7f16\u7801\u672a\u4f20\u5165\u6216\u4e0d\u6b63\u786e", (String)"BillValidaterHelper_87", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index));
            }
            if (validType == ValidTypeEnum.INVOICE || bill.getIncludeTaxFlag() == 1) {
                if (!GBKUtils.checkValidGbk((String)("*" + detail.getRevenueName() + "*" + detail.getGoodsName()))) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u5546\u54c1\u540d\u79f0[%3$s]\u5305\u542b\u975eGBK\u7f16\u7801\u5b57\u7b26", (String)"BillValidaterHelper_88", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index, "*" + detail.getRevenueName() + "*" + detail.getGoodsName()));
                }
                String gName = "*" + detail.getRevenueName() + "*" + detail.getGoodsName();
                if (InvoiceType.ALL_E_SPECIAL.getTypeCode().equals(bill.getInvoiceType()) || InvoiceType.ALL_E_NORMAL.getTypeCode().equals(bill.getInvoiceType())) {
                    if (detail.getGoodsName() != null && detail.getGoodsName().length() > 100) {
                        return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u5546\u54c1\u540d\u79f0[%3$s]\u8d85\u8fc7\u6700\u5927\u5b57\u7b26\u6570[%4$s]", (String)"BillValidaterHelper_139", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index, gName, 100));
                    }
                } else if (GBKUtils.getGBKLength((String)gName) > 92 && BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_SPLIT.getValue().equals(issueInvSetting.getString("fieldtolong"))) {
                    detail.setGoodsName(GBKUtils.cutGBKString((String)gName, (int)92));
                } else if (GBKUtils.getGBKLength((String)gName) > 92 && BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_HINT.getValue().equals(issueInvSetting.getString("fieldtolong"))) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u5546\u54c1\u540d\u79f0[%3$s]\u8d85\u8fc7\u6700\u5927\u5b57\u8282\u6570[%4$s]", (String)"BillValidaterHelper_89", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index, gName, 92));
                }
            }
            if (TaxedTypeEnum.deduction.getValue().equals(bill.getTaxationStyle()) && !"KINGDEE_FI".equals(bill.getSystemSource()) && (index > 2 || index == 2 && detail.getLineProperty() != 1)) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u5dee\u989d\u53d1\u7968\u660e\u7ec6\u53ea\u80fd\u6709\u4e00\u884c", (String)"BillValidaterHelper_90", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
            }
            if (detail.getLineProperty() != 1 && detail.getLineProperty() != 2) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u884c\u6027\u8d28\u4e0d\u5408\u6cd5[1-\u6298\u6263\u884c\uff0c2-\u6b63\u5e38\u5546\u54c1\u884c]", (String)"BillValidaterHelper_91", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index));
            }
            if (bill.isNormalRowCheck() && validType == ValidTypeEnum.INVOICE && detail.getLineProperty() == 1) {
                if (index <= 1) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u9996\u884c\u660e\u7ec6\u4e0d\u80fd\u4e3a\u6298\u6263\u884c", (String)"BillValidaterHelper_92", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
                }
                if (((BillDetailVo)bill.getBillDetail().get(index - 2)).getLineProperty() != 2) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u4e3a\u6298\u6263\u884c\u5bf9\u5e94\u7684\u88ab\u6298\u6263\u884c\u884c\u6027\u8d28\u4e0d\u6b63\u786e", (String)"BillValidaterHelper_93", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
                }
            }
            if (validType == ValidTypeEnum.BILL) {
                detail.setOriUnitPrice(detail.getPrice());
                if (bill.getIncludeTaxFlag() == 1) {
                    BillPushSetValueHelper.setDetailHS((BillVo)bill, (BillDetailVo)detail, (int)index);
                } else {
                    BillPushSetValueHelper.setDetailBHS((BillVo)bill, (BillDetailVo)detail, (int)index);
                }
            } else {
                if (null == detail.getTaxAmount()) {
                    detail.setTaxAmount(BigDecimal.ZERO);
                }
                if (detail.getIncludeTaxAmount().subtract(detail.getTaxAmount()).setScale(2, RoundingMode.HALF_UP).compareTo(detail.getAmount()) != 0) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u91d1\u989d+\u7a0e\u989d\u4e0e\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u4e00\u81f4", (String)"BillValidaterHelper_94", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index));
                }
            }
            if (bill.getBillProperty() == -1 && (null != detail.getDiscountAmount() && detail.getDiscountAmount().compareTo(BigDecimal.ZERO) != 0 || detail.getLineProperty() == 0 || detail.getLineProperty() == 1)) {
                return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u4e3a\u8d1f\u6570\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u6709\u6298\u6263\u884c", (String)"BillValidaterHelper_95", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
            }
            detail.setAmount(detail.getAmount().setScale(2, 4));
            detail.setTaxAmount(detail.getTaxAmount().setScale(2, 4));
            detail.setIncludeTaxAmount(detail.getIncludeTaxAmount().setScale(2, 4));
            BillValidaterHelper.checkZSFS(bill, detail, index);
            if (bill.getIncludeTaxFlag() == 1) {
                BillPushSetValueHelper.setRemainAmount((BillDetailVo)detail, (BigDecimal)detail.getIncludeTaxAmount());
            } else {
                BillPushSetValueHelper.setRemainAmount((BillDetailVo)detail, (BigDecimal)detail.getAmount());
            }
        }
        catch (MsgException msgException) {
            LOGGER.error(msgException.getErrorMsg(), (Throwable)msgException);
            return ResponseVo.fail((String)msgException.getErrorCode(), (String)msgException.getErrorMsg());
        }
        return ResponseVo.success((String)"");
    }

    private static void checkAmountPriceQuanlity(BillVo bill, BillDetailVo detail, int index) {
        boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)bill.getInvoiceType()) || "1".equals(bill.getIsElePaper());
        String quantityStr = detail.getQuantity();
        String priceStr = detail.getPrice();
        if (MathUtils.isNullOrZero((BigDecimal)detail.getAmount()) && StringUtils.isNotBlank((CharSequence)quantityStr) && StringUtils.isNotBlank((CharSequence)priceStr)) {
            detail.setAmount(new BigDecimal(priceStr).multiply(new BigDecimal(quantityStr)).setScale(2, 4));
        } else if (!MathUtils.isNullOrZero((BigDecimal)detail.getAmount()) && StringUtils.isNotBlank((CharSequence)quantityStr) && StringUtils.isNotBlank((CharSequence)priceStr)) {
            detail.setQuantity(BillValidaterHelper.getQuantityByAmount(detail.getAmount(), quantityStr));
            BigDecimal amount = new BigDecimal(detail.getQuantity()).multiply(new BigDecimal(priceStr)).setScale(2, 4);
            BigDecimal abs = amount.subtract(detail.getAmount()).abs();
            if (bill.isCheckAmountDiff() && abs.compareTo(InvoiceConstant.DIFF_01) > 0) {
                throw new MsgException(ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u5546\u54c1\u5355\u4ef7*\u6570\u91cf[%3$s]\u4e0e\u91d1\u989d[%4$s]\u8bef\u5dee\u5927\u4e8e0.01", (String)"BillValidaterHelper_96", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index, amount, detail.getAmount()));
            }
        } else {
            if (!MathUtils.isNullOrZero((BigDecimal)detail.getAmount()) && StringUtils.isNotBlank((CharSequence)quantityStr) && StringUtils.isBlank((CharSequence)priceStr)) {
                try {
                    detail.setQuantity(BillValidaterHelper.getQuantityByAmount(detail.getAmount(), quantityStr));
                    BigDecimal price = PriceHelper.calcPriceOrNum((BigDecimal)detail.getAmount(), (BigDecimal)new BigDecimal(detail.getQuantity()), (boolean)isAllEle);
                    detail.setPrice(price.toPlainString());
                }
                catch (KDBizException e) {
                    throw new MsgException(ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c[%3$s]", (String)"BillValidaterHelper_97", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index, e.getMessage()));
                }
            }
            if (!MathUtils.isNullOrZero((BigDecimal)detail.getAmount()) && StringUtils.isBlank((CharSequence)quantityStr) && StringUtils.isNotBlank((CharSequence)priceStr)) {
                try {
                    BigDecimal quantity = UnitPriceHelper.calcNum((BigDecimal)detail.getAmount(), (BigDecimal)new BigDecimal(priceStr));
                    detail.setQuantity(quantity.toPlainString());
                }
                catch (KDBizException e) {
                    throw new MsgException(ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c[%3$s]", (String)"BillValidaterHelper_97", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index, e.getMessage()));
                }
            }
        }
    }

    private static String getQuantityByAmount(BigDecimal amount, String quantityStr) {
        if (amount.compareTo(BigDecimal.ZERO) > 0) {
            if (quantityStr.startsWith("-")) {
                return quantityStr.replaceFirst("-", "");
            }
            return quantityStr;
        }
        if (!quantityStr.startsWith("-")) {
            return "-" + quantityStr;
        }
        return quantityStr;
    }

    private static void checkDiscountRow(BillVo bill, BillDetailVo detail, int i, int index, ValidTypeEnum validType) {
        boolean normalCheck = bill.isNormalRowCheck();
        if (normalCheck && i == 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u7b2c\u4e00\u884c\u4e0d\u5141\u8bb8\u4e3a\u6298\u6263\u884c", (String)"BillValidaterHelper_98", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
        }
        BillDetailVo preDetail = null;
        if (normalCheck) {
            preDetail = (BillDetailVo)bill.getBillDetail().get(i - 1);
        }
        if (normalCheck && preDetail != null && preDetail.getLineProperty() == 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u6298\u6263\u884c\u4e0a\u4e00\u884c\u4e0d\u80fd\u4e3a\u6298\u6263\u884c", (String)"BillValidaterHelper_99", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index));
        }
        if (normalCheck && preDetail != null && validType == ValidTypeEnum.BILL && !MathUtils.isNullOrZero((BigDecimal)preDetail.getDiscountAmount())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u6298\u6263\u884c\u4e0a\u4e00\u884c\u6298\u6263\u91d1\u989d\u4e0d\u80fd\u6709\u503c", (String)"BillValidaterHelper_100", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index));
        }
        if (MathUtils.isNullOrZero((BigDecimal)detail.getAmount())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u6298\u6263\u884c\u91d1\u989d\u4e0d\u80fd\u4e3a0", (String)"BillValidaterHelper_101", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index));
        }
        if (detail.getAmount().compareTo(BigDecimal.ZERO) > 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u6298\u6263\u884c\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e0", (String)"BillValidaterHelper_102", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index));
        }
        if (normalCheck && preDetail != null && MathUtils.isNullOrZero((BigDecimal)preDetail.getAmount())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u6298\u6263\u884c\u4e0a\u4e00\u884c\u91d1\u989d\u4e0d\u80fd\u4e3a0", (String)"BillValidaterHelper_103", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index));
        }
        if (bill.getIncludeTaxFlag() == 1 && preDetail != null ? normalCheck && detail.getAmount().abs().compareTo(preDetail.getIncludeTaxAmount().abs()) > 0 : preDetail != null && normalCheck && detail.getAmount().abs().compareTo(preDetail.getAmount().abs()) > 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u6298\u6263\u884c\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u4e0a\u4e00\u884c", (String)"BillValidaterHelper_104", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index));
        }
    }

    private static void checkPrivilegeFlag(BillVo bill, BillDetailVo detail, int index) {
        if (detail.getPrivilegeFlag() == 0 && StringUtils.isNotBlank((CharSequence)detail.getPrivilegeContent()) && !"\u666e\u901a\u96f6\u7a0e\u7387".equals(detail.getPrivilegeContent())) {
            throw new MsgException(ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u4e0d\u4eab\u53d7\u4f18\u60e0\u4e0d\u5141\u8bb8\u6709\u4eab\u53d7\u4f18\u60e0\u5185\u5bb9", (String)"BillValidaterHelper_105", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index));
        }
        if (detail.getPrivilegeFlag() == 1 && StringUtils.isBlank((CharSequence)detail.getPrivilegeContent())) {
            throw new MsgException(ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u4eab\u53d7\u4f18\u60e0\u65f6\u4eab\u53d7\u4f18\u60e0\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillValidaterHelper_106", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index));
        }
        if (TaxUtils.isPurchaseInvoice((String)bill.getSpecialType())) {
            if (!StringUtils.equals((CharSequence)detail.getTaxRate(), (CharSequence)"0")) {
                throw new MsgException(ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u519c\u4ea7\u54c1\u6536\u8d2d\u53d1\u7968\u7684\u7a0e\u7387\u987b\u4e3a0", (String)"BillValidaterHelper_107", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index));
            }
            if (!StringUtils.equals((CharSequence)detail.getPrivilegeContent(), (CharSequence)"\u514d\u7a0e") || detail.getPrivilegeFlag() != 1) {
                throw new MsgException(ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u6536\u8d2d\u7968\u5546\u54c1\u5fc5\u987b\u4e3a\u4eab\u53d7\u4f18\u60e0\u653f\u7b56\u548c\u514d\u7a0e", (String)"BillValidaterHelper_108", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index));
            }
        }
        if (TaxedTypeEnum.all_e_reduced_tax.getValue().equals(bill.getTaxationStyle())) {
            if ("\u63095%\u7b80\u6613\u5f81\u6536\u51cf\u63091.5%\u8ba1\u5f81".equals(detail.getPrivilegeContent()) && !"0.015".equals(detail.getTaxRate())) {
                throw new MsgException(ApiErrCodeEnum.ERROR.getCode(), ResManager.loadKDString((String)"\u660e\u7ec6\u4f18\u60e0\u653f\u7b56\u63095%\u7b80\u6613\u5f81\u6536\u51cf\u63091.5%\u8ba1\u5f81\u65f6\uff0c\u7a0e\u7387\u9700\u4f200.015", (String)"BillValidaterHelper_146", (String)"imc-sim-service", (Object[])new Object[0]));
            }
            if (!AllEPrivilegeTypeEnum.T_10.getName().equals(detail.getPrivilegeContent())) {
                throw new MsgException(ApiErrCodeEnum.ERROR.getCode(), ResManager.loadKDString((String)"\u51cf\u6309\u5f81\u7a0e\uff0c\u4f18\u60e0\u653f\u7b56\u5fc5\u987b\u662f\u63095%\u7b80\u6613\u5f81\u6536\u51cf\u63091.5%\u8ba1\u5f81", (String)"BillValidaterHelper_147", (String)"imc-sim-service", (Object[])new Object[0]));
            }
        }
    }

    private static void checkTaxRate(BillVo bill, BillDetailVo detail, int index) {
        if (StringUtils.isBlank((CharSequence)detail.getTaxRate())) {
            throw new MsgException(ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u7a0e\u7387\u672a\u4f20\u5165", (String)"BillValidaterHelper_109", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index));
        }
        BillPushSetValueHelper.setDetailTaxRate((BillVo)bill, (BillDetailVo)detail, (int)index);
    }

    private static void checkZSFS(BillVo bill, BillDetailVo detail, int index) {
        BigDecimal billDetailTaxDiff;
        boolean isCezs;
        BigDecimal taxRate = new BigDecimal(detail.getTaxRate());
        String policyConstants = detail.getPrivilegeContent();
        if (InvoiceUtils.isAllEInvoice((Object)bill.getInvoiceType()) && "0.015".equals(detail.getTaxRate()) && (detail.getPrivilegeFlag() != 1 || !ZzstsglEnum.TEN.getDescription().equals(detail.getPrivilegeContent()))) {
            throw new MsgException(ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u660e\u7ec6,\u7a0e\u7387\u4e3a\u51cf\u63091.5,\u4f18\u60e0\u653f\u7b56\u5fc5\u987b\u4e3a\u4eab\u53d7,\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\u5fc5\u987b\u4e3a\u63095%%\u7b80\u6613\u5f81\u6536\u51cf\u63091.5%%\u8ba1\u5f81", (String)"OriginalBillPluginControl_35", (String)"imc-sim-service", (Object[])new Object[0]), index));
        }
        boolean bl = isCezs = TaxedTypeEnum.deduction.getValue().equals(bill.getTaxationStyle()) || TaxedTypeEnum.all_e_deduction.getValue().equals(bill.getTaxationStyle());
        if (isCezs) {
            BigDecimal deduction = BillPushSetValueHelper.getDeduction((BillVo)bill, (BillDetailVo)detail);
            LOGGER.info("BillPush \u5dee\u989d\u5f81\u7a0e\u660e\u7ec6 \u539f\u7a0e\u989d\uff1a " + detail.getTaxAmount());
            LOGGER.info("BillPush \u5dee\u989d\u5f81\u7a0e\u660e\u7ec6 \u6263\u9664\u989d\uff1a " + deduction);
            BigDecimal afterTax = bill.getIncludeTaxFlag() == 1 ? BillPushSetValueHelper.getCETaxHS((BillDetailVo)detail, (BigDecimal)deduction, (BigDecimal)taxRate) : BillPushSetValueHelper.getCETaxBHS((BillDetailVo)detail, (BigDecimal)deduction, (BigDecimal)taxRate);
            billDetailTaxDiff = afterTax.subtract(detail.getTaxAmount());
        } else if (TaxedTypeEnum.subtract.getValue().equals(bill.getTaxationStyle()) && ReducedHelper.isSpecialCalc((Object)policyConstants)) {
            int hsbz = bill.getIncludeTaxFlag();
            if (0 == hsbz) {
                BigDecimal calcTax = ReducedHelper.calcTaxWithoutTax((Object)policyConstants, (BigDecimal)detail.getAmount());
                billDetailTaxDiff = calcTax.add(detail.getAmount()).subtract(detail.getIncludeTaxAmount());
            } else {
                BigDecimal calcTax = ReducedHelper.calcTaxWithTax((Object)policyConstants, (BigDecimal)detail.getIncludeTaxAmount());
                billDetailTaxDiff = calcTax.add(detail.getAmount()).subtract(detail.getIncludeTaxAmount());
            }
        } else if (InvoiceUtils.isAllEInvoice((Object)bill.getInvoiceType()) && "0.015".equals(detail.getTaxRate()) && ZzstsglEnum.TEN.getDescription().equals(policyConstants)) {
            if (0 == bill.getIncludeTaxFlag()) {
                BigDecimal calcTax = ReduceOnePoint5Helper.getTaxAmountBHS((BigDecimal)detail.getAmount(), (BigDecimal)new BigDecimal(detail.getTaxRate()), (String)detail.getRevenueCode());
                billDetailTaxDiff = calcTax.add(detail.getAmount()).subtract(detail.getIncludeTaxAmount());
            } else {
                BigDecimal calcTax = ReduceOnePoint5Helper.getTaxAmountHS((BigDecimal)detail.getIncludeTaxAmount(), (BigDecimal)new BigDecimal(detail.getTaxRate()), (String)detail.getRevenueCode());
                billDetailTaxDiff = calcTax.add(detail.getAmount()).subtract(detail.getIncludeTaxAmount());
            }
        } else {
            BigDecimal tax = TaxCalcUtil.calTax((BigDecimal)detail.getAmount(), (BigDecimal)BigDecimal.ZERO, (String)detail.getTaxRate(), (boolean)false, (int)6);
            billDetailTaxDiff = detail.getAmount().add(tax).subtract(detail.getIncludeTaxAmount());
        }
        if (bill.isNotCheckTaxDiff()) {
            return;
        }
        if (billDetailTaxDiff.abs().compareTo(InvoiceConstant.DIFFF_06) > 0) {
            throw new MsgException(ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u91d1\u989d\u4e0e\u7a0e\u989d\u8ba1\u7b97\u6709\u8bef\uff0c\u5b58\u5728\u8bef\u5dee\uff0c\u8bf7\u67e5\u6b63\uff0c\u5546\u54c1\u540d\u79f0[%3$s]\uff0c\u91d1\u989d[%4$s]\uff0c\u7a0e\u989d[%5$s]!", (String)"BillValidaterHelper_110", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index, detail.getGoodsName(), detail.getAmount().setScale(2, 4), detail.getTaxAmount().setScale(2, 4)));
        }
    }

    private static void checkSpecificationAndUnit(BillVo bill, BillDetailVo detail, int index, DynamicObject issueInvSetting) {
        String invoiceType = bill.getInvoiceType();
        if (StringUtils.isNotBlank((CharSequence)detail.getSpecification())) {
            if (!GBKUtils.checkValidGbk((String)detail.getSpecification())) {
                throw new MsgException(ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u89c4\u683c\u578b\u53f7[%3$s]\u5305\u542b\u975eGBK\u7f16\u7801\u5b57\u7b26", (String)"BillValidaterHelper_111", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index, detail.getSpecification()));
            }
            if (InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
                if (String.valueOf(detail.getSpecification()).length() > 40 && BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_SPLIT.getValue().equals(issueInvSetting.getString("fieldtolong"))) {
                    detail.setSpecification(detail.getSpecification().substring(0, 40));
                } else if (String.valueOf(detail.getSpecification()).length() > 40 && BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_HINT.getValue().equals(issueInvSetting.getString("fieldtolong"))) {
                    throw new MsgException(ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u89c4\u683c\u578b\u53f7[%3$s]\u8d85\u8fc7\u6700\u5927\u5b57\u8282\u6570[%4$s]", (String)"BillValidaterHelper_112", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index, detail.getSpecification(), 40));
                }
            } else if (GBKUtils.getGBKLength((String)detail.getSpecification()) > 40 && BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_SPLIT.getValue().equals(issueInvSetting.getString("fieldtolong"))) {
                detail.setSpecification(GBKUtils.cutGBKString((String)detail.getSpecification(), (int)40));
            } else if (GBKUtils.getGBKLength((String)detail.getSpecification()) > 40 && BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_HINT.getValue().equals(issueInvSetting.getString("fieldtolong"))) {
                throw new MsgException(ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u89c4\u683c\u578b\u53f7[%3$s]\u8d85\u8fc7\u6700\u5927\u5b57\u8282\u6570[%4$s]", (String)"BillValidaterHelper_112", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index, detail.getSpecification(), 40));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)detail.getUnits())) {
            if (!GBKUtils.checkValidGbk((String)detail.getUnits())) {
                throw new MsgException(ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u8ba1\u91cf\u5355\u4f4d[%3$s]\u5305\u542b\u975eGBK\u7f16\u7801\u5b57\u7b26", (String)"BillValidaterHelper_113", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index, detail.getUnits()));
            }
            if (InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
                if (detail.getUnits().length() > 22 && BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_SPLIT.getValue().equals(issueInvSetting.getString("fieldtolong"))) {
                    detail.setUnits(detail.getUnits().substring(0, 21));
                } else if (detail.getUnits().length() > 22 && BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_HINT.getValue().equals(issueInvSetting.getString("fieldtolong"))) {
                    throw new MsgException(ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u8ba1\u91cf\u5355\u4f4d[%3$s]\u8d85\u8fc7\u6700\u5927\u5b57\u7b26\u6570[%4$s]", (String)"BillValidaterHelper_114", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index, detail.getUnits(), 22));
                }
            } else if (GBKUtils.getGBKLength((String)detail.getUnits()) > 22 && BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_SPLIT.getValue().equals(issueInvSetting.getString("fieldtolong"))) {
                detail.setUnits(GBKUtils.cutGBKString((String)detail.getUnits(), (int)22));
            } else if (GBKUtils.getGBKLength((String)detail.getUnits()) > 22 && BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_HINT.getValue().equals(issueInvSetting.getString("fieldtolong"))) {
                throw new MsgException(ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u8ba1\u91cf\u5355\u4f4d[%3$s]\u8d85\u8fc7\u6700\u5927\u5b57\u8282\u6570[%4$s]", (String)"BillValidaterHelper_115", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index, detail.getUnits(), 22));
            }
        }
    }

    private static void checkVehicleItem(BillVo bill, BillDetailVo detail, int index) {
        String specialType = bill.getSpecialType();
        String invoiceType = bill.getInvoiceType();
        String property = String.valueOf(detail.getLineProperty());
        String num = detail.getQuantity();
        String price = detail.getPrice();
        String unit = detail.getUnits();
        try {
            InvoiceCheckService.checkVehicleItem((String)specialType, (String)invoiceType, (String)property, (int)index, (String)num, (String)price, (String)unit);
        }
        catch (Exception e) {
            throw new MsgException(ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), e.getMessage());
        }
    }

    public static void checkSpecificationAndUnitAndRemark(BillVo bill, int index, DynamicObject issueInvSetting, BillDetailVo detailVo) {
        String invoiceType = bill.getInvoiceType();
        if (StringUtils.isNotBlank((CharSequence)detailVo.getSpecification())) {
            if (!GBKUtils.checkValidGbk((String)detailVo.getSpecification())) {
                throw new MsgException(ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u89c4\u683c\u578b\u53f7[%3$s]\u5305\u542b\u975eGBK\u7f16\u7801\u5b57\u7b26", (String)"BillValidaterHelper_111", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index, detailVo.getSpecification()));
            }
            if (InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
                if (detailVo.getSpecification().length() > 40 && BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_SPLIT.getValue().equals(issueInvSetting.getString("fieldtolong"))) {
                    detailVo.setSpecification(detailVo.getSpecification().substring(0, 40));
                } else if (detailVo.getSpecification().length() > 40 && BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_HINT.getValue().equals(issueInvSetting.getString("fieldtolong"))) {
                    throw new MsgException(ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u89c4\u683c\u578b\u53f7[%3$s]\u8d85\u8fc7\u6700\u5927\u5b57\u7b26\u6570[%4$s]", (String)"BillValidaterHelper_116", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index, detailVo.getSpecification(), 40));
                }
            } else if (GBKUtils.getGBKLength((String)detailVo.getSpecification()) > 40 && BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_SPLIT.getValue().equals(issueInvSetting.getString("fieldtolong"))) {
                detailVo.setSpecification(GBKUtils.cutGBKString((String)detailVo.getSpecification(), (int)40));
            } else if (GBKUtils.getGBKLength((String)detailVo.getSpecification()) > 40 && BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_HINT.getValue().equals(issueInvSetting.getString("fieldtolong"))) {
                throw new MsgException(ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u89c4\u683c\u578b\u53f7[%3$s]\u8d85\u8fc7\u6700\u5927\u5b57\u8282\u6570[%4$s]", (String)"BillValidaterHelper_112", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index, detailVo.getSpecification(), 40));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)detailVo.getUnits())) {
            if (!GBKUtils.checkValidGbk((String)detailVo.getUnits())) {
                throw new MsgException(ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u8ba1\u91cf\u5355\u4f4d[%3$s]\u5305\u542b\u975eGBK\u7f16\u7801\u5b57\u7b26", (String)"BillValidaterHelper_113", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index, detailVo.getUnits()));
            }
            if (InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
                if (detailVo.getUnits().length() > 22 && BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_SPLIT.getValue().equals(issueInvSetting.getString("fieldtolong"))) {
                    detailVo.setUnits(detailVo.getUnits().substring(0, 21));
                } else if (detailVo.getUnits().length() > 22 && BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_HINT.getValue().equals(issueInvSetting.getString("fieldtolong"))) {
                    throw new MsgException(ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u8ba1\u91cf\u5355\u4f4d[%3$s]\u8d85\u8fc7\u6700\u5927\u5b57\u7b26\u6570[%4$s]", (String)"BillValidaterHelper_114", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index, detailVo.getUnits(), 22));
                }
            } else if (GBKUtils.getGBKLength((String)detailVo.getUnits()) > 22 && BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_SPLIT.getValue().equals(issueInvSetting.getString("fieldtolong"))) {
                detailVo.setUnits(GBKUtils.cutGBKString((String)detailVo.getUnits(), (int)22));
            } else if (GBKUtils.getGBKLength((String)detailVo.getUnits()) > 22 && BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_HINT.getValue().equals(issueInvSetting.getString("fieldtolong"))) {
                throw new MsgException(ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u8ba1\u91cf\u5355\u4f4d[%3$s]\u8d85\u8fc7\u6700\u5927\u5b57\u8282\u6570[%4$s]", (String)"BillValidaterHelper_115", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index, detailVo.getUnits(), 22));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)detailVo.getLineRemark())) {
            if (!GBKUtils.checkValidGbk((String)detailVo.getLineRemark())) {
                throw new MsgException(ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u884c\u5907\u6ce8[%3$s]\u5305\u542b\u975eGBK\u7f16\u7801\u5b57\u7b26", (String)"BillValidaterHelper_117", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index, detailVo.getUnits()));
            }
            if (GBKUtils.getGBKLength((String)detailVo.getLineRemark()) > 100 && BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_SPLIT.getValue().equals(issueInvSetting.getString("fieldtolong"))) {
                detailVo.setUnits(GBKUtils.cutGBKString((String)detailVo.getLineRemark(), (int)100));
            } else if (GBKUtils.getGBKLength((String)detailVo.getLineRemark()) > 100 && BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_HINT.getValue().equals(issueInvSetting.getString("fieldtolong"))) {
                throw new MsgException(ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u884c\u5907\u6ce8[%3$s]\u8d85\u8fc7\u6700\u5927\u5b57\u8282\u6570[%4$s]", (String)"BillValidaterHelper_118", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index, detailVo.getUnits(), 100));
            }
        }
    }

    private static void checkGoodsName(BillVo bill, BillDetailVo detail, int index) {
        if (StringUtils.isBlank((CharSequence)detail.getGoodsName())) {
            throw new MsgException(ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillValidaterHelper_119", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index));
        }
        if (StringUtils.isNotBlank((CharSequence)detail.getGoodsName())) {
            if (!GBKUtils.checkValidGbk((String)detail.getGoodsName())) {
                throw new MsgException(ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u5546\u54c1\u540d\u79f0[%3$s]\u5305\u542b\u975eGBK\u7f16\u7801\u5b57\u7b26", (String)"BillValidaterHelper_88", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index, detail.getGoodsName()));
            }
            String tempGoodsName = '*' + detail.getRevenueName() + '*' + detail.getGoodsName();
            if (InvoiceType.ALL_E_SPECIAL.getTypeCode().equals(bill.getInvoiceType()) || InvoiceType.ALL_E_NORMAL.getTypeCode().equals(bill.getInvoiceType())) {
                if (detail.getGoodsName() != null && detail.getGoodsName().length() > 100) {
                    throw new MsgException(ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u5546\u54c1\u540d\u79f0[%3$s]\u8d85\u8fc7\u6700\u5927\u5b57\u7b26\u6570[%4$s]", (String)"BillValidaterHelper_139", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index, detail.getGoodsName(), 100));
                }
            } else if (GBKUtils.getGBKLength((String)tempGoodsName) > 92) {
                throw new MsgException(ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u7b80\u79f0+\u5546\u54c1\u540d\u79f0[%3$s]\u8d85\u8fc7\u6700\u5927\u5b57\u8282\u6570[%4$s]", (String)"BillValidaterHelper_120", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index, tempGoodsName, 92));
            }
        } else {
            throw new MsgException(ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u660e\u7ec6\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillValidaterHelper_119", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), index));
        }
    }

    private static String paddingRevenueCode(String revenueCode) {
        if (StringUtils.isBlank((CharSequence)revenueCode)) {
            return "";
        }
        if (revenueCode.length() >= 19) {
            return revenueCode;
        }
        return BillValidaterHelper.paddingRevenueCode(revenueCode + "0");
    }

    private static boolean isCheckAmountDiff001(BillVo bill) {
        if (CallbackHelperUtil.isFromArIssueBill((String)bill.getSystemSource())) {
            return false;
        }
        String billSaveAmountCheck = ImcConfigUtil.getValue((String)"sim_bill_save_check_amount", (String)bill.getSellerTaxpayerId());
        return StringUtils.isBlank((CharSequence)billSaveAmountCheck);
    }

    private static boolean isCheckTaxDiff006(BillVo bill) {
        String billSaveTaxCheck = ImcConfigUtil.getValue((String)"sim_bill_save_check_tax", (String)bill.getSellerTaxpayerId());
        return StringUtils.isNotEmpty((CharSequence)billSaveTaxCheck) && "1".equals(billSaveTaxCheck);
    }

    public static void checkReductionTaxType(BillVo invoiceDTO) {
        if (StringUtils.isNotEmpty((CharSequence)invoiceDTO.getReductionTaxType())) {
            ImmutableSet stringSet = ImmutableSet.of((Object)"01", (Object)"02", (Object)"03", (Object)"04", (Object)"05", (Object)"51", (Object[])new String[]{"52", "53"});
            if (!stringSet.contains(invoiceDTO.getReductionTaxType())) {
                throw new MsgException(ApiErrCodeEnum.REDUCTIONTAXTYPE_ERROR.getCode(), ApiErrCodeEnum.REDUCTIONTAXTYPE_ERROR.getMsg());
            }
            if (StringUtils.isNotEmpty((CharSequence)invoiceDTO.getSpecialType()) && !"E06".equals(invoiceDTO.getSpecialType())) {
                throw new MsgException(ApiErrCodeEnum.REDUCTIONTAXTYPE_ERROR2.getCode(), ApiErrCodeEnum.REDUCTIONTAXTYPE_ERROR2.getMsg());
            }
        }
    }

    public static void validSpecialType(BillVo bill) {
        String specialType = bill.getSpecialType();
        String billNo = bill.getBillNo();
        if ("18".equals(specialType)) {
            List details = bill.getBillDetail();
            String invoiceType = bill.getInvoiceType();
            if (!InvoiceUtils.isSpecialInvoice((String)invoiceType)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%s,\u673a\u52a8\u8f66\u589e\u503c\u7a0e\u53d1\u7968\u7684\u53d1\u7968\u7c7b\u578b\u5fc5\u987b\u4e13\u7968", (String)"BillValidaterHelper_121", (String)"imc-sim-service", (Object[])new Object[0]), billNo));
            }
            for (BillDetailVo detail : details) {
                int lineProperty = detail.getLineProperty();
                if (1 == lineProperty) continue;
                String num = detail.getQuantity();
                if (!RegexUtil.isIntegerLargeZero((String)num)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%s,\u673a\u52a8\u8f66\u589e\u503c\u7a0e\u53d1\u7968\u6570\u91cf\u5fc5\u987b\u4e3a\u6b63\u6574\u6570", (String)"BillValidaterHelper_122", (String)"imc-sim-service", (Object[])new Object[0]), billNo));
                }
                String price = detail.getPrice();
                if (!RegexUtil.isFloatLargeZero((String)price)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%s,\u673a\u52a8\u8f66\u589e\u503c\u7a0e\u53d1\u7968\u5355\u4ef7\u5fc5\u987b\u4e3a\u6b63\u6570", (String)"BillValidaterHelper_123", (String)"imc-sim-service", (Object[])new Object[0]), billNo));
                }
                String unit = detail.getUnits();
                if ("\u8f86".equals(unit)) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%s,\u5355\u4f4d\u680f\u5fc5\u987b\u4e3a:\u8f86", (String)"BillValidaterHelper_124", (String)"imc-sim-service", (Object[])new Object[0]), billNo));
            }
        } else if ("02".equals(specialType)) {
            boolean isAllEle = "1".equals(bill.getIsElePaper()) || InvoiceUtils.isAllEInvoice((Object)bill.getInvoiceType());
            boolean isBlueInvoice = true;
            if (StringUtils.isNotBlank((Object)bill.getBillProperty())) {
                isBlueInvoice = "1".equals(String.valueOf(bill.getBillProperty()));
            } else if (!BigDecimalUtil.compareZero((BigDecimal)bill.getTotalAmount())) {
                isBlueInvoice = BigDecimalUtil.greaterZero((BigDecimal)bill.getTotalAmount());
            } else if (null != bill.getBillDetail() && bill.getBillDetail().size() > 0) {
                isBlueInvoice = BigDecimalUtil.greaterZero((BigDecimal)((BillDetailVo)bill.getBillDetail().get(0)).getAmount());
            }
            if (!InvoiceUtils.isNormalInvoice((String)bill.getInvoiceType()) && !InvoiceType.ALL_E_NORMAL.getTypeCode().equals(bill.getInvoiceType())) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%s, \u519c\u4ea7\u54c1\u6536\u8d2d\u53d1\u7968\u7684\u53d1\u7968\u7c7b\u578b\u5fc5\u987b\u4e3a\u666e\u7968", (String)"BillValidaterHelper_125", (String)"imc-sim-service", (Object[])new Object[0]), billNo));
            }
            if (isBlueInvoice && isAllEle && StringUtils.isEmpty((CharSequence)bill.getCardType())) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%s, \u6570\u7535\u7968\u519c\u4ea7\u54c1\u6536\u8d2d\u53d1\u7968\u8bc1\u4ef6\u7c7b\u578b\u5fc5\u586b", (String)"BillValidaterHelper_126", (String)"imc-sim-service", (Object[])new Object[0]), billNo));
            }
            if (isAllEle && StringUtils.isEmpty((CharSequence)bill.getBuyerTaxpayerId())) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%s, \u6570\u7535\u7968\u519c\u4ea7\u54c1\u6536\u8d2d\u53d1\u7968\u8bc1\u4ef6\u53f7\u7801\uff08\u8d2d\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff09\u5fc5\u586b", (String)"BillValidaterHelper_190", (String)"imc-sim-service", (Object[])new Object[0]), billNo));
            }
            if (isBlueInvoice && isAllEle && bill.getNation() == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7:%s\u6570\u7535\u7968\u519c\u4ea7\u54c1\u6536\u8d2d\u53d1\u7968\uff0c\u56fd\u7c4d\uff08\u5730\u533a\uff09\u5fc5\u586b", (String)"BillValidaterHelper_191", (String)"imc-sim-service", (Object[])new Object[0]), billNo));
            }
            if (isBlueInvoice && isAllEle) {
                InvoiceValidHelper.validateCardNoInfo((String)bill.getCardType(), (String)bill.getBuyerTaxpayerId());
                DynamicObject nation = InvoiceUtils.getNation((String)bill.getCardType(), (String)bill.getBuyerTaxpayerId());
                if (null != nation && !Objects.equals(nation.getPkValue(), bill.getNation().getPkValue())) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7:%1$s\u56fd\u7c4d\uff08\u5730\u533a\uff09\u4fe1\u606f\u4e0e\u8bc1\u4ef6\u4fe1\u606f\u4e0d\u5339\u914d\uff0c\u5339\u914d\u5230\u7684\u56fd\u7c4d\uff08\u5730\u533a\uff09\u4ee3\u7801:%2$s", (String)"BillValidaterHelper_192", (String)"imc-sim-service", (Object[])new Object[0]), billNo, nation.getString("number")));
                }
            }
        } else if ("E07".equals(specialType)) {
            BillValidaterHelper.dealCheckVesselVehicheMethod(bill);
        }
    }

    private static void dealCheckVesselVehicheMethod(BillVo bill) {
        String billNo = bill.getBillNo();
        List details = bill.getBillDetail();
        for (BillDetailVo detail : details) {
            String unit = detail.getUnits();
            int lineProperty = detail.getLineProperty();
            if (lineProperty == 1 || "\u8f86".equals(unit)) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%s,\u5355\u4f4d\u680f\u5fc5\u987b\u4e3a:\u8f86", (String)"BillValidaterHelper_124", (String)"imc-sim-service", (Object[])new Object[0]), billNo));
        }
    }

    public static void dealCheckVessalVehicheMethod(DynamicObject originBillDynamicObject) {
        String billNo = originBillDynamicObject.getString("billno");
        String invoiceType = originBillDynamicObject.getString("invoicetype");
        String specialType = originBillDynamicObject.getString("specialtype");
        boolean flag = InvoiceType.checkIsTaxInvoice((String)invoiceType);
        DynamicObjectCollection dynamicObjectCollection = originBillDynamicObject.getDynamicObjectCollection("vehichevesselships");
        if (flag && "E07".equals(specialType) && dynamicObjectCollection != null && dynamicObjectCollection.size() > 0) {
            String errorMsg = ResManager.loadKDString((String)"\u5f00\u5177\u7a0e\u63a7\u53d1\u7968\u65f6\uff0c\u4e0d\u80fd\u591f\u652f\u6301\u4ee3\u6536\u8f66\u8239\u7a0e\u670d\u52a1", (String)"BillValidaterHelper_132", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        if (InvoiceUtils.isAllEInvoice((Object)invoiceType) && "E07".equals(specialType)) {
            if (InvoiceType.ALL_E_SPECIAL.getTypeCode().equals(invoiceType)) {
                String errorMsg = ResManager.loadKDString((String)"\u4ee3\u6536\u8f66\u8239\u7a0e\u7279\u6b8a\u7968\u79cd\u53ea\u5141\u8bb8\u5f00\u5177\u6570\u7535\u7968\uff08\u666e\u901a\u53d1\u7968\uff09", (String)"BillValidaterHelper_131", (String)"imc-sim-service", (Object[])new Object[0]);
                throw new KDBizException(errorMsg);
            }
            DynamicObjectCollection itemObjectCollection = originBillDynamicObject.getDynamicObjectCollection("sim_original_bill_item");
            for (DynamicObject itemObject : itemObjectCollection) {
                String unit = itemObject.getString("unit");
                String rowtype = itemObject.getString("rowtype");
                if (!"2".equals(rowtype) || "\u8f86".equals(unit)) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%s,\u5355\u4f4d\u680f\u5fc5\u987b\u4e3a:\u8f86", (String)"BillValidaterHelper_124", (String)"imc-sim-service", (Object[])new Object[0]), billNo));
            }
        }
    }

    public static void dealSetPeriodDateMethod(DynamicObject originBillDynamicObject) {
        String specialType = originBillDynamicObject.getString("specialtype");
        if ("E07".equals(specialType)) {
            DynamicObjectCollection vesselShipCollection = originBillDynamicObject.getDynamicObjectCollection("vehichevesselships");
            for (DynamicObject vesselShipItem : vesselShipCollection) {
                Date periodStartDate = vesselShipItem.getDate("periodstartdate");
                Date peroidEndDate = vesselShipItem.getDate("periodenddate");
                if (periodStartDate == null || peroidEndDate == null) continue;
                String periodDate = DateUtils.format((Date)periodStartDate, (String)"yyyy-MM") + " " + DateUtils.format((Date)peroidEndDate, (String)"yyyy-MM");
                vesselShipItem.set("perioddate", (Object)periodDate);
            }
        }
    }

    public static void dealCheckVessalShipPeriodMethod(String interfaceCode, String data) {
        if (OpenApiInterfaceCodeEnum.BILL_PUSH.getCode().equals(interfaceCode)) {
            JSONArray jsonArray = JSONArray.parseArray((String)data);
            if (jsonArray != null && !jsonArray.isEmpty()) {
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    BillValidaterHelper.dealCheckVessalShipPeriodMethod(jsonObject, OpenApiInterfaceCodeEnum.BILL_PUSH.getCode());
                }
            }
        } else if (OpenApiInterfaceCodeEnum.ALLE_INVOICE_OPEN.getCode().equals(interfaceCode)) {
            JSONObject jsonObject = JSONObject.parseObject((String)data);
            BillValidaterHelper.dealCheckVessalShipPeriodMethod(jsonObject, OpenApiInterfaceCodeEnum.ALLE_INVOICE_OPEN.getCode());
        }
    }

    private static void dealCheckVessalShipPeriodMethod(JSONObject jsonObject, String interfaceCode) {
        String vehicheVesselShipList;
        boolean isBillPush = OpenApiInterfaceCodeEnum.BILL_PUSH.getCode().equalsIgnoreCase(interfaceCode);
        if (jsonObject.containsKey((Object)"vehicheVesselShipList") && StringUtils.isNotBlank((CharSequence)(vehicheVesselShipList = jsonObject.getString("vehicheVesselShipList")))) {
            JSONArray subArray = JSONArray.parseArray((String)vehicheVesselShipList);
            for (int j = 0; j < subArray.size(); ++j) {
                boolean flag2;
                boolean flag1;
                JSONObject subObject = subArray.getJSONObject(j);
                String periodStartDate = subObject.getString("periodStartDate");
                String periodEndDate = subObject.getString("periodEndDate");
                if (isBillPush) {
                    if (!StringUtils.isNotBlank((CharSequence)periodStartDate) && !StringUtils.isNotBlank((CharSequence)periodEndDate)) continue;
                    flag1 = InvoiceCheckService.isValidDateFormat((String)periodStartDate);
                    flag2 = InvoiceCheckService.isValidDateFormat((String)periodEndDate);
                    if (flag1 && flag2) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u7279\u6b8a\u7968\u79cd\u7c7b\u578b\u4e3a\uff1a\u4ee3\u6536\u8f66\u8239\u7a0e\u65f6\uff0c\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u6b62\u65e5\u671f\u7684\u683c\u5f0f\u5fc5\u987b\u4e3a:yyyy-MM", (String)"BillValidaterHelper_138", (String)"imc-sim-service", (Object[])new Object[0]));
                }
                flag1 = InvoiceCheckService.isValidDateFormat((String)periodStartDate);
                flag2 = InvoiceCheckService.isValidDateFormat((String)periodEndDate);
                if (flag1 && flag2) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u7279\u6b8a\u7968\u79cd\u7c7b\u578b\u4e3a\uff1a\u4ee3\u6536\u8f66\u8239\u7a0e\u65f6\uff0c\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u6b62\u65e5\u671f\u7684\u683c\u5f0f\u5fc5\u987b\u4e3a:yyyy-MM", (String)"BillValidaterHelper_138", (String)"imc-sim-service", (Object[])new Object[0]));
            }
        }
    }

    public static void checkLength(DataEntityPropertyCollection properties, String key, BillVo bill, String val) {
        IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)key);
        if (property instanceof TextProp) {
            int maxLenth = ((TextProp)property).getMaxLenth();
            if (GBKUtils.getGBKLength((String)val) > maxLenth) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\u7684%2$s\u8d85\u957f", (String)"BillPushServiceImpl_36", (String)"imc-sim-webapi", (Object[])new Object[0]), bill.getBillNo(), property.getDisplayName().getLocaleValue()));
            }
        }
    }

    public static void checkExtraInfo(DynamicObject originBillDynamicObject) {
        if (!"sim_original_bill".equals(originBillDynamicObject.getDataEntityType().getName())) {
            return;
        }
        DynamicObjectCollection extraItems = originBillDynamicObject.getDynamicObjectCollection("extra");
        HashSet<String> nameSet = new HashSet<String>();
        for (int i = 0; i < extraItems.size(); ++i) {
            DynamicObject extraItem = (DynamicObject)extraItems.get(i);
            String extraName = extraItem.getString("extrainfoname");
            String extraType = extraItem.getString("extrainfotype");
            String extraValue = extraItem.getString("extrainfovalue");
            Date extraTime = extraItem.getDate("extrainfotime");
            if (StringUtils.isBlank((CharSequence)extraName) || StringUtils.isBlank((CharSequence)extraType) || StringUtils.isBlank((CharSequence)extraValue)) {
                if ("2".equals(extraType)) {
                    if (null == extraTime) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e:%1$s\u7684\u7b2c:%2$s\u884c\u9644\u52a0\u8981\u7d20\u540d\u79f0\u3001\u9644\u52a0\u8981\u7d20\u7c7b\u578b\u3001\u9644\u52a0\u8981\u7d20\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillValidaterHelper_158", (String)"imc-sim-service", (Object[])new Object[0]), originBillDynamicObject.getString("billno"), i + 1));
                    }
                } else {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e:%1$s\u7684\u7b2c:%2$s\u884c\u9644\u52a0\u8981\u7d20\u540d\u79f0\u3001\u9644\u52a0\u8981\u7d20\u7c7b\u578b\u3001\u9644\u52a0\u8981\u7d20\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillValidaterHelper_158", (String)"imc-sim-service", (Object[])new Object[0]), originBillDynamicObject.getString("billno"), i + 1));
                }
            }
            if (extraName.length() > 200 || String.valueOf(extraValue).length() > 200) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e:%1$s\u7684\u7b2c:%2$s\u884c\u9644\u52a0\u8981\u7d20\u540d\u79f0\u3001\u9644\u52a0\u8981\u7d20\u503c\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7200\u5b57\u7b26", (String)"BillValidaterHelper_159", (String)"imc-sim-service", (Object[])new Object[0]), originBillDynamicObject.getString("billno"), i + 1));
            }
            if ("1".equals(extraType) && !BigDecimalUtil.isNumber((String)extraValue)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e:%1$s\u7684\u7b2c:%2$s\u884c\u9644\u52a0\u8981\u7d20\u503c\u683c\u5f0f\u6709\u8bef", (String)"BillValidaterHelper_160", (String)"imc-sim-service", (Object[])new Object[0]), originBillDynamicObject.getString("billno"), i + 1));
            }
            if (nameSet.contains(extraName)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e:%1$s\u7684\u7b2c:%2$s\u884c\u5df2\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u9644\u52a0\u8981\u7d20\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0", (String)"BillValidaterHelper_161", (String)"imc-sim-service", (Object[])new Object[0]), originBillDynamicObject.getString("billno"), i + 1));
            }
            nameSet.add(extraName);
        }
    }

    public static ApiResult checkCoalTypeCodeAndQuality(BillVo bill, boolean autoMergeOrAutoIssue) {
        if (EnterpriseHelper.isLqptChannel((String)bill.getSellerTaxpayerId())) {
            return ResponseVo.success((String)"");
        }
        if (-1 == bill.getBillProperty()) {
            return ResponseVo.success((String)"");
        }
        boolean isCoal = false;
        for (int i = 0; i < bill.getBillDetail().size(); ++i) {
            BillDetailVo detail = (BillDetailVo)bill.getBillDetail().get(i);
            if (!CoalTypeCodeEnum.coalTypeGoodsCode.contains(detail.getRevenueCode())) continue;
            isCoal = true;
            if (autoMergeOrAutoIssue && StringUtils.isEmpty((CharSequence)detail.getCoalTypeCode())) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u7164\u70ad\u79cd\u7c7b\u4ee3\u7801\u5fc5\u586b", (String)"BillValidaterHelper_163", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), i + 1));
            }
            if (!StringUtils.isNotBlank((CharSequence)detail.getCoalTypeCode()) || CoalTypeCodeEnum.coalTypeCodeSet.contains(detail.getCoalTypeCode())) continue;
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\u7164\u70ad\u79cd\u7c7b\u4ee3\u7801\u586b\u5199\u6709\u8bef\uff0c\u6b63\u786e\u503c\u4e3a\u30100100\uff0c0201\uff0c0202\uff0c0203\uff0c0204\uff0c0300\u3011\u5176\u4e2d\u4e4b\u4e00", (String)"BillValidaterHelper_164", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), i + 1));
        }
        if (!isCoal) {
            bill.setCoalQuality(null);
        }
        if (null != bill.getCoalQuality()) {
            if (StringUtils.isNotEmpty((CharSequence)bill.getCoalQuality().getCoalHeat()) && bill.getCoalQuality().getCoalHeat().length() > 10) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\u7164\u70ad\u8d28\u91cf\u4fe1\u606f\u6bcf\u5343\u514b\u7164\u70ad\u53d1\u70ed\u91cf(\u5343\u5361)\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc710\u4e2a\u5b57\u7b26", (String)"BillValidaterHelper_175", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
            }
            if (StringUtils.isNotEmpty((CharSequence)bill.getCoalQuality().getTotalSulfurInDry()) && bill.getCoalQuality().getTotalSulfurInDry().length() > 10) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\u7164\u70ad\u8d28\u91cf\u4fe1\u606f\u5e72\u57fa\u5168\u786b\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc710\u4e2a\u5b57\u7b26", (String)"BillValidaterHelper_176", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
            }
            if (StringUtils.isNotEmpty((CharSequence)bill.getCoalQuality().getDryAshFreeVolatileMatter()) && bill.getCoalQuality().getDryAshFreeVolatileMatter().length() > 10) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\u7164\u70ad\u8d28\u91cf\u4fe1\u606f\u5e72\u71e5\u65e0\u7070\u57fa\u6325\u53d1\u5206\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc710\u4e2a\u5b57\u7b26", (String)"BillValidaterHelper_177", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
            }
        }
        return ResponseVo.success((String)"");
    }

    public static String checkDigitalInvoiceBuyerSellerInfo(DynamicObject originBillDynamicObject) {
        String sellerAddressAndTel;
        String sellerName;
        String buyerAddressAndTel;
        String invoiceType = originBillDynamicObject.getString("invoicetype");
        if (InvoiceType.checkIsTaxInvoice((String)invoiceType)) {
            return null;
        }
        String billNo = originBillDynamicObject.getString("billno");
        String buyerName = originBillDynamicObject.getString("buyername");
        if (StringUtils.isNotBlank((CharSequence)buyerName) && buyerName.length() > 100) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u8d2d\u65b9\u540d\u79f0[%2$s]\u8d85\u8fc7\u53d1\u7968\u53ef\u5f00\u5177\u6700\u5927\u957f\u5ea6[%3$s]\u5b57\u7b26", (String)"BillValidaterHelper_165", (String)"imc-sim-service", (Object[])new Object[0]), billNo, buyerName, 100);
            return errorMsg;
        }
        String buyerTaxNo = originBillDynamicObject.getString("buyertaxno");
        if (StringUtils.isNotBlank((CharSequence)buyerTaxNo) && buyerTaxNo.length() > 20) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u8d2d\u65b9\u7a0e\u53f7[%2$s]\u8d85\u8fc7\u53d1\u7968\u53ef\u5f00\u5177\u6700\u5927\u957f\u5ea6[%3$s]\u5b57\u7b26", (String)"BillValidaterHelper_166", (String)"imc-sim-service", (Object[])new Object[0]), billNo, buyerTaxNo, 20);
            return errorMsg;
        }
        String buyerBankAndAccount = originBillDynamicObject.getString("buyerbank");
        if (StringUtils.isNotBlank((CharSequence)buyerBankAndAccount)) {
            Pair pairMap = AddressSplitHelper.splitBankAndName((String)buyerBankAndAccount);
            String buyerBankName = (String)pairMap.getKey();
            if (StringUtils.isNotBlank((CharSequence)buyerBankName) && buyerBankName.length() > 100) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u8d2d\u65b9\u5f00\u6237\u884c\u540d\u79f0[%2$s]\u8d85\u8fc7\u53d1\u7968\u53ef\u5f00\u5177\u6700\u5927\u957f\u5ea6[%3$s]\u5b57\u7b26", (String)"BillValidaterHelper_167", (String)"imc-sim-service", (Object[])new Object[0]), billNo, buyerBankName, 100);
                return errorMsg;
            }
            String buyerBankNo = (String)pairMap.getValue();
            if (StringUtils.isNotBlank((CharSequence)buyerBankNo) && buyerBankNo.length() > 50) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u8d2d\u65b9\u94f6\u884c\u8d26\u53f7[%2$s]\u8d85\u8fc7\u53d1\u7968\u53ef\u5f00\u5177\u6700\u5927\u957f\u5ea6[%3$s]\u5b57\u7b26", (String)"BillValidaterHelper_56", (String)"imc-sim-service", (Object[])new Object[0]), billNo, buyerBankNo, 50);
                return errorMsg;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(buyerAddressAndTel = originBillDynamicObject.getString("buyeraddr")))) {
            Pair pairMap = AddressSplitHelper.splitAddressAndTel((String)buyerAddressAndTel);
            String buyerAddress = (String)pairMap.getKey();
            if (StringUtils.isNotBlank((CharSequence)buyerAddress) && buyerAddress.length() > 100) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u8d2d\u65b9\u5730\u5740[%2$s]\u8d85\u8fc7\u53d1\u7968\u53ef\u5f00\u5177\u6700\u5927\u957f\u5ea6[%3$s]\u5b57\u7b26", (String)"BillValidaterHelper_168", (String)"imc-sim-service", (Object[])new Object[0]), billNo, buyerAddress, 100);
                return errorMsg;
            }
            String buyerTel = (String)pairMap.getValue();
            if (StringUtils.isNotBlank((CharSequence)buyerTel) && buyerTel.length() > 20) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u8d2d\u65b9\u5730\u5740\u7535\u8bdd[%2$s]\u8d85\u8fc7\u53d1\u7968\u53ef\u5f00\u5177\u6700\u5927\u957f\u5ea6[%3$s]\u5b57\u7b26", (String)"BillValidaterHelper_60", (String)"imc-sim-service", (Object[])new Object[0]), billNo, buyerTel, 20);
                return errorMsg;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(sellerName = originBillDynamicObject.getString("salername"))) && sellerName.length() > 100) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u9500\u65b9\u540d\u79f0[%2$s]\u8d85\u8fc7\u53d1\u7968\u53ef\u5f00\u5177\u6700\u5927\u957f\u5ea6[%3$s]\u5b57\u7b26", (String)"BillValidaterHelper_169", (String)"imc-sim-service", (Object[])new Object[0]), billNo, sellerName, 100);
            return errorMsg;
        }
        String sellerTaxNo = originBillDynamicObject.getString("salertaxno");
        if (StringUtils.isNotBlank((CharSequence)sellerTaxNo) && sellerTaxNo.length() > 20) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u9500\u65b9\u7a0e\u53f7[%2$s]\u8d85\u8fc7\u53d1\u7968\u53ef\u5f00\u5177\u6700\u5927\u957f\u5ea6[%3$s]\u5b57\u7b26", (String)"BillValidaterHelper_170", (String)"imc-sim-service", (Object[])new Object[0]), billNo, sellerTaxNo, 20);
            return errorMsg;
        }
        String sellerBankAndAccount = originBillDynamicObject.getString("salerbank");
        if (StringUtils.isNotBlank((CharSequence)sellerBankAndAccount)) {
            Pair pairMap = AddressSplitHelper.splitBankAndName((String)sellerBankAndAccount);
            String sellerBankName = (String)pairMap.getKey();
            if (StringUtils.isNotBlank((CharSequence)sellerBankName) && sellerBankName.length() > 100) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u9500\u65b9\u5f00\u6237\u884c\u540d\u79f0[%2$s]\u8d85\u8fc7\u53d1\u7968\u53ef\u5f00\u5177\u6700\u5927\u957f\u5ea6[%3$s]\u5b57\u7b26", (String)"BillValidaterHelper_171", (String)"imc-sim-service", (Object[])new Object[0]), billNo, sellerBankName, 100);
                return errorMsg;
            }
            String sellerBankNo = (String)pairMap.getValue();
            if (StringUtils.isNotBlank((CharSequence)sellerBankNo) && sellerBankNo.length() > 50) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u9500\u65b9\u94f6\u884c\u8d26\u53f7[%2$s]\u8d85\u8fc7\u53d1\u7968\u53ef\u5f00\u5177\u6700\u5927\u957f\u5ea6[%3$s]\u5b57\u7b26", (String)"BillValidaterHelper_172", (String)"imc-sim-service", (Object[])new Object[0]), billNo, sellerBankNo, 50);
                return errorMsg;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(sellerAddressAndTel = originBillDynamicObject.getString("buyeraddr")))) {
            Pair pairMap = AddressSplitHelper.splitAddressAndTel((String)sellerAddressAndTel);
            String sellerAddress = (String)pairMap.getKey();
            if (StringUtils.isNotBlank((CharSequence)sellerAddress) && sellerAddress.length() > 100) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u9500\u65b9\u5730\u5740[%2$s]\u8d85\u8fc7\u53d1\u7968\u53ef\u5f00\u5177\u6700\u5927\u957f\u5ea6[%3$s]\u5b57\u7b26", (String)"BillValidaterHelper_173", (String)"imc-sim-service", (Object[])new Object[0]), billNo, sellerAddress, 100);
                return errorMsg;
            }
            String sellerTel = (String)pairMap.getValue();
            if (StringUtils.isNotBlank((CharSequence)sellerTel) && sellerTel.length() > 20) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u9500\u65b9\u5730\u5740\u7535\u8bdd[%2$s]\u8d85\u8fc7\u53d1\u7968\u53ef\u5f00\u5177\u6700\u5927\u957f\u5ea6[%3$s]\u5b57\u7b26", (String)"BillValidaterHelper_174", (String)"imc-sim-service", (Object[])new Object[0]), billNo, sellerTel, 20);
                return errorMsg;
            }
        }
        return null;
    }
}

