/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper;

import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.InvoiceTypeNewEnum;
import kd.imc.bdm.common.dto.BillDetailNewVo;
import kd.imc.bdm.common.dto.BillNewVo;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.helper.AddressSplitHelper;
import kd.imc.bdm.common.openapi.alle.AllEInvoiceRequestDTO;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class OriginalBillValidateHelper {
    public static ApiResult dealValidateBillNewVoMethod(List<BillNewVo> billNewVos) {
        String errorMsg = OriginalBillValidateHelper.dealCheckBillNewVoParamMethod(billNewVos);
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)errorMsg);
        }
        errorMsg = OriginalBillValidateHelper.dealCheckBillMatchRuleMethod(billNewVos);
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)errorMsg);
        }
        return null;
    }

    private static String dealCheckBillNewVoParamMethod(List<BillNewVo> billNewVos) {
        HashSet<String> batchNoSet = new HashSet<String>(8);
        for (BillNewVo billNewVo : billNewVos) {
            DynamicObject originalBill;
            String businessSystemCode = billNewVo.getBusinessSystemCode();
            if (StringUtils.isNotBlank((CharSequence)businessSystemCode) && (businessSystemCode.length() < 2 || businessSystemCode.length() > 50)) {
                return ResManager.loadKDString((String)"\u6765\u6e90\u4e1a\u52a1\u7cfb\u7edf\u7b80\u79f0\u957f\u5ea6\u9650\u5236\u8303\u56f4[2-50]\u4e2a\u5b57\u7b26\uff01", (String)"OriginalBillValidateHelper_0", (String)"imc-sim-service", (Object[])new Object[0]);
            }
            String batchNo = billNewVo.getBatchNo();
            if (StringUtils.isBlank((CharSequence)batchNo)) {
                return ResManager.loadKDString((String)"\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"OriginalBillValidateHelper_1", (String)"imc-sim-service", (Object[])new Object[0]);
            }
            if (batchNo.length() > 50) {
                return ResManager.loadKDString((String)"\u6279\u6b21\u53f7\u957f\u5ea6\u4e0d\u80fd\u591f\u8d85\u8fc750\u4e2a\u5b57\u7b26\uff01", (String)"OriginalBillValidateHelper_2", (String)"imc-sim-service", (Object[])new Object[0]);
            }
            String billNo = billNewVo.getBillNo();
            if (StringUtils.isBlank((CharSequence)billNo)) {
                return ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"OriginalBillValidateHelper_3", (String)"imc-sim-service", (Object[])new Object[0]);
            }
            if (billNo.length() > 50) {
                return ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u957f\u5ea6\u4e0d\u80fd\u591f\u8d85\u8fc750\u4e2a\u5b57\u7b26\uff01", (String)"OriginalBillValidateHelper_4", (String)"imc-sim-service", (Object[])new Object[0]);
            }
            QFilter qFilter = new QFilter("batchbelong", "=", (Object)batchNo).and("billno", "=", (Object)billNo).and("validstate", "=", (Object)"2");
            if (StringUtils.isNotBlank((CharSequence)businessSystemCode)) {
                qFilter = qFilter.and("systemsource", "=", (Object)businessSystemCode);
            }
            if ((originalBill = BusinessDataServiceHelper.loadSingle((String)"sim_original_bill", (QFilter[])qFilter.toArray())) != null) {
                return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6279\u6b21\u53f7:%1$s\uff0c\u4e0b\u7684\u8ba2\u5355\u53f7:%2$s\u6570\u636e\u5df2\u5b58\u5728\uff01", (String)"OriginalBillValidateHelper_5", (String)"imc-sim-service", (Object[])new Object[0]), batchNo, billNo);
            }
            BigDecimal totalAmount = billNewVo.getTotalAmount();
            if (totalAmount == null) {
                return ResManager.loadKDString((String)"\u5355\u636e\u4ef7\u7a0e\u5408\u8ba1\u603b\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"OriginalBillValidateHelper_6", (String)"imc-sim-service", (Object[])new Object[0]);
            }
            Integer totalRows = billNewVo.getTotalRows();
            if (totalRows == null || totalRows == 0) {
                return ResManager.loadKDString((String)"\u5355\u636e\u5408\u8ba1\u660e\u7ec6\u884c\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"OriginalBillValidateHelper_7", (String)"imc-sim-service", (Object[])new Object[0]);
            }
            String applyOrgCode = billNewVo.getApplyOrgCode();
            if (StringUtils.isNotBlank((CharSequence)applyOrgCode) && applyOrgCode.length() > 20) {
                return ResManager.loadKDString((String)"\u5355\u636e\u63d0\u4ea4\u7684\u7ec4\u7ec7\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u591f\u8d85\u8fc720\u4e2a\u5b57\u7b26\uff01", (String)"OriginalBillValidateHelper_8", (String)"imc-sim-service", (Object[])new Object[0]);
            }
            String invoiceOrgCode = billNewVo.getInvoiceOrgCode();
            if (StringUtils.isNotBlank((CharSequence)invoiceOrgCode) && invoiceOrgCode.length() > 20) {
                return ResManager.loadKDString((String)"\u5355\u636e\u5f00\u7968\u7684\u7ec4\u7ec7\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u591f\u8d85\u8fc720\u4e2a\u5b57\u7b26\uff01", (String)"OriginalBillValidateHelper_9", (String)"imc-sim-service", (Object[])new Object[0]);
            }
            String sellerTelephone = billNewVo.getSellerTelephone();
            if (StringUtils.isNotBlank((CharSequence)sellerTelephone) && sellerTelephone.length() > 30) {
                return ResManager.loadKDString((String)"\u9500\u65b9\u7535\u8bdd\u957f\u5ea6\u4e0d\u80fd\u591f\u8d85\u8fc730\u4e2a\u5b57\u7b26\uff01", (String)"OriginalBillValidateHelper_10", (String)"imc-sim-service", (Object[])new Object[0]);
            }
            String sellerAccountNumber = billNewVo.getSellerAccountNumber();
            if (StringUtils.isNotBlank((CharSequence)sellerAccountNumber) && sellerAccountNumber.length() > 30) {
                return ResManager.loadKDString((String)"\u9500\u65b9\u94f6\u884c\u8d26\u53f7\u957f\u5ea6\u4e0d\u80fd\u591f\u8d85\u8fc730\u4e2a\u5b57\u7b26\uff01", (String)"OriginalBillValidateHelper_11", (String)"imc-sim-service", (Object[])new Object[0]);
            }
            String buyerTelephone = billNewVo.getBuyerTelephone();
            if (StringUtils.isNotBlank((CharSequence)buyerTelephone) && buyerTelephone.length() > 30) {
                return ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9\u7535\u8bdd\u957f\u5ea6\u4e0d\u80fd\u591f\u8d85\u8fc730\u4e2a\u5b57\u7b26\uff01", (String)"OriginalBillValidateHelper_12", (String)"imc-sim-service", (Object[])new Object[0]);
            }
            String buyerAccountNumber = billNewVo.getBuyerAccountNumber();
            if (StringUtils.isNotBlank((CharSequence)buyerAccountNumber) && buyerAccountNumber.length() > 30) {
                return ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9\u94f6\u884c\u8d26\u53f7\u957f\u5ea6\u4e0d\u80fd\u591f\u8d85\u8fc730\u4e2a\u5b57\u7b26\uff01", (String)"OriginalBillValidateHelper_13", (String)"imc-sim-service", (Object[])new Object[0]);
            }
            String issuer = billNewVo.getIssuer();
            if (StringUtils.isNotBlank((CharSequence)issuer) && issuer.length() > 10) {
                return ResManager.loadKDString((String)"\u5f00\u7968\u4eba\u957f\u5ea6\u4e0d\u80fd\u591f\u8d85\u8fc710\u4e2a\u5b57\u7b26\uff01", (String)"OriginalBillValidateHelper_14", (String)"imc-sim-service", (Object[])new Object[0]);
            }
            String cashier = billNewVo.getCashier();
            if (StringUtils.isNotBlank((CharSequence)cashier) && cashier.length() > 10) {
                return ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u957f\u5ea6\u4e0d\u80fd\u591f\u8d85\u8fc710\u4e2a\u5b57\u7b26\uff01", (String)"OriginalBillValidateHelper_15", (String)"imc-sim-service", (Object[])new Object[0]);
            }
            String reviewer = billNewVo.getReviewer();
            if (StringUtils.isNotBlank((CharSequence)reviewer) && reviewer.length() > 10) {
                return ResManager.loadKDString((String)"\u590d\u6838\u4eba\u957f\u5ea6\u4e0d\u80fd\u591f\u8d85\u8fc710\u4e2a\u5b57\u7b26\uff01", (String)"OriginalBillValidateHelper_16", (String)"imc-sim-service", (Object[])new Object[0]);
            }
            List billDetailNewVoList = billNewVo.getBillLineDetail();
            if (billDetailNewVoList == null || billDetailNewVoList.isEmpty()) {
                return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8ba2\u5355\u53f7:%s\uff0c\u4e0d\u542b\u6709\u4efb\u4f55\u5355\u636e\u660e\u7ec6\u6570\u636e\uff01", (String)"OriginalBillValidateHelper_17", (String)"imc-sim-service", (Object[])new Object[0]), billNo);
            }
            if (totalRows.intValue() != billDetailNewVoList.size()) {
                return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8ba2\u5355\u53f7:%s\uff0c\u5408\u8ba1\u660e\u7ec6\u884c\u6570\u4e0e\u5b9e\u9645\u5355\u636e\u660e\u7ec6\u6570\u91cf\u4e0d\u4e00\u81f4\uff01", (String)"OriginalBillValidateHelper_18", (String)"imc-sim-service", (Object[])new Object[0]), billNo);
            }
            for (BillDetailNewVo billDetailNewVo : billDetailNewVoList) {
                String lineId = billDetailNewVo.getLineid();
                if (StringUtils.isBlank((CharSequence)lineId)) {
                    return ResManager.loadKDString((String)"\u5355\u636e\u660e\u7ec6\u7684\u884c\u53f7\u4e3a\u7a7a\uff01", (String)"OriginalBillValidateHelper_19", (String)"imc-sim-service", (Object[])new Object[0]);
                }
                int lineRow = Integer.parseInt(lineId);
                if (lineRow < 1 || lineRow > 9999) {
                    return ResManager.loadKDString((String)"\u5355\u636e\u660e\u7ec6\u7684\u884c\u53f7\u9650\u5236\u8303\u56f4[1-9999]", (String)"OriginalBillValidateHelper_20", (String)"imc-sim-service", (Object[])new Object[0]);
                }
                String detailId = billDetailNewVo.getDetailId();
                if (StringUtils.isBlank((CharSequence)detailId)) {
                    return ResManager.loadKDString((String)"\u4e1a\u52a1\u7cfb\u7edf\u660e\u7ec6id\u4e3a\u7a7a\uff01", (String)"OriginalBillValidateHelper_21", (String)"imc-sim-service", (Object[])new Object[0]);
                }
                if (detailId.length() > 50) {
                    return ResManager.loadKDString((String)"\u4e1a\u52a1\u7cfb\u7edf\u660e\u7ec6id\u503c\u957f\u5ea6\u8d85\u8fc750\u4e2a\u5b57\u7b26\uff01", (String)"OriginalBillValidateHelper_22", (String)"imc-sim-service", (Object[])new Object[0]);
                }
                if (billDetailNewVo.getLineProperty() != 0) continue;
                return ResManager.loadKDString((String)"\u884c\u7c7b\u578b\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"OriginalBillValidateHelper_23", (String)"imc-sim-service", (Object[])new Object[0]);
            }
            batchNoSet.add(batchNo);
        }
        Integer batchQuantity = billNewVos.get(0).getBatchQuantity();
        if (batchNoSet.size() > 1) {
            return ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u51fa\u73b0\u591a\u4e2a\u4e0d\u540c\u6279\u6b21\u53f7\u8ba2\u5355\uff01", (String)"OriginalBillValidateHelper_24", (String)"imc-sim-service", (Object[])new Object[0]);
        }
        if (batchNoSet.size() == 1 && batchQuantity != null && batchQuantity <= 0) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u6279\u6b21\u53f7\u4e0b\uff0c\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0\uff01", (String)"OriginalBillValidateHelper_35", (String)"imc-sim-service", (Object[])new Object[0]);
        }
        if (batchQuantity != null && batchQuantity > 0 && batchQuantity.intValue() != billNewVos.size()) {
            return ResManager.loadKDString((String)"\u540c\u4e00\u6279\u6b21\u53f7\uff0c\u5355\u636e\u6570\u91cf\u4e0d\u4e00\u81f4\uff01", (String)"OriginalBillValidateHelper_25", (String)"imc-sim-service", (Object[])new Object[0]);
        }
        return null;
    }

    public static String dealCheckBillVoMethod(List<BillVo> bills) {
        HashSet<String> batchNoSet = new HashSet<String>(8);
        HashSet<Integer> autoMergeSet = new HashSet<Integer>(8);
        for (BillVo billVo : bills) {
            String batchNo = billVo.getBatchNo();
            if (StringUtils.isNotBlank((CharSequence)batchNo)) {
                batchNoSet.add(batchNo);
            }
            int autoMerge = billVo.getAutoMerge();
            autoMergeSet.add(autoMerge);
        }
        String errorMsg = null;
        if (batchNoSet.size() > 1) {
            errorMsg = ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u51fa\u73b0\u591a\u4e2a\u4e0d\u540c\u6279\u6b21\u53f7\u8ba2\u5355\uff01", (String)"OriginalBillValidateHelper_24", (String)"imc-sim-service", (Object[])new Object[0]);
        }
        if (autoMergeSet.size() > 1) {
            errorMsg = ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u51fa\u73b0\u591a\u79cd\u5408\u5e76\u89c4\u5219\uff01", (String)"OriginalBillValidateHelper_34", (String)"imc-sim-service", (Object[])new Object[0]);
        }
        return errorMsg;
    }

    private static String dealCheckBillMatchRuleMethod(List<BillNewVo> billNewVos) {
        for (BillNewVo billNewVo : billNewVos) {
            String businessSystemCode = billNewVo.getBusinessSystemCode();
            boolean flag = OriginalBillValidateHelper.checkIsMatchRule("^[a-zA-Z0-9_-]+$", businessSystemCode);
            if (!flag) {
                return ResManager.loadKDString((String)"\u6765\u6e90\u4e1a\u52a1\u7cfb\u7edf\u4e0d\u7b26\u5408\u89c4\u5219\uff01", (String)"OriginalBillValidateHelper_26", (String)"imc-sim-service", (Object[])new Object[0]);
            }
            String batchNo = billNewVo.getBatchNo();
            flag = OriginalBillValidateHelper.checkIsMatchRule("^[a-zA-Z0-9_-]+$", batchNo);
            if (!flag) {
                return ResManager.loadKDString((String)"\u6279\u6b21\u53f7\u4e0d\u7b26\u5408\u89c4\u5219\uff01", (String)"OriginalBillValidateHelper_27", (String)"imc-sim-service", (Object[])new Object[0]);
            }
            String billNo = billNewVo.getBillNo();
            flag = OriginalBillValidateHelper.checkIsMatchRule("^[a-zA-Z0-9_-]+$", billNo);
            if (!flag) {
                return ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e0d\u7b26\u5408\u89c4\u5219\uff01", (String)"OriginalBillValidateHelper_28", (String)"imc-sim-service", (Object[])new Object[0]);
            }
            String contractNo = billNewVo.getContractNo();
            flag = OriginalBillValidateHelper.checkIsMatchRule("^[a-zA-Z0-9_-]+$", contractNo);
            if (!flag) {
                return ResManager.loadKDString((String)"\u5355\u636e\u5bf9\u5e94\u5408\u540c\u7f16\u53f7\u4e0d\u7b26\u5408\u89c4\u5219\uff01", (String)"OriginalBillValidateHelper_29", (String)"imc-sim-service", (Object[])new Object[0]);
            }
            String applyOrgCode = billNewVo.getApplyOrgCode();
            flag = OriginalBillValidateHelper.checkIsMatchRule("^[a-zA-Z0-9_-]+$", applyOrgCode);
            if (!flag) {
                return ResManager.loadKDString((String)"\u5355\u636e\u63d0\u4ea4\u7684\u7ec4\u7ec7\u7f16\u7801\u4e0d\u7b26\u5408\u89c4\u5219\uff01", (String)"OriginalBillValidateHelper_30", (String)"imc-sim-service", (Object[])new Object[0]);
            }
            String invoiceOrgCode = billNewVo.getInvoiceOrgCode();
            flag = OriginalBillValidateHelper.checkIsMatchRule("^[a-zA-Z0-9_-]+$", invoiceOrgCode);
            if (!flag) {
                return ResManager.loadKDString((String)"\u5355\u636e\u5f00\u7968\u7684\u7ec4\u7ec7\u7f16\u7801\u4e0d\u7b26\u5408\u89c4\u5219\uff01", (String)"OriginalBillValidateHelper_31", (String)"imc-sim-service", (Object[])new Object[0]);
            }
            String invoiceType = billNewVo.getInvoiceType();
            if (StringUtils.isBlank((CharSequence)invoiceType)) {
                invoiceType = "A01";
            }
            if (!(flag = InvoiceTypeNewEnum.checkIsMatchInvoiceType((String)invoiceType))) {
                return ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b\u53c2\u6570\u672a\u5339\u914d\u5230\uff01", (String)"OriginalBillValidateHelper_32", (String)"imc-sim-service", (Object[])new Object[0]);
            }
            List billDetailNewVoList = billNewVo.getBillLineDetail();
            for (BillDetailNewVo billDetailNewVo : billDetailNewVoList) {
                String detailId = billDetailNewVo.getDetailId();
                flag = OriginalBillValidateHelper.checkIsMatchRule("^[a-zA-Z0-9_-]+$", detailId);
                if (flag) continue;
                return ResManager.loadKDString((String)"\u4e1a\u52a1\u7cfb\u7edf\u660e\u7ec6id\u4e0d\u7b26\u5408\u89c4\u5219\uff01", (String)"OriginalBillValidateHelper_33", (String)"imc-sim-service", (Object[])new Object[0]);
            }
        }
        return null;
    }

    private static boolean checkIsMatchRule(String regex, String text) {
        if (StringUtils.isBlank((CharSequence)text) || StringUtils.isBlank((CharSequence)regex)) {
            return true;
        }
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        return matcher.matches();
    }

    public static ApiResult dealValidateBuyerSellerInfo(BillVo bill) {
        String sellerAddressAndTel;
        String sellerName;
        String buyerAddressAndTel;
        String invoiceType = bill.getInvoiceType();
        if (InvoiceType.checkIsTaxInvoice((String)invoiceType)) {
            return null;
        }
        String buyerName = bill.getBuyerName();
        if (StringUtils.isNotBlank((CharSequence)buyerName) && buyerName.length() > 100) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_BUYERNAME_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_BUYERNAME_CHECK.getMsg());
        }
        String buyerTaxNo = bill.getBuyerTaxpayerId();
        if (StringUtils.isNotBlank((CharSequence)buyerTaxNo) && buyerTaxNo.length() > 20) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_BUYERID_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_BUYERID_CHECK.getMsg());
        }
        String buyerBankAndAccount = bill.getBuyerBankAndAccount();
        if (StringUtils.isNotBlank((CharSequence)buyerBankAndAccount)) {
            Pair pairMap = AddressSplitHelper.splitBankAndName((String)buyerBankAndAccount);
            String buyerBankName = (String)pairMap.getKey();
            if (StringUtils.isNotBlank((CharSequence)buyerBankName) && buyerBankName.length() > 100) {
                return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_BUYERACCOUNTNAME_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_BUYERACCOUNTNAME_CHECK.getMsg());
            }
            String buyerBankNo = (String)pairMap.getValue();
            if (StringUtils.isNotBlank((CharSequence)buyerBankNo) && buyerBankNo.length() > 50) {
                return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_BUYERACCOUNT_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_BUYERACCOUNT_CHECK.getMsg());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(buyerAddressAndTel = bill.getBuyerAddressAndTel()))) {
            Pair pairMap = AddressSplitHelper.splitAddressAndTel((String)buyerAddressAndTel);
            String buyerAddress = (String)pairMap.getKey();
            if (StringUtils.isNotBlank((CharSequence)buyerAddress) && buyerAddress.length() > 100) {
                return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_BUYERADDRESS_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_BUYERADDRESS_CHECK.getMsg());
            }
            String buyerTel = (String)pairMap.getValue();
            if (StringUtils.isNotBlank((CharSequence)buyerTel) && buyerTel.length() > 20) {
                return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_BUYERTEL_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_BUYERTEL_CHECK.getMsg());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(sellerName = bill.getSellerName())) && sellerName.length() > 100) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_SELLERNAME_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_SELLERNAME_CHECK.getMsg());
        }
        String sellerTaxNo = bill.getSellerTaxpayerId();
        if (StringUtils.isNotBlank((CharSequence)sellerTaxNo) && sellerTaxNo.length() > 20) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_SELLERID_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_SELLERID_CHECK.getMsg());
        }
        String sellerBankAndAccount = bill.getSellerBankAndAccount();
        if (StringUtils.isNotBlank((CharSequence)sellerBankAndAccount)) {
            Pair pairMap = AddressSplitHelper.splitBankAndName((String)sellerBankAndAccount);
            String sellerBankName = (String)pairMap.getKey();
            if (StringUtils.isNotBlank((CharSequence)sellerBankName) && sellerBankName.length() > 100) {
                return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_SELLERACCOUNTNAME_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_SELLERACCOUNTNAME_CHECK.getMsg());
            }
            String sellerBankNo = (String)pairMap.getValue();
            if (StringUtils.isNotBlank((CharSequence)sellerBankNo) && sellerBankNo.length() > 50) {
                return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_SELLERACCOUNT_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_SELLERACCOUNT_CHECK.getMsg());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(sellerAddressAndTel = bill.getSellerAddressAndTel()))) {
            Pair pairMap = AddressSplitHelper.splitAddressAndTel((String)sellerAddressAndTel);
            String sellerAddress = (String)pairMap.getKey();
            if (StringUtils.isNotBlank((CharSequence)sellerAddress) && sellerAddress.length() > 100) {
                return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_SELLERADDRESS_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_SELLERADDRESS_CHECK.getMsg());
            }
            String sellerTel = (String)pairMap.getValue();
            if (StringUtils.isNotBlank((CharSequence)sellerTel) && sellerTel.length() > 20) {
                return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_SELLERTEL_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_SELLERTEL_CHECK.getMsg());
            }
        }
        return null;
    }

    public static ApiResult dealCheckBuyerInfoByIssueInvoice(AllEInvoiceRequestDTO invoiceDTO) {
        String invoiceType = invoiceDTO.getInvoiceType();
        ImmutableSet invoiceTypeSet = ImmutableSet.of((Object)"01", (Object)"02");
        if (!invoiceTypeSet.contains((Object)invoiceType)) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ALLE_INVOICE_TYPE_ERROR.getCode(), (String)ApiErrCodeEnum.ALLE_INVOICE_TYPE_ERROR.getMsg());
        }
        String buyerName = invoiceDTO.getBuyerName();
        if (StringUtils.isNotBlank((CharSequence)buyerName) && buyerName.length() > 100) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_BUYERNAME_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_BUYERNAME_CHECK.getMsg());
        }
        String buyerTaxNo = invoiceDTO.getBuyerTaxpayerId();
        if (StringUtils.isNotBlank((CharSequence)buyerTaxNo) && buyerTaxNo.length() > 20) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_BUYERID_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_BUYERID_CHECK.getMsg());
        }
        String buyerBankName = invoiceDTO.getBuyerBank();
        if (StringUtils.isNotBlank((CharSequence)buyerBankName) && buyerBankName.length() > 100) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_BUYERACCOUNTNAME_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_BUYERACCOUNTNAME_CHECK.getMsg());
        }
        String buyerBankAccount = invoiceDTO.getBuyerBankAccount();
        if (StringUtils.isNotBlank((CharSequence)buyerBankAccount) && buyerBankAccount.length() > 50) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_BUYERACCOUNT_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_BUYERACCOUNT_CHECK.getMsg());
        }
        String buyerAddress = invoiceDTO.getBuyerAddress();
        if (StringUtils.isNotBlank((CharSequence)buyerAddress) && buyerAddress.length() > 100) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_BUYERADDRESS_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_BUYERADDRESS_CHECK.getMsg());
        }
        String buyerTel = invoiceDTO.getBuyerTel();
        if (StringUtils.isNotBlank((CharSequence)buyerTel) && buyerTel.length() > 20) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_BUYERTEL_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_BUYERTEL_CHECK.getMsg());
        }
        return null;
    }

    public static ApiResult dealCheckSellerInfoByIssueInvoice(AllEInvoiceRequestDTO invoiceDTO) {
        String invoiceType = invoiceDTO.getInvoiceType();
        ImmutableSet invoiceTypeSet = ImmutableSet.of((Object)"01", (Object)"02");
        if (!invoiceTypeSet.contains((Object)invoiceType)) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ALLE_INVOICE_TYPE_ERROR.getCode(), (String)ApiErrCodeEnum.ALLE_INVOICE_TYPE_ERROR.getMsg());
        }
        String sellerName = invoiceDTO.getSellerName();
        if (StringUtils.isNotBlank((CharSequence)sellerName) && sellerName.length() > 100) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_SELLERNAME_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_SELLERNAME_CHECK.getMsg());
        }
        String sellerTaxNo = invoiceDTO.getSellerTaxpayerId();
        if (StringUtils.isNotBlank((CharSequence)sellerTaxNo) && sellerTaxNo.length() > 20) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_SELLERID_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_SELLERID_CHECK.getMsg());
        }
        String sellerBankName = invoiceDTO.getSellerBank();
        if (StringUtils.isNotBlank((CharSequence)sellerBankName) && sellerBankName.length() > 100) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_SELLERACCOUNTNAME_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_SELLERACCOUNTNAME_CHECK.getMsg());
        }
        String sellerBankAccount = invoiceDTO.getSellerBankAccount();
        if (StringUtils.isNotBlank((CharSequence)sellerBankAccount) && sellerBankAccount.length() > 50) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_SELLERACCOUNT_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_SELLERACCOUNT_CHECK.getMsg());
        }
        String sellerAddress = invoiceDTO.getSellerAddress();
        if (StringUtils.isNotBlank((CharSequence)sellerAddress) && sellerAddress.length() > 100) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_SELLERADDRESS_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_SELLERADDRESS_CHECK.getMsg());
        }
        String sellerTel = invoiceDTO.getSellerTel();
        if (StringUtils.isNotBlank((CharSequence)sellerTel) && sellerTel.length() > 20) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_SELLERTEL_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_SELLERTEL_CHECK.getMsg());
        }
        return null;
    }

    public static ApiResult dealCheckBuyerInfoByQuickRed(String buyerName, String buyerTaxpayerId, String buyerBank, String buyerBankAccount, String buyerTel, String buyerAddress) {
        if (StringUtils.isNotBlank((CharSequence)buyerName) && buyerName.length() > 100) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_BUYERNAME_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_BUYERNAME_CHECK.getMsg());
        }
        if (StringUtils.isNotBlank((CharSequence)buyerTaxpayerId) && buyerTaxpayerId.length() > 20) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_BUYERID_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_BUYERID_CHECK.getMsg());
        }
        if (StringUtils.isNotBlank((CharSequence)buyerBank) && buyerBank.length() > 100) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_BUYERACCOUNTNAME_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_BUYERACCOUNTNAME_CHECK.getMsg());
        }
        if (StringUtils.isNotBlank((CharSequence)buyerBankAccount) && buyerBankAccount.length() > 50) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_BUYERACCOUNT_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_BUYERACCOUNT_CHECK.getMsg());
        }
        if (StringUtils.isNotBlank((CharSequence)buyerAddress) && buyerAddress.length() > 100) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_BUYERADDRESS_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_BUYERADDRESS_CHECK.getMsg());
        }
        if (StringUtils.isNotBlank((CharSequence)buyerTel) && buyerTel.length() > 20) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_BUYERTEL_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_BUYERTEL_CHECK.getMsg());
        }
        return null;
    }

    public static ApiResult dealCheckSellerInfoByQuickRed(String sellerName, String sellerTaxpayerId, String sellerBank, String sellerBankAccount, String sellerTel, String sellerAddress) {
        if (StringUtils.isNotBlank((CharSequence)sellerName) && sellerName.length() > 100) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_SELLERNAME_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_SELLERNAME_CHECK.getMsg());
        }
        if (StringUtils.isNotBlank((CharSequence)sellerTaxpayerId) && sellerTaxpayerId.length() > 20) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_SELLERID_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_SELLERID_CHECK.getMsg());
        }
        if (StringUtils.isNotBlank((CharSequence)sellerBank) && sellerBank.length() > 100) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_SELLERACCOUNTNAME_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_SELLERACCOUNTNAME_CHECK.getMsg());
        }
        if (StringUtils.isNotBlank((CharSequence)sellerBankAccount) && sellerBankAccount.length() > 50) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_SELLERACCOUNT_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_SELLERACCOUNT_CHECK.getMsg());
        }
        if (StringUtils.isNotBlank((CharSequence)sellerAddress) && sellerAddress.length() > 100) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_SELLERADDRESS_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_SELLERADDRESS_CHECK.getMsg());
        }
        if (StringUtils.isNotBlank((CharSequence)sellerTel) && sellerTel.length() > 20) {
            return ResponseVo.fail((String)ApiErrCodeEnum.INVOICE_OPEN_SELLERTEL_CHECK.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_SELLERTEL_CHECK.getMsg());
        }
        return null;
    }
}

