/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.control;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.dto.SaleAddrAndPayeeDTO;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.SchemeHelper;
import kd.imc.bdm.common.model.DrawerInfo;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.UUID;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.helper.DrawerStrategyWithFilterHelper;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginalBillPluginBaseControl;
import kd.imc.sim.formplugin.match.ConditionMatchHelper;
import kd.sdk.annotation.SdkDeprecated;

public class OriginalBillPluginAddControl
extends OriginalBillPluginBaseControl {
    private static final String BILL_PURCHASE = "BILL_PURCHASE";
    public static final String FROM_ADD_NEW = "FROM_ADD_NEW";

    public static void initNewBill(AbstractFormPlugin formPlugin, IFormView view) {
        String billNo = String.valueOf(view.getModel().getValue("billno"));
        if (StringUtils.isBlank((CharSequence)billNo)) {
            view.getModel().setValue("billno", (Object)new StringBuffer("INV_").append(UUID.getBatchNumber()));
        }
        long orgId = OriginalBillPluginAddControl.getOrgId(formPlugin);
        SaleInfo saleInfoByOrg = TaxUtils.getSaleInfoByOrg((Long)orgId);
        SaleAddrAndPayeeDTO addrAndPayee = OriginalBillPluginAddControl.getAddrAndPayee(saleInfoByOrg, formPlugin.getView().getModel().getDataEntity());
        OriginalBillPluginAddControl.updateSellerInfo(view, addrAndPayee);
        view.getModel().setValue("confirmstate", (Object)"0");
        view.getModel().setValue("validstate", (Object)"0");
        if (StringUtils.isEmpty((CharSequence)formPlugin.getPageCache().get("fromCopy")) && !"3".equals(formPlugin.getView().getModel().getValue("billsource"))) {
            view.getModel().setValue("billproperties", (Object)"1");
            view.getModel().setValue("taxationstyle", (Object)"0");
        }
        view.setEnable(Boolean.TRUE, new String[]{"billproperties"});
        view.getModel().setValue("split", (Object)"1");
        view.getModel().setValue("priority", (Object)"0");
        if (StringUtils.isBlank((Object)view.getModel().getValue("BILLSOURCE"))) {
            view.getModel().setValue("billsource", (Object)"6");
        }
        view.getModel().setValue("originbillseq", (Object)("100_" + UUID.getBatchNumber() + "_0001"));
        String billStatus = (String)view.getModel().getValue("billstatus");
        if (StringUtils.isBlank((CharSequence)billStatus)) {
            view.getModel().setValue("billstatus", (Object)billStatus);
            view.getModel().setValue("comprehensivestatus", (Object)"11");
        }
        view.getModel().setValue("mergerule", SchemeHelper.getDefaultMergeRuleByOrg((long)orgId));
        view.getModel().setValue("creator", (Object)Long.parseLong(RequestContext.get().getUserId()));
        view.setEnable(Boolean.FALSE, new String[]{"salername"});
        view.setEnable(Boolean.FALSE, new String[]{"salertaxno"});
        view.setEnable(Boolean.TRUE, new String[]{"saleraddr"});
        view.setEnable(Boolean.TRUE, new String[]{"salerbank"});
        view.setEnable(Boolean.FALSE, new String[]{"salerorbuyer"});
        view.getPageCache().put(FROM_ADD_NEW, FROM_ADD_NEW);
        view.setEnable(Boolean.TRUE, new String[]{"billproperties"});
        view.setEnable(Boolean.TRUE, new String[]{"taxationstyle"});
        view.setEnable(Boolean.FALSE, new String[]{"validstate"});
        view.setVisible(Boolean.TRUE, new String[]{"itemdel", "newdiscountrow"});
        DrawerInfo drawerInfo = DrawerStrategyWithFilterHelper.getOriginalBillDrawerStrategy(view.getModel().getValue("jqbh"), view.getModel().getDataEntity());
        view.getModel().setValue("drawer", (Object)drawerInfo.getDrawer());
        view.getModel().setValue("payee", (Object)drawerInfo.getPayee());
        view.getModel().setValue("reviewer", (Object)drawerInfo.getReviewer());
        if (AllEleAuthHelper.elePaperSetValue((IDataModel)view.getModel())) {
            view.getModel().setValue("iselepaper", (Object)"1");
        }
    }

    @SdkDeprecated
    public static SaleAddrAndPayeeDTO getAddrAndPayee(SaleInfo saleInfo, DynamicObject bill) {
        if (saleInfo == null) {
            saleInfo = TaxUtils.getSaleInfoByOrg();
        }
        DynamicObject invoiceSettingObj = OriginalBillPluginAddControl.getSaleAddrBankByOrg(saleInfo, bill);
        String invoiceAddr = "";
        String openuserbank = "";
        if (invoiceSettingObj != null) {
            invoiceAddr = invoiceSettingObj.getString("invoiceaddr");
            openuserbank = invoiceSettingObj.getString("openuserbank");
        }
        return new SaleAddrAndPayeeDTO(saleInfo.getSaleName(), saleInfo.getSaleTaxNo(), openuserbank, invoiceAddr);
    }

    public static DynamicObject getSaleAddrBankByOrg(SaleInfo saleInfo, DynamicObject bill) {
        DynamicObject[] settings = TaxUtils.getSaleAddrBankArrByOrg((SaleInfo)saleInfo);
        if (null == settings || 0 == settings.length) {
            return null;
        }
        for (DynamicObject setting : settings) {
            String fiterTag = setting.getString("filter_tag");
            if (StringUtils.isEmpty((CharSequence)fiterTag) || !ConditionMatchHelper.verify((String)fiterTag, (DynamicObject)bill)) continue;
            return setting;
        }
        List defaultSettings = Arrays.stream(settings).filter(a -> a.getString("ischeck").equals("1")).collect(Collectors.toList());
        if (defaultSettings.size() > 0) {
            return (DynamicObject)defaultSettings.get(0);
        }
        return null;
    }

    public static void updateSellerInfo(IFormView view, SaleAddrAndPayeeDTO addrAndPayee) {
        if (StringUtils.isBlank((Object)view.getModel().getValue("salername"))) {
            view.getModel().setValue("salername", (Object)addrAndPayee.getSaleName());
        }
        if (StringUtils.isBlank((Object)view.getModel().getValue("salertaxno"))) {
            view.getModel().setValue("salertaxno", (Object)addrAndPayee.getSaleTaxNo());
        }
        if (StringUtils.isBlank((Object)view.getModel().getValue("saleraddr"))) {
            view.getModel().setValue("saleraddr", (Object)addrAndPayee.getInvoiceAddr());
        }
        if (StringUtils.isBlank((Object)view.getModel().getValue("salerbank"))) {
            view.getModel().setValue("salerbank", (Object)addrAndPayee.getOpenUserBank());
        }
    }

    public static void initBotpBill(AbstractFormPlugin formPlugin) {
        String splitRule;
        IFormView view = formPlugin.getView();
        view.setVisible(Boolean.TRUE, new String[]{"itemdel", "newdiscountrow"});
        long orgId = OriginalBillPluginAddControl.getOrgId(formPlugin);
        Object mergeRule = view.getModel().getValue("mergerule");
        if (null == mergeRule) {
            view.getModel().setValue("mergerule", SchemeHelper.getDefaultMergeRuleByOrg((long)orgId));
        }
        if (StringUtils.isBlank((CharSequence)(splitRule = (String)view.getModel().getValue("splitrule")))) {
            view.getModel().setValue("splitrule", (Object)"000000_s");
        }
        view.getModel().setValue("originbillseq", (Object)("100_" + UUID.getBatchNumber() + "_0001"));
        view.getModel().setValue("split", (Object)"1");
        view.setEnable(Boolean.TRUE, new String[]{"billproperties"});
        view.getModel().setValue("confirmstate", (Object)"0");
        view.getModel().setValue("validstate", (Object)"0");
        if (StringUtils.isBlank((Object)view.getModel().getValue("drawer"))) {
            DrawerInfo drawerInfo = DrawerStrategyWithFilterHelper.getOriginalBillDrawerStrategy(view.getModel().getValue("jqbh"), view.getModel().getDataEntity());
            view.getModel().setValue("drawer", (Object)drawerInfo.getDrawer());
            view.getModel().setValue("payee", (Object)drawerInfo.getPayee());
            view.getModel().setValue("reviewer", (Object)drawerInfo.getReviewer());
        }
        if (StringUtils.isBlank((Object)view.getModel().getValue("taxationstyle"))) {
            view.getModel().setValue("taxationstyle", (Object)"0");
        }
        EquipmentUtil.bindDefaultDev((AbstractFormPlugin)formPlugin, (String)"jqbh", (Long)orgId, (String)EquipmentUtil.getDefaultDevNoByOrg((Long)orgId));
        if (StringUtils.isBlank((Object)view.getModel().getValue("salername"))) {
            SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)orgId);
            SaleAddrAndPayeeDTO addrAndPayee = TaxUtils.getDefaultAddrAndPayee((SaleInfo)saleInfo);
            OriginalBillPluginAddControl.updateSellerInfo(view, addrAndPayee);
        }
    }

    public static void setPurchaseInvoiceCaption(AbstractFormPlugin formPlugin, IFormView view) {
        if (InvoiceUtils.isAllEInvoice((Object)((String)view.getModel().getValue("invoicetype"))) || AllEleAuthHelper.isElePaper((Object)view.getModel().getValue("invoicetype"))) {
            view.setVisible(Boolean.TRUE, new String[]{"cardtype"});
        }
        OriginalBillPluginAddControl.setCaptionByName(view, "salername", ResManager.loadKDString((String)"\u8d2d\u65b9\u540d\u79f0", (String)"OriginalBillPluginAddControl_0", (String)"imc-sim-service", (Object[])new Object[0]));
        Label buyernamelaber = (Label)view.getControl("buyernamelaber");
        buyernamelaber.setText(ResManager.loadKDString((String)"\u9500\u552e\u65b9", (String)"OriginalBillPluginAddControl_4", (String)"imc-sim-service", (Object[])new Object[0]));
        Label selleramelaber = (Label)view.getControl("selleramelaber");
        selleramelaber.setText(ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9", (String)"OriginalBillPluginAddControl_5", (String)"imc-sim-service", (Object[])new Object[0]));
        OriginalBillPluginAddControl.setCaptionByName(view, "buyername", ResManager.loadKDString((String)"\u9500\u65b9\u540d\u79f0", (String)"OriginalBillPluginAddControl_1", (String)"imc-sim-service", (Object[])new Object[0]));
        ComboEdit buyerProperty = (ComboEdit)view.getControl("buyerproperty");
        buyerProperty.setCaption(new LocaleString(ResManager.loadKDString((String)"\u9500\u65b9\u4f01\u4e1a\u7c7b\u578b", (String)"OriginalBillPluginAddControl_2", (String)"imc-sim-service", (Object[])new Object[0])));
        formPlugin.getPageCache().put(BILL_PURCHASE, "true");
        ViewUtil.showComboEditByKey((IFormView)formPlugin.getView(), (String)"invoicetype", (Set)Sets.newHashSet((Object[])new String[]{InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode(), InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode(), InvoiceType.ALL_E_NORMAL.getTypeCode()}), (boolean)false, null);
    }

    public static void setNormalInvoiceCaption(AbstractFormPlugin formPlugin, IFormView view) {
        OriginalBillPluginAddControl.setCaptionByName(view, "buyername", ResManager.loadKDString((String)"\u8d2d\u65b9\u540d\u79f0", (String)"OriginalBillPluginAddControl_0", (String)"imc-sim-service", (Object[])new Object[0]));
        Label buyernamelaber = (Label)view.getControl("buyernamelaber");
        Label selleramelaber = (Label)view.getControl("selleramelaber");
        buyernamelaber.setText(ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9", (String)"OriginalBillPluginAddControl_5", (String)"imc-sim-service", (Object[])new Object[0]));
        selleramelaber.setText(ResManager.loadKDString((String)"\u9500\u552e\u65b9", (String)"OriginalBillPluginAddControl_4", (String)"imc-sim-service", (Object[])new Object[0]));
        OriginalBillPluginAddControl.setCaptionByName(view, "salername", ResManager.loadKDString((String)"\u9500\u65b9\u540d\u79f0", (String)"OriginalBillPluginAddControl_1", (String)"imc-sim-service", (Object[])new Object[0]));
        ComboEdit buyerProperty = (ComboEdit)view.getControl("buyerproperty");
        buyerProperty.setCaption(new LocaleString(ResManager.loadKDString((String)"\u8d2d\u65b9\u4f01\u4e1a\u7c7b\u578b", (String)"OriginalBillPluginAddControl_3", (String)"imc-sim-service", (Object[])new Object[0])));
        formPlugin.getPageCache().put(BILL_PURCHASE, "false");
        ViewUtil.showComboEditAll((IFormView)view, (String)"invoicetype", (boolean)false, null);
        if ("-1".equals(view.getModel().getValue("billproperties"))) {
            view.getModel().setValue("salerorbuyer", (Object)"0");
        }
    }

    public static void setCaptionByName(IFormView view, String name, String value) {
        FieldEdit control = (FieldEdit)view.getControl(name);
        control.setCaption(new LocaleString(value));
    }

    private static long getOrgId(AbstractFormPlugin plugin) {
        return plugin.getView().getModel().getValue("orgid") == null ? RequestContext.get().getOrgId() : DynamicObjectUtil.getDynamicObjectLongValue((Object)plugin.getView().getModel().getValue("orgid"));
    }
}

