/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.control;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.ReducedHelper;
import kd.imc.bdm.common.helper.invoice.ReduceOnePoint5Helper;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.model.invoice.TaxedTypeEnum;
import kd.imc.sim.common.model.invoice.ZzstsglEnum;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginalBillPluginZSFSControl;

public class OriginalBillPluginBaseControl {
    public static final String KEY_ENTRY_ENTITY = "sim_original_bill_item";
    public static final String DO_NOT_CHANGE_NUM = "do_not_change_num";
    public static final String DO_NOT_CHANGE_AMOUNT = "do_not_change_amount";
    public static final String DO_NOT_CHANGE_TAX_AMOUNT = "do_not_change_tax_amount";
    public static final String DO_NOT_CHANGE_UNIT_PRICE = "do_not_change_unit_price";
    public static final String DO_NOT_CHANGE_TAX_RATE = "do_not_change_tax_rate";
    public static final String DO_NOT_CHANGE_TAX_UNIT_PRICE = "do_not_change_tax_unit_price";
    public static final String DO_NOT_CHANGE_TAX = "do_not_change_tax";
    public static final String DO_NOT_CHANGE_YHZC = "do_not_change_yhzc";
    public static final String DO_NOT_CHANGE_YHZCNR = "do_not_change_yhzcnr";
    public static final String DO_NOT_CHANGE_ZSFS = "do_not_change_zsfs";
    public static final String ROW_ROW_TYPE = "rowtype";
    public static final String ROW_TAX = "tax";
    public static final String ROW_NUM = "num";
    public static final String SWITCH_TAX_FLAG = "hsbz";
    public static final String ROW_UNIT_PRICE = "unitprice";
    public static final String ROW_TAX_UNIT_PRICE = "taxunitprice";
    public static final String ROW_AMOUNT = "amount";
    public static final String ROW_TAX_AMOUNT = "taxamount";
    public static final String ROW_TAX_RATE = "taxrate";
    public static final String ROW_REMAIN_NUM = "remainvalidnum";
    public static final String ROW_REMAIN_AMOUNT = "remainvalidamount";
    public static final String ROW_REMAIN_TAX = "remainvalidtax";
    public static final String DEDUCTION = "deduction";
    public static final String TAXATIONSTYLE = "taxationstyle";

    protected static boolean checkUnitPriceGreaterZero(AbstractFormPlugin formPlugin, IFormView view, Object oldValue, int index, BigDecimal unitPrice, String cacheKey, String rowKey) {
        if (unitPrice.compareTo(BigDecimal.ZERO) < 0) {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u660e\u7ec6\u5355\u4ef7\u4e0d\u80fd\u5c0f\u4e8e0", (String)"OriginalBillPluginBaseControl_0", (String)"imc-sim-service", (Object[])new Object[0]), index + 1), Integer.valueOf(3000));
            OriginalBillPluginBaseControl.setRowValueWithCache(formPlugin, view, oldValue, index, cacheKey, rowKey);
            return false;
        }
        return true;
    }

    public static void setRowValueWithCache(AbstractFormPlugin formPlugin, IFormView view, Object value, int index, String cacheKey, String rowKey) {
        formPlugin.getPageCache().put(cacheKey + index, "1");
        view.getModel().setValue(rowKey, value, index);
        formPlugin.getPageCache().remove(cacheKey + index);
    }

    public static boolean isCETaxStyle(IFormView view) {
        String taxationStyle = (String)view.getModel().getValue(TAXATIONSTYLE);
        return TaxedTypeEnum.deduction.getValue().equals(taxationStyle) || TaxedTypeEnum.alleTaxedTypeDeduction((String)taxationStyle);
    }

    public static BigDecimal updateDeductionTaxBHS(IFormView view, int i, BigDecimal taxRate, BigDecimal amount) {
        BigDecimal tax;
        if (!"1".equals(view.getModel().getValue(ROW_ROW_TYPE, i))) {
            BigDecimal subtract = amount.subtract((BigDecimal)view.getModel().getValue(DEDUCTION));
            tax = subtract.multiply(taxRate);
        } else {
            tax = OriginalBillPluginBaseControl.getZKItemTaxAmountByDeductionBHS(view, taxRate, (BigDecimal)view.getModel().getValue(ROW_TAX, 0));
        }
        return tax;
    }

    public static BigDecimal updateDeductionTaxHS(IFormView view, int index, BigDecimal taxAmount, BigDecimal taxRate) {
        BigDecimal tax;
        if (!"1".equals(view.getModel().getValue(ROW_ROW_TYPE, index))) {
            BigDecimal subtract = taxAmount.subtract((BigDecimal)view.getModel().getValue(DEDUCTION));
            tax = BigDecimal.ONE.divide(BigDecimal.ONE.add(taxRate), 15, RoundingMode.HALF_UP).multiply(taxRate).multiply(subtract).setScale(2, RoundingMode.HALF_UP);
        } else {
            tax = OriginalBillPluginBaseControl.getZKItemTaxAmountByDeductionHS(view, taxRate, (BigDecimal)view.getModel().getValue(ROW_TAX, 0));
        }
        return tax;
    }

    protected static BigDecimal getZKItemTaxAmountByDeductionBHS(IFormView view, BigDecimal taxRate, BigDecimal bzkTax) {
        BigDecimal zkAmount = (BigDecimal)view.getModel().getValue(ROW_AMOUNT, 1);
        BigDecimal zkTax = zkAmount.multiply(taxRate);
        if (bzkTax.add(zkTax).compareTo(BigDecimal.ZERO) < 0) {
            zkTax = bzkTax.negate();
        }
        return zkTax;
    }

    protected static BigDecimal getZKItemTaxAmountByDeductionHS(IFormView view, BigDecimal taxRate, BigDecimal bzkTax) {
        BigDecimal zkAmount;
        BigDecimal zkTaxAmount = (BigDecimal)view.getModel().getValue(ROW_TAX_AMOUNT, 1);
        BigDecimal zkTax = zkTaxAmount.subtract(zkAmount = zkTaxAmount.divide(BigDecimal.ONE.add(taxRate), 2, RoundingMode.HALF_UP));
        if (bzkTax.add(zkTax).compareTo(BigDecimal.ZERO) < 0) {
            zkTax = bzkTax.negate();
        }
        return zkTax;
    }

    public static void updateRowSurplusAndCanCommitAmountNumTax(IFormView view, BigDecimal num, BigDecimal amount, BigDecimal tax, int index) {
        if (num != null) {
            view.getModel().setValue(ROW_REMAIN_NUM, (Object)num, index);
        }
        if ("1".equals(view.getModel().getValue(SWITCH_TAX_FLAG))) {
            view.getModel().setValue(ROW_REMAIN_AMOUNT, (Object)amount.add(tax), index);
        } else {
            view.getModel().setValue(ROW_REMAIN_AMOUNT, (Object)amount, index);
        }
        view.getModel().setValue(ROW_REMAIN_TAX, (Object)tax, index);
    }

    public static boolean beforeAddRowCheck(IFormView view, int newRowIndex, int type) {
        IDataModel model = view.getModel();
        if (StringUtils.isEmpty((CharSequence)String.valueOf(model.getValue("goodscode", newRowIndex - 1)))) {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u672a\u586b\u5199", (String)"OriginalBillPluginBaseControl_1", (String)"imc-sim-service", (Object[])new Object[0]), newRowIndex), Integer.valueOf(3000));
            return false;
        }
        String taxRate = (String)model.getValue(ROW_TAX_RATE, newRowIndex - 1);
        if (StringUtils.isEmpty((CharSequence)taxRate) && newRowIndex > 0) {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillPluginBaseControl_2", (String)"imc-sim-service", (Object[])new Object[0]), newRowIndex), Integer.valueOf(3000));
            return false;
        }
        String taxationStyle = (String)model.getValue(TAXATIONSTYLE);
        if (TaxedTypeEnum.deduction.getValue().equals(taxationStyle) || TaxedTypeEnum.alleTaxedTypeDeduction((String)taxationStyle)) {
            BigDecimal amount = (BigDecimal)view.getModel().getValue(ROW_AMOUNT, newRowIndex - 1);
            if (amount != null && MathUtils.isZero((BigDecimal)amount)) {
                view.showTipNotification(String.format(ResManager.loadKDString((String)"\u5dee\u989d\u5f81\u7a0e\uff0c\u7b2c%1$s\u884c\u660e\u7ec6\u91d1\u989d\u4e0d\u80fd\u4e3a0", (String)"OriginalBillPluginBaseControl_3", (String)"imc-sim-service", (Object[])new Object[0]), newRowIndex), Integer.valueOf(3000));
                return false;
            }
            if (MathUtils.isZero((BigDecimal)((BigDecimal)model.getValue(DEDUCTION))) && !TaxedTypeEnum.all_e_deduction_full.getValue().equals(taxationStyle)) {
                if (TaxedTypeEnum.all_e_deduction.getValue().equals(taxationStyle)) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5dee\u989d\u5f81\u7a0e-\u5dee\u989d\u5f00\u7968\uff0c\u8bf7\u5148\u5f55\u5165\u5dee\u989d\u660e\u7ec6\uff0c\u5e76\u8f93\u5165\u672c\u6b21\u6263\u9664\u91d1\u989d", (String)"OriginalBillPluginBaseControl_4", (String)"imc-sim-service", (Object[])new Object[0]));
                } else {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5dee\u989d\u5f81\u7a0e\uff0c\u6263\u9664\u989d\u4e0d\u80fd\u4e3a0", (String)"OriginalBillPluginBaseControl_5", (String)"imc-sim-service", (Object[])new Object[0]));
                }
                return false;
            }
            if (type == 0 && newRowIndex > 0 || type == 1 && newRowIndex > 1) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5dee\u989d\u5f81\u7a0e\u53ea\u652f\u6301\u4e00\u884c\u5546\u54c1\u660e\u7ec6", (String)"OriginalBillPluginBaseControl_6", (String)"imc-sim-service", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    public static void updateBillTotalAmount(AbstractFormPlugin formPlugin) {
        DynamicObject[] items;
        IDataModel model = formPlugin.getView().getModel();
        IPageCache pageCache = formPlugin.getPageCache();
        boolean hsbz = "1".equals(formPlugin.getView().getModel().getValue(SWITCH_TAX_FLAG));
        BigDecimal oldTotalAmount = BigDecimal.ZERO;
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal invoiceAmount = BigDecimal.ZERO;
        BigDecimal totalTax = BigDecimal.ZERO;
        BigDecimal surplusAmount = BigDecimal.ZERO;
        BigDecimal surplusTax = BigDecimal.ZERO;
        EntryGrid grid = (EntryGrid)formPlugin.getControl(KEY_ENTRY_ENTITY);
        for (DynamicObject item : items = grid.getEntryData().getDataEntitys()) {
            if (item.getBoolean("gift")) continue;
            if (hsbz) {
                oldTotalAmount = oldTotalAmount.add(item.getBigDecimal(ROW_TAX_AMOUNT));
                totalAmount = totalAmount.add(item.getBigDecimal(ROW_TAX_AMOUNT));
                totalTax = totalTax.add(item.getBigDecimal(ROW_TAX_AMOUNT).subtract(item.getBigDecimal(ROW_AMOUNT)));
            } else {
                oldTotalAmount = oldTotalAmount.add(item.getBigDecimal(ROW_AMOUNT)).add(item.getBigDecimal(ROW_TAX));
                totalAmount = totalAmount.add(item.getBigDecimal(ROW_AMOUNT)).add(item.getBigDecimal(ROW_TAX));
                totalTax = totalTax.add(item.getBigDecimal(ROW_TAX));
            }
            invoiceAmount = invoiceAmount.add(item.getBigDecimal(ROW_AMOUNT));
            surplusAmount = surplusAmount.add(item.getBigDecimal(ROW_AMOUNT));
            surplusTax = surplusTax.add(item.getBigDecimal(ROW_TAX));
        }
        model.setValue("invoiceamount", (Object)invoiceAmount);
        model.setValue("totaltax", (Object)totalTax);
        model.setValue("surplusamount", (Object)surplusAmount);
        model.setValue("surplustax", (Object)totalTax);
        model.setValue("oldtotalamount", (Object)oldTotalAmount);
        model.setValue("totalamount", (Object)totalAmount);
        pageCache.remove("DIFF" + model.getValue("billno"));
    }

    protected static void updateRowValueByBHS(AbstractFormPlugin formPlugin, IFormView view, int index, BigDecimal num, BigDecimal taxRate, BigDecimal amount, Object oldValue, String rowKey) {
        boolean isAllEle;
        formPlugin.getPageCache().put(DO_NOT_CHANGE_AMOUNT + index, "1");
        formPlugin.getPageCache().put(DO_NOT_CHANGE_TAX_AMOUNT + index, "1");
        formPlugin.getPageCache().put(DO_NOT_CHANGE_TAX_UNIT_PRICE + index, "1");
        BigDecimal tax = amount.multiply(taxRate);
        BigDecimal taxAmount = amount.add(tax);
        Object invoiceType = view.getModel().getValue("invoicetype");
        Object isElePaper = view.getModel().getValue("iselepaper");
        boolean bl = isAllEle = InvoiceUtils.isAllEInvoice((Object)((String)invoiceType)) || "1".equals(isElePaper);
        if (!OriginalBillPluginZSFSControl.checkDeduction(view, amount)) {
            view.getModel().setValue(rowKey, oldValue, index);
            return;
        }
        Object policyConstants = view.getModel().getValue("policycontants", index);
        if (OriginalBillPluginBaseControl.isCETaxStyle(view) && !MathUtils.isZero((BigDecimal)amount)) {
            BigDecimal subtract = amount.subtract((BigDecimal)view.getModel().getValue(DEDUCTION));
            tax = subtract.multiply(taxRate);
            taxAmount = amount.add(tax).setScale(2, RoundingMode.HALF_UP);
            OriginalBillPluginZSFSControl.changeZKTaxBHS(formPlugin, view, index, taxRate, tax);
        } else if (ReducedHelper.isReduced((Object)view.getModel().getValue(TAXATIONSTYLE)) && ReducedHelper.isSpecialCalc((Object)policyConstants)) {
            DynamicObject taxRateObj = (DynamicObject)view.getModel().getValue("taxratecodeid");
            if (null != taxRateObj) {
                tax = ReducedHelper.calcTaxWithoutTax((Object)policyConstants, (BigDecimal)amount);
                taxAmount = tax.add(amount);
            }
        } else if (InvoiceUtils.isAllEInvoice((Object)view.getModel().getValue("invoicetype")) && new BigDecimal("0.015").compareTo(taxRate) == 0 && ZzstsglEnum.TEN.getDescription().equals(policyConstants)) {
            tax = ReduceOnePoint5Helper.getTaxAmountBHS((BigDecimal)amount, (BigDecimal)taxRate, (String)((String)view.getModel().getValue("goodscode", index)));
            taxAmount = tax.add(amount);
        } else {
            amount = taxAmount.divide(BigDecimal.ONE.add(taxRate), 2, RoundingMode.HALF_UP);
            tax = taxAmount.subtract(amount);
        }
        if (BotpHelper.isBotpCreateBill((AbstractFormPlugin)formPlugin)) {
            view.getModel().setValue("combineamount", (Object)taxAmount, index);
        }
        OriginalBillPluginBaseControl.setRowValueWithCache(formPlugin, view, amount, index, DO_NOT_CHANGE_AMOUNT, ROW_AMOUNT);
        OriginalBillPluginBaseControl.setRowValueWithCache(formPlugin, view, taxAmount, index, DO_NOT_CHANGE_TAX_AMOUNT, ROW_TAX_AMOUNT);
        OriginalBillPluginBaseControl.setRowValueWithCache(formPlugin, view, tax.setScale(2, RoundingMode.HALF_UP), index, DO_NOT_CHANGE_TAX, ROW_TAX);
        OriginalBillPluginBaseControl.updateRowSurplusAndCanCommitAmountNumTax(view, num, amount, tax, index);
        BigDecimal unitPrice = (BigDecimal)view.getModel().getValue(ROW_UNIT_PRICE, index);
        BigDecimal taxUnitPrice = PriceHelper.getTaxUnitPriceByBHS((BigDecimal)taxRate, (BigDecimal)num, (BigDecimal)taxAmount, (BigDecimal)unitPrice, (boolean)isAllEle);
        OriginalBillPluginBaseControl.setRowValueWithCache(formPlugin, view, taxUnitPrice, index, DO_NOT_CHANGE_TAX_UNIT_PRICE, ROW_TAX_UNIT_PRICE);
        formPlugin.getPageCache().remove(DO_NOT_CHANGE_AMOUNT + index);
        formPlugin.getPageCache().remove(DO_NOT_CHANGE_TAX_AMOUNT + index);
        formPlugin.getPageCache().remove(DO_NOT_CHANGE_TAX_UNIT_PRICE + index);
    }

    protected static void updateRowValueByHS(AbstractFormPlugin formPlugin, IFormView view, int index, BigDecimal taxRate, BigDecimal num, BigDecimal taxAmount) {
        BigDecimal amount;
        BigDecimal tax;
        boolean isAllEle;
        formPlugin.getPageCache().put(DO_NOT_CHANGE_AMOUNT + index, "1");
        formPlugin.getPageCache().put(DO_NOT_CHANGE_TAX_AMOUNT + index, "1");
        formPlugin.getPageCache().put(DO_NOT_CHANGE_UNIT_PRICE + index, "1");
        Object policyConstants = view.getModel().getValue("policycontants", index);
        BigDecimal reducedPrice = null;
        Object invoiceType = view.getModel().getValue("invoicetype");
        Object isElePaper = view.getModel().getValue("iselepaper");
        boolean bl = isAllEle = InvoiceUtils.isAllEInvoice((Object)((String)invoiceType)) || "1".equals(isElePaper);
        if (OriginalBillPluginBaseControl.isCETaxStyle(view)) {
            BigDecimal subtract = taxAmount.subtract((BigDecimal)view.getModel().getValue(DEDUCTION));
            tax = BigDecimal.ONE.divide(BigDecimal.ONE.add(taxRate), 15, RoundingMode.HALF_UP).multiply(taxRate).multiply(subtract).setScale(2, RoundingMode.HALF_UP);
            amount = taxAmount.subtract(tax);
            OriginalBillPluginZSFSControl.changeZKTaxHS(formPlugin, view, index, taxRate, tax);
        } else if (ReducedHelper.isReduced((Object)view.getModel().getValue(TAXATIONSTYLE)) && ReducedHelper.isSpecialCalc((Object)policyConstants)) {
            DynamicObject taxRateObj = (DynamicObject)view.getModel().getValue("taxratecodeid");
            tax = BigDecimal.ZERO;
            amount = BigDecimal.ZERO;
            if (null != taxRateObj) {
                tax = ReducedHelper.calcTaxWithTax((Object)policyConstants, (BigDecimal)taxAmount);
                amount = taxAmount.subtract(tax);
                reducedPrice = PriceHelper.calcPriceOrNum((BigDecimal)amount, (BigDecimal)num, (boolean)isAllEle);
            }
        } else if (InvoiceUtils.isAllEInvoice((Object)view.getModel().getValue("invoicetype")) && new BigDecimal("0.015").compareTo(taxRate) == 0 && ZzstsglEnum.TEN.getDescription().equals(policyConstants)) {
            tax = ReduceOnePoint5Helper.getTaxAmountHS((BigDecimal)taxAmount, (BigDecimal)taxRate, (String)((String)view.getModel().getValue("goodscode", index)));
            amount = taxAmount.subtract(tax);
            reducedPrice = PriceHelper.calcPriceOrNum((BigDecimal)amount, (BigDecimal)num, (boolean)isAllEle);
        } else {
            amount = taxAmount.divide(BigDecimal.ONE.add(taxRate), 2, RoundingMode.HALF_UP);
            tax = taxAmount.subtract(amount);
        }
        OriginalBillPluginBaseControl.setRowValueWithCache(formPlugin, view, tax, index, DO_NOT_CHANGE_TAX, ROW_TAX);
        OriginalBillPluginBaseControl.updateRowSurplusAndCanCommitAmountNumTax(view, num, amount, tax, index);
        BigDecimal taxUnitPrice = (BigDecimal)view.getModel().getValue(ROW_TAX_UNIT_PRICE, index);
        BigDecimal unitPrice = PriceHelper.getUnitPriceByHS((BigDecimal)taxRate, (BigDecimal)num, (BigDecimal)amount, (BigDecimal)taxUnitPrice, (boolean)isAllEle);
        if (null != reducedPrice) {
            OriginalBillPluginBaseControl.setRowValueWithCache(formPlugin, view, reducedPrice, index, DO_NOT_CHANGE_UNIT_PRICE, ROW_UNIT_PRICE);
        } else {
            OriginalBillPluginBaseControl.setRowValueWithCache(formPlugin, view, unitPrice, index, DO_NOT_CHANGE_UNIT_PRICE, ROW_UNIT_PRICE);
        }
        OriginalBillPluginBaseControl.setRowValueWithCache(formPlugin, view, amount, index, DO_NOT_CHANGE_AMOUNT, ROW_AMOUNT);
        OriginalBillPluginBaseControl.setRowValueWithCache(formPlugin, view, taxAmount, index, DO_NOT_CHANGE_TAX_AMOUNT, ROW_TAX_AMOUNT);
        formPlugin.getPageCache().remove(DO_NOT_CHANGE_TAX_AMOUNT + index);
        formPlugin.getPageCache().remove(DO_NOT_CHANGE_AMOUNT + index);
        formPlugin.getPageCache().remove(DO_NOT_CHANGE_UNIT_PRICE + index);
    }
}

