/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.control;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginalBillPluginBaseControl;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginalBillPluginTaxCodeControl;

public class OriginalBillPluginRowControl
extends OriginalBillPluginBaseControl {
    public static final List<String> FIELDS = Lists.newArrayList((Object[])new String[]{"goodsname", "goodsid", "spbm", "materialtype", "goodssimplename", "specification", "unit", "taxrate", "tax", "num", "unitprice", "taxunitprice", "amount", "taxamount", "materielfield", "expenseitem"});

    public static void warpRow(DynamicObjectCollection items, AbstractFormPlugin formPlugin, IFormView view) {
        view.getModel().beginInit();
        for (int i = 0; i < items.size(); ++i) {
            view.getModel().createNewEntryRow("sim_original_bill_item");
            DynamicObjectUtil.copyDynamicObject2View((DynamicObject)((DynamicObject)items.get(i)), (AbstractFormPlugin)formPlugin, (boolean)true, (int)i);
        }
        view.getModel().endInit();
        view.updateView("sim_original_bill_item");
        view.updateView("billproperties");
    }

    public static void copyRow(AbstractFormPlugin formPlugin, IFormView view) {
        EntryGrid entryGrid = (EntryGrid)view.getControl("sim_original_bill_item");
        Object rowCount = entryGrid.getEntryData().getData().get("rowcount");
        int[] rows = entryGrid.getSelectRows();
        if (rows.length == 0) {
            formPlugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u4e00\u884c\u8fdb\u884c\u64cd\u4f5c", (String)"OriginalBillPluginRowControl_0", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        if (rows.length > 50) {
            formPlugin.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u6027\u6700\u591a\u590d\u523650\u884c", (String)"OriginalBillPluginRowControl_9", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        int newRowIndex = (Integer)rowCount;
        for (int row : rows) {
            Object rowType = view.getModel().getValue("rowtype", row);
            if ("1".equals(rowType)) {
                if (row == 0) {
                    formPlugin.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c[%s]\u884c\uff0c\u6298\u6263\u884c\u4e0e\u5546\u54c1\u884c\u9700\u8981\u540c\u65f6\u590d\u5236\uff0c\u4e0d\u5141\u8bb8\u5355\u72ec\u590d\u5236\u6298\u6263\u884c", (String)"OriginalBillPluginRowControl_1", (String)"imc-sim-service", (Object[])new Object[0]), row + 1));
                    continue;
                }
                boolean copyLastRow = false;
                for (int rowIndex : rows) {
                    if (rowIndex != row - 1 || !"2".equals(view.getModel().getValue("rowtype", row - 1))) continue;
                    copyLastRow = true;
                }
                if (!copyLastRow) {
                    formPlugin.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c[%s]\u884c\uff0c\u6298\u6263\u884c\u4e0e\u5546\u54c1\u884c\u9700\u8981\u540c\u65f6\u590d\u5236\uff0c\u4e0d\u5141\u8bb8\u5355\u72ec\u590d\u5236\u6298\u6263\u884c", (String)"OriginalBillPluginRowControl_1", (String)"imc-sim-service", (Object[])new Object[0]), row + 1));
                    continue;
                }
            }
            if (OriginalBillPluginRowControl.beforeAddRowCheck(view, newRowIndex, 0)) {
                view.getModel().beginInit();
                view.getModel().createNewEntryRow("sim_original_bill_item");
                DynamicObject[] dataEntryList = entryGrid.getEntryData().getDataEntitys();
                DynamicObjectUtil.copyDynamicObject2View((DynamicObject)dataEntryList[row], (AbstractFormPlugin)formPlugin, (boolean)true, (int)newRowIndex);
                view.getModel().endInit();
                view.updateView("sim_original_bill_item", newRowIndex);
            }
            ++newRowIndex;
        }
        entryGrid.selectRows(rows, newRowIndex - 1);
        formPlugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f", (String)"OriginalBillPluginRowControl_10", (String)"imc-sim-service", (Object[])new Object[0]));
    }

    private static void addDiscountRowCopy(IFormView view, int bzkItemIndex, Integer zkItemIndex, List<String> fields) {
        if (bzkItemIndex < 0 || zkItemIndex < 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u884c\u6570\u4e0d\u80fd\u5c0f\u4e8e0", (String)"OriginalBillPluginRowControl_2", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        if (CollectionUtils.isEmpty(fields)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u590d\u5236\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillPluginRowControl_3", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        for (String field : fields) {
            view.getModel().setValue(field, view.getModel().getValue(field, bzkItemIndex), zkItemIndex.intValue());
        }
        DynamicObject taxRateObj = (DynamicObject)view.getModel().getValue("taxratecodeid", bzkItemIndex);
        DynamicObject goodsIdObj = (DynamicObject)view.getModel().getValue("goodsid", bzkItemIndex);
        if (goodsIdObj != null) {
            view.getModel().setValue("goodsid", goodsIdObj.get("id"), zkItemIndex.intValue());
            OriginalBillPluginTaxCodeControl.updateRowGoodsId(view, zkItemIndex, goodsIdObj, "1", "addDiscountRow");
        }
        if (taxRateObj != null) {
            view.getModel().setValue("taxratecodeid", taxRateObj.get("id"), zkItemIndex.intValue());
            OriginalBillPluginTaxCodeControl.updateRowTaxCode(view, zkItemIndex, taxRateObj, true);
        }
        if (taxRateObj == null && goodsIdObj == null) {
            view.getModel().setValue("goodssimplename", view.getModel().getValue("goodssimplename", bzkItemIndex), zkItemIndex.intValue());
            view.getModel().setValue("goodscode", view.getModel().getValue("goodscode", bzkItemIndex), zkItemIndex.intValue());
        }
        view.getModel().setValue("goodsname", view.getModel().getValue("goodsname", bzkItemIndex), zkItemIndex.intValue());
        view.getModel().setValue("policylogo", view.getModel().getValue("policylogo", bzkItemIndex), zkItemIndex.intValue());
        view.getModel().setValue("policycontants", view.getModel().getValue("policycontants", bzkItemIndex), zkItemIndex.intValue());
        view.getModel().setValue("num", (Object)BigDecimal.ZERO, zkItemIndex.intValue());
        view.getModel().setValue("unitprice", (Object)BigDecimal.ZERO, zkItemIndex.intValue());
        view.getModel().setValue("taxamount", (Object)BigDecimal.ZERO, zkItemIndex.intValue());
        view.getModel().setValue("amount", (Object)BigDecimal.ZERO, zkItemIndex.intValue());
        view.getModel().setValue("tax", (Object)BigDecimal.ZERO, zkItemIndex.intValue());
        view.getModel().setValue("taxunitprice", (Object)BigDecimal.ZERO, zkItemIndex.intValue());
        view.getModel().setValue("specification", (Object)"", zkItemIndex.intValue());
        view.getModel().setValue("unit", (Object)"", zkItemIndex.intValue());
        view.getModel().setValue("orinum", (Object)"", zkItemIndex.intValue());
        view.getModel().setValue("orinum", (Object)"", zkItemIndex.intValue());
        view.getModel().setValue("oritaxamount", (Object)"", zkItemIndex.intValue());
    }

    public static void addRow(IFormView view, int newRowIndex) {
        if (OriginalBillPluginRowControl.beforeAddRowCheck(view, newRowIndex, 0)) {
            view.getModel().createNewEntryRow("sim_original_bill_item");
            view.getModel().setValue("rowtype", (Object)2, newRowIndex);
            if (TaxUtils.isPurchaseInvoice((String)((String)view.getModel().getValue("specialtype")))) {
                OriginalBillPluginRowControl.updatePurchaseInvoiceItem(view, newRowIndex, "2");
            }
        }
    }

    public static void updatePurchaseInvoiceItem(IFormView view, int rowIndex, String rowType) {
        view.getModel().setValue("taxrate", (Object)0, rowIndex);
        view.getModel().setValue("policylogo", (Object)"1", rowIndex);
        if ("2".equals(rowType)) {
            view.getModel().setValue("policycontants", (Object)"\u514d\u7a0e", rowIndex);
        }
    }

    public static void addDiscountRow(AbstractFormPlugin formPlugin, IFormView view) {
        if (!StringUtils.isEmpty((CharSequence)formPlugin.getPageCache().get("original_bill_add_row"))) {
            return;
        }
        if ("-1".equals(view.getModel().getValue("billproperties"))) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8d1f\u6570\u53d1\u7968\u4e0d\u80fd\u6dfb\u52a0\u6298\u6263\u884c", (String)"OriginalBillPluginRowControl_4", (String)"imc-sim-service", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        EntryGrid grid = (EntryGrid)formPlugin.getControl("sim_original_bill_item");
        int newRowIndex = Integer.parseInt(String.valueOf(grid.getEntryData().getData().get("rowcount")));
        if (newRowIndex == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u884c\u5fc5\u987b\u8ddf\u5728\u666e\u901a\u5546\u54c1\u884c\u540e\u9762\u4e14\u6bcf\u4e00\u884c\u666e\u901a\u884c\u540e\u9762\u53ea\u80fd\u8ddf\u4e00\u884c\u6298\u6263\u884c", (String)"OriginalBillPluginRowControl_5", (String)"imc-sim-service", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        if (grid.getSelectRows().length <= 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u5546\u54c1\u884c\u6dfb\u52a0\u6263\u884c", (String)"OriginalBillPluginRowControl_6", (String)"imc-sim-service", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        int selectRow = grid.getSelectRows()[0];
        newRowIndex = selectRow + 1;
        if (!"2".equals(view.getModel().getValue("rowtype", selectRow))) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u884c\u5fc5\u987b\u8ddf\u5728\u666e\u901a\u5546\u54c1\u884c\u540e\u9762\u4e14\u6bcf\u4e00\u884c\u666e\u901a\u884c\u540e\u9762\u53ea\u80fd\u8ddf\u4e00\u884c\u6298\u6263\u884c", (String)"OriginalBillPluginRowControl_5", (String)"imc-sim-service", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        if (((Boolean)view.getModel().getValue("gift", selectRow)).booleanValue()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u884c\u4e0d\u8ddf\u5728\u8d60\u54c1\u884c\u540e\u9762", (String)"OriginalBillPluginRowControl_7", (String)"imc-sim-service", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        DynamicObjectCollection items = view.getModel().getEntryEntity("sim_original_bill_item");
        if (selectRow + 1 < items.getRowCount() && !"2".equals(view.getModel().getValue("rowtype", selectRow + 1))) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u884c\u5fc5\u987b\u8ddf\u5728\u666e\u901a\u5546\u54c1\u884c\u540e\u9762\u4e14\u6bcf\u4e00\u884c\u666e\u901a\u884c\u540e\u9762\u53ea\u80fd\u8ddf\u4e00\u884c\u6298\u6263\u884c", (String)"OriginalBillPluginRowControl_5", (String)"imc-sim-service", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        BigDecimal amount = (BigDecimal)view.getModel().getValue("amount", newRowIndex - 1);
        if (amount != null && MathUtils.isZero((BigDecimal)amount)) {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u660e\u7ec6\u91d1\u989d\u4e3a0\u65f6\uff0c\u4e0d\u80fd\u6dfb\u52a0\u6298\u6263\u884c", (String)"OriginalBillPluginRowControl_8", (String)"imc-sim-service", (Object[])new Object[0]), newRowIndex), Integer.valueOf(3000));
            return;
        }
        if (OriginalBillPluginRowControl.beforeAddRowCheck(view, newRowIndex, 1)) {
            view.getModel().beginInit();
            view.getModel().createNewEntryRow("sim_original_bill_item", newRowIndex, null);
            view.getModel().setValue("rowtype", (Object)1, newRowIndex);
            OriginalBillPluginRowControl.addDiscountRowCopy(view, selectRow, newRowIndex, FIELDS);
            view.getModel().endInit();
            view.updateView("sim_original_bill_item", newRowIndex);
        }
    }
}

