/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.control;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.helper.ReducedHelper;
import kd.imc.bdm.common.helper.cache.TaxClassCodeCheckHelper;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginalBillPluginBaseControl;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginalBillPluginRowControl;

public class OriginalBillPluginTaxCodeControl
extends OriginalBillPluginBaseControl {
    private static final Log LOGGER = LogFactory.getLog(OriginalBillPluginTaxCodeControl.class);

    public static void selectGoodsId(AfterF7SelectEvent event, IFormView view, int selectRow) {
        if (event.getListSelectedRowCollection().size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5185\u5bb9", (String)"OriginalBillPluginTaxCodeControl_2", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        DynamicObject goodsInfo = (DynamicObject)view.getModel().getValue("goodsid", selectRow);
        if (goodsInfo == null) {
            return;
        }
        Object privilegeType = goodsInfo.get("privilegetype");
        Object zsfs = view.getModel().getValue("taxationstyle");
        if (ReducedHelper.isReduced((Object)zsfs)) {
            if (ReducedHelper.isPrivilegeTypeNotReduced((Object)privilegeType)) {
                view.getModel().setValue("goodsid", null, selectRow);
                view.showErrorNotification(ResManager.loadKDString((String)"\u51cf\u6309\u8ba1\u5f81\u53ea\u80fd\u9009\u62e9\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\u4e3a\u7b80\u6613\u5f81\u6536\u7684\u5f00\u7968\u9879", (String)"OriginalBillPluginTaxCodeControl_3", (String)"imc-sim-service", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection itemList = view.getModel().getEntryEntity("sim_original_bill_item");
            if (itemList.size() > 1) {
                String goodsInfoTaxRate = goodsInfo.getString("taxrate");
                int rowIndex = 0;
                for (DynamicObject item : itemList) {
                    if (selectRow == rowIndex) continue;
                    String taxRate = item.getString("taxrate");
                    if (String.valueOf(taxRate).contains("0.") && !goodsInfoTaxRate.equals(taxRate)) {
                        view.getModel().setValue("goodsid", null, selectRow);
                        view.showErrorNotification(ResManager.loadKDString((String)"\u51cf\u6309\u8ba1\u5f81\u4e0d\u652f\u6301\u5f00\u5177\u591a\u7a0e\u7387\u53d1\u7968,\u8bf7\u91cd\u65b0\u9009\u62e9\u5f00\u7968\u9879", (String)"OriginalBillPluginTaxCodeControl_4", (String)"imc-sim-service", (Object[])new Object[0]));
                        return;
                    }
                    ++rowIndex;
                }
            }
        }
        OriginalBillPluginTaxCodeControl.updateRowGoodsId(view, selectRow, goodsInfo, "2", "0");
        try {
            Object nextRowType;
            if (view.getModel().getValue("amount", selectRow + 1) != null && "1".equals(nextRowType = view.getModel().getValue("rowtype", selectRow + 1))) {
                view.getModel().setValue("goodsid", goodsInfo.get("id"), selectRow + 1);
                OriginalBillPluginTaxCodeControl.updateRowGoodsId(view, selectRow + 1, goodsInfo, "1", "0");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u66f4\u65b0\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u5931\u8d25", (Throwable)e);
        }
    }

    public static void updateRowGoodsId(IFormView view, int selectRow, DynamicObject goodsInfo, String rowType, String addDiscount) {
        if (goodsInfo == null) {
            return;
        }
        DynamicObject taxClassCode = TaxClassCodeCheckHelper.geTaxCodeById((Long)DynamicObjectUtil.getDynamicObjectLongValue((Object)goodsInfo.getDynamicObject("taxcode")));
        if (null == taxClassCode) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e3a\u6c47\u603b\u9879\u6216\u4e0d\u5b58\u5728", (String)"OriginalBillPluginTaxCodeControl_0", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        view.getModel().beginInit();
        String specialType = (String)view.getModel().getValue("specialtype");
        if (TaxUtils.isPurchaseInvoice((String)specialType)) {
            OriginalBillPluginRowControl.updatePurchaseInvoiceItem(view, selectRow, rowType);
        } else {
            view.getModel().setValue("policylogo", (Object)goodsInfo.getString("privilegeflag"), selectRow);
            view.getModel().setValue("policycontants", (Object)goodsInfo.getString("privilegetype"), selectRow);
            if (!"addDiscountRow".equals(addDiscount)) {
                view.getModel().setValue("taxrate", (Object)goodsInfo.getBigDecimal("taxrate"), selectRow);
            }
        }
        view.getModel().setValue("spbm", goodsInfo.get("number"), selectRow);
        view.getModel().setValue("goodsname", (Object)goodsInfo.getString("name"), selectRow);
        view.getModel().setValue("taxratecodeid", taxClassCode.get("id"), selectRow);
        view.getModel().setValue("goodscode", (Object)taxClassCode.getString("mergecode"), selectRow);
        view.getModel().setValue("goodssimplename", (Object)taxClassCode.getString("simplename"), selectRow);
        view.getModel().setValue("coaltypecode", (Object)goodsInfo.getString("coaltypecode"), selectRow);
        view.getModel().endInit();
        view.updateView("sim_original_bill_item", selectRow);
        if ("2".equals(rowType)) {
            view.getModel().setValue("specification", goodsInfo.get("specifications"), selectRow);
            view.getModel().setValue("unit", goodsInfo.get("unit"), selectRow);
            String isInclusive = goodsInfo.getString("isinclusive");
            boolean isZero = BigDecimalUtil.compareZero((BigDecimal)goodsInfo.getBigDecimal("price"));
            if (!isZero) {
                if ("1".equals(isInclusive)) {
                    BigDecimal unitPrice = goodsInfo.getBigDecimal("price").divide(goodsInfo.getBigDecimal("taxrate").add(BigDecimal.ONE), 8, RoundingMode.HALF_UP);
                    view.getModel().setValue("unitprice", (Object)unitPrice, selectRow);
                    view.getModel().setValue("taxunitprice", goodsInfo.get("price"), selectRow);
                } else {
                    BigDecimal taxunitPrice = goodsInfo.getBigDecimal("price").multiply(goodsInfo.getBigDecimal("taxrate")).add(goodsInfo.getBigDecimal("price"));
                    view.getModel().setValue("unitprice", goodsInfo.get("price"), selectRow);
                    view.getModel().setValue("taxunitprice", (Object)taxunitPrice, selectRow);
                }
            }
        }
    }

    public static void updateRowTaxCode(IFormView view, int selectRow, DynamicObject taxClassCode, boolean isAddDiscount) {
        if (taxClassCode != null) {
            view.getModel().setValue("goodssimplename", taxClassCode.get("simplename"), selectRow);
            view.getModel().setValue("goodscode", (Object)taxClassCode.getString("mergecode"), selectRow);
            String specialType = (String)view.getModel().getValue("specialtype");
            if (TaxUtils.isPurchaseInvoice((String)specialType)) {
                OriginalBillPluginRowControl.updatePurchaseInvoiceItem(view, selectRow, "1");
            } else {
                boolean isBillPush;
                boolean bl = isBillPush = "3".equals(view.getModel().getValue("billsource")) || "2".equals(view.getModel().getValue("billsource"));
                if (isBillPush) {
                    return;
                }
                if (!isAddDiscount) {
                    view.getModel().setValue("taxrate", (Object)new BigDecimal(taxClassCode.getString("taxrate")).stripTrailingZeros(), selectRow);
                }
            }
        } else {
            view.getModel().setValue("goodssimplename", (Object)"", selectRow);
            throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillPluginTaxCodeControl_1", (String)"imc-sim-service", (Object[])new Object[0]));
        }
    }
}

