/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.control;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.helper.invoice.RemarkTemplateHelper;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginalBillPluginBaseControl;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginalBillPluginControl;

public class OriginalBillPluginZSFSControl
extends OriginalBillPluginBaseControl {
    public static void changeZKTaxBHS(AbstractFormPlugin formPlugin, IFormView view, int index, BigDecimal taxRate, BigDecimal bzkTax) {
        BigDecimal zkTax = null;
        if (index == 0 && view.getModel().getValue("tax", 1) != null && MathUtils.isZero((BigDecimal)bzkTax)) {
            zkTax = BigDecimal.ZERO;
        } else if (index == 0 && view.getModel().getValue("tax", 1) != null && MathUtils.isZero((BigDecimal)((BigDecimal)view.getModel().getValue("tax", 1)))) {
            zkTax = OriginalBillPluginZSFSControl.getZKItemTaxAmountByDeductionBHS(view, taxRate, bzkTax);
        } else if (index == 0 && view.getModel().getValue("tax", 1) != null) {
            BigDecimal oldZkTax = (BigDecimal)view.getModel().getValue("tax", 1);
            if (bzkTax.add(oldZkTax).compareTo(BigDecimal.ZERO) < 0) {
                zkTax = bzkTax.negate();
            } else {
                BigDecimal zkAmount = (BigDecimal)view.getModel().getValue("amount", 1);
                zkTax = zkAmount.multiply(taxRate);
                if (zkTax.add(bzkTax).compareTo(BigDecimal.ZERO) < 0) {
                    zkTax = bzkTax.negate();
                }
            }
        }
        if (zkTax != null) {
            BigDecimal zkAmount = (BigDecimal)view.getModel().getValue("amount", 1);
            BigDecimal zkTaxAmount = zkAmount.add(zkTax);
            OriginalBillPluginZSFSControl.putCache(formPlugin, 0);
            OriginalBillPluginZSFSControl.putCache(formPlugin, 1);
            view.getModel().setValue("taxamount", (Object)zkTaxAmount, 1);
            view.getModel().setValue("tax", (Object)zkTax, 1);
            OriginalBillPluginZSFSControl.removeCache(formPlugin, 0);
            OriginalBillPluginZSFSControl.removeCache(formPlugin, 1);
            OriginalBillPluginZSFSControl.updateRowSurplusAndCanCommitAmountNumTax(view, BigDecimal.ZERO, zkAmount, zkTax, 1);
        }
    }

    public static void changeZKTaxHS(AbstractFormPlugin formPlugin, IFormView view, int index, BigDecimal taxRate, BigDecimal bzkTax) {
        BigDecimal zkTax = null;
        if (index == 0 && view.getModel().getValue("tax", 1) != null && MathUtils.isZero((BigDecimal)bzkTax)) {
            zkTax = BigDecimal.ZERO;
        } else if (index == 0 && view.getModel().getValue("tax", 1) != null && MathUtils.isZero((BigDecimal)((BigDecimal)view.getModel().getValue("tax", 1)))) {
            zkTax = OriginalBillPluginZSFSControl.getZKItemTaxAmountByDeductionHS(view, taxRate, bzkTax);
        } else if (index == 0 && view.getModel().getValue("tax", 1) != null) {
            BigDecimal oldZkTax = (BigDecimal)view.getModel().getValue("tax", 1);
            if (bzkTax.add(oldZkTax).compareTo(BigDecimal.ZERO) < 0) {
                zkTax = bzkTax.negate();
            } else {
                BigDecimal amount;
                BigDecimal zkTaxAmount = (BigDecimal)view.getModel().getValue("taxamount", 1);
                zkTax = zkTaxAmount.subtract(amount = zkTaxAmount.divide(BigDecimal.ONE.add(taxRate), 2, RoundingMode.HALF_UP));
                if (zkTax.add(bzkTax).compareTo(BigDecimal.ZERO) < 0) {
                    zkTax = bzkTax.negate();
                }
            }
        }
        if (zkTax != null) {
            BigDecimal zkTaxAmount = (BigDecimal)view.getModel().getValue("taxamount", 1);
            BigDecimal zkAmount = zkTaxAmount.subtract(zkTax);
            OriginalBillPluginZSFSControl.putCache(formPlugin, 0);
            OriginalBillPluginZSFSControl.putCache(formPlugin, 1);
            view.getModel().setValue("amount", (Object)zkAmount, 1);
            view.getModel().setValue("tax", (Object)zkTax, 1);
            OriginalBillPluginZSFSControl.removeCache(formPlugin, 0);
            OriginalBillPluginZSFSControl.removeCache(formPlugin, 1);
            OriginalBillPluginZSFSControl.updateRowSurplusAndCanCommitAmountNumTax(view, BigDecimal.ZERO, zkAmount, zkTax, 1);
        }
    }

    public static boolean checkDeduction(IFormView view, BigDecimal taxAmount) {
        if (OriginalBillPluginZSFSControl.isCETaxStyle(view) && BigDecimal.ZERO.compareTo(taxAmount) != 0 && taxAmount.abs().compareTo(((BigDecimal)view.getModel().getValue("deduction")).abs()) < 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5dee\u989d\u5f81\u7a0e\uff0c\u660e\u7ec6\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u6263\u9664\u989d", (String)"OriginalBillPluginZSFSControl_0", (String)"imc-sim-service", (Object[])new Object[0]), Integer.valueOf(3000));
            return false;
        }
        return true;
    }

    public static void changeZSFS(AbstractFormPlugin formPlugin, IFormView view, Object newValue, Object oldValue) {
        boolean isNotClearEntry;
        formPlugin.getView().getPageCache().put("oldZSFS", String.valueOf(oldValue));
        view.setVisible(Boolean.FALSE, new String[]{"reductiontaxtype"});
        if (!"3".equals(newValue) && view.getModel().getValue("billproperties").equals("1")) {
            view.getModel().setValue("reductiontaxtype", null);
        }
        if ((isNotClearEntry = OriginalBillPluginControl.isBotpOrBusinessSystem(view)) && ("1".equals(newValue) || "3".equals(newValue) || "0".equals(newValue))) {
            if ("3".equals(newValue) && !EnterpriseHelper.isLqptChannel((String)((String)view.getModel().getValue("salertaxno")))) {
                view.setVisible(Boolean.TRUE, new String[]{"reductiontaxtype"});
            }
            return;
        }
        DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("sim_original_bill_item");
        switch (String.valueOf(newValue)) {
            case "2": 
            case "01": 
            case "02": {
                if (!OriginalBillPluginZSFSControl.checkDifferenceLevy(view)) {
                    OriginalBillPluginZSFSControl.setValueDoNotChangeZSFS(formPlugin, oldValue);
                    formPlugin.getView().getPageCache().remove("oldZSFS");
                    return;
                }
                view.setEnable(Boolean.FALSE, new String[]{"taxadjust"});
                IDataModel model = view.getModel();
                model.setValue("deduction", (Object)0);
                model.deleteEntryData("deductions");
                break;
            }
            case "0": {
                if ("3".equals(oldValue) && entryEntity.size() > 0) {
                    ViewUtil.openNormalConfirm((AbstractFormPlugin)formPlugin, (String)ResManager.loadKDString((String)"\u9700\u8981\u6e05\u7a7a\u660e\u7ec6\u6570\u636e,\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"OriginalBillPluginZSFSControl_1", (String)"imc-sim-service", (Object[])new Object[0]), (String)"ZSFS_NORMAL");
                    return;
                }
                OriginalBillPluginZSFSControl.change2Normal(formPlugin, oldValue);
                break;
            }
            case "1": {
                Object invoiceType = view.getModel().getValue("invoicetype");
                if (InvoiceUtils.isSpecialInvoice((String)String.valueOf(invoiceType))) {
                    OriginalBillPluginZSFSControl.setValueDoNotChangeZSFS(formPlugin, oldValue);
                    view.showTipNotification(ResManager.loadKDString((String)"\u4e13\u7968\u4e0d\u80fd\u51cf\u6309\u8ba1\u5f81", (String)"OriginalBillPluginZSFSControl_2", (String)"imc-sim-service", (Object[])new Object[0]));
                    return;
                }
                OriginalBillPluginZSFSControl.changeInvoiceRemarkByDeduction(view);
                break;
            }
            case "3": {
                if (!"3".equals(oldValue) && entryEntity.size() > 0) {
                    ViewUtil.openNormalConfirm((AbstractFormPlugin)formPlugin, (String)ResManager.loadKDString((String)"\u9700\u8981\u6e05\u7a7a\u660e\u7ec6\u6570\u636e,\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"OriginalBillPluginZSFSControl_1", (String)"imc-sim-service", (Object[])new Object[0]), (String)"ZSFS_REDUCED_TAX");
                    return;
                }
                if (!EnterpriseHelper.isLqptChannel((String)((String)view.getModel().getValue("salertaxno")))) {
                    view.setVisible(Boolean.TRUE, new String[]{"reductiontaxtype"});
                }
                view.getModel().setValue("specialtype", (Object)"00");
            }
        }
    }

    public static void changeInvoiceRemarkByDeduction(IFormView view) {
        Object deduction = view.getModel().getValue("deduction");
        if (BigDecimal.ZERO.compareTo((BigDecimal)deduction) != 0) {
            String deductionRemark = String.format("\u5dee\u989d\u5f81\u7a0e\uff1a%s\u3002", deduction);
            String invoiceRemark = String.valueOf(view.getModel().getValue("invoiceremark"));
            if (invoiceRemark.contains(deductionRemark)) {
                view.getModel().setValue("invoiceremark", (Object)invoiceRemark.replace(deductionRemark, ""));
            }
        }
        OriginalBillPluginZSFSControl.deleteBillOriginalItem(view);
        view.setEnable(Boolean.valueOf(!"2".equals(view.getModel().getValue("taxationstyle"))), new String[]{"taxadjust"});
    }

    public static void change2Normal(AbstractFormPlugin formPlugin, Object oldValue) {
        IFormView view = formPlugin.getView();
        IDataModel model = view.getModel();
        model.setValue("deduction", (Object)0);
        Object invoiceType = view.getModel().getValue("invoicetype");
        Object isElePaper = view.getModel().getValue("iselepaper");
        boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)((String)invoiceType)) || "1".equals(isElePaper);
        model.deleteEntryData("deductions");
        DynamicObjectCollection items = view.getModel().getEntryEntity("sim_original_bill_item");
        if (items.isEmpty()) {
            view.setEnable(Boolean.TRUE, new String[]{"taxadjust"});
            return;
        }
        model.beginInit();
        for (int i = 0; i < items.size(); ++i) {
            BigDecimal tax;
            BigDecimal amount;
            BigDecimal taxAmount;
            DynamicObject item = (DynamicObject)items.get(i);
            if (MathUtils.isZero((BigDecimal)item.getBigDecimal("amount"))) continue;
            BigDecimal num = item.getBigDecimal("num");
            BigDecimal taxRate = item.getBigDecimal("taxrate");
            if ("1".equals(model.getValue("hsbz"))) {
                taxAmount = item.getBigDecimal("taxamount");
                amount = taxAmount.divide(BigDecimal.ONE.add(taxRate), 2, RoundingMode.HALF_UP);
                tax = taxAmount.subtract(amount);
                model.setValue("amount", (Object)amount, i);
                if (!MathUtils.isZero((BigDecimal)item.getBigDecimal("taxunitprice")) && !MathUtils.isZero((BigDecimal)item.getBigDecimal("num"))) {
                    BigDecimal unitPrice = PriceHelper.calcPriceOrNum((BigDecimal)amount, (BigDecimal)item.getBigDecimal("num"), (boolean)isAllEle);
                    model.setValue("unitprice", (Object)unitPrice, i);
                }
            } else {
                amount = item.getBigDecimal("amount");
                tax = amount.multiply(taxRate);
                taxAmount = item.getBigDecimal("amount").add(tax);
                model.setValue("taxamount", (Object)taxAmount, i);
                if (!MathUtils.isZero((BigDecimal)item.getBigDecimal("unitprice")) && !MathUtils.isZero((BigDecimal)item.getBigDecimal("num"))) {
                    BigDecimal taxUnitPrice = PriceHelper.calcPriceOrNum((BigDecimal)taxAmount, (BigDecimal)item.getBigDecimal("num"), (boolean)isAllEle);
                    model.setValue("taxunitprice", (Object)taxUnitPrice, i);
                }
            }
            model.setValue("tax", (Object)tax, i);
            OriginalBillPluginZSFSControl.updateRowSurplusAndCanCommitAmountNumTax(view, num, amount, tax, i);
        }
        view.setEnable(Boolean.TRUE, new String[]{"taxadjust"});
        model.endInit();
        view.updateView("sim_original_bill_item");
    }

    public static void deleteBillOriginalItem(IFormView view) {
        IDataModel model = view.getModel();
        model.deleteEntryData("sim_original_bill_item");
        model.setValue("oldtotalamount", (Object)BigDecimal.ZERO);
        model.setValue("invoiceamount", (Object)BigDecimal.ZERO);
        model.setValue("totalamount", (Object)BigDecimal.ZERO);
        model.setValue("totaltax", (Object)BigDecimal.ZERO);
        model.setValue("surplusamount", (Object)BigDecimal.ZERO);
        model.setValue("surplusamount", (Object)BigDecimal.ZERO);
        model.setValue("surplustax", (Object)BigDecimal.ZERO);
    }

    public static boolean checkDifferenceLevy(IFormView view) {
        DynamicObjectCollection items = view.getModel().getEntryEntity("sim_original_bill_item");
        if (items.size() > 1 && !"1".equals(((DynamicObject)items.get(1)).getString("rowtype"))) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5dee\u989d\u5f81\u7a0e\u53ea\u652f\u6301\u4e00\u884c\u5546\u54c1\u660e\u7ec6", (String)"OriginalBillPluginZSFSControl_3", (String)"imc-sim-service", (Object[])new Object[0]), Integer.valueOf(3000));
            return false;
        }
        return true;
    }

    private static void setValueDoNotChangeZSFS(AbstractFormPlugin that, Object oldValue) {
        that.getView().getModel().beginInit();
        that.getView().getModel().setValue("taxationstyle", oldValue);
        that.getView().getModel().endInit();
        that.getView().updateView("taxationstyle");
    }

    public static boolean editDeduction(AbstractFormPlugin formPlugin, IFormView view, BigDecimal newValue, BigDecimal oldValue) {
        if (!OriginalBillPluginZSFSControl.isCETaxStyle(view)) {
            OriginalBillPluginZSFSControl.setDeductionRemark(formPlugin.getView(), BigDecimal.ZERO);
            return false;
        }
        IDataModel model = formPlugin.getView().getModel();
        Object billProperty = model.getValue("billproperties");
        if ("-1".equals(billProperty)) {
            if (BigDecimalUtil.greaterZero((BigDecimal)newValue)) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8d1f\u6570\u5355\u636e\u6263\u9664\u989d\u4e0d\u80fd\u5927\u4e8e0", (String)"OriginalBillPluginZSFSControl_4", (String)"imc-sim-service", (Object[])new Object[0]));
                model.setValue("deduction", (Object)BigDecimal.ZERO);
                return false;
            }
        } else if (BigDecimalUtil.lessZero((BigDecimal)newValue)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u6b63\u6570\u5355\u636e\u6263\u9664\u989d\u4e0d\u80fd\u5c0f\u4e8e0", (String)"OriginalBillPluginZSFSControl_5", (String)"imc-sim-service", (Object[])new Object[0]));
            model.setValue("deduction", (Object)BigDecimal.ZERO);
            return false;
        }
        newValue = "1".equals(view.getModel().getValue("billproperties")) ? newValue.abs() : new BigDecimal("-" + newValue.abs());
        DynamicObjectCollection goodsItems = view.getModel().getEntryEntity("sim_original_bill_item");
        BigDecimal billTaxAmount = (BigDecimal)view.getModel().getValue("totalamount");
        if (goodsItems.size() > 0) {
            BigDecimal itemAmount = "0".equals(view.getModel().getValue("hsbz")) ? (BigDecimal)((DynamicObject)goodsItems.get(0)).get("amount") : (BigDecimal)((DynamicObject)goodsItems.get(0)).get("taxamount");
            if (itemAmount.abs().compareTo(((BigDecimal)view.getModel().getValue("deduction")).abs()) < 0 && !MathUtils.isZero((BigDecimal)itemAmount)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5dee\u989d\u5f81\u7a0e\uff0c\u660e\u7ec6\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u6263\u9664\u989d", (String)"OriginalBillPluginZSFSControl_0", (String)"imc-sim-service", (Object[])new Object[0]), Integer.valueOf(3000));
                view.getModel().setValue("deduction", (Object)oldValue);
                return false;
            }
        } else {
            OriginalBillPluginZSFSControl.setDeductionRemark(view, newValue);
            return false;
        }
        OriginalBillPluginZSFSControl.putCache(formPlugin, 0);
        OriginalBillPluginZSFSControl.putCache(formPlugin, 1);
        Object invoiceType = view.getModel().getValue("invoicetype");
        Object isElePaper = view.getModel().getValue("iselepaper");
        boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)((String)invoiceType)) || "1".equals(isElePaper);
        for (int i = 0; i < goodsItems.size(); ++i) {
            BigDecimal tax;
            DynamicObject item = (DynamicObject)goodsItems.get(i);
            BigDecimal taxRate = item.getBigDecimal("taxrate");
            BigDecimal taxAmount = item.getBigDecimal("taxamount");
            BigDecimal amount = item.getBigDecimal("amount");
            BigDecimal num = item.getBigDecimal("num");
            if ("1".equals(view.getModel().getValue("hsbz"))) {
                tax = OriginalBillPluginZSFSControl.updateDeductionTaxHS(view, i, taxAmount, taxRate);
                amount = taxAmount.subtract(tax).setScale(2, RoundingMode.HALF_UP);
                view.getModel().setValue("amount", (Object)amount, i);
                if (!MathUtils.isZero((BigDecimal)num) && !MathUtils.isZero((BigDecimal)item.getBigDecimal("unitprice"))) {
                    BigDecimal unitPrice = PriceHelper.calcPriceOrNum((BigDecimal)amount, (BigDecimal)num, (boolean)isAllEle);
                    OriginalBillPluginZSFSControl.setRowValueWithCache(formPlugin, view, unitPrice, i, "do_not_change_unit_price", "unitprice");
                }
            } else {
                tax = OriginalBillPluginZSFSControl.updateDeductionTaxBHS(view, i, taxRate, amount);
                taxAmount = amount.add(tax).setScale(2, RoundingMode.HALF_UP);
                view.getModel().setValue("taxamount", (Object)taxAmount, i);
                if (!MathUtils.isZero((BigDecimal)num) && !MathUtils.isZero((BigDecimal)item.getBigDecimal("taxunitprice"))) {
                    BigDecimal taxUnitPrice = PriceHelper.calcPriceOrNum((BigDecimal)taxAmount, (BigDecimal)num, (boolean)isAllEle);
                    OriginalBillPluginZSFSControl.setRowValueWithCache(formPlugin, view, taxUnitPrice, i, "do_not_change_tax_unit_price", "taxunitprice");
                }
            }
            OriginalBillPluginZSFSControl.setRowValueWithCache(formPlugin, view, tax, i, "do_not_change_tax", "tax");
            OriginalBillPluginZSFSControl.updateRowSurplusAndCanCommitAmountNumTax(view, num, amount, tax, i);
        }
        OriginalBillPluginZSFSControl.removeCache(formPlugin, 0);
        OriginalBillPluginZSFSControl.removeCache(formPlugin, 1);
        OriginalBillPluginZSFSControl.setDeductionRemark(view, newValue);
        return !MathUtils.isZero((BigDecimal)billTaxAmount);
    }

    private static void setDeductionRemark(IFormView view, BigDecimal newValue) {
        String invoiceType = (String)view.getModel().getValue("invoicetype");
        if (InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
            String remark = (String)view.getModel().getValue("invoiceremark");
            view.getModel().setValue("invoiceremark", (Object)OriginalBillPluginZSFSControl.createDeductionRemark(remark, newValue.setScale(2, RoundingMode.HALF_UP)));
            return;
        }
        BigDecimal billTaxAmount = (BigDecimal)view.getModel().getValue("totalamount");
        Object billProperties = view.getModel().getValue("billproperties");
        String generateRemark = RemarkTemplateHelper.generateRemark((String)"", (String)("1".equals(billProperties) ? "0" : "1"), (int)2, (BigDecimal)billTaxAmount, (BigDecimal)newValue, (String)((String)view.getModel().getValue("blueinvoicecode")), (String)((String)view.getModel().getValue("blueinvoiceno")));
        view.getModel().setValue("invoiceremark", (Object)generateRemark);
    }

    public static String createDeductionRemark(String remark, BigDecimal deductionAmount) {
        if (null == remark) {
            remark = "";
        }
        String kce = "\u6263\u9664\u989d\uff1a%s\u3002".substring(0, 4);
        if (deductionAmount.compareTo(BigDecimal.ZERO) == 0) {
            return remark.replaceFirst(kce + "\\d+(?:\\.\\d+)?[\u3002]*(?:\\s*)", "").trim();
        }
        String newPrefix = kce + deductionAmount.stripTrailingZeros().toPlainString() + "\u3002";
        return remark.replaceFirst(kce + "\\d+(?:\\.\\d+)?[\u3002]*", newPrefix).replaceFirst("^(?!.*" + kce + ")", newPrefix + " ");
    }

    private static void putCache(AbstractFormPlugin formPlugin, int i) {
        formPlugin.getPageCache().put("do_not_change_amount" + i, "1");
        formPlugin.getPageCache().put("do_not_change_unit_price" + i, "1");
        formPlugin.getPageCache().put("do_not_change_tax_amount" + i, "1");
        formPlugin.getPageCache().put("do_not_change_tax_unit_price" + i, "1");
        formPlugin.getPageCache().put("do_not_change_tax" + i, "1");
    }

    private static void removeCache(AbstractFormPlugin formPlugin, int i) {
        formPlugin.getPageCache().remove("do_not_change_amount" + i);
        formPlugin.getPageCache().remove("do_not_change_unit_price" + i);
        formPlugin.getPageCache().remove("do_not_change_tax_amount" + i);
        formPlugin.getPageCache().remove("do_not_change_tax_unit_price" + i);
        formPlugin.getPageCache().remove("do_not_change_tax" + i);
    }
}

