/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.util;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.table.RedInfoConstant;
import kd.imc.bdm.common.constant.table.RedReasonEnum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.InvoiceValidHelper;
import kd.imc.bdm.common.helper.RedConfirmHelper;
import kd.imc.bdm.common.helper.cache.MsgAuthSettingCacheHelper;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.RegexUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.sim.common.helper.RedInfoHelper;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginalBillPluginCopyRedInfoControl;
import kd.imc.sim.formplugin.bill.originalbill.util.Dto.CheckResult;
import kd.imc.sim.formplugin.bill.originalbill.util.OriginalBillCheckUtil;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillMergeHelper;
import kd.sdk.annotation.SdkDeprecated;

public class OriginalBillFormEditUtil {
    private static final String ERROR = "error";
    private static final Log LOG = LogFactory.getLog(OriginalBillFormEditUtil.class);

    public static void editINVOICETYPE(AbstractFormPlugin plugin, Object newValue, Object oldValue) {
        IDataModel model = plugin.getView().getModel();
        if ("1".equals(model.getValue("taxationstyle")) && InvoiceUtils.isSpecialInvoice((String)String.valueOf(newValue))) {
            model.setValue("invoicetype", (Object)InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode());
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u4e13\u7968\u4e0d\u80fd\u51cf\u6309\u8ba1\u5f81\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u53d1\u7968\u79cd\u7c7b", (String)"OriginalBillFormEditUtil_0", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        Object sellerTaxNo = model.getValue("salertaxno");
        if (AllEleAuthHelper.elePaperSetValue((Object)sellerTaxNo, (Object)newValue)) {
            model.setValue("iselepaper", (Object)"1");
            OriginalBillFormEditUtil.clearElePaperOtherData(model);
        } else {
            model.setValue("iselepaper", (Object)"0");
        }
        if (!AllEleAuthHelper.isElePaper((Object)model.getValue("iselepaper"))) {
            if ("026".equals(newValue) || "007".equals(newValue)) {
                if ("-1".equals(model.getValue("billproperties"))) {
                    plugin.getView().setVisible(Boolean.FALSE, new String[]{"applicant"});
                    plugin.getView().setVisible(Boolean.FALSE, new String[]{"infocode"});
                    plugin.getView().setVisible(Boolean.TRUE, new String[]{"originalissuetime"});
                    plugin.getView().setVisible(Boolean.TRUE, new String[]{"blueinvoicetype"});
                    plugin.getView().setVisible(Boolean.TRUE, new String[]{"redreason"});
                }
            } else if (("028".equals(newValue) || "004".equals(newValue)) && "-1".equals(model.getValue("billproperties"))) {
                plugin.getView().setVisible(Boolean.TRUE, new String[]{"applicant"});
                plugin.getView().setVisible(Boolean.TRUE, new String[]{"infocode"});
                plugin.getView().setVisible(Boolean.TRUE, new String[]{"originalissuetime"});
                plugin.getView().setVisible(Boolean.FALSE, new String[]{"blueinvoicetype"});
                plugin.getView().setVisible(Boolean.FALSE, new String[]{"redreason"});
            }
        }
        if (!InvoiceUtils.isAllEInvoice((Object)String.valueOf(newValue)) || !AllEleAuthHelper.isElePaper((Object)model.getValue("iselepaper"))) {
            model.setValue("operator", null);
            if (model.getValue("billproperties").equals("1")) {
                model.setValue("reductiontaxtype", null);
            }
        } else {
            model.setValue("jqbh", null);
            model.setValue("payee", null);
            model.setValue("reviewer", null);
        }
        OriginalBillFormEditUtil.checkInvoiceTypeInfoCode(plugin, model, newValue, oldValue);
    }

    public static void clearElePaperOtherData(IDataModel model) {
        if (StringUtils.isNotBlank((Object)model.getValue("jqbh"))) {
            model.setValue("jqbh", null);
        }
        if (StringUtils.isNotBlank((Object)model.getValue("terminalno"))) {
            model.setValue("terminalno", null);
        }
    }

    private static void checkInvoiceTypeInfoCode(AbstractFormPlugin plugin, IDataModel model, Object newValue, Object oldValue) {
        if (!AllEleAuthHelper.isElePaper((Object)model.getValue("iselepaper")) && (InvoiceUtils.isNormalInvoice((String)String.valueOf(oldValue)) && InvoiceUtils.isSpecialInvoice((String)String.valueOf(newValue)) || InvoiceUtils.isNormalInvoice((String)String.valueOf(newValue)) && InvoiceUtils.isSpecialInvoice((String)String.valueOf(oldValue)) || String.valueOf(newValue).equals("025") || String.valueOf(oldValue).equals("025"))) {
            plugin.getView().getModel().setValue("applicant", (Object)"");
            plugin.getView().getModel().setValue("infocode", (Object)"");
            plugin.getView().getModel().setValue("blueinvoicecode", (Object)"");
            plugin.getView().getModel().setValue("blueinvoiceno", (Object)"");
            plugin.getView().getModel().setValue("originalissuetime", (Object)"");
            plugin.getView().getModel().setValue("blueinvoicetype", (Object)"");
            plugin.getView().getModel().setValue("redreason", (Object)"");
        }
        if ("-1".equals(model.getValue("billproperties"))) {
            if (String.valueOf(newValue).equals(InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode()) || String.valueOf(newValue).equals(InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode())) {
                plugin.getView().setVisible(Boolean.TRUE, new String[]{"applicant"});
                plugin.getView().setVisible(Boolean.TRUE, new String[]{"infocode"});
                plugin.getView().setVisible(Boolean.TRUE, new String[]{"originalissuetime"});
                plugin.getView().setVisible(Boolean.FALSE, new String[]{"blueinvoicetype"});
                plugin.getView().setVisible(Boolean.FALSE, new String[]{"redreason"});
            } else {
                plugin.getView().setVisible(Boolean.FALSE, new String[]{"applicant"});
                plugin.getView().setVisible(Boolean.FALSE, new String[]{"infocode"});
                plugin.getView().setVisible(Boolean.TRUE, new String[]{"originalissuetime"});
                plugin.getView().setVisible(Boolean.TRUE, new String[]{"blueinvoicetype"});
                plugin.getView().setVisible(Boolean.TRUE, new String[]{"redreason"});
            }
        }
    }

    public static void editBUYERPHONE(AbstractFormPlugin plugin, Object newValue) {
        IDataModel model = plugin.getView().getModel();
        String invType = (String)model.getValue("invoicetype");
        String systemSource = (String)plugin.getView().getModel().getValue("systemsource");
        if (!BotpHelper.isFromAr((Object)systemSource) && StringUtils.isNotBlank((Object)newValue)) {
            newValue = newValue.toString().replace(" ", "");
            long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)plugin.getView().getModel().getValue("orgid"));
            if (0L == orgId) {
                orgId = RequestContext.get().getOrgId();
            }
            if (InvoiceUtils.isEtcInvoice((String)invType) && !InvoiceValidHelper.isMobile((String)newValue.toString()) && MsgAuthSettingCacheHelper.isCheckPhone((long)orgId)) {
                OriginalBillCheckUtil.msgTips((AbstractFormPlugin)plugin, (String)ERROR, (String)ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u624b\u673a\u53f7", (String)"OriginalBillFormEditUtil_1", (String)"imc-sim-service", (Object[])new Object[0]));
            }
        }
    }

    public static void editBUYEREMAIL(AbstractFormPlugin plugin, Object newValue) {
        String systemSource = (String)plugin.getView().getModel().getValue("systemsource");
        if (!BotpHelper.isFromAr((Object)systemSource) && StringUtils.isNotBlank((Object)newValue)) {
            String[] mails = newValue.toString().split(";");
            if (mails.length > 10) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6700\u591a\u652f\u6301\u586b\u519910\u4e2a\u90ae\u7bb1", (String)"OriginalBillFormEditUtil_2", (String)"imc-sim-service", (Object[])new Object[0]));
            }
            for (String mail : mails) {
                if (RegexUtil.isEmail((String)mail)) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u90ae\u7bb1", (String)"OriginalBillFormEditUtil_3", (String)"imc-sim-service", (Object[])new Object[0]));
            }
        }
    }

    public static void editBUYERBANK(AbstractFormPlugin plugin, Object newValue) {
        IDataModel model = plugin.getView().getModel();
        String invType = (String)model.getValue("invoicetype");
        if (("028".equals(invType) || "004".equals(invType)) && StringUtils.isBlank((Object)newValue)) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"'\u4e13\u7528\u53d1\u7968'\u7c7b\u578b\u65f6\uff0c\u8d2d\u65b9\u5f00\u6237\u884c\u53ca\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillFormEditUtil_4", (String)"imc-sim-service", (Object[])new Object[0]));
        }
    }

    public static void editBUYERADDR(AbstractFormPlugin plugin, Object newValue) {
        IDataModel model = plugin.getView().getModel();
        String invType = (String)model.getValue("invoicetype");
        if (("028".equals(invType) || "004".equals(invType)) && StringUtils.isBlank((Object)newValue)) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"'\u4e13\u7528\u53d1\u7968'\u7c7b\u578b\u65f6\uff0c\u8d2d\u65b9\u5730\u5740\u3001\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillFormEditUtil_5", (String)"imc-sim-service", (Object[])new Object[0]));
        }
    }

    public static void editAPPLICANT(AbstractFormPlugin plugin, Object newValue) {
        if (StringUtils.isNotBlank((Object)newValue)) {
            if (!newValue.equals("2")) {
                plugin.getView().setEnable(Boolean.TRUE, new String[]{"infocode"});
                plugin.getView().setEnable(Boolean.FALSE, new String[]{"blueinvoicecode", "blueinvoiceno", "originalissuetime"});
            } else {
                plugin.getView().setEnable(Boolean.TRUE, new String[]{"infocode", "blueinvoicecode", "blueinvoiceno", "originalissuetime"});
            }
        } else {
            plugin.getView().setEnable(Boolean.TRUE, new String[]{"infocode", "blueinvoicecode", "blueinvoiceno", "originalissuetime"});
        }
    }

    public static void systemSourceSaveDataCheck(DynamicObject saveObject) {
        BigDecimal cacheInvoiceAmount = new BigDecimal(CacheHelper.get((String)(saveObject.getString("billno") + "invoiceamount"))).setScale(2, RoundingMode.HALF_UP);
        BigDecimal cacheTotalamount = new BigDecimal(CacheHelper.get((String)(saveObject.getString("billno") + "totalamount"))).setScale(2, RoundingMode.HALF_UP);
        BigDecimal cacheTotaltax = new BigDecimal(CacheHelper.get((String)(saveObject.getString("billno") + "totaltax"))).setScale(2, RoundingMode.HALF_UP);
        BigDecimal newinvoiceamount = saveObject.getBigDecimal("invoiceamount");
        BigDecimal newtotalamount = saveObject.getBigDecimal("totalamount");
        BigDecimal newtotaltax = saveObject.getBigDecimal("totaltax");
        boolean taxAdjust = saveObject.getBoolean("taxadjust");
        if (taxAdjust) {
            BigDecimal diff = new BillMergeHelper().getItemsMaxTaxDiff(saveObject, saveObject.getString("jqbh"));
            if (cacheTotalamount.compareTo(newtotalamount.setScale(2, RoundingMode.HALF_UP)) != 0 || cacheInvoiceAmount.subtract(newinvoiceamount).abs().compareTo(diff) > 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u603b\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u7b49\u4e8e\u539f\u503c\uff0c\u8bf7\u4fee\u6539\uff01\u539f\u4ef7\u7a0e\u5408\u8ba1%1$s\u5143\uff0c\u539f\u603b\u91d1\u989d%2$s\u5143", (String)"OriginalBillFormEditUtil_7", (String)"imc-sim-service", (Object[])new Object[0]), cacheTotalamount, cacheInvoiceAmount));
            }
        } else if (cacheInvoiceAmount.compareTo(newinvoiceamount.setScale(2, RoundingMode.HALF_UP)) != 0 || cacheTotalamount.compareTo(newtotalamount.setScale(2, RoundingMode.HALF_UP)) != 0 || cacheTotaltax.compareTo(newtotaltax.setScale(2, RoundingMode.HALF_UP)) != 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u603b\u4ef7\u7a0e\u5408\u8ba1\u3001\u603b\u7a0e\u989d\u3001\u603b\u91d1\u989d\u4e0d\u7b49\u4e8e\u539f\u503c\uff0c\u8bf7\u4fee\u6539\uff01\u539f\u4ef7\u7a0e\u5408\u8ba1%1$s\u5143\uff0c\u603b\u7a0e\u989d%2$s\u5143\uff0c\u603b\u4e0d\u542b\u7a0e\u91d1\u989d%3$s\u5143", (String)"OriginalBillFormEditUtil_8", (String)"imc-sim-service", (Object[])new Object[0]), cacheTotalamount, cacheTotaltax, cacheInvoiceAmount));
        }
    }

    public static void removeCacheHelperEditAmount(String billno) {
        CacheHelper.remove((String)(billno + "invoiceamount"));
        CacheHelper.remove((String)(billno + "totalamount"));
        CacheHelper.remove((String)(billno + "totaltax"));
        CacheHelper.remove((String)(billno + "needCheckTotalAmount"));
    }

    @SdkDeprecated
    public static String checkInfoCode(String infoCode, String billNo, String billCheck, Long orgId) {
        QFilter qFilter = new QFilter("infocode", "=", (Object)infoCode).and("billno", "not in", (Object)billNo.split(","));
        DynamicObject[] originalBill = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)"id,infocode,billno", (QFilter[])qFilter.toArray());
        if (originalBill.length > 0 && StringUtils.isBlank((CharSequence)billCheck)) {
            return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868/\u7ea2\u5b57\u786e\u8ba4\u5355\u7f16\u53f7%1$s\u5df2\u5173\u8054\u5355\u636e%2$s", (String)"OriginalBillFormEditUtil_12", (String)"imc-sim-service", (Object[])new Object[0]), infoCode, originalBill[0].getString("billno"));
        }
        qFilter = new QFilter("infocode", "=", (Object)infoCode);
        qFilter.and("org", "=", (Object)orgId);
        DynamicObject[] redInfoList = BusinessDataServiceHelper.load((String)"sim_red_info", (String)"id,infocode,infostatus,status,billstatus", (QFilter[])qFilter.toArray());
        if (redInfoList.length > 0) {
            for (DynamicObject redInfo : redInfoList) {
                DynamicObject[] relations;
                if (infoCode.equals(redInfo.getString("infocode")) && (relations = OriginalBillFormEditUtil.getRelationsByTBillIdWorkBench(redInfo.getPkValue())).length > 0) {
                    return String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7f16\u53f7/\u7ea2\u5b57\u786e\u8ba4\u5355\u7f16\u53f7%s\u5df2\u5173\u8054\u5176\u4ed6\u5355\u636e", (String)"OriginalBillFormEditUtil_13", (String)"imc-sim-service", (Object[])new Object[0]), infoCode);
                }
                if (!RedInfoConstant.isAuditSuccess((String)redInfo.getString("infostatus")) || !"3".equals(redInfo.getString("status"))) {
                    return String.format(ResManager.loadKDString((String)"\u5355\u636e%s\u7ea2\u5b57\u4fe1\u606f\u8868\u72b6\u6001\u4e3a\u975e'\u5ba1\u6838\u901a\u8fc7'\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u5f00\u7968", (String)"OriginalBillFormEditUtil_14", (String)"imc-sim-service", (Object[])new Object[0]), billNo);
                }
                if (!BillStatusEnum.AUDIT_SUCCESS.getCode().equals(redInfo.getString("billstatus")) && !BillStatusEnum.NO_APPROVAL_REQUIRED.getCode().equals(redInfo.getString("billstatus"))) {
                    return String.format(ResManager.loadKDString((String)"\u5355\u636e%s\u7ea2\u5b57\u4fe1\u606f\u8868\u5185\u90e8\u5ba1\u6838\u72b6\u6001\u4e3a\u975e'\u5df2\u5ba1\u6838'\u6216'\u65e0\u9700\u5ba1\u6279'\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u5f00\u7968", (String)"OriginalBillFormEditUtil_15", (String)"imc-sim-service", (Object[])new Object[0]), billNo);
                }
                if (!StringUtils.isBlank((CharSequence)redInfo.getString("infocode")) && redInfo.getString("infocode").length() == 16) continue;
                return String.format(ResManager.loadKDString((String)"\u5355\u636e%s\u7ea2\u5b57\u4fe1\u606f\u8868\u7f16\u53f7\u4e0d\u5408\u6cd5\uff0816\u4f4d\u6570\u5b57\uff09", (String)"OriginalBillFormEditUtil_16", (String)"imc-sim-service", (Object[])new Object[0]), billNo);
            }
        }
        return "";
    }

    private static DynamicObject[] getRelationsByTBillIdWorkBench(Object invoiceId) {
        DynamicObject[] relations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_bill_inv_relation"), (QFilter[])new QFilter("tbillid", "=", invoiceId).and("isdelete", "!=", (Object)"Y").toArray());
        if (relations.length < 1) {
            return new DynamicObject[0];
        }
        List blueRelationList = Arrays.stream(relations).filter(o -> !"sim_red_info".equals(o.getString("ttable"))).collect(Collectors.toList());
        if (blueRelationList.size() < 1) {
            return new DynamicObject[0];
        }
        Map<Object, DynamicObject> blueRelationMap = blueRelationList.stream().collect(Collectors.toMap(k -> k.getString("tbillid"), v -> v, (v1, v2) -> v2));
        DynamicObject[] invoices = BusinessDataServiceHelper.load((Object[])blueRelationMap.keySet().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice"));
        List<DynamicObject> invoiceList = Arrays.stream(invoices).filter(o -> !o.getString("invoicestatus").equals("6")).collect(Collectors.toList());
        if (invoiceList.size() < 1) {
            return new DynamicObject[0];
        }
        return invoiceList.toArray(new DynamicObject[0]);
    }

    public static void editINFOCODE(AbstractFormPlugin plugin, Object billNo, Object newValue, Object oldValue) {
        String result;
        if (StringUtils.isNotBlank((Object)newValue) && StringUtils.isNotBlank((CharSequence)(result = OriginalBillFormEditUtil.checkInfoCode(newValue.toString(), billNo.toString(), null, DynamicObjectUtil.getDynamicObjectLongValue((Object)plugin.getView().getModel().getValue("orgid")))))) {
            throw new KDBizException(result);
        }
        if (StringUtils.isNotBlank((CharSequence)((String)newValue)) && !RegexUtil.isRedInfoCode((String)((String)newValue)) && StringUtils.isBlank((CharSequence)plugin.getPageCache().get("callBackRedInfo"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7f16\u53f7\u4e0d\u5408\u6cd5\uff0816\u4f4d\u6570\u5b57\uff09", (String)"OriginalBillFormEditUtil_17", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        plugin.getPageCache().remove("callBackRedInfo");
        DynamicObject bill = plugin.getView().getModel().getDataEntity(true);
        boolean addNew = "6".equals(plugin.getView().getModel().getValue("billsource"));
        if (!addNew) {
            RedInfoHelper.checkRedInfo((String)((String)newValue), (DynamicObject)bill);
        } else {
            OriginalBillPluginCopyRedInfoControl.copyRedInfo(plugin, (String)newValue);
        }
    }

    public static void editBLUEINVOICECODE(AbstractFormPlugin plugin, Object newValue) {
        String invoiceType;
        if (StringUtils.isBlank((Object)newValue) && OriginalBillPluginCopyRedInfoControl.isFromInvoice(plugin)) {
            plugin.getView().getModel().deleteEntryData("sim_original_bill_item");
            plugin.getPageCache().remove("itemType");
        }
        if (!InvoiceUtils.isExecuteInvoiceRule((String)(invoiceType = String.valueOf(plugin.getView().getModel().getValue("invoicetype"))))) {
            return;
        }
        if (StringUtils.isNotBlank((Object)newValue) && !RegexUtil.isInvoiceCode((String)newValue.toString())) {
            OriginalBillCheckUtil.msgTips((AbstractFormPlugin)plugin, (String)ERROR, (String)ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u53d1\u7968\u4ee3\u7801", (String)"OriginalBillFormEditUtil_18", (String)"imc-sim-service", (Object[])new Object[0]));
        }
    }

    public static void editBLUEINVOICECONO(AbstractFormPlugin plugin, Object newValue) {
        String invoiceType = String.valueOf(plugin.getView().getModel().getValue("invoicetype"));
        if (!InvoiceUtils.isExecuteInvoiceRule((String)invoiceType)) {
            return;
        }
        String isElePaper = String.valueOf(plugin.getView().getModel().getValue("iselepaper"));
        if (InvoiceUtils.isAllEInvoice((Object)invoiceType) || AllEleAuthHelper.isElePaper((Object)isElePaper)) {
            boolean isInvoiceNoSuccess;
            String invoiceNoStr = String.valueOf(newValue);
            boolean bl = isInvoiceNoSuccess = RegexUtil.isAllEInvoiceNo((String)invoiceNoStr) || RegexUtil.isInvoiceNo((String)invoiceNoStr);
            if (!StringUtils.isBlank((Object)newValue) && !isInvoiceNoSuccess) {
                OriginalBillCheckUtil.msgTips((AbstractFormPlugin)plugin, (String)ERROR, (String)ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u53d1\u7968\u53f7\u7801", (String)"OriginalBillFormEditUtil_19", (String)"imc-sim-service", (Object[])new Object[0]));
            }
        } else if (!InvoiceUtils.isAllEInvoice((Object)invoiceType) && StringUtils.isNotBlank((Object)newValue) && !RegexUtil.isInvoiceNo((String)String.valueOf(newValue))) {
            OriginalBillCheckUtil.msgTips((AbstractFormPlugin)plugin, (String)ERROR, (String)ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u53d1\u7968\u53f7\u7801", (String)"OriginalBillFormEditUtil_19", (String)"imc-sim-service", (Object[])new Object[0]));
        }
    }

    public static void editORIGINALISSUETIME(AbstractFormPlugin plugin, Object newValue) {
        if (null != newValue) {
            Date issuetiem = (Date)newValue;
            if (System.currentTimeMillis() < issuetiem.getTime()) {
                OriginalBillCheckUtil.msgTips((AbstractFormPlugin)plugin, (String)ERROR, (String)ResManager.loadKDString((String)"'\u5f85\u51b2\u84dd\u7968\u5f00\u7968\u65e5\u671f'\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u65f6\u95f4\uff0c\u8bf7\u4fee\u6539", (String)"OriginalBillFormEditUtil_20", (String)"imc-sim-service", (Object[])new Object[0]));
            }
        }
    }

    public static void checkBillRedInfoDO(DynamicObject originalBill) {
        String result;
        String originalInvoiceCode = originalBill.getString("blueinvoicecode");
        String originalInvoiceNo = originalBill.getString("blueinvoiceno");
        String infoCode = originalBill.getString("infocode");
        Object originalIssueTime = originalBill.get("originalissuetime");
        String applicant = originalBill.getString("applicant");
        String invType = originalBill.getString("invoicetype");
        if (StringUtils.isBlank((CharSequence)applicant) && InvoiceUtils.isSpecialInvoice((String)invType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7533\u8bf7\u65b9\u3002", (String)"OriginalBillFormEditUtil_21", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        if (RedInfoConstant.ApplicantEnum.SALER.getCode().equals(applicant)) {
            OriginalBillFormEditUtil.checkOriginalInvoice(originalBill, originalInvoiceCode, originalInvoiceNo, originalIssueTime, StringUtils.isBlank((CharSequence)infoCode));
        }
        if ((RedInfoConstant.ApplicantEnum.BUYERNODEDUCTED.getCode().equals(applicant) || RedInfoConstant.ApplicantEnum.BUYERDEDUCTED.getCode().equals(applicant)) && StringUtils.isBlank((CharSequence)infoCode)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d2d\u65b9\u7533\u8bf7\u4fe1\u606f\u8868\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OriginalBillFormEditUtil_22", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)infoCode) && StringUtils.isNotBlank((CharSequence)(result = OriginalBillFormEditUtil.checkInfoCode(infoCode, originalBill.getString("billno"), null, DynamicObjectUtil.getDynamicObjectLongValue((Object)originalBill.get("orgid")))))) {
            throw new KDBizException(result);
        }
        if (InvoiceUtils.isNormalInvoice((String)invType) && (StringUtils.isBlank((CharSequence)originalInvoiceCode) || StringUtils.isBlank((CharSequence)originalInvoiceNo)) && StringUtils.isBlank((CharSequence)infoCode)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u8865\u5f55\u539f\u84dd\u7968\u4fe1\u606f\uff0c\u6216\u7ea2\u5b57\u4fe1\u606f\u8868\u7f16\u53f7", (String)"OriginalBillFormEditUtil_23", (String)"imc-sim-service", (Object[])new Object[0]));
        }
    }

    public static void checkOriginalInvoice(DynamicObject obj, String originalInvoiceCode, String originalInvoiceNo, Object issueTime, boolean redIsNull) {
        Date issueDate;
        String applicant = obj.getString("applicant");
        if (redIsNull && StringUtils.isBlank((CharSequence)originalInvoiceCode) && RedInfoConstant.ApplicantEnum.SALER.getCode().equals(applicant)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f85\u51b2\u84dd\u7968\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillFormEditUtil_24", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        if (redIsNull && StringUtils.isBlank((CharSequence)originalInvoiceNo) && RedInfoConstant.ApplicantEnum.SALER.getCode().equals(applicant)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f85\u51b2\u84dd\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillFormEditUtil_25", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)originalInvoiceCode) && !RegexUtil.isInvoiceCode((String)originalInvoiceCode) && RedInfoConstant.ApplicantEnum.SALER.getCode().equals(applicant)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f85\u51b2\u84dd\u7968\u4ee3\u7801\u683c\u5f0f\u9519\u8bef", (String)"OriginalBillFormEditUtil_26", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)originalInvoiceCode) && !RegexUtil.isInvoiceNo((String)originalInvoiceNo) && RedInfoConstant.ApplicantEnum.SALER.getCode().equals(applicant)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f85\u51b2\u84dd\u7968\u53f7\u7801\u683c\u5f0f\u9519\u8bef", (String)"OriginalBillFormEditUtil_27", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        if (redIsNull && issueTime == null && RedInfoConstant.ApplicantEnum.SALER.getCode().equals(applicant)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9500\u65b9\u7533\u8bf7\u65f6\u5f85\u51b2\u84dd\u7968\u5f00\u7968\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillFormEditUtil_28", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        if (issueTime != null && (issueDate = (Date)issueTime).after(new Date())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9500\u65b9\u7533\u8bf7\u65f6\u5f85\u51b2\u84dd\u7968\u5f00\u7968\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u65f6\u95f4", (String)"OriginalBillFormEditUtil_29", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)originalInvoiceNo) || StringUtils.isBlank((CharSequence)originalInvoiceCode)) {
            return;
        }
        String confirmInvoiceType = obj.getString("invoicetype");
        DynamicObject invoice = QueryServiceHelper.queryOne((String)"sim_vatinvoice", (String)"remainredamount,canredtaxamount,buyername,buyertaxno,invoicetype,salername,salertaxno", (QFilter[])InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)originalInvoiceCode, (String)originalInvoiceNo).toArray());
        if (invoice == null) {
            return;
        }
        if (!obj.getString("buyername").equals(invoice.getString("buyername"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u8d2d\u65b9\u540d\u79f0\u4e0e\u539f\u84dd\u7968\u8d2d\u65b9\u540d\u79f0\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u4fdd\u5b58", (String)"OriginalBillFormEditUtil_30", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        if (!obj.getString("buyertaxno").equals(invoice.getString("buyertaxno"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u8d2d\u65b9\u7a0e\u53f7\u4e0e\u539f\u84dd\u7968\u8d2d\u65b9\u7a0e\u53f7\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u4fdd\u5b58", (String)"OriginalBillFormEditUtil_31", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        String invoiceType = invoice.getString("invoicetype");
        if (InvoiceUtils.isSpecialInvoice((String)invoiceType) && !InvoiceUtils.isSpecialInvoice((String)confirmInvoiceType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u53d1\u7968\u79cd\u7c7b\u4e0e\u539f\u84dd\u7968\u53d1\u7968\u79cd\u7c7b\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u4fdd\u5b58", (String)"OriginalBillFormEditUtil_32", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        if (InvoiceUtils.isNormalInvoice((String)invoiceType) && !InvoiceUtils.isNormalInvoice((String)confirmInvoiceType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u53d1\u7968\u79cd\u7c7b\u4e0e\u539f\u84dd\u7968\u53d1\u7968\u79cd\u7c7b\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u4fdd\u5b58", (String)"OriginalBillFormEditUtil_32", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        if (obj.getBigDecimal("invoiceamount").abs().compareTo(invoice.getBigDecimal("remainredamount")) > 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u91d1\u989d\u8d85\u8fc7\u5269\u4f59\u53ef\u7ea2\u51b2\u91d1\u989d\uff0c\u65e0\u6cd5\u4fdd\u5b58\uff0c\u5269\u4f59\u53ef\u7ea2\u51b2\u91d1\u989d\u4e3a%s", (String)"OriginalBillFormEditUtil_33", (String)"imc-sim-service", (Object[])new Object[0]), invoice.getBigDecimal("remainredamount").setScale(2, 4)));
        }
        if (obj.getBigDecimal("totaltax").abs().compareTo(invoice.getBigDecimal("canredtaxamount")) > 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7a0e\u989d\u8d85\u8fc7\u5269\u4f59\u53ef\u7ea2\u51b2\u7a0e\u989d\uff0c\u65e0\u6cd5\u4fdd\u5b58\uff0c\u5269\u4f59\u53ef\u7ea2\u51b2\u7a0e\u989d\u4e3a%s", (String)"OriginalBillFormEditUtil_34", (String)"imc-sim-service", (Object[])new Object[0]), invoice.getBigDecimal("canredtaxamount").setScale(2, 4)));
        }
        long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)obj.get("orgid"));
        SaleInfo sale = TaxUtils.getSaleInfoByOrg((Long)orgId);
        if (!invoice.getString("salername").equals(sale.getSaleName())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u7ed1\u5b9a\u7684\u4f01\u4e1a\u9500\u65b9\u540d\u79f0\u4e0e\u539f\u84dd\u7968\u9500\u65b9\u540d\u79f0\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u4fdd\u5b58", (String)"OriginalBillFormEditUtil_35", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        if (!invoice.getString("salertaxno").equals(sale.getSaleTaxNo())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u7ed1\u5b9a\u7684\u4f01\u4e1a\u9500\u65b9\u7a0e\u53f7\u4e0e\u539f\u84dd\u7968\u9500\u65b9\u7a0e\u53f7\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u4fdd\u5b58", (String)"OriginalBillFormEditUtil_36", (String)"imc-sim-service", (Object[])new Object[0]));
        }
    }

    @SdkDeprecated
    public static CheckResult checkNormalRedReasonInfo(DynamicObject[] dynamicObjects, Boolean isAuto, Boolean isSave) {
        ArrayList errMsgList = Lists.newArrayListWithCapacity((int)dynamicObjects.length);
        ArrayList updateList = Lists.newArrayListWithCapacity((int)dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String billno;
            block10: {
                block11: {
                    block12: {
                        boolean isNotAllEle;
                        String invoiceType = dynamicObject.getString("invoicetype");
                        billno = dynamicObject.getString("billno");
                        if (InvoiceUtils.isSpecialInvoice((String)dynamicObject.getString("invoicetype")) || "1".equals(dynamicObject.getString("billproperties"))) continue;
                        if (StringUtils.isBlank((CharSequence)dynamicObject.getString("blueinvoicecode")) && StringUtils.isBlank((CharSequence)dynamicObject.getString("blueinvoiceno")) && isSave.booleanValue()) {
                            dynamicObject.set("blueinvoicetype", (Object)"");
                            dynamicObject.set("originalissuetime", null);
                            continue;
                        }
                        if (!isSave.booleanValue() && StringUtils.isBlank((CharSequence)dynamicObject.getString("blueinvoicecode")) && StringUtils.isBlank((CharSequence)dynamicObject.getString("blueinvoiceno")) && !InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
                            errMsgList.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u5f85\u51b2\u84dd\u7968\u4ee3\u7801\u3001\u5f85\u51b2\u84dd\u7968\u53f7\u7801 \u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillFormEditUtil_37", (String)"imc-sim-service", (Object[])new Object[0]), billno));
                            continue;
                        }
                        boolean bl = isNotAllEle = !InvoiceUtils.isAllEInvoice((Object)invoiceType) && !AllEleAuthHelper.isElePaper((Object)dynamicObject.getString("iselepaper"));
                        if (isNotAllEle && StringUtils.isBlank((CharSequence)dynamicObject.getString("blueinvoicecode")) && StringUtils.isNotBlank((CharSequence)dynamicObject.getString("blueinvoiceno")) || StringUtils.isNotBlank((CharSequence)dynamicObject.getString("blueinvoicecode")) && StringUtils.isBlank((CharSequence)dynamicObject.getString("blueinvoiceno"))) {
                            errMsgList.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u5f85\u51b2\u84dd\u7968\u4ee3\u7801\u3001\u5f85\u51b2\u84dd\u7968\u53f7\u7801 \u9700\u540c\u65f6\u4e0d\u4e3a\u7a7a\u6216\u540c\u65f6\u4e3a\u7a7a", (String)"OriginalBillFormEditUtil_38", (String)"imc-sim-service", (Object[])new Object[0]), billno));
                            continue;
                        }
                        if (InvoiceUtils.isExecuteInvoiceRule((String)invoiceType) && !InvoiceUtils.isAllEInvoice((Object)invoiceType) && !RegexUtil.isInvoiceCode((String)dynamicObject.getString("blueinvoicecode"))) {
                            errMsgList.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u5f85\u51b2\u84dd\u7968\u4ee3\u7801\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"OriginalBillFormEditUtil_39", (String)"imc-sim-service", (Object[])new Object[0]), billno));
                            continue;
                        }
                        if (InvoiceUtils.isExecuteInvoiceRule((String)invoiceType) && !InvoiceUtils.isAllEInvoice((Object)invoiceType) && !RegexUtil.isInvoiceNo((String)dynamicObject.getString("blueinvoiceno"))) {
                            errMsgList.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u5f85\u51b2\u84dd\u7968\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"OriginalBillFormEditUtil_40", (String)"imc-sim-service", (Object[])new Object[0]), billno));
                            continue;
                        }
                        if (InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
                            boolean isInvoiceNoSuccess;
                            String invoiceNo = dynamicObject.getString("blueinvoiceno");
                            boolean bl2 = isInvoiceNoSuccess = RegexUtil.isInvoiceNo((String)invoiceNo) || RegexUtil.isAllEInvoiceNo((String)invoiceNo);
                            if (!isInvoiceNoSuccess) {
                                errMsgList.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u5f85\u51b2\u84dd\u7968\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"OriginalBillFormEditUtil_40", (String)"imc-sim-service", (Object[])new Object[0]), billno));
                                continue;
                            }
                        }
                        if (!StringUtils.isBlank((CharSequence)dynamicObject.getString("blueinvoicetype")) && !StringUtils.isBlank((CharSequence)dynamicObject.getString("redreason")) && !StringUtils.isBlank((CharSequence)"originalissuetime")) break block10;
                        if (!isAuto.booleanValue()) break block11;
                        DynamicObject[] load = OriginalBillFormEditUtil.checkBlueInvoceIsExsit(dynamicObject);
                        if (load.length <= 0) break block12;
                        if ("6".equals(load[0].getString("invoicestatus")) || "3".equals(load[0].getString("invoicestatus"))) {
                            errMsgList.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u5f85\u51b2\u53d1\u7968\u5df2\u7ea2\u51b2\u6216\u5df2\u4f5c\u5e9f", (String)"OriginalBillFormEditUtil_41", (String)"imc-sim-service", (Object[])new Object[0]), billno));
                        }
                        dynamicObject.set("blueinvoicetype", (Object)load[0].getString("invoicetype"));
                        dynamicObject.set("originalissuetime", (Object)load[0].getDate("issuetime"));
                        dynamicObject.set("redreason", (Object)RedReasonEnum.INVOICE_ERR.getTypeCode());
                        updateList.add(dynamicObject);
                        break block10;
                    }
                    if (StringUtils.isBlank((CharSequence)dynamicObject.getString("blueinvoicetype")) || StringUtils.isBlank((CharSequence)dynamicObject.getString("originalissuetime"))) {
                        errMsgList.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u5f85\u51b2\u53d1\u7968\u79cd\u7c7b \u6216 \u5f85\u51b2\u84dd\u7968\u5f00\u7968\u65e5\u671f\u8bf7\u8865\u5145\u5b8c\u6574", (String)"OriginalBillFormEditUtil_42", (String)"imc-sim-service", (Object[])new Object[0]), billno));
                        continue;
                    }
                    if (!StringUtils.isBlank((CharSequence)dynamicObject.getString("redreason")) && RedReasonEnum.getAllTypeCode().contains(dynamicObject.getString("redreason"))) break block10;
                    dynamicObject.set("redreason", (Object)RedReasonEnum.INVOICE_ERR.getTypeCode());
                    updateList.add(dynamicObject);
                    break block10;
                }
                errMsgList.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u8bf7\u5c06 \u5f85\u51b2\u53d1\u7968\u79cd\u7c7b\u3001\u51b2\u7ea2\u539f\u56e0\u3001\u5f85\u51b2\u84dd\u7968\u5f00\u7968\u65e5\u671f \u8865\u5145\u5b8c\u6574", (String)"OriginalBillFormEditUtil_43", (String)"imc-sim-service", (Object[])new Object[0]), billno));
                continue;
            }
            if (!InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode().equals(dynamicObject.getString("invoicetype")) || InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode().equals(dynamicObject.getString("blueinvoicetype"))) continue;
            errMsgList.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u5377\u7968\u7684\u5f85\u51b2\u53d1\u7968\u79cd\u7c7b\u53ea\u80fd\u662f\u5377\u7968", (String)"OriginalBillFormEditUtil_44", (String)"imc-sim-service", (Object[])new Object[0]), billno));
        }
        CheckResult result = new CheckResult();
        result.setErrMsgList(errMsgList);
        result.setUpdateList(updateList);
        return result;
    }

    private static DynamicObject[] checkBlueInvoceIsExsit(DynamicObject bill) {
        QFilter filter = new QFilter("invoicecode", "=", (Object)bill.getString("blueinvoicecode")).and("invoiceno", "=", (Object)bill.getString("blueinvoiceno")).and("issuestatus", "=", (Object)"0").and("issuetype", "=", (Object)"0");
        if (InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode().equals(bill.getString("invoicetype"))) {
            filter.and("invoicetype", "=", (Object)InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode());
        } else {
            filter.and("invoicetype", "not in", (Object)InvoiceUtils.getSpecialInvoiceType().toArray());
        }
        return BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])new QFilter[]{filter});
    }

    public static void editRedConfirmBill(AbstractFormPlugin plugin, Object newValue, Object oldValue) {
        if (newValue == oldValue) {
            return;
        }
        if (!StringUtils.isBlank((Object)newValue)) {
            IDataModel model = plugin.getView().getModel();
            Object value = model.getValue("orgid");
            Long orgId = value instanceof DynamicObject ? Long.valueOf(((DynamicObject)value).getLong("id")) : (value instanceof Long ? (Long)value : Long.valueOf(RequestContext.get().getOrgId()));
            QFilter baseDataFilter = ImcBaseDataHelper.getRedConfirmFilter((Object)orgId);
            QFilter numberFilter = new QFilter("number", "=", newValue);
            DynamicObject redConfirm = BusinessDataServiceHelper.loadSingle((String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_confirm_bill", (boolean)true), (QFilter[])new QFilter[]{numberFilter, baseDataFilter});
            if (redConfirm == null) {
                OriginalBillFormEditUtil.emptyValue(model);
                plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u5f53\u524d\u7ea2\u5b57\u786e\u8ba4\u5355", (String)"OriginalBillFormEditUtil_45", (String)"imc-sim-service", (Object[])new Object[0]));
                return;
            }
            Object viewInvoiceType = model.getValue("invoicetype");
            if (!"1".equals(redConfirm.getString("uploadstatus"))) {
                OriginalBillFormEditUtil.emptyValue(model);
                plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ea2\u5b57\u786e\u8ba4\u5355\u975e\u5df2\u5f55\u5165", (String)"OriginalBillFormEditUtil_46", (String)"imc-sim-service", (Object[])new Object[0]));
                return;
            }
            String issueStatus = redConfirm.getString("issuestatus");
            if (!"2".equals(issueStatus) && !"3".equals(issueStatus)) {
                OriginalBillFormEditUtil.emptyValue(model);
                plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ea2\u5b57\u786e\u8ba4\u5355\u975e\u672a\u5f00\u7968\u72b6\u6001", (String)"OriginalBillFormEditUtil_47", (String)"imc-sim-service", (Object[])new Object[0]));
                return;
            }
            if (!redConfirm.getString("invoicetype").equals(String.valueOf(viewInvoiceType))) {
                OriginalBillFormEditUtil.emptyValue(model);
                plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ea2\u5b57\u786e\u8ba4\u5355\u53d1\u7968\u7c7b\u578b\u548c\u5f53\u524d\u5355\u636e\u53d1\u7968\u7c7b\u578b\u4e0d\u4e00\u81f4", (String)"OriginalBillFormEditUtil_48", (String)"imc-sim-service", (Object[])new Object[0]));
                return;
            }
            String source = redConfirm.getString("source");
            if ("5".equals(source) || "10".equals(source)) {
                OriginalBillFormEditUtil.emptyValue(model);
                plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ea2\u5b57\u786e\u8ba4\u5355\u5df2\u7ecf\u88ab\u5360\u7528", (String)"OriginalBillFormEditUtil_49", (String)"imc-sim-service", (Object[])new Object[0]));
                return;
            }
            model.setValue("originalissuetime", redConfirm.get("originalissuetime"));
            model.setValue("blueinvoiceno", redConfirm.get("originalinvoiceno"));
            model.setValue("blueinvoicetype", redConfirm.get("originalinvoicetype"));
            model.setValue("redreason", (Object)RedConfirmHelper.matchBillRedReason((Object)redConfirm.getString("redreason")));
        }
    }

    private static void emptyValue(IDataModel model) {
        model.setValue("originalissuetime", null);
        model.setValue("blueinvoiceno", null);
        model.setValue("blueinvoicetype", null);
    }

    public static void checkBillRedConfirmBillDO(DynamicObject bill) {
        boolean isEle;
        boolean bl = isEle = InvoiceUtils.isAllEInvoice((Object)bill.getString("invoicetype")) || AllEleAuthHelper.isElePaper((Object)bill.getString("iselepaper"));
        if (!isEle) {
            return;
        }
        String billProperties = bill.getString("billproperties");
        if (!"-1".equals(billProperties)) {
            return;
        }
        String originalInvoiceNo = bill.getString("blueinvoiceno");
        String originalInvoiceCode = bill.getString("blueinvoicecode");
        if (StringUtils.isNotBlank((CharSequence)originalInvoiceCode) && !RegexUtil.isInvoiceCode((String)originalInvoiceCode)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f85\u51b2\u84dd\u7968\u4ee3\u7801\u683c\u5f0f\u9519\u8bef", (String)"OriginalBillFormEditUtil_26", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)originalInvoiceCode) && !RegexUtil.isInvoiceNo((String)originalInvoiceNo)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f85\u51b2\u84dd\u7968\u53f7\u7801\u683c\u5f0f\u9519\u8bef", (String)"OriginalBillFormEditUtil_27", (String)"imc-sim-service", (Object[])new Object[0]));
        }
    }
}

