/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.util;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.helper.allele.CreditQuotaHelper;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginalBillPluginIssueControl;
import org.apache.commons.lang3.tuple.Pair;

public class SelectDeviceUtil {
    public static final String BUTTON_CONTENT = "content";
    public static final String CONFIRM_AMOUNT = "confirmAmount";

    public static void initSelectDeviceView(AbstractFormPlugin that) {
        FormShowParameter parameter = that.getView().getFormShowParameter();
        JSONArray jsonArray = (JSONArray)parameter.getCustomParam("pks");
        if (Objects.isNull(jsonArray)) {
            return;
        }
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)String.join((CharSequence)",", "orgid", "salertaxno", "invoicetype", "salertaxno", "iselepaper", "jqbh", "terminalno", "totalamount", "totaltax", "itemcount", "drawer"), (QFilter[])new QFilter("id", "in", (Object)jsonArray).toArray());
        long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)bills[0].get("orgid"));
        that.getPageCache().put("orgid", String.valueOf(orgId));
        that.getPageCache().put("invoicetype", bills[0].getString("invoicetype"));
        that.getPageCache().put("salertaxno", bills[0].getString("salertaxno"));
        that.getPageCache().put("iselepaper", bills[0].getString("iselepaper"));
        SelectDeviceUtil.setJqbh(that, bills);
        BigDecimal confirmAmount = SelectDeviceUtil.setInvoiceAmountTotal(that, bills);
        if (InvoiceUtils.isAllEInvoice((Object)bills[0].getString("invoicetype")) || AllEleAuthHelper.isElePaper((Object)bills[0].getString("iselepaper"))) {
            SelectDeviceUtil.setAccount(that, bills[0].getString("salertaxno"), bills[0].getString("drawer"));
            SelectDeviceUtil.setCreditQuota(that, bills[0].getString("salertaxno"), confirmAmount, false);
        } else {
            that.getView().setVisible(Boolean.FALSE, new String[]{"eallsurplus"});
        }
    }

    public static void setAccount(AbstractFormPlugin that, String taxNo, String drawer) {
        String leqiLianYongAccount;
        if (!EnterpriseHelper.isRpaIssueChannel((String)taxNo)) {
            that.getView().setVisible(Boolean.FALSE, new String[]{"flexaccount", "accountflex"});
            that.getView().getModel().setValue("account", (Object)"");
            return;
        }
        that.getView().setVisible(Boolean.TRUE, new String[]{"flexaccount", "accountflex"});
        DynamicObject account = AllEleAuthHelper.getAccountByTaxNo((String)taxNo);
        Pair accountList = AllEleAuthHelper.getAccountList((DynamicObject)account, (boolean)true);
        ViewUtil.setDropDownViewData((AbstractFormPlugin)that, (String)"account", (Map)((Map)accountList.getValue()));
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)accountList.getKey()))) {
            that.getView().getModel().setValue("account", accountList.getKey());
        }
        if (StringUtils.isNotBlank((CharSequence)(leqiLianYongAccount = AllEleAuthHelper.getLeqiLianYongAccountByDrawer((DynamicObject)account, (String)drawer)))) {
            that.getView().getModel().setValue("account", accountList.getKey());
        }
    }

    public static void setCreditQuota(AbstractFormPlugin that, String salerTaxNo, BigDecimal confirmAmount, boolean isCallBack) {
        String creditQuota = CreditQuotaHelper.getCreditQuota((AbstractFormPlugin)that, (String)salerTaxNo);
        that.getView().getModel().setValue("surplus", (Object)creditQuota);
        that.getView().getModel().setValue(CONFIRM_AMOUNT, (Object)CreditQuotaHelper.getNumberFormat((BigDecimal)confirmAmount));
        String currentsurplus = CreditQuotaHelper.getNumberFormat((BigDecimal)new BigDecimal(creditQuota.replace(",", "")).subtract(confirmAmount));
        that.getView().getModel().setValue("currentsurplus", (Object)currentsurplus);
        if (!isCallBack) {
            that.getPageCache().put(CONFIRM_AMOUNT, confirmAmount.toString());
        }
    }

    private static void setJqbh(AbstractFormPlugin that, DynamicObject[] bills) {
        if (InvoiceUtils.isAllEInvoice((Object)bills[0].getString("invoicetype")) || AllEleAuthHelper.isElePaper((Object)bills[0].getString("iselepaper"))) {
            that.getView().setVisible(Boolean.FALSE, new String[]{"jqbhflex"});
            that.getView().getModel().setValue("jqbh", (Object)"");
            return;
        }
        that.getView().setVisible(Boolean.FALSE, new String[]{"creditflex"});
        boolean onlyDev = OriginalBillPluginIssueControl.checkBillDev(bills);
        String jqbh = bills[0].getString("jqbh");
        if (EquipmentHelper.isDisableJQBH((Object)bills[0].getString("salertaxno"), (Object)jqbh)) {
            jqbh = null;
        }
        long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)bills[0].get("orgid"));
        SelectDeviceUtil.setEquipmentAndTerminaNo(that, orgId);
        if (onlyDev) {
            that.getView().getModel().setValue("jqbh", (Object)jqbh);
        } else {
            that.getView().getModel().setValue("jqbh", null);
        }
        if (StringUtils.isNotBlank((CharSequence)jqbh) && onlyDev) {
            that.getView().getModel().setValue("terminalno", (Object)bills[0].getString("terminalno"));
        }
    }

    private static BigDecimal setInvoiceAmountTotal(AbstractFormPlugin that, DynamicObject[] bills) {
        BigDecimal confirmAmount = BigDecimal.ZERO;
        BigDecimal totalTax = BigDecimal.ZERO;
        long itemSize = 0L;
        for (DynamicObject bill : bills) {
            BigDecimal bigDecimal = bill.getBigDecimal("totalamount");
            BigDecimal billTotalTax = bill.getBigDecimal("totaltax");
            confirmAmount = confirmAmount.add(bigDecimal);
            totalTax = totalTax.add(billTotalTax);
            itemSize += (long)bill.getInt("itemcount");
        }
        confirmAmount = confirmAmount.setScale(2, 4);
        totalTax = totalTax.setScale(2, 4);
        Label label = (Label)that.getControl(BUTTON_CONTENT);
        if (bills.length == 1) {
            that.getView().setEnable(Boolean.FALSE, new String[]{"ismergebill"});
        }
        label.setText(String.format(ResManager.loadKDString((String)"\u603b\u8ba1\u63d0\u4ea4\u5355\u636e%1$s\u6761\uff0c\u660e\u7ec6%2$s\u6761\uff0c\u4ef7\u7a0e\u5408\u8ba1%3$s\u5143\uff0c\u7a0e\u989d%4$s", (String)"SelectDeviceUtil_0", (String)"imc-sim-service", (Object[])new Object[0]), bills.length, itemSize, confirmAmount, totalTax));
        return confirmAmount.subtract(totalTax);
    }

    public static void setEquipmentAndTerminaNo(AbstractFormPlugin that, long orgId) {
        orgId = orgId == 0L ? RequestContext.get().getOrgId() : orgId;
        SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)orgId);
        EquipmentUtil.initEquipmentAndTerminal((AbstractFormPlugin)that, (long)orgId, (String)saleInfo.getSaleTaxNo(), (String)"jqbh", (String)"terminalno", (boolean)true);
    }
}

