/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.workbench.alleevent;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.dto.BillRelationDTO;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.formplugin.bill.originalbill.workbench.alleevent.AbstractAllEBillWorkbenchCustomEvent;
import kd.imc.sim.formplugin.bill.originalbill.workbench.alleevent.AllEBillTabCustomEvent;
import kd.imc.sim.formplugin.bill.originalbill.workbench.alleevent.AllEBillWorkbenchCacheHelper;
import kd.imc.sim.formplugin.bill.originalbill.workbench.event.BillProcessTabCustomEvent;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class AllEBillProcessPositiveTabCustomEvent
extends AbstractAllEBillWorkbenchCustomEvent {
    @Override
    public void customEvent(AbstractFormPlugin that, CustomEventArgs e) {
        String event = e.getEventName();
        String param = e.getEventArgs();
        switch (event) {
            case "process/positive/queryPositiveBill": {
                this.queryPositiveOrNegativeBill(that, param, "positive", "process/positive/queryPositiveBill");
                break;
            }
            case "process/positive/queryInvoiceByBillId": {
                this.queryInvoiceByBillList(that, param, "process/positive/queryInvoiceByBillId");
                break;
            }
            case "process/positive/changeSplitRule": {
                new BillProcessTabCustomEvent().changeSplitRule(that, param, "process/positive/changeSplitRule");
                break;
            }
            case "process/positive/queryMergeDeviation": {
                new BillProcessTabCustomEvent().queryMergeDeviation(that, param, "process/positive/queryMergeDeviation");
                break;
            }
            case "process/positive/openFixedQuantity": {
                ViewUtil.openDialog((AbstractFormPlugin)that, null, (String)"sim_bill_fixed_quantity", (String)"process/positive/openFixedQuantity");
                break;
            }
            case "process/positive/nextStep": {
                this.nextStep(that, param);
                break;
            }
            case "process/positive/queryBuyer": {
                this.queryBuyer(that, param);
                break;
            }
            case "process/positive/queryPlace": {
                this.queryPlace(that, param);
                break;
            }
            case "process/positive/changeSpecification": {
                this.changeSpecification(that, param);
            }
        }
    }

    private void changeSpecification(AbstractFormPlugin that, String param) {
        that.getPageCache().put(that.getView().getPageId() + "changeSpecification", param);
        ViewUtil.openNormalConfirm((AbstractFormPlugin)that, (String)ResManager.loadKDString((String)"\u662f\u5426\u5e94\u7528\u4e8e\u672c\u53d1\u7968\u5176\u5b83\u9879\u76ee\u540d\u79f0\u76f8\u540c\u7684\u660e\u7ec6\uff1f", (String)"AllEBillProcessPositiveTabCustomEvent_0", (String)"imc-sim-service", (Object[])new Object[0]), (String)"process/positive/changeSpecification");
    }

    private void queryPlace(AbstractFormPlugin that, String param) {
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"bdm_admindivision", (boolean)false, (int)2, (boolean)true);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)that, "process/positive/queryPlace"));
        that.getPageCache().put(that.getView().getPageId() + "queryPlace", param);
        that.getView().showForm((FormShowParameter)showParameter);
    }

    private void queryBuyer(AbstractFormPlugin that, String param) {
        AllEBillProcessPositiveTabCustomEvent.putPageCache(that, "process/positive/queryBuyer", param);
        QFilter filter = ImcBaseDataHelper.getInvTitleFilter((Object)AllEBillWorkbenchCacheHelper.getCurrentOrg(that));
        ViewUtil.openListPage((AbstractFormPlugin)that, (QFilter)filter, (String)"bdm_invice_title_strate", (String)"process/positive/queryBuyer");
    }

    private void nextStep(AbstractFormPlugin that, String param) {
        JSONObject invRealtionMap;
        JSONObject json = JSONObject.parseObject((String)param);
        JSONObject invoiceMap = json.getJSONObject("invoices");
        if (invoiceMap != null) {
            Set invoiceEntries = invoiceMap.entrySet();
            for (Object entry : invoiceEntries) {
                JSONArray invoiceList = (JSONArray)entry.getValue();
                PriceHelper.convertPrice2Str((JSONArray)invoiceList);
                for (Object o : invoiceList) {
                    JSONObject invJson = (JSONObject)o;
                    String issueType = invJson.getString("issuetype");
                    JSONArray extra = invJson.getJSONArray("extra");
                    StringBuilder extraRemarkBuilder = new StringBuilder(" ");
                    if (!IssueType.BLUE_INVOICE.getTypeCode().equals(issueType) || null == extra || extra.size() <= 0) continue;
                    for (Object extraItem : extra) {
                        JSONObject extraItemJson = (JSONObject)extraItem;
                        extraRemarkBuilder.append(extraItemJson.get((Object)"extrainfoname")).append(":").append(extraItemJson.get((Object)"extrainfovalue")).append(" ");
                    }
                    invJson.put("extraRemark", (Object)extraRemarkBuilder.toString());
                }
                if (invoiceList.size() == 0) continue;
                AllEBillProcessPositiveTabCustomEvent.putPageCache(that, (String)entry.getKey() + "invoice", invoiceList.toJSONString());
                AllEBillProcessPositiveTabCustomEvent.putPageCache(that, (String)entry.getKey() + "count", String.valueOf(invoiceList.size()));
            }
        }
        if ((invRealtionMap = json.getJSONObject("invRealtion")) != null) {
            Set relationEntries = invRealtionMap.entrySet();
            for (Object entry : relationEntries) {
                JSONArray invRelationList = (JSONArray)entry.getValue();
                if (invRelationList == null || invRelationList.size() == 0) continue;
                AllEBillProcessPositiveTabCustomEvent.putPageCache(that, (String)entry.getKey() + "relation", invRelationList.toJSONString());
            }
        }
        List<String> mergeBillId = AllEBillWorkbenchCacheHelper.getCacheMergeBillIdList(that);
        int invoiceCount = 0;
        for (String billId : mergeBillId) {
            String billInvoiceCount = AllEBillProcessPositiveTabCustomEvent.getPageCacheVal(that, billId + "count");
            if (!StringUtils.isNotBlank((String)billInvoiceCount)) continue;
            invoiceCount += Integer.parseInt(billInvoiceCount);
        }
        AllEBillProcessPositiveTabCustomEvent.setCurrentDisplay(that, Boolean.TRUE, 2, false);
        Map<String, Object> params = AllEBillProcessPositiveTabCustomEvent.getCurrentPageParams(AllEBillProcessPositiveTabCustomEvent.getPageCacheVal(that, "currentTab"), 2);
        params.put("invoicecount", invoiceCount);
        AllEBillProcessPositiveTabCustomEvent.putPageCache(that, "blueInvoiceCount", String.valueOf(invoiceCount));
        AllEBillProcessPositiveTabCustomEvent.updateCustomControl(that, params, "process/positive/nextStepReturn");
    }

    void queryPositiveOrNegativeBill(AbstractFormPlugin that, String param, String tab, String eventKey) {
        String tableId = "sim_merge_bill";
        String idCacheKey = "mergebillPks";
        boolean isNegative = "negative".equals(tab);
        if (isNegative) {
            tableId = "sim_match_bill";
            idCacheKey = "matchbillPks";
        }
        JSONObject json = JSONObject.parseObject((String)param);
        String mergePkksStr = AllEBillProcessPositiveTabCustomEvent.getPageCacheVal(that, idCacheKey);
        List pkList = Arrays.stream(mergePkksStr.split(",")).collect(Collectors.toList());
        HashMap<String, Object> returnMap = new HashMap<String, Object>(4);
        try {
            HashMap<String, Object> map = new HashMap<String, Object>((Map<String, Object>)json);
            List subIdList = this.getSubIdList(pkList, json);
            ArrayList<DynamicObject> mergeOrMatchBills = new ArrayList<DynamicObject>(subIdList.size());
            for (String mergeOrMatchId : subIdList) {
                Map billMap = (Map)SerializationUtils.fromJsonString((String)AllEBillProcessPositiveTabCustomEvent.getPageCacheVal(that, mergeOrMatchId), Map.class);
                DynamicObject bill2 = BusinessDataServiceHelper.newDynamicObject((String)tableId);
                DynamicObjectUtil.map2DynamicObject((Map)billMap, (DynamicObject)bill2);
                mergeOrMatchBills.add(bill2);
            }
            if (isNegative) {
                AllEBillTabCustomEvent tabCustomEvent = new AllEBillTabCustomEvent();
                ArrayList matchBillMaps = new ArrayList(subIdList.size());
                mergeOrMatchBills.forEach(bill -> matchBillMaps.addAll(tabCustomEvent.handleMatchBill((DynamicObject)bill, true)));
                BigDecimal totalAmount = BigDecimal.ZERO;
                BigDecimal matchAmount = BigDecimal.ZERO;
                for (DynamicObject matchBill : mergeOrMatchBills) {
                    totalAmount = totalAmount.add(matchBill.getBigDecimal("applyamount").setScale(2, 4));
                    matchAmount = matchAmount.add(matchBill.getBigDecimal("matchamount").setScale(2, 4).abs());
                }
                AllEBillProcessPositiveTabCustomEvent.putPageCache(that, "matchamountlabel", matchAmount.negate().toString());
                AllEBillProcessPositiveTabCustomEvent.putPageCache(that, "unmatchamountlabel", totalAmount.add(matchAmount).setScale(2, 4).toString());
                this.setMatchBillMatchAmount(that);
                this.setMatchBillUnMatchAmount(that);
                map.put("negativeBillList", matchBillMaps);
                map.put("pks", AllEBillWorkbenchCacheHelper.getCacheMatchBillIdList(that));
                map.put("totalPage", (pkList.size() - 1) / 10 + 1);
                map.put("total", pkList.size());
            } else {
                map.put("positiveBillList", this.getHandlerList(mergeOrMatchBills));
            }
            returnMap.put(tab, map);
            AllEBillProcessPositiveTabCustomEvent.updateCustomControl(that, returnMap, eventKey);
        }
        catch (Exception e) {
            that.getView().showErrorNotification(e.getMessage());
            AllEBillProcessPositiveTabCustomEvent.updateCustomControlError(that, returnMap, eventKey);
        }
    }

    void queryInvoiceByBillList(AbstractFormPlugin that, String pk, String eventKey) {
        DynamicObject[] invoices;
        DynamicObjectCollection relations;
        HashMap curInvoiceMap = new HashMap(4);
        String cacheBillInvoiceStr = AllEBillWorkbenchCacheHelper.getCacheBillInvoiceStr(that, pk);
        List list = new ArrayList(1);
        if (StringUtils.isNotBlank((String)cacheBillInvoiceStr)) {
            list = (List)SerializationUtils.fromJsonString((String)cacheBillInvoiceStr, List.class);
        } else if (StringUtils.isNotBlank((String)AllEBillProcessPositiveTabCustomEvent.getPageCacheVal(that, "repeatInit")) && CollectionUtils.isNotEmpty((Collection)(relations = QueryServiceHelper.query((String)"sim_merge_inv_relation", (String)"tbillid", (QFilter[])new QFilter("sbillid", "=", (Object)Long.parseLong(pk)).toArray()))) && (invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])new QFilter("id", "in", (Object)relations.stream().map(relation -> relation.getLong("tbillid")).toArray()).toArray())) != null && invoices.length != 0) {
            list = DynamicObjectUtil.dynamicObjects2ListMap((DynamicObject[])invoices, (boolean)true);
            AllEBillProcessPositiveTabCustomEvent.putPageCache(that, pk + "invoice", SerializationUtils.toJsonString(list));
        }
        for (Map map : list) {
            List extra = (List)map.get("extra");
            if (null == extra) continue;
            StringBuilder extraRemarkBuilder = new StringBuilder(" ");
            for (Map extraItem : extra) {
                extraRemarkBuilder.append(extraItem.get("extrainfoname")).append(":").append(extraItem.get("extrainfovalue")).append(" ");
            }
            map.put("extraRemark", extraRemarkBuilder.toString());
        }
        curInvoiceMap.put(pk, list);
        HashMap<String, Object> returnMap = new HashMap<String, Object>(4);
        returnMap.put("curInvoiceList", curInvoiceMap);
        String cacheBillInvoiceRelations = AllEBillWorkbenchCacheHelper.getCacheBillInvoiceRelations(that, pk);
        JSONObject invoiceRelationMap = new JSONObject();
        if (StringUtils.isNotBlank((String)cacheBillInvoiceRelations)) {
            if (cacheBillInvoiceRelations.contains("sBillId")) {
                List relations2 = JSONArray.parseArray((String)cacheBillInvoiceRelations, BillRelationDTO.class);
                invoiceRelationMap.put(pk, AllEBillProcessPositiveTabCustomEvent.relations2ListMap(relations2));
            } else {
                JSONArray invRelationArr = JSONArray.parseArray((String)cacheBillInvoiceRelations);
                ArrayList<JSONObject> relationList = new ArrayList<JSONObject>(invRelationArr.size());
                for (int i = 0; i < invRelationArr.size(); ++i) {
                    relationList.add(invRelationArr.getJSONObject(i));
                }
                invoiceRelationMap.put(pk, relationList);
            }
        } else {
            invoiceRelationMap.put(pk, new ArrayList(1));
        }
        returnMap.put("curInvoiceRelationMap", invoiceRelationMap);
        returnMap.put("billId", pk);
        AllEBillProcessPositiveTabCustomEvent.updateCustomControl(that, returnMap, eventKey);
    }
}

