/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.workbench.alleevent;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.table.RedReasonEnum;
import kd.imc.bdm.common.dto.BillRelationDTO;
import kd.imc.bdm.common.dto.merge.MergeRequestDTO;
import kd.imc.bdm.common.dto.merge.MergeResponseDTO;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.SystemParameterHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.constant.RedConfirmBillRedReasonEnum;
import kd.imc.sim.common.constant.table.MatchBillConstant;
import kd.imc.sim.common.helper.OriginalBillHelper;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.service.WideInvoiceSevice;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.bill.originalbill.workbench.alleevent.AbstractAllEBillWorkbenchCustomEvent;
import kd.imc.sim.formplugin.bill.originalbill.workbench.alleevent.AllEBillWorkbenchCacheHelper;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillMergeHelper;
import kd.imc.sim.formplugin.bill.splitMerge.split.impl.AbstractBillSplitServiceImpl;
import kd.imc.sim.formplugin.match.MinusBillMatchHelper;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillHelper;
import org.apache.commons.collections.CollectionUtils;

public class AllEBillTabCustomEvent
extends AbstractAllEBillWorkbenchCustomEvent {
    @Override
    public void customEvent(AbstractFormPlugin that, CustomEventArgs e) {
        String event = e.getEventName();
        String param = e.getEventArgs();
        switch (event) {
            case "bill/changeMergeRule": {
                AllEBillTabCustomEvent.putPageCache(that, "bill/changeMergeRule", param);
                break;
            }
            case "bill/mergebill": {
                this.mergeBill(that, param);
                break;
            }
            case "bill/showOriginalBill": {
                this.openOriginalBill(that, param);
                break;
            }
            case "bill/removeBill": {
                this.removeBill(that, param);
                break;
            }
            case "bill/queryBill": {
                this.queryBill(that, param);
            }
        }
    }

    public void nextStep(AbstractFormPlugin that) {
        List<String> cacheBillIdList = AllEBillWorkbenchCacheHelper.getCacheBillIdList(that);
        if (CollectionUtils.isEmpty(cacheBillIdList)) {
            that.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u53ef\u5f00\u7968\u5355\u636e\uff0c\u8bf7\u9000\u51fa\u5de5\u4f5c\u53f0\u91cd\u65b0\u9009\u53d6\u5355\u636e", (String)"BillTabCustomEvent_5", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        AllEBillTabCustomEvent.setNegativeMaxIndex(that, 1);
        AllEBillTabCustomEvent.setPositiveMaxIndex(that, 1);
        String currentTab = AllEBillTabCustomEvent.getPageCacheVal(that, "currentTab");
        if (StringUtils.isBlank((CharSequence)currentTab)) {
            currentTab = "positive";
        }
        AllEBillTabCustomEvent.putPageCache(that, "currentTab", currentTab);
        AllEBillTabCustomEvent.setCurrentDisplay(that, "positive".equals(currentTab), 1, false);
        AllEBillTabCustomEvent.updateCustomControl(that, AllEBillTabCustomEvent.getCurrentPageParams(currentTab, 1), "bill/nextSetp");
    }

    public void mergeBill(AbstractFormPlugin that, String param) {
        try {
            Map positiveMap;
            MergeResponseDTO mergeResponse;
            DynamicObject mergeRule;
            JSONObject json;
            boolean isMergeBill;
            String onlyPositive = that.getPageCache().getBigObject("onlypositive");
            if (StringUtils.isNotBlank((CharSequence)onlyPositive)) {
                Map returnMap = (Map)SerializationUtils.fromJsonString((String)onlyPositive, Map.class);
                AllEBillTabCustomEvent.updateCustomControl(that, returnMap, "bill/mergebill");
                return;
            }
            List<String> pks = AllEBillWorkbenchCacheHelper.getCacheBillIdList(that);
            DynamicObject[] bills = OriginalBillHelper.queryOriginalbillsByIds(pks.stream().map(Long::parseLong).toArray(), AllEBillTabCustomEvent.getMergeBillQueryField(), "originbillseq desc");
            boolean tempSavePriview = "1".equals(AllEBillTabCustomEvent.getPageCacheVal(that, "tempSavePreview"));
            if (!tempSavePriview) {
                HashMap<String, StringBuilder> usedMap = new HashMap<String, StringBuilder>(bills.length);
                HashMap<Long, String> userPkNameMap = new HashMap<Long, String>(bills.length);
                for (DynamicObject bill2 : bills) {
                    this.checkBillUsed(usedMap, userPkNameMap, bill2);
                }
                if (usedMap.size() > 0) {
                    AllEBillTabCustomEvent.setCurrentDisplay(that, true, 0);
                    this.showErrMsgAndJumpFirstPage(that, this.generateTips(usedMap));
                    return;
                }
            }
            if (isMergeBill = (json = JSONObject.parseObject((String)param)).getBoolean("mergeBill").booleanValue()) {
                BotpHelper.checkBillsComplete((DynamicObject[])bills);
            }
            if (DynamicObjectUtil.getDynamicObjectLongValue((Object)json.get((Object)"mergeRuleId")) != 0L && (mergeRule = BusinessDataServiceHelper.loadSingle((String)"bdm_merge_rule_strategy", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_merge_rule_strategy"), (QFilter[])new QFilter("id", "=", (Object)json.getLong("mergeRuleId")).toArray())) != null) {
                for (DynamicObject bill3 : bills) {
                    bill3.set("mergerule", (Object)mergeRule);
                }
            }
            try {
                MergeRequestDTO request = new MergeRequestDTO.Builder().mergeBill(isMergeBill).mergeBillDetail(json.getBoolean("mergeBillDetail").booleanValue()).bills(bills).build();
                mergeResponse = new BillMergeHelper().mergeBill(request);
                AllEBillTabCustomEvent.putPageCache(that, "currentAccount", json.getString("currentAccount"));
                AllEBillTabCustomEvent.putPageCache(that, "mergeRelations", SerializationUtils.toJsonString((Object)mergeResponse.getRelations()));
                AllEBillTabCustomEvent.putPageCache(that, "billNoMap", SerializationUtils.toJsonString((Object)mergeResponse.getBillNoMap()));
            }
            catch (MsgException e) {
                String message = ResManager.loadKDString((String)"\u5355\u636e\u5b58\u5728\u660e\u7ec6\u8d85\u8fc7\u7a0e\u63a7\u5c3e\u5dee\uff0c\u8bf7\u8c03\u6574\u6570\u636e\u540e\u5f00\u7968\u3002", (String)"AllEBillTabCustomEvent_0", (String)"imc-sim-service", (Object[])new Object[0]);
                if ("mergeMoreThanTaxControl".equals(e.getErrorCode())) {
                    message = ResManager.loadKDString((String)"\u5355\u636e\u7684\u660e\u7ec6\u5408\u5e76\u540e\u8d85\u8fc7\u7a0e\u63a7\u5141\u8bb8\u7684\u5c3e\u5dee\uff0c\u65e0\u6cd5\u5408\u5e76\uff0c\u8bf7\u91cd\u65b0\u52fe\u9009\u5355\u636e\u6216\u5728\u3010\u53d1\u7968\u62c6\u5408\u8bbe\u7f6e\u3011\u4e2d\u91cd\u65b0\u914d\u7f6e\u5408\u5e76\u89c4\u5219\u3002", (String)"AllEBillTabCustomEvent_1", (String)"imc-sim-service", (Object[])new Object[0]);
                }
                that.getView().showMessage(message, e.getErrorMsg(), MessageTypes.Commit);
                AllEBillTabCustomEvent.setCurrentDisplay(that, true, 0);
                return;
            }
            catch (KDBizException e) {
                this.showErrMsgAndJumpFirstPage(that, e.getMessage());
                return;
            }
            String operateBatch = this.getOperateBatch();
            AllEBillTabCustomEvent.putPageCache(that, "operatebatch", operateBatch);
            List mergeBillList = mergeResponse.getBills();
            ArrayList<DynamicObject> negativeBillList = new ArrayList<DynamicObject>(mergeBillList.size());
            ArrayList<DynamicObject> positiveBillList = new ArrayList<DynamicObject>(mergeBillList.size());
            for (DynamicObject mergeBill : mergeBillList) {
                if (mergeBill.getBigDecimal("totalamount").compareTo(BigDecimal.ZERO) > 0) {
                    positiveBillList.add(mergeBill);
                    continue;
                }
                negativeBillList.add(mergeBill);
            }
            HashMap<String, Object> returnMap = new HashMap<String, Object>(4);
            if (CollectionUtils.isNotEmpty(positiveBillList)) {
                HashMap<String, Object> positiveBill = new HashMap<String, Object>(4);
                returnMap.put("positive", positiveBill);
                List positiveBills = mergeResponse.getBills();
                ArrayList<DynamicObject> mergeBills = new ArrayList<DynamicObject>(positiveBills.size());
                for (DynamicObject bill4 : positiveBillList) {
                    DynamicObject mergeBill = this.createMergeBill(bill4, operateBatch);
                    mergeBills.add(mergeBill);
                }
                mergeResponse.setBills(mergeBills);
                positiveBill.putAll(AllEBillTabCustomEvent.splitCacheAllEBill(that, mergeResponse));
                positiveBill.remove("invoiceList");
                positiveBill.remove("invoiceRelationMap");
                positiveBill.put("pageIndex", 1);
                positiveBill.put("pageSize", 10);
                positiveBill.put("total", positiveBillList.size());
                positiveBill.put("totalPage", (positiveBillList.size() - 1) / 10 + 1);
                List<Map<String, Object>> positiveBillMapList = this.getHandlerList(positiveBillList.stream().limit(10L).collect(Collectors.toList()));
                PriceHelper.convertMapPrice2Str(positiveBillMapList);
                positiveBill.put("positiveBillList", positiveBillMapList);
                this.handleTaxDeviation((List)positiveBill.get("positiveBillList"), (Map)positiveBill.remove("taxDeviationBillMap"));
                AllEBillTabCustomEvent.putPageCache(that, "mergebillcountlabel", String.valueOf(positiveBillList.size()));
                AllEBillTabCustomEvent.putPageCache(that, "mergetotalamountlabel", positiveBillList.stream().map(bill -> bill.getBigDecimal("invoiceamount")).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, 4).toString());
                this.setMergeBillAmountLabel(that);
                this.setMergeBillCountLabel(that);
                AllEBillTabCustomEvent.putPageCache(that, "mergebillPks", positiveBillList.stream().map(bill -> String.valueOf(bill.getLong("id"))).collect(Collectors.joining(",")));
            }
            if (CollectionUtils.isNotEmpty(negativeBillList)) {
                if (CollectionUtils.isEmpty(positiveBillList)) {
                    AllEBillTabCustomEvent.putPageCache(that, "currentTab", "negative");
                    AllEBillTabCustomEvent.setCurrentDisplay(that, Boolean.FALSE, 1);
                }
                this.createNegativeReturn(that, returnMap, negativeBillList);
            }
            if (null != (positiveMap = (Map)returnMap.get("positive"))) {
                List positiveBillList1 = (List)positiveMap.get("positiveBillList");
                for (Map billMap : positiveBillList1) {
                    StringBuilder extraRemarkBuilder = new StringBuilder(" ");
                    List extra = (List)billMap.get("extra");
                    if (null == extra || extra.size() <= 0) continue;
                    for (Map extraItem : extra) {
                        extraRemarkBuilder.append(extraItem.get("extrainfoname")).append(":").append(extraItem.get("extrainfovalue")).append(" ");
                    }
                    billMap.put("extraRemark", extraRemarkBuilder.toString());
                }
            }
            if (!tempSavePriview) {
                String currentUserId = RequestContext.get().getUserId();
                for (String pk : pks) {
                    CacheHelper.put((String)(pk + "workbench"), (String)currentUserId);
                }
            }
            this.showMergeTips(that, isMergeBill, bills);
            List removeBills = mergeResponse.getRemoveBills();
            if (CollectionUtils.isNotEmpty((Collection)removeBills)) {
                this.onlyPositiveConfirm(that, bills, removeBills, pks, returnMap);
                AllEBillTabCustomEvent.setCurrentDisplay(that, true, 0);
                return;
            }
            AllEBillTabCustomEvent.updateCustomControl(that, returnMap, "bill/mergebill");
        }
        catch (Exception e) {
            LOGGER.error("\u8fdb\u5165\u5355\u636e\u5904\u7406\u9875\u9762\u5931\u8d25", (Throwable)e);
            AllEBillTabCustomEvent.handleExcepiton(that, e);
            AllEBillTabCustomEvent.setCurrentDisplay(that, true, 0);
        }
    }

    private void showErrMsgAndJumpFirstPage(AbstractFormPlugin that, String message) {
        that.getView().showErrorNotification(message);
        AllEBillTabCustomEvent.setCurrentDisplay(that, true, 0);
    }

    public List<DynamicObject> createMergeBill(List<DynamicObject> billList) {
        String operateBatch = this.getOperateBatch();
        for (DynamicObject bill : billList) {
            this.createMergeBill(bill, operateBatch);
        }
        return billList;
    }

    public DynamicObject createMergeBill(DynamicObject bill, String operateBatch) {
        DynamicObject mergeBill = BusinessDataServiceHelper.newDynamicObject((String)"sim_merge_bill");
        DynamicObjectUtil.copyDynamicObject((DynamicObject)bill, (DynamicObject)mergeBill, (boolean)true, (boolean)true, (boolean)true);
        mergeBill.set("originbillseq", (Object)(operateBatch + "blue"));
        mergeBill.set("surplusamount", mergeBill.get("invoiceamount"));
        mergeBill.set("surplustax", mergeBill.get("totaltax"));
        DynamicObjectCollection items = mergeBill.getDynamicObjectCollection("sim_original_bill_item");
        for (DynamicObject item : items) {
            item.set("tax", item.get("remainvalidtax"));
            item.set("taxamount", item.get("remainvalidamount"));
            item.set("amount", (Object)item.getBigDecimal("taxamount").subtract(item.getBigDecimal("tax")));
            item.set("num", (Object)item.getBigDecimal("remainvalidnum"));
            item.set("issuedamount", (Object)BigDecimal.ZERO);
            item.set("issuedtax", (Object)BigDecimal.ZERO);
            item.set("issuedtotaltaxamount", (Object)BigDecimal.ZERO);
            item.set("issuednum", (Object)BigDecimal.ZERO);
        }
        AbstractBillSplitServiceImpl.copyOtherEntry(bill, mergeBill, new HashSet<String>(Collections.singletonList("sim_original_bill_item")));
        return mergeBill;
    }

    public void createNegativeReturn(AbstractFormPlugin that, Map<String, Object> returnMap, List<DynamicObject> negativeBillList) {
        HashMap<String, Object> negativeBill = new HashMap<String, Object>(4);
        returnMap.put("negative", negativeBill);
        negativeBill.put("pageIndex", 1);
        negativeBill.put("pageSize", 10);
        negativeBill.put("total", negativeBillList.size());
        negativeBill.put("totalPage", (negativeBillList.size() - 1) / 10 + 1);
        List<Map<String, Object>> allNegativeMap = this.getNegativeList(that, negativeBillList);
        List negativeBillListMap = allNegativeMap.stream().limit(10L).collect(Collectors.toList());
        negativeBill.put("negativeBillList", negativeBillListMap);
        boolean isMatchBill = "sim_match_bill".equals(negativeBillList.get(0).getDataEntityType().getName());
        if (isMatchBill) {
            AllEBillTabCustomEvent.putPageCache(that, "matchbillamountlabel", negativeBillList.stream().map(bill -> bill.getBigDecimal("applyamount")).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, 4).toString());
        } else {
            BigDecimal totalAmount = negativeBillList.stream().map(bill -> bill.getBigDecimal("invoiceamount")).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, 4);
            AllEBillTabCustomEvent.putPageCache(that, "matchbillamountlabel", totalAmount.toString());
            AllEBillTabCustomEvent.putPageCache(that, "matchamountlabel", BigDecimal.ZERO.setScale(2, 4).toString());
            AllEBillTabCustomEvent.putPageCache(that, "unmatchamountlabel", totalAmount.toString());
        }
        this.setMatchBillTotalAmount(that);
        this.setMatchBillMatchAmount(that);
        this.setMatchBillUnMatchAmount(that);
        List matchIds = negativeBillList.stream().map(bill -> String.valueOf(bill.getLong("id"))).distinct().collect(Collectors.toList());
        AllEBillTabCustomEvent.putPageCache(that, "matchbillPks", String.join((CharSequence)",", matchIds));
        negativeBill.put("pks", matchIds);
    }

    private List<Map<String, Object>> getNegativeList(AbstractFormPlugin that, List<DynamicObject> negativeBillList) {
        ArrayList<Map<String, Object>> matchBillList = new ArrayList<Map<String, Object>>(negativeBillList.size());
        boolean isMatchBill = "sim_match_bill".equals(negativeBillList.get(0).getDataEntityType().getName());
        String operateBatch = AllEBillTabCustomEvent.getPageCacheVal(that, "operatebatch") + "red";
        HashMap<String, String> mergeCacheMap = new HashMap<String, String>(negativeBillList.size());
        for (DynamicObject mergeBill : negativeBillList) {
            DynamicObject matchBill;
            if (isMatchBill) {
                matchBill = mergeBill;
            } else {
                matchBill = MinusBillMatchHelper.createMatchBillByOriginalBill(mergeBill, operateBatch);
                this.autoSpecifyMatchBill(that, mergeBill, matchBill);
            }
            matchBillList.addAll(this.handleMatchBill(matchBill, true));
            mergeCacheMap.put(String.valueOf(matchBill.getLong("id")), AllEBillTabCustomEvent.encodeVal(SerializationUtils.toJsonString((Object)matchBill)));
        }
        that.getPageCache().put(mergeCacheMap);
        return matchBillList;
    }

    public void autoSpecifyMatchBill(AbstractFormPlugin that, DynamicObject mergeBill, DynamicObject matchBill) {
        this.autoSpecifyMatchBill(that, mergeBill, matchBill, true);
    }

    public void autoSpecifyMatchBill(AbstractFormPlugin that, DynamicObject mergeBill, DynamicObject matchBill, boolean submit) {
        String redConfirmBillNo = mergeBill.getString("infocode");
        if (StringUtils.isNotBlank((CharSequence)redConfirmBillNo)) {
            this.specifyRedConfirm(that, redConfirmBillNo, matchBill, submit);
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)mergeBill.getString("blueinvoiceno"))) {
            this.specifyOriInvoice(that, mergeBill, matchBill, submit);
        }
    }

    private void specifyRedConfirm(AbstractFormPlugin that, String redConfirmBillNo, DynamicObject matchBill, boolean submit) {
        BigDecimal redConfirmTotalAmount;
        BigDecimal applyTotalAmount;
        DynamicObject redConfirm = BusinessDataServiceHelper.loadSingle((String)"sim_red_confirm_bill", (String)String.join((CharSequence)",", "originalinvoicecode", "originalinvoiceno", "occupystatus", "invoiceamount", "totaltax", "totalamount"), (QFilter[])new QFilter("number", "=", (Object)redConfirmBillNo).toArray());
        if (redConfirm == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7:[%1$s]\uff0c\u5bf9\u5e94\u7684\u7ea2\u5b57\u786e\u8ba4\u5355\u4e0d\u5b58\u5728\uff0c\u7ea2\u5b57\u786e\u8ba4\u5355\u7f16\u53f7[%2$s]", (String)"AllEBillTabCustomEvent_4", (String)"imc-sim-service", (Object[])new Object[0]), matchBill.getString("billno"), redConfirmBillNo));
        }
        BigDecimal applyAmount = matchBill.getBigDecimal("applyamount").setScale(2, 4);
        BigDecimal redConfirmAmount = redConfirm.getBigDecimal("invoiceamount").setScale(2, 4);
        BigDecimal negativeBillDiff = SystemParameterHelper.getSimParameterBigDecimal((long)DynamicObjectUtil.getDynamicObjectLongValue((Object)matchBill.get("org")), (String)"negativebilldiff");
        if (MathUtils.isZero((BigDecimal)negativeBillDiff) && applyAmount.compareTo(redConfirmAmount) != 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\u548c\u7ea2\u5b57\u786e\u8ba4\u5355\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u5355\u636e\u7f16\u53f7:[%1$s]\uff0c\u5355\u636e\u91d1\u989d:[%2$s]\uff0c\u7ea2\u5b57\u786e\u8ba4\u5355\u7f16\u53f7[%3$s]\uff0c\u7ea2\u5b57\u786e\u8ba4\u5355\u91d1\u989d:[%4$s]", (String)"AllEBillTabCustomEvent_5", (String)"imc-sim-service", (Object[])new Object[0]), matchBill.getString("billno"), applyAmount, redConfirmBillNo, redConfirmAmount));
        }
        BigDecimal applyTax = matchBill.getBigDecimal("applytax").setScale(2, 4);
        BigDecimal redConfirmTax = redConfirm.getBigDecimal("totaltax").setScale(2, 4);
        if (MathUtils.isZero((BigDecimal)negativeBillDiff)) {
            if (applyTax.compareTo(redConfirmTax) != 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\u548c\u7ea2\u5b57\u786e\u8ba4\u5355\u7a0e\u989d\u4e0d\u4e00\u81f4\uff0c\u5355\u636e\u7f16\u53f7:[%1$s]\uff0c\u5355\u636e\u7a0e\u989d:[%2$s]\uff0c\u7ea2\u5b57\u786e\u8ba4\u5355\u7f16\u53f7[%3$s]\uff0c\u7ea2\u5b57\u786e\u8ba4\u5355\u7a0e\u989d:[%4$s]", (String)"AllEBillTabCustomEvent_6", (String)"imc-sim-service", (Object[])new Object[0]), matchBill.getString("billno"), applyTax, redConfirmBillNo, redConfirmTax));
            }
        } else {
            BigDecimal redConfirmDiff;
            BigDecimal configDiff = negativeBillDiff.abs();
            if (configDiff.subtract(redConfirmDiff = redConfirmTax.abs().subtract(applyTax.abs()).abs()).compareTo(BigDecimal.ZERO) < 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\uff0c\u5408\u8ba1\u7a0e\u989d\u4e0e\u7ea2\u5b57\u786e\u8ba4\u5355\u5b58\u5728\u7a0e\u989d\u5dee\u5f02\u4e3a\uff1a%2$s\uff0c\u5141\u8bb8\u5bb9\u5dee\u8303\u56f4\u00b1%3$s", (String)"AllEBillTabCustomEvent_17", (String)"imc-sim-service", (Object[])new Object[0]), matchBill.getString("billno"), redConfirmDiff, configDiff));
            }
        }
        if ((applyTotalAmount = matchBill.getBigDecimal("applytotalamount").setScale(2, 4)).compareTo(redConfirmTotalAmount = redConfirm.getBigDecimal("totalamount").setScale(2, 4)) != 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\u548c\u7ea2\u5b57\u786e\u8ba4\u5355\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u4e00\u81f4\uff0c\u5355\u636e\u7f16\u53f7:[%1$s]\uff0c\u5355\u636e\u4ef7\u7a0e\u5408\u8ba1:[%2$s]\uff0c\u7ea2\u5b57\u786e\u8ba4\u5355\u7f16\u53f7[%3$s]\uff0c\u7ea2\u5b57\u786e\u8ba4\u5355\u4ef7\u7a0e\u5408\u8ba1:[%4$s]", (String)"AllEBillTabCustomEvent_7", (String)"imc-sim-service", (Object[])new Object[0]), matchBill.getString("billno"), applyTotalAmount, redConfirmBillNo, redConfirmTotalAmount));
        }
        matchBill.set("matchtarget", (Object)"2");
        matchBill.set("matchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode());
        matchBill.set("matchtype", (Object)"0");
        matchBill.set("matchinvoicenum", (Object)1);
        DynamicObjectCollection items = matchBill.getDynamicObjectCollection("sim_original_bill_item");
        for (DynamicObject item : items) {
            item.set("itemmatchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode());
            DynamicObjectCollection redConfirmItems = item.getDynamicObjectCollection("confirmsubentryentity");
            DynamicObject redConfirmItem = redConfirmItems.addNew();
            redConfirmItem.set("confirminfocode", (Object)redConfirm.getString("number"));
            redConfirmItem.set("redconfirmpk", redConfirm.getPkValue());
            redConfirmItem.set("confirmoriinvoicecode", (Object)redConfirm.getString("originalinvoicecode"));
            redConfirmItem.set("confirmoriinvoiceno", (Object)redConfirm.getString("originalinvoiceno"));
        }
        matchBill.set("matchamount", (Object)redConfirm.getBigDecimal("invoiceamount"));
        matchBill.set("matchtax", (Object)redConfirm.getBigDecimal("totaltax"));
        matchBill.set("matchtotalamount", (Object)redConfirm.getBigDecimal("totalamount"));
        if (submit) {
            try (TXHandle tx = TX.required();){
                try {
                    this.saveSpecifyRedConfirm(that, matchBill, redConfirm);
                }
                catch (Throwable e) {
                    LOGGER.error("\u63d0\u4ea4\u5f00\u7968\u5f02\u5e38", e);
                    that.getView().showErrorNotification(e.getMessage());
                    tx.markRollback();
                }
            }
        }
    }

    private void saveSpecifyRedConfirm(AbstractFormPlugin that, DynamicObject matchBill, DynamicObject redConfirm) {
        redConfirm.set("occupystatus", (Object)"1");
        ImcSaveServiceHelper.update((DynamicObject)redConfirm);
        ImcSaveServiceHelper.save((DynamicObject)matchBill);
        List<String> saveIdList = AllEBillWorkbenchCacheHelper.getSavedMatchBillIdList(that);
        saveIdList.add(String.valueOf(matchBill.getLong("id")));
        AllEBillTabCustomEvent.putPageCache(that, "save_matchbillPks", saveIdList.stream().distinct().collect(Collectors.joining(",")));
        this.setBillComprehensiveStatusByManually(that, matchBill, true);
    }

    private void setBillComprehensiveStatusByManually(AbstractFormPlugin that, DynamicObject matchBill, boolean isRedConfirm) {
        List<String> matchBillIdList = AllEBillWorkbenchCacheHelper.getCacheMatchBillIdList(that);
        if (!matchBillIdList.contains(String.valueOf(matchBill.getLong("id")))) {
            matchBillIdList.add(String.valueOf(matchBill.getLong("id")));
            AllEBillTabCustomEvent.putPageCache(that, "matchbillPks", String.join((CharSequence)",", matchBillIdList));
        }
        List<BillRelationDTO> mergeRelations = AllEBillWorkbenchCacheHelper.getCacheMatchBillRelations(that);
        List<BillRelationDTO> relations = mergeRelations.stream().filter(relation -> relation.gettBillId().equals(matchBill.getLong("id"))).distinct().collect(Collectors.toList());
        this.saveRelationAndUpdateOriginalBill(matchBill, relations, isRedConfirm);
    }

    public void saveRelationAndUpdateOriginalBill(DynamicObject matchBill, List<BillRelationDTO> relations, boolean isRedConfirm) {
        DynamicObject[] originalBills;
        for (DynamicObject bill : originalBills = BusinessDataServiceHelper.load((Object[])relations.stream().map(BillRelationDTO::getsBillId).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill"))) {
            bill.set("operatebatch", (Object)matchBill.getString("matchbatch"));
            bill.set("matchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode());
            bill.set("comprehensivestatus", (Object)(isRedConfirm ? "41" : "33"));
            bill.set("confirmstate", (Object)"2");
            bill.set("confirmamount", bill.get("1".equals(bill.getString("hsbz")) ? "totalamount" : "invoiceamount"));
            DynamicObjectCollection items = bill.getDynamicObjectCollection("sim_original_bill_item");
            for (DynamicObject item : items) {
                item.set("remainvalidamount", (Object)BigDecimal.ZERO);
                item.set("remainvalidtax", (Object)BigDecimal.ZERO);
                item.set("remainvalidnum", (Object)BigDecimal.ZERO);
            }
        }
        ImcSaveServiceHelper.save((DynamicObject[])originalBills);
        new MinusBillMatchHelper().handleRelationZero(Collections.singletonList(matchBill), relations);
        ArrayList<DynamicObject> relationList = new ArrayList<DynamicObject>(relations.size());
        for (BillRelationDTO relation : relations) {
            relation.settBillNo(matchBill.getString("billno"));
            DynamicObject relationObj = BusinessDataServiceHelper.newDynamicObject((String)"sim_matchbill_relation");
            DynamicObjectUtil.bean2DynamicObject((Object)relation, (DynamicObject)relationObj);
            relationList.add(relationObj);
        }
        ImcSaveServiceHelper.save(relationList);
    }

    private void specifyOriInvoice(AbstractFormPlugin that, DynamicObject mergeBill, DynamicObject matchBill, boolean submit) {
        DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "invoicecode", "invoiceno", "occupystatus", "invoiceamount", "totaltax", "totalamount", "remainredamount", "canredtaxamount", "items.id", "items.seq", "items.itemremainredamount", "items.itemremainredtax", "items.goodsname", "items.specification", "items.unit"), (QFilter[])InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)mergeBill.getString("blueinvoicecode"), (String)mergeBill.getString("blueinvoiceno")).toArray());
        if (invoice == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7:[%1$s]\uff0c\u5bf9\u5e94\u7684\u539f\u84dd\u7968\u4e0d\u5b58\u5728\uff0c\u539f\u84dd\u7968\u4ee3\u7801[%2$s]\uff0c\u539f\u84dd\u7968\u53f7\u7801[%3$s]", (String)"AllEBillTabCustomEvent_8", (String)"imc-sim-service", (Object[])new Object[0]), matchBill.getString("billno"), mergeBill.getString("blueinvoicecode"), mergeBill.getString("blueinvoiceno")));
        }
        BigDecimal applyAmount = matchBill.getBigDecimal("applyamount").setScale(2, 4);
        BigDecimal invoiceAmount = invoice.getBigDecimal("invoiceamount").setScale(2, 4);
        BigDecimal remainRedAmount = invoice.getBigDecimal("remainredamount").setScale(2, 4);
        BigDecimal applyTax = matchBill.getBigDecimal("applytax").setScale(2, 4);
        BigDecimal totalTax = invoice.getBigDecimal("totaltax").setScale(2, 4);
        BigDecimal canRedTax = invoice.getBigDecimal("canredtaxamount").setScale(2, 4);
        if (applyAmount.abs().compareTo(remainRedAmount) > 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u5f00\u7968\u7533\u8bf7\u5355\u91d1\u989d\u5927\u4e8e\u84dd\u7968\u91d1\u989d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u84dd\u7968\uff0c\u5355\u636e\u7f16\u53f7:[%1$s]\uff0c\u5355\u636e\u91d1\u989d:[%2$s]\uff0c\u539f\u84dd\u7968\u4ee3\u7801:[%3$s]\uff0c\u539f\u84dd\u7968\u53f7\u7801:[%4$s]\uff0c\u539f\u84dd\u7968\u91d1\u989d:[%5$s]", (String)"AllEBillTabCustomEvent_9", (String)"imc-sim-service", (Object[])new Object[0]), matchBill.getString("billno"), applyAmount, mergeBill.getString("blueinvoicecode"), mergeBill.getString("blueinvoiceno"), remainRedAmount));
        }
        if (applyTax.abs().compareTo(canRedTax) > 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u5f00\u7968\u7533\u8bf7\u5355\u7a0e\u989d\u5927\u4e8e\u84dd\u7968\u7a0e\u989d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u84dd\u7968\uff0c\u5355\u636e\u7f16\u53f7:[%1$s]\uff0c\u5355\u636e\u7a0e\u989d:[%2$s]\uff0c\u539f\u84dd\u7968\u4ee3\u7801:[%3$s]\uff0c\u539f\u84dd\u7968\u53f7\u7801:[%4$s]\uff0c\u539f\u84dd\u7968\u7a0e\u989d:[%5$s]", (String)"AllEBillTabCustomEvent_10", (String)"imc-sim-service", (Object[])new Object[0]), matchBill.getString("billno"), applyTax, mergeBill.getString("blueinvoicecode"), mergeBill.getString("blueinvoiceno"), canRedTax));
        }
        if (RedConfirmBillRedReasonEnum.INVOICE_ERR.getBillCode().equals(mergeBill.getString("redreason"))) {
            if (applyAmount.abs().compareTo(invoiceAmount) != 0 || applyAmount.abs().compareTo(remainRedAmount) != 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6307\u5b9a\u84dd\u7968\u91d1\u989d\u4e0e\u5f00\u7968\u7533\u8bf7\u5355\u91d1\u989d\u4e0d\u5339\u914d\uff0c\u7ea2\u51b2\u539f\u56e0\u4e3a\u5f00\u7968\u6709\u8bef\u65f6\uff0c\u4ec5\u652f\u6301\u84dd\u7968\u5168\u989d\u7ea2\u51b2\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u84dd\u7968\uff0c\u5355\u636e\u7f16\u53f7:[%1$s]\uff0c\u5355\u636e\u91d1\u989d:[%2$s]\uff0c\u539f\u84dd\u7968\u4ee3\u7801:[%3$s]\uff0c\u539f\u84dd\u7968\u53f7\u7801:[%4$s]\uff0c\u539f\u84dd\u7968\u91d1\u989d:[%5$s]", (String)"AllEBillTabCustomEvent_11", (String)"imc-sim-service", (Object[])new Object[0]), matchBill.getString("billno"), applyAmount, mergeBill.getString("blueinvoicecode"), mergeBill.getString("blueinvoiceno"), applyAmount.compareTo(invoiceAmount) != 0 ? invoiceAmount : remainRedAmount));
            }
            if (applyTax.abs().compareTo(totalTax) != 0 || applyTax.abs().compareTo(canRedTax) != 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6307\u5b9a\u84dd\u7968\u7a0e\u989d\u4e0e\u5f00\u7968\u7533\u8bf7\u5355\u7a0e\u989d\u4e0d\u5339\u914d\uff0c\u7ea2\u51b2\u539f\u56e0\u4e3a\u5f00\u7968\u6709\u8bef\u65f6\uff0c\u4ec5\u652f\u6301\u84dd\u7968\u5168\u989d\u7ea2\u51b2\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u84dd\u7968\uff0c\u5355\u636e\u7f16\u53f7:[%1$s]\uff0c\u5355\u636e\u7a0e\u989d:[%2$s]\uff0c\u539f\u84dd\u7968\u4ee3\u7801:[%3$s]\uff0c\u539f\u84dd\u7968\u53f7\u7801:[%4$s]\uff0c\u539f\u84dd\u7968\u7a0e\u989d:[%5$s]", (String)"AllEBillTabCustomEvent_12", (String)"imc-sim-service", (Object[])new Object[0]), matchBill.getString("billno"), applyTax, mergeBill.getString("blueinvoicecode"), mergeBill.getString("blueinvoiceno"), applyTax.compareTo(totalTax) != 0 ? totalTax : canRedTax));
            }
        }
        DynamicObjectCollection matchBillItems = matchBill.getDynamicObjectCollection("sim_original_bill_item");
        if (applyAmount.abs().compareTo(invoiceAmount) == 0 && applyTax.abs().compareTo(totalTax) == 0) {
            matchBill.set("matchtarget", (Object)"3");
            for (DynamicObject item2 : matchBillItems) {
                item2.set("itemmatchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode());
                DynamicObjectCollection oriItems = item2.getDynamicObjectCollection("subentryentity");
                DynamicObject oriItem = oriItems.addNew();
                oriItem.set("oriinvoiceid", invoice.getPkValue());
                oriItem.set("oriitemseq", (Object)-1);
                oriItem.set("oriinvoicecode", (Object)invoice.getString("invoicecode"));
                oriItem.set("oriinvoiceno", (Object)invoice.getString("invoiceno"));
                oriItem.set("pushstatus", (Object)"-1");
                oriItem.set("oriitemamount", (Object)invoice.getBigDecimal("invoiceamount"));
                oriItem.set("oriitemtax", (Object)invoice.getBigDecimal("totaltax"));
            }
        } else {
            DynamicObjectCollection billItems = mergeBill.getDynamicObjectCollection("sim_original_bill_item");
            if (("".equals(mergeBill.getString("specialtype")) || "00".equals(mergeBill.getString("specialtype"))) && billItems.stream().allMatch(item -> item.getInt("originalseq") == 0)) {
                return;
            }
            if (billItems.stream().anyMatch(item -> item.getInt("originalseq") == 0)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u90e8\u5206\u7ea2\u51b2\u65f6\uff0c\u8bf7\u586b\u5199\u539f\u84dd\u7968\u5e8f\u53f7\uff0c\u539f\u84dd\u7968\u5e8f\u53f7\u4ece1\u5f00\u59cb\uff0c\u5355\u636e\u7f16\u53f7:[%1$s]\uff0c\u539f\u84dd\u7968\u4ee3\u7801:[%2$s]\uff0c\u539f\u84dd\u7968\u53f7\u7801:[%3$s]", (String)"AllEBillTabCustomEvent_14", (String)"imc-sim-service", (Object[])new Object[0]), matchBill.getString("billno"), mergeBill.getString("blueinvoicecode"), mergeBill.getString("blueinvoiceno")));
            }
            Set originSeqSet = billItems.stream().map(item -> item.getInt("originalseq")).collect(Collectors.toSet());
            if (billItems.size() != originSeqSet.size()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u539f\u84dd\u7968\u660e\u7ec6\u5e8f\u53f7\u91cd\u590d\uff0c\u5355\u636e\u7f16\u53f7:[%1$s]\uff0c\u539f\u84dd\u7968\u4ee3\u7801:[%2$s]\uff0c\u539f\u84dd\u7968\u53f7\u7801:[%3$s]", (String)"AllEBillTabCustomEvent_13", (String)"imc-sim-service", (Object[])new Object[0]), matchBill.getString("billno"), mergeBill.getString("blueinvoicecode"), mergeBill.getString("blueinvoiceno")));
            }
            Map<Integer, DynamicObject> invoiceDetailSeqMap = RedConfirmBillHelper.getInvoiceDetailSeqMap(invoice);
            for (int i = 0; i < matchBillItems.size(); ++i) {
                DynamicObject matchBillItem = (DynamicObject)matchBillItems.get(i);
                DynamicObject billItem = (DynamicObject)billItems.get(i);
                int originalSeq = billItem.getInt("originalseq");
                DynamicObject invoiceItem = invoiceDetailSeqMap.get(originalSeq);
                if (invoiceItem == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u539f\u84dd\u7968\u4e0d\u5b58\u5728\u5e8f\u53f7\u4e3a[%1$s]\u7684\u660e\u7ec6\u884c\uff0c\u5355\u636e\u7f16\u53f7:[%2$s]\uff0c\u539f\u84dd\u7968\u4ee3\u7801:[%3$s]\uff0c\u539f\u84dd\u7968\u53f7\u7801:[%4$s]", (String)"AllEBillTabCustomEvent_15", (String)"imc-sim-service", (Object[])new Object[0]), originalSeq, matchBill.getString("billno"), mergeBill.getString("blueinvoicecode"), mergeBill.getString("blueinvoiceno")));
                }
                if (matchBillItem.getBigDecimal("amount").compareTo(invoiceItem.getBigDecimal("itemremainredamount")) > 0 || matchBillItem.getBigDecimal("tax").abs().compareTo(invoiceItem.getBigDecimal("itemremainredtax")) > 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u884c[%1$s]\u7684\u7ea2\u51b2\u91d1\u989d\u5927\u4e8e\u539f\u84dd\u7968\u660e\u7ec6\u884c\u91d1\u989d\uff0c\u5355\u636e\u7f16\u53f7:[%2$s]\uff0c\u539f\u84dd\u7968\u4ee3\u7801:[%3$s]\uff0c\u539f\u84dd\u7968\u53f7\u7801:[%4$s]", (String)"AllEBillTabCustomEvent_16", (String)"imc-sim-service", (Object[])new Object[0]), originalSeq, matchBill.getString("billno"), mergeBill.getString("blueinvoicecode"), mergeBill.getString("blueinvoiceno")));
                }
                matchBillItem.set("itemmatchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode());
                DynamicObjectCollection oriItems = matchBillItem.getDynamicObjectCollection("subentryentity");
                DynamicObject oriItem = oriItems.addNew();
                oriItem.set("oriinvoiceid", invoice.getPkValue());
                oriItem.set("oriitemid", invoiceItem.get("id"));
                oriItem.set("oriitemseq", (Object)originalSeq);
                oriItem.set("oriitemgoodsname", invoiceItem.get("goodsname"));
                oriItem.set("oriitemspecification", invoiceItem.get("specification"));
                oriItem.set("oriitemunit", invoiceItem.get("unit"));
                oriItem.set("oriinvoicecode", mergeBill.get("blueinvoicecode"));
                oriItem.set("oriinvoiceno", mergeBill.get("blueinvoiceno"));
                oriItem.set("oriitemamount", (Object)matchBillItem.getBigDecimal("amount").negate());
                oriItem.set("oriitemtax", (Object)matchBillItem.getBigDecimal("tax").negate());
                oriItem.set("oriitemnum", (Object)matchBillItem.getBigDecimal("num").negate());
                oriItem.set("oritaxrate", matchBillItem.get("taxrate"));
                oriItem.set("oriitemunitprice", matchBillItem.get("unitprice"));
                oriItem.set("oriitemtaxunitprice", matchBillItem.get("taxunitprice"));
                oriItem.set("pushstatus", (Object)"-1");
            }
        }
        matchBill.set("matchtarget", (Object)"3");
        matchBill.set("matchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode());
        matchBill.set("matchtype", (Object)"0");
        matchBill.set("matchinvoicenum", (Object)1);
        matchBill.set("redreason", (Object)mergeBill.getString("redreason"));
        matchBill.set("matchamount", (Object)mergeBill.getBigDecimal("invoiceamount"));
        matchBill.set("matchtax", (Object)mergeBill.getBigDecimal("totaltax"));
        matchBill.set("matchtotalamount", (Object)mergeBill.getBigDecimal("totalamount"));
        if (submit) {
            try (TXHandle tx = TX.required();){
                try {
                    this.saveSpecifyOriInvoice(that, matchBill, invoice);
                }
                catch (Throwable e) {
                    LOGGER.error("\u63d0\u4ea4\u5f00\u7968\u5f02\u5e38", e);
                    that.getView().showErrorNotification(e.getMessage());
                    tx.markRollback();
                }
            }
        }
    }

    private void saveSpecifyOriInvoice(AbstractFormPlugin that, DynamicObject matchBill, DynamicObject invoice) {
        invoice.set("occupystatus", (Object)"1");
        ImcSaveServiceHelper.update((DynamicObject)invoice);
        WideInvoiceSevice.dealOneWideInvoiceOccupyStatus((DynamicObject)invoice);
        ImcSaveServiceHelper.save((DynamicObject)matchBill);
        List<String> saveIdList = AllEBillWorkbenchCacheHelper.getSavedMatchBillIdList(that);
        saveIdList.add(String.valueOf(matchBill.getLong("id")));
        AllEBillTabCustomEvent.putPageCache(that, "save_matchbillPks", saveIdList.stream().distinct().collect(Collectors.joining(",")));
        this.setBillComprehensiveStatusByManually(that, matchBill, false);
    }

    public List<Map<String, Object>> handleMatchBill(DynamicObject matchBill, boolean isSecondPage) {
        Map matchBillMap = DynamicObjectUtil.dynamicObjectToMap((DynamicObject)matchBill, (boolean)true);
        matchBillMap.remove("sim_original_bill_item");
        if (isSecondPage) {
            return this.secondPageReturn(matchBill, matchBillMap);
        }
        HashMap redConfirmItemListMap = new HashMap(4);
        DynamicObjectCollection items = matchBill.getDynamicObjectCollection("sim_original_bill_item");
        HashMap<String, DynamicObject> redConfirmMap = new HashMap<String, DynamicObject>(items.size());
        for (DynamicObject item : items) {
            HashMap<String, String> redconfirmMap;
            DynamicObjectCollection oriInvoiceItems = item.getDynamicObjectCollection("subentryentity");
            for (DynamicObject oriInvoiceItem : oriInvoiceItems) {
                String oriInvoiceCode = oriInvoiceItem.getString("oriinvoicecode");
                String oriInvoiceNo = oriInvoiceItem.getString("oriinvoiceno");
                if (redConfirmItemListMap.containsKey(oriInvoiceCode + "\u25cf\u25c6\u25a0" + oriInvoiceNo)) continue;
                redconfirmMap = new HashMap(4);
                matchBillMap.forEach(redconfirmMap::put);
                redconfirmMap.put("originalinvoicecode", oriInvoiceItem.getString("oriinvoicecode"));
                redconfirmMap.put("originalinvoiceno", oriInvoiceItem.getString("oriinvoiceno"));
                redconfirmMap.put("invoicetype", InvoiceType.getDescription((String)((String)redconfirmMap.get("invoicetype"))));
                String number = oriInvoiceItem.getString("infocode");
                redconfirmMap.put("number", number);
                Arrays.stream(RedConfirmBillRedReasonEnum.values()).filter(e -> e.getBillCode().equals(matchBill.getString("redreason"))).findFirst().ifPresent(k -> redconfirmMap.put("redreason", k.getDesc()));
                DynamicObject redConfirm = this.getRedConfirm(redConfirmMap, number);
                if (redConfirm != null) {
                    redconfirmMap.put("invoiceamount", redConfirm.getString("invoiceamount"));
                    redconfirmMap.put("confirmstatus", redConfirm.getString("confirmstatus"));
                    redconfirmMap.put("enteridentity", redConfirm.getString("enteridentity"));
                    redconfirmMap.put("failreason", redConfirm.getString("failreason"));
                }
                redConfirmItemListMap.put(oriInvoiceCode + "\u25cf\u25c6\u25a0" + oriInvoiceNo, redconfirmMap);
            }
            DynamicObjectCollection matchConfirmItems = item.getDynamicObjectCollection("confirmsubentryentity");
            for (DynamicObject matchConfirmItem : matchConfirmItems) {
                String number = matchConfirmItem.getString("confirminfocode");
                if (redConfirmItemListMap.containsKey(number)) continue;
                redconfirmMap = new HashMap<String, String>(4);
                matchBillMap.forEach(redconfirmMap::put);
                redconfirmMap.put("invoicetype", InvoiceType.getDescription((String)((String)redconfirmMap.get("invoicetype"))));
                redconfirmMap.put("number", number);
                DynamicObject redConfirm = this.getRedConfirm(redConfirmMap, number);
                if (redConfirm != null) {
                    redconfirmMap.put("originalinvoicecode", redConfirm.getString("originalinvoicecode"));
                    redconfirmMap.put("originalinvoiceno", redConfirm.getString("originalinvoiceno"));
                    redconfirmMap.put("redreason", RedReasonEnum.getDescriptionByEleTypeCode((String)redConfirm.getString("redreason")));
                    redconfirmMap.put("invoiceamount", redConfirm.getString("invoiceamount"));
                    redconfirmMap.put("confirmstatus", redConfirm.getString("confirmstatus"));
                    redconfirmMap.put("enteridentity", redConfirm.getString("enteridentity"));
                    redconfirmMap.put("failreason", redConfirm.getString("failreason"));
                }
                redConfirmItemListMap.put(number, redconfirmMap);
            }
        }
        return new ArrayList<Map<String, Object>>(redConfirmItemListMap.values());
    }

    private List<Map<String, Object>> secondPageReturn(DynamicObject matchBill, Map<String, Object> matchBillMap) {
        String invoiceNo;
        String invoiceCode;
        DynamicObjectCollection oriInvoiceItems;
        matchBillMap.put("matchpercent", matchBill.getBigDecimal("matchamount").abs().multiply(new BigDecimal("100")).divide(matchBill.getBigDecimal("applyamount").abs(), 2, 1).toString() + "%");
        matchBillMap.put("unmatchamount", matchBill.getBigDecimal("applyamount").add(matchBill.getBigDecimal("matchamount").abs()).setScale(2, 4).toString());
        ArrayList invoiceOrRedConfirmList = new ArrayList(4);
        DynamicObjectCollection items = matchBill.getDynamicObjectCollection("sim_original_bill_item");
        HashMap<String, DynamicObject> blueInvoiceMap = new HashMap<String, DynamicObject>(items.size());
        HashMap<String, DynamicObject> redConfirmMap = new HashMap<String, DynamicObject>(items.size());
        String matchTarget = matchBill.getString("matchtarget");
        HashMap<String, BigDecimal> invoice2AmountMap = new HashMap<String, BigDecimal>(4);
        if ("0".equals(matchTarget) || "3".equals(matchTarget)) {
            for (DynamicObject item : items) {
                oriInvoiceItems = item.getDynamicObjectCollection("subentryentity");
                for (DynamicObject oriInvoiceItem : oriInvoiceItems) {
                    invoiceCode = oriInvoiceItem.getString("oriinvoicecode");
                    invoiceNo = oriInvoiceItem.getString("oriinvoiceno");
                    BigDecimal amount = (BigDecimal)invoice2AmountMap.get(invoiceCode + "\u25cf\u25c6\u25a0" + invoiceNo);
                    if (amount == null) {
                        invoice2AmountMap.put(invoiceCode + "\u25cf\u25c6\u25a0" + invoiceNo, oriInvoiceItem.getBigDecimal("oriitemamount"));
                        continue;
                    }
                    if (!"0".equals(matchTarget)) continue;
                    invoice2AmountMap.put(invoiceCode + "\u25cf\u25c6\u25a0" + invoiceNo, amount.add(oriInvoiceItem.getBigDecimal("oriitemamount")));
                }
            }
        }
        for (DynamicObject item : items) {
            oriInvoiceItems = item.getDynamicObjectCollection("subentryentity");
            for (DynamicObject oriInvoiceItem : oriInvoiceItems) {
                DynamicObject redConfirm;
                invoiceCode = oriInvoiceItem.getString("oriinvoicecode");
                invoiceNo = oriInvoiceItem.getString("oriinvoiceno");
                if (blueInvoiceMap.containsKey(invoiceCode + "\u25cf\u25c6\u25a0" + invoiceNo)) continue;
                HashMap<String, Object> oriInvoiceItemMap = new HashMap<String, Object>(4);
                oriInvoiceItemMap.put("originalinvoicecode", invoiceCode);
                oriInvoiceItemMap.put("originalinvoiceno", invoiceNo);
                oriInvoiceItemMap.put("number", oriInvoiceItem.getString("infocode"));
                oriInvoiceItemMap.put("buyername", matchBill.getString("buyername"));
                DynamicObject invoice = this.getInvoice(invoiceCode, invoiceNo, blueInvoiceMap);
                if (invoice != null) {
                    BigDecimal matchAmount = (BigDecimal)invoice2AmountMap.get(invoiceCode + "\u25cf\u25c6\u25a0" + invoiceNo);
                    matchAmount = matchAmount == null ? BigDecimal.ZERO : matchAmount;
                    oriInvoiceItemMap.put("oriinvoicetype", InvoiceType.getDescription((String)invoice.getString("invoicetype")));
                    oriInvoiceItemMap.put("matchamount", matchAmount);
                    oriInvoiceItemMap.put("totalamount", "");
                    oriInvoiceItemMap.put("isallred", invoice.getBigDecimal("invoiceamount").compareTo(matchAmount) == 0);
                }
                if ((redConfirm = this.getRedConfirm(redConfirmMap, oriInvoiceItem.getString("infocode"))) != null) {
                    oriInvoiceItemMap.put("confirmstatus", redConfirm.getString("confirmstatus"));
                }
                invoiceOrRedConfirmList.add(oriInvoiceItemMap);
            }
            DynamicObjectCollection matchConfirmItems = item.getDynamicObjectCollection("confirmsubentryentity");
            for (DynamicObject matchConfirmItem : matchConfirmItems) {
                String infoCode = matchConfirmItem.getString("confirminfocode");
                if (redConfirmMap.containsKey(infoCode)) continue;
                HashMap<String, Object> matchConfirmItemMap = new HashMap<String, Object>(4);
                String invoiceCode2 = matchConfirmItem.getString("confirmoriinvoicecode");
                String invoiceNo2 = matchConfirmItem.getString("confirmoriinvoiceno");
                matchConfirmItemMap.put("originalinvoicecode", invoiceCode2);
                matchConfirmItemMap.put("originalinvoiceno", invoiceNo2);
                matchConfirmItemMap.put("number", matchConfirmItem.getString("confirminfocode"));
                matchConfirmItemMap.put("buyername", matchBill.getString("buyername"));
                DynamicObject redConfirm = this.getRedConfirm(redConfirmMap, matchConfirmItem.getString("confirminfocode"));
                if (redConfirm != null) {
                    matchConfirmItemMap.put("confirmstatus", redConfirm.getString("confirmstatus"));
                    matchConfirmItemMap.put("matchamount", redConfirm.getBigDecimal("invoiceamount").setScale(2, 4));
                    boolean isAllRed = redConfirm.getBigDecimal("invoiceamount").abs().compareTo(redConfirm.getBigDecimal("originalinvoiceamount")) == 0;
                    matchConfirmItemMap.put("isallred", isAllRed);
                }
                redConfirmMap.put(infoCode, redConfirm);
                DynamicObject invoice = this.getInvoice(invoiceCode2, invoiceNo2, blueInvoiceMap);
                if (invoice != null) {
                    matchConfirmItemMap.put("oriinvoicetype", InvoiceType.getDescription((String)invoice.getString("invoicetype")));
                    matchConfirmItemMap.put("totalamount", "");
                }
                invoiceOrRedConfirmList.add(matchConfirmItemMap);
            }
        }
        matchBillMap.put("invoiceOrRedConfirm", invoiceOrRedConfirmList);
        return Collections.singletonList(matchBillMap);
    }

    private DynamicObject getInvoice(String invoiceCode, String invoiceNo, Map<String, DynamicObject> blueInvoiccMap) {
        DynamicObject invoice = null;
        if (StringUtils.isNotBlank((CharSequence)invoiceCode) || StringUtils.isNotBlank((CharSequence)invoiceNo)) {
            invoice = blueInvoiccMap.get(invoiceCode + "\u25cf\u25c6\u25a0" + invoiceNo);
            if (invoice == null) {
                invoice = QueryServiceHelper.queryOne((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "invoicetype", "remainredamount", "invoicestatus", "invoiceamount"), (QFilter[])InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)invoiceCode, (String)invoiceNo).toArray());
            }
            blueInvoiccMap.put(invoiceCode + "\u25cf\u25c6\u25a0" + invoiceNo, invoice);
        }
        return invoice;
    }

    private DynamicObject getRedConfirm(Map<String, DynamicObject> redConfirmMap, String number) {
        DynamicObject redConfirm = null;
        if (StringUtils.isNotBlank((CharSequence)number)) {
            redConfirm = redConfirmMap.get(number);
            if (redConfirm == null) {
                redConfirm = QueryServiceHelper.queryOne((String)"sim_red_confirm_bill", (String)String.join((CharSequence)",", "redreason", "invoiceamount", "originalinvoiceamount", "confirmstatus", "enteridentity", "failreason", "originalinvoicecode", "originalinvoiceno"), (QFilter[])new QFilter("number", "=", (Object)number).toArray());
            }
            redConfirmMap.put(number, redConfirm);
        }
        return redConfirm;
    }

    private void removeBill(AbstractFormPlugin that, String param) {
        try {
            JSONObject json = JSONObject.parseObject((String)param);
            List<String> cacheBillIdList = AllEBillWorkbenchCacheHelper.getCacheBillIdList(that);
            if (cacheBillIdList.size() == 1) {
                that.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u4fdd\u7559\u4e00\u4e2a\u5f00\u7968\u7533\u8bf7\u5355\uff01", (String)"AllEBillTabCustomEvent_2", (String)"imc-sim-service", (Object[])new Object[0]));
                AllEBillTabCustomEvent.updateCustomControlError(that, null, "bill/removeBill");
                return;
            }
            this.removeBillCalcAmount(that, json, cacheBillIdList);
            AllEBillTabCustomEvent.updateCustomControl(that, null, "bill/removeBill");
        }
        catch (Exception e) {
            AllEBillTabCustomEvent.updateCustomControlError(that, null, "bill/removeBill");
        }
    }

    private void removeBillCalcAmount(AbstractFormPlugin that, JSONObject json, List<String> cacheBillIdList) {
        AllEBillTabCustomEvent.putPageCache(that, "pks", cacheBillIdList.stream().filter(pk -> !pk.equals(json.getString("id"))).collect(Collectors.joining(",")));
        this.setBillCountLabel(that);
        BigDecimal totalAmount = new BigDecimal(AllEBillTabCustomEvent.getPageCacheVal(that, "totalamountlabel")).subtract(json.getBigDecimal("totalamount")).setScale(2, 4);
        AllEBillTabCustomEvent.putPageCache(that, "totalamountlabel", totalAmount.toString());
        this.setTotalAmountLabel(that);
        int itemCount = json.getInteger("itemcount");
        AllEBillTabCustomEvent.putPageCache(that, "itemcountlabel", String.valueOf(Integer.parseInt(AllEBillTabCustomEvent.getPageCacheVal(that, "itemcountlabel")) - itemCount));
        this.setItemCountLabel(that);
    }

    private void queryBill(AbstractFormPlugin that, String param) {
        JSONObject json = JSONObject.parseObject((String)param);
        List pkList = AllEBillWorkbenchCacheHelper.getCacheBillIdList(that).stream().map(Long::parseLong).collect(Collectors.toList());
        List<Long> subIdList = this.getSubIdList(pkList, json);
        HashMap<String, Object> map = new HashMap<String, Object>((Map<String, Object>)json);
        try (DataSet ds = this.queryBillDataSet(json, subIdList);){
            DynamicObjectCollection bills = ORMUtil.toDynamicObjectCollection((DataSet)ds, (String)"sim_original_bill");
            map.put("total", pkList.size());
            map.put("totalPage", (pkList.size() - 1) / json.getInteger("pageSize") + 1);
            map.put("bills", DynamicObjectUtil.dynamicObjects2ListMap((List)bills, (boolean)true));
            AllEBillTabCustomEvent.updateCustomControl(that, map, "bill/queryBill");
        }
        catch (Exception e) {
            that.getView().showErrorNotification(e.getMessage());
            AllEBillTabCustomEvent.updateCustomControlError(that, map, "bill/queryBill");
        }
    }

    private DataSet queryBillDataSet(JSONObject json, List<Long> subIdList) {
        String buyerName;
        ORM orm = ORM.create();
        QFilter qFilter = new QFilter("id", "in", subIdList);
        String billNo = json.getString("billno");
        if (StringUtils.isNotBlank((CharSequence)billNo)) {
            qFilter.and("billno", "like", (Object)("%" + billNo + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)(buyerName = json.getString("buyername")))) {
            qFilter.and("buyername", "like", (Object)("%" + buyerName + "%"));
        }
        return orm.queryDataSet("AllEBillTabCustomEvent.queryBill", "sim_original_bill", String.join((CharSequence)",", FIRST_PAGE_SELECT_FIELD, "mergerule.name as mergerulename"), qFilter.toArray(), "originbillseq desc");
    }

    private void openOriginalBill(AbstractFormPlugin that, String pk) {
        if (StringUtils.isBlank((CharSequence)pk)) {
            that.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u65e0\u6b64\u5355\u636e\u3002", (String)"AllEBillTabCustomEvent_3", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        if (!QueryServiceHelper.exists((String)"sim_original_bill", (Object)Long.valueOf(pk))) {
            that.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u65e0\u6b64\u5355\u636e\u3002", (String)"AllEBillTabCustomEvent_3", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        BillShowParameter listParam = new BillShowParameter();
        listParam.setPkId((Object)pk);
        listParam.setStatus(OperationStatus.VIEW);
        listParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listParam.setFormId("sim_original_bill");
        listParam.setCustomParam("source", (Object)"workbench");
        that.getView().showForm((FormShowParameter)listParam);
    }
}

