/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.workbench.event;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.imc.bdm.common.dto.BillRelationDTO;
import kd.imc.bdm.common.dto.merge.MergeRemoveBillDTO;
import kd.imc.bdm.common.dto.merge.MergeResponseDTO;
import kd.imc.bdm.common.dto.split.LimitAmountsDTO;
import kd.imc.bdm.common.dto.split.SplitRequestDTO;
import kd.imc.bdm.common.dto.split.SplitResponseDTO;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.SplitRuleHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.common.model.invoice.InvoiceSpecialType;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.common.utils.ZipUtil;
import kd.imc.sim.formplugin.bill.originalbill.workbench.pluginworkutils.BillProcessTabUtil;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillSplitHelper;
import kd.imc.sim.formplugin.bill.splitMerge.split.impl.SplitByRuleServiceImpl;
import org.apache.commons.collections.CollectionUtils;

public abstract class AbstractBillWorkbenchCustomEvent {
    private static Log LOGGER = LogFactory.getLog(AbstractBillWorkbenchCustomEvent.class);
    public static final String CURRENT_ORG = "currentOrg";
    public static final String PAGE_AUTO_AMOUNT_SPLIT = "sim_split_amount_auto";
    public static final String PAGE_CUSTOM_AMOUNT_SPLIT = "sim_bill_split_by_amount";
    protected static final String FIRST_PAGE_SELECT_FIELD = String.join((CharSequence)",", "id", "billno", "buyername", "billdate", "invoicetype", "billproperties", "totalamount", "surplusamount", "surplustax", "orgid", "salertaxno", "jqbh", "terminalno", "iselepaper", "itemcount");
    protected static final Set<String> MERGE_BILL_REMOVE_FIELD = new ImmutableSet.Builder().add((Object[])new String[]{"currency", "exchangerate"}).add((Object[])new String[]{"billtype", "biztype", "redflushblue", "originbillseq", "oribuyername", "oribuyerbank", "oribuyeraddr", "goodstype"}).add((Object[])new String[]{"sim_original_bill_item.goodsid", "sim_original_bill_item.materialtype", "sim_original_bill_item.issuedamount", "sim_original_bill_item.issuedtax", "sim_original_bill_item.issuedtotaltaxamounts", "sim_original_bill_item.origoodsname"}).add((Object[])new String[]{"sim_original_bill_item.orispecification", "sim_original_bill_item.oriunit", "sim_original_bill_item.oriunitprice", "sim_original_bill_item.discountrates", "sim_original_bill_item.orinum"}).add((Object[])new String[]{"sim_original_bill_item.deductedpk", "sim_original_bill_item.taxratecodeid", "sim_original_bill_item.combineamount", "sim_original_bill_item.amountdeviation", "sim_original_bill_item.numdeviation"}).add((Object[])new String[]{"sim_original_bill_item.expenseitem", "sim_original_bill_item.materielfield", "sim_original_bill_item.sourceinfocode", "sim_original_bill_item.sourceinfodetailid", "sim_original_bill_item.benchmark", "sim_original_bill_item.oritaxamount"}).add((Object[])new String[]{"sim_original_bill_item.combinenum", "sim_original_bill_item.fromprice", "sim_original_bill_item.fromamount", "sim_original_bill_item.fromissuedamount", "sim_original_bill_item.fromtax", "sim_original_bill_item.fromissuedtax"}).add((Object[])new String[]{"sim_original_bill_item.fromdiscountamount", "sim_original_bill_item.fromtaxdeviation", "sim_original_bill_item.fromtaxprice", "sim_original_bill_item.fromtaxamount", "sim_original_bill_item.fromissuedtaxamount", "sim_original_bill_item.combinelocalamount"}).add((Object[])new String[]{"sim_original_bill_item.modelnumrate", "sim_original_bill_item.oriissuednum", "sim_original_bill_item.issuednum", "sim_original_bill_item.blueinvoiceitemid", "sim_original_bill_item.orifromtaxamount", "sim_original_bill_item.pushnum"}).add((Object[])new String[]{"sim_original_bill_item.unpushnum", "sim_original_bill_item.pushlocalamt", "sim_original_bill_item.unpushlocalamt", "sim_original_bill_item.corebilltype", "sim_original_bill_item.corebillno", "sim_original_bill_item.corebillid", "sim_original_bill_item.unitfield_id"}).add((Object[])new String[]{"sim_original_bill_item.corebillentryid", "sim_original_bill_item.conbillentity", "sim_original_bill_item.conbillnumber", "sim_original_bill_item.conbillrownum", "sim_original_bill_item.conbillid", "sim_original_bill_item.conbillentryid"}).add((Object[])new String[]{"sim_original_bill_item.discountmode", "sim_original_bill_item.corebillentryseq", "sim_original_bill_item.unitfield", "sim_original_bill_item.unpushamt", "sim_original_bill_item.pushamt", "sim_original_bill_item.srcentryid", "sim_original_bill_item.conbillentity_id"}).add((Object[])new String[]{"sim_original_bill_item.sim_original_bill_item_lk", "sim_original_bill_item.goodsid_id", "sim_original_bill_item.materialtype_id", "sim_original_bill_item.taxratecodeid_id", "sim_original_bill_item.expenseitem_id", "sim_original_bill_item.materielfield_id"}).add((Object[])new String[]{"materialtypebase", "materialtypebase_id", "billtypebase", "billtypebase_id"}).add((Object[])new String[]{"confirmamount", "mainissuedamount", "billstatus", "auditor", "auditor_id", "auditdate", "auditsuggestion", "validstate"}).add((Object[])new String[]{"invoicedamount", "invoicedtax", "invoicedtotalamount", "invoicecode", "invoiceno", "issuetime", "invoicestatus", "abolishreason"}).add((Object[])new String[]{"salesorg", "salesorgbase_id", "settlementorg", "settlementorgbase_id", "capitalorg", "capitalorgbase_id", "customname", "creator", "creator_id"}).add((Object[])new String[]{"billtaxrate", "botptype", "botpparamconfig", "taxorg", "taxorg_id", "buyerpersonname", "priority", "createdate"}).add((Object[])new String[]{"foreigninvoiceamount", "foreignissuedamount", "foreigntax", "foreigntotalamount", "foreignissuedtotalamount", "foreignissuedtax", "foreigntaxdifference"}).add((Object[])new String[]{"fromcurr", "fromcurr_id", "tocurr", "tocurr_id", "exratetable", "quotation", "exrate", "exratetable_id"}).add((Object[])new String[]{"taxadjust", "plantaxamount", "planamount", "producttype", "pushbillname", "editable", "closestatus"}).add((Object[])new String[]{"pushlocalamount", "unpushlocalamount", "pushamount", "unpushamount", "mbenchemark"}).add((Object[])new String[]{"billhead_lk.id", "billhead_lk.seq", "billhead_lk.billhead_lk_stableid", "billhead_lk.billhead_lk_sbillid", "billhead_lk.billhead_lk_sid"}).add((Object[])new String[]{"orgid_id", "operator_id", "simpleaddress_id"}).build();

    public static String getMergeBillQueryField() {
        ArrayList<String> fieldList = new ArrayList<String>(Splitter.on((String)",").splitToList((CharSequence)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_original_bill", (boolean)true)));
        fieldList.removeAll(MERGE_BILL_REMOVE_FIELD);
        String missingField = ImcConfigUtil.getValue((String)"bdm_merge_bill", (String)"missing_field");
        if (StringUtils.isNotBlank((CharSequence)missingField)) {
            fieldList.addAll(Splitter.on((String)",").splitToList((CharSequence)missingField));
        }
        String billDetailFields = ImcConfigUtil.getValue((String)CacheKeyEnum.BDM_MERGE_BILL_DETAIL_FIELD.getConfigType(), (String)CacheKeyEnum.BDM_MERGE_BILL_DETAIL_FIELD.getConfigKey());
        String billHeadFields = ImcConfigUtil.getValue((String)CacheKeyEnum.BDM_MERGE_BILL_HEAD_FIELD.getConfigType(), (String)CacheKeyEnum.BDM_MERGE_BILL_HEAD_FIELD.getConfigKey());
        if (StringUtils.isNotBlank((CharSequence)billHeadFields)) {
            String[] headFields;
            for (String headField : headFields = billHeadFields.split(",")) {
                if (fieldList.contains(headField)) continue;
                fieldList.add(headField);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)billDetailFields)) {
            String[] detailFields;
            for (String detailField : detailFields = billDetailFields.split(",")) {
                String itemKey = "sim_original_bill_item." + detailField;
                if (fieldList.contains(itemKey)) continue;
                fieldList.add(itemKey);
            }
        }
        return String.join((CharSequence)",", fieldList);
    }

    public abstract void customEvent(AbstractFormPlugin var1, CustomEventArgs var2);

    public static void updateCustomControl(AbstractFormPlugin that, Map<String, Object> showDataMap, String eventKey) {
        ViewUtil.bindDataToHtml((AbstractFormPlugin)that, AbstractBillWorkbenchCustomEvent.createReturnMap(eventKey, showDataMap, true), (String)AbstractBillWorkbenchCustomEvent.getUserControlName(that));
    }

    public static void updateCustomControlError(AbstractFormPlugin that, Map<String, Object> showDataMap, String eventKey) {
        ViewUtil.bindDataToHtml((AbstractFormPlugin)that, AbstractBillWorkbenchCustomEvent.createReturnMap(eventKey, showDataMap, false), (String)AbstractBillWorkbenchCustomEvent.getUserControlName(that));
    }

    private static Map<String, Object> createReturnMap(String eventKey, Map<String, Object> showDataMap, boolean isSuccess) {
        if (showDataMap == null) {
            showDataMap = new HashMap<String, Object>(4);
        }
        showDataMap.put("eventKey", eventKey);
        showDataMap.put("errCode", isSuccess ? ErrorType.SUCCESS.getCode() : ErrorType.FAIL.getCode());
        return showDataMap;
    }

    public static void putPageCache(AbstractFormPlugin that, String key, String value) {
        if (that == null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)value)) {
            that.getPageCache().put(key, value);
            return;
        }
        that.getPageCache().put(key, AbstractBillWorkbenchCustomEvent.encodeVal(value));
    }

    protected static String encodeVal(String val) {
        return Base64.getEncoder().encodeToString(ZipUtil.gzipStr((String)val, (String)StandardCharsets.UTF_8.name()));
    }

    public static String getPageCacheVal(AbstractFormPlugin that, String key) {
        if (that == null) {
            return "";
        }
        String cacheVal = that.getPageCache().get(key);
        if (StringUtils.isBlank((CharSequence)cacheVal)) {
            return cacheVal;
        }
        return AbstractBillWorkbenchCustomEvent.decodeVal(that.getPageCache().get(key));
    }

    protected static String decodeVal(String val) {
        byte[] tempContent = Base64.getDecoder().decode(val);
        return ZipUtil.gunzipStr((byte[])tempContent, (String)StandardCharsets.UTF_8.name());
    }

    private static String getUserControlName(AbstractFormPlugin that) {
        String pageSource = AbstractBillWorkbenchCustomEvent.getPageCacheVal(that, "workbenchtype");
        if (StringUtils.isBlank((CharSequence)pageSource)) {
            return "workbench";
        }
        return pageSource;
    }

    public static void handleExcepiton(AbstractFormPlugin that, Exception e) {
        if (e instanceof MsgException) {
            that.getView().showErrorNotification(((MsgException)((Object)e)).getErrorMsg());
        } else {
            that.getView().showErrorNotification(e.getMessage());
        }
    }

    protected boolean checkWorkbenchCache(Object pk) {
        String userId = CacheHelper.get((String)(pk + "workbench"));
        if (StringUtils.isBlank((CharSequence)userId)) {
            return false;
        }
        return !userId.equals(RequestContext.get().getUserId());
    }

    protected void clearWorkbenchCache(String param) {
        JSONObject json = JSONObject.parseObject((String)param);
        List pks = json.getJSONArray("pks").toJavaList(String.class);
        BillHelper.clearWorkbench((Object[])pks.toArray());
    }

    protected void closeWorkBench(AbstractFormPlugin that, String param) {
        JSONObject json = JSONObject.parseObject((String)param);
        Integer curIndex = json.getInteger("curIndex");
        if (curIndex != null && curIndex == 3) {
            that.getView().returnDataToParent((Object)"refresh");
        }
        AbstractBillWorkbenchCustomEvent.putPageCache(that, "tempCacheInfoCode", "");
        if (curIndex != null) {
            switch (curIndex) {
                case 0: {
                    BillProcessTabUtil.confrimCheck(that, ResManager.loadKDString((String)"\u662f\u5426\u9000\u51fa\u5de5\u4f5c\u53f0\uff1f", (String)"AbstractBillWorkbenchCustomEvent_0", (String)"imc-sim-service", (Object[])new Object[0]), ResManager.loadKDString((String)"\u786e\u8ba4\u9000\u51fa", (String)"AbstractBillWorkbenchCustomEvent_1", (String)"imc-sim-service", (Object[])new Object[0]), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"AbstractBillWorkbenchCustomEvent_2", (String)"imc-sim-service", (Object[])new Object[0]), "workbrach_checkout");
                    break;
                }
                case 1: 
                case 2: {
                    BillProcessTabUtil.confrimCheck(that, ResManager.loadKDString((String)"\u9000\u51fa\u5de5\u4f5c\u53f0\u540e\uff0c\u6570\u636e\u4e0d\u88ab\u4fdd\u5b58\uff0c\u662f\u5426\u9000\u51fa\uff1f", (String)"AbstractBillWorkbenchCustomEvent_3", (String)"imc-sim-service", (Object[])new Object[0]), ResManager.loadKDString((String)"\u786e\u8ba4\u9000\u51fa", (String)"AbstractBillWorkbenchCustomEvent_1", (String)"imc-sim-service", (Object[])new Object[0]), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"AbstractBillWorkbenchCustomEvent_2", (String)"imc-sim-service", (Object[])new Object[0]), "workbrach_checkout");
                    break;
                }
                case 3: {
                    if (json.getBoolean("resultIsComplete").booleanValue()) {
                        that.getView().returnDataToParent((Object)"refresh");
                        that.getView().close();
                        break;
                    }
                    BillProcessTabUtil.confrimCheck(that, String.format(ResManager.loadKDString((String)"\u9000\u51fa\u540e\u60a8\u53ef\u4ee5\u5728\u5bf9\u5e94\u9875\u9762\u67e5\u770b\u6570\u636e\u3002%1$s1\u3001\u84dd\u5b57\u53d1\u7968\u3001\u7ea2\u5b57\u666e\u7968\u3001\u7ea2\u5b57\u4e13\u7968\uff08\u5e26\u4fe1\u606f\u8868\u7f16\u53f7\uff09\u53ef\u4ee5\u5728 \u5f85\u5f00\u53d1\u7968 -> \u5f85\u5f00\u53d1\u7968 \u4e2d\u53d1\u8d77\u5f00\u7968\uff1b%2$s2\u3001\u7533\u8bf7\u7ea2\u5b57\u4fe1\u606f\u8868:\u5728 \u53d1\u7968\u7ea2\u51b2 -> \u7ea2\u5b57\u4fe1\u606f\u8868 \u4e2d\u67e5\u770b\uff1b", (String)"AbstractBillWorkbenchCustomEvent_4", (String)"imc-sim-service", (Object[])new Object[0]), "\r\n\r\n", "\r\n"), ResManager.loadKDString((String)"\u786e\u8ba4\u9000\u51fa", (String)"AbstractBillWorkbenchCustomEvent_1", (String)"imc-sim-service", (Object[])new Object[0]), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"AbstractBillWorkbenchCustomEvent_2", (String)"imc-sim-service", (Object[])new Object[0]), "workbrach_checkout");
                }
            }
        }
    }

    public static Map<String, Object> splitCacheBill(AbstractFormPlugin that, MergeResponseDTO mergeResponse, String jqbh, SplitRequestDTO splitRequest) {
        LimitAmountsDTO limitAmountsDTO;
        HashMap<String, Object> returnMap = new HashMap<String, Object>(4);
        long currentOrgId = Long.parseLong(AbstractBillWorkbenchCustomEvent.getPageCacheVal(that, CURRENT_ORG));
        if (InvoiceUtils.isAllEInvoice((Object)((DynamicObject)mergeResponse.getBills().get(0)).getString("invoicetype")) || AllEleAuthHelper.isElePaper((Object)((DynamicObject)mergeResponse.getBills().get(0)).getString("iselepaper"))) {
            limitAmountsDTO = new LimitAmountsDTO(true);
        } else {
            DynamicObject devObj = EquipmentUtil.getDevByCode((Long)currentOrgId, (String)jqbh);
            limitAmountsDTO = new LimitAmountsDTO(devObj);
        }
        HashMap<String, List> invoiceMap = new HashMap<String, List>(4);
        HashMap<String, List<Map<String, Object>>> invoiceRelationMap = new HashMap<String, List<Map<String, Object>>>(4);
        HashMap<String, JSONObject> taxDeviationBillMap = new HashMap<String, JSONObject>(4);
        if (splitRequest == null) {
            splitRequest = new SplitRequestDTO();
            splitRequest.setNum(Integer.valueOf(1));
        }
        HashMap<String, DynamicObject> ruleMap = new HashMap<String, DynamicObject>(10);
        HashMap<String, String> mergeCacheMap = new HashMap<String, String>(mergeResponse.getBills().size());
        for (DynamicObject mergeBill : mergeResponse.getBills()) {
            JSONObject taxDeviationBill;
            BigDecimal totalamount;
            mergeBill.set("orgid", (Object)currentOrgId);
            splitRequest.setBill(mergeBill);
            String mergeLabel = splitRequest.getNum() != 1 && splitRequest.getFixedNumber() != false ? "1" : mergeBill.getString("mergelable");
            splitRequest.setLimitAmounts(limitAmountsDTO);
            splitRequest.setBillNoMap(mergeResponse.getBillNoMap());
            splitRequest.setInvoiceContent(mergeResponse.getInvoiceContent());
            String ruleCode = splitRequest.getBill().getString("splitrule");
            if (StringUtils.isNotBlank((CharSequence)ruleCode) && !SplitByRuleServiceImpl.DEFAULT_RULE.contains((Object)ruleCode)) {
                DynamicObject rule = (DynamicObject)ruleMap.get(currentOrgId + ruleCode);
                if (rule == null) {
                    rule = SplitRuleHelper.getRuleByCode((Long)currentOrgId, (String)ruleCode);
                }
                ruleMap.put(currentOrgId + ruleCode, rule);
                splitRequest.setRuleObj(rule);
            }
            SplitResponseDTO splitResponse = BillSplitHelper.splitBill((SplitRequestDTO)splitRequest);
            AbstractBillWorkbenchCustomEvent.setMergeLabel(splitResponse, mergeLabel);
            List invoiceListMap = DynamicObjectUtil.dynamicObjectslist2ListMap((List)splitResponse.getInvoices());
            if (BillHelper.isRedInfo((DynamicObject)mergeBill)) {
                AbstractBillWorkbenchCustomEvent.dealInvoiceContent(that, mergeBill, invoiceListMap);
            }
            if ((totalamount = mergeBill.getBigDecimal("totalamount")).compareTo(BigDecimal.ZERO) > 0 && (taxDeviationBill = AbstractBillWorkbenchCustomEvent.handleSplitTaxDeviation(splitResponse.getRelations(), mergeBill, mergeResponse.getRelations())).size() != 0) {
                taxDeviationBillMap.put(taxDeviationBill.getString("id"), taxDeviationBill);
            }
            AbstractBillWorkbenchCustomEvent.allEleSpecialData(mergeBill, invoiceListMap);
            invoiceListMap.forEach(o -> o.put("orgid", currentOrgId + ""));
            invoiceMap.put(String.valueOf(mergeBill.getLong("id")), invoiceListMap);
            invoiceRelationMap.put(String.valueOf(mergeBill.getLong("id")), AbstractBillWorkbenchCustomEvent.relations2ListMap(splitResponse.getRelations()));
            mergeCacheMap.put(String.valueOf(mergeBill.getLong("id")), Base64.getEncoder().encodeToString(ZipUtil.gzipStr((String)SerializationUtils.toJsonString((Object)DynamicObjectUtil.dynamicObject2Map((DynamicObject)mergeBill)), (String)StandardCharsets.UTF_8.name())));
        }
        that.getPageCache().put(mergeCacheMap);
        returnMap.put("invoiceList", invoiceMap);
        returnMap.put("billNoMap", mergeResponse.getBillNoMap());
        returnMap.put("invoiceRelationMap", invoiceRelationMap);
        returnMap.put("taxDeviationBillMap", taxDeviationBillMap);
        return returnMap;
    }

    protected Map<String, Object> dealMergeBill(List<DynamicObject> mergeBillList) {
        HashMap<String, Object> mergeBillMap = new HashMap<String, Object>(4);
        mergeBillMap.put("bills", this.getHandlerList(mergeBillList));
        return mergeBillMap;
    }

    protected List<Map<String, Object>> getHandlerList(List<DynamicObject> mergeBillList) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(mergeBillList.size());
        for (DynamicObject mergeBill : mergeBillList) {
            Map mergeBillMap = DynamicObjectUtil.dynamicObjectToMap((DynamicObject)mergeBill, (boolean)true);
            String specialType = mergeBill.getString("specialtype");
            if (InvoiceSpecialType.allEleSpecialOneRow((String)specialType)) {
                mergeBillMap.put("simpleaddress_name", AbstractBillWorkbenchCustomEvent.getAddressName(mergeBill));
            }
            list.add(mergeBillMap);
        }
        return list;
    }

    public static void allEleSpecialData(DynamicObject mergeBill, List<Map<String, Object>> invoiceListMap) {
        block4: {
            String specialType;
            block3: {
                specialType = mergeBill.getString("specialtype");
                if (!InvoiceSpecialType.allEleSpecialOneRow((String)specialType)) break block3;
                String addressName = AbstractBillWorkbenchCustomEvent.getAddressName(mergeBill);
                for (Map<String, Object> invoice : invoiceListMap) {
                    invoice.put("simpleaddress_name", addressName);
                }
                break block4;
            }
            if (!"E09".equals(specialType)) break block4;
            for (Map<String, Object> invoice : invoiceListMap) {
                List travelerList = (List)invoice.get("travelers");
                if (!CollectionUtils.isNotEmpty((Collection)travelerList)) continue;
                for (Map traveler : travelerList) {
                    Date travelDate = (Date)traveler.get("traveldate");
                    if (travelDate == null) continue;
                    traveler.put("traveldate", DateUtils.format((Date)travelDate));
                }
            }
        }
    }

    protected static String getAddressName(DynamicObject mergeBill) {
        DynamicObject simpleAddress;
        String addressName = "";
        Object simpleAddressObj = mergeBill.get("simpleaddress");
        if (simpleAddressObj != null && (simpleAddress = simpleAddressObj instanceof DynamicObject ? (DynamicObject)simpleAddressObj : BusinessDataServiceHelper.loadSingleFromCache((Object)simpleAddressObj, (String)"bdm_admindivision")) != null) {
            addressName = simpleAddress.getString("name");
        }
        return addressName;
    }

    protected static void dealInvoiceContent(AbstractFormPlugin that, DynamicObject mergeBill, List<Map<String, Object>> invoiceListMap) {
        if (StringUtils.isNotBlank((CharSequence)mergeBill.getString("infocode"))) {
            BillProcessTabUtil.setSelectInfoCodes(that, mergeBill.getString("infocode"), false);
        }
        String invoiceContent = mergeBill.getString("split");
        for (Map<String, Object> invoice : invoiceListMap) {
            invoice.put("invoiceContent", invoiceContent);
        }
        String invoiceContentChange = mergeBill.getString("mergekey");
        long mergeBillId = mergeBill.getLong("id");
        if ("-1".equals(invoiceContentChange)) {
            if ("2".equals(invoiceContent)) {
                AbstractBillWorkbenchCustomEvent.putPageCache(that, mergeBillId + "invoiceContent" + "2", SerializationUtils.toJsonString(invoiceListMap.get(0)));
            }
            return;
        }
        Map<String, Object> invoice = invoiceListMap.get(0);
        HashMap<String, Object> issueByBillInvoice = new HashMap<String, Object>(invoice.size());
        issueByBillInvoice.putAll(invoice);
        issueByBillInvoice.put("buyeraddr", mergeBill.getString("buyeraddr"));
        issueByBillInvoice.put("buyerbank", mergeBill.getString("buyerbank"));
        issueByBillInvoice.put("applyreason", mergeBill.getString("invoiceremark"));
        issueByBillInvoice.put("drawer", mergeBill.getString("drawer"));
        issueByBillInvoice.put("reviewer", mergeBill.getString("reviewer"));
        issueByBillInvoice.put("payee", mergeBill.getString("payee"));
        AbstractBillWorkbenchCustomEvent.putPageCache(that, mergeBillId + "invoiceContent" + "1", SerializationUtils.toJsonString(invoice));
        switch (invoiceContentChange) {
            case "0": {
                AbstractBillWorkbenchCustomEvent.putPageCache(that, mergeBillId + "invoiceContent" + "2", SerializationUtils.toJsonString(issueByBillInvoice));
                break;
            }
            case "1": {
                issueByBillInvoice.put("items", AbstractBillWorkbenchCustomEvent.dealItems(mergeBill.getDynamicObjectCollection("sim_original_bill_item")));
                if ("2".equals(invoiceContent)) {
                    invoice.clear();
                    invoice.putAll(issueByBillInvoice);
                }
                AbstractBillWorkbenchCustomEvent.putPageCache(that, mergeBillId + "invoiceContent" + "2", SerializationUtils.toJsonString(issueByBillInvoice));
            }
        }
    }

    protected static JSONArray dealItems(DynamicObjectCollection billItems) {
        int seq = 0;
        JSONArray invoiceItems = new JSONArray();
        for (DynamicObject billItem : billItems) {
            JSONObject item = new JSONObject();
            item.put("id", (Object)String.valueOf(DBServiceHelper.genGlobalLongId()));
            item.put("seq", (Object)seq++);
            item.put("taxpremark", (Object)billItem.getString("policylogo"));
            item.put("zzstsgl", (Object)billItem.getString("policycontants"));
            item.put("taxrate", (Object)billItem.getString("taxrate"));
            item.put("goodscode", (Object)billItem.getString("goodscode"));
            item.put("num", (Object)billItem.getBigDecimal("remainvalidnum"));
            item.put("unitprice", (Object)billItem.getBigDecimal("unitprice"));
            item.put("taxunitprice", (Object)billItem.getBigDecimal("taxunitprice"));
            item.put("unit", (Object)billItem.getString("unit"));
            item.put("tax", (Object)billItem.getBigDecimal("remainvalidtax"));
            item.put("taxamount", (Object)billItem.getBigDecimal("remainvalidamount"));
            item.put("amount", (Object)billItem.getBigDecimal("remainvalidamount").subtract(billItem.getBigDecimal("remainvalidtax")));
            item.put("specification", (Object)billItem.getString("specification"));
            item.put("billsourceid", (Object)billItem.getString("billsourceid"));
            String goodsSimpleName = billItem.getString("goodssimplename");
            String goodsName = billItem.getString("goodsname");
            if (StringUtils.isNotBlank((CharSequence)goodsSimpleName) && StringUtils.isNotBlank((CharSequence)goodsName) && !goodsName.startsWith("*")) {
                goodsSimpleName = goodsSimpleName.startsWith("*") ? goodsSimpleName : '*' + goodsSimpleName + '*';
                item.put("simplegoodsname", (Object)goodsSimpleName);
                item.put("goodsname", (Object)(goodsSimpleName + goodsName));
            } else {
                item.put("simplegoodsname", (Object)billItem.getString("goodssimplename"));
                item.put("goodsname", (Object)billItem.getString("goodsname"));
            }
            String rowType = billItem.getString("rowtype");
            if ("2".equals(rowType)) {
                item.put("rowtype", (Object)"0");
            } else if ("1".equals(rowType)) {
                JSONObject beDiscountItem = invoiceItems.getJSONObject(seq - 1);
                beDiscountItem.put("rowtype", (Object)"2");
            }
            invoiceItems.set(seq - 1, (Object)item);
        }
        return invoiceItems;
    }

    protected static void setMergeLabel(SplitResponseDTO splitResponse, String mergeLabel) {
        List invoices = splitResponse.getInvoices();
        for (DynamicObject invoice : invoices) {
            if (InvoiceUtils.isAllEInvoice((Object)invoice.getString("invoicetype")) && invoice.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) < 0) {
                invoice.set("mergelable", (Object)"");
                continue;
            }
            if (!StringUtils.isBlank((CharSequence)invoice.getString("mergelable"))) continue;
            invoice.set("mergelable", (Object)mergeLabel);
        }
    }

    public static List<Map<String, Object>> relations2ListMap(List<BillRelationDTO> relations) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(relations.size());
        for (BillRelationDTO relation : relations) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("sbillid", String.valueOf(relation.getsBillId()));
            map.put("sbillno", relation.getsBillNo());
            map.put("sdetailid", String.valueOf(relation.getsDetailId()));
            map.put("tbillid", String.valueOf(relation.gettBillId()));
            map.put("tbillno", relation.gettBillNo());
            map.put("tdetailid", String.valueOf(relation.gettDetailId()));
            map.put("amount", relation.getAmount());
            map.put("tax", relation.getTax());
            map.put("num", relation.getNum());
            map.put("price", relation.getPrice());
            map.put("ttable", relation.gettTable());
            map.put("pushtype", relation.getPushType());
            map.put("taxDeviation", relation.getTaxDeviation());
            list.add(map);
        }
        return list;
    }

    protected static JSONObject handleSplitTaxDeviation(List<BillRelationDTO> invRelations, DynamicObject bill, List<BillRelationDTO> billRelations) {
        JSONObject json = new JSONObject();
        try {
            Map<Long, List<BillRelationDTO>> invRelationTaxDeviationMap = invRelations.stream().collect(Collectors.groupingBy(BillRelationDTO::getsDetailId));
            List mergeBillRelations = billRelations.stream().filter(relation -> relation.gettBillId().equals(bill.getLong("id"))).collect(Collectors.toList());
            Map<Long, BigDecimal> billRelationTaxDeviationMap = mergeBillRelations.stream().filter(relation -> !MathUtils.isNullOrZero((BigDecimal)relation.getTaxDeviation())).collect(Collectors.toMap(BillRelationDTO::gettDetailId, BillRelationDTO::getTaxDeviation, (v1, v2) -> v1));
            JSONArray itemTaxDeviations = new JSONArray();
            DynamicObjectCollection mergeItems = bill.getDynamicObjectCollection("sim_original_bill_item");
            BigDecimal taxDeviationSum = BigDecimal.ZERO;
            for (DynamicObject mergeItem : mergeItems) {
                long mergeItemId = mergeItem.getLong("id");
                List<BillRelationDTO> relations = invRelationTaxDeviationMap.get(mergeItemId);
                BigDecimal taxDeviation = relations.stream().map(BillRelationDTO::getTaxDeviation).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal billItemTaxDeviation = billRelationTaxDeviationMap.getOrDefault(mergeItemId, BigDecimal.ZERO);
                if (taxDeviation.compareTo(BigDecimal.ZERO) == 0 && billItemTaxDeviation.compareTo(BigDecimal.ZERO) == 0) continue;
                billItemTaxDeviation = billItemTaxDeviation.add(taxDeviation);
                JSONObject itemTaxDeviation = new JSONObject();
                itemTaxDeviation.put("id", (Object)String.valueOf(mergeItemId));
                itemTaxDeviation.put("taxdeviation", (Object)billItemTaxDeviation);
                itemTaxDeviations.add((Object)itemTaxDeviation);
                taxDeviationSum = taxDeviationSum.add(billItemTaxDeviation);
            }
            json.put("id", (Object)String.valueOf(bill.getLong("id")));
            json.put("maintaxdeviation", (Object)taxDeviationSum);
            json.put("sim_original_bill_item", (Object)itemTaxDeviations);
        }
        catch (Exception e) {
            LOGGER.error("\u8bbe\u7f6e\u5c3e\u5dee\u5931\u8d25", (Throwable)e);
        }
        return json;
    }

    protected void handleTaxDeviation(Map<String, Object> map) {
        try {
            Map mergeBillMap = (Map)map.get("mergeBill");
            List mergeBills = (List)mergeBillMap.get("bills");
            this.handleTaxDeviation(mergeBills, (Map)map.remove("taxDeviationBillMap"));
        }
        catch (Exception e) {
            LOGGER.error("\u8bbe\u7f6e\u5c3e\u5dee\u5931\u8d25", (Throwable)e);
        }
    }

    protected void handleTaxDeviation(List<Map<String, Object>> mergeBills, Map<String, JSONObject> taxDeviationBillMap) {
        for (Map<String, Object> mergeBill : mergeBills) {
            String mergeBillId = (String)mergeBill.get("id");
            JSONObject taxDeviationBill = taxDeviationBillMap.get(mergeBillId);
            if (taxDeviationBill == null) continue;
            JSONArray taxDeviationArr = taxDeviationBill.getJSONArray("sim_original_bill_item");
            Map<String, BigDecimal> taxDeviationMap = taxDeviationArr.stream().map(json -> (JSONObject)json).collect(Collectors.toMap(k -> k.getString("id"), v -> v.getBigDecimal("taxdeviation")));
            List items = (List)mergeBill.get("sim_original_bill_item");
            for (Map item : items) {
                BigDecimal taxDeviation = taxDeviationMap.get(item.get("id"));
                if (taxDeviation == null) continue;
                item.put("taxdeviation", taxDeviation);
            }
            mergeBill.put("maintaxdeviation", taxDeviationBill.getBigDecimal("maintaxdeviation"));
        }
    }

    public static Map<String, Object> queryMergeDeviation(DynamicObject originalBill) {
        HashMap<String, JSONObject> taxDeviationBillMap = new HashMap<String, JSONObject>();
        JSONArray itemTaxDeviations = new JSONArray();
        DynamicObjectCollection items = originalBill.getDynamicObjectCollection("sim_original_bill_item");
        for (DynamicObject item : items) {
            JSONObject itemTaxDeviation = new JSONObject();
            itemTaxDeviation.put("id", (Object)String.valueOf(item.getLong("id")));
            itemTaxDeviation.put("taxdeviation", (Object)item.getBigDecimal("taxdeviation"));
            itemTaxDeviations.add((Object)itemTaxDeviation);
        }
        JSONObject json = new JSONObject();
        json.put("id", (Object)String.valueOf(originalBill.getLong("id")));
        json.put("maintaxdeviation", (Object)originalBill.getBigDecimal("maintaxdeviation"));
        json.put("sim_original_bill_item", (Object)itemTaxDeviations);
        taxDeviationBillMap.put(String.valueOf(originalBill.getLong("id")), json);
        HashMap<String, Object> returnMap = new HashMap<String, Object>(4);
        returnMap.put("taxDeviationBillMap", taxDeviationBillMap);
        return returnMap;
    }

    public static void openPreviewStatistics(AbstractFormPlugin that) {
        String userId = RequestContext.get().getUserId();
        DynamicObject showStatistics = QueryServiceHelper.queryOne((String)"sim_preview_setting", (String)"show", (QFilter[])new QFilter("userid", "=", (Object)Long.parseLong(userId)).toArray());
        if (showStatistics == null || "1".equals(showStatistics.getString("show"))) {
            AbstractBillWorkbenchCustomEvent.openPreviewStatisticsPage(that);
        }
    }

    protected static void openPreviewStatisticsPage(AbstractFormPlugin that) {
        String cacheStatistics = AbstractBillWorkbenchCustomEvent.getPageCacheVal(that, "sim_preview_statistics");
        if (StringUtils.isBlank((CharSequence)cacheStatistics)) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("statistics", cacheStatistics);
        ViewUtil.openDialog((AbstractFormPlugin)that, map, (String)"sim_preview_statistics", null);
    }

    protected void checkBillUsed(HashMap<String, StringBuilder> usedMap, HashMap<Long, String> userPkNameMap, DynamicObject bill) {
        if (this.checkWorkbenchCache(bill.getPkValue())) {
            String userName;
            long userPk = Long.parseLong(CacheHelper.get((String)(bill.getPkValue() + "workbench")));
            if (!userPkNameMap.containsKey(userPk)) {
                Map userInfo = UserServiceHelper.getUserInfoByID((long)userPk);
                userName = (String)userInfo.get("name");
                userPkNameMap.put(userPk, userName);
            } else {
                userName = userPkNameMap.get(userPk);
            }
            StringBuilder billNoBuilder = usedMap.get(userName);
            if (null == billNoBuilder) {
                billNoBuilder = new StringBuilder();
                usedMap.put(userName, billNoBuilder);
            }
            billNoBuilder.append('[').append(bill.getString("billno")).append(']');
        }
    }

    protected String generateTips(HashMap<String, StringBuilder> usedMap) {
        StringBuilder tips = new StringBuilder();
        for (Map.Entry<String, StringBuilder> entry : usedMap.entrySet()) {
            String userName = entry.getKey();
            StringBuilder billNos = entry.getValue();
            tips.append(ResManager.loadKDString((String)"\u7528\u6237", (String)"AbstractBillWorkbenchCustomEvent_5", (String)"imc-sim-service", (Object[])new Object[0])).append(userName).append(ResManager.loadKDString((String)"\u5360\u7528\u4e86\u5355\u636e\uff1a", (String)"AbstractBillWorkbenchCustomEvent_6", (String)"imc-sim-service", (Object[])new Object[0])).append((CharSequence)billNos).append(System.lineSeparator());
        }
        return tips.toString();
    }

    protected void onlyPositiveConfirm(AbstractFormPlugin that, DynamicObject[] bills, List<MergeRemoveBillDTO> removeBills, List<String> pks, Map<String, Object> returnMap) {
        that.getPageCache().putBigObject("onlypositive", SerializationUtils.toJsonString(returnMap));
        BigDecimal totalAmount = Arrays.stream(bills).map(bill -> bill.getBigDecimal("totalamount")).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, 4);
        BigDecimal removeAmount = removeBills.stream().map(MergeRemoveBillDTO::getTotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, 4);
        ViewUtil.openMsgConfirm((AbstractFormPlugin)that, (String)String.format(ResManager.loadKDString((String)"\u672c\u6b21\u5171\u63d0\u4ea4%1$s\u4e2a\u5355\u636e\uff0c\u4ef7\u7a0e\u5408\u8ba1%2$s\u5143\uff0c\u5176\u4e2d%3$s\u4e2a\u5355\u636e\u3001\u4ef7\u7a0e\u5408\u8ba1%4$s\u5143\u65e0\u6cd5\u88ab\u51b2\u62b5\uff0c\u672c\u6b21\u4e0d\u652f\u6301\u5f00\u7968\uff0c\u53ef\u5f00\u7968\u5355\u636e%5$s\u4e2a\uff0c\u4ef7\u7a0e\u5408\u8ba1%6$s\u5143\uff0c\u662f\u5426\u7ee7\u7eed\u5f00\u7968\uff1f", (String)"AbstractBillWorkbenchCustomEvent_7", (String)"imc-sim-service", (Object[])new Object[0]), pks.size(), totalAmount, removeBills.size(), removeAmount, pks.size() - removeBills.size(), totalAmount.subtract(removeAmount)), (String)String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u51b2\u62b5\u3001\u672c\u6b21\u4e0d\u652f\u6301\u5f00\u7968\u7684\u5355\u636e\u7f16\u53f7:%1$s%2$s", (String)"AbstractBillWorkbenchCustomEvent_8", (String)"imc-sim-service", (Object[])new Object[0]), System.lineSeparator(), removeBills.stream().map(MergeRemoveBillDTO::getBillNo).collect(Collectors.joining(System.lineSeparator()))), (String)"onlypositive");
    }

    public void showMergeTips(AbstractFormPlugin that, boolean isMergeBill, DynamicObject[] bills) {
        if (!isMergeBill || bills.length <= 1) {
            return;
        }
        for (DynamicObject bill : bills) {
            String systemSource = bill.getString("systemsource");
            if ("AR_FINARBILL".equals(systemSource) || "AR_BUSBILL".equals(systemSource)) {
                that.getView().showTipNotification(ResManager.loadKDString((String)"\u4ece\u5e94\u6536\u5355\u4e0b\u63a8\u7684\u5f00\u7968\u7533\u8bf7\u5355\uff0c\u6682\u4e0d\u652f\u6301\u5355\u636e\u5408\u5e76\u5f00\u7968\u3002", (String)"AbstractBillWorkbenchCustomEvent_9", (String)"imc-sim-service", (Object[])new Object[0]));
                return;
            }
            if (!"XKQJ".equals(systemSource)) continue;
            that.getView().showTipNotification(ResManager.loadKDString((String)"\u4ece\u9500\u552e\u53d1\u7968\u5355\u4e0b\u63a8\u7684\u5f00\u7968\u7533\u8bf7\u5355\uff0c\u6682\u4e0d\u652f\u6301\u5355\u636e\u5408\u5e76\u5f00\u7968\u3002", (String)"AbstractBillWorkbenchCustomEvent_10", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
    }
}

