/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.workbench.event;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Splitter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.MessageTypes;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.dto.merge.MergeRequestDTO;
import kd.imc.bdm.common.dto.merge.MergeResponseDTO;
import kd.imc.bdm.common.dto.split.LimitAmountsDTO;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.helper.SplitRuleHelper;
import kd.imc.bdm.common.helper.invoice.RemarkTemplateHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.dto.bill.workbench.SplitOrMergeRuleDTO;
import kd.imc.sim.common.helper.OriginalBillHelper;
import kd.imc.sim.formplugin.bill.originalbill.workbench.dto.BillPreviewStatisticsDTO;
import kd.imc.sim.formplugin.bill.originalbill.workbench.event.AbstractBillWorkbenchCustomEvent;
import kd.imc.sim.formplugin.bill.originalbill.workbench.pluginworkutils.BillProcessTabUtil;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillMergeHelper;
import org.apache.commons.lang3.tuple.Pair;

public class BillCommonCustomEvent
extends AbstractBillWorkbenchCustomEvent {
    private static final Log LOGGER = LogFactory.getLog(BillCommonCustomEvent.class);

    @Override
    public void customEvent(AbstractFormPlugin that, CustomEventArgs e) {
        String event = e.getEventName();
        String param = e.getEventArgs();
        switch (event) {
            case "common/tip": {
                that.getView().showTipNotification(param);
                break;
            }
            case "close": {
                this.closeWorkBench(that, param);
                break;
            }
            case "init": {
                this.initData(that);
                break;
            }
            case "common/show_confirm": {
                this.showConfirm(that, param);
            }
        }
    }

    private void initData(AbstractFormPlugin that) {
        try {
            Map customParams = that.getView().getFormShowParameter().getCustomParams();
            this.externalSystemReplace(customParams);
            String step = (String)customParams.get("step");
            String jqbh = (String)customParams.get("jqbh");
            String terminalNo = (String)customParams.get("terminalNo");
            String pageSource = (String)customParams.get("pageSource");
            JSONArray pkValues = (JSONArray)customParams.get("pks");
            DynamicObject[] bills = OriginalBillHelper.queryOriginalbillsByIds(pkValues.stream().map(id -> Long.parseLong(String.valueOf(id))).toArray(), "preview".equals(step) || "pratiques".equals(pageSource) ? BillCommonCustomEvent.getMergeBillQueryField() : FIRST_PAGE_SELECT_FIELD, "originbillseq desc");
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("\u63d0\u4ea4\u5230\u5de5\u4f5c\u53f0\u7684\u5355\u636e\u6570\u91cf\u4e3a : " + pkValues.size());
            }
            Map<String, Object> map = this.createBillProcessMap(that, bills, jqbh, terminalNo);
            HashMap<String, StringBuilder> usedMap = new HashMap<String, StringBuilder>();
            HashMap<Long, String> userPkNameMap = new HashMap<Long, String>();
            if ("preview".equals(step)) {
                String currentUserId = RequestContext.get().getUserId();
                for (DynamicObject bill : bills) {
                    this.checkBillUsed(usedMap, userPkNameMap, bill);
                }
                if (usedMap.size() > 0) {
                    String tips = this.generateTips(usedMap);
                    throw new KDBizException(tips);
                }
                Boolean isMergeBill = (Boolean)customParams.get("isMergeBill");
                Boolean isMergeDetail = (Boolean)customParams.get("isMergeDetail");
                map.put("currentDisplay", 2);
                map.put("isMergeBill", isMergeBill);
                map.put("isMergeDetail", isMergeDetail);
                map.put("terminalNo", terminalNo);
                try {
                    String account = (String)customParams.get("account");
                    if (StringUtils.isNotBlank((CharSequence)account)) {
                        map.put("currentAccount", account);
                    }
                    map.putAll(this.createPreViewMap(that, bills, isMergeBill, isMergeDetail, jqbh));
                }
                catch (MsgException e) {
                    String message = ResManager.loadKDString((String)"\u5355\u636e\u5b58\u5728\u660e\u7ec6\u8d85\u8fc7\u7a0e\u63a7\u5c3e\u5dee\uff0c\u8bf7\u8c03\u6574\u6570\u636e\u540e\u5f00\u7968\u3002", (String)"BillCommonCustomEvent_0", (String)"imc-sim-service", (Object[])new Object[0]);
                    if ("mergeMoreThanTaxControl".equals(e.getErrorCode())) {
                        message = ResManager.loadKDString((String)"\u5355\u636e\u7684\u660e\u7ec6\u5408\u5e76\u540e\u8d85\u8fc7\u7a0e\u63a7\u5141\u8bb8\u7684\u5c3e\u5dee\uff0c\u65e0\u6cd5\u5408\u5e76\uff0c\u8bf7\u91cd\u65b0\u52fe\u9009\u5355\u636e\u6216\u5728\u3010\u53d1\u7968\u62c6\u5408\u8bbe\u7f6e\u3011\u4e2d\u91cd\u65b0\u914d\u7f6e\u5408\u5e76\u89c4\u5219\u3002", (String)"BillCommonCustomEvent_1", (String)"imc-sim-service", (Object[])new Object[0]);
                    }
                    that.getView().showMessage(message, e.getErrorMsg(), MessageTypes.Commit);
                    BillCommonCustomEvent.updateCustomControlError(that, map, "init");
                    return;
                }
                for (DynamicObject bill : bills) {
                    CacheHelper.put((String)(bill.getPkValue() + "workbench"), (String)currentUserId);
                }
                this.dealRedRemarkAndItem(map);
            }
            if ("pratiques".equals(pageSource)) {
                map.put("currentDisplay", 1);
                map.put("mergeBill", this.convertDynamicBills2Json(bills));
                BillCommonCustomEvent.putPageCache(that, "workbenchtype", "partiallyopen");
            }
            BillCommonCustomEvent.updateCustomControl(that, map, "init");
            if ("preview".equals(step)) {
                Map invoiceList = (Map)map.get("invoiceList");
                this.statisticsInvoice(that, invoiceList);
                BillCommonCustomEvent.openPreviewStatistics(that);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8fdb\u5165\u5de5\u4f5c\u53f0\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
            BillCommonCustomEvent.handleExcepiton(that, e);
            BillCommonCustomEvent.updateCustomControlError(that, null, "init");
        }
    }

    private void statisticsInvoice(AbstractFormPlugin that, Map<String, List<Map<String, Object>>> invoiceList) {
        Collection<List<Map<String, Object>>> invoices = invoiceList.values();
        HashMap<Object, BillPreviewStatisticsDTO> map = new HashMap<Object, BillPreviewStatisticsDTO>(4);
        for (List<Map<String, Object>> billInvoice : invoices) {
            for (Map<String, Object> invoice : billInvoice) {
                BillPreviewStatisticsDTO previewStatistics = map.computeIfAbsent(invoice.get("invoicetype"), k -> new BillPreviewStatisticsDTO());
                previewStatistics.setInvoiceType((String)invoice.get("invoicetype"));
                previewStatistics.setInvoiceCount(Integer.valueOf(previewStatistics.getInvoiceCount() + 1));
                previewStatistics.setInvoiceAmount(previewStatistics.getInvoiceAmount().add(BigDecimalUtil.getJsonBigDecimalVal((Object)invoice.get("invoiceamount"))));
                previewStatistics.setTotalTax(previewStatistics.getTotalTax().add(BigDecimalUtil.getJsonBigDecimalVal((Object)invoice.get("totaltax"))));
                previewStatistics.setTotalAmount(previewStatistics.getTotalAmount().add(BigDecimalUtil.getJsonBigDecimalVal((Object)invoice.get("totalamount"))));
            }
        }
        BillCommonCustomEvent.putPageCache(that, "sim_preview_statistics", JSONObject.toJSONString(map.values()));
    }

    private void externalSystemReplace(Map<String, Object> customParams) {
        String orgNumber = (String)customParams.get("orgNumber");
        String billNos = (String)customParams.get("billNos");
        if (StringUtils.isBlank((CharSequence)orgNumber) && StringUtils.isBlank((CharSequence)billNos)) {
            return;
        }
        JSONArray pks = new JSONArray();
        DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bdm_org", (String)"", (QFilter[])new QFilter("number", "=", (Object)orgNumber).toArray());
        if (org == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7[%s]\u672a\u5f15\u5165", (String)"BillCommonCustomEvent_2", (String)"imc-sim-service", (Object[])new Object[0]), orgNumber));
        }
        List billNoList = Splitter.on((String)",").splitToList((CharSequence)billNos);
        String billSource = (String)customParams.get("billSource");
        if (!"XKQJ".equals(billSource) && billNoList.size() > 30) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u6b21\u4ec5\u652f\u630130\u4e2a\u5355\u636e", (String)"BillCommonCustomEvent_3", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        QFilter qFilter = new QFilter("orgid", "=", org.getPkValue()).and("billno", "in", (Object)billNoList);
        DynamicObject[] originalBills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)"", (QFilter[])qFilter.toArray());
        if (originalBills.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u5355\u636e\u6570\u636e", (String)"BillCommonCustomEvent_4", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        Arrays.stream(originalBills).forEach(bill -> pks.add(bill.getPkValue()));
        customParams.put("pks", pks);
    }

    private void dealRedRemarkAndItem(Map<String, Object> map) {
        Map invoiceListMap = (Map)map.get("invoiceList");
        if (invoiceListMap == null) {
            return;
        }
        Set entries = invoiceListMap.entrySet();
        for (Map.Entry entry : entries) {
            List invoices = (List)entry.getValue();
            for (Map invoiceMap : invoices) {
                QFilter filter;
                DynamicObject[] infoArray;
                List items = (List)invoiceMap.get("items");
                for (int i = 0; i < items.size(); ++i) {
                    Map currentRow = (Map)items.get(i);
                    if (!"1".equals(currentRow.get("rowtype"))) continue;
                    Map lastRow = (Map)items.get(i - 1);
                    currentRow.put("zzstsgl", lastRow.get("zzstsgl"));
                    currentRow.put("zerotaxmark", lastRow.get("zerotaxmark"));
                    currentRow.put("taxpremark", lastRow.get("taxpremark"));
                }
                String oriInvoiceCode = (String)invoiceMap.get("originalinvoicecode");
                String oriInvoiceNo = (String)invoiceMap.get("originalinvoiceno");
                String infoCode = (String)invoiceMap.get("infocode");
                String infoSerialNo = (String)invoiceMap.get("infoserialno");
                String remark = invoiceMap.get("remark") == null ? "" : (String)invoiceMap.get("remark");
                Object invoiceType = invoiceMap.get("invoicetype");
                Object totalamount = invoiceMap.get("totalamount");
                boolean isRedInfo = false;
                if (InvoiceUtils.isSpecialInvoice((String)String.valueOf(invoiceType)) && null != totalamount) {
                    isRedInfo = BigDecimalUtil.lessZero((BigDecimal)((BigDecimal)totalamount));
                }
                boolean isRedConfirm = false;
                if (InvoiceUtils.isAllEInvoice((Object)String.valueOf(invoiceType)) && StringUtils.isNotBlank((CharSequence)infoCode) && StringUtils.isNotBlank((CharSequence)oriInvoiceNo)) {
                    isRedConfirm = true;
                }
                if (StringUtils.isBlank((CharSequence)oriInvoiceCode) && StringUtils.isNotBlank((CharSequence)infoCode) && StringUtils.isNotBlank((CharSequence)infoSerialNo) && (infoArray = BusinessDataServiceHelper.load((String)"sim_red_info", (String)"invoicecode,invoiceno,originalinvoicecode,originalinvoiceno", (QFilter[])(filter = new QFilter("infoserialno", "=", (Object)infoSerialNo).and("infosource", "!=", (Object)"6").and("infocode", "=", (Object)infoCode)).toArray())).length > 0) {
                    oriInvoiceCode = infoArray[0].getString("originalinvoicecode");
                    oriInvoiceNo = infoArray[0].getString("originalinvoiceno");
                }
                if (StringUtils.isNotBlank((CharSequence)oriInvoiceCode) && StringUtils.isNotBlank((CharSequence)oriInvoiceNo)) {
                    String applyreason;
                    String redRemark = RemarkTemplateHelper.getRedInvoiceRemarkTemplate((String)oriInvoiceCode, (String)oriInvoiceNo);
                    String string = applyreason = invoiceMap.get("applyreason") == null ? "" : (String)invoiceMap.get("applyreason");
                    if (isRedInfo && !applyreason.contains("\u5bf9\u5e94\u6b63\u6570\u53d1\u7968\u4ee3\u7801")) {
                        invoiceMap.put("applyreason", applyreason + redRemark);
                        invoiceMap.put("addPreviewApplyReason", redRemark);
                    } else if (!applyreason.contains("\u5bf9\u5e94\u6b63\u6570\u53d1\u7968\u4ee3\u7801") && !remark.contains("\u5bf9\u5e94\u6b63\u6570\u53d1\u7968\u4ee3\u7801")) {
                        invoiceMap.put("remark", remark + redRemark);
                        invoiceMap.put("addPreviewApplyReason", redRemark);
                    }
                }
                if (!isRedConfirm) continue;
                String redConfirmRemark = RemarkTemplateHelper.generateRedAllEleRemark((String)infoCode, (String)oriInvoiceNo);
                invoiceMap.put("remark", redConfirmRemark + remark);
                invoiceMap.put("addPreviewApplyReason", redConfirmRemark);
            }
        }
    }

    private Map<String, Object> createBillProcessMap(AbstractFormPlugin that, DynamicObject[] bills, String jqbh, String terminalNo) {
        LimitAmountsDTO limitAmountsDTO;
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("currentDisplay", 0);
        map.put("bills", DynamicObjectUtil.dynamicObjects2ListMap((DynamicObject[])bills, (boolean)true));
        long currenDataOrgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)bills[0].get("orgid"));
        BillCommonCustomEvent.putPageCache(that, "currentOrg", String.valueOf(currenDataOrgId));
        BillCommonCustomEvent.putPageCache(that, "currentSalerTaxNo", bills[0].getString("salertaxno"));
        if (!InvoiceUtils.isAllEInvoice((Object)bills[0].getString("invoicetype")) && !AllEleAuthHelper.isElePaper((Object)bills[0].getString("iselepaper"))) {
            DynamicObject orgDynamicObject = TaxUtils.getOrgDynamicObject((Long)currenDataOrgId);
            jqbh = this.initJqbh(orgDynamicObject, jqbh, bills[0].getString("jqbh"), map);
            this.initTerminalNo(orgDynamicObject, jqbh, terminalNo, bills[0].getString("terminalno"), map);
            DynamicObject devObj = EquipmentUtil.getDevByCode((Long)currenDataOrgId, (String)jqbh);
            limitAmountsDTO = new LimitAmountsDTO(devObj);
        } else {
            limitAmountsDTO = new LimitAmountsDTO(true);
            this.initAccount(bills[0].getString("salertaxno"), map);
        }
        map.put("taxequipment", new BillMergeHelper().getItemsMaxTaxDiff(bills[0], jqbh));
        map.put("limitAmounts", limitAmountsDTO);
        BillCommonCustomEvent.putPageCache(that, "limitAmounts", JSONObject.toJSONString((Object)limitAmountsDTO));
        map.put("splitrule", this.getSplitRules(currenDataOrgId));
        map.put("creditQuota", CacheHelper.get((String)("creditQuota_" + bills[0].getString("salertaxno"))));
        return map;
    }

    public String initJqbh(DynamicObject orgDynamicObject, String selectJqbh, String billJqbh, Map<String, Object> map) {
        Map bindDevMap = EquipmentUtil.getBindDevList((DynamicObject)orgDynamicObject, null);
        map.put("jqbhs", bindDevMap);
        if (StringUtils.isBlank((CharSequence)selectJqbh) && StringUtils.isBlank((CharSequence)(selectJqbh = billJqbh))) {
            String devno = orgDynamicObject.getString("defaultdev");
            selectJqbh = StringUtils.isNotBlank((CharSequence)devno) ? devno : (String)bindDevMap.values().stream().findFirst().orElse(null);
        }
        boolean isEnable = false;
        for (Map.Entry entry : bindDevMap.entrySet()) {
            String value = (String)entry.getValue();
            if (!value.equalsIgnoreCase(selectJqbh)) continue;
            isEnable = true;
            break;
        }
        if (!isEnable) {
            selectJqbh = bindDevMap.values().stream().findFirst().orElse(null);
        }
        if (StringUtils.isNotBlank((CharSequence)selectJqbh)) {
            map.put("currentJqbh", selectJqbh);
        }
        return selectJqbh;
    }

    private void initTerminalNo(DynamicObject orgDynamicObject, String selectJqbh, String selectTerminalNo, String billTerminalNo, Map<String, Object> map) {
        if (StringUtils.isNotBlank((CharSequence)selectJqbh)) {
            List bindTerminalList = new ArrayList(4);
            selectTerminalNo = billTerminalNo;
            String taxNo = orgDynamicObject.getDynamicObject("epinfo").getString("number");
            DynamicObject equipment = EquipmentUtil.getEquipmentDynamicObjectByDevNo((String)selectJqbh, (String)taxNo);
            if (equipment != null && "8".equals(equipment.getString("equipmenttype"))) {
                bindTerminalList = EquipmentUtil.getTerminanMapListByDevNo((String)selectJqbh, (String)taxNo);
            }
            if (bindTerminalList != null && bindTerminalList.size() > 0 && StringUtils.isEmpty((CharSequence)selectTerminalNo)) {
                selectTerminalNo = (String)bindTerminalList.get(0);
            }
            map.put("terminalNos", bindTerminalList);
        }
        map.put("terminalNo", selectTerminalNo);
    }

    public void initAccount(String salerTaxNo, Map<String, Object> map) {
        DynamicObject account = AllEleAuthHelper.getAccountByTaxNo((String)salerTaxNo);
        if (!EnterpriseHelper.isLqptChannel((String)salerTaxNo)) {
            Pair accountList = AllEleAuthHelper.getAccountList((DynamicObject)account, (boolean)true);
            map.put("currentAccount", accountList.getKey());
            map.put("accountMap", ((Map)accountList.getValue()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey)));
        }
    }

    private Map<String, Object> createPreViewMap(AbstractFormPlugin that, DynamicObject[] bills, boolean isMergeBill, boolean isMergeDetail, String jqbh) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        MergeRequestDTO request = new MergeRequestDTO.Builder().mergeBill(isMergeBill).mergeBillDetail(isMergeDetail).setJqbh(jqbh).bills(bills).build();
        MergeResponseDTO mergeResponse = new BillMergeHelper().mergeBill(request);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("\u5de5\u4f5c\u53f0\u5408\u5e76\u540e\u7684\u5355\u636e\u6570\u91cf\u4e3a : " + mergeResponse.getBills().size());
        }
        map.put("mergeBill", this.dealMergeBill(mergeResponse.getBills()));
        if (Arrays.stream(bills).anyMatch(bill -> "B".equals(bill.getString("billsourcetype")))) {
            map.put("hidePreback", Boolean.TRUE);
        }
        BillCommonCustomEvent.putPageCache(that, "mergeRelations", JSONObject.toJSONString((Object)mergeResponse.getRelations()));
        BillCommonCustomEvent.putPageCache(that, "billNoMap", JSONObject.toJSONString((Object)mergeResponse.getBillNoMap()));
        map.putAll(BillCommonCustomEvent.splitCacheBill(that, mergeResponse, jqbh, null));
        this.handleTaxDeviation(map);
        return map;
    }

    private Map<String, Object> convertDynamicBills2Json(DynamicObject[] bills) {
        HashMap<String, Object> mergeBillMap = new HashMap<String, Object>(4);
        for (DynamicObject bill : bills) {
            boolean isTax = "1".equals(bill.getString("hsbz"));
            DynamicObjectCollection items = bill.getDynamicObjectCollection("sim_original_bill_item");
            for (int i = 0; i < items.size(); ++i) {
                String rowType;
                DynamicObject item = (DynamicObject)items.get(i);
                if (!isTax) {
                    BigDecimal taxAmount = item.getBigDecimal("remainvalidamount").add(item.getBigDecimal("remainvalidtax"));
                    item.set("remainvalidamount", (Object)taxAmount);
                }
                if ("2".equals(rowType = item.getString("rowtype"))) {
                    item.set("rowtype", (Object)"0");
                    continue;
                }
                if (!"1".equals(rowType)) continue;
                DynamicObject beDiscountItem = (DynamicObject)items.get(i - 1);
                beDiscountItem.set("rowtype", (Object)"2");
            }
        }
        List list = DynamicObjectUtil.dynamicObjects2ListMap((DynamicObject[])bills, (boolean)true);
        mergeBillMap.put("bills", list);
        return mergeBillMap;
    }

    public List<SplitOrMergeRuleDTO> getSplitRules(Long orgId) {
        ArrayList<SplitOrMergeRuleDTO> splitRuleList = new ArrayList<SplitOrMergeRuleDTO>(10);
        DynamicObjectCollection splitRule = SplitRuleHelper.getRuleByOrg((long)orgId);
        QFilter numberFilter = new QFilter("orgid", "=", (Object)orgId);
        DynamicObject[] descDynamic = BusinessDataServiceHelper.load((String)"sim_split_use", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_split_use"), (QFilter[])numberFilter.toArray(), (String)"usecount desc");
        Map<String, String> defaultRuleMap = BillProcessTabUtil.getDefaultRuleMap();
        HashSet<String> usedRuleSet = new HashSet<String>();
        for (DynamicObject object : descDynamic) {
            String ruleCode2 = object.getString("rulecode");
            if (StringUtils.isBlank((CharSequence)ruleCode2)) continue;
            Iterator iterator = splitRule.iterator();
            boolean isFind = false;
            while (iterator.hasNext()) {
                DynamicObject dynamicObject = (DynamicObject)iterator.next();
                if (!dynamicObject.getString("number").equals(ruleCode2)) continue;
                usedRuleSet.add(ruleCode2);
                splitRuleList.add(new SplitOrMergeRuleDTO(dynamicObject.getString("number"), dynamicObject.getString("name")));
                isFind = true;
                iterator.remove();
            }
            if (isFind || !defaultRuleMap.containsKey(ruleCode2)) continue;
            if (!usedRuleSet.contains(ruleCode2)) {
                splitRuleList.add(new SplitOrMergeRuleDTO(object.getString("rulecode"), object.getString("rulename")));
            }
            usedRuleSet.add(ruleCode2);
        }
        defaultRuleMap.forEach((ruleCode, ruleName) -> {
            SplitOrMergeRuleDTO rule = splitRuleList.stream().filter(o -> o.getRuleCode().equals(ruleCode)).findFirst().orElse(null);
            if (rule == null) {
                splitRuleList.add(new SplitOrMergeRuleDTO(ruleCode, ruleName));
            }
        });
        if (!CollectionUtils.isEmpty((Collection)splitRule)) {
            for (DynamicObject obj : splitRule) {
                splitRuleList.add(new SplitOrMergeRuleDTO(obj.getString("number"), obj.getString("name")));
            }
        }
        return splitRuleList;
    }

    private void showConfirm(AbstractFormPlugin that, String param) {
        JSONObject jsonArs = JSONObject.parseObject((String)param);
        String content = jsonArs.getString("content");
        BillCommonCustomEvent.putPageCache(that, "common/show_confirm", param);
        ViewUtil.openNormalConfirm((AbstractFormPlugin)that, (String)content, (String)"common/show_confirm");
    }
}

