/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.splitMerge.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.dto.merge.MergeTaxDeviationDTO;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.sim.common.constant.InvoiceConstant;
import kd.imc.sim.common.enums.TaxDiffEnum;
import kd.imc.sim.common.helper.ItemMerge2OneHelper;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.common.utils.TaxCalcUtil;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillCalcMethod;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillMergeHelper;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillMergeMethod;

public class BillSplitWorkBenchMergeHelper {
    private static final Set<String> ROWTYPE_NOT_DISCOUNT = new ImmutableSet.Builder().add((Object)"2").add((Object)"0").build();

    public static JSONObject dynamicObjectCount(AbstractFormPlugin that, JSONObject invoicesJson, String jqbh, JSONObject request, BigDecimal allBillsAmount) {
        String billId = request.getJSONArray("billIds").getString(0);
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((String)"sim_original_bill", (String)String.join((CharSequence)",", "mergerule", "invoicetype", "salertaxno", "iselepaper"), (QFilter[])new QFilter("id", "=", (Object)Long.parseLong(billId)).toArray());
        if (bill == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u5f00\u7968\u7533\u8bf7\u5355\u4e0d\u5b58\u5728", (String)"BillSplitWorkBenchMergeHelper_0", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        DynamicObject mergeRule = bill.getDynamicObject("mergerule");
        mergeRule = mergeRule != null ? BusinessDataServiceHelper.loadSingle((Object)mergeRule.getPkValue(), (String)"bdm_merge_rule_strategy") : BillMergeMethod.createDefaultMergeConfig();
        boolean isMerge2Multiline = "1".equals(mergeRule.getString("deviationrule")) && "2".equals(mergeRule.getString("nodeviationmergerule"));
        boolean isNumOne = "2".equals(mergeRule.getString("samerowtypemerge"));
        boolean isOffset = "2".equalsIgnoreCase(mergeRule.getString("negativeoffset"));
        JSONObject newInvoicesJson = new JSONObject();
        TaxDiffEnum taxDiffEnum = new BillMergeHelper().getTaxDiff(bill, jqbh);
        for (String key : invoicesJson.keySet()) {
            JSONArray invoiceArr = invoicesJson.getJSONArray(key);
            JSONArray newInvoiceArr = new JSONArray();
            for (Object invoiceObj : invoiceArr) {
                List<String> taxDeviationMsg;
                JSONObject invoice = (JSONObject)invoiceObj;
                BigDecimal amount = invoice.getBigDecimal("invoiceamount");
                if (isNumOne && allBillsAmount.compareTo(amount) != 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u624b\u5de5\u5904\u7406\u4e0e\u201c\u5408\u5e76\u89c4\u5219\u6570\u91cf\u7f6e\u4e3a1\u201d\u4e0d\u7b26\uff0c\u8bf7\u8c03\u6574\u5408\u5e76\u89c4\u5219", (String)"BillSplitWorkBenchMergeHelper_1", (String)"imc-sim-service", (Object[])new Object[0]));
                }
                LinkedHashMap<String, List<JSONObject>> billDetailMaps = BillSplitWorkBenchMergeHelper.countItemsFormJson(invoice, mergeRule);
                Collection<List<JSONObject>> detailLists = billDetailMaps.values();
                JSONArray newInvoiceItems = new JSONArray();
                for (List<JSONObject> itemList : detailLists) {
                    BillSplitWorkBenchMergeHelper.mergeItems(invoice, newInvoiceItems, itemList, isMerge2Multiline, taxDiffEnum);
                    if (!isNumOne) continue;
                    BillSplitWorkBenchMergeHelper.manualMerge(invoice, newInvoiceItems);
                }
                if (isOffset) {
                    boolean isPartApply = allBillsAmount.compareTo(amount) != 0;
                    ItemMerge2OneHelper.manualOffsetMerge((JSONObject)invoice, (JSONArray)newInvoiceItems, (boolean)isNumOne, (boolean)isPartApply);
                }
                if (!CollectionUtils.isEmpty(taxDeviationMsg = BillSplitWorkBenchMergeHelper.adjustmentTailDifference(invoice, newInvoiceItems, taxDiffEnum))) {
                    if ("1".equals(mergeRule.getString("deviationrule"))) {
                        List pks = request.getJSONArray("billIds").toJavaList(Long.class);
                        DynamicObjectCollection bills = QueryServiceHelper.query((String)"sim_original_bill", (String)"billno", (QFilter[])new QFilter("id", "in", (Object)pks).toArray());
                        throw new MsgException(bills.stream().map(originalbill -> String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%s", (String)"BillSplitWorkBenchMergeHelper_4", (String)"imc-sim-service", (Object[])new Object[0]), originalbill.getString("billno"))).collect(Collectors.joining(System.lineSeparator())));
                    }
                    that.getView().showTipNotification(String.join((CharSequence)System.lineSeparator(), taxDeviationMsg), Integer.valueOf(5000));
                }
                invoice.put("items", (Object)newInvoiceItems);
                BillSplitWorkBenchMergeHelper.clearItemInfo(mergeRule, invoice);
                BillSplitWorkBenchMergeHelper.calcBillHeadAmount(invoice, newInvoiceItems);
                newInvoiceArr.add((Object)invoice);
            }
            newInvoicesJson.put(key, (Object)newInvoiceArr);
        }
        return newInvoicesJson;
    }

    public static void mergeItems(JSONObject invoice, JSONArray newInvoiceItems, List<JSONObject> itemList, boolean isMerge2Multiline, TaxDiffEnum taxDiffEnum) {
        int itemsNowIndex = newInvoiceItems.size();
        HashMap<Integer, MergeTaxDeviationDTO> taxDeviationMap = new HashMap<Integer, MergeTaxDeviationDTO>(itemList.size());
        for (int i = 0; i < itemList.size(); ++i) {
            JSONObject nowItem = itemList.get(i);
            taxDeviationMap.put(i, new MergeTaxDeviationDTO(nowItem.getString("rowtype"), BillSplitWorkBenchMergeHelper.getTaxDeviation(invoice, nowItem)));
            JSONObject tItem = BillSplitWorkBenchMergeHelper.findLastSameItem(newInvoiceItems, itemsNowIndex, nowItem);
            if (tItem == null) {
                JSONObject newItem = BillSplitWorkBenchMergeHelper.cloneJSONObject(nowItem);
                newInvoiceItems.add((Object)newItem);
                continue;
            }
            BillSplitWorkBenchMergeHelper.doMergeItem(tItem, nowItem);
        }
        if (isMerge2Multiline) {
            BillSplitWorkBenchMergeHelper.dealMergeTax(itemList, invoice, itemsNowIndex, taxDeviationMap, newInvoiceItems, taxDiffEnum);
        }
    }

    private static void dealMergeTax(List<JSONObject> itemList, JSONObject invoice, int itemsNowIndex, Map<Integer, MergeTaxDeviationDTO> taxDeviationMap, JSONArray newInvoiceItems, TaxDiffEnum taxDiffEnum) {
        for (int nowIndex = itemsNowIndex; nowIndex < newInvoiceItems.size(); ++nowIndex) {
            Integer taxDeviationNearIndex;
            BigDecimal taxDeviation;
            JSONObject tItem = newInvoiceItems.getJSONObject(nowIndex);
            if (!tItem.getString("id").contains(",") || !BigDecimalUtil.compare((BigDecimal)(taxDeviation = BillSplitWorkBenchMergeHelper.getTaxDeviation(invoice, tItem)), (BigDecimal)BigDecimal.ZERO, (BigDecimal)InvoiceConstant.DIFFF_06) && BillSplitWorkBenchMergeHelper.checkBwTaxDeviation(invoice, newInvoiceItems, taxDiffEnum) && BillSplitWorkBenchMergeHelper.checkRpaTaxDeviation(invoice, tItem, taxDeviation, taxDiffEnum) || (taxDeviationNearIndex = BillSplitWorkBenchMergeHelper.getTaxDeviationNear(taxDeviationMap, tItem.getString("rowtype"), taxDeviation)) == null) continue;
            JSONObject sSubItem = itemList.get(taxDeviationNearIndex);
            BillSplitWorkBenchMergeHelper.subItem(tItem, sSubItem);
            if ("0".equals(sSubItem.getString("rowtype"))) {
                BillSplitWorkBenchMergeHelper.addOrMergeItem(sSubItem, invoice, newInvoiceItems, nowIndex, taxDiffEnum);
                taxDeviationMap.remove(taxDeviationNearIndex);
            } else if ("1".equals(sSubItem.getString("rowtype"))) {
                JSONObject tBeDiscountItem = newInvoiceItems.getJSONObject(nowIndex - 1);
                JSONObject sSubBeDiscountIem = itemList.get(taxDeviationNearIndex - 1);
                BillSplitWorkBenchMergeHelper.subItem(tBeDiscountItem, sSubBeDiscountIem);
                BillSplitWorkBenchMergeHelper.addOrMergeItem(sSubBeDiscountIem, sSubItem, invoice, newInvoiceItems, nowIndex, taxDiffEnum);
                taxDeviationMap.remove(taxDeviationNearIndex);
                taxDeviationMap.remove(taxDeviationNearIndex - 1);
                --nowIndex;
            } else {
                JSONObject tDiscountRow = newInvoiceItems.getJSONObject(nowIndex + 1);
                JSONObject sDiscountRow = itemList.get(taxDeviationNearIndex + 1);
                BillSplitWorkBenchMergeHelper.subItem(tDiscountRow, sDiscountRow);
                if (tDiscountRow.getBigDecimal("amount").compareTo(BigDecimal.ZERO) == 0) {
                    newInvoiceItems.remove((Object)tDiscountRow);
                }
                BillSplitWorkBenchMergeHelper.addOrMergeItem(sSubItem, sDiscountRow, invoice, newInvoiceItems, nowIndex + 1, taxDiffEnum);
                taxDeviationMap.remove(taxDeviationNearIndex);
                taxDeviationMap.remove(taxDeviationNearIndex + 1);
            }
            --nowIndex;
        }
    }

    private static boolean checkBwTaxDeviation(JSONObject invoice, JSONArray items, TaxDiffEnum taxDiffEnum) {
        if (taxDiffEnum != TaxDiffEnum.DIFF_AVG_001) {
            return true;
        }
        BigDecimal taxDeviationSum = BigDecimal.ZERO;
        for (int i = 0; i < items.size(); ++i) {
            JSONObject item = items.getJSONObject(i);
            taxDeviationSum = taxDeviationSum.add(BillSplitWorkBenchMergeHelper.getTaxDeviation(invoice, item));
        }
        BigDecimal taxDeviation = InvoiceConstant.DIFF_01.multiply(new BigDecimal(items.size()));
        return taxDeviation.compareTo(taxDeviationSum.setScale(2, 4).abs()) >= 0;
    }

    private static boolean checkBwMergeItem(JSONObject mergeItem, JSONObject invoice, JSONArray items, TaxDiffEnum taxDiffEnum, boolean isAddRow) {
        if (taxDiffEnum != TaxDiffEnum.DIFF_AVG_001) {
            return true;
        }
        BigDecimal taxDeviationSum = BigDecimal.ZERO;
        for (int i = 0; i < items.size(); ++i) {
            JSONObject item = items.getJSONObject(i);
            taxDeviationSum = mergeItem.getString("id").contains(item.getString("id")) ? taxDeviationSum.add(BillSplitWorkBenchMergeHelper.getTaxDeviation(invoice, mergeItem)) : taxDeviationSum.add(BillSplitWorkBenchMergeHelper.getTaxDeviation(invoice, item));
        }
        BigDecimal taxDeviation = InvoiceConstant.DIFF_01.multiply(new BigDecimal(items.size() + (isAddRow ? 1 : 0)));
        return taxDeviation.compareTo(taxDeviationSum.setScale(2, 4).abs()) >= 0;
    }

    public static boolean checkRpaTaxDeviation(JSONObject invoice, JSONObject item, BigDecimal taxDeviation, TaxDiffEnum taxDiffEnum) {
        if (taxDiffEnum != TaxDiffEnum.DIFF_RPA_001) {
            return true;
        }
        if (!InvoiceUtils.isAllEInvoice((Object)invoice.getString("invoicetype"))) {
            return true;
        }
        if (!"1".equals(item.getString("rowtype"))) {
            return true;
        }
        return taxDeviation.abs().compareTo(InvoiceConstant.DIFF_01) <= 0;
    }

    private static Integer getTaxDeviationNear(Map<Integer, MergeTaxDeviationDTO> taxDeviationMap, String rowType, BigDecimal taxDeviation) {
        Set<Map.Entry<Integer, MergeTaxDeviationDTO>> entries = taxDeviationMap.entrySet();
        List<Map.Entry<Integer, MergeTaxDeviationDTO>> taxDeviationList = entries.stream().filter(o -> ((MergeTaxDeviationDTO)o.getValue()).getRowType().equals(rowType) || ROWTYPE_NOT_DISCOUNT.contains(((MergeTaxDeviationDTO)o.getValue()).getRowType()) && ROWTYPE_NOT_DISCOUNT.contains(rowType)).collect(Collectors.toList());
        return BillMergeHelper.getTaxDeviationNear(taxDeviationList, taxDeviation);
    }

    private static void addOrMergeItem(JSONObject sItem, JSONObject invoice, JSONArray newInvoiceItems, int startIndex, TaxDiffEnum taxDiffEnum) {
        for (int i = startIndex + 1; i < newInvoiceItems.size(); ++i) {
            JSONObject beMergeItem;
            JSONObject tItem = newInvoiceItems.getJSONObject(i);
            if (!sItem.getString("rowtype").equals(tItem.getString("rowtype")) || !BillSplitWorkBenchMergeHelper.checkMergeItem(beMergeItem = BillSplitWorkBenchMergeHelper.cloneJSONObject(tItem), sItem, invoice) || !BillSplitWorkBenchMergeHelper.checkBwMergeItem(beMergeItem, invoice, newInvoiceItems, taxDiffEnum, false)) continue;
            BillSplitWorkBenchMergeHelper.doMergeItem(tItem, sItem);
            return;
        }
        JSONObject sItemNew = BillSplitWorkBenchMergeHelper.cloneJSONObject(sItem);
        newInvoiceItems.add((Object)sItemNew);
    }

    private static void addOrMergeItem(JSONObject sBeDisountItem, JSONObject sDiscountItem, JSONObject invoice, JSONArray newInvoiceItems, int startIndex, TaxDiffEnum taxDiffEnum) {
        for (int i = startIndex + 1; i < newInvoiceItems.size(); ++i) {
            JSONObject tItem = newInvoiceItems.getJSONObject(i);
            if ("1".equals(tItem.getString("rowtype"))) continue;
            if ("2".equals(tItem.getString("rowtype"))) {
                JSONObject discountItem = newInvoiceItems.getJSONObject(i + 1);
                JSONObject beNormalMerItem = BillSplitWorkBenchMergeHelper.cloneJSONObject(tItem);
                JSONObject beDiscountMergeItem = BillSplitWorkBenchMergeHelper.cloneJSONObject(discountItem);
                if (!BillSplitWorkBenchMergeHelper.checkMergeItem(beNormalMerItem, sBeDisountItem, invoice) || !BillSplitWorkBenchMergeHelper.checkMergeItem(beDiscountMergeItem, sDiscountItem, invoice) || !BillSplitWorkBenchMergeHelper.checkBwMergeItem(beNormalMerItem, invoice, newInvoiceItems, taxDiffEnum, false) || !BillSplitWorkBenchMergeHelper.checkRpaMergeItem(beDiscountMergeItem, sDiscountItem, invoice)) continue;
                BillSplitWorkBenchMergeHelper.doMergeItem(tItem, sBeDisountItem);
                BillSplitWorkBenchMergeHelper.doMergeItem(discountItem, sDiscountItem);
                return;
            }
            JSONObject beNormalMerItem = BillSplitWorkBenchMergeHelper.cloneJSONObject(tItem);
            if (!BillSplitWorkBenchMergeHelper.checkMergeItem(beNormalMerItem, sBeDisountItem, invoice) || !BillSplitWorkBenchMergeHelper.checkBwMergeItem(beNormalMerItem, invoice, newInvoiceItems, taxDiffEnum, true)) continue;
            BillSplitWorkBenchMergeHelper.doMergeItem(tItem, sBeDisountItem);
            JSONObject sDiscountItemNew = BillSplitWorkBenchMergeHelper.cloneJSONObject(sDiscountItem);
            newInvoiceItems.add(i + 1, (Object)sDiscountItemNew);
            return;
        }
        JSONObject sBeDisountItemNew = BillSplitWorkBenchMergeHelper.cloneJSONObject(sBeDisountItem);
        newInvoiceItems.add((Object)sBeDisountItemNew);
        JSONObject sDiscountItemNew = BillSplitWorkBenchMergeHelper.cloneJSONObject(sDiscountItem);
        newInvoiceItems.add((Object)sDiscountItemNew);
    }

    private static boolean checkRpaMergeItem(JSONObject beDiscountMergeItem, JSONObject sDiscountItem, JSONObject invoice) {
        BillSplitWorkBenchMergeHelper.doMergeItem(beDiscountMergeItem, sDiscountItem);
        return BillSplitWorkBenchMergeHelper.checkItemlessThanDeviation(beDiscountMergeItem, invoice, InvoiceConstant.DIFF_01);
    }

    private static void subItem(JSONObject beMergeItem, JSONObject sItem) {
        String[] ids = beMergeItem.getString("id").split(",");
        beMergeItem.put("id", (Object)Stream.of(ids).filter(id -> !sItem.getString("id").equals(id)).collect(Collectors.joining(",")));
        beMergeItem.put("amount", (Object)BigDecimalUtil.getJsonBigDecimalVal((Object)beMergeItem.get((Object)"amount")).subtract(BigDecimalUtil.getJsonBigDecimalVal((Object)sItem.get((Object)"amount"))));
        beMergeItem.put("taxamount", (Object)BigDecimalUtil.getJsonBigDecimalVal((Object)beMergeItem.get((Object)"taxamount")).subtract(BigDecimalUtil.getJsonBigDecimalVal((Object)sItem.get((Object)"taxamount"))));
        beMergeItem.put("tax", (Object)BigDecimalUtil.getJsonBigDecimalVal((Object)beMergeItem.get((Object)"tax")).subtract(BigDecimalUtil.getJsonBigDecimalVal((Object)sItem.get((Object)"tax"))));
        beMergeItem.put("num", (Object)BigDecimalUtil.getJsonBigDecimalVal((Object)beMergeItem.get((Object)"num")).subtract(BigDecimalUtil.getJsonBigDecimalVal((Object)sItem.get((Object)"num"))));
    }

    private static JSONObject findLastSameItem(JSONArray newInvoiceItems, int itemsNowIndex, JSONObject sItem) {
        for (int i = newInvoiceItems.size() - 1; i >= itemsNowIndex; --i) {
            JSONObject item = newInvoiceItems.getJSONObject(i);
            if (!sItem.getString("rowtype").equals(item.getString("rowtype")) && (!ROWTYPE_NOT_DISCOUNT.contains(sItem.getString("rowtype")) || !ROWTYPE_NOT_DISCOUNT.contains(item.getString("rowtype")))) continue;
            return item;
        }
        return null;
    }

    private static BigDecimal getTaxDeviation(JSONObject invoice, JSONObject item) {
        return BigDecimalUtil.getJsonBigDecimalVal((Object)item.get((Object)"tax")).subtract(TaxCalcUtil.calTax((BigDecimal)BigDecimalUtil.getJsonBigDecimalVal((Object)item.get((Object)"amount")), (BigDecimal)BigDecimalUtil.getJsonBigDecimalVal((Object)invoice.get((Object)"deduction")), (String)item.getString("taxrate"), (boolean)false, (int)6));
    }

    public static void manualMerge(JSONObject invoice, JSONArray newInvoiceItems) {
        for (Object item : newInvoiceItems) {
            JSONObject itemJson = (JSONObject)item;
            if ("1".equals(itemJson.getString("rowtype"))) continue;
            BigDecimal num = BigDecimal.ONE;
            if (BigDecimal.ZERO.compareTo(itemJson.getBigDecimal("amount")) > 0) {
                num = num.negate();
            }
            itemJson.put("num", (Object)num);
            itemJson.put("unitprice", itemJson.get((Object)"amount"));
            itemJson.put("taxunitprice", itemJson.get((Object)"taxamount"));
        }
        invoice.put("mergelable", (Object)"1");
    }

    private static boolean checkMergeItem(JSONObject beMergeItem, JSONObject item, JSONObject invoice) {
        BillSplitWorkBenchMergeHelper.doMergeItem(beMergeItem, item);
        return BillSplitWorkBenchMergeHelper.checkItemlessThanDeviation(beMergeItem, invoice, InvoiceConstant.DIFFF_06);
    }

    private static void doMergeItem(JSONObject beMergeItem, JSONObject item) {
        beMergeItem.put("id", (Object)(beMergeItem.get((Object)"id") + "," + item.get((Object)"id")));
        beMergeItem.put("amount", (Object)BigDecimalUtil.getJsonBigDecimalVal((Object)beMergeItem.get((Object)"amount")).add(BigDecimalUtil.getJsonBigDecimalVal((Object)item.get((Object)"amount"))));
        beMergeItem.put("taxamount", (Object)BigDecimalUtil.getJsonBigDecimalVal((Object)beMergeItem.get((Object)"taxamount")).add(BigDecimalUtil.getJsonBigDecimalVal((Object)item.get((Object)"taxamount"))));
        beMergeItem.put("tax", (Object)BigDecimalUtil.getJsonBigDecimalVal((Object)beMergeItem.get((Object)"tax")).add(BigDecimalUtil.getJsonBigDecimalVal((Object)item.get((Object)"tax"))));
        beMergeItem.put("num", (Object)BigDecimalUtil.getJsonBigDecimalVal((Object)beMergeItem.get((Object)"num")).add(BigDecimalUtil.getJsonBigDecimalVal((Object)item.get((Object)"num"))));
    }

    public static boolean checkItemlessThanDeviation(JSONObject item, JSONObject invoice, BigDecimal diff) {
        boolean isTax = "1".equals(invoice.getString("hsbz"));
        BigDecimal tax = BigDecimalUtil.getJsonBigDecimalVal((Object)item.get((Object)"tax"));
        BigDecimal deduction = BigDecimalUtil.getJsonBigDecimalVal((Object)invoice.get((Object)"deduction"));
        if ("1".equals(item.getString("rowtype"))) {
            deduction = BigDecimal.ZERO;
        }
        BigDecimal calcTax = TaxCalcUtil.calTax((BigDecimal)(isTax ? BigDecimalUtil.getJsonBigDecimalVal((Object)item.get((Object)"taxamount")) : BigDecimalUtil.getJsonBigDecimalVal((Object)item.get((Object)"amount"))), (BigDecimal)deduction, (String)item.getString("taxrate"), (boolean)isTax, (int)6);
        return !BigDecimalUtil.compare((BigDecimal)calcTax, (BigDecimal)tax, (BigDecimal)diff);
    }

    private static void calcBillHeadAmount(JSONObject invoice, JSONArray newInvoiceItems) {
        BigDecimal invoiceamount = BigDecimal.ZERO;
        BigDecimal totalamount = BigDecimal.ZERO;
        BigDecimal totaltax = BigDecimal.ZERO;
        for (int i = 0; i < newInvoiceItems.size(); ++i) {
            JSONObject dyNew = newInvoiceItems.getJSONObject(i);
            invoiceamount = invoiceamount.add(BigDecimalUtil.getJsonBigDecimalVal((Object)dyNew.get((Object)"amount")));
            totalamount = totalamount.add(BigDecimalUtil.getJsonBigDecimalVal((Object)dyNew.get((Object)"taxamount")));
            totaltax = totaltax.add(BigDecimalUtil.getJsonBigDecimalVal((Object)dyNew.get((Object)"tax")));
        }
        invoice.put("invoiceamount", (Object)invoiceamount);
        invoice.put("totalamount", (Object)totalamount);
        invoice.put("totaltax", (Object)totaltax);
    }

    private static List<String> adjustmentTailDifference(JSONObject invoice, JSONArray newInvoiceItems, TaxDiffEnum taxDiffEnum) {
        boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)invoice.getString("invoicetype")) || "1".equals(invoice.getString("iselepaper"));
        ArrayList<String> msgList = new ArrayList<String>(newInvoiceItems.size());
        for (int i = 0; i < newInvoiceItems.size(); ++i) {
            JSONObject item = newInvoiceItems.getJSONObject(i);
            BigDecimal itemTaxAmount = BigDecimalUtil.getJsonBigDecimalVal((Object)item.get((Object)"taxamount"));
            BigDecimal tax = BigDecimalUtil.getJsonBigDecimalVal((Object)item.get((Object)"tax"));
            String taxRate = StringUtils.isNotBlank((CharSequence)item.getString("taxrate")) ? item.getString("taxrate") : "0";
            BigDecimal calcTax = TaxCalcUtil.calTax((BigDecimal)itemTaxAmount.subtract(tax), (BigDecimal)BigDecimal.ZERO, (String)taxRate, (boolean)false, (int)6);
            if (BigDecimalUtil.compare((BigDecimal)calcTax, (BigDecimal)tax, (BigDecimal)InvoiceConstant.DIFFF_06) || !BillSplitWorkBenchMergeHelper.checkBwTaxDeviation(invoice, newInvoiceItems, taxDiffEnum) || !BillSplitWorkBenchMergeHelper.checkRpaTaxDeviation(invoice, item, calcTax.subtract(tax), taxDiffEnum)) {
                BigDecimal singleDiff = "1".equals(item.getString("rowtype")) && taxDiffEnum == TaxDiffEnum.DIFF_RPA_001 ? InvoiceConstant.DIFF_01 : InvoiceConstant.DIFFF_06;
                calcTax = BillCalcMethod.calcBillTax(itemTaxAmount, tax, BigDecimal.ZERO, taxRate, 1, singleDiff);
                item.put("tax", (Object)calcTax);
                item.put("amount", (Object)itemTaxAmount.subtract(calcTax));
                msgList.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5408\u5e76\u540e\u7a0e\u989d\u8d85\u5c3e\u5dee\uff0c\u5df2\u8fdb\u884c\u91cd\u7b97\uff0c\u539f\u5408\u5e76\u7a0e\u989d\u4e3a%2$s", (String)"BillSplitWorkBenchMergeHelper_3", (String)"imc-sim-service", (Object[])new Object[0]), i + 1, tax.setScale(2, 4)));
            }
            BillSplitWorkBenchMergeHelper.calcPrice(item, isAllEle);
            if (i == 0 || !"1".equals(item.getString("rowtype"))) continue;
            JSONObject preItem = newInvoiceItems.getJSONObject(i - 1);
            preItem.put("rowtype", (Object)"2");
        }
        return msgList;
    }

    private static void calcPrice(JSONObject item, boolean isAllEle) {
        BigDecimal num = BigDecimalUtil.getJsonBigDecimalVal((Object)item.get((Object)"num"));
        if (MathUtils.isNullOrZero((BigDecimal)num)) {
            item.put("taxunitprice", (Object)BigDecimal.ZERO);
            item.put("unitprice", (Object)BigDecimal.ZERO);
            return;
        }
        BigDecimal unitPrice = BigDecimalUtil.getJsonBigDecimalVal((Object)item.get((Object)"unitprice"));
        BigDecimal amount = BigDecimalUtil.getJsonBigDecimalVal((Object)item.get((Object)"amount"));
        if (BigDecimalUtil.compare((BigDecimal)BigDecimalUtil.multiply((BigDecimal)num, (BigDecimal)unitPrice), (BigDecimal)amount, (BigDecimal)InvoiceConstant.DIFF_01)) {
            item.put("unitprice", (Object)PriceHelper.calcPriceOrNum((BigDecimal)amount, (BigDecimal)num, (boolean)isAllEle));
        }
        BigDecimal taxUnitPrice = BigDecimalUtil.getJsonBigDecimalVal((Object)item.get((Object)"taxunitprice"));
        BigDecimal taxAmount = BigDecimalUtil.getJsonBigDecimalVal((Object)item.get((Object)"taxamount"));
        if (BigDecimalUtil.compare((BigDecimal)BigDecimalUtil.multiply((BigDecimal)num, (BigDecimal)taxUnitPrice), (BigDecimal)taxAmount, (BigDecimal)InvoiceConstant.DIFF_01)) {
            item.put("taxunitprice", (Object)PriceHelper.calcPriceOrNum((BigDecimal)taxAmount, (BigDecimal)num, (boolean)isAllEle));
        }
    }

    private static LinkedHashMap<String, List<JSONObject>> countItemsFormJson(JSONObject invoice, DynamicObject mergeRule) {
        JSONArray items = invoice.getJSONArray("items");
        LinkedHashMap<String, List<JSONObject>> returnMap = new LinkedHashMap<String, List<JSONObject>>(items.size());
        block9: for (int i = 0; i < items.size(); ++i) {
            JSONObject itemObject = items.getJSONObject(i);
            switch (itemObject.getString("rowtype")) {
                case "0": 
                case "2": {
                    String mergeBillDetailKey = BillSplitWorkBenchMergeHelper.getMergeBillDetailKey(invoice, itemObject, mergeRule);
                    List dynamicObjects = returnMap.computeIfAbsent(mergeBillDetailKey, k -> new ArrayList());
                    dynamicObjects.add(itemObject);
                    continue block9;
                }
                case "1": {
                    returnMap.get(BillSplitWorkBenchMergeHelper.getMergeBillDetailKey(invoice, items.getJSONObject(i - 1), mergeRule)).add(itemObject);
                }
            }
        }
        return returnMap;
    }

    private static String getMergeBillDetailKey(JSONObject invoice, JSONObject item, DynamicObject mergeRule) {
        ArrayList<String> list = new ArrayList<String>(15);
        list.add(item.getString("goodsname"));
        list.add("1".equals(item.get((Object)"rowtype")) ? "1" : "0");
        list.add(item.getString("taxrate"));
        String price = "1".equals(invoice.getString("hsbz")) ? item.getString("taxunitprice") : item.getString("unitprice");
        String itemMergeKey = mergeRule.getString("itemmergekey");
        if (StringUtils.isNotBlank((CharSequence)itemMergeKey)) {
            String[] itemMergeFields;
            for (String itemMergeField : itemMergeFields = itemMergeKey.split(",")) {
                if ("price".equals(itemMergeField)) {
                    list.add(price);
                    continue;
                }
                Object billValue = item.get((Object)itemMergeField);
                list.add(String.valueOf(billValue));
            }
        }
        return String.join((CharSequence)"\u25cf\u25c6\u25a0", list);
    }

    private static void clearItemInfo(DynamicObject mergeRule, JSONObject invoice) {
        String clearItemKey = mergeRule.getString("clearitemkey");
        if (StringUtils.isBlank((CharSequence)clearItemKey)) {
            return;
        }
        if (clearItemKey.contains("num")) {
            invoice.put("mergelable", (Object)"1");
        }
        String[] itemKeyArr = clearItemKey.split(",");
        JSONArray items = invoice.getJSONArray("items");
        Set itemKeys = items.getJSONObject(0).keySet();
        for (Object itemJson : items) {
            JSONObject item = (JSONObject)itemJson;
            for (String itemKey : itemKeyArr) {
                if ("price".equals(itemKey)) {
                    item.put("unitprice", null);
                    item.put("taxunitprice", null);
                    continue;
                }
                if ("num".equals(itemKey)) {
                    item.put("num", null);
                    continue;
                }
                if (!itemKeys.contains(itemKey)) continue;
                item.put(itemKey, (Object)"");
            }
        }
    }

    public static JSONObject cloneJSONObject(JSONObject json) {
        JSONObject newJson = new JSONObject();
        Set entries = json.entrySet();
        for (Map.Entry entry : entries) {
            newJson.put((String)entry.getKey(), entry.getValue());
        }
        return newJson;
    }
}

