/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.splitMerge.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.dto.BillCheckProcessDto;
import kd.imc.bdm.common.dto.BillDetailVo;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.InvTitleSettingHelper;
import kd.imc.bdm.common.helper.IssueInvSettingHelper;
import kd.imc.bdm.common.helper.RelationHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.constant.RedConfirmStatusEnum;
import kd.imc.sim.common.constant.ValidTypeEnum;
import kd.imc.sim.common.helper.BillValidaterHelper;
import kd.imc.sim.common.helper.InvTitleMatchHelper;
import kd.imc.sim.common.helper.issueinvoice.IssueInvoiceMqHelper;
import kd.imc.sim.common.service.CheckBillService;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.issuing.helper.IssueInvoiceControlHelper;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillHelper;
import org.apache.commons.collections.CollectionUtils;

public class BillValidResultController {
    public static final String SIM_REPEAT_PUSH_BILL_ID = "sim_repeat_push_bill_id";

    public static DynamicObject[] loadRelationByBill(DynamicObject bill) {
        QFilter filter = new QFilter("sbillid", "=", bill.getPkValue());
        return BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)"sbillid,tbillid", (QFilter[])filter.toArray());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApiResult handleValidResult(BillVo bill) {
        String billRemark;
        QFilter qFilter = new QFilter("billno", "=", (Object)bill.getBillNo());
        qFilter.and("orgid", "=", (Object)bill.getOrgId());
        DynamicObject billDB = BusinessDataServiceHelper.loadSingle((String)"sim_original_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_original_bill", (boolean)true), (QFilter[])qFilter.toArray());
        if (StringUtils.isNotBlank((CharSequence)bill.getAccount())) {
            if (InvoiceUtils.isAllEInvoice((Object)bill.getInvoiceType()) || "1".equals(bill.getIsElePaper())) {
                String taxNo = bill.getSellerTaxpayerId();
                String errorMsg = AllEleAuthHelper.checkIssueAccount((String)taxNo, (String)bill.getAccount());
                if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)errorMsg);
                }
            } else {
                bill.setAccount(null);
            }
        }
        if (null == billDB) {
            return ApiResult.success((Object)"");
        }
        if ("2".equals(billDB.getString("validstate"))) {
            return ApiResult.success((Object)billDB);
        }
        DynamicObject invTitleSetting = InvTitleSettingHelper.getInvTitleSetting((Long)bill.getOrgId());
        boolean isOpenTitleMapping = invTitleSetting != null && invTitleSetting.getBoolean(InvTitleSettingHelper.InvTitleMappingEnum.TIT_MAPP_BILL_PUSH.getCode());
        List<BillVo> billVos = Collections.singletonList(bill);
        InvTitleMatchHelper.setAsstactInfo(billVos, isOpenTitleMapping);
        InvTitleMatchHelper.matchInvTitle(billVos, isOpenTitleMapping, invTitleSetting);
        ApiResult apiResult = BillValidaterHelper.validBillBuyer(bill, ValidTypeEnum.getValidTypeByCode((int)bill.getAutoInvoice()));
        if (!apiResult.getSuccess()) {
            return apiResult;
        }
        try {
            new CheckBillService(bill).checkInvoiceType(new BillCheckProcessDto(Boolean.valueOf(1 == bill.getAutoInvoice()), bill.getAutoInvoice() == 1));
        }
        catch (MsgException e) {
            return ResponseVo.fail((String)e.getErrorCode(), (String)e.getErrorMsg());
        }
        String invoiceType = bill.getInvoiceType();
        if (InvoiceUtils.isAllEInvoice((Object)invoiceType) || "1".equals(bill.getIsElePaper())) {
            if (String.valueOf(bill.getRemark()).length() > 450) {
                if (!InvoiceUtils.isCutRemark((Long)bill.getOrgId())) return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u53d1\u7968\u5907\u6ce8\u8d85\u8fc7\u53d1\u7968\u53ef\u5f00\u5177\u6700\u5927\u957f\u5ea6[%2$s]\u5b57\u7b26", (String)"BillValidResultController_1", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), 450));
                billRemark = InvoiceUtils.cutRemarkChar((String)bill.getRemark(), (int)450);
                bill.setRemark(billRemark);
            }
        } else if (GBKUtils.getGBKLength((String)bill.getRemark()) > 230) {
            if (!InvoiceUtils.isCutRemark((Long)bill.getOrgId())) return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u53d1\u7968\u5907\u6ce8\u8d85\u8fc7\u53d1\u7968\u53ef\u5f00\u5177\u6700\u5927\u957f\u5ea6[%2$s]\u5b57\u8282", (String)"BillValidResultController_2", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo(), 230));
            billRemark = GBKUtils.cutGBKString((String)bill.getRemark(), (int)230);
            bill.setRemark(billRemark);
        }
        String issueCacheKey = CacheHelper.get((String)(DynamicObjectUtil.getDynamicObjectLongValue((Object)billDB.get("orgid")) + "!!!" + billDB.getString("billno")));
        String processCacheKey = CacheHelper.get((String)(billDB.getPkValue() + "workbench"));
        if (StringUtils.isNotBlank((CharSequence)issueCacheKey) || StringUtils.isNotBlank((CharSequence)processCacheKey)) {
            return ResponseVo.fail((ApiErrCodeEnum)ApiErrCodeEnum.BILL_WITHDRAW_PROCESS_NULL);
        }
        if ("0".equals(billDB.getString("confirmstate"))) {
            DynamicObject[] relationObjs = BillValidResultController.loadRelationByBill(billDB);
            if (relationObjs.length == 0) {
                Object pkValue = billDB.getPkValue();
                CacheHelper.put((String)("sim_repeat_push_bill_id_" + bill.getBillNo()), (String)pkValue.toString());
                DeleteServiceHelper.delete((String)"sim_original_bill", (QFilter[])qFilter.toArray());
                return ApiResult.success((Object)"");
            }
            DynamicObject[] invObjList = RelationHelper.loadInvoiceByRelation((DynamicObject[])relationObjs);
            List<DynamicObject> invList = BillValidResultController.checkInvObjList(invObjList);
            if (CollectionUtils.isEmpty(invList)) {
                ApiResult checkPhoneResult = BillValidaterHelper.checkPhoneAndEmail(bill, ValidTypeEnum.BILL);
                if (checkPhoneResult != null) {
                    return checkPhoneResult;
                }
                BillValidResultController.updateBill(bill, billDB);
                BillValidResultController.updateDetail(bill, billDB);
                return ApiResult.success((Object)billDB);
            }
            if (1 == bill.getAutoInvoice()) {
                return BillValidResultController.pushAutoInvoice(billDB, invList);
            }
            ImcSaveServiceHelper.update((DynamicObject)billDB);
            return ResponseVo.success((String)ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\u63a8\u9001\u6210\u529f", (String)"BillValidResultController_3", (String)"imc-sim-service", (Object[])new Object[0]), null);
        }
        if (0 == bill.getAutoInvoice()) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u5df2\u5b58\u5728", (String)"BillValidResultController_0", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
        }
        DynamicObject[] relationObjs = BillValidResultController.loadRelationByBill(billDB);
        if (relationObjs.length == 0) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u5df2\u5b58\u5728", (String)"BillValidResultController_0", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
        }
        DynamicObject[] redConfirmBillList = RelationHelper.loadRedConfirmByRelation((DynamicObject[])relationObjs);
        DynamicObject[] invObjList = RelationHelper.loadInvoiceByRelation((DynamicObject[])relationObjs);
        List<DynamicObject> invList = BillValidResultController.checkInvObjList(invObjList);
        if (!CollectionUtils.isEmpty(invList)) return BillValidResultController.pushAutoInvoice(billDB, invList);
        if (billDB.getInt("billproperties") != -1 || redConfirmBillList.length <= 0) return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u5df2\u5b58\u5728", (String)"BillValidResultController_0", (String)"imc-sim-service", (Object[])new Object[0]), bill.getBillNo()));
        for (DynamicObject redConfirmBill : redConfirmBillList) {
            ApiResult submitResult;
            if ((StringUtils.isEmpty((CharSequence)redConfirmBill.getString("number")) || RedConfirmStatusEnum.validConfirmStatus.contains((Object)redConfirmBill.getString("confirmstatus"))) && (submitResult = RedConfirmBillHelper.submit(redConfirmBill)) != null) {
                return ResponseVo.fail((String)submitResult.getErrorCode(), (String)String.format(ResManager.loadKDString((String)"\u539f\u84dd\u7968\u7ea2\u51b2\u751f\u6210\u7ea2\u5b57\u786e\u8ba4\u5355\u51fa\u9519\uff1a%s", (String)"RedConfirmBillHelper_8", (String)"imc-sim-service", (Object[])new Object[0]), submitResult.getMessage()));
            }
            DynamicObject waitInvoice = RedConfirmBillHelper.createWaitInvoice(redConfirmBill);
            waitInvoice.set("orgid", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)billDB.get("orgid")));
            waitInvoice.set("buyertype", (Object)"4");
            waitInvoice.set("issuebillstatus", (Object)BillStatusEnum.NO_APPROVAL_REQUIRED.getCode());
            ArrayList<DynamicObject> copyList = new ArrayList<DynamicObject>();
            copyList.add(waitInvoice);
            DynamicObject[] bills = new DynamicObject[]{billDB};
            IssueInvoiceControlHelper.copySpecialInfoAndExtraInfo(copyList, bills);
            ImcSaveServiceHelper.save((DynamicObject)waitInvoice);
            invList.add(waitInvoice);
        }
        return BillValidResultController.pushAutoInvoice(billDB, invList);
    }

    private static void updateDetail(BillVo bill, DynamicObject billDB) {
        DynamicObjectCollection dynamicObjectCollection = billDB.getDynamicObjectCollection("sim_original_bill_item");
        Map<String, DynamicObject> detailMap = dynamicObjectCollection.stream().collect(Collectors.toMap(k -> k.getString("billsourceid"), v -> v, (v1, v2) -> v1));
        List billDetail = bill.getBillDetail();
        for (int i = 0; i < billDetail.size(); ++i) {
            DynamicObject detail;
            BillDetailVo detailVo = (BillDetailVo)billDetail.get(i);
            if (!StringUtils.isNotBlank((CharSequence)detailVo.getBillSourceId()) || null == (detail = detailMap.get(detailVo.getBillSourceId()))) continue;
            DynamicObject issueInvSetting = IssueInvSettingHelper.getIssueInvSetting((Long)bill.getOrgId());
            BillValidaterHelper.checkSpecificationAndUnitAndRemark(bill, i, issueInvSetting, detailVo);
            detail.set("unit", (Object)detailVo.getUnits());
            detail.set("specification", (Object)detailVo.getSpecification());
            detail.set("remark", (Object)detailVo.getLineRemark());
        }
    }

    private static void updateBill(BillVo bill, DynamicObject billDB) {
        billDB.set("buyername", (Object)bill.getBuyerName());
        billDB.set("buyeremail", (Object)bill.getBuyerRecipientMail());
        billDB.set("buyerphone", (Object)bill.getBuyerRecipientPhone());
        billDB.set("buyerbank", (Object)bill.getBuyerBankAndAccount());
        billDB.set("buyeraddr", (Object)bill.getBuyerAddressAndTel());
        billDB.set("billremark", (Object)bill.getNote());
        billDB.set("buyertaxno", (Object)bill.getBuyerTaxpayerId());
        billDB.set("invoicetype", (Object)bill.getInvoiceType());
        billDB.set("invoiceremark", (Object)bill.getRemark());
    }

    private static ApiResult pushAutoInvoice(DynamicObject billDB, List<DynamicObject> invList) {
        IssueInvoiceMqHelper.submitInvoice2MQ((DynamicObject[])invList.toArray(new DynamicObject[0]));
        billDB.set("confirmstate", (Object)"2");
        SaveServiceHelper.update((DynamicObject)billDB);
        return ResponseVo.success((String)ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\u63a8\u9001\u6210\u529f", (String)"BillValidResultController_3", (String)"imc-sim-service", (Object[])new Object[0]), null);
    }

    private static List<DynamicObject> checkInvObjList(DynamicObject[] invObjList) {
        ArrayList<DynamicObject> invoiceList = new ArrayList<DynamicObject>(8);
        for (DynamicObject invoiceDynamicObject : invObjList) {
            if (!IssueStatusEnum.none.getCode().equals(invoiceDynamicObject.getString("issuestatus")) && !IssueStatusEnum.failed.getCode().equals(invoiceDynamicObject.getString("issuestatus"))) continue;
            invoiceList.add(invoiceDynamicObject);
        }
        return invoiceList;
    }

    public static void setOldPk(DynamicObject dynamicBill) {
        String billNO = dynamicBill.getString("billno");
        String oldPk = CacheHelper.get((String)("sim_repeat_push_bill_id_" + billNO));
        if (StringUtils.isNotBlank((CharSequence)oldPk)) {
            dynamicBill.set("id", (Object)Long.parseLong(oldPk));
            CacheHelper.remove((String)("sim_repeat_push_bill_id_" + billNO));
        }
    }
}

