/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.splitMerge.split.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.imc.bdm.common.dto.split.SplitRequestDTO;
import kd.imc.bdm.common.dto.split.SplitResponseDTO;
import kd.imc.bdm.common.helper.ExtraInfoHelper;
import kd.imc.sim.common.utils.TaxCalcUtil;
import kd.imc.sim.formplugin.bill.splitMerge.split.impl.AbstractSplitQuantityService;
import kd.imc.sim.formplugin.bill.splitMerge.split.impl.NoSplitServiceImpl;

public class DeductionSplitServiceImpl
extends AbstractSplitQuantityService {
    public boolean support(SplitRequestDTO splitRequest) {
        return "imc_deduction_split".equals(splitRequest.getRuleCode());
    }

    public SplitResponseDTO split(SplitRequestDTO splitRequestDTO) {
        ArrayList invoices = new ArrayList(1);
        DynamicObject bill = splitRequestDTO.getBill();
        BigDecimal limitAmount = this.checkLimit(splitRequestDTO.getLimitAmounts(), bill);
        if (bill.getBigDecimal("invoiceamount").compareTo(limitAmount) <= 0) {
            return new NoSplitServiceImpl().split(splitRequestDTO);
        }
        int quantity = bill.getBigDecimal("invoiceamount").divide(limitAmount, 0, 0).intValue();
        splitRequestDTO.setNum(Integer.valueOf(quantity));
        splitRequestDTO.setFixedNumber(Boolean.TRUE);
        this.createInvoices(splitRequestDTO, bill, invoices);
        DynamicObjectCollection billItems = bill.getDynamicObjectCollection("sim_original_bill_item");
        BigDecimal scale = limitAmount.divide(bill.getBigDecimal("invoiceamount"), 100, 1);
        BigDecimal deduction = bill.getBigDecimal("deduction").multiply(scale).setScale(2, 4);
        BigDecimal deductionSum = BigDecimal.ZERO;
        int billItemLen = billItems.size();
        for (int billItemIndex = 0; billItemIndex < billItemLen; ++billItemIndex) {
            DynamicObject billItem = (DynamicObject)billItems.get(billItemIndex);
            BigDecimal invoiceItemAmount = billItem.getBigDecimal("remainvalidamount").subtract(billItem.getBigDecimal("remainvalidtax")).multiply(scale).setScale(2, 4);
            BigDecimal amountSum = BigDecimal.ZERO;
            BigDecimal taxSum = BigDecimal.ZERO;
            for (int numIndex = 0; numIndex < quantity; ++numIndex) {
                DynamicObject invoice = (DynamicObject)invoices.get(numIndex);
                if (numIndex == quantity - 1) {
                    invoiceItemAmount = billItem.getBigDecimal("remainvalidamount").subtract(billItem.getBigDecimal("remainvalidtax")).subtract(amountSum);
                }
                DynamicObjectCollection invoiceItems = ((DynamicObject)invoices.get(numIndex)).getDynamicObjectCollection("items");
                DynamicObject invoiceItem = invoiceItems.addNew();
                this.createInvoiceItem(billItem, invoiceItem, scale, splitRequestDTO, true);
                if (billItemIndex == 0) {
                    if (numIndex == quantity - 1) {
                        deduction = bill.getBigDecimal("deduction").subtract(deductionSum);
                    }
                    invoice.set("deduction", (Object)deduction);
                    deductionSum = deductionSum.add(deduction);
                    invoice.set("remark", (Object)this.replaceDeductionRemark(bill, invoice));
                } else if ("1".equals(invoiceItem.getString("rowtype"))) {
                    ((DynamicObject)invoiceItems.get(billItemIndex - 1)).set("rowtype", (Object)"2");
                }
                invoiceItem.set("amount", (Object)invoiceItemAmount);
                if ("2".equals(billItem.getString("rowtype"))) {
                    invoiceItem.set("tax", (Object)TaxCalcUtil.calTax((BigDecimal)invoiceItemAmount, (BigDecimal)invoice.getBigDecimal("deduction"), (String)invoiceItem.getString("taxrate"), (boolean)false));
                } else {
                    invoiceItem.set("tax", (Object)TaxCalcUtil.calTax((BigDecimal)invoiceItemAmount, (BigDecimal)BigDecimal.ZERO, (String)invoiceItem.getString("taxrate"), (boolean)false));
                }
                invoiceItem.set("taxamount", (Object)invoiceItem.getBigDecimal("amount").add(invoiceItem.getBigDecimal("tax")));
                this.calcPriceAndFillAmount(invoiceItem, false);
                amountSum = amountSum.add(invoiceItem.getBigDecimal("amount"));
                taxSum = taxSum.add(invoiceItem.getBigDecimal("tax"));
            }
            this.adjustmentTaxDiff(amountSum.add(taxSum), taxSum, billItem, invoices, billItemIndex);
        }
        this.calcInvoiceHeadAmount(invoices);
        ExtraInfoHelper.copyExtraInfo(invoices, (SplitRequestDTO)splitRequestDTO);
        return new SplitResponseDTO(invoices, this.createBillInvoiceRelation(quantity, bill, invoices));
    }

    private String replaceDeductionRemark(DynamicObject bill, DynamicObject invoice) {
        String oriDeducRemark = String.format("\u5dee\u989d\u5f81\u7a0e\uff1a%s\u3002", bill.getBigDecimal("deduction").setScale(2, 4));
        String invDeducRemark = String.format("\u5dee\u989d\u5f81\u7a0e\uff1a%s\u3002", invoice.getBigDecimal("deduction").setScale(2, 4));
        String invoiceRemark = invoice.getString("remark");
        if (invoiceRemark.contains(oriDeducRemark)) {
            return invoice.getString("remark").replace(oriDeducRemark, invDeducRemark);
        }
        return invDeducRemark + invoice.getString("remark");
    }
}

