/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.splitMerge.split.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.imc.bdm.common.dto.split.SplitRequestDTO;
import kd.imc.bdm.common.dto.split.SplitResponseDTO;
import kd.imc.bdm.common.helper.ExtraInfoHelper;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.sim.formplugin.bill.splitMerge.split.impl.AbstractSplitQuantityService;
import kd.imc.sim.formplugin.bill.splitMerge.split.impl.SplitByRuleServiceImpl;

public class SplitByInvoiceQuantityServiceImpl
extends AbstractSplitQuantityService {
    public boolean support(SplitRequestDTO splitReques) {
        return "imc_split_by_invoice_quantity".equals(splitReques.getRuleCode());
    }

    public SplitResponseDTO split(SplitRequestDTO configDto) {
        this.checkBill(configDto);
        DynamicObject bill = configDto.getBill();
        String invoiceType = bill.getString("invoicetype");
        String isElePaper = bill.getString("iselepaper");
        boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)invoiceType) || "1".equals(isElePaper);
        ArrayList invoices = new ArrayList(configDto.getNum());
        this.createInvoices(configDto, bill, invoices);
        DynamicObjectCollection billItems = bill.getDynamicObjectCollection("sim_original_bill_item");
        BigDecimal bigNum = new BigDecimal(configDto.getNum());
        int len = billItems.size();
        for (int billItemIndex = 0; billItemIndex < len; ++billItemIndex) {
            DynamicObject billItem = (DynamicObject)billItems.get(billItemIndex);
            BigDecimal taxAmountSum = BigDecimal.ZERO;
            BigDecimal taxSum = BigDecimal.ZERO;
            for (int numIndex = 0; numIndex < configDto.getNum(); ++numIndex) {
                DynamicObjectCollection invoiceItems = ((DynamicObject)invoices.get(numIndex)).getDynamicObjectCollection("items");
                DynamicObject invoiceItem = invoiceItems.addNew();
                this.createInvoiceItem(billItem, invoiceItem, bigNum, configDto, false);
                if (!configDto.getFixedNumber().booleanValue() && numIndex == configDto.getNum() - 1) {
                    BigDecimal splitNum = this.getSplitNum(billItem, configDto);
                    invoiceItem.set("num", (Object)billItem.getBigDecimal("remainvalidnum").subtract(splitNum.multiply(new BigDecimal(configDto.getNum() - 1))));
                    SplitByRuleServiceImpl.calcPrice(invoiceItem, isAllEle);
                }
                if (billItemIndex != 0 && "1".equals(invoiceItem.getString("rowtype"))) {
                    ((DynamicObject)invoiceItems.get(billItemIndex - 1)).set("rowtype", (Object)"2");
                }
                taxAmountSum = taxAmountSum.add(invoiceItem.getBigDecimal("taxamount"));
                taxSum = taxSum.add(invoiceItem.getBigDecimal("tax"));
            }
            this.adjustmentTaxDiff(taxAmountSum, taxSum, billItem, invoices, billItemIndex);
        }
        this.calcInvoiceHeadAmount(invoices);
        ExtraInfoHelper.copyExtraInfo(invoices, (SplitRequestDTO)configDto);
        return new SplitResponseDTO(invoices, this.createBillInvoiceRelation(configDto.getNum(), bill, invoices));
    }

    private void checkBill(SplitRequestDTO configDto) {
        DynamicObject bill = configDto.getBill();
        if (bill == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"SplitByInvoiceQuantityServiceImpl_0", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        DynamicObjectCollection items = configDto.getBill().getDynamicObjectCollection("sim_original_bill_item");
        boolean isTax = "1".equals(configDto.getBill().getString("hsbz"));
        BigDecimal amountSum = BigDecimal.ZERO;
        for (DynamicObject item : items) {
            BigDecimal amount = item.getBigDecimal("remainvalidamount");
            if (isTax) {
                amount = amount.subtract(item.getBigDecimal("remainvalidtax"));
            }
            amountSum = amountSum.add(amount);
        }
        BigDecimal limitAmount = this.checkLimit(configDto.getLimitAmounts(), bill);
        if (amountSum.divide(new BigDecimal(configDto.getNum()), 0, 2).compareTo(limitAmount) > 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u62c6\u5206\u53d1\u7968\u7684\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u9650\u989d%1$s", (String)"SplitByInvoiceQuantityServiceImpl_2", (String)"imc-sim-service", (Object[])new Object[0]), limitAmount.setScale(2, 4)));
        }
    }
}

