/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.billcenter.convert;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.helper.DrawerStrategyHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.cache.TaxClassCodeCheckHelper;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.TaxRateUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.UUID;
import kd.imc.sim.common.helper.BillValidaterHelper;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.utils.AllEleLqAddressSplitUtil;
import kd.imc.sim.formplugin.match.BillMatchHelper;
import kd.imc.sim.formplugin.match.ConditionMatchHelper;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractIsomerismBill2OriginalBillConvertPlugin
extends AbstractConvertPlugIn {
    private static Log log = LogFactory.getLog(AbstractIsomerismBill2OriginalBillConvertPlugin.class);

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        e.addSrcField("sim_isomerism_item_data.id");
        e.addSrcField("sim_isomerism_item_data.tax_rate");
        e.addSrcField("id");
    }

    protected void fillinItem(AfterConvertEventArgs e) {
        ExtendedDataEntity[] itemExtendedDataEntities;
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        for (ExtendedDataEntity itemExtendedDataEntity : itemExtendedDataEntities = entitySet.FindByEntityKey("sim_original_bill_item")) {
            DynamicObject item = itemExtendedDataEntity.getDataEntity();
            List sourceBillRows = (List)itemExtendedDataEntity.getValue("ConvertSource");
            DynamicObject sourceItem = (DynamicObject)sourceBillRows.get(0);
            BigDecimal taxRate = (BigDecimal)((DynamicProperty)e.getFldProperties().get("sim_isomerism_item_data.tax_rate")).getValue((Object)sourceItem);
            item.set("taxrate", (Object)TaxRateUtil.convertTaxRate((String)taxRate.stripTrailingZeros().toPlainString()));
        }
    }

    protected void fillInBill(AfterConvertEventArgs e, Map<Long, List<DynamicObject>> orgBillMaps, Set<String> taxNoSet) {
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entities = entitySet.FindByEntityKey(this.getTgtMainType().getName());
        HashMap<Long, SaleInfo> orgSaleInfoMap = new HashMap<Long, SaleInfo>(entities.length);
        for (ExtendedDataEntity entity : entities) {
            DynamicObject originalBill = entity.getDataEntity();
            originalBill.set("originbillseq", (Object)("100_" + UUID.getBatchNumber() + "_0001"));
            this.fillInSalerInfo(orgSaleInfoMap, originalBill);
            taxNoSet.add(originalBill.getString("salertaxno"));
            boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)originalBill.getString("invoicetype")) || "1".equals(originalBill.getString("iselepaper"));
            HashMap<String, Integer> countMap = new HashMap<String, Integer>(8);
            DynamicObjectCollection items = originalBill.getDynamicObjectCollection("sim_original_bill_item");
            for (DynamicObject item : items) {
                this.fillInGoodInfos(originalBill, item);
                item.set("unitprice", (Object)PriceHelper.calcPriceOrNum((BigDecimal)item.getBigDecimal("amount"), (BigDecimal)item.getBigDecimal("num"), (boolean)isAllEle));
                String extrafield2 = item.getString("extrafield2");
                if (StringUtils.isBlank((CharSequence)extrafield2)) {
                    extrafield2 = "02";
                }
                if (countMap.containsKey(extrafield2)) {
                    countMap.put(extrafield2, (Integer)countMap.get(extrafield2) + 1);
                    continue;
                }
                countMap.put(extrafield2, 1);
            }
            String switch_cfg = ImcConfigUtil.getValue((String)CacheKeyEnum.APPROVAL_WORK_FLOW_SWITCH.getConfigType(), (String)CacheKeyEnum.APPROVAL_WORK_FLOW_SWITCH.getConfigKey());
            if (StringUtils.isNotBlank((CharSequence)switch_cfg) && "Y".equals(switch_cfg)) {
                int normalInvoiceCount;
                int specialInvoiceCount = countMap.containsKey("01") ? (Integer)countMap.get("01") : 0;
                int n = normalInvoiceCount = countMap.containsKey("02") ? (Integer)countMap.get("02") : 0;
                if (specialInvoiceCount == items.size()) {
                    originalBill.set("invoicetype", (Object)InvoiceType.ALL_E_SPECIAL.getTypeCode());
                }
                if (normalInvoiceCount == items.size()) {
                    originalBill.set("invoicetype", (Object)InvoiceType.ALL_E_NORMAL.getTypeCode());
                }
            }
            List list = orgBillMaps.computeIfAbsent(DynamicObjectUtil.getDynamicObjectLongValue((Object)originalBill.get("orgid")), k -> new ArrayList());
            list.add(originalBill);
        }
    }

    private void fillInSalerInfo(Map<Long, SaleInfo> salerInfoMap, DynamicObject originalBill) {
        long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)originalBill.get("orgid"));
        SaleInfo saleInfo = salerInfoMap.get(orgId);
        if (saleInfo == null && (saleInfo = TaxUtils.getSaleInfoByOrg((Long)orgId)) == null) {
            saleInfo = new SaleInfo();
        }
        salerInfoMap.put(orgId, saleInfo);
        originalBill.set("salername", (Object)saleInfo.getSaleName());
        originalBill.set("salertaxno", (Object)saleInfo.getSaleTaxNo());
        if (StringUtils.isBlank((CharSequence)originalBill.getString("jqbh"))) {
            originalBill.set("jqbh", (Object)saleInfo.getDefaultDev());
        }
    }

    private void fillInGoodInfos(DynamicObject bill, DynamicObject item) {
        DynamicObject taxClassCode;
        String revenueCode;
        String goodsCode = item.getString("spbm");
        if (StringUtils.isNotBlank((CharSequence)goodsCode)) {
            String extrafield = item.getString("extrafield");
            long orgId = StringUtils.isNotBlank((CharSequence)extrafield) ? Long.parseLong(extrafield) : DynamicObjectUtil.getDynamicObjectLongValue((Object)bill.get("orgid"));
            String systemCode = item.getString("extrafield3");
            if (StringUtils.isBlank((CharSequence)systemCode)) {
                systemCode = bill.getString("textfield1");
            }
            if (log.isInfoEnabled()) {
                log.info(String.format("\u5f53\u524d\u5339\u914d\u884c\u7684\u5546\u54c1\u540d\u79f0\u4e3a[%s]\uff0c\u5f00\u7968\u9879\u7f16\u7801\u4e3a[%s]\uff0c\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e3a[%s]\uff0c\u7ec4\u7ec7\u4e3a[%s]\uff0c\u7cfb\u7edf\u7f16\u7801[%s]", item.getString("goodsname"), goodsCode, item.getString("goodscode"), orgId, systemCode));
            }
            DynamicObject goodsInfo = null;
            Map goodsInfoMap = BusinessDataServiceHelper.loadFromCache((String)"bdm_goods_info", (String)String.join((CharSequence)",", "id", "name", "unit", "specifications", "taxcode", "privilegeflag", "privilegetype", "filter_tag"), (QFilter[])ImcBaseDataHelper.getGoodsInfoFilter((Object)orgId).and("number", "=", (Object)goodsCode).toArray(), (String)"priority asc");
            Collection goodsInfos = goodsInfoMap.values();
            for (DynamicObject info : goodsInfos) {
                String filterStr;
                DynamicObject goodsInfoObject = BusinessDataServiceHelper.loadSingle((Object)info.getLong("id"), (String)"bdm_goods_info");
                if (goodsInfoObject != null && (info = this.dealMatchGoodsInfoMethod(goodsInfoObject, systemCode, info)) == null || !ConditionMatchHelper.verify((String)(filterStr = info.getString("filter_tag")), (DynamicObject)bill)) continue;
                if (log.isInfoEnabled()) {
                    log.info(String.format("\u5f00\u7968\u9879\u7f16\u7801\u5339\u914d\u5230\u5f00\u7968\u9879\u76ee\uff0c\u5f00\u7968\u9879\u7f16\u7801\u4e3a[%s],\u5f00\u7968\u9879id\u4e3a[%s],\u7b56\u7565\u6761\u4ef6\u662f[%s]", goodsCode, info.getPkValue(), filterStr));
                }
                goodsInfo = info;
                break;
            }
            if (goodsInfo == null) {
                if (log.isInfoEnabled()) {
                    log.info(String.format("\u5f00\u7968\u9879\u7f16\u7801\u672a\u5339\u914d\u5230\u5f00\u7968\u9879\uff0c\u5f00\u7968\u9879\u7f16\u7801\u4e3a[%s],\u7ec4\u7ec7id\u4e3a[%s]", goodsCode, orgId));
                }
                goodsInfo = BusinessDataServiceHelper.newDynamicObject((String)"bdm_goods_info");
            }
            item.set("goodsid", goodsInfo);
            if (StringUtils.isBlank((CharSequence)item.getString("goodsname"))) {
                item.set("goodsname", (Object)goodsInfo.getString("name"));
            }
            if (StringUtils.isBlank((CharSequence)item.getString("unit"))) {
                item.set("unit", (Object)goodsInfo.getString("unit"));
            }
            if (StringUtils.isBlank((CharSequence)item.getString("specification"))) {
                item.set("specification", (Object)goodsInfo.getString("specifications"));
            }
            if (StringUtils.isBlank((CharSequence)item.getString("goodscode"))) {
                DynamicObject taxCode = goodsInfo.getDynamicObject("taxcode");
                item.set("goodscode", (Object)(taxCode != null ? taxCode.getString("mergecode") : ""));
            }
            if (StringUtils.isBlank((CharSequence)item.getString("policylogo"))) {
                item.set("policylogo", (Object)goodsInfo.getString("privilegeflag"));
            }
            if (StringUtils.isBlank((CharSequence)item.getString("policycontants"))) {
                item.set("policycontants", (Object)goodsInfo.getString("privilegetype"));
            }
        }
        if (StringUtils.isBlank((CharSequence)(revenueCode = item.getString("goodscode")))) {
            return;
        }
        item.set("goodscode", this.fillInTaxCode(revenueCode));
        if (log.isInfoEnabled()) {
            log.info(String.format("\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e0d\u4e3a\u7a7a\uff0c\u5f00\u59cb\u8fdb\u884c\u8865\u5145\u7b80\u79f0\uff0c\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e3a[%s]", revenueCode));
        }
        if ((taxClassCode = TaxClassCodeCheckHelper.geTaxCode((String)item.getString("goodscode"))) == null) {
            return;
        }
        item.set("taxratecodeid", (Object)taxClassCode);
        if (StringUtils.isBlank((CharSequence)item.getString("goodssimplename"))) {
            if (log.isInfoEnabled()) {
                log.info("\u67e5\u8be2\u5230\u7b80\u79f0:{},\u8fdb\u884c\u8865\u5145!", (Object)taxClassCode.getString("simplename"));
            }
            item.set("goodssimplename", (Object)taxClassCode.getString("simplename"));
        }
    }

    private DynamicObject dealMatchGoodsInfoMethod(DynamicObject goodsInfoObject, String systemCode, DynamicObject info) {
        boolean hasField = DynamicObjectUtil.checkDynamicObjectHasField((DynamicObject)goodsInfoObject, (String)"lbsv_system_code");
        if (hasField) {
            String lbsv_system_code = goodsInfoObject.getString("lbsv_system_code");
            log.info("\u8d26\u5355\u4e2d\u5fc3\u4e0b\u63a8\u5f00\u7968\u7533\u8bf7\u5355\uff0c\u5339\u914d\u5f00\u7968\u9879\u5904\u7406\uff0csystemCode:{}, lbsv_system_code:{}", (Object)systemCode, (Object)lbsv_system_code);
            if (StringUtils.isEmpty((CharSequence)systemCode)) {
                String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u5355\u4e2d\u5fc3\u8ba2\u5355\u6570\u636e\u4e0b\u63a8\u5f00\u7968\u7533\u8bf7\u5355\uff0c\u7cfb\u7edf\u7f16\u7801\u4e3a\u7a7a\uff01", (String)"IsomerismBill2OriginalPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]);
                throw new KDBizException(errorMsg);
            }
            if (StringUtils.isEmpty((CharSequence)lbsv_system_code)) {
                String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u5339\u914d\u5230\u5f00\u7968\u9879\u914d\u7f6e\u6570\u636e\uff0c\u7cfb\u7edf\u7f16\u7801\u5b57\u6bb5\u4e3a\u7a7a\uff01", (String)"IsomerismBill2OriginalPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]);
                throw new KDBizException(errorMsg);
            }
            if (lbsv_system_code.equals(systemCode)) {
                return goodsInfoObject;
            }
            return null;
        }
        return info;
    }

    private Object fillInTaxCode(String mergeCode) {
        int length = mergeCode.length();
        if (length >= 19) {
            return mergeCode;
        }
        StringBuilder mergeCodeSb = new StringBuilder(mergeCode);
        for (int i = 0; i < 19 - length; ++i) {
            mergeCodeSb.append('0');
        }
        if (log.isInfoEnabled()) {
            log.info(String.format("\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e0d\u4e3a\u7a7a\uff0c\u5f00\u59cb\u8fdb\u884c\u88650\u64cd\u4f5c\uff0c\u539f\u7a0e\u6536\u5206\u7c7b\u7f16\u7801[%s],\u8865\u5168\u540e\u7684\u7a0e\u6536\u5206\u7c7b\u7f16\u7801[%s]", mergeCode, mergeCodeSb.toString()));
        }
        return mergeCodeSb.toString();
    }

    protected void matchBill(Map<Long, List<DynamicObject>> orgBillMaps, Set<String> taxNoSet) {
        BillMatchHelper billMatchHelper = new BillMatchHelper();
        DynamicObject defaultDrawerStrategy = BusinessDataServiceHelper.newDynamicObject((String)"bdm_drawer_strategy");
        defaultDrawerStrategy.set("drawerstrategy", (Object)"1,1,1");
        Map<Object, List<DynamicObject>> settingByTaxNo = BillValidaterHelper.getSettingByTaxNo(taxNoSet);
        Set<Map.Entry<Long, List<DynamicObject>>> entries = orgBillMaps.entrySet();
        for (Map.Entry<Long, List<DynamicObject>> entry : entries) {
            billMatchHelper.matchSplitOrMergeRule(entry.getKey(), entry.getValue(), "2");
            DynamicObject[] drawerStrategyArr = DrawerStrategyHelper.queryDrawerStrategyByOrg((Long)entry.getKey());
            for (DynamicObject originalBill : entry.getValue()) {
                List settings = settingByTaxNo.getOrDefault(originalBill.getString("salertaxno"), new ArrayList(1));
                billMatchHelper.matchSalerAddrAndBank(originalBill, settings.toArray(new DynamicObject[0]));
                billMatchHelper.matchDrawer(originalBill, drawerStrategyArr, defaultDrawerStrategy);
            }
        }
    }

    protected void convertEatateLease(Map<Long, List<DynamicObject>> orgBillMaps) {
        try {
            Set<Map.Entry<Long, List<DynamicObject>>> entries = orgBillMaps.entrySet();
            for (Map.Entry<Long, List<DynamicObject>> entry : entries) {
                for (DynamicObject originalBill : entry.getValue()) {
                    DynamicObjectCollection sales;
                    if (!"E06".equals(originalBill.getString("specialtype")) || !CollectionUtils.isEmpty((Collection)(sales = originalBill.getDynamicObjectCollection("estatesales")))) continue;
                    DynamicObject dynamicObject = sales.addNew();
                    DynamicObject simpleAddressObj = originalBill.getDynamicObject("simpleaddress");
                    Map adrressMap = AllEleLqAddressSplitUtil.split((String)simpleAddressObj.getString("name"));
                    dynamicObject.set("saleestateid", (Object)originalBill.getString("estateid"));
                    dynamicObject.set("saleprincename", adrressMap.get("province"));
                    dynamicObject.set("salecityname", adrressMap.get("city"));
                    dynamicObject.set("saledetailaddress", (Object)originalBill.getString("detailaddress"));
                    dynamicObject.set("salecrosscitysign", (Object)originalBill.getString("crosscitysign"));
                    dynamicObject.set("saleunit", (Object)originalBill.getString("areaunit"));
                    dynamicObject.set("leasestartdate", (Object)originalBill.getDate("startleasedate"));
                    dynamicObject.set("leaseenddate", (Object)originalBill.getDate("endleasedate"));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

