/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.invoicebatch;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.model.RowValue;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.MD5;
import kd.imc.bdm.common.util.TaxRateUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.UUID;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.model.invoice.TaxedTypeEnum;
import kd.imc.sim.common.service.IssueInvoiceService;
import kd.imc.sim.common.service.WideInvoiceSevice;
import kd.imc.sim.common.utils.MD5Util;
import kd.imc.sim.formplugin.invoicebatch.TaxInvoiceParseHelper;
import kd.imc.sim.formplugin.issuing.dataimport.HistoryInvoiceDataImportService;

public class TaxInvoiceImportUtil {
    private static final Log LOGGER = LogFactory.getLog(TaxInvoiceImportUtil.class);
    private String INVOICE_SHEET = "INVOICE";
    private String DETAIL_SHEET = "DETAIL";
    private String[] UPDATE_FIELD = new String[]{"invoicetype", "invoicestatus", "issuetime"};
    private Map<String, Long> orgMap = null;
    private Set<String> invoiceTypeSet = new HashSet<String>(8);

    public void insertDataImport(String path, String fileName) {
        QFilter filter3;
        QFilter filter2;
        JSONObject fileInfo = this.getFileHashByUrl(path);
        QFilter filter1 = new QFilter("filehash", "=", (Object)fileInfo.getString("fileHash"));
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"sim_his_inv_data_import", (String)"id,billno", (QFilter[])new QFilter[]{filter1, filter2 = new QFilter("datatype", "=", (Object)"1"), filter3 = new QFilter("executionstatus", "in", (Object)new String[]{"0", "2"})});
        if (collect != null && collect.size() > 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5df2\u7ecf\u4e0a\u4f20\u4e86\u76f8\u540c\u7684\u6587\u4ef6\uff0c\u6279\u6b21\u53f7%1$s\uff0c\u8bf7\u68c0\u67e5", (String)"TaxInvoiceImportUtil_8", (String)"imc-sim-service", (Object[])new Object[0]), ((DynamicObject)collect.get(0)).getString("billno")));
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_his_inv_data_import");
        HistoryInvoiceDataImportService.setBaseData(dynamicObject, "1", "", "2", null);
        dynamicObject.set("filehash", (Object)fileInfo.getString("fileHash"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        ArrayList attachmentDataList = new ArrayList(1);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", fileName);
        map.put("size", fileInfo.getLong("size"));
        map.put("url", path);
        map.put("uploadTime", new Date());
        map.put("entityNum", "sim_his_inv_data_import");
        map.put("createtime", new Date());
        map.put("uid", dynamicObject.getString("billno"));
        attachmentDataList.add(map);
        AttachmentServiceHelper.upload((String)"sim_his_inv_data_import", (Object)dynamicObject.getPkValue(), (String)"attachmentpanel", attachmentDataList);
    }

    private JSONObject getFileHashByUrl(String path) {
        int maxMb = this.getMaxMb(null);
        int maxbyte = maxMb * 1024 * 1024;
        JSONObject file = new JSONObject();
        FileService service = FileServiceFactory.getAttachmentFileService();
        try (InputStream inputStream = service.getInputStream(path);){
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                byte[] buffer = new byte[1024];
                int len = 0;
                int total = 0;
                while ((len = inputStream.read(buffer)) != -1) {
                    bos.write(buffer, 0, len);
                    if ((total += len) <= maxbyte) continue;
                    throw new KDException(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u6700\u5927\u6587\u4ef6(%1$sMB)\u9650\u5236", (String)"TaxInvoiceParseHelper_1", (String)"imc-sim-service", (Object[])new Object[0]), maxMb));
                }
                bos.flush();
                file.put("fileHash", (Object)MD5Util.md5Hex((byte[])bos.toByteArray()));
                file.put("size", (Object)total);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file;
    }

    public JSONObject parseTaxFile(AbstractFormPlugin formPlugin, String filepath, String fileName) {
        LOGGER.info("\u9500\u9879\u7a0e\u5c40\u6587\u4ef6\u5bfc\u5165\uff0c\u5f00\u59cb:{}", (Object)fileName);
        JSONObject result = new JSONObject();
        try {
            int maxmb = this.getMaxMb(formPlugin);
            String batchNo = MD5.md5Hex((String)filepath);
            TaxInvoiceParseHelper helper = new TaxInvoiceParseHelper();
            helper.parseTaxFile(batchNo, filepath, maxmb);
            result = this.dealTempData(batchNo);
            if (formPlugin != null) {
                int total = result.getIntValue("total");
                int success = result.getIntValue("success");
                Map errMap = (Map)result.get((Object)"errMap");
                if (success < total) {
                    TaxInvoiceImportUtil.showErrorResult(total, success, errMap, formPlugin, "sim_original_bill_import", "sim_inv_import_result");
                } else {
                    formPlugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5904\u7406\u6210\u529f", (String)"TaxInvoiceImportUtil_1", (String)"imc-sim-service", (Object[])new Object[0]));
                }
            }
        }
        catch (KDException e) {
            if (formPlugin != null) {
                formPlugin.getView().showErrorNotification(e.getMessage());
            } else {
                this.addErrMap(result, e.getMessage());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6587\u4ef6\u5904\u7406\u5931\u8d25", (Throwable)e);
            String msg = String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u5904\u7406\u5931\u8d25,\u8bf7\u6c42id:%1$s", (String)"TaxInvoiceImportUtil_0", (String)"imc-sim-service", (Object[])new Object[0]), RequestContext.get().getTraceId());
            if (formPlugin != null) {
                formPlugin.getView().showErrorNotification(msg);
            }
            this.addErrMap(result, msg);
        }
        return result;
    }

    private int getMaxMb(AbstractFormPlugin formPlugin) {
        String configType = formPlugin == null ? "_task" : "_page";
        int maxmb = BigDecimalUtil.transDecimal((Object)ImcConfigUtil.getValue((String)"bdm_excel_config", (String)("maxfile_mb" + configType))).intValue();
        if (maxmb < 1) {
            maxmb = formPlugin == null ? 50 : 8;
        }
        return maxmb;
    }

    private JSONObject dealTempData(String batchNo) {
        JSONObject result = new JSONObject();
        TaxInvoiceParseHelper helper = new TaxInvoiceParseHelper();
        HashMap<String, List<RowValue>> map = new HashMap<String, List<RowValue>>(4);
        LinkedHashMap<String, String> errMap = new LinkedHashMap<String, String>(32);
        int success = 0;
        int total = 0;
        while (true) {
            List<String> rowKeyList = helper.queryTempData(map, errMap, batchNo);
            total += ((List)map.get(this.INVOICE_SHEET)).size();
            List list = (List)map.get(this.INVOICE_SHEET);
            if (list == null || list.isEmpty()) break;
            List<Map<String, Object>> invoiceList = this.getRigthMap((List)map.get(this.INVOICE_SHEET), this.INVOICE_SHEET);
            List<Map<String, Object>> detailList = this.getRigthMap((List)map.get(this.DETAIL_SHEET), this.DETAIL_SHEET);
            Map detail = detailList.stream().collect(Collectors.groupingBy(mapObject -> this.getInvoiceNumber((Map<String, Object>)mapObject), HashMap::new, Collectors.toList()));
            invoiceList.forEach(mapObject -> {
                String invoiceKey = this.getInvoiceNumber((Map<String, Object>)mapObject);
                mapObject.put("items", detail.get(invoiceKey));
            });
            List<Map<String, Object>> excelInvoiceList = this.fullValue(invoiceList, errMap);
            success += excelInvoiceList.size();
            this.save(excelInvoiceList);
            helper.deleteTempData(batchNo, rowKeyList);
        }
        result.put("total", (Object)total);
        result.put("success", (Object)success);
        result.put("errMap", errMap);
        return result;
    }

    private static void showErrorResult(int dataNum, int successSize, Map<String, String> errMap, AbstractFormPlugin formPlugin, String callbackKey, String formId) {
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("totalline", dataNum);
        customParams.put("successline", successSize);
        customParams.put("failline", dataNum - successSize);
        customParams.put("url", "");
        customParams.put("errMap", errMap);
        ViewUtil.openDialog((AbstractFormPlugin)formPlugin, customParams, (String)formId, (String)callbackKey);
    }

    private void save(List<Map<String, Object>> excelInvoiceList) {
        Map<String, DynamicObject> existsMap = this.queryExistsInvoice(excelInvoiceList);
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> addList = new ArrayList<DynamicObject>(16);
        String batchbelong = UUID.getBatchNumber();
        for (Map<String, Object> invoice : excelInvoiceList) {
            DynamicObject obj = existsMap.get(this.nullToEmpty(invoice.get("invoicecode")) + this.nullToEmpty(invoice.get("invoiceno")));
            if (obj != null) {
                DynamicObject newobj = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
                DynamicObjectUtil.map2DynamicObject(invoice, (DynamicObject)newobj);
                this.setUpdateValue(obj, newobj);
                this.dealSetInvoiceRemarkMethod(obj, newobj);
                updateList.add(obj);
                continue;
            }
            obj = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
            DynamicObjectUtil.map2DynamicObject(invoice, (DynamicObject)obj);
            InvoiceUtils.filterOneInvoiceIllegalItems((DynamicObject)obj);
            IssueInvoiceService.setBlueInvoiceRemainRedAmount((DynamicObject)obj);
            IssueInvoiceService.updateDiscountInfo((DynamicObject)obj);
            obj.set("batchbelong", (Object)batchbelong);
            addList.add(obj);
        }
        if (!updateList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
        }
        if (!addList.isEmpty()) {
            DynamicObject[] objs;
            for (DynamicObject obj : objs = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])addList.toArray(new DynamicObject[0]))) {
                WideInvoiceSevice.addInvoiceToWide((DynamicObject)obj);
            }
        }
    }

    private String getInvoiceNumber(Map<String, Object> mapObject) {
        String invoiceCode = this.nullToEmpty(mapObject.get("invoicecode"));
        String invoiceNo = this.nullToEmpty(mapObject.get("invoiceno"));
        String allInvoiceNo = this.nullToEmpty(mapObject.get("alletaxinvoiceno"));
        if (allInvoiceNo.length() > 10) {
            return allInvoiceNo;
        }
        return invoiceCode + "-" + invoiceNo;
    }

    private void dealSetInvoiceRemarkMethod(DynamicObject invoiceObject, DynamicObject newInvoiceObject) {
        String issueType = newInvoiceObject.getString("issuetype");
        if (IssueType.RED_INVOICE.getTypeCode().equals(issueType)) {
            invoiceObject.set("remark", (Object)newInvoiceObject.getString("remark"));
        }
    }

    private void setUpdateValue(DynamicObject oldobj, DynamicObject newobj) {
        for (String field : this.UPDATE_FIELD) {
            if (newobj.get(field) == null) continue;
            oldobj.set(field, newobj.get(field));
        }
    }

    private Map<String, DynamicObject> queryExistsInvoice(List<Map<String, Object>> list) {
        ArrayList<String> invoiceNoList = new ArrayList<String>(list.size());
        HashSet<String> keySet = new HashSet<String>(list.size());
        HashSet<String> taxSet = new HashSet<String>(list.size());
        for (Map<String, Object> map : list) {
            invoiceNoList.add((String)map.get("invoiceno"));
            taxSet.add((String)map.get("salertaxno"));
            keySet.add(this.nullToEmpty(map.get("invoicecode")) + this.nullToEmpty(map.get("invoiceno")));
        }
        QFilter filter1 = new QFilter("invoiceno", "in", invoiceNoList);
        QFilter filter2 = new QFilter("salertaxno", "in", taxSet);
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"sim_vatinvoice", (String)"id,invoicecode,invoiceno", (QFilter[])new QFilter[]{filter1, filter2});
        ArrayList idList = new ArrayList(collect.size());
        collect.forEach(obj -> {
            if (!keySet.add(this.nullToEmpty(obj.getString("invoicecode")) + this.nullToEmpty(obj.getString("invoiceno")))) {
                idList.add(obj.getLong("id"));
            }
        });
        DynamicObject[] invoices = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice"));
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(invoices.length);
        for (DynamicObject obj2 : invoices) {
            map.put(this.nullToEmpty(obj2.getString("invoicecode")) + this.nullToEmpty(obj2.getString("invoiceno")), obj2);
        }
        return map;
    }

    private List<Map<String, Object>> fullValue(List<Map<String, Object>> invoiceList, Map<String, String> errMap) {
        ArrayList<Map<String, Object>> invoiceNewList = new ArrayList<Map<String, Object>>(invoiceList.size());
        long batch = Long.parseLong(DateUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
        int index = 0;
        DecimalFormat decimalFormat = new DecimalFormat("000");
        HashSet<String> errrorSet = new HashSet<String>(16);
        for (Map<String, Object> map : invoiceList) {
            try {
                if (index >= 999) {
                    ++batch;
                    index = 0;
                }
                ++index;
                List detail = (List)map.get("items");
                boolean negative = BigDecimal.ZERO.compareTo(BigDecimalUtil.transDecimal((Object)map.get("totalamount"))) > 0;
                boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)((String)map.get("invoicetype"))) || "1".equals(map.get("iselepaper"));
                this.fullDetailValue(detail, negative, isAllEle);
                map.put("orderno", UUID.randomUUID());
                map.put("buyertype", "8");
                map.put("issuestatus", "0");
                if (StringUtils.isEmpty((CharSequence)this.nullToEmpty(map.get("buyertaxno")))) {
                    map.put("buyerproperty", "1");
                } else {
                    map.put("buyerproperty", "0");
                }
                String remark = this.nullToEmpty(map.get("remark"));
                if (remark.length() > 230) {
                    map.put("remark", remark.substring(0, 230));
                }
                map.put("hsbz", "0");
                map.put("billno", "300_" + batch + "_" + decimalFormat.format(index));
                map.put("taxedtype", TaxedTypeEnum.normal.getValue());
                this.setInvoiceType(map);
                this.setInvoiceNo(map);
                String invoiceCode = this.nullToEmpty(map.get("invoicecode"));
                if (detail == null || detail.isEmpty()) {
                    String msg = String.format(ResManager.loadKDString((String)"\u53d1\u7968:%1$s", (String)"TaxInvoiceImportUtil_10", (String)"imc-sim-service", (Object[])new Object[0]), this.getInvoiceNumber(map));
                    errMap.put(msg, String.format(ResManager.loadKDString((String)"\u7f3a\u5c11\u660e\u7ec6\u884c", (String)"TaxInvoiceImportUtil_11", (String)"imc-sim-service", (Object[])new Object[0]), new Object[0]));
                    continue;
                }
                if (StringUtils.isNotEmpty((CharSequence)invoiceCode) && detail.size() > 8) {
                    map.put("inventorymark", "1");
                } else {
                    map.put("inventorymark", "0");
                }
                this.setInvoiceStatus(map);
                this.setOrg(map);
                this.setSpecialtype(map);
                this.setIssuType(map);
                invoiceNewList.add(map);
            }
            catch (KDException e) {
                errrorSet.add(e.getMessage());
            }
            catch (Exception e) {
                errrorSet.add(e.getMessage());
                LOGGER.error("\u53d1\u7968\u5904\u7406\u5931\u8d25:" + map.get("alletaxinvoiceno") + map.get("invoiceno") + map.get("invoicecode"), (Throwable)e);
            }
            Iterator iterator = errrorSet.iterator();
            int i = 1;
            while (iterator.hasNext()) {
                String msg = String.format(ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c\u9519\u8bef%1$s", (String)"TaxInvoiceImportUtil_9", (String)"imc-sim-service", (Object[])new Object[0]), i++);
                errMap.put(msg, (String)iterator.next());
            }
        }
        return invoiceNewList;
    }

    private void setOrg(Map<String, Object> map) {
        Long orgId = this.getOrgId(this.nullToEmpty(map.get("salertaxno")));
        if (orgId <= 0L) {
            throw new KDException(String.format(ResManager.loadKDString((String)"\u7a0e\u53f7[%1$s]\u672a\u914d\u7f6e\u7ec4\u7ec7\uff0c\u8bf7\u5148\u5728\u4f01\u4e1a\u4fe1\u606f\u4e2d\u7ef4\u62a4\u7ec4\u7ec7", (String)"TaxInvoiceImportUtil_4", (String)"imc-sim-service", (Object[])new Object[0]), this.nullToEmpty(map.get("salertaxno"))));
        }
        map.put("orgid", orgId);
    }

    private Long getOrgId(String taxNo) {
        if (StringUtils.isEmpty((CharSequence)taxNo)) {
            return 0L;
        }
        if (this.orgMap == null) {
            this.orgMap = new HashMap<String, Long>(2);
        }
        if (this.orgMap.get(taxNo) == null) {
            try {
                DynamicObject orgDynamicObject = TaxUtils.getOrgDynamicObjectByTaxNo((String)taxNo);
                this.orgMap.put(taxNo, orgDynamicObject.getLong("id"));
            }
            catch (Exception e) {
                this.orgMap.put(taxNo, 0L);
            }
        }
        return this.orgMap.get(taxNo);
    }

    private void setInvoiceStatus(Map<String, Object> map) {
        String status = this.nullToEmpty(map.get("invoicestatus"));
        status = status.indexOf("\u5e9f") >= 0 ? "6" : (status.indexOf("\u7ea2") >= 0 ? (status.indexOf("\u90e8") >= 0 ? "2" : "3") : "0");
        map.put("invoicestatus", status);
    }

    private void setInvoiceType(Map<String, Object> map) {
        String type = this.nullToEmpty(map.get("invoicetype"));
        type = type.indexOf("\u6570\u7535") >= 0 ? (type.indexOf("\u4e13\u7528") >= 0 ? InvoiceType.ALL_E_SPECIAL.getTypeCode() : InvoiceType.ALL_E_NORMAL.getTypeCode()) : (type.indexOf("\u7535") >= 0 ? (type.indexOf("\u4e13\u7528") >= 0 ? InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode() : InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode()) : (type.indexOf("\u4e13\u7528") >= 0 ? InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode() : InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode()));
        this.invoiceTypeSet.add(type);
        map.put("invoicetype", type);
    }

    private void setInvoiceNo(Map<String, Object> detail) {
        String eInvoiceNo = this.nullToEmpty(detail.get("alletaxinvoiceno"));
        String invoiceNo = this.nullToEmpty(detail.get("invoiceno"));
        if (eInvoiceNo.length() == 20 && StringUtils.isEmpty((CharSequence)invoiceNo)) {
            detail.put("invoiceno", eInvoiceNo);
            detail.put("invoicecode", "");
            detail.put("alletaxinvoiceno", "");
        }
        if (StringUtils.isNotEmpty((CharSequence)invoiceNo) && StringUtils.isNotBlank((CharSequence)eInvoiceNo) && eInvoiceNo.length() < 20) {
            detail.put("alletaxinvoiceno", "");
        }
    }

    private void fullDetailValue(List<Map<String, Object>> detailList, boolean negative, boolean isAllEle) {
        if (detailList != null) {
            ArrayList<Integer> deducIndex = new ArrayList<Integer>(8);
            for (int i = 0; i < detailList.size(); ++i) {
                Map<String, Object> map = detailList.get(i);
                String taxRate = TaxRateUtil.percent2Point((String)((String)map.get("taxrate")));
                map.put("taxrate", taxRate);
                boolean detailnegative = BigDecimal.ZERO.compareTo(BigDecimalUtil.transDecimal((Object)map.get("amount"))) > 0;
                map.put("rowtype", "0");
                if (!negative && detailnegative) {
                    map.put("rowtype", "1");
                    deducIndex.add(i - 1);
                }
                map.put("taxpremark", "0");
                map.put("taxamount", BigDecimalUtil.transDecimal((Object)map.get("amount")).add(BigDecimalUtil.transDecimal((Object)map.get("tax"))));
                try {
                    BigDecimal num = BigDecimalUtil.transDecimal((Object)map.get("num"));
                    BigDecimal taxamount = BigDecimalUtil.transDecimal((Object)map.get("taxamount"));
                    BigDecimal unitPrice = BigDecimalUtil.transDecimal((Object)map.get("unitprice"));
                    BigDecimal taxUnit = PriceHelper.getTaxUnitPriceByBHS((BigDecimal)BigDecimalUtil.transDecimal((Object)taxRate), (BigDecimal)num, (BigDecimal)taxamount, (BigDecimal)unitPrice, (boolean)isAllEle);
                    map.put("taxunitprice", taxUnit);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                map.put("seq", i);
            }
            for (Integer index : deducIndex) {
                Map<String, Object> map = detailList.get(index);
                map.put("rowtype", "2");
            }
        }
    }

    private String nullToEmpty(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString().trim();
    }

    private List<Map<String, Object>> getRigthMap(List<RowValue> list, String type) {
        ArrayList<Map<String, Object>> returnlist = new ArrayList<Map<String, Object>>(8);
        if (list != null) {
            for (RowValue val : list) {
                String goodsname;
                if (!val.isRight()) continue;
                HashMap valMap = new HashMap(8);
                val.getCellList().forEach(e -> valMap.put(e.getFieldCode(), e.getFieldValue()));
                String seq = this.nullToEmpty(valMap.get("cellSeq"));
                if (seq.indexOf("\u5408\u8ba1") >= 0 || (goodsname = this.nullToEmpty(valMap.get("goodsname"))).indexOf("\u8be6\u89c1\u9500\u8d27\u6e05\u5355") >= 0) continue;
                returnlist.add(valMap);
            }
        }
        return returnlist;
    }

    private void setIssuType(Map<String, Object> invoice) {
        if (BigDecimal.ZERO.compareTo(BigDecimalUtil.transDecimal((Object)invoice.get("totalamount"))) > 0) {
            invoice.put("issuetype", IssueType.RED_INVOICE.getTypeCode());
        } else {
            invoice.put("issuetype", IssueType.BLUE_INVOICE.getTypeCode());
        }
    }

    private void setSpecialtype(Map<String, Object> invoice) {
        List item = (List)invoice.get("items");
        if (item == null || item.isEmpty()) {
            invoice.put("specialtype", "00");
        } else {
            String specialTypeName = this.nullToEmpty(((Map)item.get(0)).get("specialtype"));
            String specialType = null;
            specialType = specialTypeName.indexOf("\u5efa\u7b51\u670d\u52a1") >= 0 ? "E03" : (specialTypeName.indexOf("\u8d27\u7269") >= 0 ? "E04" : (specialTypeName.indexOf("\u65c5\u5ba2") >= 0 ? "E09" : (specialTypeName.indexOf("\u519c") != -1 ? "02" : "00")));
            if (specialType != null) {
                invoice.put("specialtype", specialType);
            }
        }
    }

    private void addErrMap(JSONObject result, String msg) {
        HashMap<String, String> errMap = (HashMap<String, String>)result.get((Object)"errMap");
        if (errMap == null) {
            errMap = new HashMap<String, String>(1);
        }
        errMap.put(ResManager.loadKDString((String)"\u6587\u4ef6\u5904\u7406\u5931\u8d25", (String)"TaxInvoiceImportUtil_7", (String)"imc-sim-service", (Object[])new Object[0]), msg);
        result.put("errMap", errMap);
    }

    public Set<String> getInvoiceTypeSet() {
        return this.invoiceTypeSet;
    }
}

