/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.invoicebatch;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imc.bdm.common.helper.ExcelHelper;
import kd.imc.bdm.common.model.CellValue;
import kd.imc.bdm.common.model.FileField;
import kd.imc.bdm.common.model.RowValue;
import kd.imc.sim.formplugin.invoicebatch.model.TaxInvoiceSheetHandler;
import org.apache.commons.io.FileUtils;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.model.Styles;
import org.apache.poi.xssf.model.StylesTable;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class TaxInvoiceParseHelper {
    private static final Log LOGGER = LogFactory.getLog(TaxInvoiceParseHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseTaxFile(String batchNo, String filepath, int maxMb) throws Exception {
        long start = System.currentTimeMillis();
        File tempFile = null;
        try {
            tempFile = this.createTempFile(filepath, batchNo);
            try (OPCPackage pkg = OPCPackage.open((File)tempFile);){
                XSSFReader reader = new XSSFReader(pkg);
                SharedStrings sharedStringsTable = reader.getSharedStringsTable();
                StylesTable stylesTable = reader.getStylesTable();
                XSSFReader.SheetIterator sheetIterator = (XSSFReader.SheetIterator)reader.getSheetsData();
                QFilter qfilter = new QFilter("batchno", "=", (Object)batchNo);
                DeleteServiceHelper.delete((String)"sim_import_temp", (QFilter[])qfilter.toArray());
                HashMap<String, Map<Integer, FileField>> configMap = new HashMap<String, Map<Integer, FileField>>(2);
                while (sheetIterator.hasNext()) {
                    InputStream sheetStream = sheetIterator.next();
                    InputSource sheetSource = new InputSource(sheetStream);
                    String sheetName = sheetIterator.getSheetName();
                    String sheetType = this.getSheetType(sheetIterator.getSheetName());
                    if (sheetType == null) continue;
                    Map<Integer, FileField> config = this.getConfig(sheetType, configMap);
                    TaxInvoiceSheetHandler sheetHandler = new TaxInvoiceSheetHandler(sheetType, sheetName, batchNo, config);
                    XSSFSheetXMLHandler handler = new XSSFSheetXMLHandler((Styles)stylesTable, sharedStringsTable, (XSSFSheetXMLHandler.SheetContentsHandler)sheetHandler, false);
                    XMLReader xmlReader = XMLReaderFactory.createXMLReader("com.sun.org.apache.xerces.internal.parsers.SAXParser");
                    xmlReader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                    xmlReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
                    xmlReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                    xmlReader.setContentHandler((ContentHandler)handler);
                    xmlReader.parse(sheetSource);
                    sheetStream.close();
                }
                LOGGER.info("\u9500\u9879\u7a0e\u5c40\u6587\u4ef6\u5bfc\u5165\uff0c\u603b\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - start));
            }
        }
        finally {
            if (tempFile != null) {
                try {
                    Files.delete(tempFile.toPath());
                }
                catch (IOException iOException) {}
            }
        }
    }

    private File createTempFile(String filepath, String temFileName) throws IOException {
        File tempFile = null;
        FileService service = FileServiceFactory.getAttachmentFileService();
        try (InputStream inputStream = service.getInputStream(filepath);){
            tempFile = File.createTempFile(temFileName, "xlsx");
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tempFile);
        }
        return tempFile;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public byte[] checkFileSize(String path, int maxMb) {
        int maxbyte = maxMb * 1024 * 1024;
        FileService service = FileServiceFactory.getAttachmentFileService();
        try {
            Throwable throwable = null;
            try (InputStream inputStream = service.getInputStream(path);){
                byte[] byArray;
                Throwable throwable2;
                ByteArrayOutputStream bos;
                block31: {
                    block32: {
                        bos = new ByteArrayOutputStream();
                        throwable2 = null;
                        byte[] buffer = new byte[1024];
                        int len = 0;
                        int total = 0;
                        while ((len = inputStream.read(buffer)) != -1) {
                            bos.write(buffer, 0, len);
                            if ((total += len) <= maxbyte) continue;
                            throw new KDException(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u6700\u5927\u6587\u4ef6(%1$sMB)\u9650\u5236", (String)"TaxInvoiceParseHelper_1", (String)"imc-sim-service", (Object[])new Object[0]), maxMb));
                        }
                        byArray = bos.toByteArray();
                        if (bos == null) break block31;
                        if (throwable2 == null) break block32;
                        try {
                            bos.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block31;
                    }
                    bos.close();
                }
                return byArray;
                catch (Throwable throwable4) {
                    try {
                        try {
                            try {
                                throwable2 = throwable4;
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                if (bos != null) {
                                    if (throwable2 != null) {
                                        try {
                                            bos.close();
                                        }
                                        catch (Throwable throwable6) {
                                            throwable2.addSuppressed(throwable6);
                                        }
                                    } else {
                                        bos.close();
                                    }
                                }
                                throw throwable5;
                            }
                        }
                        catch (IOException iOException) {
                        }
                    }
                    catch (Throwable throwable7) {
                        throwable = throwable7;
                        throw throwable7;
                    }
                    catch (Throwable throwable8) {
                        throw throwable8;
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public List<String> queryTempData(Map<String, List<RowValue>> dataMap, Map<String, String> errMap, String batchNo) {
        int pageNo = 200;
        ArrayList<String> rowKeyList = new ArrayList<String>(pageNo);
        ArrayList<RowValue> listRwoValue = new ArrayList<RowValue>(pageNo);
        DynamicObjectCollection collect = this.queryInvoice(batchNo, pageNo);
        for (DynamicObject obj : collect) {
            rowKeyList.add(obj.getString("rowkey"));
            listRwoValue.add(this.createRowValue(obj, errMap));
        }
        dataMap.put("INVOICE", listRwoValue);
        ArrayList<RowValue> detailRwoValue = new ArrayList<RowValue>(pageNo);
        DynamicObjectCollection detailList = this.queryDetail(batchNo, rowKeyList);
        for (DynamicObject obj : detailList) {
            detailRwoValue.add(this.createRowValue(obj, errMap));
        }
        dataMap.put("DETAIL", detailRwoValue);
        return rowKeyList;
    }

    public void deleteTempData(String batchNo, List<String> rowKeyList) {
        QFilter filter2 = new QFilter("batchno", "=", (Object)batchNo);
        QFilter filter1 = new QFilter("rowkey", "in", rowKeyList);
        DeleteServiceHelper.delete((String)"sim_import_temp", (QFilter[])new QFilter[]{filter2, filter1});
    }

    private RowValue createRowValue(DynamicObject obj, Map<String, String> errMap) {
        ArrayList<CellValue> cellList = new ArrayList<CellValue>(32);
        RowValue rowValue = new RowValue();
        rowValue.setRowIndex(obj.getInt("rowid"));
        rowValue.setSheetName(obj.getString("sheetname"));
        JSONArray array = JSONArray.parseArray((String)obj.getString("data_tag"));
        for (int i = 0; i < array.size(); ++i) {
            JSONObject cell = array.getJSONObject(i);
            CellValue cellValue = new CellValue(rowValue.getRowIndex(), cell.getIntValue("i"), cell.getString("v"));
            cellValue.setFieldCode(cell.getString("k"));
            cellValue.setFieldName(cell.getString("n"));
            cellList.add(cellValue);
            if (!"0".equals(cell.getString("s"))) continue;
            rowValue.setRight(false);
            errMap.put(String.format(ResManager.loadKDString((String)"\u5de5\u4f5c\u8868 %1$s\u7b2c%2$s\u884c%3$s\u5217", (String)"TaxInvoiceParseHelper_0", (String)"imc-sim-service", (Object[])new Object[0]), rowValue.getSheetName(), rowValue.getRowIndex(), cellValue.getCellIndex()), cell.getString("m"));
        }
        rowValue.setCellList(cellList);
        return rowValue;
    }

    private DynamicObjectCollection queryInvoice(String batchNo, int pageNo) {
        QFilter filter1 = new QFilter("datatype", "=", (Object)"INVOICE");
        QFilter filter2 = new QFilter("batchno", "=", (Object)batchNo);
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"sim_import_temp", (String)"id,rowid,rowkey,status,sheetname,errormsg,data_tag", (QFilter[])new QFilter[]{filter1, filter2}, (String)"", (int)pageNo);
        return collect;
    }

    private DynamicObjectCollection queryDetail(String batchNo, List<String> invoiceList) {
        QFilter filter1 = new QFilter("datatype", "=", (Object)"DETAIL");
        QFilter filter2 = new QFilter("batchno", "=", (Object)batchNo);
        QFilter filter3 = new QFilter("rowkey", "in", invoiceList);
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"sim_import_temp", (String)"id,rowid,rowkey,status,sheetname,errormsg,data_tag", (QFilter[])new QFilter[]{filter1, filter2, filter3}, (String)"rowkey,rowid");
        return collect;
    }

    private Map<Integer, FileField> getConfig(String sheetType, Map<String, Map<Integer, FileField>> configMap) {
        if (configMap.get(sheetType) == null) {
            List fileFieldList = ExcelHelper.readTemplate((String)"excel_templates", (String)("TaxInvoice_" + sheetType + ".json"));
            HashMap<Integer, FileField> fieldConfigMap = new HashMap<Integer, FileField>(fileFieldList.size());
            fileFieldList.forEach(field -> fieldConfigMap.put(field.getColIndex() - 1, (FileField)field));
            configMap.put(sheetType, fieldConfigMap);
            return fieldConfigMap;
        }
        return configMap.get(sheetType);
    }

    private String getSheetType(String sheetName) {
        if (sheetName.indexOf("\u6c47\u603b") > 0) {
            return "DETAIL";
        }
        if (sheetName.indexOf("\u57fa\u7840") > 0) {
            return "INVOICE";
        }
        return null;
    }
}

