/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.invoicebatch.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.model.FileField;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.sim.formplugin.invoicebatch.model.RowInfo;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import org.apache.poi.xssf.usermodel.XSSFComment;

public class TaxInvoiceSheetHandler
implements XSSFSheetXMLHandler.SheetContentsHandler {
    private String[] keyArray = new String[]{"invoicecode", "invoiceno", "alletaxinvoiceno"};
    private String sheetType;
    private String batchNo;
    private Map<Integer, String> head = new LinkedHashMap<Integer, String>();
    private Map<Integer, FileField> fieldConfigMap;
    private List<RowInfo> data = new ArrayList<RowInfo>(64);
    private List<Map<String, String>> currentRow;
    private String sheetName;
    boolean isHead = false;
    boolean isRight = true;

    public TaxInvoiceSheetHandler(String sheetType, String sheetName, String batchNo, Map<Integer, FileField> fieldConfigMap) {
        this.sheetType = sheetType;
        this.batchNo = batchNo;
        this.fieldConfigMap = fieldConfigMap;
        this.sheetName = sheetName;
    }

    public void startRow(int rowNum) {
        boolean bl = this.isHead = rowNum < 1;
        if (rowNum % 200 == 0) {
            this.saveRow(this.data);
        }
        this.isRight = true;
        this.currentRow = new ArrayList<Map<String, String>>(16);
    }

    public void endRow(int rowNum) {
        String rowKey;
        if (!this.isHead && !StringUtils.isEmpty((CharSequence)(rowKey = this.getUintKey()))) {
            RowInfo info = new RowInfo(this.sheetType, rowNum, rowKey, this.batchNo, this.currentRow);
            info.setRight(this.isRight);
            this.data.add(info);
        }
    }

    public void cell(String cellReference, String formattedValue, XSSFComment comment) {
        if (cellReference != null) {
            int columnIndex = this.getColumnIndex(cellReference);
            if (this.isHead) {
                this.head.put(columnIndex, formattedValue);
            } else {
                FileField config = this.fieldConfigMap.get(columnIndex);
                if (config != null) {
                    List<String> arr;
                    String cellVal = formattedValue;
                    StringBuilder errorMsg = new StringBuilder();
                    if (StringUtils.isBlank((CharSequence)formattedValue) && StringUtils.isNotBlank((CharSequence)config.getDefaultValue())) {
                        cellVal = config.getDefaultValue();
                    }
                    boolean right = true;
                    if (config.getMaxLength() != null) {
                        int length;
                        cellVal = cellVal == null ? "" : cellVal;
                        int n = length = config.getGbkLength() != false ? GBKUtils.getGBKLength((String)cellVal).intValue() : cellVal.length();
                        if (length > config.getMaxLength()) {
                            right = false;
                            String msg = null;
                            msg = config.getGbkLength() != false ? String.format(ResManager.loadKDString((String)"%1$s\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e%2$s,\u4e00\u4e2a\u6c49\u5b57\u5360\u4e24\u4e2a\u5b57\u8282", (String)"TaxInvoiceSheetHandler_17", (String)"imc-sim-service", (Object[])new Object[0]), config.getFieldName(), config.getMaxLength()) : String.format(ResManager.loadKDString((String)"%1$s\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e%2$s", (String)"TaxInvoiceSheetHandler_18", (String)"imc-sim-service", (Object[])new Object[0]), config.getFieldName(), config.getMaxLength());
                            errorMsg.append(msg);
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)config.getRegex()) && StringUtils.isNotBlank((CharSequence)cellVal) && !Pattern.matches(config.getRegex(), cellVal.trim())) {
                        if (!right) {
                            errorMsg.append(';');
                        }
                        right = false;
                        errorMsg.append(StringUtils.isNotBlank((CharSequence)config.getRegexErrorMsg()) ? config.getRegexErrorMsg() : ResManager.loadKDString((String)"\u6570\u636e\u683c\u5f0f\u9519\u8bef", (String)"TaxInvoiceSheetHandler_19", (String)"imc-sim-service", (Object[])new Object[0]));
                    }
                    if (StringUtils.isNotBlank((CharSequence)config.getContainsContent()) && StringUtils.isNotBlank((CharSequence)cellVal) && !(arr = Arrays.asList(config.getContainsContent().split("~~~"))).contains(cellVal)) {
                        if (!right) {
                            errorMsg.append(';');
                        }
                        right = false;
                        errorMsg.append(String.format(ResManager.loadKDString((String)"%s\u5185\u5bb9\u586b\u5199\u9519\u8bef", (String)"TaxInvoiceSheetHandler_20", (String)"imc-sim-service", (Object[])new Object[0]), config.getFieldName()));
                    }
                    HashMap<String, String> cell = new HashMap<String, String>(4);
                    cell.put("k", config.getFieldCode());
                    cell.put("v", cellVal);
                    cell.put("m", errorMsg.toString());
                    cell.put("i", columnIndex + "");
                    cell.put("s", errorMsg.toString());
                    if (!right) {
                        this.isRight = false;
                        cell.put("s", "0");
                    } else {
                        cell.put("s", "1");
                    }
                    this.currentRow.add(cell);
                }
            }
        }
    }

    public void endSheet() {
        this.saveRow(this.data);
    }

    private void saveRow(List<RowInfo> data) {
        if (data.size() > 0) {
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(data.size());
            for (RowInfo info : data) {
                DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"sim_import_temp");
                obj.set("batchno", (Object)this.batchNo);
                obj.set("datatype", (Object)this.sheetType);
                obj.set("rowkey", (Object)info.getRowKey());
                obj.set("rowid", (Object)info.getRowId());
                obj.set("status", (Object)"1");
                obj.set("errormsg", (Object)"");
                obj.set("sheetname", (Object)this.sheetName);
                obj.set("createtime", (Object)new Date());
                if (!info.isRight()) {
                    obj.set("status", (Object)"0");
                }
                obj.set("data_tag", (Object)SerializationUtils.toJsonString(info.getCellInfoMap()));
                list.add(obj);
            }
            SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
            data.clear();
        }
    }

    private String getUintKey() {
        String[] valArray = new String[this.keyArray.length];
        for (Map<String, String> map : this.currentRow) {
            for (int i = 0; i < this.keyArray.length; ++i) {
                String val = this.getInvoiceKeyValue(map, this.keyArray[i]);
                if (val == null) continue;
                valArray[i] = val;
            }
        }
        return StringUtils.trimToEmpty((String)valArray[0]) + StringUtils.trimToEmpty((String)valArray[1]) + StringUtils.trimToEmpty((String)valArray[2]);
    }

    private String getInvoiceKeyValue(Map<String, String> map, String datakey) {
        String k = map.get("k");
        if (datakey.equals(k)) {
            String val = map.get("v");
            if (val == null) {
                return "";
            }
            if (val.length() < 3) {
                return "";
            }
            return val.trim();
        }
        return null;
    }

    private int getColumnIndex(String cellReference) {
        String colStr = this.getColumnNo(cellReference);
        int result = 0;
        int length = colStr.length();
        for (int i = 0; i < length; ++i) {
            char ch = colStr.charAt(length - i - 1);
            int num = ch - 65 + 1;
            num = (int)((double)num * Math.pow(26.0, i));
            result += num;
        }
        return result - 1;
    }

    private String getColumnNo(String cellReference) {
        String colStr = cellReference.replaceAll("[0-9]", "");
        return colStr;
    }

    public void headerFooter(String text, boolean isHeader, String tagName) {
    }
}

