/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.control;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.ComponentInterfaceTypeEnum;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.table.GoodsInfoConstant;
import kd.imc.bdm.common.dto.ComponentRequest;
import kd.imc.bdm.common.dto.ComponentResponse;
import kd.imc.bdm.common.dto.PaperInvoiceRollInfoDTO;
import kd.imc.bdm.common.enums.PayeeStrategyEnum;
import kd.imc.bdm.common.enums.ReviewerStrategyEnum;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.ComponentServiceHelper;
import kd.imc.bdm.common.helper.DrawerStrategyHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.model.DrawerInfo;
import kd.imc.bdm.common.model.DrawerStrategyDTO;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.service.OpenInvoiceService;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.ComboEditUtil;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.UUID;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.bdm.file.fpy.enums.SpecialTypeEnum;
import kd.imc.sim.common.constant.InvoiceConstant;
import kd.imc.sim.common.helper.BwServerInvoiceHelper;
import kd.imc.sim.common.helper.HostModeInvoiceHelper;
import kd.imc.sim.common.helper.LyServerInvoiceHelper;
import kd.imc.sim.common.helper.allele.CreditQuotaHelper;
import kd.imc.sim.common.model.invoice.IssueTypeEnum;
import kd.imc.sim.common.model.invoice.TaxedTypeEnum;
import kd.imc.sim.common.utils.DeviceUtil;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.issuing.control.CreateInvoiceBaseControl;
import kd.imc.sim.formplugin.issuing.control.CreateInvoiceCustomViewControl;
import kd.imc.sim.formplugin.issuing.control.CreateInvoiceWaitControl;
import kd.imc.sim.formplugin.issuing.helper.CreateInvoiceGoodsHelper;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;

public class CreateInvoiceControl
extends CreateInvoiceBaseControl {
    private static final String REISSUE_INVALID = "REISSUE_INVALID";

    public static void initDrawer(AbstractFormPlugin plugin) {
        IDataModel model = plugin.getView().getModel();
        String invOrg = plugin.getPageCache().get("invOrg");
        long org = StringUtils.isEmpty((CharSequence)invOrg) ? CreateInvoiceBaseControl.getOrgIdByView(plugin) : Long.parseLong(invOrg);
        DrawerInfo drawerInfo = DrawerStrategyHelper.getDrawerInfoNonOriginalBill(null, null, null, (Long)org, (Object)model.getValue("jqbh"));
        model.setValue("drawer", (Object)drawerInfo.getDrawer());
        model.setValue("payee", (Object)drawerInfo.getPayee());
        model.setValue("reviewer", (Object)drawerInfo.getReviewer());
        CreateInvoiceControl.initPayeeReviewerMethod(org, model);
    }

    private static void initPayeeReviewerMethod(long org, IDataModel model) {
        String invoiceType = (String)model.getValue("invoicetype");
        if (InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
            DrawerStrategyDTO strategy = DrawerStrategyHelper.getDrawerStrategyMethod((Long)org);
            if (PayeeStrategyEnum.DEVICE_DEFAULT.getCode().equals(strategy.getPayeeStrategy())) {
                model.setValue("payee", null);
            }
            if (ReviewerStrategyEnum.DEVICE_DEFAULT.getCode().equals(strategy.getReviewerStrategy())) {
                model.setValue("reviewer", null);
            }
        }
    }

    public static void normalBlueInvoiceInitData(AbstractFormPlugin plugin) {
        plugin.getView().setVisible(Boolean.TRUE, new String[]{"custombuyername"});
        plugin.getView().setVisible(Boolean.FALSE, new String[]{"flexbuyername", "btnred", "tipnsrsbh", "tipdzdh", "tipyhzh"});
        plugin.getView().setEnable(Boolean.TRUE, new String[]{"specialtype", "buyerproperty"});
        plugin.getView().getModel().setValue("billno", (Object)("200_" + UUID.getBatchNumber() + "_0001"));
        ComboEditUtil.setComboEditDefault((AbstractFormPlugin)plugin, (String)"invoicetype");
        plugin.getView().getModel().setValue("issuetype", (Object)IssueTypeEnum.blue.getValue());
    }

    public static void doIssueInvoice(AbstractFormPlugin plugin, Map<String, Object> showDataMap) {
        Object billNo;
        QFilter qFilter;
        DynamicObject invoice;
        Object issueType = plugin.getView().getModel().getValue("issuetype");
        if ("1".equals(issueType) && null != (invoice = QueryServiceHelper.queryOne((String)"sim_vatinvoice", (String)"orgid", (QFilter[])(qFilter = new QFilter("billno", "=", billNo = plugin.getView().getModel().getValue("billno"))).toArray()))) {
            PermissionHelper.checkPermission((String)"sim", (String)"sim_vatinvoice", (long)invoice.getLong("orgid"), (ImcPermItemEnum)ImcPermItemEnum.SIM_RED);
        }
        if (InvoiceUtils.isAllEInvoice((Object)((String)plugin.getView().getModel().getValue("invoicetype")))) {
            HashMap params = Maps.newHashMap();
            String taxNo = (String)plugin.getView().getModel().getValue("salertaxno");
            if ("02".equals(plugin.getView().getModel().getValue("specialtype"))) {
                taxNo = (String)plugin.getView().getModel().getValue("buyertaxno");
            }
            params.put("salertaxno", taxNo);
            String allEAccount = (String)plugin.getView().getModel().getValue("account");
            if (StringUtils.isNotBlank((CharSequence)allEAccount)) {
                params.put("drawer", plugin.getView().getModel().getValue("drawer"));
            }
            params.put("account", StringUtils.trimToEmpty((String)allEAccount));
            if (AllEleServiceHelper.isNeedLogin((AbstractFormPlugin)plugin, (Map)params)) {
                return;
            }
        }
        CreateInvoiceControl.openInvoiceBindDataToHtml(plugin, showDataMap);
    }

    public static void openInvoiceBindDataToHtml(AbstractFormPlugin plugin, Map<String, Object> showDataMap) {
        plugin.getView().setEnable(Boolean.FALSE, new String[]{"openinvoice"});
        try {
            plugin.getPageCache().remove("batchSave");
            showDataMap.put("eventkey", "openinvoice");
            ViewUtil.bindDataToHtml((AbstractFormPlugin)plugin, showDataMap, (String)"customcontrolap");
        }
        catch (Exception e) {
            plugin.getView().setEnable(Boolean.TRUE, new String[]{"openinvoice"});
            plugin.getView().showErrorNotification(e.getMessage());
        }
    }

    public static void queryBuyerTitle(String ars, String key, AbstractFormPlugin formPlugin, String pageId) {
        HashMap<String, Object> showDataMap = new HashMap<String, Object>(6);
        showDataMap.put("eventkey", "queryTitle");
        OpenInvoiceService openInvoiceService = new OpenInvoiceService();
        List companyInfos = openInvoiceService.queryCompany(ars);
        showDataMap.put("companyInfos", companyInfos);
        ViewUtil.bindDataToHtml((AbstractFormPlugin)formPlugin, showDataMap, (String)key, (String)pageId);
    }

    public static void getDiscount(String ars, AbstractFormPlugin formPlugin) {
        JSONObject json = JSONObject.parseObject((String)ars);
        formPlugin.getPageCache().put("rowData", ars);
        HashMap<String, String> customParams = new HashMap<String, String>(8);
        customParams.put("taxrate", json.getString("sl"));
        String hsbz = (String)formPlugin.getView().getModel().getValue("hsbz");
        if ("1".equals(hsbz)) {
            customParams.put("amount", json.getString("xmjehs"));
        } else {
            customParams.put("amount", json.getString("xmje"));
        }
        ViewUtil.openDialog((AbstractFormPlugin)formPlugin, customParams, (String)"sim_discount_dialog", (String)"close_call_back_discount");
    }

    public static void queryGoods(String ars, AbstractFormPlugin formPlugin) {
        String start;
        JSONObject jsonObject = JSONObject.parseObject((String)ars);
        String spmc = jsonObject.getString("spmc");
        String xmmc = jsonObject.getString("xmmc");
        if (StringUtils.isNotEmpty((CharSequence)spmc) && StringUtils.isNotEmpty((CharSequence)xmmc) && xmmc.startsWith(start = "*" + spmc + "*")) {
            xmmc = xmmc.substring(start.length());
            jsonObject.put("xmmc", (Object)xmmc);
        }
        if ("1".equals(formPlugin.getPageCache().get("waitFromBill"))) {
            formPlugin.getPageCache().put("billEditDetailTaxRate", jsonObject.getString("sl"));
        }
        formPlugin.getPageCache().put("rowData", jsonObject.toJSONString());
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bdm_mark_tax_tab");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("xmmc", (Object)xmmc);
        parameter.setCustomParam("orgid", (Object)CreateInvoiceControl.getOrgIdByView(formPlugin));
        CreateInvoiceControl.setSpecialInvoiceFlag(formPlugin, parameter);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)formPlugin, "queryGoods");
        parameter.setCloseCallBack(closeCallBack);
        formPlugin.getView().showForm(parameter);
    }

    public static Map<String, Object> handleGoodsCodeCloseCallBack(ClosedCallBackEvent event, AbstractFormPlugin formPlugin) {
        Map map = (Map)event.getReturnData();
        CreateInvoiceGoodsHelper helper = new CreateInvoiceGoodsHelper();
        Map<String, Object> showDataMap = new HashMap<String, Object>(16);
        ListSelectedRowCollection collection = (ListSelectedRowCollection)map.get("result");
        Object primaryKeyValue = collection.get(0).getPrimaryKeyValue();
        String rowData = formPlugin.getPageCache().get("rowData");
        String currentRow = formPlugin.getPageCache().get("rowid");
        String billEditDetailTaxRate = formPlugin.getPageCache().get("billEditDetailTaxRate");
        if ("tax".equals(map.get("type"))) {
            showDataMap = helper.goodsTreeCloseBack(rowData, currentRow, billEditDetailTaxRate, event.getActionId(), primaryKeyValue);
        } else if ("mark".equals(map.get("type"))) {
            showDataMap = helper.customerGoodsCloseBack(rowData, currentRow, billEditDetailTaxRate, event.getActionId(), primaryKeyValue);
        }
        return showDataMap;
    }

    private static void setSpecialInvoiceFlag(AbstractFormPlugin formPlugin, FormShowParameter parameter) {
        if ("1".equals(formPlugin.getPageCache().get("tobacco_enterprise"))) {
            if ("11".equals(formPlugin.getView().getModel().getValue("checkboxtobacco"))) {
                parameter.setCustomParam("TOBACCO_LABEL", (Object)"2");
            } else {
                parameter.setCustomParam("TOBACCO_LABEL", (Object)"1");
            }
        } else {
            parameter.setCustomParam("TOBACCO_LABEL", (Object)"0");
        }
        String oilEnterprise = formPlugin.getPageCache().get("oil_enterprise");
        if (StringUtils.isNotEmpty((CharSequence)oilEnterprise) && "1".equals(oilEnterprise)) {
            String specialType;
            if (DynamicObjectUtil.checkDynamicObjectHasField((DynamicObject)formPlugin.getView().getModel().getDataEntity(), (String)"specialtype")) {
                specialType = formPlugin.getView().getModel().getDataEntity().getString("specialtype");
            } else if (DynamicObjectUtil.checkDynamicObjectHasField((DynamicObject)formPlugin.getView().getModel().getDataEntity(), (String)"checkboxtobacco")) {
                specialType = formPlugin.getView().getModel().getDataEntity().getString("checkboxtobacco");
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u7279\u6b8a\u7968\u79cd\u5b57\u6bb5\u672a\u627e\u5230", (String)"CreateInvoiceControl_0", (String)"imc-sim-service", (Object[])new Object[0]));
            }
            if ("08".equals(specialType)) {
                parameter.setCustomParam("OIL_LABLE", (Object)"2");
            } else {
                parameter.setCustomParam("OIL_LABLE", (Object)"1");
            }
        } else {
            parameter.setCustomParam("OIL_LABLE", (Object)"0");
        }
    }

    public static void confirmDeduction(ClosedCallBackEvent event, AbstractFormPlugin formPlugin) {
        BigDecimal deduction = (BigDecimal)event.getReturnData();
        HashMap<String, Object> showDataMap = new HashMap<String, Object>(4);
        if (deduction != null) {
            deduction = deduction.setScale(2, 4);
            showDataMap.put("eventkey", "returncezs");
            showDataMap.put("kplx", String.valueOf(IssueTypeEnum.deduction.getValue()));
            showDataMap.put("deduction", deduction);
            formPlugin.getView().getModel().setValue("deduction", (Object)deduction);
            String remark = String.format(ResManager.loadKDString((String)"\u5dee\u989d\u5f81\u7a0e\uff1a%s\u3002", (String)"CreateInvoiceControl_1", (String)"imc-sim-service", (Object[])new Object[0]), deduction);
            formPlugin.getView().getModel().setValue("redremark", (Object)remark);
            if (null != formPlugin.getPageCache().get(REISSUE_INVALID)) {
                formPlugin.getView().getModel().setValue("remark", (Object)remark);
            }
            HashMap<String, String> issueTypeSelectMap = new HashMap<String, String>();
            issueTypeSelectMap.put(ResManager.loadKDString((String)"\u6b63\u6570\u53d1\u7968", (String)"CreateInvoiceControl_2", (String)"imc-sim-service", (Object[])new Object[0]), "0");
            ViewUtil.setDropDownViewData((AbstractFormPlugin)formPlugin, (String)"issuetype", issueTypeSelectMap);
            ViewUtil.bindDataToHtml((AbstractFormPlugin)formPlugin, showDataMap, (String)"customcontrolap");
        }
    }

    public static void selectOtherTaxedType(AbstractFormPlugin formPlugin, IFormView view, String newValue) {
        formPlugin.getPageCache().put("has_change_zsfs", "");
        view.getModel().setValue("taxedtype", (Object)newValue);
        view.getModel().setValue("deduction", (Object)"");
        HashMap<String, String> hsbzSelectMap = new HashMap<String, String>();
        hsbzSelectMap.put(ResManager.loadKDString((String)"\u542b\u7a0e", (String)"CreateInvoiceControl_3", (String)"imc-sim-service", (Object[])new Object[0]), "1");
        hsbzSelectMap.put(ResManager.loadKDString((String)"\u4e0d\u542b\u7a0e", (String)"CreateInvoiceControl_4", (String)"imc-sim-service", (Object[])new Object[0]), "0");
        ViewUtil.setDropDownViewData((AbstractFormPlugin)formPlugin, (String)"hsbz", hsbzSelectMap);
        HashMap<String, String> issueTypeSelectMap = new HashMap<String, String>();
        issueTypeSelectMap.put(ResManager.loadKDString((String)"\u6b63\u6570\u53d1\u7968", (String)"CreateInvoiceControl_2", (String)"imc-sim-service", (Object[])new Object[0]), "0");
        issueTypeSelectMap.put(ResManager.loadKDString((String)"\u8d1f\u6570\u53d1\u7968", (String)"CreateInvoiceControl_5", (String)"imc-sim-service", (Object[])new Object[0]), "1");
        ViewUtil.setDropDownViewData((AbstractFormPlugin)formPlugin, (String)"issuetype", issueTypeSelectMap);
        view.setEnable(Boolean.TRUE, new String[]{"remark"});
        view.getModel().setValue("remark", (Object)"");
        CreateInvoiceControl.changeZSFS(formPlugin, view);
    }

    public static void changeZSFS(AbstractFormPlugin formPlugin, IFormView view) {
        HashMap<String, Object> showDataMap = new HashMap<String, Object>();
        showDataMap.put("eventkey", "setzsfs");
        showDataMap.put("kplx", String.valueOf(IssueTypeEnum.blue.getValue()));
        Object zsfs = view.getModel().getValue("taxedtype");
        showDataMap.put("zsfs", zsfs);
        if (EnterpriseHelper.isLqptChannel((String)((String)view.getModel().getValue("salertaxno")))) {
            showDataMap.put("channelType", "leqi");
            showDataMap.put("companyType", "38");
        } else {
            showDataMap.put("channelType", "rpa");
        }
        IDataModel model = view.getModel();
        showDataMap.put("specialtype", model.getValue("specialtype"));
        showDataMap.put("invoicetype", model.getValue("invoicetype"));
        ViewUtil.bindDataToHtml((AbstractFormPlugin)formPlugin, showDataMap, (String)"customcontrolap");
    }

    public static void updateBuyerTaxNo(String ars, AbstractFormPlugin formPlugin, String taxNoKey, String taxNameKey) {
        JSONObject jsonObject = JSONObject.parseObject((String)ars);
        if (StringUtils.isNotBlank((CharSequence)jsonObject.getString("tax"))) {
            formPlugin.getView().getModel().setValue(taxNoKey, jsonObject.get((Object)"tax"));
        }
        formPlugin.getView().getModel().setValue(taxNameKey, jsonObject.get((Object)"name"));
        formPlugin.getView().updateView(taxNoKey);
        formPlugin.getView().updateView(taxNameKey);
    }

    public static void disableInvoiceToolBar(Boolean flag, AbstractFormPlugin formPlugin, IFormView view) {
        ComboEditUtil.setComboEditDefault((AbstractFormPlugin)formPlugin, (String)"invoicetype");
        formPlugin.getView().setEnable(Boolean.FALSE, new String[]{"invoicetype"});
        view.setEnable(Boolean.FALSE, new String[]{"taxedtype"});
        view.setEnable(Boolean.FALSE, new String[]{"hsbz"});
        view.setVisible(Boolean.FALSE, new String[]{"btnred"});
        view.setVisible(flag, new String[]{"btnflush"});
        view.setVisible(flag, new String[]{"btnsave"});
    }

    public static void batchJumpShowView(Object batchFid, AbstractFormPlugin plugin) {
        plugin.getPageCache().put("editType", "1");
        plugin.getView().setVisible(Boolean.TRUE, new String[]{"flexbuyername"});
        plugin.getView().setVisible(Boolean.FALSE, new String[]{"custombuyername"});
        CreateInvoiceControl.initBatchJumpDataAndView(batchFid, false, plugin, plugin.getView());
    }

    public static void batchJumpEditView(Object batchFid, AbstractFormPlugin formPlugin) {
        formPlugin.getPageCache().put("editType", "0");
        formPlugin.getView().setVisible(Boolean.FALSE, new String[]{"flexbuyername"});
        formPlugin.getView().setVisible(Boolean.TRUE, new String[]{"custombuyername"});
        CreateInvoiceControl.initBatchJumpDataAndView(batchFid, true, formPlugin, formPlugin.getView());
    }

    public static void initBatchJumpDataAndView(Object batchFid, boolean editFlag, AbstractFormPlugin formPlugin, IFormView view) {
        CreateInvoiceControl.disableInvoiceToolBar(editFlag, formPlugin, view);
        CreateInvoiceControl.disableOrEnableSaler(editFlag, view);
        CreateInvoiceControl.disableOrEnableBuyer(editFlag, formPlugin);
        CreateInvoiceWaitControl.initBatchJumpAndView(formPlugin, view, batchFid, editFlag);
    }

    public static void addDeduction(String args, AbstractFormPlugin formPlugin) {
        if (StringUtils.isEmpty((CharSequence)args)) {
            formPlugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u660e\u7ec6\u884c\u4fe1\u606f", (String)"CreateInvoiceControl_6", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        JSONArray array = JSONArray.parseArray((String)args);
        BigDecimal amount = ((JSONObject)array.get(0)).getBigDecimal("xmjehs");
        if (StringUtils.isBlank((CharSequence)formPlugin.getPageCache().get(REISSUE_INVALID)) && (amount == null || amount.compareTo(BigDecimal.ZERO) <= 0)) {
            formPlugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u5546\u54c1\u91d1\u989d", (String)"CreateInvoiceControl_7", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        String taxRate = ((JSONObject)array.get(0)).getString("sl");
        if (InvoiceConstant.TAX_015.toString().equals(taxRate)) {
            formPlugin.getView().showTipNotification(ResManager.loadKDString((String)"\u5dee\u989d\u5f81\u7a0e\u65b9\u5f0f\u7a0e\u7387\u4e0d\u80fd\u4e3a1.5%", (String)"CreateInvoiceControl_8", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        HashMap<String, BigDecimal> deductParamMap = new HashMap<String, BigDecimal>();
        deductParamMap.put("amount", amount);
        ViewUtil.openDialog((AbstractFormPlugin)formPlugin, deductParamMap, (String)"sim_deduction_dialog", (String)"callback_sim_deduction_dialog");
    }

    public static void handleSelectInvoiceVolumn(ClosedCallBackEvent event, AbstractFormPlugin formPlugin) {
        Map map = (Map)event.getReturnData();
        if (MapUtils.isNotEmpty((Map)map)) {
            HashMap<String, String> sjdMap = new HashMap<String, String>();
            sjdMap.put("fpdm", ObjectUtils.defaultIfNull(map.get("invoice_code"), (Object)"").toString());
            sjdMap.put("fphm", ObjectUtils.defaultIfNull(map.get("invoice_num"), (Object)"").toString());
            sjdMap.put("kpzl", InvoiceType.PAPER_NOMAL_INVOICE.getTypeCodeHx());
            String deviceId = formPlugin.getView().getModel().getValue("jqbh") == null ? "" : formPlugin.getView().getModel().getValue("jqbh").toString();
            SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)CreateInvoiceControl.getOrgIdByView(formPlugin));
            ComponentResponse componentResponse = ComponentServiceHelper.doPost((String)ComponentServiceHelper.getComponentRequestUrl((String)deviceId), (String)JSON.toJSONString((Object)new ComponentRequest(ComponentInterfaceTypeEnum.SETINVOICEVOLUME.getCzlx(), sjdMap, null, saleInfo.getDefaultTerminal())), Map.class);
            if (!"0".equals(componentResponse.getErrcode())) {
                throw new KDBizException(String.format("%s(%s)", ResManager.loadKDString((String)"\u9009\u62e9\u53d1\u7968\u5377\u5f02\u5e38", (String)"CreateInvoiceControl_9", (String)"imc-sim-service", (Object[])new Object[0]), componentResponse.getDescription()));
            }
            formPlugin.getView().getModel().setValue("invoicecode", sjdMap.get("invoice_code"));
            formPlugin.getView().getModel().setValue("invoiceno", sjdMap.get("invoice_num"));
        }
    }

    public static void setNextInvoiceCodeNo(IFormView view) {
        if (view.getModel().getValue("jqbh") == null || StringUtils.isEmpty((CharSequence)view.getModel().getValue("jqbh").toString()) || InvoiceUtils.isAllEInvoice((Object)((String)view.getModel().getValue("invoicetype")))) {
            return;
        }
        view.setVisible(Boolean.TRUE, new String[]{"flexsurplus"});
        String equipmentNo = ObjectUtils.defaultIfNull((Object)view.getModel().getValue("jqbh"), (Object)"").toString();
        String terminalNo = ObjectUtils.defaultIfNull((Object)view.getModel().getValue("terminalno"), (Object)"").toString();
        String invoiceType = ObjectUtils.defaultIfNull((Object)view.getModel().getValue("invoicetype"), (Object)"").toString();
        String equipmentType = DeviceUtil.getDevType((String)equipmentNo);
        String taxNo = ObjectUtils.defaultIfNull((Object)view.getModel().getValue("salertaxno"), (Object)"").toString();
        switch (equipmentType) {
            case "3": {
                CreateInvoiceControl.setNextInvoiceCodeNoNull(view);
                break;
            }
            case "8": {
                if (StringUtils.isBlank((CharSequence)terminalNo)) {
                    CreateInvoiceControl.setNextInvoiceCodeNoNull(view);
                }
                MsgResponse bwResponse = BwServerInvoiceHelper.getInvoiceStock((String)equipmentNo, (String)terminalNo, (String)invoiceType, (String)equipmentNo, (String)taxNo);
                CreateInvoiceControl.handleNextInvoiceCodeNo(view, invoiceType, bwResponse);
                break;
            }
            case "9": 
            case "10": 
            case "11": {
                MsgResponse lyResponse = LyServerInvoiceHelper.getInvoiceStock((String)equipmentNo, (String)terminalNo, (String)invoiceType, (String)equipmentNo, (String)taxNo);
                CreateInvoiceControl.handleNextInvoiceCodeNo(view, invoiceType, lyResponse);
                break;
            }
            case "4": 
            case "6": 
            case "7": {
                MsgResponse msgResponse = HostModeInvoiceHelper.getInvoiceStock((String)taxNo, (String)invoiceType, (String)equipmentNo);
                CreateInvoiceControl.handleNextInvoiceCodeNo(view, invoiceType, msgResponse);
                break;
            }
            case "0": 
            case "1": 
            case "2": {
                ComponentResponse<PaperInvoiceRollInfoDTO> response = CreateInvoiceControl.getPaperStock(equipmentNo, terminalNo, invoiceType);
                if (response.isSucess() && response.getResponse() != null && ((PaperInvoiceRollInfoDTO)response.getResponse()).getInfo() != null) {
                    view.getModel().setValue("surplus", (Object)String.format(ResManager.loadKDString((String)"\u5269\u4f59\u7968\u91cf\uff1a %s\u4efd", (String)"CreateInvoiceControl_10", (String)"imc-sim-service", (Object[])new Object[0]), ((PaperInvoiceRollInfoDTO)response.getResponse()).getInfo().getRemainder()));
                    if (InvoiceUtils.getPaperInvoiceType().contains(invoiceType)) {
                        view.getModel().setValue("invoicecode", (Object)((PaperInvoiceRollInfoDTO)response.getResponse()).getInfo().getInvoice_code());
                        view.getModel().setValue("invoiceno", (Object)((PaperInvoiceRollInfoDTO)response.getResponse()).getInfo().getInvoice_num());
                        break;
                    }
                    view.getModel().setValue("invoicecode", (Object)"");
                    view.getModel().setValue("invoiceno", (Object)"");
                    break;
                }
                if (!"\u6210\u529f".equals(response.getDescription())) {
                    view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5269\u4f59\u7968\u91cf\u5931\u8d25\uff1a%s", (String)"CreateInvoiceControl_11", (String)"imc-sim-service", (Object[])new Object[0]), response.getDescription()));
                }
                CreateInvoiceControl.setNextInvoiceCodeNoNull(view);
                break;
            }
            default: {
                CreateInvoiceControl.setNextInvoiceCodeNoNull(view);
            }
        }
    }

    private static void handleNextInvoiceCodeNo(IFormView view, String invoiceType, MsgResponse response) {
        if (ErrorType.SUCCESS.getCode().equals(response.getErrorCode())) {
            JSONObject retJson = JSONObject.parseObject((String)response.getRespData());
            String remainder = retJson.getString("remainder");
            view.getModel().setValue("surplus", (Object)String.format(ResManager.loadKDString((String)"\u5269\u4f59\u7968\u91cf\uff1a %s\u4efd", (String)"CreateInvoiceControl_10", (String)"imc-sim-service", (Object[])new Object[0]), StringUtils.isNotEmpty((CharSequence)remainder) ? remainder : "0"));
            if (InvoiceUtils.getPaperInvoiceType().contains(invoiceType)) {
                view.getModel().setValue("invoicecode", (Object)retJson.getString("invoice_code"));
                view.getModel().setValue("invoiceno", (Object)retJson.getString("invoice_num"));
            } else {
                view.getModel().setValue("invoicecode", (Object)"");
                view.getModel().setValue("invoiceno", (Object)"");
            }
        } else {
            CreateInvoiceControl.setNextInvoiceCodeNoNull(view);
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5269\u4f59\u7968\u91cf\u5931\u8d25\uff1a%s", (String)"CreateInvoiceControl_11", (String)"imc-sim-service", (Object[])new Object[0]), response.getErrorMsg()));
        }
    }

    public static void setNextInvoiceCodeNoNull(IFormView view) {
        view.getModel().setValue("invoiceno", (Object)"");
        view.getModel().setValue("invoicecode", (Object)"");
        view.getModel().setValue("surplus", (Object)ResManager.loadKDString((String)"\u5269\u4f59\u7968\u91cf\uff1a 0\u4efd", (String)"CreateInvoiceControl_12", (String)"imc-sim-service", (Object[])new Object[0]));
    }

    public static void setCreditQuota(AbstractFormPlugin that) {
        String creditQuota = SpecialTypeEnum.PURCHASE_OF_AGRICULTURAL_PRODUCTS_02.getValue().equals(that.getView().getModel().getValue("specialtype")) ? CreditQuotaHelper.getCreditQuota((AbstractFormPlugin)that, (String)((String)that.getView().getModel().getValue("buyertaxno"))) : CreditQuotaHelper.getCreditQuota((AbstractFormPlugin)that, (String)((String)that.getView().getModel().getValue("salertaxno")));
        that.getView().getModel().setValue("surplus", (Object)String.format(ResManager.loadKDString((String)"\u53ef\u7528\u6388\u4fe1\u989d\u5ea6\uff1a%s\u5143", (String)"CreateInvoiceControl_13", (String)"imc-sim-service", (Object[])new Object[0]), creditQuota));
    }

    private static ComponentResponse<PaperInvoiceRollInfoDTO> getPaperStock(String equipmentNo, String terminalNo, String invoiceType) {
        ComponentRequest request = new ComponentRequest(ComponentInterfaceTypeEnum.GETINVOICEINFO.getCzlx(), null, null, terminalNo);
        request.setInvoice_type(InvoiceType.getTypeCodeHx((String)invoiceType));
        return ComponentServiceHelper.doPost((String)ComponentServiceHelper.getComponentRequestUrl((String)equipmentNo), (String)JSON.toJSONString((Object)request), PaperInvoiceRollInfoDTO.class);
    }

    public static void bindViewFromReIssue(String orderNo, Object pk, AbstractFormPlugin plugin) {
        plugin.getPageCache().put("editType", "0");
        DynamicObject invoiceDynamicObject = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"sim_vatinvoice");
        String reOrderNo = invoiceDynamicObject.getString("reorderno");
        plugin.getPageCache().put("singleIssueReOrderNo", reOrderNo);
        CreateInvoiceControl.autoBaseInit(invoiceDynamicObject, plugin);
        plugin.getView().getModel().setValue("invoicecode", null);
        plugin.getView().getModel().setValue("invoiceno", null);
        CreateInvoiceCustomViewControl.initCustomInvalidViewData(plugin, invoiceDynamicObject);
        CreateInvoiceControl.editAble(Boolean.TRUE, plugin, invoiceDynamicObject);
        CreateInvoiceControl.visibleControl(plugin);
        CreateInvoiceControl.setEquipmentAndTerminalNoByInvoiceDynamicObject(plugin, invoiceDynamicObject);
        plugin.getView().getModel().setValue("jqbh", (Object)invoiceDynamicObject.getString("jqbh"));
        plugin.getView().getModel().setValue("terminalno", (Object)invoiceDynamicObject.getString("terminalno"));
        plugin.getView().getModel().setValue("startleasedate", invoiceDynamicObject.get("startleasedate"));
        plugin.getView().getModel().setValue("endleasedate", invoiceDynamicObject.get("endleasedate"));
        CreateInvoiceControl.bindInvoiceTypeLabel(plugin, invoiceDynamicObject.getString("invoicetype"));
        CreateInvoiceControl.showTobaccoLabel(plugin, invoiceDynamicObject, Boolean.FALSE);
        plugin.getView().getModel().setValue("orderno", (Object)orderNo);
        plugin.getView().getModel().setValue("orgid", invoiceDynamicObject.getDynamicObject("orgid").getPkValue());
        plugin.getView().getModel().setValue("buyerproperty", (Object)invoiceDynamicObject.getString("buyerproperty"));
        CreateInvoiceBaseControl.setCreateInvoiceEstateTime(invoiceDynamicObject, plugin);
    }

    public static void bindInvoiceTypeLabel(AbstractFormPlugin plugin, String invoiceType) {
        String labelName = null;
        if (InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode().equals(invoiceType)) {
            labelName = "\u589e\u503c\u7a0e\u7535\u5b50\u4e13\u7528\u53d1\u7968";
        }
        if (InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode().equals(invoiceType)) {
            labelName = "\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968";
        }
        if (InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode().equals(invoiceType)) {
            labelName = "\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968";
        } else if (InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode().equals(invoiceType)) {
            labelName = "\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968";
        } else if (InvoiceType.ALL_E_NORMAL.getTypeCode().equals(invoiceType)) {
            labelName = "\u6570\u7535\u53d1\u7968\uff08\u666e\u901a\u53d1\u7968\uff09";
        } else if (InvoiceType.ALL_E_SPECIAL.getTypeCode().equals(invoiceType)) {
            labelName = "\u6570\u7535\u53d1\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09";
        }
        Label label = (Label)plugin.getView().getControl("labeinvoicetype");
        label.setText(labelName);
    }

    public static void changeTravelerTypeLabel(AbstractFormPlugin plugin) {
        String labelName = null;
        String invoiceType = (String)plugin.getView().getModel().getValue("invoicetype");
        if (InvoiceType.ALL_E_NORMAL.getTypeCode().equals(invoiceType)) {
            labelName = "\u6570\u7535\u53d1\u7968\uff08\u666e\u901a\u53d1\u7968\uff09";
        } else if (InvoiceType.ALL_E_SPECIAL.getTypeCode().equals(invoiceType)) {
            labelName = "\u6570\u7535\u53d1\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09";
        }
        Label label = (Label)plugin.getView().getControl("labeinvoicetype");
        String name = ResManager.loadKDString((String)"--\u65c5\u5ba2\u8fd0\u8f93\u670d\u52a1", (String)"CreateInvoiceControl_15", (String)"imc-sim-service", (Object[])new Object[0]);
        label.setText(labelName + name);
    }

    public static void changeVesselVehicheTypeLabel(AbstractFormPlugin plugin) {
        String labelName = null;
        String invoiceType = (String)plugin.getView().getModel().getValue("invoicetype");
        if (InvoiceType.ALL_E_NORMAL.getTypeCode().equals(invoiceType)) {
            labelName = "\u6570\u7535\u53d1\u7968\uff08\u666e\u901a\u53d1\u7968\uff09";
        } else if (InvoiceType.ALL_E_SPECIAL.getTypeCode().equals(invoiceType)) {
            labelName = "\u6570\u7535\u53d1\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09";
        }
        Label label = (Label)plugin.getView().getControl("labeinvoicetype");
        String name = ResManager.loadKDString((String)"--\u4ee3\u6536\u8f66\u8239\u7a0e", (String)"CreateInvoiceControl_16", (String)"imc-sim-service", (Object[])new Object[0]);
        label.setText(labelName + name);
    }

    public static void fixTaxDiff(AbstractFormPlugin plugin, String ars) {
        String diff = plugin.getPageCache().get("tempTaxDiff");
        if (StringUtils.isNotBlank((CharSequence)diff)) {
            JSONObject taxdiff = JSONObject.parseObject((String)ars);
            DecimalFormat df = new DecimalFormat("0.00");
            String taxdiffStr = df.format(new BigDecimal(diff).subtract(new BigDecimal(taxdiff.getString("taxdiff"))));
            plugin.getView().getModel().setValue("taxdiff", (Object)String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u7a0e\u989d\u5c3e\u5dee\uff1a%s", (String)"CreateInvoiceControl_14", (String)"imc-sim-service", (Object[])new Object[0]), taxdiffStr));
        }
    }

    public static void queryLikeGoodsByName(AbstractFormPlugin plugin, String ars) {
        JSONObject json = JSONObject.parseObject((String)ars);
        String value = String.valueOf(plugin.getView().getModel().getValue("checkboxtobacco"));
        boolean isTobacco = "11".equals(value);
        QFilter markFilter = ImcBaseDataHelper.getGoodsInfoFilter((Object)CreateInvoiceControl.getOrgIdByView(plugin));
        markFilter.and("name", "like", (Object)("%" + json.getString("value") + "%"));
        markFilter.and("taxcode.number", isTobacco ? "like" : "not like", (Object)"1030402%");
        DynamicObject[] goodsInfoList = BusinessDataServiceHelper.load((String)"bdm_goods_info", (String)GoodsInfoConstant.SELECT_PROPERTIES, (QFilter[])markFilter.toArray());
        ArrayList goodsList = new ArrayList(goodsInfoList.length);
        for (DynamicObject goodsInfoObj : goodsInfoList) {
            DynamicObject dynamicObject = goodsInfoObj.getDynamicObject("taxcode");
            HashMap<String, String> tmpMap = new HashMap<String, String>();
            tmpMap.put("index", json.getString("index"));
            tmpMap.put("ggxh", goodsInfoObj.getString("specifications"));
            String taxRate = goodsInfoObj.getString("taxrate");
            tmpMap.put("sl", taxRate);
            tmpMap.put("slText", taxRate);
            tmpMap.put("spbm", dynamicObject.getString("mergecode"));
            tmpMap.put("spmc", "*" + dynamicObject.get("simplename") + "*");
            BigDecimal price = goodsInfoObj.getBigDecimal("price");
            String xmdjStr = MathUtils.isNullOrZero((BigDecimal)price) ? "" : price.stripTrailingZeros().toPlainString();
            BigDecimal prices = goodsInfoObj.getBigDecimal("prices");
            String xmdjsStr = MathUtils.isNullOrZero((BigDecimal)prices) ? "" : prices.stripTrailingZeros().toPlainString();
            String hsbz = goodsInfoObj.getString("isinclusive");
            if ("1".equals(hsbz)) {
                tmpMap.put("xmdj", xmdjsStr);
                tmpMap.put("xmdjhs", xmdjStr);
            } else {
                tmpMap.put("xmdj", xmdjStr);
                tmpMap.put("xmdjhs", xmdjsStr);
            }
            tmpMap.put("xmdw", goodsInfoObj.getString("unit"));
            tmpMap.put("xmmc", "*" + dynamicObject.get("simplename") + "*" + goodsInfoObj.getString("name"));
            goodsList.add(tmpMap);
        }
        HashMap<String, Object> showDataMap = new HashMap<String, Object>(2);
        showDataMap.put("eventkey", "queryName");
        showDataMap.put("goods", goodsList);
        ViewUtil.bindDataToHtml((AbstractFormPlugin)plugin, showDataMap, (String)"customcontrolap");
    }

    public static void changeZsff(String newValue, AbstractFormPlugin plugin, IFormView view) {
        view.getModel().setValue("redremark", null);
        view.getModel().setValue("labelhjse", (Object)"");
        view.getModel().setValue("labelhjje", (Object)"");
        view.getModel().setValue("labeljshj", (Object)"");
        view.getModel().setValue("labeljshjcn", (Object)"");
        if (TaxedTypeEnum.deduction.getValue().equals(newValue)) {
            HashMap<String, String> issueTypeSelectMap = new HashMap<String, String>();
            issueTypeSelectMap.put("\u6b63\u6570\u53d1\u7968", "0");
            ViewUtil.setDropDownViewData((AbstractFormPlugin)plugin, (String)"issuetype", issueTypeSelectMap);
            view.getModel().setValue("taxedtype", (Object)TaxedTypeEnum.deduction.getValue());
            IDataModel model = plugin.getView().getModel();
            HashMap<String, String> showDataMap = new HashMap<String, String>(4);
            showDataMap.put("eventkey", "setzsfs");
            showDataMap.put("kplx", String.valueOf(IssueTypeEnum.deduction.getValue()));
            showDataMap.put("zsfs", newValue);
            showDataMap.put("specialtype", (String)model.getValue("specialtype"));
            showDataMap.put("invoicetype", (String)model.getValue("invoicetype"));
            ViewUtil.bindDataToHtml((AbstractFormPlugin)plugin, showDataMap, (String)"customcontrolap");
        } else {
            CreateInvoiceControl.selectOtherTaxedType(plugin, view, newValue);
        }
    }

    private static void editAble(Boolean enable, AbstractFormPlugin plugin, DynamicObject obj) {
        plugin.getView().setEnable(enable, new String[]{"saleraddr"});
        plugin.getView().setEnable(enable, new String[]{"salerbank"});
        plugin.getView().setEnable(Boolean.FALSE, new String[]{"issuetype", "billno"});
        if (BigDecimalUtil.lessZero((BigDecimal)obj.getBigDecimal("totalamount"))) {
            ViewUtil.setDropDownViewData((AbstractFormPlugin)plugin, (String)"invoicetype", (Map)InvoiceUtils.getRedInvoiceType());
            HashMap<String, String> taxedTypeSelectMap = new HashMap<String, String>();
            taxedTypeSelectMap.put("\u666e\u901a\u5f81\u7a0e", "0");
            taxedTypeSelectMap.put("\u5dee\u989d\u5f81\u7a0e", "2");
            ViewUtil.setDropDownViewData((AbstractFormPlugin)plugin, (String)"taxedtype", taxedTypeSelectMap);
            plugin.getView().setEnable(Boolean.FALSE, new String[]{"taxedtype"});
        }
    }

    private static void visibleControl(AbstractFormPlugin plugin) {
        plugin.getView().setVisible(Boolean.FALSE, new String[]{"btnsave", "btnred", "btnflush"});
        plugin.getView().setVisible(Boolean.FALSE, new String[]{"flexbuyername"});
    }
}

