/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.control;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.bdm.file.fpy.enums.BusinessSectorTypeEnum;
import kd.imc.sim.common.constant.InvoiceConstant;
import kd.imc.sim.common.enums.SeatClassTypeEnum;
import kd.imc.sim.common.enums.TransportTypeEnum;
import kd.imc.sim.common.enums.TravelerCardTypeEnum;
import kd.imc.sim.formplugin.issuing.control.CreateInvoiceBaseControl;
import kd.imc.sim.formplugin.issuing.control.CreateInvoiceControl;
import kd.imc.sim.formplugin.issuing.control.CreateInvoiceWaitControl;

public class CreateInvoiceCustomViewControl {
    private static final String REISSUE_INVALID = "REISSUE_INVALID";
    public static final String EDIT_UNENABLE = "0";
    public static final String EDIT_ENABLE = "1";
    private static final Log LOGGER = LogFactory.getLog(CreateInvoiceCustomViewControl.class);

    public static void initCustomViewData(AbstractFormPlugin formPlugin, String editType, String issueType, BigDecimal taxDiff) {
        IDataModel model = formPlugin.getView().getModel();
        CreateInvoiceCustomViewControl.initCustomViewItems(formPlugin, editType, issueType, model.getValue("taxedtype").toString(), taxDiff);
        CreateInvoiceCustomViewControl.initQueryTitleCustomView(formPlugin, model.getValue("buyername"), "querytitlediy", formPlugin.getView().getPageId());
        CreateInvoiceCustomViewControl.initQueryTitleCustomView(formPlugin, model.getValue("salername"), "salernamediy", formPlugin.getView().getPageId() + "2");
    }

    private static void initCustomViewItems(AbstractFormPlugin formPlugin, String editType, String issueType, String zsfs, BigDecimal taxDiff) {
        String vesselShipItems;
        String travelerItems;
        String freightItems;
        HashMap<String, Object> showDataMap = new HashMap<String, Object>(2);
        String items = formPlugin.getPageCache().get("loadItems");
        String deducItems = formPlugin.getPageCache().get("loadDeducItems");
        if (StringUtils.isNotEmpty((String)deducItems)) {
            showDataMap.put("deducItems", JSON.parseArray((String)deducItems));
        }
        if (StringUtils.isNotEmpty((String)(freightItems = formPlugin.getPageCache().get("loadFreightItems")))) {
            showDataMap.put("freights", JSON.parseArray((String)freightItems));
        }
        if (StringUtils.isNotEmpty((String)(travelerItems = formPlugin.getPageCache().get("loadTravelerItems")))) {
            showDataMap.put("travels", JSON.parseArray((String)travelerItems));
            showDataMap.put("travelerList", CreateInvoiceCustomViewControl.getTravelerListMethod());
        }
        if (StringUtils.isNotEmpty((String)(vesselShipItems = formPlugin.getPageCache().get("loadVesselShipItems")))) {
            showDataMap.put("vehichevesselships", JSON.parseArray((String)vesselShipItems));
        }
        showDataMap.put("items", InvoiceUtils.convertField2String((JSONArray)JSON.parseArray((String)items)));
        showDataMap.put("editType", editType);
        showDataMap.put("kplx", issueType);
        showDataMap.put("zsfs", zsfs);
        boolean lqptChannel = EnterpriseHelper.isLqptChannel((String)((String)formPlugin.getView().getModel().getValue("salertaxno")));
        if (lqptChannel) {
            showDataMap.put("channelType", "leqi");
        } else {
            showDataMap.put("channelType", "rpa");
        }
        DynamicObject epInfoByOrg = TaxUtils.getEpInfoByOrg((Long)CreateInvoiceBaseControl.getOrgIdByView(formPlugin));
        if (epInfoByOrg != null && epInfoByOrg.getString("qyhyxzdm").contains(BusinessSectorTypeEnum.HOUSING_LEASING_COMPANIES.getValue())) {
            showDataMap.put("companyType", "38");
        } else {
            showDataMap.put("companyType", EDIT_UNENABLE);
        }
        showDataMap.put("specialtype", formPlugin.getView().getModel().getValue("specialtype"));
        if (StringUtils.isNotEmpty((String)formPlugin.getPageCache().get("waitFromBill")) && StringUtils.isNotEmpty((String)formPlugin.getPageCache().get("click_edit"))) {
            showDataMap.put("taxAdjustMode", EDIT_UNENABLE);
        } else {
            showDataMap.put("taxAdjustMode", "-1");
        }
        showDataMap.put("eventkey", "loadData");
        showDataMap.put("hsbz", formPlugin.getView().getModel().getValue("hsbz"));
        if (taxDiff != null && taxDiff.abs().compareTo(BigDecimal.ZERO) > 0) {
            showDataMap.put("taxdiff", taxDiff.toPlainString());
            showDataMap.put("taxequipment", InvoiceConstant.DIFFF_06);
        }
        showDataMap.put("taxAdjustMode", formPlugin.getPageCache().get("taxAdjustMode"));
        ViewUtil.bindDataToHtml((AbstractFormPlugin)formPlugin, showDataMap, (String)"customcontrolap");
    }

    public static void initCustomInvalidViewData(AbstractFormPlugin formPlugin, DynamicObject invoiceDynamicObject) {
        IDataModel model = formPlugin.getView().getModel();
        CreateInvoiceWaitControl.putItems2PageCache(formPlugin, invoiceDynamicObject);
        formPlugin.getPageCache().put(REISSUE_INVALID, REISSUE_INVALID);
        model.setValue("taxedtype", (Object)invoiceDynamicObject.getString("taxedtype"));
        String editType = formPlugin.getPageCache().get("editType");
        CreateInvoiceCustomViewControl.initCustomViewItems(formPlugin, editType, invoiceDynamicObject.getString("issuetype"), invoiceDynamicObject.getString("taxedtype"), null);
        CreateInvoiceCustomViewControl.initQueryTitleCustomView(formPlugin, model.getValue("buyername"), "querytitlediy", invoiceDynamicObject.getPkValue() + "");
        if ("02".equals(formPlugin.getView().getModel().getValue("specialtype"))) {
            CreateInvoiceCustomViewControl.initQueryTitleCustomView(formPlugin, model.getValue("salername"), "salernamediy", formPlugin.getView().getPageId() + "2");
        }
    }

    public static void initQueryTitleCustomView(AbstractFormPlugin formPlugin, Object cacheBuyerName, String key, String pageId) {
        HashMap<String, Object> titleMap = new HashMap<String, Object>(6);
        titleMap.put("inputStyle", "text-indent: 8px;height: 28px;width: 100%; font-size: 14px;");
        titleMap.put("buyername", cacheBuyerName);
        titleMap.put("eventkey", "loadData");
        ViewUtil.bindDataToHtml((AbstractFormPlugin)formPlugin, titleMap, (String)key, (String)pageId);
    }

    public static void updateTitleToCustomView(AbstractFormPlugin formPlugin, String customViewKey, String buyerName) {
        HashMap<String, String> showDataMap = new HashMap<String, String>(6);
        showDataMap.put("buyername", buyerName);
        showDataMap.put("isInit", EDIT_ENABLE);
        showDataMap.put("eventkey", "updateTitle");
        if (customViewKey.equals("querytitlediy")) {
            ViewUtil.bindDataToHtml((AbstractFormPlugin)formPlugin, showDataMap, (String)customViewKey);
        } else {
            ViewUtil.bindDataToHtml((AbstractFormPlugin)formPlugin, showDataMap, (String)customViewKey, (String)(formPlugin.getView().getPageId() + "2"));
        }
    }

    public static void updateItemEnable(AbstractFormPlugin plugin) {
        HashMap<String, Object> showDataMap = new HashMap<String, Object>(6);
        IDataModel model = plugin.getView().getModel();
        showDataMap.put("invoicetype", model.getValue("invoicetype"));
        showDataMap.put("specialtype", model.getValue("specialtype"));
        showDataMap.put("zsfs", model.getValue("taxedtype"));
        showDataMap.put("eventkey", "setSpecialtype");
        String specialType = (String)model.getValue("specialtype");
        if ("E09".equals(specialType)) {
            showDataMap.put("travelerList", CreateInvoiceCustomViewControl.getTravelerListMethod());
        }
        ViewUtil.bindDataToHtml((AbstractFormPlugin)plugin, showDataMap, (String)"customcontrolap");
    }

    private static Object getTravelerListMethod() {
        HashMap<String, List<Map<String, String>>> dataMap = new HashMap<String, List<Map<String, String>>>(8);
        dataMap.put("cardTypeList", CreateInvoiceCustomViewControl.getCardTypeListMethod());
        dataMap.put("transportTypeList", CreateInvoiceCustomViewControl.getTransportTypeListMethod());
        dataMap.put("seatClassList", CreateInvoiceCustomViewControl.getSeatClassListMethod());
        return dataMap;
    }

    private static List<Map<String, String>> getCardTypeListMethod() {
        ArrayList<Map<String, String>> cardTypeList = new ArrayList<Map<String, String>>(8);
        for (TravelerCardTypeEnum travelerCardTypeEnum : TravelerCardTypeEnum.values()) {
            HashMap<String, String> cardTypeMap = new HashMap<String, String>(8);
            cardTypeMap.put("value", travelerCardTypeEnum.getCode());
            cardTypeMap.put("text", travelerCardTypeEnum.getDesc());
            cardTypeList.add(cardTypeMap);
        }
        return cardTypeList;
    }

    private static List<Map<String, String>> getTransportTypeListMethod() {
        ArrayList<Map<String, String>> transportTypeList = new ArrayList<Map<String, String>>(8);
        for (TransportTypeEnum transportTypeEnum : TransportTypeEnum.values()) {
            HashMap<String, String> transportTypeMap = new HashMap<String, String>(16);
            transportTypeMap.put("value", transportTypeEnum.getCode());
            transportTypeMap.put("text", transportTypeEnum.getDesc());
            transportTypeList.add(transportTypeMap);
        }
        return transportTypeList;
    }

    private static List<Map<String, String>> getSeatClassListMethod() {
        ArrayList<Map<String, String>> seatClassList = new ArrayList<Map<String, String>>(8);
        for (SeatClassTypeEnum seatClassTypeEnum : SeatClassTypeEnum.values()) {
            HashMap<String, String> seatClassMap = new HashMap<String, String>(16);
            seatClassMap.put("value", seatClassTypeEnum.getName());
            seatClassMap.put("text", seatClassTypeEnum.getDesc() + "-" + seatClassTypeEnum.getName());
            seatClassList.add(seatClassMap);
        }
        return seatClassList;
    }

    public static void handleCustomViewEvent(AbstractFormPlugin formPlugin, String event, String ars) {
        switch (event) {
            case "tipNotify": {
                formPlugin.getView().showTipNotification(ars, Integer.valueOf(2000));
                break;
            }
            case "success": {
                formPlugin.getView().showSuccessNotification(ars, Integer.valueOf(2000));
                break;
            }
            case "opendiscount": {
                CreateInvoiceControl.getDiscount(ars, formPlugin);
                break;
            }
            case "queryGoods": {
                CreateInvoiceControl.queryGoods(ars, formPlugin);
                break;
            }
            case "queryTitle": {
                formPlugin.getView().getModel().setValue("buyername", (Object)ars);
                formPlugin.getView().addClientCallBack("queryTitle");
                break;
            }
            case "queryTitleSaler": {
                CreateInvoiceControl.queryBuyerTitle(ars, "salernamediy", formPlugin, formPlugin.getView().getPageId() + "2");
                formPlugin.getView().getModel().setValue("salername", (Object)ars);
                break;
            }
            case "updateBuyerTaxNo": {
                CreateInvoiceControl.updateBuyerTaxNo(ars, formPlugin, "buyertaxno", "buyername");
                break;
            }
            case "updateBuyerTaxNoSaler": {
                CreateInvoiceControl.updateBuyerTaxNo(ars, formPlugin, "salertaxno", "salername");
                break;
            }
            case "chooseTitle": {
                CreateInvoiceCustomViewControl.clickTitleSearchIcon(formPlugin, "close_call_back_buyer_name");
                break;
            }
            case "chooseTitleSaler": {
                CreateInvoiceCustomViewControl.clickTitleSearchIcon(formPlugin, "close_call_back_seller_name");
                break;
            }
            case "addDeduction": {
                CreateInvoiceControl.addDeduction(ars, formPlugin);
                break;
            }
            case "chooseAllEInvoice": {
                CreateInvoiceCustomViewControl.openInvoiceF7(formPlugin, event, "in", ars);
                break;
            }
            case "chooseInvoice": {
                CreateInvoiceCustomViewControl.openInvoiceF7(formPlugin, event, "not in", ars);
                break;
            }
            case "addNewRow": {
                CreateInvoiceCustomViewControl.updateItemEnable(formPlugin);
                break;
            }
            case "checkback": {
                if (ars.equals(EDIT_ENABLE)) {
                    ViewUtil.openNormalConfirm((AbstractFormPlugin)formPlugin, (String)ResManager.loadKDString((String)"\u66f4\u6539\u5f81\u7a0e\u65b9\u5f0f\u65f6\uff0c\u5c06\u4f1a\u628a\u73b0\u6709\u6dfb\u52a0\u7684\u5546\u54c1\u5220\u9664\u91cd\u65b0\u586b\u5199\uff0c\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"CreateInvoiceCustomViewControl_0", (String)"imc-sim-service", (Object[])new Object[0]), (String)"taxedtype");
                    break;
                }
                CreateInvoiceControl.changeZsff(formPlugin.getPageCache().get("taxedtype"), formPlugin, formPlugin.getView());
                break;
            }
            case "queryName": {
                CreateInvoiceControl.queryLikeGoodsByName(formPlugin, ars);
                break;
            }
            case "fixTaxDiff": {
                CreateInvoiceControl.fixTaxDiff(formPlugin, ars);
                break;
            }
            case "queryPlace": {
                ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"bdm_admindivision", (boolean)false, (int)2, (boolean)true);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, "queryPlace"));
                formPlugin.getView().showForm((FormShowParameter)showParameter);
                formPlugin.getPageCache().put(formPlugin.getView().getPageId() + "queryPlace", ars);
                break;
            }
            case "queryTravelerPlace": {
                ListShowParameter showParameter2 = ShowFormHelper.createShowListForm((String)"bdm_admindivision", (boolean)false, (int)2, (boolean)true);
                showParameter2.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, "queryTravelerPlace"));
                formPlugin.getView().showForm((FormShowParameter)showParameter2);
                formPlugin.getPageCache().put(formPlugin.getView().getPageId() + "queryTravelerPlace", ars);
                break;
            }
            case "updateDeducation": {
                JSONArray jsons = JSONObject.parseArray((String)ars);
                BigDecimal deducAmount = BigDecimal.ZERO;
                for (Object json : jsons) {
                    String deductionAmount = ((JSONObject)json).getString("deductionamount");
                    if (!StringUtils.isNotEmpty((String)deductionAmount)) continue;
                    deducAmount = deducAmount.add(new BigDecimal(deductionAmount));
                }
                String remark = (String)formPlugin.getView().getModel().getValue("remark");
                String deducRemarkStart = "\u6263\u9664\u989d\uff1a%s\u3002".substring(0, 3);
                if (StringUtils.isNotEmpty((String)remark) && remark.startsWith(deducRemarkStart) && remark.contains("\u3002")) {
                    int index = remark.indexOf("\u3002");
                    if ((remark = remark.length() == index + 1 ? "" : remark.substring(index + 1)).startsWith(System.lineSeparator())) {
                        remark = remark.replace(System.lineSeparator(), "");
                    }
                    if (remark.startsWith("\n")) {
                        remark = remark.replace("\n", "");
                    }
                }
                String deductionRemark = "";
                if (!BigDecimalUtil.compareZero((BigDecimal)deducAmount)) {
                    deductionRemark = String.format("\u6263\u9664\u989d\uff1a%s\u3002", deducAmount.setScale(2, 4).stripTrailingZeros().toPlainString());
                }
                remark = StringUtils.isBlank((String)deductionRemark) ? remark : deductionRemark + System.lineSeparator() + remark;
                formPlugin.getView().getModel().setValue("remark", (Object)remark);
                formPlugin.getView().updateView("remark");
                break;
            }
        }
    }

    public static void openInvoiceF7(AbstractFormPlugin formPlugin, String event, String invoiceTypeFitler, String ars) {
        QFilter qFilter = new QFilter("invoiceamount", ">", (Object)BigDecimal.ZERO);
        Object orgPk = formPlugin.getView().getModel().getValue("orgid");
        IDataModel model = formPlugin.getView().getModel();
        Object orgId = orgPk instanceof DynamicObject ? ((DynamicObject)orgPk).getPkValue() : orgPk;
        qFilter.and("orgid", "=", orgId);
        qFilter.and("invoicetype", invoiceTypeFitler, (Object)InvoiceUtils.getAllEInvoiceType());
        qFilter.and("issuestatus", "=", (Object)IssueStatusEnum.ok.getCode());
        qFilter.and("invoicestatus", "!=", (Object)"6");
        JSONObject deducJson = JSONObject.parseObject((String)ars);
        String index = (String)deducJson.get((Object)"index");
        formPlugin.getPageCache().put("deducIndex", index);
        ViewUtil.openListPage((AbstractFormPlugin)formPlugin, (QFilter)qFilter, (String)"sim_vatinvoice", (String)event, (boolean)true, (boolean)false, null, null, null);
    }

    public static void clickTitleSearchIcon(AbstractFormPlugin formPlugin, String callBackKey) {
        QFilter filter = ImcBaseDataHelper.getInvTitleFilter((Object)CreateInvoiceBaseControl.getOrgIdByView(formPlugin));
        ViewUtil.openListPage((AbstractFormPlugin)formPlugin, (QFilter)filter, (String)"bdm_invice_title_strate", (String)callBackKey);
    }
}

